/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.sqa;

import com.aliyun.odps.Instance;
import com.aliyun.odps.LogView;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Session;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.TunnelEndpointLocalCache;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.ResultSet;
import com.aliyun.odps.sqa.CommandApi;
import com.aliyun.odps.sqa.ExecuteMode;
import com.aliyun.odps.sqa.FallbackPolicy;
import com.aliyun.odps.sqa.OfflineRecordSetIterator;
import com.aliyun.odps.sqa.QueryInfo;
import com.aliyun.odps.sqa.SQLExecutor;
import com.aliyun.odps.sqa.SQLExecutorConstants;
import com.aliyun.odps.sqa.SQLExecutorPool;
import com.aliyun.odps.sqa.SessionRecordSetIterator;
import com.aliyun.odps.sqa.commandapi.Command;
import com.aliyun.odps.sqa.commandapi.CommandInfo;
import com.aliyun.odps.sqa.commandapi.RecordIter;
import com.aliyun.odps.sqa.commandapi.utils.CommandUtil;
import com.aliyun.odps.sqa.commandapi.utils.SqlParserUtil;
import com.aliyun.odps.task.SQLTask;
import com.aliyun.odps.tunnel.InstanceTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.TunnelRecordReader;
import com.aliyun.odps.utils.CSVRecordParser;
import com.aliyun.odps.utils.StringUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;

class SQLExecutorImpl
implements SQLExecutor {
    private String id = null;
    private Odps odps = null;
    private ExecuteMode executeMode = ExecuteMode.INTERACTIVE;
    private FallbackPolicy fallbackPolicy = null;
    private boolean enableReattach = true;
    private boolean useInstanceTunnel = true;
    private boolean attachSuccess = false;
    private Map<String, String> properties = new HashMap<String, String>();
    private String serviceName;
    private String taskName;
    private String runningCluster;
    private String fallbackQuota;
    private int tunnelGetResultMaxRetryTime;
    private int tunnelGetResultRetryCount = 0;
    private static final long cacheSize = 1000L;
    private static final int durationSeconds = 900;
    private static TunnelEndpointLocalCache cache = new TunnelEndpointLocalCache(1000L, 900);
    private Long attachTimeout = SQLExecutorConstants.DEFAULT_ATTACH_TIMEOUT;
    private InstanceTunnel instanceTunnel = null;
    private SQLExecutorPool pool = null;
    Session session = null;
    QueryInfo queryInfo = null;
    private CommandApi commandApi = null;
    private boolean useCommandApi = false;
    private boolean parseSuccess = false;
    private boolean sessionSupportNonSelect = false;
    private boolean odpsNamespaceSchema = false;
    private String tunnelEndpoint;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    SQLExecutorImpl(Odps odps, String serviceName, String taskName, String tunnelEndpoint, Map<String, String> properties, ExecuteMode executeMode, FallbackPolicy fallbackPolicy, boolean enableReattach, boolean useInstanceTunnel, SQLExecutorPool pool, Instance recoverInstance, String runningCluster, int tunnelGetResultMaxRetryTime, boolean useCommandApi, String quotaName, Long timeout, boolean odpsNamespaceSchema, int tunnelSocketTimeout, int tunnelReadTimeout, boolean sessionSupportNonSelect) throws OdpsException {
        this.properties.putAll(properties);
        this.serviceName = serviceName;
        this.taskName = taskName;
        this.odps = odps;
        this.executeMode = executeMode;
        this.fallbackPolicy = fallbackPolicy;
        this.enableReattach = enableReattach;
        this.useInstanceTunnel = useInstanceTunnel;
        this.pool = pool;
        this.runningCluster = runningCluster;
        this.tunnelGetResultMaxRetryTime = tunnelGetResultMaxRetryTime;
        this.useCommandApi = useCommandApi;
        this.odpsNamespaceSchema = odpsNamespaceSchema;
        this.fallbackQuota = quotaName;
        this.commandApi = new CommandApi(odps);
        this.sessionSupportNonSelect = sessionSupportNonSelect;
        if (timeout != null) {
            this.attachTimeout = timeout;
        }
        if (!StringUtils.isNullOrEmpty((String)quotaName)) {
            this.properties.put("odps.task.wlm.quota", quotaName);
        }
        if (executeMode.equals((Object)ExecuteMode.INTERACTIVE)) {
            if (recoverInstance != null && recoverInstance.getStatus() == Instance.Status.RUNNING) {
                this.session = new Session(odps, recoverInstance);
                this.attachSuccess = true;
            }
            try {
                if (this.session == null) {
                    this.session = Session.attach(odps, serviceName, this.properties, this.attachTimeout, runningCluster, taskName);
                    this.attachSuccess = true;
                }
            }
            catch (OdpsException e) {
                if (!fallbackPolicy.isAlwaysFallBack()) throw e;
            }
        } else if (!executeMode.equals((Object)ExecuteMode.OFFLINE)) throw new OdpsException("Invalid execution mode, can not init with NONE.");
        this.id = UUID.randomUUID().toString();
        if (!useInstanceTunnel) return;
        this.instanceTunnel = new InstanceTunnel(odps);
        if (tunnelSocketTimeout >= 0) {
            this.instanceTunnel.getConfig().setSocketConnectTimeout(tunnelSocketTimeout);
        }
        if (tunnelReadTimeout >= 0) {
            this.instanceTunnel.getConfig().setSocketTimeout(tunnelReadTimeout);
        }
        if (!StringUtils.isNullOrEmpty((String)tunnelEndpoint)) {
            this.instanceTunnel.setEndpoint(tunnelEndpoint);
            this.tunnelEndpoint = tunnelEndpoint;
            return;
        }
        try {
            tunnelEndpoint = cache.getTunnelEndpointFromLocalCache(odps, null);
        }
        catch (ExecutionException e) {
            throw new OdpsException("Get tunnel endpoint from localCache exception:" + e.getMessage());
        }
        this.instanceTunnel.setEndpoint(tunnelEndpoint);
        this.tunnelEndpoint = tunnelEndpoint;
    }

    @Override
    public void close() {
        if (this.pool != null) {
            this.pool.releaseExecutor(this);
        } else {
            try {
                if (this.session != null) {
                    this.session.stop();
                }
            }
            catch (OdpsException odpsException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public int getSubqueryId() {
        if (this.queryInfo != null && this.queryInfo.getExecuteMode().equals((Object)ExecuteMode.INTERACTIVE)) {
            return this.queryInfo.getId();
        }
        return -1;
    }

    public String getQueryId() {
        if (this.queryInfo != null && this.queryInfo.getExecuteMode().equals((Object)ExecuteMode.INTERACTIVE)) {
            return this.queryInfo.getInstance().getId() + "_" + this.queryInfo.getId();
        }
        return null;
    }

    @Override
    public String getLogView() {
        if (this.parseSuccess) {
            Command command = this.queryInfo.getCommandInfo().getCommand();
            if (command.isSync()) {
                return null;
            }
            try {
                return new LogView(this.odps).generateLogView(this.queryInfo.getCommandInfo().getInstance(), 168L);
            }
            catch (OdpsException e) {
                return null;
            }
        }
        if (this.queryInfo != null) {
            try {
                if (this.queryInfo.getExecuteMode().equals((Object)ExecuteMode.INTERACTIVE)) {
                    if (this.session != null) {
                        return new LogView(this.odps).generateSubQueryLogView(this.queryInfo.getInstance(), this.queryInfo.getId(), this.session.getToken());
                    }
                    return new LogView(this.odps).generateSubQueryLogView(this.queryInfo.getInstance(), this.queryInfo.getId(), 168L);
                }
                return new LogView(this.odps).generateLogView(this.queryInfo.getInstance(), 168L);
            }
            catch (OdpsException e) {
                return null;
            }
        }
        if (this.session != null) {
            try {
                return this.session.getLogView();
            }
            catch (OdpsException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean isActive() {
        if (this.session != null) {
            return this.session.getInstance().getStatus().equals((Object)Instance.Status.RUNNING);
        }
        return false;
    }

    @Override
    public void cancel() throws OdpsException {
        if (this.queryInfo != null) {
            if (this.queryInfo.getExecuteMode().equals((Object)ExecuteMode.OFFLINE)) {
                this.queryInfo.getInstance().stop();
            } else {
                this.session.cancelQuery(this.queryInfo.getId());
            }
        }
    }

    @Override
    public Instance getInstance() {
        if (this.parseSuccess) {
            Command command = this.queryInfo.getCommandInfo().getCommand();
            if (command.isSync()) {
                return null;
            }
            return this.queryInfo.getCommandInfo().getInstance();
        }
        if (this.queryInfo != null) {
            return this.queryInfo.getInstance();
        }
        if (this.session != null) {
            return this.session.getInstance();
        }
        return null;
    }

    @Override
    public List<Instance.StageProgress> getProgress() throws OdpsException {
        if (this.queryInfo == null) {
            return null;
        }
        if (this.parseSuccess) {
            Command command = this.queryInfo.getCommandInfo().getCommand();
            if (command.isSync()) {
                return null;
            }
            return this.queryInfo.getCommandInfo().getInstance().getTaskProgress(this.queryInfo.getCommandInfo().getTaskName());
        }
        if (this.queryInfo.getExecuteMode().equals((Object)ExecuteMode.OFFLINE)) {
            return this.queryInfo.getInstance().getTaskProgress("sqlrt_fallback_task");
        }
        return this.session.getInstance().getTaskProgress(this.taskName);
    }

    @Override
    public String getSummary() throws OdpsException {
        if (this.queryInfo == null) {
            return null;
        }
        if (this.parseSuccess) {
            Command command = this.queryInfo.getCommandInfo().getCommand();
            if (command.isSync()) {
                return null;
            }
            Instance.TaskSummary summary = this.queryInfo.getCommandInfo().getInstance().getTaskSummary(this.queryInfo.getCommandInfo().getTaskName());
            return summary == null ? null : summary.getSummaryText();
        }
        if (this.queryInfo.getExecuteMode().equals((Object)ExecuteMode.OFFLINE)) {
            Instance.TaskSummary summary = this.queryInfo.getInstance().getTaskSummary("sqlrt_fallback_task");
            if (summary == null) {
                return null;
            }
            return summary.getSummaryText();
        }
        return this.session.getQueryStats(this.queryInfo.getId());
    }

    @Override
    public List<String> getExecutionLog() {
        if (this.queryInfo == null) {
            return null;
        }
        return this.queryInfo.getAndCleanExecutionLog();
    }

    @Override
    public List<Record> getResult() throws OdpsException, IOException {
        return this.getResult(null);
    }

    @Override
    public ResultSet getResultSet() throws OdpsException, IOException {
        return this.getResultSet(null);
    }

    @Override
    public List<Record> getResult(Long countLimit) throws OdpsException, IOException {
        if (this.queryInfo == null) {
            throw new OdpsException("No query running now.");
        }
        if (!this.useInstanceTunnel && countLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        return this.getResultInternal(null, countLimit, null, false);
    }

    @Override
    public List<Record> getResult(Long countLimit, Long sizeLimit) throws OdpsException, IOException {
        if (this.queryInfo == null) {
            throw new OdpsException("No query running now.");
        }
        if (!this.useInstanceTunnel && countLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        if (!this.useInstanceTunnel && sizeLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        List<Record> list = this.getResultInternal(null, countLimit, sizeLimit, false);
        return list;
    }

    @Override
    public List<Record> getResult(Long offset, Long countLimit, Long sizeLimit) throws OdpsException, IOException {
        if (this.queryInfo == null) {
            throw new OdpsException("No query running now.");
        }
        if (!this.useInstanceTunnel && offset != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        if (!this.useInstanceTunnel && countLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        if (!this.useInstanceTunnel && sizeLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        List<Record> list = this.getResultInternal(offset, countLimit, sizeLimit, false);
        return list;
    }

    @Override
    public List<Record> getResult(Long offset, Long countLimit, Long sizeLimit, boolean limitEnabled) throws OdpsException, IOException {
        if (this.queryInfo == null) {
            throw new OdpsException("No query running now.");
        }
        if (!this.useInstanceTunnel && offset != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        if (!this.useInstanceTunnel && countLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        if (!this.useInstanceTunnel && sizeLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        List<Record> list = this.getResultInternal(offset, countLimit, sizeLimit, limitEnabled);
        return list;
    }

    @Override
    public ResultSet getResultSet(Long countLimit) throws OdpsException, IOException {
        if (this.queryInfo == null) {
            throw new OdpsException("No query running now.");
        }
        if (!this.useInstanceTunnel && countLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        ResultSet resultSet = this.getResultSetInternal(null, countLimit, null, false);
        return resultSet;
    }

    @Override
    public ResultSet getResultSet(Long countLimit, Long sizeLimit) throws OdpsException, IOException {
        if (this.queryInfo == null) {
            throw new OdpsException("No query running now.");
        }
        if (!this.useInstanceTunnel && countLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        if (!this.useInstanceTunnel && sizeLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        ResultSet resultSet = this.getResultSetInternal(null, countLimit, sizeLimit, false);
        return resultSet;
    }

    @Override
    public ResultSet getResultSet(Long offset, Long countLimit, Long sizeLimit) throws OdpsException, IOException {
        if (this.queryInfo == null) {
            throw new OdpsException("No query running now.");
        }
        if (!this.useInstanceTunnel && offset != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        if (!this.useInstanceTunnel && countLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        if (!this.useInstanceTunnel && sizeLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        ResultSet resultSet = this.getResultSetInternal(offset, countLimit, sizeLimit, false);
        return resultSet;
    }

    @Override
    public ResultSet getResultSet(Long offset, Long countLimit, Long sizeLimit, boolean limitEnabled) throws OdpsException, IOException {
        if (this.queryInfo == null) {
            throw new OdpsException("No query running now.");
        }
        if (!this.useInstanceTunnel && offset != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        if (!this.useInstanceTunnel && countLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        if (!this.useInstanceTunnel && sizeLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        ResultSet resultSet = this.getResultSetInternal(offset, countLimit, sizeLimit, limitEnabled);
        return resultSet;
    }

    @Override
    public void run(String sql, Map<String, String> hint) throws OdpsException {
        Command command;
        if (hint == null) {
            hint = new HashMap<String, String>();
        }
        this.queryInfo = new QueryInfo(sql, hint, this.executeMode);
        this.queryInfo.setCommandInfo(new CommandInfo(sql, hint));
        if (this.useCommandApi && (command = CommandUtil.parseCommand(sql)) != null) {
            this.queryInfo.getCommandInfo().setCommand(command);
            this.queryInfo.getCommandInfo().setOdpsNamespaceSchema(this.odpsNamespaceSchema);
            if (!command.isSync()) {
                command.run(this.odps, this.queryInfo.getCommandInfo());
            }
            this.parseSuccess = true;
            return;
        }
        this.queryInfo.setSelect(this.isSelect(sql));
        this.parseSuccess = false;
        this.tunnelGetResultRetryCount = 0;
        this.runQueryInternal(this.executeMode, null, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void reattach(String errorMessage) throws OdpsException {
        if (!this.enableReattach) throw new OdpsException(errorMessage);
        try {
            this.attachSuccess = false;
            this.session = Session.attach(this.odps, this.serviceName, this.properties, this.attachTimeout, this.runningCluster, this.taskName);
            this.attachSuccess = true;
            return;
        }
        catch (OdpsException e) {
            if (this.fallbackPolicy.isAlwaysFallBack()) return;
            throw new OdpsException(errorMessage);
        }
    }

    private ExecuteMode handleSessionException(String errorMessage) throws OdpsException {
        if (errorMessage.indexOf("ODPS-181") != -1) {
            this.reattach(errorMessage);
            return ExecuteMode.INTERACTIVE;
        }
        if (errorMessage.indexOf("OdpsJobCancelledException") != -1 || errorMessage.indexOf("Job is cancelled") != -1) {
            throw new OdpsException(errorMessage);
        }
        if (this.fallbackPolicy.isFallback4UnsupportedFeature() && errorMessage.indexOf("ODPS-185") != -1) {
            return ExecuteMode.OFFLINE;
        }
        if (this.fallbackPolicy.isFallback4Upgrading() && errorMessage.indexOf("ODPS-184") != -1) {
            return ExecuteMode.OFFLINE;
        }
        if (this.fallbackPolicy.isFallback4Upgrading() && errorMessage.indexOf("ODPS-182") != -1) {
            return ExecuteMode.OFFLINE;
        }
        if (this.fallbackPolicy.isFallback4ResourceNotEnough() && errorMessage.indexOf("ODPS-183") != -1) {
            return ExecuteMode.OFFLINE;
        }
        if (this.fallbackPolicy.isFallback4RunningTimeout() && (errorMessage.indexOf("ODPS-186") != -1 || errorMessage.indexOf("Wait for cache data timeout") != -1 || errorMessage.indexOf("Get select desc from SQLRTTask timeout") != -1)) {
            return ExecuteMode.OFFLINE;
        }
        if (this.fallbackPolicy.isFallback4UnknownError() && errorMessage.indexOf("ODPS-180") != -1) {
            return ExecuteMode.OFFLINE;
        }
        if (this.fallbackPolicy.isAlwaysFallBack()) {
            return ExecuteMode.OFFLINE;
        }
        throw new OdpsException(errorMessage);
    }

    private boolean checkIsSelect(String errorCode, String errorMessage) throws OdpsException {
        if (errorCode.equals("InstanceTypeNotSupported") || errorMessage.indexOf("Non select query not supported") != -1) {
            this.queryInfo.setSelect(false);
            return false;
        }
        return true;
    }

    private TunnelRetryInfo handleTunnelException(String errorCode, String errorMessage) throws OdpsException {
        boolean isSelect = this.checkIsSelect(errorCode, errorMessage);
        TunnelRetryInfo info = new TunnelRetryInfo();
        info.errCode = errorCode;
        info.errMsg = errorMessage;
        if (!isSelect) {
            try {
                this.session.getSubQueryResult(this.queryInfo.getId());
                info.status = TunnelRetryStatus.NON_SELECT_QUERY;
                return info;
            }
            catch (OdpsException e) {
                info.status = TunnelRetryStatus.QUERY_FAILED;
                info.errCode = e.getErrorCode();
                info.errMsg = e.getMessage();
                return info;
            }
        }
        if (errorCode.equals("OdpsTaskTimeout") || errorMessage.indexOf("Wait for cache data timeout") != -1) {
            ++this.tunnelGetResultRetryCount;
            if (this.tunnelGetResultRetryCount >= this.tunnelGetResultMaxRetryTime) {
                info.status = TunnelRetryStatus.QUERY_FAILED;
                return info;
            }
            info.status = TunnelRetryStatus.NEED_RETRY;
            return info;
        }
        info.status = TunnelRetryStatus.QUERY_FAILED;
        return info;
    }

    private ResultSet newEmptyResultSet() {
        return new ResultSet(new OfflineRecordSetIterator(new ArrayList<Record>()), new TableSchema(), 0L);
    }

    private List<Record> getCommandResult(Long offset, Long countLimit, Long sizeLimit, boolean limitEnabled) throws OdpsException {
        if (offset != null && offset < 0L) {
            throw new IllegalArgumentException("illegal argument. offset = " + offset);
        }
        if (countLimit != null && countLimit < 0L) {
            throw new IllegalArgumentException("illegal argument. countLimit = " + countLimit);
        }
        Command command = this.queryInfo.getCommandInfo().getCommand();
        if (command.isSync()) {
            RecordIter recordIterator = command.run(this.odps, this.queryInfo.getCommandInfo());
            if (recordIterator == null) {
                return Collections.emptyList();
            }
            recordIterator.setCountLimit(countLimit == null ? -1L : countLimit);
            recordIterator.setOffset(offset == null ? 0L : offset);
            ArrayList<Record> records = new ArrayList<Record>();
            while (recordIterator.hasNext()) {
                Record record = recordIterator.next();
                records.add(record);
            }
            return records;
        }
        Instance instance = this.queryInfo.getCommandInfo().getInstance();
        instance.waitForSuccess();
        instance = this.queryInfo.getCommandInfo().getInstance();
        String res = instance.getTaskResults().get(this.queryInfo.getCommandInfo().getTaskName());
        return CommandUtil.toRecord(res, command.getResultHeaders().get(0));
    }

    private ResultSet getCommandResultSet(Long offset, Long countLimit, Long sizeLimit, boolean limitEnabled) throws OdpsException {
        if (offset != null && offset < 0L) {
            throw new IllegalArgumentException("illegal argument. offset = " + offset);
        }
        if (countLimit != null && countLimit < 0L) {
            throw new IllegalArgumentException("illegal argument. countLimit = " + countLimit);
        }
        Command command = this.queryInfo.getCommandInfo().getCommand();
        if (command.isSync()) {
            RecordIter recordIterator = command.run(this.odps, this.queryInfo.getCommandInfo());
            if (recordIterator == null) {
                return this.newEmptyResultSet();
            }
            recordIterator.setCountLimit(countLimit == null ? -1L : countLimit);
            recordIterator.setOffset(offset == null ? 0L : offset);
            TableSchema schema = new TableSchema();
            schema.setColumns(Arrays.asList(recordIterator.getColumns()));
            return new ResultSet(recordIterator, schema, -1L);
        }
        Instance instance = this.queryInfo.getCommandInfo().getInstance();
        instance.waitForSuccess();
        instance = this.queryInfo.getCommandInfo().getInstance();
        String res = instance.getTaskResults().get(this.queryInfo.getCommandInfo().getTaskName());
        List<Record> records = CommandUtil.toRecord(res, command.getResultHeaders().get(0));
        TableSchema schema = new TableSchema();
        schema.setColumns(Arrays.asList(records.get(0).getColumns()));
        return new ResultSet(records.iterator(), schema, records.size());
    }

    private List<Record> getResultInternal(Long offset, Long countLimit, Long sizeLimit, boolean limitEnabled) throws OdpsException, IOException {
        if (this.parseSuccess) {
            return this.getCommandResult(offset, countLimit, sizeLimit, limitEnabled);
        }
        if (this.useInstanceTunnel) {
            if (this.queryInfo.getExecuteMode() == ExecuteMode.INTERACTIVE && this.attachSuccess) {
                return this.getSessionResultByInstanceTunnel(offset, countLimit, sizeLimit, limitEnabled);
            }
            return this.getOfflineResultByInstanceTunnel(countLimit);
        }
        if (this.queryInfo.getExecuteMode() == ExecuteMode.INTERACTIVE && this.attachSuccess) {
            return this.getSessionResult();
        }
        return this.getOfflineResult();
    }

    private ResultSet getResultSetInternal(Long offset, Long countLimit, Long sizeLimit, boolean limitEnabled) throws OdpsException, IOException {
        if (this.parseSuccess) {
            return this.getCommandResultSet(offset, countLimit, sizeLimit, limitEnabled);
        }
        if (this.useInstanceTunnel) {
            if (this.queryInfo.getExecuteMode() == ExecuteMode.INTERACTIVE && this.attachSuccess) {
                return this.getSessionResultSetByInstanceTunnel(offset, countLimit, sizeLimit, limitEnabled);
            }
            return this.getOfflineResultSetByInstanceTunnel(countLimit);
        }
        if (this.queryInfo.getExecuteMode() == ExecuteMode.INTERACTIVE && this.attachSuccess) {
            return this.getSessionResultSet();
        }
        return this.getOfflineResultSet();
    }

    private List<Record> getSessionResult() throws OdpsException, IOException {
        Session.SubQueryResult result = null;
        try {
            result = this.queryInfo.isSelect() ? this.session.getSubQueryResult(this.queryInfo.getId()) : this.session.getRawSubQueryResult(this.queryInfo.getId());
        }
        catch (OdpsException e) {
            ExecuteMode executeMode = this.handleSessionException(e.getMessage());
            this.runQueryInternal(executeMode, e.getMessage(), true);
            return this.getResultInternal(null, null, null, true);
        }
        return result.getRecords();
    }

    private List<Record> getSessionResultByInstanceTunnel(Long offset, Long countLimit, Long sizeLimit, boolean limitEnabled) throws OdpsException, IOException, RuntimeException {
        Instance instance = this.queryInfo.getInstance();
        ArrayList<Record> records = new ArrayList<Record>();
        try {
            InstanceTunnel.DownloadSession downloadSession = this.instanceTunnel.createDirectDownloadSession(instance.getProject(), instance.getId(), this.taskName, this.queryInfo.getId(), limitEnabled);
            TunnelRecordReader reader = downloadSession.openRecordReader(offset == null ? 0L : offset, countLimit == null ? -1L : countLimit, sizeLimit == null ? -1L : sizeLimit);
            while (true) {
                Record record = reader.read();
                if (sizeLimit != null && sizeLimit > 0L && reader.getTotalBytes() > sizeLimit) {
                    throw new RuntimeException("InvalidArgument: sizeLimit, fetched data is larger than limit size");
                }
                if (record != null) {
                    records.add(record);
                    continue;
                }
                break;
            }
        }
        catch (TunnelException e) {
            TunnelRetryInfo retryInfo = this.handleTunnelException(e.getErrorCode(), e.getMessage());
            if (retryInfo.status.equals((Object)TunnelRetryStatus.NEED_RETRY)) {
                return this.getResultInternal(offset, countLimit, sizeLimit, limitEnabled);
            }
            if (retryInfo.status.equals((Object)TunnelRetryStatus.NON_SELECT_QUERY)) {
                this.runQueryInternal(ExecuteMode.OFFLINE, retryInfo.errMsg, true);
                return this.getResultInternal(offset, countLimit, sizeLimit, limitEnabled);
            }
            ExecuteMode executeMode = this.handleSessionException(retryInfo.errMsg);
            this.runQueryInternal(executeMode, retryInfo.errMsg, true);
            return this.getResultInternal(offset, countLimit, sizeLimit, limitEnabled);
        }
        return records;
    }

    private List<Record> getOfflineResult() throws OdpsException {
        this.queryInfo.getInstance().waitForSuccess();
        Map<String, String> results = this.queryInfo.getInstance().getTaskResults();
        String selectResult = results.get("sqlrt_fallback_task");
        if (selectResult != null) {
            if (this.queryInfo.isSelect()) {
                return SQLTask.parseCsvRecord(selectResult);
            }
            return CommandUtil.toRecord(selectResult, "Info");
        }
        return new ArrayList<Record>();
    }

    private List<Record> getOfflineResultByInstanceTunnel(Long limit) throws OdpsException, IOException {
        this.queryInfo.getInstance().waitForSuccess();
        if (this.queryInfo.isSelect()) {
            return SQLTask.getResultByInstanceTunnel(this.queryInfo.getInstance(), "sqlrt_fallback_task", limit);
        }
        Map<String, String> results = this.queryInfo.getInstance().getTaskResults();
        String selectResult = results.get("sqlrt_fallback_task");
        if (StringUtils.isNullOrEmpty((String)selectResult)) {
            return new ArrayList<Record>();
        }
        return CommandUtil.toRecord(selectResult, "Info");
    }

    private ResultSet getSessionResultSet() throws OdpsException, IOException {
        Session.SubQueryResult result = null;
        try {
            result = this.queryInfo.isSelect() ? this.session.getSubQueryResult(this.queryInfo.getId()) : this.session.getRawSubQueryResult(this.queryInfo.getId());
        }
        catch (OdpsException e) {
            ExecuteMode executeMode = this.handleSessionException(e.getMessage());
            this.runQueryInternal(executeMode, e.getMessage(), true);
            return this.getResultSetInternal(null, null, null, true);
        }
        return new ResultSet(new OfflineRecordSetIterator(result.getRecords()), result.getSchema(), result.getRecords().size());
    }

    private ResultSet getSessionResultSetByInstanceTunnel(Long offset, Long countLimit, Long sizeLimit, boolean limitEnabled) throws OdpsException, IOException {
        Instance instance = this.queryInfo.getInstance();
        InstanceTunnel.DownloadSession downloadSession = null;
        TunnelRecordReader reader = null;
        try {
            downloadSession = this.instanceTunnel.createDirectDownloadSession(instance.getProject(), instance.getId(), this.taskName, this.queryInfo.getId(), limitEnabled);
            reader = downloadSession.openRecordReader(offset == null ? 0L : offset, countLimit == null ? -1L : countLimit, sizeLimit == null ? -1L : sizeLimit);
        }
        catch (TunnelException e) {
            TunnelRetryInfo retryInfo = this.handleTunnelException(e.getErrorCode(), e.getMessage());
            if (retryInfo.status.equals((Object)TunnelRetryStatus.NEED_RETRY)) {
                return this.getResultSetInternal(offset, countLimit, sizeLimit, limitEnabled);
            }
            if (retryInfo.status.equals((Object)TunnelRetryStatus.NON_SELECT_QUERY)) {
                this.runQueryInternal(ExecuteMode.OFFLINE, retryInfo.errMsg, true);
                return this.getResultSetInternal(offset, countLimit, sizeLimit, limitEnabled);
            }
            ExecuteMode executeMode = this.handleSessionException(retryInfo.errMsg);
            this.runQueryInternal(executeMode, retryInfo.errMsg, true);
            return this.getResultSetInternal(offset, countLimit, sizeLimit, limitEnabled);
        }
        return new ResultSet(new SessionRecordSetIterator(downloadSession, reader, downloadSession.getRecordCount(), offset == null ? 0L : offset, sizeLimit == null ? -1L : sizeLimit), downloadSession.getSchema(), downloadSession.getRecordCount());
    }

    private ResultSet getOfflineResultSet() throws OdpsException, IOException {
        this.queryInfo.getInstance().waitForSuccess();
        Map<String, String> results = this.queryInfo.getInstance().getTaskResults();
        String selectResult = results.get("sqlrt_fallback_task");
        if (!StringUtils.isNullOrEmpty((String)selectResult)) {
            if (this.queryInfo.isSelect()) {
                CSVRecordParser.ParseResult parseResult = CSVRecordParser.parse(selectResult);
                List<Record> records = parseResult.getRecords();
                return new ResultSet(new OfflineRecordSetIterator(records), parseResult.getSchema(), records.size());
            }
            List<Record> records = CommandUtil.toRecord(selectResult, "Info");
            TableSchema schema = new TableSchema();
            schema.setColumns(Arrays.asList(records.get(0).getColumns()));
            return new ResultSet(new OfflineRecordSetIterator(records), schema, records.size());
        }
        return this.newEmptyResultSet();
    }

    private ResultSet getOfflineResultSetByInstanceTunnel(Long limit) throws OdpsException, IOException {
        this.queryInfo.getInstance().waitForSuccess();
        if (this.queryInfo.isSelect()) {
            URI tunnelEndpoint = null;
            if (!StringUtils.isNullOrEmpty((String)this.tunnelEndpoint)) {
                try {
                    tunnelEndpoint = new URI(this.tunnelEndpoint);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("tunnel endpoint syntax error, please check again.");
                }
            }
            return SQLTask.getResultSet(this.queryInfo.getInstance(), "sqlrt_fallback_task", limit, false, tunnelEndpoint);
        }
        Map<String, String> results = this.queryInfo.getInstance().getTaskResults();
        String selectResult = results.get("sqlrt_fallback_task");
        if (StringUtils.isNullOrEmpty((String)selectResult)) {
            return this.newEmptyResultSet();
        }
        List<Record> records = CommandUtil.toRecord(selectResult, "Info");
        TableSchema schema = new TableSchema();
        schema.setColumns(Arrays.asList(records.get(0).getColumns()));
        return new ResultSet(new OfflineRecordSetIterator(records), schema, records.size());
    }

    private void runInSessionWithRetry(String rerunMsg) throws OdpsException {
        Session.SubQueryInfo subQueryInfo = this.session.runSubQuery(this.queryInfo.getSql(), this.queryInfo.getHint());
        if (subQueryInfo.status.equals("ok")) {
            if (subQueryInfo.queryId == -1) {
                ExecuteMode executeMode = this.handleSessionException(subQueryInfo.result);
                this.runQueryInternal(executeMode, subQueryInfo.result, true);
            } else {
                this.queryInfo.setId(subQueryInfo.queryId);
                this.queryInfo.setInstance(this.session.getInstance(), ExecuteMode.INTERACTIVE, "", rerunMsg);
            }
        } else if (subQueryInfo.status.equals("NotFound")) {
            String taskTerminateMsg = this.session.getInstance().getTaskResults().get(this.taskName);
            this.reattach("Submit query failed:" + taskTerminateMsg);
            this.runQueryInternal(ExecuteMode.INTERACTIVE, taskTerminateMsg, !this.attachSuccess);
        } else {
            throw new OdpsException("Submit query failed:" + subQueryInfo.result);
        }
    }

    private void runInOffline(String rerunMsg) throws OdpsException {
        Instance instance = SQLTask.run(this.odps, this.odps.getDefaultProject(), this.queryInfo.getSql(), "sqlrt_fallback_task", this.queryInfo.getHint(), null);
        this.queryInfo.setInstance(instance, ExecuteMode.OFFLINE, new LogView(this.odps).generateLogView(instance, 168L), rerunMsg);
    }

    private void runQueryInternal(ExecuteMode executeMode, String rerunMsg, boolean isRerun) throws OdpsException {
        boolean forceRunInOffline;
        boolean fallbackForAttachFailed = false;
        boolean bl = forceRunInOffline = !this.queryInfo.isSelect() && !this.sessionSupportNonSelect;
        if (this.queryInfo.getRetry() < 1) {
            if (isRerun) {
                this.queryInfo.incRetry();
            }
            if (executeMode == ExecuteMode.INTERACTIVE && !this.attachSuccess && this.fallbackPolicy.isAlwaysFallBack() && !forceRunInOffline) {
                try {
                    this.session = Session.attach(this.odps, this.serviceName, this.properties, this.attachTimeout, this.runningCluster, this.taskName);
                    this.attachSuccess = true;
                }
                catch (OdpsException e) {
                    fallbackForAttachFailed = true;
                }
            }
            if (executeMode == ExecuteMode.OFFLINE || fallbackForAttachFailed || forceRunInOffline) {
                this.queryInfo.setExecuteMode(ExecuteMode.OFFLINE);
                if (this.queryInfo != null) {
                    if (this.queryInfo.getHint() == null) {
                        this.queryInfo.setHint(new HashMap<String, String>());
                    }
                    if (!StringUtils.isNullOrEmpty((String)this.fallbackQuota)) {
                        this.queryInfo.getHint().put("odps.task.wlm.quota", this.fallbackQuota);
                    }
                    this.queryInfo.getHint().put("odps.task.sql.sqa.enable", "false");
                    if (this.queryInfo.getInstance() != null) {
                        this.queryInfo.getHint().put("odps.sql.session.fallback.instance", this.queryInfo.getInstance().getId() + "_" + this.queryInfo.getId());
                    } else {
                        this.queryInfo.getHint().put("odps.sql.session.fallback.instance", "fallback4AttachFailed");
                    }
                }
                this.runInOffline(rerunMsg);
            } else {
                this.runInSessionWithRetry(rerunMsg);
            }
        } else {
            throw new OdpsException(rerunMsg);
        }
    }

    @Override
    public boolean hasResultSet() {
        if (this.parseSuccess) {
            return true;
        }
        return SqlParserUtil.hasResultSet(this.queryInfo.getSql());
    }

    @Override
    public boolean isRunningInInteractiveMode() {
        return this.queryInfo.getExecuteMode().equals((Object)ExecuteMode.INTERACTIVE);
    }

    public boolean isSelect(String sql) throws OdpsException {
        try {
            return SqlParserUtil.isSelect(sql);
        }
        catch (SQLException e) {
            throw new OdpsException("Sql isSelect failed", e);
        }
    }

    private class TunnelRetryInfo {
        public TunnelRetryStatus status;
        public String errCode;
        public String errMsg;

        private TunnelRetryInfo() {
        }
    }

    static enum TunnelRetryStatus {
        NEED_RETRY,
        NON_SELECT_QUERY,
        QUERY_FAILED;

    }
}

