/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.task;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Task;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.GsonBuilder;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

@Root(name="KUBE", strict=false)
public class KubeTask
extends Task {
    public static final int DEFAULT_PRIORITY = 9;
    public static final String ODPS_KUBE_APP_ID = "odps.kube.app.id";
    public static final String ODPS_KUBE_TASK_COMMAND = "odps.kube.task.command";
    public static final String ODPS_KUBE_RESOURCE_NAME = "odps.kube.resource.name";
    public static final String ODPS_KUBE_RESOURCE_KIND = "odps.kube.resource.kind";
    public static final String ODPS_KUBE_RESOURCE_LABELS = "odps.kube.resource.labels";
    @Element(name="JSON", required=false)
    @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
    private String yamlResources = "";
    private final Map<String, String> settings = new HashMap<String, String>();

    protected KubeTask() {
    }

    protected KubeTask(String taskName, String yamlFilePath) throws FileNotFoundException {
        this.setName(taskName);
        this.yamlResources = KubeTask.loadYamlResources(yamlFilePath);
    }

    public String getYamlResources() {
        return this.yamlResources;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    protected void setKubeTaskCommand(Command command) {
        this.settings.put(ODPS_KUBE_TASK_COMMAND, command.name());
    }

    protected void setKubeResourceName(String name) {
        this.settings.put(ODPS_KUBE_RESOURCE_NAME, name);
    }

    protected void setKubeResourceKind(Kind kind) {
        this.settings.put(ODPS_KUBE_RESOURCE_KIND, kind.name());
    }

    protected void setOdpsKubeAppId(String appId) {
        this.settings.put(ODPS_KUBE_APP_ID, appId);
    }

    protected void setOdpsKubeResourceLabels(String labels) {
        this.settings.put(ODPS_KUBE_RESOURCE_LABELS, labels);
    }

    public static Instance run(Odps odps, String project, String taskName, String yamlPath) throws OdpsException, FileNotFoundException {
        return KubeTask.run(odps, project, taskName, yamlPath, 9);
    }

    public static Instance run(Odps odps, String project, String taskName, String yamlPath, int priority) throws OdpsException, FileNotFoundException {
        KubeTask kubeTask = new KubeTask(taskName, yamlPath);
        kubeTask.setKubeTaskCommand(Command.CREATE);
        kubeTask.setProperty("settings", new GsonBuilder().disableHtmlEscaping().create().toJson(kubeTask.getSettings()));
        return odps.instances().create(project, kubeTask, priority);
    }

    public static Instance run(Odps odps, String project, String taskName, String appId, String resourceName, String labels, Command command, Kind kind) throws OdpsException {
        return KubeTask.run(odps, project, taskName, appId, resourceName, labels, command, kind, 9);
    }

    public static Instance run(Odps odps, String project, String taskName, String appId, String resourceName, String labels, Command command, Kind kind, int priority) throws OdpsException {
        KubeTask kubeTask = new KubeTask();
        kubeTask.setName(taskName);
        if (!StringUtils.isEmpty((String)appId)) {
            kubeTask.setOdpsKubeAppId(appId);
        }
        if (!StringUtils.isEmpty((String)resourceName)) {
            kubeTask.setKubeResourceName(resourceName);
        }
        if (!StringUtils.isEmpty((String)labels)) {
            kubeTask.setOdpsKubeResourceLabels(labels);
        }
        kubeTask.setKubeTaskCommand(command);
        kubeTask.setKubeResourceKind(kind);
        kubeTask.setProperty("settings", new GsonBuilder().disableHtmlEscaping().create().toJson(kubeTask.getSettings()));
        return odps.instances().create(project, kubeTask, priority);
    }

    public static Instance run(Odps odps, String project, String taskName, String appId, Command command) throws OdpsException {
        return KubeTask.run(odps, project, taskName, appId, command, 9);
    }

    public static Instance run(Odps odps, String project, String taskName, String appId, Command command, int priority) throws OdpsException {
        KubeTask kubeTask = new KubeTask();
        kubeTask.setName(taskName);
        kubeTask.setOdpsKubeAppId(appId);
        kubeTask.setKubeTaskCommand(command);
        kubeTask.setProperty("settings", new GsonBuilder().disableHtmlEscaping().create().toJson(kubeTask.getSettings()));
        return odps.instances().create(project, kubeTask, priority);
    }

    protected static String loadYamlResources(String yamlFilePath) throws FileNotFoundException {
        Yaml yaml = new Yaml();
        ArrayList<String> resources = new ArrayList<String>();
        Iterable iterable = yaml.loadAll((InputStream)new FileInputStream(yamlFilePath));
        for (Object resource : iterable) {
            resources.add(new GsonBuilder().disableHtmlEscaping().create().toJson(resource));
        }
        return "{\"data\":" + resources + "}";
    }

    public static enum Kind {
        NAMESPACE,
        DEPLOYMENT,
        STATEFULSET,
        DAEMONSET,
        REPLICASET,
        SERVICE,
        POD,
        CONFIGMAP,
        SECRET,
        ROLE,
        ROLEBINDING,
        SERVICEACCOUNT,
        PVC,
        PERSISTENTVOLUMECLAIM;

    }

    public static enum Command {
        CREATE,
        GET,
        REMOVE,
        APPEND,
        UPDATE,
        LIST;

    }
}

