/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public class Machine
implements Serializable {
    private static final long serialVersionUID = 5945880426501816900L;
    protected String ip = "";
    protected String machine_unique_id = "";
    protected String user_defined_id = "";
    protected long heartbeat_time = 0L;

    public Machine() {
    }

    public Machine(String ip, String machine_unique_id, String user_defined_id, long heartbeat_time) {
        this.ip = ip;
        this.machine_unique_id = machine_unique_id;
        this.user_defined_id = user_defined_id;
        this.heartbeat_time = heartbeat_time;
    }

    public JSONObject ToJsonObject() {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"ip", (Object)this.ip);
        jsonObj.put((Object)"machine-uniqueid", (Object)this.machine_unique_id);
        jsonObj.put((Object)"userdefined-id", (Object)this.user_defined_id);
        jsonObj.put((Object)"lastHeartbeatTime", (Object)this.heartbeat_time);
        return jsonObj;
    }

    public String ToJsonString() {
        return this.ToJsonObject().toString();
    }

    public void FromJsonObject(JSONObject dict) throws LogException {
        try {
            this.ip = dict.getString("ip");
            this.machine_unique_id = dict.getString("machine-uniqueid");
            this.user_defined_id = dict.getString("userdefined-id");
            this.heartbeat_time = dict.getInt("lastHeartbeatTime");
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateMachine", e.getMessage(), e, "");
        }
    }

    public void FromJsonString(String machineString) throws LogException {
        try {
            JSONObject dict = JSONObject.fromObject((Object)machineString);
            this.FromJsonObject(dict);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateMachine", e.getMessage(), e, "");
        }
    }

    public Machine(Machine machine) {
        this.ip = machine.ip;
        this.machine_unique_id = machine.machine_unique_id;
        this.user_defined_id = machine.user_defined_id;
        this.heartbeat_time = machine.heartbeat_time;
    }

    public String GetIp() {
        return this.ip;
    }

    public String GetMachineUniqueId() {
        return this.machine_unique_id;
    }

    public String GetUserDefinedId() {
        return this.user_defined_id;
    }

    public long GetLastHeartBeatTime() {
        return this.heartbeat_time;
    }
}

