/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.common.ShipperConfig;
import com.aliyun.openservices.log.exception.LogException;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public class OssShipperConfig
implements ShipperConfig {
    private String mOssBucket;
    private String mOssPrefix;
    private String mRoleArn;
    private int mBufferInterval;
    private int mBufferMb;
    private String mCompressType;

    public OssShipperConfig(String ossBucket, String ossPrefix, String roleArn, int bufferInteval, int bufferMb) {
        this(ossBucket, ossPrefix, roleArn, bufferInteval, bufferMb, "snappy");
    }

    public OssShipperConfig(String ossBucket, String ossPrefix, String roleArn, int bufferInteval, int bufferMb, String compressType) {
        this.mOssBucket = ossBucket;
        this.mOssPrefix = ossPrefix;
        this.mRoleArn = roleArn;
        this.mBufferInterval = bufferInteval;
        this.mBufferMb = bufferMb;
        this.mCompressType = compressType;
    }

    public OssShipperConfig() {
    }

    @Override
    public void FromJsonObj(JSONObject obj) throws LogException {
        try {
            this.mOssBucket = obj.getString("ossBucket");
            this.mOssPrefix = obj.getString("ossPrefix");
            this.mRoleArn = obj.getString("roleArn");
            this.mBufferInterval = obj.getInt("bufferInterval");
            this.mBufferMb = obj.getInt("bufferSize");
            this.mCompressType = obj.getString("compressType");
        }
        catch (JSONException e) {
            throw new LogException("FailToParseOssShipperConfig", e.getMessage(), e, "");
        }
    }

    public String GetOssBucket() {
        return this.mOssBucket;
    }

    public String GetOssPrefix() {
        return this.mOssPrefix;
    }

    public String GetRoleArm() {
        return this.mRoleArn;
    }

    public int GetBufferInterval() {
        return this.mBufferInterval;
    }

    public int GetBufferMb() {
        return this.mBufferMb;
    }

    public String GetCompressType() {
        return this.mCompressType;
    }

    @Override
    public String GetShipperType() {
        return "oss";
    }

    @Override
    public JSONObject GetJsonObj() {
        JSONObject obj = new JSONObject();
        obj.put((Object)"ossBucket", (Object)this.mOssBucket);
        obj.put((Object)"ossPrefix", (Object)this.mOssPrefix);
        obj.put((Object)"roleArn", (Object)this.mRoleArn);
        obj.put((Object)"bufferInterval", (Object)this.mBufferInterval);
        obj.put((Object)"bufferSize", (Object)this.mBufferMb);
        obj.put((Object)"compressType", (Object)this.mCompressType);
        return obj;
    }
}

