/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.common.Advanced;
import com.aliyun.openservices.log.common.CommonConfigInputDetail;
import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class LocalFileConfigInputDetail
extends CommonConfigInputDetail
implements Serializable {
    private static final long serialVersionUID = -5807698217939352222L;
    protected String logPath = "";
    protected String logType = "";
    protected String filePattern = "";
    protected String timeFormat = "";
    protected String topicFormat = "none";
    protected boolean preserve = true;
    protected Integer preserveDepth = 0;
    protected String fileEncoding = "utf8";
    protected boolean discardUnmatch = true;
    protected Integer maxDepth = 1000;
    protected boolean tailExisted = false;
    protected boolean discardNonUtf8 = false;
    protected boolean isDockerFile = false;
    protected Map<String, String> dockerIncludeLabel = new HashMap<String, String>();
    protected Map<String, String> dockerExcludeLabel = new HashMap<String, String>();
    protected Map<String, String> dockerIncludeEnv = new HashMap<String, String>();
    protected Map<String, String> dockerExcludeEnv = new HashMap<String, String>();
    protected long delaySkipBytes = 0L;
    protected Advanced advanced = new Advanced();

    public Advanced getAdvanced() {
        return this.advanced;
    }

    public void setAdvanced(Advanced advanced) {
        this.advanced = advanced;
    }

    public long getDelaySkipBytes() {
        return this.delaySkipBytes;
    }

    public void setDelaySkipBytes(long delaySkipBytes) {
        this.delaySkipBytes = delaySkipBytes;
    }

    public Map<String, String> getDockerIncludeEnv() {
        return this.dockerIncludeEnv;
    }

    public void setDockerIncludeEnv(Map<String, String> dockerIncludeEnv) {
        this.dockerIncludeEnv = dockerIncludeEnv;
    }

    public Map<String, String> getDockerExcludeEnv() {
        return this.dockerExcludeEnv;
    }

    public void setDockerExcludeEnv(Map<String, String> dockerExcludeEnv) {
        this.dockerExcludeEnv = dockerExcludeEnv;
    }

    public Map<String, String> getDockerIncludeLabel() {
        return this.dockerIncludeLabel;
    }

    public void setDockerIncludeLabel(Map<String, String> dockerIncludeLabel) {
        this.dockerIncludeLabel = dockerIncludeLabel;
    }

    public Map<String, String> getDockerExcludeLabel() {
        return this.dockerExcludeLabel;
    }

    public void setDockerExcludeLabel(Map<String, String> dockerExcludeLabel) {
        this.dockerExcludeLabel = dockerExcludeLabel;
    }

    public boolean isDockerFile() {
        return this.isDockerFile;
    }

    public void setDockerFile(boolean isDockerFile) {
        this.isDockerFile = isDockerFile;
    }

    public boolean GetTailExisted() {
        return this.tailExisted;
    }

    public void SetTailExisted(boolean tailExisted) {
        this.tailExisted = tailExisted;
    }

    public boolean GetDiscardNonUtf8() {
        return this.discardNonUtf8;
    }

    public void SetDiscardNonUtf8(boolean discardNonUtf8) {
        this.discardNonUtf8 = discardNonUtf8;
    }

    public String GetLogType() {
        return this.logType;
    }

    public void SetLogType(String logType) {
        this.logType = logType;
    }

    public Integer GetMaxDepth() {
        return this.maxDepth;
    }

    public void SetMaxDepth(Integer maxDepth) {
        this.maxDepth = maxDepth;
    }

    public boolean GetDiscardUnmatch() {
        return this.discardUnmatch;
    }

    public void SetDiscardUnmatch(boolean discardUnmatch) {
        this.discardUnmatch = discardUnmatch;
    }

    public String GetFileEncoding() {
        return this.fileEncoding;
    }

    public void SetFileEncoding(String fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    public boolean GetPreserve() {
        return this.preserve;
    }

    public void SetPreserve(boolean preserve) {
        this.preserve = preserve;
    }

    public Integer GetPreserveDepth() {
        return this.preserveDepth;
    }

    public void SetPreserveDepth(Integer preserveDepth) {
        this.preserveDepth = preserveDepth;
    }

    public String GetLogPath() {
        return this.logPath;
    }

    public void SetLogPath(String logPath) {
        this.logPath = logPath;
    }

    public String GetFilePattern() {
        return this.filePattern;
    }

    public void SetFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    public String GetTimeFormat() {
        return this.timeFormat;
    }

    public void SetTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public String GetTopicFormat() {
        return this.topicFormat;
    }

    public void SetTopicFormat(String topicFormat) {
        this.topicFormat = topicFormat;
    }

    protected void LocalFileConfigToJsonObject(JSONObject jsonObj) {
        this.CommonConfigToJsonObject(jsonObj);
        jsonObj.put("logPath", (Object)this.logPath);
        jsonObj.put("filePattern", (Object)this.filePattern);
        jsonObj.put("logType", (Object)this.logType);
        jsonObj.put("timeFormat", (Object)this.timeFormat);
        jsonObj.put("fileEncoding", (Object)this.fileEncoding);
        jsonObj.put("preserve", (Object)this.preserve);
        jsonObj.put("preserveDepth", (Object)this.preserveDepth);
        jsonObj.put("topicFormat", (Object)this.topicFormat);
        jsonObj.put("maxDepth", (Object)this.maxDepth);
        jsonObj.put("discardNonUtf8", (Object)this.discardNonUtf8);
        jsonObj.put("tailExisted", (Object)this.tailExisted);
        jsonObj.put("dockerFile", (Object)this.isDockerFile);
        jsonObj.put("delaySkipBytes", (Object)this.delaySkipBytes);
        jsonObj.put("discardUnmatch", (Object)this.discardUnmatch);
        jsonObj.put("advanced", (Object)this.advanced);
        JSONObject dockerIncludeEnvJson = new JSONObject();
        for (Map.Entry<String, String> entry : this.dockerIncludeEnv.entrySet()) {
            dockerIncludeEnvJson.put(entry.getKey(), (Object)entry.getValue());
        }
        jsonObj.put("dockerIncludeEnv", (Object)dockerIncludeEnvJson);
        JSONObject dockerExcludeEnvJson = new JSONObject();
        for (Map.Entry<String, String> entry : this.dockerExcludeEnv.entrySet()) {
            dockerExcludeEnvJson.put(entry.getKey(), (Object)entry.getValue());
        }
        jsonObj.put("dockerExcludeEnv", (Object)dockerExcludeEnvJson);
        JSONObject jSONObject = new JSONObject();
        for (Map.Entry<String, String> entry : this.dockerIncludeLabel.entrySet()) {
            jSONObject.put(entry.getKey(), (Object)entry.getValue());
        }
        jsonObj.put("dockerIncludeLabel", (Object)jSONObject);
        JSONObject jSONObject2 = new JSONObject();
        for (Map.Entry<String, String> entry : this.dockerExcludeLabel.entrySet()) {
            jSONObject2.put(entry.getKey(), (Object)entry.getValue());
        }
        jsonObj.put("dockerExcludeLabel", (Object)jSONObject2);
    }

    protected void LocalFileConfigFromJsonObject(JSONObject inputDetail) throws LogException {
        try {
            this.CommonConfigFromJsonObject(inputDetail);
            this.logPath = inputDetail.getString("logPath");
            this.filePattern = inputDetail.getString("filePattern");
            this.logType = inputDetail.getString("logType");
            this.timeFormat = inputDetail.containsKey((Object)"timeFormat") ? inputDetail.getString("timeFormat") : "";
            this.fileEncoding = inputDetail.containsKey((Object)"fileEncoding") ? inputDetail.getString("fileEncoding") : "utf8";
            this.preserve = inputDetail.containsKey((Object)"preserve") ? inputDetail.getBoolean("preserve") : true;
            this.preserveDepth = inputDetail.containsKey((Object)"preserveDepth") ? Integer.valueOf(inputDetail.getIntValue("preserveDepth")) : Integer.valueOf(0);
            this.discardUnmatch = inputDetail.containsKey((Object)"discardUnmatch") ? inputDetail.getBoolean("discardUnmatch") : true;
            this.maxDepth = inputDetail.containsKey((Object)"maxDepth") ? Integer.valueOf(inputDetail.getIntValue("maxDepth")) : Integer.valueOf(1000);
            this.topicFormat = inputDetail.containsKey((Object)"topicFormat") ? inputDetail.getString("topicFormat") : "none";
            this.discardNonUtf8 = inputDetail.containsKey((Object)"discardNonUtf8") ? inputDetail.getBoolean("discardNonUtf8") : false;
            this.tailExisted = inputDetail.containsKey((Object)"tailExisted") ? inputDetail.getBoolean("tailExisted") : false;
            this.isDockerFile = inputDetail.containsKey((Object)"dockerFile") ? inputDetail.getBoolean("dockerFile") : false;
            this.delaySkipBytes = inputDetail.containsKey((Object)"delaySkipBytes") ? inputDetail.getLong("delaySkipBytes") : 0L;
            this.advanced = inputDetail.containsKey((Object)"advanced") ? Advanced.fromJsonObject(inputDetail.getJSONObject("advanced")) : new Advanced(false);
            if (inputDetail.containsKey((Object)"dockerIncludeEnv")) {
                JSONObject dockerIncludeEnvJson = inputDetail.getJSONObject("dockerIncludeEnv");
                for (Map.Entry entry : dockerIncludeEnvJson.entrySet()) {
                    this.dockerIncludeEnv.put((String)entry.getKey(), entry.getValue().toString());
                }
            }
            if (inputDetail.containsKey((Object)"dockerExcludeEnv")) {
                JSONObject dockerExcludeEnvJson = inputDetail.getJSONObject("dockerExcludeEnv");
                for (Map.Entry entry : dockerExcludeEnvJson.entrySet()) {
                    this.dockerExcludeEnv.put((String)entry.getKey(), entry.getValue().toString());
                }
            }
            if (inputDetail.containsKey((Object)"dockerIncludeLabel")) {
                JSONObject dockerIncludeLabelJson = inputDetail.getJSONObject("dockerIncludeLabel");
                for (Map.Entry entry : dockerIncludeLabelJson.entrySet()) {
                    this.dockerIncludeLabel.put((String)entry.getKey(), entry.getValue().toString());
                }
            }
            if (inputDetail.containsKey((Object)"dockerExcludeLabel")) {
                JSONObject dockerExcludeLabelJson = inputDetail.getJSONObject("dockerExcludeLabel");
                for (Map.Entry entry : dockerExcludeLabelJson.entrySet()) {
                    this.dockerExcludeLabel.put((String)entry.getKey(), entry.getValue().toString());
                }
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateInputDetail", e.getMessage(), e, "");
        }
    }
}

