/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.response;

import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.internal.Unmarshaller;
import com.aliyun.openservices.log.response.Response;
import com.aliyun.openservices.log.util.JsonUtils;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;

public abstract class ResponseList<T>
extends Response {
    private Integer total;
    private Integer count;
    private List<T> results;

    public ResponseList(Map<String, String> headers) {
        super(headers);
    }

    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public List<T> getResults() {
        return this.results;
    }

    public void setResults(List<T> results) {
        this.results = results;
    }

    public abstract Unmarshaller<T> unmarshaller();

    public void deserialize(JSONObject value, String requestId) throws LogException {
        try {
            this.count = value.getInt("count");
            this.total = value.getInt("total");
            this.results = JsonUtils.readList(value, "results", this.unmarshaller());
        }
        catch (Exception ex) {
            throw new LogException("BadResponse", "Unable to deserialize JSON to model: " + ex.getMessage(), ex, requestId);
        }
    }
}

