/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.common.LocalFileConfigInputDetail;
import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import java.util.ArrayList;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public class DelimiterConfigInputDetail
extends LocalFileConfigInputDetail
implements Serializable {
    private static final long serialVersionUID = 4751026529573902188L;
    private String separator = "";
    private String quote = "";
    private ArrayList<String> key = new ArrayList();
    private String timeKey = "";
    private boolean autoExtend = true;

    public DelimiterConfigInputDetail() {
        this.logType = "delimiter_log";
    }

    public DelimiterConfigInputDetail(String logPath, String filePattern, String separator, String quote, ArrayList<String> key, String timeKey, String timeFormat, boolean autoExtend, boolean localStorage) {
        this.logType = "delimiter_log";
        this.logPath = logPath;
        this.filePattern = filePattern;
        this.separator = separator;
        this.quote = quote;
        this.key = key;
        this.timeKey = timeKey;
        this.timeFormat = timeFormat;
        this.autoExtend = autoExtend;
        this.localStorage = localStorage;
    }

    public String GetSeparator() {
        return this.separator;
    }

    public void SetSeparator(String separator) {
        this.separator = separator;
    }

    public String GetQuote() {
        return this.quote;
    }

    public void SetQuote(String quote) {
        this.quote = quote;
    }

    public ArrayList<String> GetKey() {
        return this.key;
    }

    public void SetKey(ArrayList<String> key) {
        this.key = key;
    }

    public void SetKey(JSONArray key) throws LogException {
        try {
            this.key = new ArrayList();
            for (int i = 0; i < key.size(); ++i) {
                this.key.add(key.getString(i));
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToSetKey", e.getMessage(), e, "");
        }
    }

    public String GetTimeKey() {
        return this.timeKey;
    }

    public void SetTimeKey(String timeKey) {
        this.timeKey = timeKey;
    }

    public boolean isAutoExtend() {
        return this.autoExtend;
    }

    public void SetAutoExtend(boolean autoExtend) {
        this.autoExtend = autoExtend;
    }

    @Override
    public JSONObject ToJsonObject() {
        JSONObject jsonObj = new JSONObject();
        this.LocalFileConfigToJsonObject(jsonObj);
        jsonObj.put((Object)"separator", (Object)this.separator);
        jsonObj.put((Object)"quote", (Object)this.quote);
        JSONArray keyArray = new JSONArray();
        for (String vKey : this.key) {
            keyArray.add((Object)vKey);
        }
        jsonObj.put((Object)"key", (Object)keyArray);
        jsonObj.put((Object)"timeKey", (Object)this.timeKey);
        jsonObj.put((Object)"autoExtend", (Object)this.autoExtend);
        return jsonObj;
    }

    @Override
    public void FromJsonObject(JSONObject inputDetail) throws LogException {
        this.LocalFileConfigFromJsonObject(inputDetail);
        this.separator = inputDetail.getString("separator");
        this.quote = inputDetail.getString("quote");
        this.SetKey(inputDetail.getJSONArray("key"));
        this.timeKey = inputDetail.getString("timeKey");
        this.autoExtend = inputDetail.getBoolean("autoExtend");
    }
}

