/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.loghub.client;

import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.loghub.client.ILogHubCheckPointTracker;
import com.aliyun.openservices.loghub.client.LogHubClientAdapter;
import com.aliyun.openservices.loghub.client.exceptions.LogHubCheckPointException;

public class DefaultLogHubCheckPointTracker
implements ILogHubCheckPointTracker {
    private String mCursor;
    private String mTempCheckPoint = "";
    private String mLastPersistentCheckPoint = "";
    private LogHubClientAdapter mLogHubClientAdapter;
    private String mInstanceName;
    private int mShardId;
    private long mLastCheckTime;
    private static long DEFAULT_FLUSH_CHECK_POINT_TERVAL_NANOS = 60000000000L;

    public DefaultLogHubCheckPointTracker(LogHubClientAdapter logHubClientAdapter, String instanceName, int shardId) {
        this.mLogHubClientAdapter = logHubClientAdapter;
        this.mInstanceName = instanceName;
        this.mShardId = shardId;
        this.mLastCheckTime = System.nanoTime();
    }

    public void setCursor(String cursor) {
        this.mCursor = cursor;
    }

    public String getCursor() {
        return this.mCursor;
    }

    @Override
    public void saveCheckPoint(boolean persistent) throws LogHubCheckPointException {
        this.mTempCheckPoint = this.mCursor;
        if (persistent) {
            this.flushCheckPoint();
        }
    }

    public void setInMemoryCheckPoint(String cursor) {
        this.mTempCheckPoint = cursor;
    }

    public void setInPeristentCheckPoint(String cursor) {
        this.mLastPersistentCheckPoint = cursor;
    }

    public void saveCheckPoint(String cursor, boolean persistent) throws LogHubCheckPointException {
        this.mTempCheckPoint = cursor;
        if (persistent) {
            this.flushCheckPoint();
        }
    }

    public void flushCheckPoint() throws LogHubCheckPointException {
        String toPersistent = this.mTempCheckPoint;
        if (toPersistent != null && !toPersistent.equals(this.mLastPersistentCheckPoint)) {
            try {
                this.mLogHubClientAdapter.UpdateCheckPoint(this.mShardId, this.mInstanceName, toPersistent);
                this.mLastPersistentCheckPoint = toPersistent;
            }
            catch (LogException e) {
                throw new LogHubCheckPointException("fail to persistent the cursor to outside system, " + this.mInstanceName + ", " + this.mShardId + ", " + toPersistent, e);
            }
        }
    }

    public void flushCheck() {
        long curTime = System.nanoTime();
        if (curTime > this.mLastCheckTime + DEFAULT_FLUSH_CHECK_POINT_TERVAL_NANOS) {
            try {
                this.flushCheckPoint();
            }
            catch (LogHubCheckPointException logHubCheckPointException) {
                // empty catch block
            }
            this.mLastCheckTime = curTime;
        }
    }

    @Override
    public String getCheckPoint() {
        return this.mTempCheckPoint;
    }
}

