/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.loghub.client;

import com.aliyun.openservices.log.common.Consts;
import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.response.BatchGetLogResponse;
import com.aliyun.openservices.loghub.client.FetchTaskResult;
import com.aliyun.openservices.loghub.client.ITask;
import com.aliyun.openservices.loghub.client.LogHubClientAdapter;
import com.aliyun.openservices.loghub.client.TaskResult;
import java.util.List;
import org.apache.log4j.Logger;

public class LogHubFetchTask
implements ITask {
    private LogHubClientAdapter mLogHubClientAdapter;
    private int mShardId;
    private String mCursor;
    private int mMaxFetchLogGroupSize;
    private static final Logger logger = Logger.getLogger(LogHubFetchTask.class);

    public LogHubFetchTask(LogHubClientAdapter logHubClientAdapter, int shardId, String cursor, int maxFetchLogGroupSize) {
        this.mLogHubClientAdapter = logHubClientAdapter;
        this.mShardId = shardId;
        this.mCursor = cursor;
        this.mMaxFetchLogGroupSize = maxFetchLogGroupSize;
    }

    @Override
    public TaskResult call() {
        Exception exception = null;
        for (int retry = 0; retry < 2; ++retry) {
            try {
                BatchGetLogResponse response = this.mLogHubClientAdapter.BatchGetLogs(this.mShardId, this.mMaxFetchLogGroupSize, this.mCursor);
                List fetchedData = response.GetLogGroups();
                logger.debug((Object)("shard id = " + this.mShardId + " cursor = " + this.mCursor + " next cursor" + response.GetNextCursor() + " size:" + String.valueOf(response.GetCount())));
                String cursor = response.GetNextCursor();
                if (cursor.isEmpty()) {
                    return new FetchTaskResult(fetchedData, this.mCursor, response.GetRawSize());
                }
                return new FetchTaskResult(fetchedData, cursor, response.GetRawSize());
            }
            catch (Exception e) {
                exception = e;
                if (retry != 0 || !(exception instanceof LogException) || ((LogException)((Object)exception)).GetErrorCode().toLowerCase().indexOf("invalidcursor") == -1) break;
                try {
                    this.freshCursor();
                    continue;
                }
                catch (Exception e2) {
                    return new TaskResult(exception);
                }
            }
        }
        return new TaskResult(exception);
    }

    public void freshCursor() throws NumberFormatException, LogException {
        this.mCursor = this.mLogHubClientAdapter.GetCursor(this.mShardId, Consts.CursorMode.END);
    }
}

