// $ANTLR 3.5.2 PhoenixSQL.g 2017-12-05 13:39:27

/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.phoenix.parse;

///CLOVER:OFF
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.filter.CompareFilter.CompareOp;
import java.lang.Boolean;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Stack;
import java.sql.SQLException;
import org.apache.phoenix.expression.function.CountAggregateFunction;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.PFunction.FunctionArgument;
import org.apache.phoenix.parse.UDFParseNode;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.PTable.IndexType;
import org.apache.phoenix.schema.stats.StatisticsCollectionScope;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedTime;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.parse.LikeParseNode.LikeType;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.parse.AddJarsStatement;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
@SuppressWarnings("all")
public class PhoenixSQLParser extends Parser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "ACTIVE", "ADD", "ALL", "ALTER", 
		"AND", "ANY", "ARRAY", "AS", "ASC", "ASTERISK", "ASYNC", "AT", "BETWEEN", 
		"BIND_NAME", "BY", "CACHE", "CASCADE", "CASE", "CAST", "CHAR", "CHAR_ESC", 
		"CLOSE", "COLON", "COLUMN", "COLUMNS", "COMMA", "COMMENT_AND_HINT_END", 
		"COMMENT_START", "CONCAT", "CONSTANT", "CONSTRAINT", "CREATE", "CURRENT", 
		"CURSOR", "CYCLE", "DBL_QUOTE_CHAR", "DECIMAL", "DECLARE", "DEFAULT", 
		"DEFAULTVALUE", "DELETE", "DESC", "DIGIT", "DISABLE", "DISTINCT", "DIVIDE", 
		"DOT", "DOUBLE", "DOUBLE_EQ", "DOUBLE_QUOTE", "DROP", "DUPLICATE", "ELSE", 
		"END", "EOL", "EQ", "EXECUTE", "EXISTS", "EXPLAIN", "Exponent", "FALSE", 
		"FETCH", "FIELDCHAR", "FIRST", "FOR", "FROM", "FULL", "FUNCTION", "GROUP", 
		"GT", "HAVING", "HINT_START", "IF", "IGNORE", "ILIKE", "IMMUTABLE", "IN", 
		"INCLUDE", "INCREMENT", "INDEX", "INNER", "INTO", "IS", "JAR", "JARS", 
		"JOIN", "KEY", "LAST", "LCURLY", "LEFT", "LETTER", "LIKE", "LIMIT", "LIST", 
		"LOCAL", "LPAREN", "LSQUARE", "LT", "MAXVALUE", "MINUS", "MINVALUE", "ML_COMMENT", 
		"ML_HINT", "NAME", "NEXT", "NOEQ1", "NOEQ2", "NOT", "NULL", "NULLS", "NUMBER", 
		"OFF", "OFFSET", "ON", "ONLY", "OPEN", "OR", "ORDER", "OTHER", "OUTER", 
		"OUTER_JOIN", "PERCENT", "PLUS", "POSINTEGER", "PRIMARY", "QUESTION", 
		"RCURLY", "REBUILD", "REPLACE", "RETURNS", "RIGHT", "ROW", "ROWS", "ROW_TIMESTAMP", 
		"RPAREN", "RSQUARE", "SAMPLING", "SCHEMA", "SELECT", "SEMICOLON", "SEQUENCE", 
		"SESSION", "SET", "SL_COMMENT", "SL_COMMENT1", "SL_COMMENT2", "SOME", 
		"SPLIT", "START", "STATISTICS", "STRING_LITERAL", "TABLE", "TABLES", "TEMPORARY", 
		"THEN", "TILDE", "TRACE", "TRUE", "UNION", "UNUSABLE", "UPDATE", "UPGRADE", 
		"UPSERT", "USABLE", "USE", "USING", "VALUE", "VALUES", "VIEW", "WHEN", 
		"WHERE", "WITH", "WITHIN", "WS"
	};
	public static final int EOF=-1;
	public static final int ACTIVE=4;
	public static final int ADD=5;
	public static final int ALL=6;
	public static final int ALTER=7;
	public static final int AND=8;
	public static final int ANY=9;
	public static final int ARRAY=10;
	public static final int AS=11;
	public static final int ASC=12;
	public static final int ASTERISK=13;
	public static final int ASYNC=14;
	public static final int AT=15;
	public static final int BETWEEN=16;
	public static final int BIND_NAME=17;
	public static final int BY=18;
	public static final int CACHE=19;
	public static final int CASCADE=20;
	public static final int CASE=21;
	public static final int CAST=22;
	public static final int CHAR=23;
	public static final int CHAR_ESC=24;
	public static final int CLOSE=25;
	public static final int COLON=26;
	public static final int COLUMN=27;
	public static final int COLUMNS=28;
	public static final int COMMA=29;
	public static final int COMMENT_AND_HINT_END=30;
	public static final int COMMENT_START=31;
	public static final int CONCAT=32;
	public static final int CONSTANT=33;
	public static final int CONSTRAINT=34;
	public static final int CREATE=35;
	public static final int CURRENT=36;
	public static final int CURSOR=37;
	public static final int CYCLE=38;
	public static final int DBL_QUOTE_CHAR=39;
	public static final int DECIMAL=40;
	public static final int DECLARE=41;
	public static final int DEFAULT=42;
	public static final int DEFAULTVALUE=43;
	public static final int DELETE=44;
	public static final int DESC=45;
	public static final int DIGIT=46;
	public static final int DISABLE=47;
	public static final int DISTINCT=48;
	public static final int DIVIDE=49;
	public static final int DOT=50;
	public static final int DOUBLE=51;
	public static final int DOUBLE_EQ=52;
	public static final int DOUBLE_QUOTE=53;
	public static final int DROP=54;
	public static final int DUPLICATE=55;
	public static final int ELSE=56;
	public static final int END=57;
	public static final int EOL=58;
	public static final int EQ=59;
	public static final int EXECUTE=60;
	public static final int EXISTS=61;
	public static final int EXPLAIN=62;
	public static final int Exponent=63;
	public static final int FALSE=64;
	public static final int FETCH=65;
	public static final int FIELDCHAR=66;
	public static final int FIRST=67;
	public static final int FOR=68;
	public static final int FROM=69;
	public static final int FULL=70;
	public static final int FUNCTION=71;
	public static final int GROUP=72;
	public static final int GT=73;
	public static final int HAVING=74;
	public static final int HINT_START=75;
	public static final int IF=76;
	public static final int IGNORE=77;
	public static final int ILIKE=78;
	public static final int IMMUTABLE=79;
	public static final int IN=80;
	public static final int INCLUDE=81;
	public static final int INCREMENT=82;
	public static final int INDEX=83;
	public static final int INNER=84;
	public static final int INTO=85;
	public static final int IS=86;
	public static final int JAR=87;
	public static final int JARS=88;
	public static final int JOIN=89;
	public static final int KEY=90;
	public static final int LAST=91;
	public static final int LCURLY=92;
	public static final int LEFT=93;
	public static final int LETTER=94;
	public static final int LIKE=95;
	public static final int LIMIT=96;
	public static final int LIST=97;
	public static final int LOCAL=98;
	public static final int LPAREN=99;
	public static final int LSQUARE=100;
	public static final int LT=101;
	public static final int MAXVALUE=102;
	public static final int MINUS=103;
	public static final int MINVALUE=104;
	public static final int ML_COMMENT=105;
	public static final int ML_HINT=106;
	public static final int NAME=107;
	public static final int NEXT=108;
	public static final int NOEQ1=109;
	public static final int NOEQ2=110;
	public static final int NOT=111;
	public static final int NULL=112;
	public static final int NULLS=113;
	public static final int NUMBER=114;
	public static final int OFF=115;
	public static final int OFFSET=116;
	public static final int ON=117;
	public static final int ONLY=118;
	public static final int OPEN=119;
	public static final int OR=120;
	public static final int ORDER=121;
	public static final int OTHER=122;
	public static final int OUTER=123;
	public static final int OUTER_JOIN=124;
	public static final int PERCENT=125;
	public static final int PLUS=126;
	public static final int POSINTEGER=127;
	public static final int PRIMARY=128;
	public static final int QUESTION=129;
	public static final int RCURLY=130;
	public static final int REBUILD=131;
	public static final int REPLACE=132;
	public static final int RETURNS=133;
	public static final int RIGHT=134;
	public static final int ROW=135;
	public static final int ROWS=136;
	public static final int ROW_TIMESTAMP=137;
	public static final int RPAREN=138;
	public static final int RSQUARE=139;
	public static final int SAMPLING=140;
	public static final int SCHEMA=141;
	public static final int SELECT=142;
	public static final int SEMICOLON=143;
	public static final int SEQUENCE=144;
	public static final int SESSION=145;
	public static final int SET=146;
	public static final int SL_COMMENT=147;
	public static final int SL_COMMENT1=148;
	public static final int SL_COMMENT2=149;
	public static final int SOME=150;
	public static final int SPLIT=151;
	public static final int START=152;
	public static final int STATISTICS=153;
	public static final int STRING_LITERAL=154;
	public static final int TABLE=155;
	public static final int TABLES=156;
	public static final int TEMPORARY=157;
	public static final int THEN=158;
	public static final int TILDE=159;
	public static final int TRACE=160;
	public static final int TRUE=161;
	public static final int UNION=162;
	public static final int UNUSABLE=163;
	public static final int UPDATE=164;
	public static final int UPGRADE=165;
	public static final int UPSERT=166;
	public static final int USABLE=167;
	public static final int USE=168;
	public static final int USING=169;
	public static final int VALUE=170;
	public static final int VALUES=171;
	public static final int VIEW=172;
	public static final int WHEN=173;
	public static final int WHERE=174;
	public static final int WITH=175;
	public static final int WITHIN=176;
	public static final int WS=177;

	// delegates
	public Parser[] getDelegates() {
		return new Parser[] {};
	}

	// delegators


	public PhoenixSQLParser(TokenStream input) {
		this(input, new RecognizerSharedState());
	}
	public PhoenixSQLParser(TokenStream input, RecognizerSharedState state) {
		super(input, state);
	}

	@Override public String[] getTokenNames() { return PhoenixSQLParser.tokenNames; }
	@Override public String getGrammarFileName() { return "PhoenixSQL.g"; }


	    
	    /**
	     * used to turn '?' binds into : binds.
	     */
	    private int anonBindNum;
	    private ParseNodeFactory factory;
	    private ParseContext.Stack contextStack = new ParseContext.Stack();
	    private Map<String, UDFParseNode> udfParseNodes = new HashMap<String, UDFParseNode>(1);

	    public void setParseNodeFactory(ParseNodeFactory factory) {
	        this.factory = factory;
	    }
	    
	    public boolean isCountFunction(String field) {
	        return CountAggregateFunction.NORMALIZED_NAME.equals(SchemaUtil.normalizeIdentifier(field));
	    }
	     
	    public int line(Token t) {
	        return t.getLine();
	    }

	    public int column(Token t) {
	        return t.getCharPositionInLine() + 1;
	    }
	    
	    private void throwRecognitionException(Token t) throws RecognitionException {
	        RecognitionException e = new RecognitionException();
	        e.token = t;
	        e.line = t.getLine();
	        e.charPositionInLine = t.getCharPositionInLine();
	        e.input = input;
	        throw e;
	    }
	    
	    public int getBindCount() {
	        return anonBindNum;
	    }
	    
	    public void resetBindCount() {
	        anonBindNum = 0;
	    }
	    
	    public String nextBind() {
	        return Integer.toString(++anonBindNum);
	    }
	    
	    public void updateBind(String namedBind){
	         int nBind = Integer.parseInt(namedBind);
	         if (nBind > anonBindNum) {
	             anonBindNum = nBind;
	         }
	    }

	    protected Object recoverFromMismatchedToken(IntStream input, int ttype, BitSet follow)
	        throws RecognitionException {
	        RecognitionException e = null;
	        // if next token is what we are looking for then "delete" this token
	        if (mismatchIsUnwantedToken(input, ttype)) {
	            e = new UnwantedTokenException(ttype, input);
	        } else if (mismatchIsMissingToken(input, follow)) {
	            Object inserted = getMissingSymbol(input, e, ttype, follow);
	            e = new MissingTokenException(ttype, input, inserted);
	        } else {
	            e = new MismatchedTokenException(ttype, input);
	        }
	        throw e;
	    }

	    public Object recoverFromMismatchedSet(IntStream input, RecognitionException e, BitSet follow)
	        throws RecognitionException
	    {
	        throw e;
	    }
	    
	    @Override
	    public String getErrorMessage(RecognitionException e, String[] tokenNames) {
	        if (e instanceof MismatchedTokenException) {
	            MismatchedTokenException mte = (MismatchedTokenException)e;
	            String txt = mte.token.getText();
	            String p = mte.token.getType() == -1 ? "EOF" : PARAPHRASE[mte.token.getType()];
	            String expecting = (mte.expecting < PARAPHRASE.length && mte.expecting >= 0) ? PARAPHRASE[mte.expecting] : null;
	            if (expecting == null) {
	                return "unexpected token (" + line(mte.token) + "," + column(mte.token) + "): " + (txt != null ? txt : p);
	            } else {
	                return "expecting " + expecting +
	                    ", found '" + (txt != null ? txt : p) + "'";
	            }
	        } else if (e instanceof NoViableAltException) {
	            //NoViableAltException nvae = (NoViableAltException)e;
	            return "unexpected token: (" + line(e.token) + "," + column(e.token) + ")" + getTokenErrorDisplay(e.token);
	        }
	        return super.getErrorMessage(e, tokenNames);
	     }

	    public String getTokenErrorDisplay(int t) {
	        String ret = PARAPHRASE[t];
	        if (ret == null) ret = "<UNKNOWN>";
	        return ret;
	    }


	    private String[] PARAPHRASE = new String[getTokenNames().length];
	    {
	        PARAPHRASE[NAME] = "a field or entity name";
	        PARAPHRASE[NUMBER] = "a number";
	        PARAPHRASE[EQ] = "an equals sign";
	        PARAPHRASE[LT] = "a left angle bracket";
	        PARAPHRASE[GT] = "a right angle bracket";
	        PARAPHRASE[COMMA] = "a comma";
	        PARAPHRASE[LPAREN] = "a left parentheses";
	        PARAPHRASE[RPAREN] = "a right parentheses";
	        PARAPHRASE[SEMICOLON] = "a semi-colon";
	        PARAPHRASE[COLON] = "a colon";
	        PARAPHRASE[LSQUARE] = "left square bracket";
	        PARAPHRASE[RSQUARE] = "right square bracket";
	        PARAPHRASE[LCURLY] = "left curly bracket";
	        PARAPHRASE[RCURLY] = "right curly bracket";
	        PARAPHRASE[AT] = "at";
	        PARAPHRASE[MINUS] = "a subtraction";
	        PARAPHRASE[TILDE] = "a tilde";
	        PARAPHRASE[PLUS] = "an addition";
	        PARAPHRASE[ASTERISK] = "an asterisk";
	        PARAPHRASE[DIVIDE] = "a division";
	        PARAPHRASE[FIELDCHAR] = "a field character";
	        PARAPHRASE[LETTER] = "an ansi letter";
	        PARAPHRASE[POSINTEGER] = "a positive integer";
	        PARAPHRASE[DIGIT] = "a number from 0 to 9";
	    }



	// $ANTLR start "nextStatement"
	// PhoenixSQL.g:379:1: nextStatement returns [BindableStatement ret] : (s= oneStatement SEMICOLON | EOF );
	public final BindableStatement nextStatement() throws RecognitionException {
		BindableStatement ret = null;


		BindableStatement s =null;

		try {
			// PhoenixSQL.g:380:5: (s= oneStatement SEMICOLON | EOF )
			int alt1=2;
			int LA1_0 = input.LA(1);
			if ( (LA1_0==ADD||LA1_0==ALTER||LA1_0==CLOSE||LA1_0==CREATE||LA1_0==DECLARE||LA1_0==DELETE||LA1_0==DROP||LA1_0==EXECUTE||LA1_0==EXPLAIN||LA1_0==FETCH||LA1_0==LIST||LA1_0==OPEN||LA1_0==SELECT||LA1_0==TRACE||LA1_0==UPDATE||LA1_0==UPSERT||LA1_0==USE) ) {
				alt1=1;
			}
			else if ( (LA1_0==EOF) ) {
				alt1=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 1, 0, input);
				throw nvae;
			}

			switch (alt1) {
				case 1 :
					// PhoenixSQL.g:380:8: s= oneStatement SEMICOLON
					{
					pushFollow(FOLLOW_oneStatement_in_nextStatement1235);
					s=oneStatement();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					    		try {
					    			ret = s;
					    		} finally {
					    			udfParseNodes.clear();
					    		}
					    	}
					match(input,SEMICOLON,FOLLOW_SEMICOLON_in_nextStatement1239); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:387:8: EOF
					{
					match(input,EOF,FOLLOW_EOF_in_nextStatement1248); if (state.failed) return ret;
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "nextStatement"



	// $ANTLR start "statement"
	// PhoenixSQL.g:391:1: statement returns [BindableStatement ret] : s= oneStatement EOF ;
	public final BindableStatement statement() throws RecognitionException {
		BindableStatement ret = null;


		BindableStatement s =null;

		try {
			// PhoenixSQL.g:392:5: (s= oneStatement EOF )
			// PhoenixSQL.g:392:9: s= oneStatement EOF
			{
			pushFollow(FOLLOW_oneStatement_in_statement1274);
			s=oneStatement();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			        		try {
			    			ret = s;
			    		} finally {
			    			udfParseNodes.clear();
			    		}
			    	}
			match(input,EOF,FOLLOW_EOF_in_statement1278); if (state.failed) return ret;
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "statement"



	// $ANTLR start "query"
	// PhoenixSQL.g:402:1: query returns [SelectStatement ret] : s= select_node EOF ;
	public final SelectStatement query() throws RecognitionException {
		SelectStatement ret = null;


		SelectStatement s =null;

		try {
			// PhoenixSQL.g:403:5: (s= select_node EOF )
			// PhoenixSQL.g:403:9: s= select_node EOF
			{
			pushFollow(FOLLOW_select_node_in_query1304);
			s=select_node();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EOF,FOLLOW_EOF_in_query1306); if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret =s;}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "query"



	// $ANTLR start "oneStatement"
	// PhoenixSQL.g:407:1: oneStatement returns [BindableStatement ret] : (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= alter_index_node |s= alter_table_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node ) ;
	public final BindableStatement oneStatement() throws RecognitionException {
		BindableStatement ret = null;


		BindableStatement s =null;

		 contextStack.push(new ParseContext()); 
		try {
			// PhoenixSQL.g:409:5: ( (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= alter_index_node |s= alter_table_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node ) )
			// PhoenixSQL.g:409:8: (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= alter_index_node |s= alter_table_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node )
			{
			// PhoenixSQL.g:409:8: (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= alter_index_node |s= alter_table_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node )
			int alt2=29;
			switch ( input.LA(1) ) {
			case SELECT:
				{
				alt2=1;
				}
				break;
			case UPSERT:
				{
				alt2=2;
				}
				break;
			case DELETE:
				{
				int LA2_3 = input.LA(2);
				if ( (LA2_3==JAR) ) {
					alt2=21;
				}
				else if ( (LA2_3==FROM||LA2_3==ML_HINT) ) {
					alt2=3;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case CREATE:
				{
				switch ( input.LA(2) ) {
				case SCHEMA:
					{
					alt2=5;
					}
					break;
				case VIEW:
					{
					alt2=6;
					}
					break;
				case SEQUENCE:
					{
					alt2=23;
					}
					break;
				case IMMUTABLE:
				case TABLE:
					{
					alt2=4;
					}
					break;
				case INDEX:
				case LOCAL:
					{
					alt2=7;
					}
					break;
				case FUNCTION:
				case OR:
				case TEMPORARY:
					{
					alt2=17;
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 4, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case OPEN:
				{
				alt2=8;
				}
				break;
			case CLOSE:
				{
				alt2=9;
				}
				break;
			case FETCH:
				{
				alt2=10;
				}
				break;
			case DECLARE:
				{
				alt2=11;
				}
				break;
			case DROP:
				{
				switch ( input.LA(2) ) {
				case INDEX:
					{
					alt2=13;
					}
					break;
				case FUNCTION:
					{
					alt2=18;
					}
					break;
				case SEQUENCE:
					{
					alt2=24;
					}
					break;
				case SCHEMA:
					{
					alt2=25;
					}
					break;
				case TABLE:
				case VIEW:
					{
					alt2=12;
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 9, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case ALTER:
				{
				switch ( input.LA(2) ) {
				case INDEX:
					{
					alt2=14;
					}
					break;
				case SESSION:
					{
					alt2=22;
					}
					break;
				case TABLE:
				case VIEW:
					{
					alt2=15;
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 10, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case TRACE:
				{
				alt2=16;
				}
				break;
			case ADD:
				{
				alt2=19;
				}
				break;
			case LIST:
				{
				alt2=20;
				}
				break;
			case USE:
				{
				alt2=26;
				}
				break;
			case UPDATE:
				{
				alt2=27;
				}
				break;
			case EXECUTE:
				{
				alt2=28;
				}
				break;
			case EXPLAIN:
				{
				alt2=29;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 2, 0, input);
				throw nvae;
			}
			switch (alt2) {
				case 1 :
					// PhoenixSQL.g:409:9: s= select_node
					{
					pushFollow(FOLLOW_select_node_in_oneStatement1338);
					s=select_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:410:7: s= upsert_node
					{
					pushFollow(FOLLOW_upsert_node_in_oneStatement1348);
					s=upsert_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 3 :
					// PhoenixSQL.g:411:9: s= delete_node
					{
					pushFollow(FOLLOW_delete_node_in_oneStatement1360);
					s=delete_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 4 :
					// PhoenixSQL.g:412:9: s= create_table_node
					{
					pushFollow(FOLLOW_create_table_node_in_oneStatement1372);
					s=create_table_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 5 :
					// PhoenixSQL.g:413:9: s= create_schema_node
					{
					pushFollow(FOLLOW_create_schema_node_in_oneStatement1384);
					s=create_schema_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 6 :
					// PhoenixSQL.g:414:9: s= create_view_node
					{
					pushFollow(FOLLOW_create_view_node_in_oneStatement1396);
					s=create_view_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 7 :
					// PhoenixSQL.g:415:9: s= create_index_node
					{
					pushFollow(FOLLOW_create_index_node_in_oneStatement1408);
					s=create_index_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 8 :
					// PhoenixSQL.g:416:9: s= cursor_open_node
					{
					pushFollow(FOLLOW_cursor_open_node_in_oneStatement1420);
					s=cursor_open_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 9 :
					// PhoenixSQL.g:417:9: s= cursor_close_node
					{
					pushFollow(FOLLOW_cursor_close_node_in_oneStatement1432);
					s=cursor_close_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 10 :
					// PhoenixSQL.g:418:9: s= cursor_fetch_node
					{
					pushFollow(FOLLOW_cursor_fetch_node_in_oneStatement1444);
					s=cursor_fetch_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 11 :
					// PhoenixSQL.g:419:9: s= declare_cursor_node
					{
					pushFollow(FOLLOW_declare_cursor_node_in_oneStatement1456);
					s=declare_cursor_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 12 :
					// PhoenixSQL.g:420:9: s= drop_table_node
					{
					pushFollow(FOLLOW_drop_table_node_in_oneStatement1468);
					s=drop_table_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 13 :
					// PhoenixSQL.g:421:9: s= drop_index_node
					{
					pushFollow(FOLLOW_drop_index_node_in_oneStatement1480);
					s=drop_index_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 14 :
					// PhoenixSQL.g:422:9: s= alter_index_node
					{
					pushFollow(FOLLOW_alter_index_node_in_oneStatement1492);
					s=alter_index_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 15 :
					// PhoenixSQL.g:423:9: s= alter_table_node
					{
					pushFollow(FOLLOW_alter_table_node_in_oneStatement1504);
					s=alter_table_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 16 :
					// PhoenixSQL.g:424:9: s= trace_node
					{
					pushFollow(FOLLOW_trace_node_in_oneStatement1516);
					s=trace_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 17 :
					// PhoenixSQL.g:425:9: s= create_function_node
					{
					pushFollow(FOLLOW_create_function_node_in_oneStatement1528);
					s=create_function_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 18 :
					// PhoenixSQL.g:426:9: s= drop_function_node
					{
					pushFollow(FOLLOW_drop_function_node_in_oneStatement1540);
					s=drop_function_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 19 :
					// PhoenixSQL.g:427:9: s= add_jars_node
					{
					pushFollow(FOLLOW_add_jars_node_in_oneStatement1552);
					s=add_jars_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 20 :
					// PhoenixSQL.g:428:9: s= list_jars_node
					{
					pushFollow(FOLLOW_list_jars_node_in_oneStatement1564);
					s=list_jars_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 21 :
					// PhoenixSQL.g:429:9: s= delete_jar_node
					{
					pushFollow(FOLLOW_delete_jar_node_in_oneStatement1576);
					s=delete_jar_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 22 :
					// PhoenixSQL.g:430:9: s= alter_session_node
					{
					pushFollow(FOLLOW_alter_session_node_in_oneStatement1588);
					s=alter_session_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 23 :
					// PhoenixSQL.g:431:7: s= create_sequence_node
					{
					pushFollow(FOLLOW_create_sequence_node_in_oneStatement1598);
					s=create_sequence_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 24 :
					// PhoenixSQL.g:432:7: s= drop_sequence_node
					{
					pushFollow(FOLLOW_drop_sequence_node_in_oneStatement1608);
					s=drop_sequence_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 25 :
					// PhoenixSQL.g:433:7: s= drop_schema_node
					{
					pushFollow(FOLLOW_drop_schema_node_in_oneStatement1618);
					s=drop_schema_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 26 :
					// PhoenixSQL.g:434:7: s= use_schema_node
					{
					pushFollow(FOLLOW_use_schema_node_in_oneStatement1628);
					s=use_schema_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 27 :
					// PhoenixSQL.g:435:9: s= update_statistics_node
					{
					pushFollow(FOLLOW_update_statistics_node_in_oneStatement1640);
					s=update_statistics_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 28 :
					// PhoenixSQL.g:436:9: s= execute_upgrade_node
					{
					pushFollow(FOLLOW_execute_upgrade_node_in_oneStatement1652);
					s=execute_upgrade_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 29 :
					// PhoenixSQL.g:437:9: s= explain_node
					{
					pushFollow(FOLLOW_explain_node_in_oneStatement1664);
					s=explain_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = s; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
			 contextStack.pop(); 
		}
		return ret;
	}
	// $ANTLR end "oneStatement"



	// $ANTLR start "explain_node"
	// PhoenixSQL.g:441:1: explain_node returns [BindableStatement ret] : EXPLAIN q= oneStatement ;
	public final BindableStatement explain_node() throws RecognitionException {
		BindableStatement ret = null;


		BindableStatement q =null;

		try {
			// PhoenixSQL.g:442:5: ( EXPLAIN q= oneStatement )
			// PhoenixSQL.g:442:9: EXPLAIN q= oneStatement
			{
			match(input,EXPLAIN,FOLLOW_EXPLAIN_in_explain_node1697); if (state.failed) return ret;
			pushFollow(FOLLOW_oneStatement_in_explain_node1701);
			q=oneStatement();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret =factory.explain(q);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "explain_node"



	// $ANTLR start "create_table_node"
	// PhoenixSQL.g:446:1: create_table_node returns [CreateTableStatement ret] : CREATE (im= IMMUTABLE )? TABLE ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN ) (p= fam_properties )? ( SPLIT ON s= value_expression_list )? ;
	public final CreateTableStatement create_table_node() throws RecognitionException {
		CreateTableStatement ret = null;


		Token im=null;
		Token ex=null;
		TableName t =null;
		List<ColumnDef> c =null;
		PrimaryKeyConstraint pk =null;
		ListMultimap<String,Pair<String,Object>> p =null;
		List<ParseNode> s =null;

		try {
			// PhoenixSQL.g:447:5: ( CREATE (im= IMMUTABLE )? TABLE ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN ) (p= fam_properties )? ( SPLIT ON s= value_expression_list )? )
			// PhoenixSQL.g:447:9: CREATE (im= IMMUTABLE )? TABLE ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN ) (p= fam_properties )? ( SPLIT ON s= value_expression_list )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_table_node1727); if (state.failed) return ret;
			// PhoenixSQL.g:447:16: (im= IMMUTABLE )?
			int alt3=2;
			int LA3_0 = input.LA(1);
			if ( (LA3_0==IMMUTABLE) ) {
				alt3=1;
			}
			switch (alt3) {
				case 1 :
					// PhoenixSQL.g:447:17: im= IMMUTABLE
					{
					im=(Token)match(input,IMMUTABLE,FOLLOW_IMMUTABLE_in_create_table_node1732); if (state.failed) return ret;
					}
					break;

			}

			match(input,TABLE,FOLLOW_TABLE_in_create_table_node1736); if (state.failed) return ret;
			// PhoenixSQL.g:447:38: ( IF NOT ex= EXISTS )?
			int alt4=2;
			int LA4_0 = input.LA(1);
			if ( (LA4_0==IF) ) {
				alt4=1;
			}
			switch (alt4) {
				case 1 :
					// PhoenixSQL.g:447:39: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_table_node1739); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_table_node1741); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_table_node1745); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_create_table_node1751);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:448:9: ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )
			// PhoenixSQL.g:448:10: LPAREN c= column_defs (pk= pk_constraint )? RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_create_table_node1763); if (state.failed) return ret;
			pushFollow(FOLLOW_column_defs_in_create_table_node1767);
			c=column_defs();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:448:31: (pk= pk_constraint )?
			int alt5=2;
			int LA5_0 = input.LA(1);
			if ( (LA5_0==COMMA||LA5_0==CONSTRAINT) ) {
				alt5=1;
			}
			switch (alt5) {
				case 1 :
					// PhoenixSQL.g:448:32: pk= pk_constraint
					{
					pushFollow(FOLLOW_pk_constraint_in_create_table_node1772);
					pk=pk_constraint();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			match(input,RPAREN,FOLLOW_RPAREN_in_create_table_node1776); if (state.failed) return ret;
			}

			// PhoenixSQL.g:449:9: (p= fam_properties )?
			int alt6=2;
			int LA6_0 = input.LA(1);
			if ( (LA6_0==NAME) ) {
				alt6=1;
			}
			switch (alt6) {
				case 1 :
					// PhoenixSQL.g:449:10: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_create_table_node1790);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:450:9: ( SPLIT ON s= value_expression_list )?
			int alt7=2;
			int LA7_0 = input.LA(1);
			if ( (LA7_0==SPLIT) ) {
				alt7=1;
			}
			switch (alt7) {
				case 1 :
					// PhoenixSQL.g:450:10: SPLIT ON s= value_expression_list
					{
					match(input,SPLIT,FOLLOW_SPLIT_in_create_table_node1803); if (state.failed) return ret;
					match(input,ON,FOLLOW_ON_in_create_table_node1805); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_list_in_create_table_node1809);
					s=value_expression_list();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.createTable(t, p, c, pk, s, PTableType.TABLE, ex!=null, null, null, getBindCount(), im!=null ? true : null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_table_node"



	// $ANTLR start "create_schema_node"
	// PhoenixSQL.g:455:1: create_schema_node returns [CreateSchemaStatement ret] : CREATE SCHEMA ( IF NOT ex= EXISTS )? ( DEFAULT |s= identifier ) ;
	public final CreateSchemaStatement create_schema_node() throws RecognitionException {
		CreateSchemaStatement ret = null;


		Token ex=null;
		String s =null;

		try {
			// PhoenixSQL.g:456:5: ( CREATE SCHEMA ( IF NOT ex= EXISTS )? ( DEFAULT |s= identifier ) )
			// PhoenixSQL.g:456:9: CREATE SCHEMA ( IF NOT ex= EXISTS )? ( DEFAULT |s= identifier )
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_schema_node1848); if (state.failed) return ret;
			match(input,SCHEMA,FOLLOW_SCHEMA_in_create_schema_node1850); if (state.failed) return ret;
			// PhoenixSQL.g:456:23: ( IF NOT ex= EXISTS )?
			int alt8=2;
			int LA8_0 = input.LA(1);
			if ( (LA8_0==IF) ) {
				alt8=1;
			}
			switch (alt8) {
				case 1 :
					// PhoenixSQL.g:456:24: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_schema_node1853); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_schema_node1855); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_schema_node1859); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:456:43: ( DEFAULT |s= identifier )
			int alt9=2;
			int LA9_0 = input.LA(1);
			if ( (LA9_0==DEFAULT) ) {
				alt9=1;
			}
			else if ( (LA9_0==NAME) ) {
				alt9=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 9, 0, input);
				throw nvae;
			}

			switch (alt9) {
				case 1 :
					// PhoenixSQL.g:456:44: DEFAULT
					{
					match(input,DEFAULT,FOLLOW_DEFAULT_in_create_schema_node1864); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:456:54: s= identifier
					{
					pushFollow(FOLLOW_identifier_in_create_schema_node1870);
					s=identifier();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.createSchema(s, ex!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_schema_node"



	// $ANTLR start "create_view_node"
	// PhoenixSQL.g:461:1: create_view_node returns [CreateTableStatement ret] : CREATE VIEW ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )? ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )? (p= fam_properties )? ;
	public final CreateTableStatement create_view_node() throws RecognitionException {
		CreateTableStatement ret = null;


		Token ex=null;
		TableName t =null;
		List<ColumnDef> c =null;
		PrimaryKeyConstraint pk =null;
		TableName bt =null;
		ParseNode w =null;
		ListMultimap<String,Pair<String,Object>> p =null;

		try {
			// PhoenixSQL.g:462:5: ( CREATE VIEW ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )? ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )? (p= fam_properties )? )
			// PhoenixSQL.g:462:9: CREATE VIEW ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )? ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )? (p= fam_properties )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_view_node1905); if (state.failed) return ret;
			match(input,VIEW,FOLLOW_VIEW_in_create_view_node1907); if (state.failed) return ret;
			// PhoenixSQL.g:462:21: ( IF NOT ex= EXISTS )?
			int alt10=2;
			int LA10_0 = input.LA(1);
			if ( (LA10_0==IF) ) {
				alt10=1;
			}
			switch (alt10) {
				case 1 :
					// PhoenixSQL.g:462:22: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_view_node1910); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_view_node1912); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_view_node1916); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_create_view_node1922);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:463:9: ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )?
			int alt12=2;
			int LA12_0 = input.LA(1);
			if ( (LA12_0==LPAREN) ) {
				alt12=1;
			}
			switch (alt12) {
				case 1 :
					// PhoenixSQL.g:463:10: LPAREN c= column_defs (pk= pk_constraint )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_create_view_node1934); if (state.failed) return ret;
					pushFollow(FOLLOW_column_defs_in_create_view_node1938);
					c=column_defs();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:463:31: (pk= pk_constraint )?
					int alt11=2;
					int LA11_0 = input.LA(1);
					if ( (LA11_0==COMMA||LA11_0==CONSTRAINT) ) {
						alt11=1;
					}
					switch (alt11) {
						case 1 :
							// PhoenixSQL.g:463:32: pk= pk_constraint
							{
							pushFollow(FOLLOW_pk_constraint_in_create_view_node1943);
							pk=pk_constraint();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_create_view_node1947); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:464:9: ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )?
			int alt14=2;
			int LA14_0 = input.LA(1);
			if ( (LA14_0==AS) ) {
				alt14=1;
			}
			switch (alt14) {
				case 1 :
					// PhoenixSQL.g:464:11: AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )?
					{
					match(input,AS,FOLLOW_AS_in_create_view_node1961); if (state.failed) return ret;
					match(input,SELECT,FOLLOW_SELECT_in_create_view_node1963); if (state.failed) return ret;
					match(input,ASTERISK,FOLLOW_ASTERISK_in_create_view_node1965); if (state.failed) return ret;
					match(input,FROM,FOLLOW_FROM_in_create_view_node1977); if (state.failed) return ret;
					pushFollow(FOLLOW_from_table_name_in_create_view_node1981);
					bt=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:466:11: ( WHERE w= expression )?
					int alt13=2;
					int LA13_0 = input.LA(1);
					if ( (LA13_0==WHERE) ) {
						alt13=1;
					}
					switch (alt13) {
						case 1 :
							// PhoenixSQL.g:466:12: WHERE w= expression
							{
							match(input,WHERE,FOLLOW_WHERE_in_create_view_node1994); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_create_view_node1998);
							w=expression();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}
					break;

			}

			// PhoenixSQL.g:467:9: (p= fam_properties )?
			int alt15=2;
			int LA15_0 = input.LA(1);
			if ( (LA15_0==NAME) ) {
				alt15=1;
			}
			switch (alt15) {
				case 1 :
					// PhoenixSQL.g:467:10: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_create_view_node2016);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.createTable(t, p, c, pk, null, PTableType.VIEW, ex!=null, bt==null ? t : bt, w, getBindCount(), null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_view_node"



	// $ANTLR start "create_index_node"
	// PhoenixSQL.g:472:1: create_index_node returns [CreateIndexStatement ret] : CREATE (l= LOCAL )? INDEX ( IF NOT ex= EXISTS )? i= index_name ON t= from_table_name ( LPAREN ik= ik_constraint RPAREN ) ( INCLUDE ( LPAREN icrefs= column_names RPAREN ) )? (async= ASYNC )? (p= fam_properties )? ( SPLIT ON v= value_expression_list )? ;
	public final CreateIndexStatement create_index_node() throws RecognitionException {
		CreateIndexStatement ret = null;


		Token l=null;
		Token ex=null;
		Token async=null;
		NamedNode i =null;
		TableName t =null;
		IndexKeyConstraint ik =null;
		List<ColumnName> icrefs =null;
		ListMultimap<String,Pair<String,Object>> p =null;
		List<ParseNode> v =null;

		try {
			// PhoenixSQL.g:473:5: ( CREATE (l= LOCAL )? INDEX ( IF NOT ex= EXISTS )? i= index_name ON t= from_table_name ( LPAREN ik= ik_constraint RPAREN ) ( INCLUDE ( LPAREN icrefs= column_names RPAREN ) )? (async= ASYNC )? (p= fam_properties )? ( SPLIT ON v= value_expression_list )? )
			// PhoenixSQL.g:473:9: CREATE (l= LOCAL )? INDEX ( IF NOT ex= EXISTS )? i= index_name ON t= from_table_name ( LPAREN ik= ik_constraint RPAREN ) ( INCLUDE ( LPAREN icrefs= column_names RPAREN ) )? (async= ASYNC )? (p= fam_properties )? ( SPLIT ON v= value_expression_list )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_index_node2052); if (state.failed) return ret;
			// PhoenixSQL.g:473:17: (l= LOCAL )?
			int alt16=2;
			int LA16_0 = input.LA(1);
			if ( (LA16_0==LOCAL) ) {
				alt16=1;
			}
			switch (alt16) {
				case 1 :
					// PhoenixSQL.g:473:17: l= LOCAL
					{
					l=(Token)match(input,LOCAL,FOLLOW_LOCAL_in_create_index_node2056); if (state.failed) return ret;
					}
					break;

			}

			match(input,INDEX,FOLLOW_INDEX_in_create_index_node2059); if (state.failed) return ret;
			// PhoenixSQL.g:473:31: ( IF NOT ex= EXISTS )?
			int alt17=2;
			int LA17_0 = input.LA(1);
			if ( (LA17_0==IF) ) {
				alt17=1;
			}
			switch (alt17) {
				case 1 :
					// PhoenixSQL.g:473:32: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_index_node2062); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_index_node2064); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_index_node2068); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_index_name_in_create_index_node2074);
			i=index_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,ON,FOLLOW_ON_in_create_index_node2076); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_create_index_node2080);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:474:9: ( LPAREN ik= ik_constraint RPAREN )
			// PhoenixSQL.g:474:10: LPAREN ik= ik_constraint RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_create_index_node2091); if (state.failed) return ret;
			pushFollow(FOLLOW_ik_constraint_in_create_index_node2095);
			ik=ik_constraint();
			state._fsp--;
			if (state.failed) return ret;
			match(input,RPAREN,FOLLOW_RPAREN_in_create_index_node2097); if (state.failed) return ret;
			}

			// PhoenixSQL.g:475:9: ( INCLUDE ( LPAREN icrefs= column_names RPAREN ) )?
			int alt18=2;
			int LA18_0 = input.LA(1);
			if ( (LA18_0==INCLUDE) ) {
				alt18=1;
			}
			switch (alt18) {
				case 1 :
					// PhoenixSQL.g:475:10: INCLUDE ( LPAREN icrefs= column_names RPAREN )
					{
					match(input,INCLUDE,FOLLOW_INCLUDE_in_create_index_node2109); if (state.failed) return ret;
					// PhoenixSQL.g:475:18: ( LPAREN icrefs= column_names RPAREN )
					// PhoenixSQL.g:475:19: LPAREN icrefs= column_names RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_create_index_node2112); if (state.failed) return ret;
					pushFollow(FOLLOW_column_names_in_create_index_node2116);
					icrefs=column_names();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_create_index_node2118); if (state.failed) return ret;
					}

					}
					break;

			}

			// PhoenixSQL.g:476:9: (async= ASYNC )?
			int alt19=2;
			int LA19_0 = input.LA(1);
			if ( (LA19_0==ASYNC) ) {
				alt19=1;
			}
			switch (alt19) {
				case 1 :
					// PhoenixSQL.g:476:10: async= ASYNC
					{
					async=(Token)match(input,ASYNC,FOLLOW_ASYNC_in_create_index_node2134); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:477:9: (p= fam_properties )?
			int alt20=2;
			int LA20_0 = input.LA(1);
			if ( (LA20_0==NAME) ) {
				alt20=1;
			}
			switch (alt20) {
				case 1 :
					// PhoenixSQL.g:477:10: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_create_index_node2149);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:478:9: ( SPLIT ON v= value_expression_list )?
			int alt21=2;
			int LA21_0 = input.LA(1);
			if ( (LA21_0==SPLIT) ) {
				alt21=1;
			}
			switch (alt21) {
				case 1 :
					// PhoenixSQL.g:478:10: SPLIT ON v= value_expression_list
					{
					match(input,SPLIT,FOLLOW_SPLIT_in_create_index_node2162); if (state.failed) return ret;
					match(input,ON,FOLLOW_ON_in_create_index_node2164); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_list_in_create_index_node2168);
					v=value_expression_list();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.createIndex(i, factory.namedTable(null,t), ik, icrefs, v, p, ex!=null, l==null ? IndexType.getDefault() : IndexType.LOCAL, async != null, getBindCount(), new HashMap<String, UDFParseNode>(udfParseNodes)); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_index_node"



	// $ANTLR start "create_sequence_node"
	// PhoenixSQL.g:483:1: create_sequence_node returns [CreateSequenceStatement ret] : CREATE SEQUENCE ( IF NOT ex= EXISTS )? t= from_table_name ( START ( WITH )? s= value_expression )? ( INCREMENT ( BY )? i= value_expression )? ( MINVALUE min= value_expression )? ( MAXVALUE max= value_expression )? (cyc= CYCLE )? ( CACHE c= int_literal_or_bind )? ;
	public final CreateSequenceStatement create_sequence_node() throws RecognitionException {
		CreateSequenceStatement ret = null;


		Token ex=null;
		Token cyc=null;
		TableName t =null;
		ParseNode s =null;
		ParseNode i =null;
		ParseNode min =null;
		ParseNode max =null;
		ParseNode c =null;

		try {
			// PhoenixSQL.g:484:5: ( CREATE SEQUENCE ( IF NOT ex= EXISTS )? t= from_table_name ( START ( WITH )? s= value_expression )? ( INCREMENT ( BY )? i= value_expression )? ( MINVALUE min= value_expression )? ( MAXVALUE max= value_expression )? (cyc= CYCLE )? ( CACHE c= int_literal_or_bind )? )
			// PhoenixSQL.g:484:9: CREATE SEQUENCE ( IF NOT ex= EXISTS )? t= from_table_name ( START ( WITH )? s= value_expression )? ( INCREMENT ( BY )? i= value_expression )? ( MINVALUE min= value_expression )? ( MAXVALUE max= value_expression )? (cyc= CYCLE )? ( CACHE c= int_literal_or_bind )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_sequence_node2204); if (state.failed) return ret;
			match(input,SEQUENCE,FOLLOW_SEQUENCE_in_create_sequence_node2206); if (state.failed) return ret;
			// PhoenixSQL.g:484:26: ( IF NOT ex= EXISTS )?
			int alt22=2;
			int LA22_0 = input.LA(1);
			if ( (LA22_0==IF) ) {
				alt22=1;
			}
			switch (alt22) {
				case 1 :
					// PhoenixSQL.g:484:27: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_sequence_node2210); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_sequence_node2212); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_sequence_node2216); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_create_sequence_node2222);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:485:9: ( START ( WITH )? s= value_expression )?
			int alt24=2;
			int LA24_0 = input.LA(1);
			if ( (LA24_0==START) ) {
				alt24=1;
			}
			switch (alt24) {
				case 1 :
					// PhoenixSQL.g:485:10: START ( WITH )? s= value_expression
					{
					match(input,START,FOLLOW_START_in_create_sequence_node2233); if (state.failed) return ret;
					// PhoenixSQL.g:485:16: ( WITH )?
					int alt23=2;
					int LA23_0 = input.LA(1);
					if ( (LA23_0==WITH) ) {
						alt23=1;
					}
					switch (alt23) {
						case 1 :
							// PhoenixSQL.g:485:16: WITH
							{
							match(input,WITH,FOLLOW_WITH_in_create_sequence_node2235); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_value_expression_in_create_sequence_node2240);
					s=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:486:9: ( INCREMENT ( BY )? i= value_expression )?
			int alt26=2;
			int LA26_0 = input.LA(1);
			if ( (LA26_0==INCREMENT) ) {
				alt26=1;
			}
			switch (alt26) {
				case 1 :
					// PhoenixSQL.g:486:10: INCREMENT ( BY )? i= value_expression
					{
					match(input,INCREMENT,FOLLOW_INCREMENT_in_create_sequence_node2253); if (state.failed) return ret;
					// PhoenixSQL.g:486:20: ( BY )?
					int alt25=2;
					int LA25_0 = input.LA(1);
					if ( (LA25_0==BY) ) {
						alt25=1;
					}
					switch (alt25) {
						case 1 :
							// PhoenixSQL.g:486:20: BY
							{
							match(input,BY,FOLLOW_BY_in_create_sequence_node2255); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_value_expression_in_create_sequence_node2260);
					i=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:487:9: ( MINVALUE min= value_expression )?
			int alt27=2;
			int LA27_0 = input.LA(1);
			if ( (LA27_0==MINVALUE) ) {
				alt27=1;
			}
			switch (alt27) {
				case 1 :
					// PhoenixSQL.g:487:10: MINVALUE min= value_expression
					{
					match(input,MINVALUE,FOLLOW_MINVALUE_in_create_sequence_node2273); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_create_sequence_node2277);
					min=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:488:9: ( MAXVALUE max= value_expression )?
			int alt28=2;
			int LA28_0 = input.LA(1);
			if ( (LA28_0==MAXVALUE) ) {
				alt28=1;
			}
			switch (alt28) {
				case 1 :
					// PhoenixSQL.g:488:10: MAXVALUE max= value_expression
					{
					match(input,MAXVALUE,FOLLOW_MAXVALUE_in_create_sequence_node2290); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_create_sequence_node2294);
					max=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:489:9: (cyc= CYCLE )?
			int alt29=2;
			int LA29_0 = input.LA(1);
			if ( (LA29_0==CYCLE) ) {
				alt29=1;
			}
			switch (alt29) {
				case 1 :
					// PhoenixSQL.g:489:10: cyc= CYCLE
					{
					cyc=(Token)match(input,CYCLE,FOLLOW_CYCLE_in_create_sequence_node2309); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:490:9: ( CACHE c= int_literal_or_bind )?
			int alt30=2;
			int LA30_0 = input.LA(1);
			if ( (LA30_0==CACHE) ) {
				alt30=1;
			}
			switch (alt30) {
				case 1 :
					// PhoenixSQL.g:490:10: CACHE c= int_literal_or_bind
					{
					match(input,CACHE,FOLLOW_CACHE_in_create_sequence_node2323); if (state.failed) return ret;
					pushFollow(FOLLOW_int_literal_or_bind_in_create_sequence_node2327);
					c=int_literal_or_bind();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.createSequence(t, s, i, c, min, max, cyc!=null, ex!=null, getBindCount()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_sequence_node"



	// $ANTLR start "int_literal_or_bind"
	// PhoenixSQL.g:494:1: int_literal_or_bind returns [ParseNode ret] : (n= int_or_long_literal |b= bind_expression );
	public final ParseNode int_literal_or_bind() throws RecognitionException {
		ParseNode ret = null;


		LiteralParseNode n =null;
		BindParseNode b =null;

		try {
			// PhoenixSQL.g:495:5: (n= int_or_long_literal |b= bind_expression )
			int alt31=2;
			int LA31_0 = input.LA(1);
			if ( (LA31_0==NUMBER) ) {
				alt31=1;
			}
			else if ( (LA31_0==BIND_NAME||LA31_0==QUESTION) ) {
				alt31=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 31, 0, input);
				throw nvae;
			}

			switch (alt31) {
				case 1 :
					// PhoenixSQL.g:495:7: n= int_or_long_literal
					{
					pushFollow(FOLLOW_int_or_long_literal_in_int_literal_or_bind2358);
					n=int_or_long_literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = n; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:496:7: b= bind_expression
					{
					pushFollow(FOLLOW_bind_expression_in_int_literal_or_bind2370);
					b=bind_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = b; }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "int_literal_or_bind"



	// $ANTLR start "drop_sequence_node"
	// PhoenixSQL.g:500:1: drop_sequence_node returns [DropSequenceStatement ret] : DROP SEQUENCE ( IF ex= EXISTS )? t= from_table_name ;
	public final DropSequenceStatement drop_sequence_node() throws RecognitionException {
		DropSequenceStatement ret = null;


		Token ex=null;
		TableName t =null;

		try {
			// PhoenixSQL.g:501:5: ( DROP SEQUENCE ( IF ex= EXISTS )? t= from_table_name )
			// PhoenixSQL.g:501:9: DROP SEQUENCE ( IF ex= EXISTS )? t= from_table_name
			{
			match(input,DROP,FOLLOW_DROP_in_drop_sequence_node2396); if (state.failed) return ret;
			match(input,SEQUENCE,FOLLOW_SEQUENCE_in_drop_sequence_node2398); if (state.failed) return ret;
			// PhoenixSQL.g:501:24: ( IF ex= EXISTS )?
			int alt32=2;
			int LA32_0 = input.LA(1);
			if ( (LA32_0==IF) ) {
				alt32=1;
			}
			switch (alt32) {
				case 1 :
					// PhoenixSQL.g:501:25: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_sequence_node2402); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_sequence_node2406); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_drop_sequence_node2412);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.dropSequence(t, ex!=null, getBindCount()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_sequence_node"



	// $ANTLR start "pk_constraint"
	// PhoenixSQL.g:505:1: pk_constraint returns [PrimaryKeyConstraint ret] : ( COMMA )? CONSTRAINT n= identifier PRIMARY KEY LPAREN cols= col_name_with_sort_order_rowtimestamp_list RPAREN ;
	public final PrimaryKeyConstraint pk_constraint() throws RecognitionException {
		PrimaryKeyConstraint ret = null;


		String n =null;
		List<ColumnDefInPkConstraint> cols =null;

		try {
			// PhoenixSQL.g:506:5: ( ( COMMA )? CONSTRAINT n= identifier PRIMARY KEY LPAREN cols= col_name_with_sort_order_rowtimestamp_list RPAREN )
			// PhoenixSQL.g:506:9: ( COMMA )? CONSTRAINT n= identifier PRIMARY KEY LPAREN cols= col_name_with_sort_order_rowtimestamp_list RPAREN
			{
			// PhoenixSQL.g:506:9: ( COMMA )?
			int alt33=2;
			int LA33_0 = input.LA(1);
			if ( (LA33_0==COMMA) ) {
				alt33=1;
			}
			switch (alt33) {
				case 1 :
					// PhoenixSQL.g:506:9: COMMA
					{
					match(input,COMMA,FOLLOW_COMMA_in_pk_constraint2441); if (state.failed) return ret;
					}
					break;

			}

			match(input,CONSTRAINT,FOLLOW_CONSTRAINT_in_pk_constraint2444); if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_pk_constraint2448);
			n=identifier();
			state._fsp--;
			if (state.failed) return ret;
			match(input,PRIMARY,FOLLOW_PRIMARY_in_pk_constraint2450); if (state.failed) return ret;
			match(input,KEY,FOLLOW_KEY_in_pk_constraint2452); if (state.failed) return ret;
			match(input,LPAREN,FOLLOW_LPAREN_in_pk_constraint2454); if (state.failed) return ret;
			pushFollow(FOLLOW_col_name_with_sort_order_rowtimestamp_list_in_pk_constraint2458);
			cols=col_name_with_sort_order_rowtimestamp_list();
			state._fsp--;
			if (state.failed) return ret;
			match(input,RPAREN,FOLLOW_RPAREN_in_pk_constraint2460); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.primaryKey(n,cols); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "pk_constraint"



	// $ANTLR start "col_name_with_sort_order_rowtimestamp_list"
	// PhoenixSQL.g:509:1: col_name_with_sort_order_rowtimestamp_list returns [List<ColumnDefInPkConstraint> ret] : p= col_name_with_sort_order_rowtimestamp ( COMMA p= col_name_with_sort_order_rowtimestamp )* ;
	public final List<ColumnDefInPkConstraint> col_name_with_sort_order_rowtimestamp_list() throws RecognitionException {
		List<ColumnDefInPkConstraint> ret = null;


		ColumnDefInPkConstraint p =null;

		ret = new ArrayList<ColumnDefInPkConstraint>(); 
		try {
			// PhoenixSQL.g:511:5: (p= col_name_with_sort_order_rowtimestamp ( COMMA p= col_name_with_sort_order_rowtimestamp )* )
			// PhoenixSQL.g:511:9: p= col_name_with_sort_order_rowtimestamp ( COMMA p= col_name_with_sort_order_rowtimestamp )*
			{
			pushFollow(FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list2491);
			p=col_name_with_sort_order_rowtimestamp();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(p);}
			// PhoenixSQL.g:511:65: ( COMMA p= col_name_with_sort_order_rowtimestamp )*
			loop34:
			while (true) {
				int alt34=2;
				int LA34_0 = input.LA(1);
				if ( (LA34_0==COMMA) ) {
					alt34=1;
				}

				switch (alt34) {
				case 1 :
					// PhoenixSQL.g:511:66: COMMA p= col_name_with_sort_order_rowtimestamp
					{
					match(input,COMMA,FOLLOW_COMMA_in_col_name_with_sort_order_rowtimestamp_list2497); if (state.failed) return ret;
					pushFollow(FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list2503);
					p=col_name_with_sort_order_rowtimestamp();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(p);}
					}
					break;

				default :
					break loop34;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "col_name_with_sort_order_rowtimestamp_list"



	// $ANTLR start "col_name_with_sort_order_rowtimestamp"
	// PhoenixSQL.g:514:1: col_name_with_sort_order_rowtimestamp returns [ColumnDefInPkConstraint ret] : f= identifier (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? ;
	public final ColumnDefInPkConstraint col_name_with_sort_order_rowtimestamp() throws RecognitionException {
		ColumnDefInPkConstraint ret = null;


		Token order=null;
		Token rr=null;
		String f =null;

		try {
			// PhoenixSQL.g:515:5: (f= identifier (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )
			// PhoenixSQL.g:515:9: f= identifier (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )?
			{
			pushFollow(FOLLOW_identifier_in_col_name_with_sort_order_rowtimestamp2530);
			f=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:515:22: (order= ASC |order= DESC )?
			int alt35=3;
			int LA35_0 = input.LA(1);
			if ( (LA35_0==ASC) ) {
				alt35=1;
			}
			else if ( (LA35_0==DESC) ) {
				alt35=2;
			}
			switch (alt35) {
				case 1 :
					// PhoenixSQL.g:515:23: order= ASC
					{
					order=(Token)match(input,ASC,FOLLOW_ASC_in_col_name_with_sort_order_rowtimestamp2535); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:515:33: order= DESC
					{
					order=(Token)match(input,DESC,FOLLOW_DESC_in_col_name_with_sort_order_rowtimestamp2539); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:515:46: (rr= ROW_TIMESTAMP )?
			int alt36=2;
			int LA36_0 = input.LA(1);
			if ( (LA36_0==ROW_TIMESTAMP) ) {
				alt36=1;
			}
			switch (alt36) {
				case 1 :
					// PhoenixSQL.g:515:47: rr= ROW_TIMESTAMP
					{
					rr=(Token)match(input,ROW_TIMESTAMP,FOLLOW_ROW_TIMESTAMP_in_col_name_with_sort_order_rowtimestamp2546); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.columnDefInPkConstraint(factory.columnName(f), order == null ? SortOrder.getDefault() : SortOrder.fromDDLValue(order.getText()), rr != null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "col_name_with_sort_order_rowtimestamp"



	// $ANTLR start "ik_constraint"
	// PhoenixSQL.g:519:1: ik_constraint returns [IndexKeyConstraint ret] : x= expression_with_sort_order_list ;
	public final IndexKeyConstraint ik_constraint() throws RecognitionException {
		IndexKeyConstraint ret = null;


		List<Pair<ParseNode, SortOrder>> x =null;

		try {
			// PhoenixSQL.g:520:5: (x= expression_with_sort_order_list )
			// PhoenixSQL.g:520:9: x= expression_with_sort_order_list
			{
			pushFollow(FOLLOW_expression_with_sort_order_list_in_ik_constraint2581);
			x=expression_with_sort_order_list();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.indexKey(x); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "ik_constraint"



	// $ANTLR start "expression_with_sort_order_list"
	// PhoenixSQL.g:523:1: expression_with_sort_order_list returns [List<Pair<ParseNode, SortOrder>> ret] : p= expression_with_sort_order ( COMMA p= expression_with_sort_order )* ;
	public final List<Pair<ParseNode, SortOrder>> expression_with_sort_order_list() throws RecognitionException {
		List<Pair<ParseNode, SortOrder>> ret = null;


		Pair<ParseNode, SortOrder> p =null;

		ret = new ArrayList<Pair<ParseNode, SortOrder>>(); 
		try {
			// PhoenixSQL.g:525:5: (p= expression_with_sort_order ( COMMA p= expression_with_sort_order )* )
			// PhoenixSQL.g:525:9: p= expression_with_sort_order ( COMMA p= expression_with_sort_order )*
			{
			pushFollow(FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list2608);
			p=expression_with_sort_order();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(p);}
			// PhoenixSQL.g:525:54: ( COMMA p= expression_with_sort_order )*
			loop37:
			while (true) {
				int alt37=2;
				int LA37_0 = input.LA(1);
				if ( (LA37_0==COMMA) ) {
					alt37=1;
				}

				switch (alt37) {
				case 1 :
					// PhoenixSQL.g:525:55: COMMA p= expression_with_sort_order
					{
					match(input,COMMA,FOLLOW_COMMA_in_expression_with_sort_order_list2614); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list2620);
					p=expression_with_sort_order();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(p);}
					}
					break;

				default :
					break loop37;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "expression_with_sort_order_list"



	// $ANTLR start "expression_with_sort_order"
	// PhoenixSQL.g:528:1: expression_with_sort_order returns [Pair<ParseNode, SortOrder> ret] : (x= expression ) (order= ASC |order= DESC )? ;
	public final Pair<ParseNode, SortOrder> expression_with_sort_order() throws RecognitionException {
		Pair<ParseNode, SortOrder> ret = null;


		Token order=null;
		ParseNode x =null;

		try {
			// PhoenixSQL.g:529:5: ( (x= expression ) (order= ASC |order= DESC )? )
			// PhoenixSQL.g:529:9: (x= expression ) (order= ASC |order= DESC )?
			{
			// PhoenixSQL.g:529:9: (x= expression )
			// PhoenixSQL.g:529:10: x= expression
			{
			pushFollow(FOLLOW_expression_in_expression_with_sort_order2647);
			x=expression();
			state._fsp--;
			if (state.failed) return ret;
			}

			// PhoenixSQL.g:529:24: (order= ASC |order= DESC )?
			int alt38=3;
			int LA38_0 = input.LA(1);
			if ( (LA38_0==ASC) ) {
				alt38=1;
			}
			else if ( (LA38_0==DESC) ) {
				alt38=2;
			}
			switch (alt38) {
				case 1 :
					// PhoenixSQL.g:529:25: order= ASC
					{
					order=(Token)match(input,ASC,FOLLOW_ASC_in_expression_with_sort_order2653); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:529:35: order= DESC
					{
					order=(Token)match(input,DESC,FOLLOW_DESC_in_expression_with_sort_order2657); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = Pair.newPair(x, order == null ? SortOrder.getDefault() : SortOrder.fromDDLValue(order.getText()));}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "expression_with_sort_order"



	// $ANTLR start "fam_properties"
	// PhoenixSQL.g:532:1: fam_properties returns [ListMultimap<String,Pair<String,Object>> ret] : p= fam_prop_name EQ v= prop_value ( COMMA p= fam_prop_name EQ v= prop_value )* ;
	public final ListMultimap<String,Pair<String,Object>> fam_properties() throws RecognitionException {
		ListMultimap<String,Pair<String,Object>> ret = null;


		PropertyName p =null;
		Object v =null;

		ret = ArrayListMultimap.<String,Pair<String,Object>>create(); 
		try {
			// PhoenixSQL.g:534:5: (p= fam_prop_name EQ v= prop_value ( COMMA p= fam_prop_name EQ v= prop_value )* )
			// PhoenixSQL.g:534:8: p= fam_prop_name EQ v= prop_value ( COMMA p= fam_prop_name EQ v= prop_value )*
			{
			pushFollow(FOLLOW_fam_prop_name_in_fam_properties2685);
			p=fam_prop_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EQ,FOLLOW_EQ_in_fam_properties2687); if (state.failed) return ret;
			pushFollow(FOLLOW_prop_value_in_fam_properties2691);
			v=prop_value();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.put(p.getFamilyName(),new Pair<String,Object>(p.getPropertyName(),v));}
			// PhoenixSQL.g:534:119: ( COMMA p= fam_prop_name EQ v= prop_value )*
			loop39:
			while (true) {
				int alt39=2;
				int LA39_0 = input.LA(1);
				if ( (LA39_0==COMMA) ) {
					alt39=1;
				}

				switch (alt39) {
				case 1 :
					// PhoenixSQL.g:534:120: COMMA p= fam_prop_name EQ v= prop_value
					{
					match(input,COMMA,FOLLOW_COMMA_in_fam_properties2697); if (state.failed) return ret;
					pushFollow(FOLLOW_fam_prop_name_in_fam_properties2701);
					p=fam_prop_name();
					state._fsp--;
					if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_fam_properties2703); if (state.failed) return ret;
					pushFollow(FOLLOW_prop_value_in_fam_properties2707);
					v=prop_value();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.put(p.getFamilyName(),new Pair<String,Object>(p.getPropertyName(),v));}
					}
					break;

				default :
					break loop39;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "fam_properties"



	// $ANTLR start "fam_prop_name"
	// PhoenixSQL.g:537:1: fam_prop_name returns [PropertyName ret] : (propName= identifier |familyName= identifier DOT propName= identifier );
	public final PropertyName fam_prop_name() throws RecognitionException {
		PropertyName ret = null;


		String propName =null;
		String familyName =null;

		try {
			// PhoenixSQL.g:538:5: (propName= identifier |familyName= identifier DOT propName= identifier )
			int alt40=2;
			int LA40_0 = input.LA(1);
			if ( (LA40_0==NAME) ) {
				int LA40_1 = input.LA(2);
				if ( (LA40_1==EQ) ) {
					alt40=1;
				}
				else if ( (LA40_1==DOT) ) {
					alt40=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 40, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 40, 0, input);
				throw nvae;
			}

			switch (alt40) {
				case 1 :
					// PhoenixSQL.g:538:9: propName= identifier
					{
					pushFollow(FOLLOW_identifier_in_fam_prop_name2737);
					propName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.propertyName(propName); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:539:9: familyName= identifier DOT propName= identifier
					{
					pushFollow(FOLLOW_identifier_in_fam_prop_name2751);
					familyName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_fam_prop_name2753); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_fam_prop_name2757);
					propName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.propertyName(familyName, propName); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "fam_prop_name"



	// $ANTLR start "prop_value"
	// PhoenixSQL.g:542:1: prop_value returns [Object ret] : (v= identifier |l= literal );
	public final Object prop_value() throws RecognitionException {
		Object ret = null;


		String v =null;
		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:543:5: (v= identifier |l= literal )
			int alt41=2;
			int LA41_0 = input.LA(1);
			if ( (LA41_0==NAME) ) {
				int LA41_1 = input.LA(2);
				if ( (LA41_1==EOF||LA41_1==COMMA||LA41_1==SEMICOLON||LA41_1==SPLIT) ) {
					alt41=1;
				}
				else if ( (LA41_1==STRING_LITERAL) ) {
					alt41=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 41, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( (LA41_0==DECIMAL||LA41_0==DOUBLE||LA41_0==FALSE||LA41_0==NULL||LA41_0==NUMBER||LA41_0==STRING_LITERAL||LA41_0==TRUE) ) {
				alt41=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 41, 0, input);
				throw nvae;
			}

			switch (alt41) {
				case 1 :
					// PhoenixSQL.g:543:9: v= identifier
					{
					pushFollow(FOLLOW_identifier_in_prop_value2788);
					v=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = v; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:544:9: l= literal
					{
					pushFollow(FOLLOW_literal_in_prop_value2802);
					l=literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = l.getValue(); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "prop_value"



	// $ANTLR start "column_name"
	// PhoenixSQL.g:547:1: column_name returns [ColumnName ret] : (field= identifier |family= identifier DOT field= identifier );
	public final ColumnName column_name() throws RecognitionException {
		ColumnName ret = null;


		String field =null;
		String family =null;

		try {
			// PhoenixSQL.g:548:5: (field= identifier |family= identifier DOT field= identifier )
			int alt42=2;
			int LA42_0 = input.LA(1);
			if ( (LA42_0==NAME) ) {
				int LA42_1 = input.LA(2);
				if ( (LA42_1==EOF||LA42_1==COMMA||LA42_1==EQ||LA42_1==NAME||LA42_1==RPAREN||LA42_1==SEMICOLON) ) {
					alt42=1;
				}
				else if ( (LA42_1==DOT) ) {
					alt42=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 42, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 42, 0, input);
				throw nvae;
			}

			switch (alt42) {
				case 1 :
					// PhoenixSQL.g:548:9: field= identifier
					{
					pushFollow(FOLLOW_identifier_in_column_name2833);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.columnName(field); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:549:9: family= identifier DOT field= identifier
					{
					pushFollow(FOLLOW_identifier_in_column_name2847);
					family=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_column_name2849); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_column_name2853);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.columnName(family, field); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_name"



	// $ANTLR start "column_names"
	// PhoenixSQL.g:552:1: column_names returns [List<ColumnName> ret] : v= column_name ( COMMA v= column_name )* ;
	public final List<ColumnName> column_names() throws RecognitionException {
		List<ColumnName> ret = null;


		ColumnName v =null;

		ret = new ArrayList<ColumnName>(); 
		try {
			// PhoenixSQL.g:554:5: (v= column_name ( COMMA v= column_name )* )
			// PhoenixSQL.g:554:8: v= column_name ( COMMA v= column_name )*
			{
			pushFollow(FOLLOW_column_name_in_column_names2885);
			v=column_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(v);}
			// PhoenixSQL.g:554:40: ( COMMA v= column_name )*
			loop43:
			while (true) {
				int alt43=2;
				int LA43_0 = input.LA(1);
				if ( (LA43_0==COMMA) ) {
					alt43=1;
				}

				switch (alt43) {
				case 1 :
					// PhoenixSQL.g:554:41: COMMA v= column_name
					{
					match(input,COMMA,FOLLOW_COMMA_in_column_names2891); if (state.failed) return ret;
					pushFollow(FOLLOW_column_name_in_column_names2897);
					v=column_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop43;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_names"



	// $ANTLR start "drop_table_node"
	// PhoenixSQL.g:559:1: drop_table_node returns [DropTableStatement ret] : DROP (v= VIEW | TABLE ) ( IF ex= EXISTS )? t= from_table_name (c= CASCADE )? ;
	public final DropTableStatement drop_table_node() throws RecognitionException {
		DropTableStatement ret = null;


		Token v=null;
		Token ex=null;
		Token c=null;
		TableName t =null;

		try {
			// PhoenixSQL.g:560:5: ( DROP (v= VIEW | TABLE ) ( IF ex= EXISTS )? t= from_table_name (c= CASCADE )? )
			// PhoenixSQL.g:560:9: DROP (v= VIEW | TABLE ) ( IF ex= EXISTS )? t= from_table_name (c= CASCADE )?
			{
			match(input,DROP,FOLLOW_DROP_in_drop_table_node2924); if (state.failed) return ret;
			// PhoenixSQL.g:560:14: (v= VIEW | TABLE )
			int alt44=2;
			int LA44_0 = input.LA(1);
			if ( (LA44_0==VIEW) ) {
				alt44=1;
			}
			else if ( (LA44_0==TABLE) ) {
				alt44=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 44, 0, input);
				throw nvae;
			}

			switch (alt44) {
				case 1 :
					// PhoenixSQL.g:560:15: v= VIEW
					{
					v=(Token)match(input,VIEW,FOLLOW_VIEW_in_drop_table_node2929); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:560:24: TABLE
					{
					match(input,TABLE,FOLLOW_TABLE_in_drop_table_node2933); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:560:31: ( IF ex= EXISTS )?
			int alt45=2;
			int LA45_0 = input.LA(1);
			if ( (LA45_0==IF) ) {
				alt45=1;
			}
			switch (alt45) {
				case 1 :
					// PhoenixSQL.g:560:32: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_table_node2937); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_table_node2941); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_drop_table_node2947);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:560:65: (c= CASCADE )?
			int alt46=2;
			int LA46_0 = input.LA(1);
			if ( (LA46_0==CASCADE) ) {
				alt46=1;
			}
			switch (alt46) {
				case 1 :
					// PhoenixSQL.g:560:66: c= CASCADE
					{
					c=(Token)match(input,CASCADE,FOLLOW_CASCADE_in_drop_table_node2952); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.dropTable(t, v==null ? (QueryConstants.SYSTEM_SCHEMA_NAME.equals(t.getSchemaName()) ? PTableType.SYSTEM : PTableType.TABLE) : PTableType.VIEW, ex!=null, c!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_table_node"



	// $ANTLR start "drop_schema_node"
	// PhoenixSQL.g:564:1: drop_schema_node returns [DropSchemaStatement ret] : DROP SCHEMA ( IF ex= EXISTS )? s= identifier (c= CASCADE )? ;
	public final DropSchemaStatement drop_schema_node() throws RecognitionException {
		DropSchemaStatement ret = null;


		Token ex=null;
		Token c=null;
		String s =null;

		try {
			// PhoenixSQL.g:565:5: ( DROP SCHEMA ( IF ex= EXISTS )? s= identifier (c= CASCADE )? )
			// PhoenixSQL.g:565:9: DROP SCHEMA ( IF ex= EXISTS )? s= identifier (c= CASCADE )?
			{
			match(input,DROP,FOLLOW_DROP_in_drop_schema_node2987); if (state.failed) return ret;
			match(input,SCHEMA,FOLLOW_SCHEMA_in_drop_schema_node2989); if (state.failed) return ret;
			// PhoenixSQL.g:565:21: ( IF ex= EXISTS )?
			int alt47=2;
			int LA47_0 = input.LA(1);
			if ( (LA47_0==IF) ) {
				alt47=1;
			}
			switch (alt47) {
				case 1 :
					// PhoenixSQL.g:565:22: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_schema_node2992); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_schema_node2996); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_identifier_in_drop_schema_node3002);
			s=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:565:50: (c= CASCADE )?
			int alt48=2;
			int LA48_0 = input.LA(1);
			if ( (LA48_0==CASCADE) ) {
				alt48=1;
			}
			switch (alt48) {
				case 1 :
					// PhoenixSQL.g:565:51: c= CASCADE
					{
					c=(Token)match(input,CASCADE,FOLLOW_CASCADE_in_drop_schema_node3007); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.dropSchema(s, ex!=null, c!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_schema_node"



	// $ANTLR start "drop_index_node"
	// PhoenixSQL.g:571:1: drop_index_node returns [DropIndexStatement ret] : DROP INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name ;
	public final DropIndexStatement drop_index_node() throws RecognitionException {
		DropIndexStatement ret = null;


		Token ex=null;
		NamedNode i =null;
		TableName t =null;

		try {
			// PhoenixSQL.g:572:5: ( DROP INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name )
			// PhoenixSQL.g:572:7: DROP INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name
			{
			match(input,DROP,FOLLOW_DROP_in_drop_index_node3042); if (state.failed) return ret;
			match(input,INDEX,FOLLOW_INDEX_in_drop_index_node3044); if (state.failed) return ret;
			// PhoenixSQL.g:572:18: ( IF ex= EXISTS )?
			int alt49=2;
			int LA49_0 = input.LA(1);
			if ( (LA49_0==IF) ) {
				alt49=1;
			}
			switch (alt49) {
				case 1 :
					// PhoenixSQL.g:572:19: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_index_node3047); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_index_node3051); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_index_name_in_drop_index_node3057);
			i=index_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,ON,FOLLOW_ON_in_drop_index_node3059); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_drop_index_node3063);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.dropIndex(i, t, ex!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_index_node"



	// $ANTLR start "alter_index_node"
	// PhoenixSQL.g:577:1: alter_index_node returns [AlterIndexStatement ret] : ALTER INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name s= ( USABLE | UNUSABLE | REBUILD | DISABLE | ACTIVE ) (async= ASYNC )? ;
	public final AlterIndexStatement alter_index_node() throws RecognitionException {
		AlterIndexStatement ret = null;


		Token ex=null;
		Token s=null;
		Token async=null;
		NamedNode i =null;
		TableName t =null;

		try {
			// PhoenixSQL.g:578:5: ( ALTER INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name s= ( USABLE | UNUSABLE | REBUILD | DISABLE | ACTIVE ) (async= ASYNC )? )
			// PhoenixSQL.g:578:7: ALTER INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name s= ( USABLE | UNUSABLE | REBUILD | DISABLE | ACTIVE ) (async= ASYNC )?
			{
			match(input,ALTER,FOLLOW_ALTER_in_alter_index_node3093); if (state.failed) return ret;
			match(input,INDEX,FOLLOW_INDEX_in_alter_index_node3095); if (state.failed) return ret;
			// PhoenixSQL.g:578:19: ( IF ex= EXISTS )?
			int alt50=2;
			int LA50_0 = input.LA(1);
			if ( (LA50_0==IF) ) {
				alt50=1;
			}
			switch (alt50) {
				case 1 :
					// PhoenixSQL.g:578:20: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_alter_index_node3098); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_alter_index_node3102); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_index_name_in_alter_index_node3108);
			i=index_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,ON,FOLLOW_ON_in_alter_index_node3110); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_alter_index_node3114);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			s=input.LT(1);
			if ( input.LA(1)==ACTIVE||input.LA(1)==DISABLE||input.LA(1)==REBUILD||input.LA(1)==UNUSABLE||input.LA(1)==USABLE ) {
				input.consume();
				state.errorRecovery=false;
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			// PhoenixSQL.g:578:120: (async= ASYNC )?
			int alt51=2;
			int LA51_0 = input.LA(1);
			if ( (LA51_0==ASYNC) ) {
				alt51=1;
			}
			switch (alt51) {
				case 1 :
					// PhoenixSQL.g:578:121: async= ASYNC
					{
					async=(Token)match(input,ASYNC,FOLLOW_ASYNC_in_alter_index_node3141); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.alterIndex(factory.namedTable(null, TableName.create(t.getSchemaName(), i.getName())), t.getTableName(), ex!=null, PIndexState.valueOf(SchemaUtil.normalizeIdentifier(s.getText())), async!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "alter_index_node"



	// $ANTLR start "trace_node"
	// PhoenixSQL.g:583:1: trace_node returns [TraceStatement ret] : TRACE ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF ) ;
	public final TraceStatement trace_node() throws RecognitionException {
		TraceStatement ret = null;


		Token flag=null;
		LiteralParseNode s =null;

		try {
			// PhoenixSQL.g:584:5: ( TRACE ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF ) )
			// PhoenixSQL.g:584:9: TRACE ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF )
			{
			match(input,TRACE,FOLLOW_TRACE_in_trace_node3175); if (state.failed) return ret;
			// PhoenixSQL.g:584:15: ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF )
			int alt53=2;
			int LA53_0 = input.LA(1);
			if ( (LA53_0==ON) ) {
				alt53=1;
			}
			else if ( (LA53_0==OFF) ) {
				alt53=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 53, 0, input);
				throw nvae;
			}

			switch (alt53) {
				case 1 :
					// PhoenixSQL.g:584:16: (flag= ON ( WITH SAMPLING s= sampling_rate )? )
					{
					// PhoenixSQL.g:584:16: (flag= ON ( WITH SAMPLING s= sampling_rate )? )
					// PhoenixSQL.g:584:17: flag= ON ( WITH SAMPLING s= sampling_rate )?
					{
					flag=(Token)match(input,ON,FOLLOW_ON_in_trace_node3183); if (state.failed) return ret;
					// PhoenixSQL.g:584:28: ( WITH SAMPLING s= sampling_rate )?
					int alt52=2;
					int LA52_0 = input.LA(1);
					if ( (LA52_0==WITH) ) {
						alt52=1;
					}
					switch (alt52) {
						case 1 :
							// PhoenixSQL.g:584:30: WITH SAMPLING s= sampling_rate
							{
							match(input,WITH,FOLLOW_WITH_in_trace_node3188); if (state.failed) return ret;
							match(input,SAMPLING,FOLLOW_SAMPLING_in_trace_node3190); if (state.failed) return ret;
							pushFollow(FOLLOW_sampling_rate_in_trace_node3196);
							s=sampling_rate();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:584:67: flag= OFF
					{
					flag=(Token)match(input,OFF,FOLLOW_OFF_in_trace_node3207); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.trace(Tracing.isTraceOn(flag.getText()), s == null ? Tracing.isTraceOn(flag.getText()) ? 1.0 : 0.0 : (((BigDecimal)s.getValue())).doubleValue());}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "trace_node"



	// $ANTLR start "create_function_node"
	// PhoenixSQL.g:589:1: create_function_node returns [CreateFunctionStatement ret] : CREATE ( OR replace= REPLACE )? (temp= TEMPORARY )? FUNCTION function= identifier ( LPAREN args= zero_or_more_data_types RPAREN ) RETURNS r= identifier AS (className= jar_path ) ( USING JAR (jarPath= jar_path ) )? ;
	public final CreateFunctionStatement create_function_node() throws RecognitionException {
		CreateFunctionStatement ret = null;


		Token replace=null;
		Token temp=null;
		String function =null;
		List<FunctionArgument> args =null;
		String r =null;
		LiteralParseNode className =null;
		LiteralParseNode jarPath =null;

		try {
			// PhoenixSQL.g:590:5: ( CREATE ( OR replace= REPLACE )? (temp= TEMPORARY )? FUNCTION function= identifier ( LPAREN args= zero_or_more_data_types RPAREN ) RETURNS r= identifier AS (className= jar_path ) ( USING JAR (jarPath= jar_path ) )? )
			// PhoenixSQL.g:590:9: CREATE ( OR replace= REPLACE )? (temp= TEMPORARY )? FUNCTION function= identifier ( LPAREN args= zero_or_more_data_types RPAREN ) RETURNS r= identifier AS (className= jar_path ) ( USING JAR (jarPath= jar_path ) )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_function_node3241); if (state.failed) return ret;
			// PhoenixSQL.g:590:16: ( OR replace= REPLACE )?
			int alt54=2;
			int LA54_0 = input.LA(1);
			if ( (LA54_0==OR) ) {
				alt54=1;
			}
			switch (alt54) {
				case 1 :
					// PhoenixSQL.g:590:17: OR replace= REPLACE
					{
					match(input,OR,FOLLOW_OR_in_create_function_node3244); if (state.failed) return ret;
					replace=(Token)match(input,REPLACE,FOLLOW_REPLACE_in_create_function_node3248); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:590:38: (temp= TEMPORARY )?
			int alt55=2;
			int LA55_0 = input.LA(1);
			if ( (LA55_0==TEMPORARY) ) {
				alt55=1;
			}
			switch (alt55) {
				case 1 :
					// PhoenixSQL.g:590:39: temp= TEMPORARY
					{
					temp=(Token)match(input,TEMPORARY,FOLLOW_TEMPORARY_in_create_function_node3255); if (state.failed) return ret;
					}
					break;

			}

			match(input,FUNCTION,FOLLOW_FUNCTION_in_create_function_node3259); if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_create_function_node3263);
			function=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:591:8: ( LPAREN args= zero_or_more_data_types RPAREN )
			// PhoenixSQL.g:591:9: LPAREN args= zero_or_more_data_types RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_create_function_node3274); if (state.failed) return ret;
			pushFollow(FOLLOW_zero_or_more_data_types_in_create_function_node3278);
			args=zero_or_more_data_types();
			state._fsp--;
			if (state.failed) return ret;
			match(input,RPAREN,FOLLOW_RPAREN_in_create_function_node3280); if (state.failed) return ret;
			}

			match(input,RETURNS,FOLLOW_RETURNS_in_create_function_node3290); if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_create_function_node3294);
			r=identifier();
			state._fsp--;
			if (state.failed) return ret;
			match(input,AS,FOLLOW_AS_in_create_function_node3296); if (state.failed) return ret;
			// PhoenixSQL.g:592:32: (className= jar_path )
			// PhoenixSQL.g:592:33: className= jar_path
			{
			pushFollow(FOLLOW_jar_path_in_create_function_node3302);
			className=jar_path();
			state._fsp--;
			if (state.failed) return ret;
			}

			// PhoenixSQL.g:593:8: ( USING JAR (jarPath= jar_path ) )?
			int alt56=2;
			int LA56_0 = input.LA(1);
			if ( (LA56_0==USING) ) {
				alt56=1;
			}
			switch (alt56) {
				case 1 :
					// PhoenixSQL.g:593:9: USING JAR (jarPath= jar_path )
					{
					match(input,USING,FOLLOW_USING_in_create_function_node3313); if (state.failed) return ret;
					match(input,JAR,FOLLOW_JAR_in_create_function_node3315); if (state.failed) return ret;
					// PhoenixSQL.g:593:19: (jarPath= jar_path )
					// PhoenixSQL.g:593:20: jarPath= jar_path
					{
					pushFollow(FOLLOW_jar_path_in_create_function_node3322);
					jarPath=jar_path();
					state._fsp--;
					if (state.failed) return ret;
					}

					}
					break;

			}

			if ( state.backtracking==0 ) {
			            ret = factory.createFunction(new PFunction(SchemaUtil.normalizeIdentifier(function), args,r,(String)className.getValue(), jarPath == null ? null : (String)jarPath.getValue()), temp!=null, replace!=null);
			        }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_function_node"



	// $ANTLR start "jar_path"
	// PhoenixSQL.g:599:1: jar_path returns [LiteralParseNode ret] : l= literal ;
	public final LiteralParseNode jar_path() throws RecognitionException {
		LiteralParseNode ret = null;


		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:600:5: (l= literal )
			// PhoenixSQL.g:600:7: l= literal
			{
			pushFollow(FOLLOW_literal_in_jar_path3359);
			l=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = l; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "jar_path"



	// $ANTLR start "drop_function_node"
	// PhoenixSQL.g:603:1: drop_function_node returns [DropFunctionStatement ret] : DROP FUNCTION ( IF ex= EXISTS )? function= identifier ;
	public final DropFunctionStatement drop_function_node() throws RecognitionException {
		DropFunctionStatement ret = null;


		Token ex=null;
		String function =null;

		try {
			// PhoenixSQL.g:604:5: ( DROP FUNCTION ( IF ex= EXISTS )? function= identifier )
			// PhoenixSQL.g:604:7: DROP FUNCTION ( IF ex= EXISTS )? function= identifier
			{
			match(input,DROP,FOLLOW_DROP_in_drop_function_node3382); if (state.failed) return ret;
			match(input,FUNCTION,FOLLOW_FUNCTION_in_drop_function_node3384); if (state.failed) return ret;
			// PhoenixSQL.g:604:21: ( IF ex= EXISTS )?
			int alt57=2;
			int LA57_0 = input.LA(1);
			if ( (LA57_0==IF) ) {
				alt57=1;
			}
			switch (alt57) {
				case 1 :
					// PhoenixSQL.g:604:22: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_function_node3387); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_function_node3391); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_identifier_in_drop_function_node3397);
			function=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.dropFunction(SchemaUtil.normalizeIdentifier(function), ex!=null);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_function_node"



	// $ANTLR start "add_jars_node"
	// PhoenixSQL.g:607:1: add_jars_node returns [AddJarsStatement ret] : ADD JARS jarPaths= one_or_more_jarpaths ;
	public final AddJarsStatement add_jars_node() throws RecognitionException {
		AddJarsStatement ret = null;


		List<LiteralParseNode> jarPaths =null;

		try {
			// PhoenixSQL.g:608:5: ( ADD JARS jarPaths= one_or_more_jarpaths )
			// PhoenixSQL.g:608:7: ADD JARS jarPaths= one_or_more_jarpaths
			{
			match(input,ADD,FOLLOW_ADD_in_add_jars_node3420); if (state.failed) return ret;
			match(input,JARS,FOLLOW_JARS_in_add_jars_node3422); if (state.failed) return ret;
			pushFollow(FOLLOW_one_or_more_jarpaths_in_add_jars_node3428);
			jarPaths=one_or_more_jarpaths();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.addJars(jarPaths);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "add_jars_node"



	// $ANTLR start "list_jars_node"
	// PhoenixSQL.g:611:1: list_jars_node returns [ListJarsStatement ret] : LIST JARS ;
	public final ListJarsStatement list_jars_node() throws RecognitionException {
		ListJarsStatement ret = null;


		try {
			// PhoenixSQL.g:612:5: ( LIST JARS )
			// PhoenixSQL.g:612:7: LIST JARS
			{
			match(input,LIST,FOLLOW_LIST_in_list_jars_node3451); if (state.failed) return ret;
			match(input,JARS,FOLLOW_JARS_in_list_jars_node3453); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.listJars();}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "list_jars_node"



	// $ANTLR start "delete_jar_node"
	// PhoenixSQL.g:615:1: delete_jar_node returns [DeleteJarStatement ret] : DELETE JAR jarPath= jar_path ;
	public final DeleteJarStatement delete_jar_node() throws RecognitionException {
		DeleteJarStatement ret = null;


		LiteralParseNode jarPath =null;

		try {
			// PhoenixSQL.g:616:5: ( DELETE JAR jarPath= jar_path )
			// PhoenixSQL.g:616:7: DELETE JAR jarPath= jar_path
			{
			match(input,DELETE,FOLLOW_DELETE_in_delete_jar_node3476); if (state.failed) return ret;
			match(input,JAR,FOLLOW_JAR_in_delete_jar_node3478); if (state.failed) return ret;
			pushFollow(FOLLOW_jar_path_in_delete_jar_node3484);
			jarPath=jar_path();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.deleteJar(jarPath);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "delete_jar_node"



	// $ANTLR start "alter_session_node"
	// PhoenixSQL.g:620:1: alter_session_node returns [AlterSessionStatement ret] : ALTER SESSION ( SET p= properties ) ;
	public final AlterSessionStatement alter_session_node() throws RecognitionException {
		AlterSessionStatement ret = null;


		Map<String,Object> p =null;

		try {
			// PhoenixSQL.g:621:5: ( ALTER SESSION ( SET p= properties ) )
			// PhoenixSQL.g:621:9: ALTER SESSION ( SET p= properties )
			{
			match(input,ALTER,FOLLOW_ALTER_in_alter_session_node3510); if (state.failed) return ret;
			match(input,SESSION,FOLLOW_SESSION_in_alter_session_node3512); if (state.failed) return ret;
			// PhoenixSQL.g:621:23: ( SET p= properties )
			// PhoenixSQL.g:621:24: SET p= properties
			{
			match(input,SET,FOLLOW_SET_in_alter_session_node3515); if (state.failed) return ret;
			pushFollow(FOLLOW_properties_in_alter_session_node3519);
			p=properties();
			state._fsp--;
			if (state.failed) return ret;
			}

			if ( state.backtracking==0 ) {ret = factory.alterSession(p);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "alter_session_node"



	// $ANTLR start "alter_table_node"
	// PhoenixSQL.g:626:1: alter_table_node returns [AlterTableStatement ret] : ALTER ( TABLE |v= VIEW ) t= from_table_name ( ( DROP COLUMN ( IF ex= EXISTS )? c= column_names ) | ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) | ( SET (p= fam_properties ) ) ) ;
	public final AlterTableStatement alter_table_node() throws RecognitionException {
		AlterTableStatement ret = null;


		Token v=null;
		Token ex=null;
		TableName t =null;
		List<ColumnName> c =null;
		List<ColumnDef> d =null;
		ListMultimap<String,Pair<String,Object>> p =null;

		try {
			// PhoenixSQL.g:627:5: ( ALTER ( TABLE |v= VIEW ) t= from_table_name ( ( DROP COLUMN ( IF ex= EXISTS )? c= column_names ) | ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) | ( SET (p= fam_properties ) ) ) )
			// PhoenixSQL.g:627:9: ALTER ( TABLE |v= VIEW ) t= from_table_name ( ( DROP COLUMN ( IF ex= EXISTS )? c= column_names ) | ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) | ( SET (p= fam_properties ) ) )
			{
			match(input,ALTER,FOLLOW_ALTER_in_alter_table_node3553); if (state.failed) return ret;
			// PhoenixSQL.g:627:15: ( TABLE |v= VIEW )
			int alt58=2;
			int LA58_0 = input.LA(1);
			if ( (LA58_0==TABLE) ) {
				alt58=1;
			}
			else if ( (LA58_0==VIEW) ) {
				alt58=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 58, 0, input);
				throw nvae;
			}

			switch (alt58) {
				case 1 :
					// PhoenixSQL.g:627:16: TABLE
					{
					match(input,TABLE,FOLLOW_TABLE_in_alter_table_node3556); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:627:24: v= VIEW
					{
					v=(Token)match(input,VIEW,FOLLOW_VIEW_in_alter_table_node3562); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_alter_table_node3567);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:628:9: ( ( DROP COLUMN ( IF ex= EXISTS )? c= column_names ) | ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) | ( SET (p= fam_properties ) ) )
			int alt62=3;
			switch ( input.LA(1) ) {
			case DROP:
				{
				alt62=1;
				}
				break;
			case ADD:
				{
				alt62=2;
				}
				break;
			case SET:
				{
				alt62=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 62, 0, input);
				throw nvae;
			}
			switch (alt62) {
				case 1 :
					// PhoenixSQL.g:628:11: ( DROP COLUMN ( IF ex= EXISTS )? c= column_names )
					{
					// PhoenixSQL.g:628:11: ( DROP COLUMN ( IF ex= EXISTS )? c= column_names )
					// PhoenixSQL.g:628:12: DROP COLUMN ( IF ex= EXISTS )? c= column_names
					{
					match(input,DROP,FOLLOW_DROP_in_alter_table_node3580); if (state.failed) return ret;
					match(input,COLUMN,FOLLOW_COLUMN_in_alter_table_node3582); if (state.failed) return ret;
					// PhoenixSQL.g:628:24: ( IF ex= EXISTS )?
					int alt59=2;
					int LA59_0 = input.LA(1);
					if ( (LA59_0==IF) ) {
						alt59=1;
					}
					switch (alt59) {
						case 1 :
							// PhoenixSQL.g:628:25: IF ex= EXISTS
							{
							match(input,IF,FOLLOW_IF_in_alter_table_node3585); if (state.failed) return ret;
							ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_alter_table_node3589); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_column_names_in_alter_table_node3595);
					c=column_names();
					state._fsp--;
					if (state.failed) return ret;
					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:628:58: ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? )
					{
					// PhoenixSQL.g:628:58: ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? )
					// PhoenixSQL.g:628:59: ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )?
					{
					match(input,ADD,FOLLOW_ADD_in_alter_table_node3601); if (state.failed) return ret;
					// PhoenixSQL.g:628:63: ( IF NOT ex= EXISTS )?
					int alt60=2;
					int LA60_0 = input.LA(1);
					if ( (LA60_0==IF) ) {
						alt60=1;
					}
					switch (alt60) {
						case 1 :
							// PhoenixSQL.g:628:64: IF NOT ex= EXISTS
							{
							match(input,IF,FOLLOW_IF_in_alter_table_node3604); if (state.failed) return ret;
							match(input,NOT,FOLLOW_NOT_in_alter_table_node3606); if (state.failed) return ret;
							ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_alter_table_node3610); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:628:83: (d= column_defs )
					// PhoenixSQL.g:628:84: d= column_defs
					{
					pushFollow(FOLLOW_column_defs_in_alter_table_node3617);
					d=column_defs();
					state._fsp--;
					if (state.failed) return ret;
					}

					// PhoenixSQL.g:628:99: (p= fam_properties )?
					int alt61=2;
					int LA61_0 = input.LA(1);
					if ( (LA61_0==NAME) ) {
						alt61=1;
					}
					switch (alt61) {
						case 1 :
							// PhoenixSQL.g:628:100: p= fam_properties
							{
							pushFollow(FOLLOW_fam_properties_in_alter_table_node3623);
							p=fam_properties();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}

					}
					break;
				case 3 :
					// PhoenixSQL.g:628:122: ( SET (p= fam_properties ) )
					{
					// PhoenixSQL.g:628:122: ( SET (p= fam_properties ) )
					// PhoenixSQL.g:628:123: SET (p= fam_properties )
					{
					match(input,SET,FOLLOW_SET_in_alter_table_node3631); if (state.failed) return ret;
					// PhoenixSQL.g:628:127: (p= fam_properties )
					// PhoenixSQL.g:628:128: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_alter_table_node3636);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}

					}

					}
					break;

			}

			if ( state.backtracking==0 ) { PTableType tt = v==null ? (QueryConstants.SYSTEM_SCHEMA_NAME.equals(t.getSchemaName()) ? PTableType.SYSTEM : PTableType.TABLE) : PTableType.VIEW; ret = ( c == null ? factory.addColumn(factory.namedTable(null,t), tt, d, ex!=null, p) : factory.dropColumn(factory.namedTable(null,t), tt, c, ex!=null) ); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "alter_table_node"



	// $ANTLR start "update_statistics_node"
	// PhoenixSQL.g:632:1: update_statistics_node returns [UpdateStatisticsStatement ret] : UPDATE STATISTICS t= from_table_name (s= INDEX |s= ALL |s= COLUMNS )? ( SET (p= properties ) )? ;
	public final UpdateStatisticsStatement update_statistics_node() throws RecognitionException {
		UpdateStatisticsStatement ret = null;


		Token s=null;
		TableName t =null;
		Map<String,Object> p =null;

		try {
			// PhoenixSQL.g:633:2: ( UPDATE STATISTICS t= from_table_name (s= INDEX |s= ALL |s= COLUMNS )? ( SET (p= properties ) )? )
			// PhoenixSQL.g:633:6: UPDATE STATISTICS t= from_table_name (s= INDEX |s= ALL |s= COLUMNS )? ( SET (p= properties ) )?
			{
			match(input,UPDATE,FOLLOW_UPDATE_in_update_statistics_node3670); if (state.failed) return ret;
			match(input,STATISTICS,FOLLOW_STATISTICS_in_update_statistics_node3672); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_update_statistics_node3676);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:633:42: (s= INDEX |s= ALL |s= COLUMNS )?
			int alt63=4;
			switch ( input.LA(1) ) {
				case INDEX:
					{
					alt63=1;
					}
					break;
				case ALL:
					{
					alt63=2;
					}
					break;
				case COLUMNS:
					{
					alt63=3;
					}
					break;
			}
			switch (alt63) {
				case 1 :
					// PhoenixSQL.g:633:43: s= INDEX
					{
					s=(Token)match(input,INDEX,FOLLOW_INDEX_in_update_statistics_node3681); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:633:53: s= ALL
					{
					s=(Token)match(input,ALL,FOLLOW_ALL_in_update_statistics_node3687); if (state.failed) return ret;
					}
					break;
				case 3 :
					// PhoenixSQL.g:633:61: s= COLUMNS
					{
					s=(Token)match(input,COLUMNS,FOLLOW_COLUMNS_in_update_statistics_node3693); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:633:73: ( SET (p= properties ) )?
			int alt64=2;
			int LA64_0 = input.LA(1);
			if ( (LA64_0==SET) ) {
				alt64=1;
			}
			switch (alt64) {
				case 1 :
					// PhoenixSQL.g:633:74: SET (p= properties )
					{
					match(input,SET,FOLLOW_SET_in_update_statistics_node3698); if (state.failed) return ret;
					// PhoenixSQL.g:633:78: (p= properties )
					// PhoenixSQL.g:633:79: p= properties
					{
					pushFollow(FOLLOW_properties_in_update_statistics_node3703);
					p=properties();
					state._fsp--;
					if (state.failed) return ret;
					}

					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.updateStatistics(factory.namedTable(null, t), s == null ? StatisticsCollectionScope.getDefault() : StatisticsCollectionScope.valueOf(SchemaUtil.normalizeIdentifier(s.getText())), p);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "update_statistics_node"



	// $ANTLR start "execute_upgrade_node"
	// PhoenixSQL.g:637:1: execute_upgrade_node returns [ExecuteUpgradeStatement ret] : EXECUTE UPGRADE ;
	public final ExecuteUpgradeStatement execute_upgrade_node() throws RecognitionException {
		ExecuteUpgradeStatement ret = null;


		try {
			// PhoenixSQL.g:638:2: ( EXECUTE UPGRADE )
			// PhoenixSQL.g:638:6: EXECUTE UPGRADE
			{
			match(input,EXECUTE,FOLLOW_EXECUTE_in_execute_upgrade_node3727); if (state.failed) return ret;
			match(input,UPGRADE,FOLLOW_UPGRADE_in_execute_upgrade_node3729); if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.executeUpgrade();}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "execute_upgrade_node"



	// $ANTLR start "prop_name"
	// PhoenixSQL.g:642:1: prop_name returns [String ret] : p= identifier ;
	public final String prop_name() throws RecognitionException {
		String ret = null;


		String p =null;

		try {
			// PhoenixSQL.g:643:5: (p= identifier )
			// PhoenixSQL.g:643:9: p= identifier
			{
			pushFollow(FOLLOW_identifier_in_prop_name3755);
			p=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = SchemaUtil.normalizeIdentifier(p); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "prop_name"



	// $ANTLR start "properties"
	// PhoenixSQL.g:646:1: properties returns [Map<String,Object> ret] : k= prop_name EQ v= prop_value ( COMMA k= prop_name EQ v= prop_value )* ;
	public final Map<String,Object> properties() throws RecognitionException {
		Map<String,Object> ret = null;


		String k =null;
		Object v =null;

		ret = new HashMap<String,Object>(); 
		try {
			// PhoenixSQL.g:648:5: (k= prop_name EQ v= prop_value ( COMMA k= prop_name EQ v= prop_value )* )
			// PhoenixSQL.g:648:8: k= prop_name EQ v= prop_value ( COMMA k= prop_name EQ v= prop_value )*
			{
			pushFollow(FOLLOW_prop_name_in_properties3789);
			k=prop_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EQ,FOLLOW_EQ_in_properties3791); if (state.failed) return ret;
			pushFollow(FOLLOW_prop_value_in_properties3795);
			v=prop_value();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.put(k,v);}
			// PhoenixSQL.g:648:54: ( COMMA k= prop_name EQ v= prop_value )*
			loop65:
			while (true) {
				int alt65=2;
				int LA65_0 = input.LA(1);
				if ( (LA65_0==COMMA) ) {
					alt65=1;
				}

				switch (alt65) {
				case 1 :
					// PhoenixSQL.g:648:55: COMMA k= prop_name EQ v= prop_value
					{
					match(input,COMMA,FOLLOW_COMMA_in_properties3801); if (state.failed) return ret;
					pushFollow(FOLLOW_prop_name_in_properties3805);
					k=prop_name();
					state._fsp--;
					if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_properties3807); if (state.failed) return ret;
					pushFollow(FOLLOW_prop_value_in_properties3811);
					v=prop_value();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.put(k,v);}
					}
					break;

				default :
					break loop65;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "properties"



	// $ANTLR start "column_defs"
	// PhoenixSQL.g:651:1: column_defs returns [List<ColumnDef> ret] : v= column_def ( COMMA v= column_def )* ;
	public final List<ColumnDef> column_defs() throws RecognitionException {
		List<ColumnDef> ret = null;


		ColumnDef v =null;

		ret = new ArrayList<ColumnDef>(); 
		try {
			// PhoenixSQL.g:653:5: (v= column_def ( COMMA v= column_def )* )
			// PhoenixSQL.g:653:8: v= column_def ( COMMA v= column_def )*
			{
			pushFollow(FOLLOW_column_def_in_column_defs3846);
			v=column_def();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(v);}
			// PhoenixSQL.g:653:39: ( COMMA v= column_def )*
			loop66:
			while (true) {
				int alt66=2;
				int LA66_0 = input.LA(1);
				if ( (LA66_0==COMMA) ) {
					int LA66_1 = input.LA(2);
					if ( (LA66_1==NAME) ) {
						alt66=1;
					}

				}

				switch (alt66) {
				case 1 :
					// PhoenixSQL.g:653:40: COMMA v= column_def
					{
					match(input,COMMA,FOLLOW_COMMA_in_column_defs3852); if (state.failed) return ret;
					pushFollow(FOLLOW_column_def_in_column_defs3858);
					v=column_def();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop66;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_defs"



	// $ANTLR start "column_def"
	// PhoenixSQL.g:656:1: column_def returns [ColumnDef ret] : c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ( (nn= NOT )? n= NULL )? ( DEFAULT df= expression )? (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )? ;
	public final ColumnDef column_def() throws RecognitionException {
		ColumnDef ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		Token nn=null;
		Token n=null;
		Token pk=null;
		Token order=null;
		Token rr=null;
		ColumnName c =null;
		String dt =null;
		ParseNode df =null;

		try {
			// PhoenixSQL.g:657:5: (c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ( (nn= NOT )? n= NULL )? ( DEFAULT df= expression )? (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )? )
			// PhoenixSQL.g:657:9: c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ( (nn= NOT )? n= NULL )? ( DEFAULT df= expression )? (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )?
			{
			pushFollow(FOLLOW_column_name_in_column_def3884);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_column_def3888);
			dt=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:657:37: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
			int alt68=2;
			int LA68_0 = input.LA(1);
			if ( (LA68_0==LPAREN) ) {
				alt68=1;
			}
			switch (alt68) {
				case 1 :
					// PhoenixSQL.g:657:38: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_column_def3891); if (state.failed) return ret;
					l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column_def3895); if (state.failed) return ret;
					// PhoenixSQL.g:657:54: ( COMMA s= NUMBER )?
					int alt67=2;
					int LA67_0 = input.LA(1);
					if ( (LA67_0==COMMA) ) {
						alt67=1;
					}
					switch (alt67) {
						case 1 :
							// PhoenixSQL.g:657:55: COMMA s= NUMBER
							{
							match(input,COMMA,FOLLOW_COMMA_in_column_def3898); if (state.failed) return ret;
							s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column_def3902); if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_column_def3906); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:657:83: (ar= ARRAY )?
			int alt69=2;
			int LA69_0 = input.LA(1);
			if ( (LA69_0==ARRAY) ) {
				alt69=1;
			}
			switch (alt69) {
				case 1 :
					// PhoenixSQL.g:657:83: ar= ARRAY
					{
					ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_column_def3912); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:657:91: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			int alt71=2;
			int LA71_0 = input.LA(1);
			if ( (LA71_0==LSQUARE) ) {
				alt71=1;
			}
			switch (alt71) {
				case 1 :
					// PhoenixSQL.g:657:92: lsq= LSQUARE (a= NUMBER )? RSQUARE
					{
					lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_column_def3918); if (state.failed) return ret;
					// PhoenixSQL.g:657:104: (a= NUMBER )?
					int alt70=2;
					int LA70_0 = input.LA(1);
					if ( (LA70_0==NUMBER) ) {
						alt70=1;
					}
					switch (alt70) {
						case 1 :
							// PhoenixSQL.g:657:105: a= NUMBER
							{
							a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column_def3923); if (state.failed) return ret;
							}
							break;

					}

					match(input,RSQUARE,FOLLOW_RSQUARE_in_column_def3927); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:657:126: ( (nn= NOT )? n= NULL )?
			int alt73=2;
			int LA73_0 = input.LA(1);
			if ( ((LA73_0 >= NOT && LA73_0 <= NULL)) ) {
				alt73=1;
			}
			switch (alt73) {
				case 1 :
					// PhoenixSQL.g:657:127: (nn= NOT )? n= NULL
					{
					// PhoenixSQL.g:657:129: (nn= NOT )?
					int alt72=2;
					int LA72_0 = input.LA(1);
					if ( (LA72_0==NOT) ) {
						alt72=1;
					}
					switch (alt72) {
						case 1 :
							// PhoenixSQL.g:657:129: nn= NOT
							{
							nn=(Token)match(input,NOT,FOLLOW_NOT_in_column_def3934); if (state.failed) return ret;
							}
							break;

					}

					n=(Token)match(input,NULL,FOLLOW_NULL_in_column_def3939); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:657:144: ( DEFAULT df= expression )?
			int alt74=2;
			int LA74_0 = input.LA(1);
			if ( (LA74_0==DEFAULT) ) {
				alt74=1;
			}
			switch (alt74) {
				case 1 :
					// PhoenixSQL.g:657:145: DEFAULT df= expression
					{
					match(input,DEFAULT,FOLLOW_DEFAULT_in_column_def3944); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_column_def3948);
					df=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:657:169: (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )?
			int alt77=2;
			int LA77_0 = input.LA(1);
			if ( (LA77_0==PRIMARY) ) {
				alt77=1;
			}
			switch (alt77) {
				case 1 :
					// PhoenixSQL.g:657:170: pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )?
					{
					pk=(Token)match(input,PRIMARY,FOLLOW_PRIMARY_in_column_def3955); if (state.failed) return ret;
					match(input,KEY,FOLLOW_KEY_in_column_def3957); if (state.failed) return ret;
					// PhoenixSQL.g:657:185: (order= ASC |order= DESC )?
					int alt75=3;
					int LA75_0 = input.LA(1);
					if ( (LA75_0==ASC) ) {
						alt75=1;
					}
					else if ( (LA75_0==DESC) ) {
						alt75=2;
					}
					switch (alt75) {
						case 1 :
							// PhoenixSQL.g:657:186: order= ASC
							{
							order=(Token)match(input,ASC,FOLLOW_ASC_in_column_def3962); if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:657:196: order= DESC
							{
							order=(Token)match(input,DESC,FOLLOW_DESC_in_column_def3966); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:657:211: (rr= ROW_TIMESTAMP )?
					int alt76=2;
					int LA76_0 = input.LA(1);
					if ( (LA76_0==ROW_TIMESTAMP) ) {
						alt76=1;
					}
					switch (alt76) {
						case 1 :
							// PhoenixSQL.g:657:211: rr= ROW_TIMESTAMP
							{
							rr=(Token)match(input,ROW_TIMESTAMP,FOLLOW_ROW_TIMESTAMP_in_column_def3972); if (state.failed) return ret;
							}
							break;

					}

					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.columnDef(c, dt, ar != null || lsq != null, a == null ? null :  Integer.parseInt( a.getText() ), nn!=null ? Boolean.FALSE : n!=null ? Boolean.TRUE : null, 
			            l == null ? null : Integer.parseInt( l.getText() ),
			            s == null ? null : Integer.parseInt( s.getText() ),
			            pk != null, 
			            order == null ? SortOrder.getDefault() : SortOrder.fromDDLValue(order.getText()),
			            df == null ? null : df.toString(),
			            rr != null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_def"



	// $ANTLR start "dyn_column_defs"
	// PhoenixSQL.g:667:1: dyn_column_defs returns [List<ColumnDef> ret] : v= dyn_column_def ( COMMA v= dyn_column_def )* ;
	public final List<ColumnDef> dyn_column_defs() throws RecognitionException {
		List<ColumnDef> ret = null;


		ColumnDef v =null;

		ret = new ArrayList<ColumnDef>(); 
		try {
			// PhoenixSQL.g:669:5: (v= dyn_column_def ( COMMA v= dyn_column_def )* )
			// PhoenixSQL.g:669:8: v= dyn_column_def ( COMMA v= dyn_column_def )*
			{
			pushFollow(FOLLOW_dyn_column_def_in_dyn_column_defs4015);
			v=dyn_column_def();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(v);}
			// PhoenixSQL.g:669:43: ( COMMA v= dyn_column_def )*
			loop78:
			while (true) {
				int alt78=2;
				int LA78_0 = input.LA(1);
				if ( (LA78_0==COMMA) ) {
					alt78=1;
				}

				switch (alt78) {
				case 1 :
					// PhoenixSQL.g:669:44: COMMA v= dyn_column_def
					{
					match(input,COMMA,FOLLOW_COMMA_in_dyn_column_defs4021); if (state.failed) return ret;
					pushFollow(FOLLOW_dyn_column_def_in_dyn_column_defs4027);
					v=dyn_column_def();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop78;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "dyn_column_defs"



	// $ANTLR start "dyn_column_def"
	// PhoenixSQL.g:672:1: dyn_column_def returns [ColumnDef ret] : c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ;
	public final ColumnDef dyn_column_def() throws RecognitionException {
		ColumnDef ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		ColumnName c =null;
		String dt =null;

		try {
			// PhoenixSQL.g:673:5: (c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )
			// PhoenixSQL.g:673:9: c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			{
			pushFollow(FOLLOW_column_name_in_dyn_column_def4053);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_dyn_column_def4057);
			dt=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:673:37: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
			int alt80=2;
			int LA80_0 = input.LA(1);
			if ( (LA80_0==LPAREN) ) {
				alt80=1;
			}
			switch (alt80) {
				case 1 :
					// PhoenixSQL.g:673:38: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_dyn_column_def4060); if (state.failed) return ret;
					l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_def4064); if (state.failed) return ret;
					// PhoenixSQL.g:673:54: ( COMMA s= NUMBER )?
					int alt79=2;
					int LA79_0 = input.LA(1);
					if ( (LA79_0==COMMA) ) {
						alt79=1;
					}
					switch (alt79) {
						case 1 :
							// PhoenixSQL.g:673:55: COMMA s= NUMBER
							{
							match(input,COMMA,FOLLOW_COMMA_in_dyn_column_def4067); if (state.failed) return ret;
							s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_def4071); if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_dyn_column_def4075); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:673:83: (ar= ARRAY )?
			int alt81=2;
			int LA81_0 = input.LA(1);
			if ( (LA81_0==ARRAY) ) {
				alt81=1;
			}
			switch (alt81) {
				case 1 :
					// PhoenixSQL.g:673:83: ar= ARRAY
					{
					ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_dyn_column_def4081); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:673:91: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			int alt83=2;
			int LA83_0 = input.LA(1);
			if ( (LA83_0==LSQUARE) ) {
				alt83=1;
			}
			switch (alt83) {
				case 1 :
					// PhoenixSQL.g:673:92: lsq= LSQUARE (a= NUMBER )? RSQUARE
					{
					lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_dyn_column_def4087); if (state.failed) return ret;
					// PhoenixSQL.g:673:104: (a= NUMBER )?
					int alt82=2;
					int LA82_0 = input.LA(1);
					if ( (LA82_0==NUMBER) ) {
						alt82=1;
					}
					switch (alt82) {
						case 1 :
							// PhoenixSQL.g:673:105: a= NUMBER
							{
							a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_def4092); if (state.failed) return ret;
							}
							break;

					}

					match(input,RSQUARE,FOLLOW_RSQUARE_in_dyn_column_def4096); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.columnDef(c, dt, ar != null || lsq != null, a == null ? null :  Integer.parseInt( a.getText() ), Boolean.TRUE,
			            l == null ? null : Integer.parseInt( l.getText() ),
			            s == null ? null : Integer.parseInt( s.getText() ),
			            false, 
			            SortOrder.getDefault(),
			            false); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "dyn_column_def"



	// $ANTLR start "dyn_column_name_or_def"
	// PhoenixSQL.g:682:1: dyn_column_name_or_def returns [ColumnDef ret] : c= column_name (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )? ;
	public final ColumnDef dyn_column_name_or_def() throws RecognitionException {
		ColumnDef ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		ColumnName c =null;
		String dt =null;

		try {
			// PhoenixSQL.g:683:5: (c= column_name (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )? )
			// PhoenixSQL.g:683:9: c= column_name (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )?
			{
			pushFollow(FOLLOW_column_name_in_dyn_column_name_or_def4133);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:683:23: (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )?
			int alt89=2;
			int LA89_0 = input.LA(1);
			if ( (LA89_0==NAME) ) {
				alt89=1;
			}
			switch (alt89) {
				case 1 :
					// PhoenixSQL.g:683:24: dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
					{
					pushFollow(FOLLOW_identifier_in_dyn_column_name_or_def4138);
					dt=identifier();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:683:38: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
					int alt85=2;
					int LA85_0 = input.LA(1);
					if ( (LA85_0==LPAREN) ) {
						alt85=1;
					}
					switch (alt85) {
						case 1 :
							// PhoenixSQL.g:683:39: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
							{
							match(input,LPAREN,FOLLOW_LPAREN_in_dyn_column_name_or_def4141); if (state.failed) return ret;
							l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_name_or_def4145); if (state.failed) return ret;
							// PhoenixSQL.g:683:55: ( COMMA s= NUMBER )?
							int alt84=2;
							int LA84_0 = input.LA(1);
							if ( (LA84_0==COMMA) ) {
								alt84=1;
							}
							switch (alt84) {
								case 1 :
									// PhoenixSQL.g:683:56: COMMA s= NUMBER
									{
									match(input,COMMA,FOLLOW_COMMA_in_dyn_column_name_or_def4148); if (state.failed) return ret;
									s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_name_or_def4152); if (state.failed) return ret;
									}
									break;

							}

							match(input,RPAREN,FOLLOW_RPAREN_in_dyn_column_name_or_def4156); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:683:84: (ar= ARRAY )?
					int alt86=2;
					int LA86_0 = input.LA(1);
					if ( (LA86_0==ARRAY) ) {
						alt86=1;
					}
					switch (alt86) {
						case 1 :
							// PhoenixSQL.g:683:84: ar= ARRAY
							{
							ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_dyn_column_name_or_def4162); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:683:92: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
					int alt88=2;
					int LA88_0 = input.LA(1);
					if ( (LA88_0==LSQUARE) ) {
						alt88=1;
					}
					switch (alt88) {
						case 1 :
							// PhoenixSQL.g:683:93: lsq= LSQUARE (a= NUMBER )? RSQUARE
							{
							lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_dyn_column_name_or_def4168); if (state.failed) return ret;
							// PhoenixSQL.g:683:105: (a= NUMBER )?
							int alt87=2;
							int LA87_0 = input.LA(1);
							if ( (LA87_0==NUMBER) ) {
								alt87=1;
							}
							switch (alt87) {
								case 1 :
									// PhoenixSQL.g:683:106: a= NUMBER
									{
									a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_name_or_def4173); if (state.failed) return ret;
									}
									break;

							}

							match(input,RSQUARE,FOLLOW_RSQUARE_in_dyn_column_name_or_def4177); if (state.failed) return ret;
							}
							break;

					}

					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.columnDef(c, dt, ar != null || lsq != null, a == null ? null :  Integer.parseInt( a.getText() ), Boolean.TRUE,
			            l == null ? null : Integer.parseInt( l.getText() ),
			            s == null ? null : Integer.parseInt( s.getText() ),
			            false, 
			            SortOrder.getDefault(),
			            false); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "dyn_column_name_or_def"



	// $ANTLR start "subquery_expression"
	// PhoenixSQL.g:692:1: subquery_expression returns [ParseNode ret] : s= select_node ;
	public final ParseNode subquery_expression() throws RecognitionException {
		ParseNode ret = null;


		SelectStatement s =null;

		try {
			// PhoenixSQL.g:693:5: (s= select_node )
			// PhoenixSQL.g:693:8: s= select_node
			{
			pushFollow(FOLLOW_select_node_in_subquery_expression4217);
			s=select_node();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.subquery(s, false);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "subquery_expression"



	// $ANTLR start "single_select"
	// PhoenixSQL.g:696:1: single_select returns [SelectStatement ret] : SELECT (h= hintClause )? (d= DISTINCT | ALL )? sel= select_list ( FROM from= parseFrom )? ( WHERE where= expression )? ( GROUP BY group= group_by )? ( HAVING having= expression )? ;
	public final SelectStatement single_select() throws RecognitionException {
		SelectStatement ret = null;


		Token d=null;
		HintNode h =null;
		List<AliasedNode> sel =null;
		TableNode from =null;
		ParseNode where =null;
		List<ParseNode> group =null;
		ParseNode having =null;

		 contextStack.push(new ParseContext()); 
		try {
			// PhoenixSQL.g:698:5: ( SELECT (h= hintClause )? (d= DISTINCT | ALL )? sel= select_list ( FROM from= parseFrom )? ( WHERE where= expression )? ( GROUP BY group= group_by )? ( HAVING having= expression )? )
			// PhoenixSQL.g:698:9: SELECT (h= hintClause )? (d= DISTINCT | ALL )? sel= select_list ( FROM from= parseFrom )? ( WHERE where= expression )? ( GROUP BY group= group_by )? ( HAVING having= expression )?
			{
			match(input,SELECT,FOLLOW_SELECT_in_single_select4250); if (state.failed) return ret;
			// PhoenixSQL.g:698:16: (h= hintClause )?
			int alt90=2;
			int LA90_0 = input.LA(1);
			if ( (LA90_0==ML_HINT) ) {
				alt90=1;
			}
			switch (alt90) {
				case 1 :
					// PhoenixSQL.g:698:17: h= hintClause
					{
					pushFollow(FOLLOW_hintClause_in_single_select4255);
					h=hintClause();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:699:9: (d= DISTINCT | ALL )?
			int alt91=3;
			int LA91_0 = input.LA(1);
			if ( (LA91_0==DISTINCT) ) {
				alt91=1;
			}
			else if ( (LA91_0==ALL) ) {
				alt91=2;
			}
			switch (alt91) {
				case 1 :
					// PhoenixSQL.g:699:10: d= DISTINCT
					{
					d=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_single_select4271); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:699:23: ALL
					{
					match(input,ALL,FOLLOW_ALL_in_single_select4275); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_select_list_in_single_select4281);
			sel=select_list();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:700:9: ( FROM from= parseFrom )?
			int alt92=2;
			int LA92_0 = input.LA(1);
			if ( (LA92_0==FROM) ) {
				alt92=1;
			}
			switch (alt92) {
				case 1 :
					// PhoenixSQL.g:700:10: FROM from= parseFrom
					{
					match(input,FROM,FOLLOW_FROM_in_single_select4292); if (state.failed) return ret;
					pushFollow(FOLLOW_parseFrom_in_single_select4296);
					from=parseFrom();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:701:9: ( WHERE where= expression )?
			int alt93=2;
			int LA93_0 = input.LA(1);
			if ( (LA93_0==WHERE) ) {
				alt93=1;
			}
			switch (alt93) {
				case 1 :
					// PhoenixSQL.g:701:10: WHERE where= expression
					{
					match(input,WHERE,FOLLOW_WHERE_in_single_select4309); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_single_select4313);
					where=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:702:9: ( GROUP BY group= group_by )?
			int alt94=2;
			int LA94_0 = input.LA(1);
			if ( (LA94_0==GROUP) ) {
				alt94=1;
			}
			switch (alt94) {
				case 1 :
					// PhoenixSQL.g:702:10: GROUP BY group= group_by
					{
					match(input,GROUP,FOLLOW_GROUP_in_single_select4326); if (state.failed) return ret;
					match(input,BY,FOLLOW_BY_in_single_select4328); if (state.failed) return ret;
					pushFollow(FOLLOW_group_by_in_single_select4332);
					group=group_by();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:703:9: ( HAVING having= expression )?
			int alt95=2;
			int LA95_0 = input.LA(1);
			if ( (LA95_0==HAVING) ) {
				alt95=1;
			}
			switch (alt95) {
				case 1 :
					// PhoenixSQL.g:703:10: HAVING having= expression
					{
					match(input,HAVING,FOLLOW_HAVING_in_single_select4345); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_single_select4349);
					having=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ParseContext context = contextStack.peek(); ret = factory.select(from, h, d!=null, sel, where, group, having, null, null,null, getBindCount(), context.isAggregate(), context.hasSequences(), null, new HashMap<String,UDFParseNode>(udfParseNodes)); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
			 contextStack.pop(); 
		}
		return ret;
	}
	// $ANTLR end "single_select"



	// $ANTLR start "unioned_selects"
	// PhoenixSQL.g:708:1: unioned_selects returns [List<SelectStatement> ret] : s= single_select ( UNION ALL s= single_select )* ;
	public final List<SelectStatement> unioned_selects() throws RecognitionException {
		List<SelectStatement> ret = null;


		SelectStatement s =null;

		ret = new ArrayList<SelectStatement>();
		try {
			// PhoenixSQL.g:710:5: (s= single_select ( UNION ALL s= single_select )* )
			// PhoenixSQL.g:710:9: s= single_select ( UNION ALL s= single_select )*
			{
			pushFollow(FOLLOW_single_select_in_unioned_selects4393);
			s=single_select();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(s);}
			// PhoenixSQL.g:710:39: ( UNION ALL s= single_select )*
			loop96:
			while (true) {
				int alt96=2;
				int LA96_0 = input.LA(1);
				if ( (LA96_0==UNION) ) {
					alt96=1;
				}

				switch (alt96) {
				case 1 :
					// PhoenixSQL.g:710:40: UNION ALL s= single_select
					{
					match(input,UNION,FOLLOW_UNION_in_unioned_selects4398); if (state.failed) return ret;
					match(input,ALL,FOLLOW_ALL_in_unioned_selects4400); if (state.failed) return ret;
					pushFollow(FOLLOW_single_select_in_unioned_selects4404);
					s=single_select();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(s);}
					}
					break;

				default :
					break loop96;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "unioned_selects"



	// $ANTLR start "select_node"
	// PhoenixSQL.g:714:1: select_node returns [SelectStatement ret] : u= unioned_selects ( ORDER BY order= order_by )? ( LIMIT l= limit )? ( OFFSET o= offset ( ROW | ROWS )? )? ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )? ;
	public final SelectStatement select_node() throws RecognitionException {
		SelectStatement ret = null;


		List<SelectStatement> u =null;
		List<OrderByNode> order =null;
		LimitNode l =null;
		OffsetNode o =null;

		 contextStack.push(new ParseContext()); 
		try {
			// PhoenixSQL.g:716:5: (u= unioned_selects ( ORDER BY order= order_by )? ( LIMIT l= limit )? ( OFFSET o= offset ( ROW | ROWS )? )? ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )? )
			// PhoenixSQL.g:716:9: u= unioned_selects ( ORDER BY order= order_by )? ( LIMIT l= limit )? ( OFFSET o= offset ( ROW | ROWS )? )? ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )?
			{
			pushFollow(FOLLOW_unioned_selects_in_select_node4442);
			u=unioned_selects();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:717:9: ( ORDER BY order= order_by )?
			int alt97=2;
			int LA97_0 = input.LA(1);
			if ( (LA97_0==ORDER) ) {
				alt97=1;
			}
			switch (alt97) {
				case 1 :
					// PhoenixSQL.g:717:10: ORDER BY order= order_by
					{
					match(input,ORDER,FOLLOW_ORDER_in_select_node4453); if (state.failed) return ret;
					match(input,BY,FOLLOW_BY_in_select_node4455); if (state.failed) return ret;
					pushFollow(FOLLOW_order_by_in_select_node4459);
					order=order_by();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:718:9: ( LIMIT l= limit )?
			int alt98=2;
			int LA98_0 = input.LA(1);
			if ( (LA98_0==LIMIT) ) {
				alt98=1;
			}
			switch (alt98) {
				case 1 :
					// PhoenixSQL.g:718:10: LIMIT l= limit
					{
					match(input,LIMIT,FOLLOW_LIMIT_in_select_node4472); if (state.failed) return ret;
					pushFollow(FOLLOW_limit_in_select_node4476);
					l=limit();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:719:9: ( OFFSET o= offset ( ROW | ROWS )? )?
			int alt100=2;
			int LA100_0 = input.LA(1);
			if ( (LA100_0==OFFSET) ) {
				alt100=1;
			}
			switch (alt100) {
				case 1 :
					// PhoenixSQL.g:719:10: OFFSET o= offset ( ROW | ROWS )?
					{
					match(input,OFFSET,FOLLOW_OFFSET_in_select_node4489); if (state.failed) return ret;
					pushFollow(FOLLOW_offset_in_select_node4493);
					o=offset();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:719:26: ( ROW | ROWS )?
					int alt99=2;
					int LA99_0 = input.LA(1);
					if ( ((LA99_0 >= ROW && LA99_0 <= ROWS)) ) {
						alt99=1;
					}
					switch (alt99) {
						case 1 :
							// PhoenixSQL.g:
							{
							if ( (input.LA(1) >= ROW && input.LA(1) <= ROWS) ) {
								input.consume();
								state.errorRecovery=false;
								state.failed=false;
							}
							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								MismatchedSetException mse = new MismatchedSetException(null,input);
								throw mse;
							}
							}
							break;

					}

					}
					break;

			}

			// PhoenixSQL.g:720:9: ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )?
			int alt102=2;
			int LA102_0 = input.LA(1);
			if ( (LA102_0==FETCH) ) {
				alt102=1;
			}
			switch (alt102) {
				case 1 :
					// PhoenixSQL.g:720:10: FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY
					{
					match(input,FETCH,FOLLOW_FETCH_in_select_node4515); if (state.failed) return ret;
					if ( input.LA(1)==FIRST||input.LA(1)==NEXT ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					// PhoenixSQL.g:720:31: (l= limit )?
					int alt101=2;
					int LA101_0 = input.LA(1);
					if ( (LA101_0==BIND_NAME||LA101_0==NUMBER||LA101_0==QUESTION) ) {
						alt101=1;
					}
					switch (alt101) {
						case 1 :
							// PhoenixSQL.g:720:32: l= limit
							{
							pushFollow(FOLLOW_limit_in_select_node4528);
							l=limit();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( (input.LA(1) >= ROW && input.LA(1) <= ROWS) ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					match(input,ONLY,FOLLOW_ONLY_in_select_node4540); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ParseContext context = contextStack.peek(); ret = factory.select(u, order, l, o, getBindCount(), context.isAggregate()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
			 contextStack.pop(); 
		}
		return ret;
	}
	// $ANTLR end "select_node"



	// $ANTLR start "upsert_node"
	// PhoenixSQL.g:726:1: upsert_node returns [UpsertStatement ret] : UPSERT (hint= hintClause )? INTO t= from_table_name ( LPAREN p= upsert_column_refs RPAREN )? ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? ) |s= select_node ) ;
	public final UpsertStatement upsert_node() throws RecognitionException {
		UpsertStatement ret = null;


		Token ig=null;
		HintNode hint =null;
		TableName t =null;
		Pair<List<ColumnDef>,List<ColumnName>> p =null;
		List<ParseNode> v =null;
		List<Pair<ColumnName,ParseNode>> pairs =null;
		SelectStatement s =null;

		try {
			// PhoenixSQL.g:727:5: ( UPSERT (hint= hintClause )? INTO t= from_table_name ( LPAREN p= upsert_column_refs RPAREN )? ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? ) |s= select_node ) )
			// PhoenixSQL.g:727:9: UPSERT (hint= hintClause )? INTO t= from_table_name ( LPAREN p= upsert_column_refs RPAREN )? ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? ) |s= select_node )
			{
			match(input,UPSERT,FOLLOW_UPSERT_in_upsert_node4579); if (state.failed) return ret;
			// PhoenixSQL.g:727:16: (hint= hintClause )?
			int alt103=2;
			int LA103_0 = input.LA(1);
			if ( (LA103_0==ML_HINT) ) {
				alt103=1;
			}
			switch (alt103) {
				case 1 :
					// PhoenixSQL.g:727:17: hint= hintClause
					{
					pushFollow(FOLLOW_hintClause_in_upsert_node4584);
					hint=hintClause();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			match(input,INTO,FOLLOW_INTO_in_upsert_node4588); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_upsert_node4592);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:728:9: ( LPAREN p= upsert_column_refs RPAREN )?
			int alt104=2;
			int LA104_0 = input.LA(1);
			if ( (LA104_0==LPAREN) ) {
				alt104=1;
			}
			switch (alt104) {
				case 1 :
					// PhoenixSQL.g:728:10: LPAREN p= upsert_column_refs RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_upsert_node4603); if (state.failed) return ret;
					pushFollow(FOLLOW_upsert_column_refs_in_upsert_node4607);
					p=upsert_column_refs();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_upsert_node4609); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:729:9: ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? ) |s= select_node )
			int alt107=2;
			int LA107_0 = input.LA(1);
			if ( (LA107_0==VALUES) ) {
				alt107=1;
			}
			else if ( (LA107_0==SELECT) ) {
				alt107=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 107, 0, input);
				throw nvae;
			}

			switch (alt107) {
				case 1 :
					// PhoenixSQL.g:729:10: ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? )
					{
					// PhoenixSQL.g:729:10: ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? )
					// PhoenixSQL.g:729:11: VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )?
					{
					match(input,VALUES,FOLLOW_VALUES_in_upsert_node4623); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_upsert_node4625); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_upsert_node4629);
					v=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_upsert_node4631); if (state.failed) return ret;
					// PhoenixSQL.g:729:58: ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )?
					int alt106=2;
					int LA106_0 = input.LA(1);
					if ( (LA106_0==ON) ) {
						alt106=1;
					}
					switch (alt106) {
						case 1 :
							// PhoenixSQL.g:729:60: ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) )
							{
							match(input,ON,FOLLOW_ON_in_upsert_node4635); if (state.failed) return ret;
							match(input,DUPLICATE,FOLLOW_DUPLICATE_in_upsert_node4637); if (state.failed) return ret;
							match(input,KEY,FOLLOW_KEY_in_upsert_node4639); if (state.failed) return ret;
							// PhoenixSQL.g:729:77: (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) )
							int alt105=2;
							int LA105_0 = input.LA(1);
							if ( (LA105_0==IGNORE) ) {
								alt105=1;
							}
							else if ( (LA105_0==UPDATE) ) {
								alt105=2;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 105, 0, input);
								throw nvae;
							}

							switch (alt105) {
								case 1 :
									// PhoenixSQL.g:729:79: ig= IGNORE
									{
									ig=(Token)match(input,IGNORE,FOLLOW_IGNORE_in_upsert_node4645); if (state.failed) return ret;
									}
									break;
								case 2 :
									// PhoenixSQL.g:729:91: ( UPDATE pairs= update_column_pairs )
									{
									// PhoenixSQL.g:729:91: ( UPDATE pairs= update_column_pairs )
									// PhoenixSQL.g:729:93: UPDATE pairs= update_column_pairs
									{
									match(input,UPDATE,FOLLOW_UPDATE_in_upsert_node4651); if (state.failed) return ret;
									pushFollow(FOLLOW_update_column_pairs_in_upsert_node4655);
									pairs=update_column_pairs();
									state._fsp--;
									if (state.failed) return ret;
									}

									}
									break;

							}

							}
							break;

					}

					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:729:137: s= select_node
					{
					pushFollow(FOLLOW_select_node_in_upsert_node4670);
					s=select_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.upsert(
			            factory.namedTable(null,t,p == null ? null : p.getFirst()), 
			            hint, p == null ? null : p.getSecond(), 
			            v, s, getBindCount(), 
			            new HashMap<String, UDFParseNode>(udfParseNodes),
			            ig != null ? Collections.<Pair<ColumnName,ParseNode>>emptyList() : pairs != null ? pairs : null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "upsert_node"



	// $ANTLR start "update_column_pairs"
	// PhoenixSQL.g:738:1: update_column_pairs returns [ List<Pair<ColumnName,ParseNode>> ret] : p= update_column_pair ( COMMA p= update_column_pair )* ;
	public final List<Pair<ColumnName,ParseNode>> update_column_pairs() throws RecognitionException {
		List<Pair<ColumnName,ParseNode>> ret = null;


		Pair<ColumnName,ParseNode> p =null;

		ret = new ArrayList<Pair<ColumnName,ParseNode>>(); 
		try {
			// PhoenixSQL.g:740:5: (p= update_column_pair ( COMMA p= update_column_pair )* )
			// PhoenixSQL.g:740:8: p= update_column_pair ( COMMA p= update_column_pair )*
			{
			pushFollow(FOLLOW_update_column_pair_in_update_column_pairs4711);
			p=update_column_pair();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret.add(p); }
			// PhoenixSQL.g:741:8: ( COMMA p= update_column_pair )*
			loop108:
			while (true) {
				int alt108=2;
				int LA108_0 = input.LA(1);
				if ( (LA108_0==COMMA) ) {
					alt108=1;
				}

				switch (alt108) {
				case 1 :
					// PhoenixSQL.g:741:9: COMMA p= update_column_pair
					{
					match(input,COMMA,FOLLOW_COMMA_in_update_column_pairs4723); if (state.failed) return ret;
					pushFollow(FOLLOW_update_column_pair_in_update_column_pairs4727);
					p=update_column_pair();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret.add(p); }
					}
					break;

				default :
					break loop108;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "update_column_pairs"



	// $ANTLR start "update_column_pair"
	// PhoenixSQL.g:744:1: update_column_pair returns [ Pair<ColumnName,ParseNode> ret ] : c= column_name EQ e= expression ;
	public final Pair<ColumnName,ParseNode> update_column_pair() throws RecognitionException {
		Pair<ColumnName,ParseNode> ret = null;


		ColumnName c =null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:745:5: (c= column_name EQ e= expression )
			// PhoenixSQL.g:745:8: c= column_name EQ e= expression
			{
			pushFollow(FOLLOW_column_name_in_update_column_pair4752);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EQ,FOLLOW_EQ_in_update_column_pair4754); if (state.failed) return ret;
			pushFollow(FOLLOW_expression_in_update_column_pair4758);
			e=expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = new Pair<ColumnName,ParseNode>(c,e); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "update_column_pair"



	// $ANTLR start "upsert_column_refs"
	// PhoenixSQL.g:749:1: upsert_column_refs returns [Pair<List<ColumnDef>,List<ColumnName>> ret] : d= dyn_column_name_or_def ( COMMA d= dyn_column_name_or_def )* ;
	public final Pair<List<ColumnDef>,List<ColumnName>> upsert_column_refs() throws RecognitionException {
		Pair<List<ColumnDef>,List<ColumnName>> ret = null;


		ColumnDef d =null;

		ret = new Pair<List<ColumnDef>,List<ColumnName>>(new ArrayList<ColumnDef>(), new ArrayList<ColumnName>()); 
		try {
			// PhoenixSQL.g:751:5: (d= dyn_column_name_or_def ( COMMA d= dyn_column_name_or_def )* )
			// PhoenixSQL.g:751:8: d= dyn_column_name_or_def ( COMMA d= dyn_column_name_or_def )*
			{
			pushFollow(FOLLOW_dyn_column_name_or_def_in_upsert_column_refs4787);
			d=dyn_column_name_or_def();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { if (d.getDataType()!=null) { ret.getFirst().add(d); } ret.getSecond().add(d.getColumnDefName()); }
			// PhoenixSQL.g:752:8: ( COMMA d= dyn_column_name_or_def )*
			loop109:
			while (true) {
				int alt109=2;
				int LA109_0 = input.LA(1);
				if ( (LA109_0==COMMA) ) {
					alt109=1;
				}

				switch (alt109) {
				case 1 :
					// PhoenixSQL.g:752:9: COMMA d= dyn_column_name_or_def
					{
					match(input,COMMA,FOLLOW_COMMA_in_upsert_column_refs4800); if (state.failed) return ret;
					pushFollow(FOLLOW_dyn_column_name_or_def_in_upsert_column_refs4804);
					d=dyn_column_name_or_def();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { if (d.getDataType()!=null) { ret.getFirst().add(d); } ret.getSecond().add(d.getColumnDefName()); }
					}
					break;

				default :
					break loop109;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "upsert_column_refs"



	// $ANTLR start "declare_cursor_node"
	// PhoenixSQL.g:757:1: declare_cursor_node returns [DeclareCursorStatement ret] : DECLARE c= cursor_name CURSOR FOR s= select_node ;
	public final DeclareCursorStatement declare_cursor_node() throws RecognitionException {
		DeclareCursorStatement ret = null;


		CursorName c =null;
		SelectStatement s =null;

		try {
			// PhoenixSQL.g:758:5: ( DECLARE c= cursor_name CURSOR FOR s= select_node )
			// PhoenixSQL.g:758:10: DECLARE c= cursor_name CURSOR FOR s= select_node
			{
			match(input,DECLARE,FOLLOW_DECLARE_in_declare_cursor_node4832); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_declare_cursor_node4836);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,CURSOR,FOLLOW_CURSOR_in_declare_cursor_node4838); if (state.failed) return ret;
			match(input,FOR,FOLLOW_FOR_in_declare_cursor_node4840); if (state.failed) return ret;
			pushFollow(FOLLOW_select_node_in_declare_cursor_node4844);
			s=select_node();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.declareCursor(c, s); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "declare_cursor_node"



	// $ANTLR start "cursor_open_node"
	// PhoenixSQL.g:762:1: cursor_open_node returns [OpenStatement ret] : OPEN c= cursor_name ;
	public final OpenStatement cursor_open_node() throws RecognitionException {
		OpenStatement ret = null;


		CursorName c =null;

		try {
			// PhoenixSQL.g:763:5: ( OPEN c= cursor_name )
			// PhoenixSQL.g:763:10: OPEN c= cursor_name
			{
			match(input,OPEN,FOLLOW_OPEN_in_cursor_open_node4878); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_cursor_open_node4882);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.open(c);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_open_node"



	// $ANTLR start "cursor_close_node"
	// PhoenixSQL.g:766:1: cursor_close_node returns [CloseStatement ret] : CLOSE c= cursor_name ;
	public final CloseStatement cursor_close_node() throws RecognitionException {
		CloseStatement ret = null;


		CursorName c =null;

		try {
			// PhoenixSQL.g:767:5: ( CLOSE c= cursor_name )
			// PhoenixSQL.g:767:10: CLOSE c= cursor_name
			{
			match(input,CLOSE,FOLLOW_CLOSE_in_cursor_close_node4909); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_cursor_close_node4913);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.close(c);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_close_node"



	// $ANTLR start "cursor_fetch_node"
	// PhoenixSQL.g:770:1: cursor_fetch_node returns [FetchStatement ret] : FETCH NEXT (a= NUMBER )? ( ROW | ROWS )? FROM c= cursor_name ;
	public final FetchStatement cursor_fetch_node() throws RecognitionException {
		FetchStatement ret = null;


		Token a=null;
		CursorName c =null;

		try {
			// PhoenixSQL.g:771:5: ( FETCH NEXT (a= NUMBER )? ( ROW | ROWS )? FROM c= cursor_name )
			// PhoenixSQL.g:771:10: FETCH NEXT (a= NUMBER )? ( ROW | ROWS )? FROM c= cursor_name
			{
			match(input,FETCH,FOLLOW_FETCH_in_cursor_fetch_node4939); if (state.failed) return ret;
			match(input,NEXT,FOLLOW_NEXT_in_cursor_fetch_node4941); if (state.failed) return ret;
			// PhoenixSQL.g:771:21: (a= NUMBER )?
			int alt110=2;
			int LA110_0 = input.LA(1);
			if ( (LA110_0==NUMBER) ) {
				alt110=1;
			}
			switch (alt110) {
				case 1 :
					// PhoenixSQL.g:771:22: a= NUMBER
					{
					a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_cursor_fetch_node4946); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:771:33: ( ROW | ROWS )?
			int alt111=2;
			int LA111_0 = input.LA(1);
			if ( ((LA111_0 >= ROW && LA111_0 <= ROWS)) ) {
				alt111=1;
			}
			switch (alt111) {
				case 1 :
					// PhoenixSQL.g:
					{
					if ( (input.LA(1) >= ROW && input.LA(1) <= ROWS) ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					}
					break;

			}

			match(input,FROM,FOLLOW_FROM_in_cursor_fetch_node4957); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_cursor_fetch_node4961);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.fetch(c,true, a == null ? 1 :  Integer.parseInt( a.getText() )); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_fetch_node"



	// $ANTLR start "delete_node"
	// PhoenixSQL.g:775:1: delete_node returns [DeleteStatement ret] : DELETE (hint= hintClause )? FROM t= from_table_name ( WHERE v= expression )? ( ORDER BY order= order_by )? ( LIMIT l= limit )? ;
	public final DeleteStatement delete_node() throws RecognitionException {
		DeleteStatement ret = null;


		HintNode hint =null;
		TableName t =null;
		ParseNode v =null;
		List<OrderByNode> order =null;
		LimitNode l =null;

		try {
			// PhoenixSQL.g:776:5: ( DELETE (hint= hintClause )? FROM t= from_table_name ( WHERE v= expression )? ( ORDER BY order= order_by )? ( LIMIT l= limit )? )
			// PhoenixSQL.g:776:9: DELETE (hint= hintClause )? FROM t= from_table_name ( WHERE v= expression )? ( ORDER BY order= order_by )? ( LIMIT l= limit )?
			{
			match(input,DELETE,FOLLOW_DELETE_in_delete_node4987); if (state.failed) return ret;
			// PhoenixSQL.g:776:16: (hint= hintClause )?
			int alt112=2;
			int LA112_0 = input.LA(1);
			if ( (LA112_0==ML_HINT) ) {
				alt112=1;
			}
			switch (alt112) {
				case 1 :
					// PhoenixSQL.g:776:17: hint= hintClause
					{
					pushFollow(FOLLOW_hintClause_in_delete_node4992);
					hint=hintClause();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			match(input,FROM,FOLLOW_FROM_in_delete_node4996); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_delete_node5000);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:777:9: ( WHERE v= expression )?
			int alt113=2;
			int LA113_0 = input.LA(1);
			if ( (LA113_0==WHERE) ) {
				alt113=1;
			}
			switch (alt113) {
				case 1 :
					// PhoenixSQL.g:777:10: WHERE v= expression
					{
					match(input,WHERE,FOLLOW_WHERE_in_delete_node5011); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_delete_node5015);
					v=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:778:9: ( ORDER BY order= order_by )?
			int alt114=2;
			int LA114_0 = input.LA(1);
			if ( (LA114_0==ORDER) ) {
				alt114=1;
			}
			switch (alt114) {
				case 1 :
					// PhoenixSQL.g:778:10: ORDER BY order= order_by
					{
					match(input,ORDER,FOLLOW_ORDER_in_delete_node5028); if (state.failed) return ret;
					match(input,BY,FOLLOW_BY_in_delete_node5030); if (state.failed) return ret;
					pushFollow(FOLLOW_order_by_in_delete_node5034);
					order=order_by();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:779:9: ( LIMIT l= limit )?
			int alt115=2;
			int LA115_0 = input.LA(1);
			if ( (LA115_0==LIMIT) ) {
				alt115=1;
			}
			switch (alt115) {
				case 1 :
					// PhoenixSQL.g:779:10: LIMIT l= limit
					{
					match(input,LIMIT,FOLLOW_LIMIT_in_delete_node5047); if (state.failed) return ret;
					pushFollow(FOLLOW_limit_in_delete_node5051);
					l=limit();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.delete(factory.namedTable(null,t), hint, v, order, l, getBindCount(), new HashMap<String, UDFParseNode>(udfParseNodes)); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "delete_node"



	// $ANTLR start "limit"
	// PhoenixSQL.g:783:1: limit returns [LimitNode ret] : (b= bind_expression |l= int_or_long_literal );
	public final LimitNode limit() throws RecognitionException {
		LimitNode ret = null;


		BindParseNode b =null;
		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:784:5: (b= bind_expression |l= int_or_long_literal )
			int alt116=2;
			int LA116_0 = input.LA(1);
			if ( (LA116_0==BIND_NAME||LA116_0==QUESTION) ) {
				alt116=1;
			}
			else if ( (LA116_0==NUMBER) ) {
				alt116=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 116, 0, input);
				throw nvae;
			}

			switch (alt116) {
				case 1 :
					// PhoenixSQL.g:784:7: b= bind_expression
					{
					pushFollow(FOLLOW_bind_expression_in_limit5086);
					b=bind_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.limit(b); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:785:7: l= int_or_long_literal
					{
					pushFollow(FOLLOW_int_or_long_literal_in_limit5098);
					l=int_or_long_literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.limit(l); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "limit"



	// $ANTLR start "offset"
	// PhoenixSQL.g:788:1: offset returns [OffsetNode ret] : (b= bind_expression |l= int_or_long_literal );
	public final OffsetNode offset() throws RecognitionException {
		OffsetNode ret = null;


		BindParseNode b =null;
		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:789:2: (b= bind_expression |l= int_or_long_literal )
			int alt117=2;
			int LA117_0 = input.LA(1);
			if ( (LA117_0==BIND_NAME||LA117_0==QUESTION) ) {
				alt117=1;
			}
			else if ( (LA117_0==NUMBER) ) {
				alt117=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 117, 0, input);
				throw nvae;
			}

			switch (alt117) {
				case 1 :
					// PhoenixSQL.g:789:4: b= bind_expression
					{
					pushFollow(FOLLOW_bind_expression_in_offset5124);
					b=bind_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.offset(b); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:790:7: l= int_or_long_literal
					{
					pushFollow(FOLLOW_int_or_long_literal_in_offset5136);
					l=int_or_long_literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.offset(l); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "offset"



	// $ANTLR start "sampling_rate"
	// PhoenixSQL.g:793:1: sampling_rate returns [LiteralParseNode ret] : l= literal ;
	public final LiteralParseNode sampling_rate() throws RecognitionException {
		LiteralParseNode ret = null;


		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:794:5: (l= literal )
			// PhoenixSQL.g:794:7: l= literal
			{
			pushFollow(FOLLOW_literal_in_sampling_rate5161);
			l=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = l; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "sampling_rate"



	// $ANTLR start "hintClause"
	// PhoenixSQL.g:797:1: hintClause returns [HintNode ret] : c= ML_HINT ;
	public final HintNode hintClause() throws RecognitionException {
		HintNode ret = null;


		Token c=null;

		try {
			// PhoenixSQL.g:798:5: (c= ML_HINT )
			// PhoenixSQL.g:798:8: c= ML_HINT
			{
			c=(Token)match(input,ML_HINT,FOLLOW_ML_HINT_in_hintClause5187); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.hint(c.getText()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "hintClause"



	// $ANTLR start "select_list"
	// PhoenixSQL.g:802:1: select_list returns [List<AliasedNode> ret] : (n= selectable ( COMMA n= selectable )* | ASTERISK );
	public final List<AliasedNode> select_list() throws RecognitionException {
		List<AliasedNode> ret = null;


		AliasedNode n =null;

		ret = new ArrayList<AliasedNode>();
		try {
			// PhoenixSQL.g:804:5: (n= selectable ( COMMA n= selectable )* | ASTERISK )
			int alt119=2;
			int LA119_0 = input.LA(1);
			if ( (LA119_0==ARRAY||LA119_0==BIND_NAME||(LA119_0 >= CASE && LA119_0 <= CAST)||LA119_0==CURRENT||LA119_0==DECIMAL||LA119_0==DOUBLE||LA119_0==EXISTS||LA119_0==FALSE||LA119_0==LPAREN||LA119_0==MINUS||(LA119_0 >= NAME && LA119_0 <= NEXT)||(LA119_0 >= NOT && LA119_0 <= NULL)||LA119_0==NUMBER||LA119_0==QUESTION||LA119_0==STRING_LITERAL||LA119_0==TRUE) ) {
				alt119=1;
			}
			else if ( (LA119_0==ASTERISK) ) {
				alt119=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 119, 0, input);
				throw nvae;
			}

			switch (alt119) {
				case 1 :
					// PhoenixSQL.g:804:9: n= selectable ( COMMA n= selectable )*
					{
					pushFollow(FOLLOW_selectable_in_select_list5219);
					n=selectable();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(n);}
					// PhoenixSQL.g:804:36: ( COMMA n= selectable )*
					loop118:
					while (true) {
						int alt118=2;
						int LA118_0 = input.LA(1);
						if ( (LA118_0==COMMA) ) {
							alt118=1;
						}

						switch (alt118) {
						case 1 :
							// PhoenixSQL.g:804:37: COMMA n= selectable
							{
							match(input,COMMA,FOLLOW_COMMA_in_select_list5224); if (state.failed) return ret;
							pushFollow(FOLLOW_selectable_in_select_list5228);
							n=selectable();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {ret.add(n);}
							}
							break;

						default :
							break loop118;
						}
					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:805:7: ASTERISK
					{
					match(input,ASTERISK,FOLLOW_ASTERISK_in_select_list5240); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = Collections.<AliasedNode>singletonList(factory.aliasedNode(null, factory.wildcard()));}
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "select_list"



	// $ANTLR start "selectable"
	// PhoenixSQL.g:809:1: selectable returns [AliasedNode ret] : (field= expression (a= parseAlias )? |familyName= identifier DOT ASTERISK |s= identifier DOT t= identifier DOT ASTERISK );
	public final AliasedNode selectable() throws RecognitionException {
		AliasedNode ret = null;


		ParseNode field =null;
		String a =null;
		String familyName =null;
		String s =null;
		String t =null;

		try {
			// PhoenixSQL.g:810:5: (field= expression (a= parseAlias )? |familyName= identifier DOT ASTERISK |s= identifier DOT t= identifier DOT ASTERISK )
			int alt121=3;
			int LA121_0 = input.LA(1);
			if ( (LA121_0==ARRAY||LA121_0==BIND_NAME||(LA121_0 >= CASE && LA121_0 <= CAST)||LA121_0==CURRENT||LA121_0==DECIMAL||LA121_0==DOUBLE||LA121_0==EXISTS||LA121_0==FALSE||LA121_0==LPAREN||LA121_0==MINUS||LA121_0==NEXT||(LA121_0 >= NOT && LA121_0 <= NULL)||LA121_0==NUMBER||LA121_0==QUESTION||LA121_0==STRING_LITERAL||LA121_0==TRUE) ) {
				alt121=1;
			}
			else if ( (LA121_0==NAME) ) {
				int LA121_2 = input.LA(2);
				if ( (LA121_2==EOF||LA121_2==AND||LA121_2==AS||LA121_2==ASTERISK||LA121_2==BETWEEN||LA121_2==COMMA||LA121_2==CONCAT||LA121_2==DIVIDE||LA121_2==EQ||LA121_2==FETCH||LA121_2==FROM||(LA121_2 >= GROUP && LA121_2 <= HAVING)||LA121_2==ILIKE||LA121_2==IN||LA121_2==IS||(LA121_2 >= LIKE && LA121_2 <= LIMIT)||(LA121_2 >= LPAREN && LA121_2 <= LT)||LA121_2==MINUS||LA121_2==NAME||(LA121_2 >= NOEQ1 && LA121_2 <= NOT)||LA121_2==OFFSET||(LA121_2 >= OR && LA121_2 <= ORDER)||(LA121_2 >= PERCENT && LA121_2 <= PLUS)||LA121_2==RPAREN||LA121_2==SEMICOLON||LA121_2==STRING_LITERAL||LA121_2==UNION||LA121_2==WHERE) ) {
					alt121=1;
				}
				else if ( (LA121_2==DOT) ) {
					int LA121_3 = input.LA(3);
					if ( (LA121_3==ASTERISK) ) {
						alt121=2;
					}
					else if ( (LA121_3==NAME) ) {
						int LA121_5 = input.LA(4);
						if ( (LA121_5==EOF||LA121_5==AND||LA121_5==AS||LA121_5==ASTERISK||LA121_5==BETWEEN||LA121_5==COMMA||LA121_5==CONCAT||LA121_5==DIVIDE||LA121_5==EQ||LA121_5==FETCH||LA121_5==FROM||(LA121_5 >= GROUP && LA121_5 <= HAVING)||LA121_5==ILIKE||LA121_5==IN||LA121_5==IS||(LA121_5 >= LIKE && LA121_5 <= LIMIT)||(LA121_5 >= LSQUARE && LA121_5 <= LT)||LA121_5==MINUS||LA121_5==NAME||(LA121_5 >= NOEQ1 && LA121_5 <= NOT)||LA121_5==OFFSET||(LA121_5 >= OR && LA121_5 <= ORDER)||(LA121_5 >= PERCENT && LA121_5 <= PLUS)||LA121_5==RPAREN||LA121_5==SEMICOLON||LA121_5==UNION||LA121_5==WHERE) ) {
							alt121=1;
						}
						else if ( (LA121_5==DOT) ) {
							int LA121_6 = input.LA(5);
							if ( (LA121_6==ASTERISK) ) {
								alt121=3;
							}
							else if ( (LA121_6==NAME) ) {
								alt121=1;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								int nvaeMark = input.mark();
								try {
									for (int nvaeConsume = 0; nvaeConsume < 5 - 1; nvaeConsume++) {
										input.consume();
									}
									NoViableAltException nvae =
										new NoViableAltException("", 121, 6, input);
									throw nvae;
								} finally {
									input.rewind(nvaeMark);
								}
							}

						}

						else {
							if (state.backtracking>0) {state.failed=true; return ret;}
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 121, 5, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 121, 3, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 121, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 121, 0, input);
				throw nvae;
			}

			switch (alt121) {
				case 1 :
					// PhoenixSQL.g:810:9: field= expression (a= parseAlias )?
					{
					pushFollow(FOLLOW_expression_in_selectable5269);
					field=expression();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:810:26: (a= parseAlias )?
					int alt120=2;
					int LA120_0 = input.LA(1);
					if ( (LA120_0==AS||LA120_0==NAME) ) {
						alt120=1;
					}
					switch (alt120) {
						case 1 :
							// PhoenixSQL.g:810:27: a= parseAlias
							{
							pushFollow(FOLLOW_parseAlias_in_selectable5274);
							a=parseAlias();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.aliasedNode(a, field); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:811:8: familyName= identifier DOT ASTERISK
					{
					pushFollow(FOLLOW_identifier_in_selectable5289);
					familyName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_selectable5291); if (state.failed) return ret;
					match(input,ASTERISK,FOLLOW_ASTERISK_in_selectable5293); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.aliasedNode(null, factory.family(familyName));}
					}
					break;
				case 3 :
					// PhoenixSQL.g:812:9: s= identifier DOT t= identifier DOT ASTERISK
					{
					pushFollow(FOLLOW_identifier_in_selectable5308);
					s=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_selectable5310); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_selectable5314);
					t=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_selectable5316); if (state.failed) return ret;
					match(input,ASTERISK,FOLLOW_ASTERISK_in_selectable5318); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.aliasedNode(null, factory.tableWildcard(factory.table(s, t))); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "selectable"



	// $ANTLR start "group_by"
	// PhoenixSQL.g:817:1: group_by returns [List<ParseNode> ret] : expr= expression ( COMMA expr= expression )* ;
	public final List<ParseNode> group_by() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode expr =null;

		ret = new ArrayList<ParseNode>();
		try {
			// PhoenixSQL.g:819:5: (expr= expression ( COMMA expr= expression )* )
			// PhoenixSQL.g:819:9: expr= expression ( COMMA expr= expression )*
			{
			pushFollow(FOLLOW_expression_in_group_by5351);
			expr=expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret.add(expr); }
			// PhoenixSQL.g:820:9: ( COMMA expr= expression )*
			loop122:
			while (true) {
				int alt122=2;
				int LA122_0 = input.LA(1);
				if ( (LA122_0==COMMA) ) {
					alt122=1;
				}

				switch (alt122) {
				case 1 :
					// PhoenixSQL.g:820:10: COMMA expr= expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_group_by5364); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_group_by5370);
					expr=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(expr); }
					}
					break;

				default :
					break loop122;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "group_by"



	// $ANTLR start "order_by"
	// PhoenixSQL.g:824:1: order_by returns [List<OrderByNode> ret] : field= parseOrderByField ( COMMA field= parseOrderByField )* ;
	public final List<OrderByNode> order_by() throws RecognitionException {
		List<OrderByNode> ret = null;


		OrderByNode field =null;

		ret = new ArrayList<OrderByNode>();
		try {
			// PhoenixSQL.g:826:5: (field= parseOrderByField ( COMMA field= parseOrderByField )* )
			// PhoenixSQL.g:826:9: field= parseOrderByField ( COMMA field= parseOrderByField )*
			{
			pushFollow(FOLLOW_parseOrderByField_in_order_by5404);
			field=parseOrderByField();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret.add(field); }
			// PhoenixSQL.g:827:9: ( COMMA field= parseOrderByField )*
			loop123:
			while (true) {
				int alt123=2;
				int LA123_0 = input.LA(1);
				if ( (LA123_0==COMMA) ) {
					alt123=1;
				}

				switch (alt123) {
				case 1 :
					// PhoenixSQL.g:827:10: COMMA field= parseOrderByField
					{
					match(input,COMMA,FOLLOW_COMMA_in_order_by5417); if (state.failed) return ret;
					pushFollow(FOLLOW_parseOrderByField_in_order_by5423);
					field=parseOrderByField();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(field); }
					}
					break;

				default :
					break loop123;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "order_by"



	// $ANTLR start "parseOrderByField"
	// PhoenixSQL.g:831:1: parseOrderByField returns [OrderByNode ret] : (expr= expression ) ( ASC | DESC )? ( NULLS ( FIRST | LAST ) )? ;
	public final OrderByNode parseOrderByField() throws RecognitionException {
		OrderByNode ret = null;


		ParseNode expr =null;

		boolean isAscending = true; boolean nullsLast = false;
		try {
			// PhoenixSQL.g:833:5: ( (expr= expression ) ( ASC | DESC )? ( NULLS ( FIRST | LAST ) )? )
			// PhoenixSQL.g:833:9: (expr= expression ) ( ASC | DESC )? ( NULLS ( FIRST | LAST ) )?
			{
			// PhoenixSQL.g:833:9: (expr= expression )
			// PhoenixSQL.g:833:10: expr= expression
			{
			pushFollow(FOLLOW_expression_in_parseOrderByField5460);
			expr=expression();
			state._fsp--;
			if (state.failed) return ret;
			}

			// PhoenixSQL.g:834:9: ( ASC | DESC )?
			int alt124=3;
			int LA124_0 = input.LA(1);
			if ( (LA124_0==ASC) ) {
				alt124=1;
			}
			else if ( (LA124_0==DESC) ) {
				alt124=2;
			}
			switch (alt124) {
				case 1 :
					// PhoenixSQL.g:834:10: ASC
					{
					match(input,ASC,FOLLOW_ASC_in_parseOrderByField5472); if (state.failed) return ret;
					if ( state.backtracking==0 ) {isAscending = true;}
					}
					break;
				case 2 :
					// PhoenixSQL.g:834:38: DESC
					{
					match(input,DESC,FOLLOW_DESC_in_parseOrderByField5478); if (state.failed) return ret;
					if ( state.backtracking==0 ) {isAscending = false;}
					}
					break;

			}

			// PhoenixSQL.g:835:9: ( NULLS ( FIRST | LAST ) )?
			int alt126=2;
			int LA126_0 = input.LA(1);
			if ( (LA126_0==NULLS) ) {
				alt126=1;
			}
			switch (alt126) {
				case 1 :
					// PhoenixSQL.g:835:10: NULLS ( FIRST | LAST )
					{
					match(input,NULLS,FOLLOW_NULLS_in_parseOrderByField5493); if (state.failed) return ret;
					// PhoenixSQL.g:835:16: ( FIRST | LAST )
					int alt125=2;
					int LA125_0 = input.LA(1);
					if ( (LA125_0==FIRST) ) {
						alt125=1;
					}
					else if ( (LA125_0==LAST) ) {
						alt125=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 125, 0, input);
						throw nvae;
					}

					switch (alt125) {
						case 1 :
							// PhoenixSQL.g:835:17: FIRST
							{
							match(input,FIRST,FOLLOW_FIRST_in_parseOrderByField5496); if (state.failed) return ret;
							if ( state.backtracking==0 ) {nullsLast = false;}
							}
							break;
						case 2 :
							// PhoenixSQL.g:835:46: LAST
							{
							match(input,LAST,FOLLOW_LAST_in_parseOrderByField5502); if (state.failed) return ret;
							if ( state.backtracking==0 ) {nullsLast = true;}
							}
							break;

					}

					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.orderBy(expr, nullsLast, isAscending); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseOrderByField"



	// $ANTLR start "parseFrom"
	// PhoenixSQL.g:839:1: parseFrom returns [TableNode ret] : t= table_list ;
	public final TableNode parseFrom() throws RecognitionException {
		TableNode ret = null;


		TableNode t =null;

		try {
			// PhoenixSQL.g:840:5: (t= table_list )
			// PhoenixSQL.g:840:9: t= table_list
			{
			pushFollow(FOLLOW_table_list_in_parseFrom5542);
			t=table_list();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = t;}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseFrom"



	// $ANTLR start "table_list"
	// PhoenixSQL.g:843:1: table_list returns [TableNode ret] : t= table_ref ( COMMA s= table_ref )* ;
	public final TableNode table_list() throws RecognitionException {
		TableNode ret = null;


		TableNode t =null;
		TableNode s =null;

		try {
			// PhoenixSQL.g:844:5: (t= table_ref ( COMMA s= table_ref )* )
			// PhoenixSQL.g:844:9: t= table_ref ( COMMA s= table_ref )*
			{
			pushFollow(FOLLOW_table_ref_in_table_list5573);
			t=table_ref();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = t;}
			// PhoenixSQL.g:844:33: ( COMMA s= table_ref )*
			loop127:
			while (true) {
				int alt127=2;
				int LA127_0 = input.LA(1);
				if ( (LA127_0==COMMA) ) {
					alt127=1;
				}

				switch (alt127) {
				case 1 :
					// PhoenixSQL.g:844:34: COMMA s= table_ref
					{
					match(input,COMMA,FOLLOW_COMMA_in_table_list5578); if (state.failed) return ret;
					pushFollow(FOLLOW_table_ref_in_table_list5582);
					s=table_ref();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.join(JoinTableNode.JoinType.Inner, ret, s, null, false); }
					}
					break;

				default :
					break loop127;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_list"



	// $ANTLR start "table_ref"
	// PhoenixSQL.g:847:1: table_ref returns [TableNode ret] : l= table_factor (j= join_type JOIN r= table_factor ON e= expression )* ;
	public final TableNode table_ref() throws RecognitionException {
		TableNode ret = null;


		TableNode l =null;
		JoinTableNode.JoinType j =null;
		TableNode r =null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:848:2: (l= table_factor (j= join_type JOIN r= table_factor ON e= expression )* )
			// PhoenixSQL.g:848:4: l= table_factor (j= join_type JOIN r= table_factor ON e= expression )*
			{
			pushFollow(FOLLOW_table_factor_in_table_ref5606);
			l=table_factor();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = l; }
			// PhoenixSQL.g:848:33: (j= join_type JOIN r= table_factor ON e= expression )*
			loop128:
			while (true) {
				int alt128=2;
				int LA128_0 = input.LA(1);
				if ( (LA128_0==FULL||LA128_0==INNER||LA128_0==JOIN||LA128_0==LEFT||LA128_0==RIGHT) ) {
					alt128=1;
				}

				switch (alt128) {
				case 1 :
					// PhoenixSQL.g:848:34: j= join_type JOIN r= table_factor ON e= expression
					{
					pushFollow(FOLLOW_join_type_in_table_ref5613);
					j=join_type();
					state._fsp--;
					if (state.failed) return ret;
					match(input,JOIN,FOLLOW_JOIN_in_table_ref5615); if (state.failed) return ret;
					pushFollow(FOLLOW_table_factor_in_table_ref5619);
					r=table_factor();
					state._fsp--;
					if (state.failed) return ret;
					match(input,ON,FOLLOW_ON_in_table_ref5621); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_table_ref5625);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.join(j, ret, r, e, false); }
					}
					break;

				default :
					break loop128;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_ref"



	// $ANTLR start "table_factor"
	// PhoenixSQL.g:851:1: table_factor returns [TableNode ret] : ( LPAREN t= table_list RPAREN |n= bind_name ( ( AS )? alias= identifier )? |f= from_table_name ( ( AS )? alias= identifier )? ( LPAREN cdefs= dyn_column_defs RPAREN )? | LPAREN s= select_node RPAREN ( ( AS )? alias= identifier )? );
	public final TableNode table_factor() throws RecognitionException {
		TableNode ret = null;


		TableNode t =null;
		String n =null;
		String alias =null;
		TableName f =null;
		List<ColumnDef> cdefs =null;
		SelectStatement s =null;

		try {
			// PhoenixSQL.g:852:5: ( LPAREN t= table_list RPAREN |n= bind_name ( ( AS )? alias= identifier )? |f= from_table_name ( ( AS )? alias= identifier )? ( LPAREN cdefs= dyn_column_defs RPAREN )? | LPAREN s= select_node RPAREN ( ( AS )? alias= identifier )? )
			int alt136=4;
			switch ( input.LA(1) ) {
			case LPAREN:
				{
				int LA136_1 = input.LA(2);
				if ( (LA136_1==BIND_NAME||LA136_1==LPAREN||LA136_1==NAME||LA136_1==QUESTION) ) {
					alt136=1;
				}
				else if ( (LA136_1==SELECT) ) {
					alt136=4;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 136, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case BIND_NAME:
			case QUESTION:
				{
				alt136=2;
				}
				break;
			case NAME:
				{
				alt136=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 136, 0, input);
				throw nvae;
			}
			switch (alt136) {
				case 1 :
					// PhoenixSQL.g:852:9: LPAREN t= table_list RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_table_factor5649); if (state.failed) return ret;
					pushFollow(FOLLOW_table_list_in_table_factor5653);
					t=table_list();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_table_factor5655); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = t; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:853:9: n= bind_name ( ( AS )? alias= identifier )?
					{
					pushFollow(FOLLOW_bind_name_in_table_factor5669);
					n=bind_name();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:853:21: ( ( AS )? alias= identifier )?
					int alt130=2;
					int LA130_0 = input.LA(1);
					if ( (LA130_0==AS||LA130_0==NAME) ) {
						alt130=1;
					}
					switch (alt130) {
						case 1 :
							// PhoenixSQL.g:853:22: ( AS )? alias= identifier
							{
							// PhoenixSQL.g:853:22: ( AS )?
							int alt129=2;
							int LA129_0 = input.LA(1);
							if ( (LA129_0==AS) ) {
								alt129=1;
							}
							switch (alt129) {
								case 1 :
									// PhoenixSQL.g:853:23: AS
									{
									match(input,AS,FOLLOW_AS_in_table_factor5673); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_identifier_in_table_factor5679);
							alias=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.bindTable(alias, factory.table(null,n)); }
					}
					break;
				case 3 :
					// PhoenixSQL.g:854:9: f= from_table_name ( ( AS )? alias= identifier )? ( LPAREN cdefs= dyn_column_defs RPAREN )?
					{
					pushFollow(FOLLOW_from_table_name_in_table_factor5696);
					f=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:854:27: ( ( AS )? alias= identifier )?
					int alt132=2;
					int LA132_0 = input.LA(1);
					if ( (LA132_0==AS||LA132_0==NAME) ) {
						alt132=1;
					}
					switch (alt132) {
						case 1 :
							// PhoenixSQL.g:854:28: ( AS )? alias= identifier
							{
							// PhoenixSQL.g:854:28: ( AS )?
							int alt131=2;
							int LA131_0 = input.LA(1);
							if ( (LA131_0==AS) ) {
								alt131=1;
							}
							switch (alt131) {
								case 1 :
									// PhoenixSQL.g:854:29: AS
									{
									match(input,AS,FOLLOW_AS_in_table_factor5700); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_identifier_in_table_factor5706);
							alias=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:854:53: ( LPAREN cdefs= dyn_column_defs RPAREN )?
					int alt133=2;
					int LA133_0 = input.LA(1);
					if ( (LA133_0==LPAREN) ) {
						alt133=1;
					}
					switch (alt133) {
						case 1 :
							// PhoenixSQL.g:854:54: LPAREN cdefs= dyn_column_defs RPAREN
							{
							match(input,LPAREN,FOLLOW_LPAREN_in_table_factor5711); if (state.failed) return ret;
							pushFollow(FOLLOW_dyn_column_defs_in_table_factor5715);
							cdefs=dyn_column_defs();
							state._fsp--;
							if (state.failed) return ret;
							match(input,RPAREN,FOLLOW_RPAREN_in_table_factor5717); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.namedTable(alias,f,cdefs); }
					}
					break;
				case 4 :
					// PhoenixSQL.g:855:9: LPAREN s= select_node RPAREN ( ( AS )? alias= identifier )?
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_table_factor5731); if (state.failed) return ret;
					pushFollow(FOLLOW_select_node_in_table_factor5735);
					s=select_node();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_table_factor5737); if (state.failed) return ret;
					// PhoenixSQL.g:855:37: ( ( AS )? alias= identifier )?
					int alt135=2;
					int LA135_0 = input.LA(1);
					if ( (LA135_0==AS||LA135_0==NAME) ) {
						alt135=1;
					}
					switch (alt135) {
						case 1 :
							// PhoenixSQL.g:855:38: ( AS )? alias= identifier
							{
							// PhoenixSQL.g:855:38: ( AS )?
							int alt134=2;
							int LA134_0 = input.LA(1);
							if ( (LA134_0==AS) ) {
								alt134=1;
							}
							switch (alt134) {
								case 1 :
									// PhoenixSQL.g:855:39: AS
									{
									match(input,AS,FOLLOW_AS_in_table_factor5741); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_identifier_in_table_factor5747);
							alias=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.derivedTable(alias, s); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_factor"



	// $ANTLR start "join_type"
	// PhoenixSQL.g:858:1: join_type returns [JoinTableNode.JoinType ret] : ( ( INNER )? | LEFT ( OUTER )? | RIGHT ( OUTER )? | FULL ( OUTER )? );
	public final JoinTableNode.JoinType join_type() throws RecognitionException {
		JoinTableNode.JoinType ret = null;


		try {
			// PhoenixSQL.g:859:5: ( ( INNER )? | LEFT ( OUTER )? | RIGHT ( OUTER )? | FULL ( OUTER )? )
			int alt141=4;
			switch ( input.LA(1) ) {
			case INNER:
			case JOIN:
				{
				alt141=1;
				}
				break;
			case LEFT:
				{
				alt141=2;
				}
				break;
			case RIGHT:
				{
				alt141=3;
				}
				break;
			case FULL:
				{
				alt141=4;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 141, 0, input);
				throw nvae;
			}
			switch (alt141) {
				case 1 :
					// PhoenixSQL.g:859:9: ( INNER )?
					{
					// PhoenixSQL.g:859:9: ( INNER )?
					int alt137=2;
					int LA137_0 = input.LA(1);
					if ( (LA137_0==INNER) ) {
						alt137=1;
					}
					switch (alt137) {
						case 1 :
							// PhoenixSQL.g:859:9: INNER
							{
							match(input,INNER,FOLLOW_INNER_in_join_type5774); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Inner; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:860:9: LEFT ( OUTER )?
					{
					match(input,LEFT,FOLLOW_LEFT_in_join_type5789); if (state.failed) return ret;
					// PhoenixSQL.g:860:14: ( OUTER )?
					int alt138=2;
					int LA138_0 = input.LA(1);
					if ( (LA138_0==OUTER) ) {
						alt138=1;
					}
					switch (alt138) {
						case 1 :
							// PhoenixSQL.g:860:14: OUTER
							{
							match(input,OUTER,FOLLOW_OUTER_in_join_type5791); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Left; }
					}
					break;
				case 3 :
					// PhoenixSQL.g:861:9: RIGHT ( OUTER )?
					{
					match(input,RIGHT,FOLLOW_RIGHT_in_join_type5806); if (state.failed) return ret;
					// PhoenixSQL.g:861:15: ( OUTER )?
					int alt139=2;
					int LA139_0 = input.LA(1);
					if ( (LA139_0==OUTER) ) {
						alt139=1;
					}
					switch (alt139) {
						case 1 :
							// PhoenixSQL.g:861:15: OUTER
							{
							match(input,OUTER,FOLLOW_OUTER_in_join_type5808); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Right; }
					}
					break;
				case 4 :
					// PhoenixSQL.g:862:9: FULL ( OUTER )?
					{
					match(input,FULL,FOLLOW_FULL_in_join_type5822); if (state.failed) return ret;
					// PhoenixSQL.g:862:15: ( OUTER )?
					int alt140=2;
					int LA140_0 = input.LA(1);
					if ( (LA140_0==OUTER) ) {
						alt140=1;
					}
					switch (alt140) {
						case 1 :
							// PhoenixSQL.g:862:15: OUTER
							{
							match(input,OUTER,FOLLOW_OUTER_in_join_type5825); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Full; }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "join_type"



	// $ANTLR start "parseAlias"
	// PhoenixSQL.g:865:1: parseAlias returns [String ret] : ( AS )? alias= parseNoReserved ;
	public final String parseAlias() throws RecognitionException {
		String ret = null;


		String alias =null;

		try {
			// PhoenixSQL.g:866:5: ( ( AS )? alias= parseNoReserved )
			// PhoenixSQL.g:866:9: ( AS )? alias= parseNoReserved
			{
			// PhoenixSQL.g:866:9: ( AS )?
			int alt142=2;
			int LA142_0 = input.LA(1);
			if ( (LA142_0==AS) ) {
				alt142=1;
			}
			switch (alt142) {
				case 1 :
					// PhoenixSQL.g:866:9: AS
					{
					match(input,AS,FOLLOW_AS_in_parseAlias5856); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_parseNoReserved_in_parseAlias5861);
			alias=parseNoReserved();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = alias; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseAlias"



	// $ANTLR start "expression"
	// PhoenixSQL.g:870:1: expression returns [ParseNode ret] : e= or_expression ;
	public final ParseNode expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode e =null;

		try {
			// PhoenixSQL.g:871:5: (e= or_expression )
			// PhoenixSQL.g:871:9: e= or_expression
			{
			pushFollow(FOLLOW_or_expression_in_expression5889);
			e=or_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = e; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "expression"



	// $ANTLR start "or_expression"
	// PhoenixSQL.g:875:1: or_expression returns [ParseNode ret] : i= and_expression ( OR i= and_expression )* ;
	public final ParseNode or_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:877:5: (i= and_expression ( OR i= and_expression )* )
			// PhoenixSQL.g:877:9: i= and_expression ( OR i= and_expression )*
			{
			pushFollow(FOLLOW_and_expression_in_or_expression5921);
			i=and_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:877:38: ( OR i= and_expression )*
			loop143:
			while (true) {
				int alt143=2;
				int LA143_0 = input.LA(1);
				if ( (LA143_0==OR) ) {
					alt143=1;
				}

				switch (alt143) {
				case 1 :
					// PhoenixSQL.g:877:39: OR i= and_expression
					{
					match(input,OR,FOLLOW_OR_in_or_expression5926); if (state.failed) return ret;
					pushFollow(FOLLOW_and_expression_in_or_expression5930);
					i=and_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop143;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.or(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "or_expression"



	// $ANTLR start "and_expression"
	// PhoenixSQL.g:881:1: and_expression returns [ParseNode ret] : i= not_expression ( AND i= not_expression )* ;
	public final ParseNode and_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:883:5: (i= not_expression ( AND i= not_expression )* )
			// PhoenixSQL.g:883:9: i= not_expression ( AND i= not_expression )*
			{
			pushFollow(FOLLOW_not_expression_in_and_expression5966);
			i=not_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:883:38: ( AND i= not_expression )*
			loop144:
			while (true) {
				int alt144=2;
				int LA144_0 = input.LA(1);
				if ( (LA144_0==AND) ) {
					alt144=1;
				}

				switch (alt144) {
				case 1 :
					// PhoenixSQL.g:883:39: AND i= not_expression
					{
					match(input,AND,FOLLOW_AND_in_and_expression5971); if (state.failed) return ret;
					pushFollow(FOLLOW_not_expression_in_and_expression5975);
					i=not_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop144;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.and(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "and_expression"



	// $ANTLR start "not_expression"
	// PhoenixSQL.g:887:1: not_expression returns [ParseNode ret] : ( ( ( NOT )? boolean_expression )=> (n= NOT )? e= boolean_expression | (n= NOT )? LPAREN e= expression RPAREN );
	public final ParseNode not_expression() throws RecognitionException {
		ParseNode ret = null;


		Token n=null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:888:5: ( ( ( NOT )? boolean_expression )=> (n= NOT )? e= boolean_expression | (n= NOT )? LPAREN e= expression RPAREN )
			int alt147=2;
			int LA147_0 = input.LA(1);
			if ( (LA147_0==NOT) ) {
				int LA147_1 = input.LA(2);
				if ( (synpred1_PhoenixSQL()) ) {
					alt147=1;
				}
				else if ( (true) ) {
					alt147=2;
				}

			}
			else if ( (LA147_0==MINUS) && (synpred1_PhoenixSQL())) {
				alt147=1;
			}
			else if ( (LA147_0==STRING_LITERAL) && (synpred1_PhoenixSQL())) {
				alt147=1;
			}
			else if ( (LA147_0==NUMBER) && (synpred1_PhoenixSQL())) {
				alt147=1;
			}
			else if ( (LA147_0==DECIMAL) && (synpred1_PhoenixSQL())) {
				alt147=1;
			}
			else if ( (LA147_0==DOUBLE) && (synpred1_PhoenixSQL())) {
				alt147=1;
			}
			else if ( (LA147_0==NULL) && (synpred1_PhoenixSQL())) {
				alt147=1;
			}
			else if ( (LA147_0==TRUE) && (synpred1_PhoenixSQL())) {
				alt147=1;
			}
			else if ( (LA147_0==FALSE) && (synpred1_PhoenixSQL())) {
				alt147=1;
			}
			else if ( (LA147_0==NAME) && (synpred1_PhoenixSQL())) {
				alt147=1;
			}
			else if ( (LA147_0==BIND_NAME) && (synpred1_PhoenixSQL())) {
				alt147=1;
			}
			else if ( (LA147_0==QUESTION) && (synpred1_PhoenixSQL())) {
				alt147=1;
			}
			else if ( (LA147_0==ARRAY) && (synpred1_PhoenixSQL())) {
				alt147=1;
			}
			else if ( (LA147_0==CASE) && (synpred1_PhoenixSQL())) {
				alt147=1;
			}
			else if ( (LA147_0==LPAREN) ) {
				int LA147_15 = input.LA(2);
				if ( (synpred1_PhoenixSQL()) ) {
					alt147=1;
				}
				else if ( (true) ) {
					alt147=2;
				}

			}
			else if ( (LA147_0==CAST) && (synpred1_PhoenixSQL())) {
				alt147=1;
			}
			else if ( (LA147_0==NEXT) && (synpred1_PhoenixSQL())) {
				alt147=1;
			}
			else if ( (LA147_0==CURRENT) && (synpred1_PhoenixSQL())) {
				alt147=1;
			}
			else if ( (LA147_0==EXISTS) && (synpred1_PhoenixSQL())) {
				alt147=1;
			}

			switch (alt147) {
				case 1 :
					// PhoenixSQL.g:888:9: ( ( NOT )? boolean_expression )=> (n= NOT )? e= boolean_expression
					{
					// PhoenixSQL.g:888:40: (n= NOT )?
					int alt145=2;
					int LA145_0 = input.LA(1);
					if ( (LA145_0==NOT) ) {
						alt145=1;
					}
					switch (alt145) {
						case 1 :
							// PhoenixSQL.g:888:40: n= NOT
							{
							n=(Token)match(input,NOT,FOLLOW_NOT_in_not_expression6017); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_boolean_expression_in_not_expression6022);
					e=boolean_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = n == null ? e : factory.not(e); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:889:9: (n= NOT )? LPAREN e= expression RPAREN
					{
					// PhoenixSQL.g:889:10: (n= NOT )?
					int alt146=2;
					int LA146_0 = input.LA(1);
					if ( (LA146_0==NOT) ) {
						alt146=1;
					}
					switch (alt146) {
						case 1 :
							// PhoenixSQL.g:889:10: n= NOT
							{
							n=(Token)match(input,NOT,FOLLOW_NOT_in_not_expression6036); if (state.failed) return ret;
							}
							break;

					}

					match(input,LPAREN,FOLLOW_LPAREN_in_not_expression6039); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_not_expression6043);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_not_expression6045); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = n == null ? e : factory.not(e); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "not_expression"



	// $ANTLR start "comparison_op"
	// PhoenixSQL.g:892:1: comparison_op returns [CompareOp ret] : ( EQ | LT | GT | LT EQ | GT EQ | ( NOEQ1 | NOEQ2 ) );
	public final CompareOp comparison_op() throws RecognitionException {
		CompareOp ret = null;


		try {
			// PhoenixSQL.g:893:2: ( EQ | LT | GT | LT EQ | GT EQ | ( NOEQ1 | NOEQ2 ) )
			int alt148=6;
			switch ( input.LA(1) ) {
			case EQ:
				{
				alt148=1;
				}
				break;
			case LT:
				{
				int LA148_2 = input.LA(2);
				if ( (LA148_2==EQ) ) {
					alt148=4;
				}
				else if ( (LA148_2==ALL||(LA148_2 >= ANY && LA148_2 <= ARRAY)||LA148_2==BIND_NAME||(LA148_2 >= CASE && LA148_2 <= CAST)||LA148_2==CURRENT||LA148_2==DECIMAL||LA148_2==DOUBLE||LA148_2==FALSE||LA148_2==LPAREN||LA148_2==MINUS||(LA148_2 >= NAME && LA148_2 <= NEXT)||LA148_2==NULL||LA148_2==NUMBER||LA148_2==QUESTION||LA148_2==STRING_LITERAL||LA148_2==TRUE) ) {
					alt148=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 148, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case GT:
				{
				int LA148_3 = input.LA(2);
				if ( (LA148_3==EQ) ) {
					alt148=5;
				}
				else if ( (LA148_3==ALL||(LA148_3 >= ANY && LA148_3 <= ARRAY)||LA148_3==BIND_NAME||(LA148_3 >= CASE && LA148_3 <= CAST)||LA148_3==CURRENT||LA148_3==DECIMAL||LA148_3==DOUBLE||LA148_3==FALSE||LA148_3==LPAREN||LA148_3==MINUS||(LA148_3 >= NAME && LA148_3 <= NEXT)||LA148_3==NULL||LA148_3==NUMBER||LA148_3==QUESTION||LA148_3==STRING_LITERAL||LA148_3==TRUE) ) {
					alt148=3;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 148, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case NOEQ1:
			case NOEQ2:
				{
				alt148=6;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 148, 0, input);
				throw nvae;
			}
			switch (alt148) {
				case 1 :
					// PhoenixSQL.g:893:4: EQ
					{
					match(input,EQ,FOLLOW_EQ_in_comparison_op6065); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOp.EQUAL; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:894:4: LT
					{
					match(input,LT,FOLLOW_LT_in_comparison_op6072); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOp.LESS; }
					}
					break;
				case 3 :
					// PhoenixSQL.g:895:4: GT
					{
					match(input,GT,FOLLOW_GT_in_comparison_op6079); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOp.GREATER; }
					}
					break;
				case 4 :
					// PhoenixSQL.g:896:4: LT EQ
					{
					match(input,LT,FOLLOW_LT_in_comparison_op6086); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_comparison_op6088); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOp.LESS_OR_EQUAL; }
					}
					break;
				case 5 :
					// PhoenixSQL.g:897:4: GT EQ
					{
					match(input,GT,FOLLOW_GT_in_comparison_op6095); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_comparison_op6097); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOp.GREATER_OR_EQUAL; }
					}
					break;
				case 6 :
					// PhoenixSQL.g:898:4: ( NOEQ1 | NOEQ2 )
					{
					if ( (input.LA(1) >= NOEQ1 && input.LA(1) <= NOEQ2) ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					if ( state.backtracking==0 ) { ret = CompareOp.NOT_EQUAL; }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "comparison_op"



	// $ANTLR start "boolean_expression"
	// PhoenixSQL.g:901:1: boolean_expression returns [ParseNode ret] : (l= value_expression ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |) | EXISTS LPAREN s= subquery_expression RPAREN );
	public final ParseNode boolean_expression() throws RecognitionException {
		ParseNode ret = null;


		Token all=null;
		Token any=null;
		Token n=null;
		ParseNode l =null;
		CompareOp op =null;
		ParseNode r =null;
		ParseNode r1 =null;
		ParseNode r2 =null;
		List<ParseNode> v =null;
		ParseNode s =null;

		try {
			// PhoenixSQL.g:902:5: (l= value_expression ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |) | EXISTS LPAREN s= subquery_expression RPAREN )
			int alt157=2;
			int LA157_0 = input.LA(1);
			if ( (LA157_0==ARRAY||LA157_0==BIND_NAME||(LA157_0 >= CASE && LA157_0 <= CAST)||LA157_0==CURRENT||LA157_0==DECIMAL||LA157_0==DOUBLE||LA157_0==FALSE||LA157_0==LPAREN||LA157_0==MINUS||(LA157_0 >= NAME && LA157_0 <= NEXT)||LA157_0==NULL||LA157_0==NUMBER||LA157_0==QUESTION||LA157_0==STRING_LITERAL||LA157_0==TRUE) ) {
				alt157=1;
			}
			else if ( (LA157_0==EXISTS) ) {
				alt157=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 157, 0, input);
				throw nvae;
			}

			switch (alt157) {
				case 1 :
					// PhoenixSQL.g:902:9: l= value_expression ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |)
					{
					pushFollow(FOLLOW_value_expression_in_boolean_expression6135);
					l=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:902:28: ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |)
					int alt156=4;
					switch ( input.LA(1) ) {
					case EQ:
					case GT:
					case LT:
					case NOEQ1:
					case NOEQ2:
						{
						alt156=1;
						}
						break;
					case IS:
						{
						alt156=2;
						}
						break;
					case BETWEEN:
					case ILIKE:
					case IN:
					case LIKE:
					case NOT:
						{
						alt156=3;
						}
						break;
					case EOF:
					case AND:
					case AS:
					case ASC:
					case COMMA:
					case CONSTRAINT:
					case DESC:
					case ELSE:
					case END:
					case FETCH:
					case FROM:
					case FULL:
					case GROUP:
					case HAVING:
					case INNER:
					case JOIN:
					case LEFT:
					case LIMIT:
					case MAXVALUE:
					case MINVALUE:
					case NAME:
					case NULLS:
					case OFFSET:
					case OR:
					case ORDER:
					case PRIMARY:
					case RIGHT:
					case RPAREN:
					case RSQUARE:
					case SEMICOLON:
					case THEN:
					case UNION:
					case WHEN:
					case WHERE:
						{
						alt156=4;
						}
						break;
					default:
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 156, 0, input);
						throw nvae;
					}
					switch (alt156) {
						case 1 :
							// PhoenixSQL.g:902:29: (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) )
							{
							// PhoenixSQL.g:902:29: (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) )
							// PhoenixSQL.g:902:30: op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) )
							{
							pushFollow(FOLLOW_comparison_op_in_boolean_expression6141);
							op=comparison_op();
							state._fsp--;
							if (state.failed) return ret;
							// PhoenixSQL.g:902:47: (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) )
							int alt151=4;
							switch ( input.LA(1) ) {
							case ARRAY:
							case BIND_NAME:
							case CASE:
							case CAST:
							case CURRENT:
							case DECIMAL:
							case DOUBLE:
							case FALSE:
							case MINUS:
							case NAME:
							case NEXT:
							case NULL:
							case NUMBER:
							case QUESTION:
							case STRING_LITERAL:
							case TRUE:
								{
								alt151=1;
								}
								break;
							case LPAREN:
								{
								int LA151_2 = input.LA(2);
								if ( (LA151_2==ARRAY||LA151_2==BIND_NAME||(LA151_2 >= CASE && LA151_2 <= CAST)||LA151_2==CURRENT||LA151_2==DECIMAL||LA151_2==DOUBLE||LA151_2==EXISTS||LA151_2==FALSE||LA151_2==LPAREN||LA151_2==MINUS||(LA151_2 >= NAME && LA151_2 <= NEXT)||(LA151_2 >= NOT && LA151_2 <= NULL)||LA151_2==NUMBER||LA151_2==QUESTION||LA151_2==STRING_LITERAL||LA151_2==TRUE) ) {
									alt151=1;
								}
								else if ( (LA151_2==SELECT) ) {
									alt151=2;
								}

								else {
									if (state.backtracking>0) {state.failed=true; return ret;}
									int nvaeMark = input.mark();
									try {
										input.consume();
										NoViableAltException nvae =
											new NoViableAltException("", 151, 2, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case ALL:
								{
								int LA151_3 = input.LA(2);
								if ( (LA151_3==LPAREN) ) {
									int LA151_6 = input.LA(3);
									if ( (LA151_6==ARRAY||LA151_6==BIND_NAME||(LA151_6 >= CASE && LA151_6 <= CAST)||LA151_6==CURRENT||LA151_6==DECIMAL||LA151_6==DOUBLE||LA151_6==FALSE||LA151_6==LPAREN||LA151_6==MINUS||(LA151_6 >= NAME && LA151_6 <= NEXT)||LA151_6==NULL||LA151_6==NUMBER||LA151_6==QUESTION||LA151_6==STRING_LITERAL||LA151_6==TRUE) ) {
										alt151=3;
									}
									else if ( (LA151_6==SELECT) ) {
										alt151=4;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										int nvaeMark = input.mark();
										try {
											for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
												input.consume();
											}
											NoViableAltException nvae =
												new NoViableAltException("", 151, 6, input);
											throw nvae;
										} finally {
											input.rewind(nvaeMark);
										}
									}

								}

								else {
									if (state.backtracking>0) {state.failed=true; return ret;}
									int nvaeMark = input.mark();
									try {
										input.consume();
										NoViableAltException nvae =
											new NoViableAltException("", 151, 3, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case ANY:
								{
								int LA151_4 = input.LA(2);
								if ( (LA151_4==LPAREN) ) {
									int LA151_6 = input.LA(3);
									if ( (LA151_6==ARRAY||LA151_6==BIND_NAME||(LA151_6 >= CASE && LA151_6 <= CAST)||LA151_6==CURRENT||LA151_6==DECIMAL||LA151_6==DOUBLE||LA151_6==FALSE||LA151_6==LPAREN||LA151_6==MINUS||(LA151_6 >= NAME && LA151_6 <= NEXT)||LA151_6==NULL||LA151_6==NUMBER||LA151_6==QUESTION||LA151_6==STRING_LITERAL||LA151_6==TRUE) ) {
										alt151=3;
									}
									else if ( (LA151_6==SELECT) ) {
										alt151=4;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										int nvaeMark = input.mark();
										try {
											for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
												input.consume();
											}
											NoViableAltException nvae =
												new NoViableAltException("", 151, 6, input);
											throw nvae;
										} finally {
											input.rewind(nvaeMark);
										}
									}

								}

								else {
									if (state.backtracking>0) {state.failed=true; return ret;}
									int nvaeMark = input.mark();
									try {
										input.consume();
										NoViableAltException nvae =
											new NoViableAltException("", 151, 4, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							default:
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 151, 0, input);
								throw nvae;
							}
							switch (alt151) {
								case 1 :
									// PhoenixSQL.g:902:48: r= value_expression
									{
									pushFollow(FOLLOW_value_expression_in_boolean_expression6146);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									}
									break;
								case 2 :
									// PhoenixSQL.g:902:69: ( LPAREN r= subquery_expression RPAREN )
									{
									// PhoenixSQL.g:902:69: ( LPAREN r= subquery_expression RPAREN )
									// PhoenixSQL.g:902:70: LPAREN r= subquery_expression RPAREN
									{
									match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6151); if (state.failed) return ret;
									pushFollow(FOLLOW_subquery_expression_in_boolean_expression6155);
									r=subquery_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6157); if (state.failed) return ret;
									}

									}
									break;
								case 3 :
									// PhoenixSQL.g:902:109: ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN )
									{
									// PhoenixSQL.g:902:109: ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN )
									// PhoenixSQL.g:902:110: (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN
									{
									// PhoenixSQL.g:902:110: (all= ALL |any= ANY )
									int alt149=2;
									int LA149_0 = input.LA(1);
									if ( (LA149_0==ALL) ) {
										alt149=1;
									}
									else if ( (LA149_0==ANY) ) {
										alt149=2;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										NoViableAltException nvae =
											new NoViableAltException("", 149, 0, input);
										throw nvae;
									}

									switch (alt149) {
										case 1 :
											// PhoenixSQL.g:902:111: all= ALL
											{
											all=(Token)match(input,ALL,FOLLOW_ALL_in_boolean_expression6166); if (state.failed) return ret;
											}
											break;
										case 2 :
											// PhoenixSQL.g:902:121: any= ANY
											{
											any=(Token)match(input,ANY,FOLLOW_ANY_in_boolean_expression6172); if (state.failed) return ret;
											}
											break;

									}

									match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6175); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression6179);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6181); if (state.failed) return ret;
									}

									}
									break;
								case 4 :
									// PhoenixSQL.g:902:167: ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN )
									{
									// PhoenixSQL.g:902:167: ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN )
									// PhoenixSQL.g:902:168: (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN
									{
									// PhoenixSQL.g:902:168: (all= ALL |any= ANY )
									int alt150=2;
									int LA150_0 = input.LA(1);
									if ( (LA150_0==ALL) ) {
										alt150=1;
									}
									else if ( (LA150_0==ANY) ) {
										alt150=2;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										NoViableAltException nvae =
											new NoViableAltException("", 150, 0, input);
										throw nvae;
									}

									switch (alt150) {
										case 1 :
											// PhoenixSQL.g:902:169: all= ALL
											{
											all=(Token)match(input,ALL,FOLLOW_ALL_in_boolean_expression6191); if (state.failed) return ret;
											}
											break;
										case 2 :
											// PhoenixSQL.g:902:179: any= ANY
											{
											any=(Token)match(input,ANY,FOLLOW_ANY_in_boolean_expression6197); if (state.failed) return ret;
											}
											break;

									}

									match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6200); if (state.failed) return ret;
									pushFollow(FOLLOW_subquery_expression_in_boolean_expression6204);
									r=subquery_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6206); if (state.failed) return ret;
									}

									}
									break;

							}

							if ( state.backtracking==0 ) {ret = all != null ? factory.wrapInAll(op, l, r) : any != null ? factory.wrapInAny(op, l, r) : factory.comparison(op,l,r); }
							}

							}
							break;
						case 2 :
							// PhoenixSQL.g:903:22: ( IS (n= NOT )? NULL )
							{
							// PhoenixSQL.g:903:22: ( IS (n= NOT )? NULL )
							// PhoenixSQL.g:903:23: IS (n= NOT )? NULL
							{
							match(input,IS,FOLLOW_IS_in_boolean_expression6236); if (state.failed) return ret;
							// PhoenixSQL.g:903:27: (n= NOT )?
							int alt152=2;
							int LA152_0 = input.LA(1);
							if ( (LA152_0==NOT) ) {
								alt152=1;
							}
							switch (alt152) {
								case 1 :
									// PhoenixSQL.g:903:27: n= NOT
									{
									n=(Token)match(input,NOT,FOLLOW_NOT_in_boolean_expression6240); if (state.failed) return ret;
									}
									break;

							}

							match(input,NULL,FOLLOW_NULL_in_boolean_expression6243); if (state.failed) return ret;
							if ( state.backtracking==0 ) {ret = factory.isNull(l,n!=null); }
							}

							}
							break;
						case 3 :
							// PhoenixSQL.g:904:22: ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) )
							{
							// PhoenixSQL.g:904:22: ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) )
							// PhoenixSQL.g:904:24: (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) )
							{
							// PhoenixSQL.g:904:25: (n= NOT )?
							int alt153=2;
							int LA153_0 = input.LA(1);
							if ( (LA153_0==NOT) ) {
								alt153=1;
							}
							switch (alt153) {
								case 1 :
									// PhoenixSQL.g:904:25: n= NOT
									{
									n=(Token)match(input,NOT,FOLLOW_NOT_in_boolean_expression6274); if (state.failed) return ret;
									}
									break;

							}

							// PhoenixSQL.g:904:31: ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) )
							int alt155=4;
							switch ( input.LA(1) ) {
							case LIKE:
								{
								alt155=1;
								}
								break;
							case ILIKE:
								{
								alt155=2;
								}
								break;
							case BETWEEN:
								{
								alt155=3;
								}
								break;
							case IN:
								{
								alt155=4;
								}
								break;
							default:
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 155, 0, input);
								throw nvae;
							}
							switch (alt155) {
								case 1 :
									// PhoenixSQL.g:904:32: ( LIKE r= value_expression )
									{
									// PhoenixSQL.g:904:32: ( LIKE r= value_expression )
									// PhoenixSQL.g:904:33: LIKE r= value_expression
									{
									match(input,LIKE,FOLLOW_LIKE_in_boolean_expression6279); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression6283);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									if ( state.backtracking==0 ) {ret = factory.like(l,r,n!=null,LikeType.CASE_SENSITIVE); }
									}

									}
									break;
								case 2 :
									// PhoenixSQL.g:905:32: ( ILIKE r= value_expression )
									{
									// PhoenixSQL.g:905:32: ( ILIKE r= value_expression )
									// PhoenixSQL.g:905:33: ILIKE r= value_expression
									{
									match(input,ILIKE,FOLLOW_ILIKE_in_boolean_expression6321); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression6325);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									if ( state.backtracking==0 ) {ret = factory.like(l,r,n!=null,LikeType.CASE_INSENSITIVE); }
									}

									}
									break;
								case 3 :
									// PhoenixSQL.g:906:32: ( BETWEEN r1= value_expression AND r2= value_expression )
									{
									// PhoenixSQL.g:906:32: ( BETWEEN r1= value_expression AND r2= value_expression )
									// PhoenixSQL.g:906:33: BETWEEN r1= value_expression AND r2= value_expression
									{
									match(input,BETWEEN,FOLLOW_BETWEEN_in_boolean_expression6363); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression6367);
									r1=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,AND,FOLLOW_AND_in_boolean_expression6369); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression6373);
									r2=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									if ( state.backtracking==0 ) {ret = factory.between(l,r1,r2,n!=null); }
									}

									}
									break;
								case 4 :
									// PhoenixSQL.g:907:32: ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) )
									{
									// PhoenixSQL.g:907:32: ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) )
									// PhoenixSQL.g:907:33: ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) )
									{
									// PhoenixSQL.g:907:33: ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) )
									// PhoenixSQL.g:907:34: IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) )
									{
									match(input,IN,FOLLOW_IN_in_boolean_expression6412); if (state.failed) return ret;
									// PhoenixSQL.g:907:37: ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) )
									int alt154=3;
									int LA154_0 = input.LA(1);
									if ( (LA154_0==BIND_NAME||LA154_0==QUESTION) ) {
										alt154=1;
									}
									else if ( (LA154_0==LPAREN) ) {
										int LA154_2 = input.LA(2);
										if ( (LA154_2==SELECT) ) {
											alt154=2;
										}
										else if ( (LA154_2==ARRAY||LA154_2==BIND_NAME||(LA154_2 >= CASE && LA154_2 <= CAST)||LA154_2==CURRENT||LA154_2==DECIMAL||LA154_2==DOUBLE||LA154_2==EXISTS||LA154_2==FALSE||LA154_2==LPAREN||LA154_2==MINUS||(LA154_2 >= NAME && LA154_2 <= NEXT)||(LA154_2 >= NOT && LA154_2 <= NULL)||LA154_2==NUMBER||LA154_2==QUESTION||LA154_2==STRING_LITERAL||LA154_2==TRUE) ) {
											alt154=3;
										}

										else {
											if (state.backtracking>0) {state.failed=true; return ret;}
											int nvaeMark = input.mark();
											try {
												input.consume();
												NoViableAltException nvae =
													new NoViableAltException("", 154, 2, input);
												throw nvae;
											} finally {
												input.rewind(nvaeMark);
											}
										}

									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										NoViableAltException nvae =
											new NoViableAltException("", 154, 0, input);
										throw nvae;
									}

									switch (alt154) {
										case 1 :
											// PhoenixSQL.g:907:38: (r= bind_expression )
											{
											// PhoenixSQL.g:907:38: (r= bind_expression )
											// PhoenixSQL.g:907:39: r= bind_expression
											{
											pushFollow(FOLLOW_bind_expression_in_boolean_expression6418);
											r=bind_expression();
											state._fsp--;
											if (state.failed) return ret;
											if ( state.backtracking==0 ) {ret = factory.inList(Arrays.asList(l,r),n!=null);}
											}

											}
											break;
										case 2 :
											// PhoenixSQL.g:908:35: ( LPAREN r= subquery_expression RPAREN )
											{
											// PhoenixSQL.g:908:35: ( LPAREN r= subquery_expression RPAREN )
											// PhoenixSQL.g:908:36: LPAREN r= subquery_expression RPAREN
											{
											match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6459); if (state.failed) return ret;
											pushFollow(FOLLOW_subquery_expression_in_boolean_expression6463);
											r=subquery_expression();
											state._fsp--;
											if (state.failed) return ret;
											match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6465); if (state.failed) return ret;
											if ( state.backtracking==0 ) {ret = factory.in(l,r,n!=null,false);}
											}

											}
											break;
										case 3 :
											// PhoenixSQL.g:909:35: ( LPAREN v= one_or_more_expressions RPAREN )
											{
											// PhoenixSQL.g:909:35: ( LPAREN v= one_or_more_expressions RPAREN )
											// PhoenixSQL.g:909:36: LPAREN v= one_or_more_expressions RPAREN
											{
											match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6506); if (state.failed) return ret;
											pushFollow(FOLLOW_one_or_more_expressions_in_boolean_expression6510);
											v=one_or_more_expressions();
											state._fsp--;
											if (state.failed) return ret;
											match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6512); if (state.failed) return ret;
											if ( state.backtracking==0 ) {List<ParseNode> il = new ArrayList<ParseNode>(v.size() + 1); il.add(l); il.addAll(v); ret = factory.inList(il,n!=null);}
											}

											}
											break;

									}

									}

									}

									}
									break;

							}

							}

							}
							break;
						case 4 :
							// PhoenixSQL.g:912:23: 
							{
							if ( state.backtracking==0 ) { ret = l; }
							}
							break;

					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:913:9: EXISTS LPAREN s= subquery_expression RPAREN
					{
					match(input,EXISTS,FOLLOW_EXISTS_in_boolean_expression6612); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6614); if (state.failed) return ret;
					pushFollow(FOLLOW_subquery_expression_in_boolean_expression6618);
					s=subquery_expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6620); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.exists(s,false);}
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "boolean_expression"



	// $ANTLR start "bind_expression"
	// PhoenixSQL.g:916:1: bind_expression returns [BindParseNode ret] : b= bind_name ;
	public final BindParseNode bind_expression() throws RecognitionException {
		BindParseNode ret = null;


		String b =null;

		try {
			// PhoenixSQL.g:917:5: (b= bind_name )
			// PhoenixSQL.g:917:9: b= bind_name
			{
			pushFollow(FOLLOW_bind_name_in_bind_expression6648);
			b=bind_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.bind(b); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "bind_expression"



	// $ANTLR start "value_expression"
	// PhoenixSQL.g:920:1: value_expression returns [ParseNode ret] : i= add_expression ;
	public final ParseNode value_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		try {
			// PhoenixSQL.g:921:5: (i= add_expression )
			// PhoenixSQL.g:921:9: i= add_expression
			{
			pushFollow(FOLLOW_add_expression_in_value_expression6679);
			i=add_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = i; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "value_expression"



	// $ANTLR start "add_expression"
	// PhoenixSQL.g:924:1: add_expression returns [ParseNode ret] : i= subtract_expression ( PLUS i= subtract_expression )* ;
	public final ParseNode add_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:926:5: (i= subtract_expression ( PLUS i= subtract_expression )* )
			// PhoenixSQL.g:926:9: i= subtract_expression ( PLUS i= subtract_expression )*
			{
			pushFollow(FOLLOW_subtract_expression_in_add_expression6710);
			i=subtract_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:926:43: ( PLUS i= subtract_expression )*
			loop158:
			while (true) {
				int alt158=2;
				int LA158_0 = input.LA(1);
				if ( (LA158_0==PLUS) ) {
					alt158=1;
				}

				switch (alt158) {
				case 1 :
					// PhoenixSQL.g:926:44: PLUS i= subtract_expression
					{
					match(input,PLUS,FOLLOW_PLUS_in_add_expression6715); if (state.failed) return ret;
					pushFollow(FOLLOW_subtract_expression_in_add_expression6719);
					i=subtract_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop158;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.add(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "add_expression"



	// $ANTLR start "subtract_expression"
	// PhoenixSQL.g:929:1: subtract_expression returns [ParseNode ret] : i= concat_expression ( MINUS i= concat_expression )* ;
	public final ParseNode subtract_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:931:5: (i= concat_expression ( MINUS i= concat_expression )* )
			// PhoenixSQL.g:931:9: i= concat_expression ( MINUS i= concat_expression )*
			{
			pushFollow(FOLLOW_concat_expression_in_subtract_expression6754);
			i=concat_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:931:41: ( MINUS i= concat_expression )*
			loop159:
			while (true) {
				int alt159=2;
				int LA159_0 = input.LA(1);
				if ( (LA159_0==MINUS) ) {
					alt159=1;
				}

				switch (alt159) {
				case 1 :
					// PhoenixSQL.g:931:42: MINUS i= concat_expression
					{
					match(input,MINUS,FOLLOW_MINUS_in_subtract_expression6759); if (state.failed) return ret;
					pushFollow(FOLLOW_concat_expression_in_subtract_expression6763);
					i=concat_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop159;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.subtract(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "subtract_expression"



	// $ANTLR start "concat_expression"
	// PhoenixSQL.g:934:1: concat_expression returns [ParseNode ret] : i= multiply_divide_modulo_expression ( CONCAT i= multiply_divide_modulo_expression )* ;
	public final ParseNode concat_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:936:5: (i= multiply_divide_modulo_expression ( CONCAT i= multiply_divide_modulo_expression )* )
			// PhoenixSQL.g:936:9: i= multiply_divide_modulo_expression ( CONCAT i= multiply_divide_modulo_expression )*
			{
			pushFollow(FOLLOW_multiply_divide_modulo_expression_in_concat_expression6798);
			i=multiply_divide_modulo_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:936:57: ( CONCAT i= multiply_divide_modulo_expression )*
			loop160:
			while (true) {
				int alt160=2;
				int LA160_0 = input.LA(1);
				if ( (LA160_0==CONCAT) ) {
					alt160=1;
				}

				switch (alt160) {
				case 1 :
					// PhoenixSQL.g:936:58: CONCAT i= multiply_divide_modulo_expression
					{
					match(input,CONCAT,FOLLOW_CONCAT_in_concat_expression6803); if (state.failed) return ret;
					pushFollow(FOLLOW_multiply_divide_modulo_expression_in_concat_expression6807);
					i=multiply_divide_modulo_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop160;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.concat(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "concat_expression"



	// $ANTLR start "multiply_divide_modulo_expression"
	// PhoenixSQL.g:939:1: multiply_divide_modulo_expression returns [ParseNode ret] : i= negate_expression (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )* ;
	public final ParseNode multiply_divide_modulo_expression() throws RecognitionException {
		ParseNode ret = null;


		Token op=null;
		ParseNode i =null;
		ParseNode rhs =null;

		ParseNode lhs = null; List<ParseNode> l;
		try {
			// PhoenixSQL.g:941:5: (i= negate_expression (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )* )
			// PhoenixSQL.g:941:9: i= negate_expression (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )*
			{
			pushFollow(FOLLOW_negate_expression_in_multiply_divide_modulo_expression6842);
			i=negate_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {lhs = i;}
			// PhoenixSQL.g:942:9: (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )*
			loop161:
			while (true) {
				int alt161=2;
				int LA161_0 = input.LA(1);
				if ( (LA161_0==ASTERISK||LA161_0==DIVIDE||LA161_0==PERCENT) ) {
					alt161=1;
				}

				switch (alt161) {
				case 1 :
					// PhoenixSQL.g:942:10: op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression
					{
					op=input.LT(1);
					if ( input.LA(1)==ASTERISK||input.LA(1)==DIVIDE||input.LA(1)==PERCENT ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					pushFollow(FOLLOW_negate_expression_in_multiply_divide_modulo_expression6872);
					rhs=negate_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            l = Arrays.asList(lhs, rhs); 
					            // determine the expression type based on the operator found
					            lhs = op.getType() == ASTERISK ? factory.multiply(l)
					                : op.getType() == DIVIDE   ? factory.divide(l)
					                : factory.modulus(l);
					            }
					}
					break;

				default :
					break loop161;
				}
			}

			if ( state.backtracking==0 ) { ret = lhs; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "multiply_divide_modulo_expression"



	// $ANTLR start "use_schema_node"
	// PhoenixSQL.g:953:1: use_schema_node returns [UseSchemaStatement ret] : USE ( DEFAULT |s= identifier ) ;
	public final UseSchemaStatement use_schema_node() throws RecognitionException {
		UseSchemaStatement ret = null;


		String s =null;

		try {
			// PhoenixSQL.g:954:2: ( USE ( DEFAULT |s= identifier ) )
			// PhoenixSQL.g:954:6: USE ( DEFAULT |s= identifier )
			{
			match(input,USE,FOLLOW_USE_in_use_schema_node6915); if (state.failed) return ret;
			// PhoenixSQL.g:954:10: ( DEFAULT |s= identifier )
			int alt162=2;
			int LA162_0 = input.LA(1);
			if ( (LA162_0==DEFAULT) ) {
				alt162=1;
			}
			else if ( (LA162_0==NAME) ) {
				alt162=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 162, 0, input);
				throw nvae;
			}

			switch (alt162) {
				case 1 :
					// PhoenixSQL.g:954:11: DEFAULT
					{
					match(input,DEFAULT,FOLLOW_DEFAULT_in_use_schema_node6918); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:954:21: s= identifier
					{
					pushFollow(FOLLOW_identifier_in_use_schema_node6924);
					s=identifier();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.useSchema(s); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "use_schema_node"



	// $ANTLR start "negate_expression"
	// PhoenixSQL.g:958:1: negate_expression returns [ParseNode ret] : (m= MINUS )? e= array_expression ;
	public final ParseNode negate_expression() throws RecognitionException {
		ParseNode ret = null;


		Token m=null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:959:5: ( (m= MINUS )? e= array_expression )
			// PhoenixSQL.g:959:9: (m= MINUS )? e= array_expression
			{
			// PhoenixSQL.g:959:10: (m= MINUS )?
			int alt163=2;
			int LA163_0 = input.LA(1);
			if ( (LA163_0==MINUS) ) {
				alt163=1;
			}
			switch (alt163) {
				case 1 :
					// PhoenixSQL.g:959:10: m= MINUS
					{
					m=(Token)match(input,MINUS,FOLLOW_MINUS_in_negate_expression6960); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_array_expression_in_negate_expression6965);
			e=array_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = m==null ? e : factory.negate(e); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "negate_expression"



	// $ANTLR start "array_expression"
	// PhoenixSQL.g:963:1: array_expression returns [ParseNode ret] : e= term ( LSQUARE s= value_expression RSQUARE )? ;
	public final ParseNode array_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode e =null;
		ParseNode s =null;

		try {
			// PhoenixSQL.g:964:5: (e= term ( LSQUARE s= value_expression RSQUARE )? )
			// PhoenixSQL.g:964:9: e= term ( LSQUARE s= value_expression RSQUARE )?
			{
			pushFollow(FOLLOW_term_in_array_expression6993);
			e=term();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:964:16: ( LSQUARE s= value_expression RSQUARE )?
			int alt164=2;
			int LA164_0 = input.LA(1);
			if ( (LA164_0==LSQUARE) ) {
				alt164=1;
			}
			switch (alt164) {
				case 1 :
					// PhoenixSQL.g:964:17: LSQUARE s= value_expression RSQUARE
					{
					match(input,LSQUARE,FOLLOW_LSQUARE_in_array_expression6996); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_array_expression7000);
					s=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RSQUARE,FOLLOW_RSQUARE_in_array_expression7002); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { if (s == null) { ret = e; } else { ret = factory.arrayElemRef(Arrays.<ParseNode>asList(e,s)); } }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "array_expression"



	// $ANTLR start "term"
	// PhoenixSQL.g:967:1: term returns [ParseNode ret] : (e= literal_or_bind |field= identifier |ex= ARRAY LSQUARE v= one_or_more_expressions RSQUARE |tableName= table_name DOT field= identifier |field= identifier LPAREN l= zero_or_more_expressions RPAREN wg= ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )? |field= identifier LPAREN t= ASTERISK RPAREN |field= identifier LPAREN t= DISTINCT l= zero_or_more_expressions RPAREN |e= case_statement | LPAREN l= one_or_more_expressions RPAREN | CAST LPAREN e= expression AS dt= identifier ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )? ar= ( ARRAY | ( LSQUARE RSQUARE ) )? RPAREN | (n= NEXT | CURRENT ) VALUE FOR s= from_table_name | (n= NEXT ) lorb= literal_or_bind VALUES FOR s= from_table_name );
	public final ParseNode term() throws RecognitionException {
		ParseNode ret = null;


		Token ex=null;
		Token a=null;
		Token wg=null;
		Token t=null;
		Token length=null;
		Token scale=null;
		Token ar=null;
		Token n=null;
		ParseNode e =null;
		String field =null;
		List<ParseNode> v =null;
		TableName tableName =null;
		List<ParseNode> l =null;
		List<ParseNode> l2 =null;
		String dt =null;
		TableName s =null;
		ParseNode lorb =null;

		try {
			// PhoenixSQL.g:968:5: (e= literal_or_bind |field= identifier |ex= ARRAY LSQUARE v= one_or_more_expressions RSQUARE |tableName= table_name DOT field= identifier |field= identifier LPAREN l= zero_or_more_expressions RPAREN wg= ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )? |field= identifier LPAREN t= ASTERISK RPAREN |field= identifier LPAREN t= DISTINCT l= zero_or_more_expressions RPAREN |e= case_statement | LPAREN l= one_or_more_expressions RPAREN | CAST LPAREN e= expression AS dt= identifier ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )? ar= ( ARRAY | ( LSQUARE RSQUARE ) )? RPAREN | (n= NEXT | CURRENT ) VALUE FOR s= from_table_name | (n= NEXT ) lorb= literal_or_bind VALUES FOR s= from_table_name )
			int alt171=12;
			switch ( input.LA(1) ) {
			case BIND_NAME:
			case DECIMAL:
			case DOUBLE:
			case FALSE:
			case NULL:
			case NUMBER:
			case QUESTION:
			case STRING_LITERAL:
			case TRUE:
				{
				alt171=1;
				}
				break;
			case NAME:
				{
				switch ( input.LA(2) ) {
				case STRING_LITERAL:
					{
					alt171=1;
					}
					break;
				case EOF:
				case AND:
				case AS:
				case ASC:
				case ASTERISK:
				case BETWEEN:
				case CACHE:
				case COMMA:
				case CONCAT:
				case CONSTRAINT:
				case CYCLE:
				case DESC:
				case DIVIDE:
				case ELSE:
				case END:
				case EQ:
				case FETCH:
				case FROM:
				case FULL:
				case GROUP:
				case GT:
				case HAVING:
				case ILIKE:
				case IN:
				case INCREMENT:
				case INNER:
				case IS:
				case JOIN:
				case LEFT:
				case LIKE:
				case LIMIT:
				case LSQUARE:
				case LT:
				case MAXVALUE:
				case MINUS:
				case MINVALUE:
				case NAME:
				case NOEQ1:
				case NOEQ2:
				case NOT:
				case NULLS:
				case OFFSET:
				case OR:
				case ORDER:
				case PERCENT:
				case PLUS:
				case PRIMARY:
				case RIGHT:
				case RPAREN:
				case RSQUARE:
				case SEMICOLON:
				case THEN:
				case UNION:
				case WHEN:
				case WHERE:
					{
					alt171=2;
					}
					break;
				case DOT:
					{
					alt171=4;
					}
					break;
				case LPAREN:
					{
					switch ( input.LA(3) ) {
					case ASTERISK:
						{
						alt171=6;
						}
						break;
					case DISTINCT:
						{
						alt171=7;
						}
						break;
					case ARRAY:
					case BIND_NAME:
					case CASE:
					case CAST:
					case COMMA:
					case CURRENT:
					case DECIMAL:
					case DOUBLE:
					case EXISTS:
					case FALSE:
					case LPAREN:
					case MINUS:
					case NAME:
					case NEXT:
					case NOT:
					case NULL:
					case NUMBER:
					case QUESTION:
					case RPAREN:
					case STRING_LITERAL:
					case TRUE:
						{
						alt171=5;
						}
						break;
					default:
						if (state.backtracking>0) {state.failed=true; return ret;}
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 171, 11, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 171, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case ARRAY:
				{
				alt171=3;
				}
				break;
			case CASE:
				{
				alt171=8;
				}
				break;
			case LPAREN:
				{
				alt171=9;
				}
				break;
			case CAST:
				{
				alt171=10;
				}
				break;
			case NEXT:
				{
				int LA171_7 = input.LA(2);
				if ( (LA171_7==VALUE) ) {
					alt171=11;
				}
				else if ( (LA171_7==BIND_NAME||LA171_7==DECIMAL||LA171_7==DOUBLE||LA171_7==FALSE||LA171_7==NAME||LA171_7==NULL||LA171_7==NUMBER||LA171_7==QUESTION||LA171_7==STRING_LITERAL||LA171_7==TRUE) ) {
					alt171=12;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 171, 7, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case CURRENT:
				{
				alt171=11;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 171, 0, input);
				throw nvae;
			}
			switch (alt171) {
				case 1 :
					// PhoenixSQL.g:968:9: e= literal_or_bind
					{
					pushFollow(FOLLOW_literal_or_bind_in_term7035);
					e=literal_or_bind();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = e; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:969:9: field= identifier
					{
					pushFollow(FOLLOW_identifier_in_term7049);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.column(null,field,field); }
					}
					break;
				case 3 :
					// PhoenixSQL.g:970:9: ex= ARRAY LSQUARE v= one_or_more_expressions RSQUARE
					{
					ex=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_term7063); if (state.failed) return ret;
					match(input,LSQUARE,FOLLOW_LSQUARE_in_term7065); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_term7069);
					v=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RSQUARE,FOLLOW_RSQUARE_in_term7071); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.upsertStmtArrayNode(v);}
					}
					break;
				case 4 :
					// PhoenixSQL.g:971:9: tableName= table_name DOT field= identifier
					{
					pushFollow(FOLLOW_table_name_in_term7085);
					tableName=table_name();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_term7087); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_term7091);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.column(tableName, field, field); }
					}
					break;
				case 5 :
					// PhoenixSQL.g:972:9: field= identifier LPAREN l= zero_or_more_expressions RPAREN wg= ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )?
					{
					pushFollow(FOLLOW_identifier_in_term7105);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term7107); if (state.failed) return ret;
					pushFollow(FOLLOW_zero_or_more_expressions_in_term7111);
					l=zero_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term7113); if (state.failed) return ret;
					// PhoenixSQL.g:972:70: ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )?
					int alt166=2;
					int LA166_0 = input.LA(1);
					if ( (LA166_0==WITHIN) ) {
						alt166=1;
					}
					switch (alt166) {
						case 1 :
							// PhoenixSQL.g:972:71: WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN
							{
							wg=(Token)match(input,WITHIN,FOLLOW_WITHIN_in_term7118); if (state.failed) return ret;
							wg=(Token)match(input,GROUP,FOLLOW_GROUP_in_term7120); if (state.failed) return ret;
							wg=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_term7122); if (state.failed) return ret;
							wg=(Token)match(input,ORDER,FOLLOW_ORDER_in_term7124); if (state.failed) return ret;
							wg=(Token)match(input,BY,FOLLOW_BY_in_term7126); if (state.failed) return ret;
							pushFollow(FOLLOW_one_or_more_expressions_in_term7130);
							l2=one_or_more_expressions();
							state._fsp--;
							if (state.failed) return ret;
							// PhoenixSQL.g:972:127: (a= ASC | DESC )
							int alt165=2;
							int LA165_0 = input.LA(1);
							if ( (LA165_0==ASC) ) {
								alt165=1;
							}
							else if ( (LA165_0==DESC) ) {
								alt165=2;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 165, 0, input);
								throw nvae;
							}

							switch (alt165) {
								case 1 :
									// PhoenixSQL.g:972:128: a= ASC
									{
									a=(Token)match(input,ASC,FOLLOW_ASC_in_term7135); if (state.failed) return ret;
									}
									break;
								case 2 :
									// PhoenixSQL.g:972:136: DESC
									{
									wg=(Token)match(input,DESC,FOLLOW_DESC_in_term7139); if (state.failed) return ret;
									}
									break;

							}

							wg=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_term7142); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) {
					            FunctionParseNode f = wg==null ? factory.function(field, l) : factory.function(field,l,l2,a!=null);
					            if (!contextStack.isEmpty()) {
					            	contextStack.peek().setAggregate(f.isAggregate());
					            }
					            if(f instanceof UDFParseNode) udfParseNodes.put(f.getName(),(UDFParseNode)f);
					            ret = f;
					        }
					}
					break;
				case 6 :
					// PhoenixSQL.g:981:9: field= identifier LPAREN t= ASTERISK RPAREN
					{
					pushFollow(FOLLOW_identifier_in_term7167);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term7169); if (state.failed) return ret;
					t=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_term7173); if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term7175); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            if (!isCountFunction(field)) {
					                throwRecognitionException(t);
					            }
					            FunctionParseNode f = factory.function(field, LiteralParseNode.STAR);
					            if (!contextStack.isEmpty()) {
					            	contextStack.peek().setAggregate(f.isAggregate());
					            }
					            if(f instanceof UDFParseNode) udfParseNodes.put(f.getName(),(UDFParseNode)f);
					            ret = f;
					        }
					}
					break;
				case 7 :
					// PhoenixSQL.g:993:9: field= identifier LPAREN t= DISTINCT l= zero_or_more_expressions RPAREN
					{
					pushFollow(FOLLOW_identifier_in_term7199);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term7201); if (state.failed) return ret;
					t=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_term7205); if (state.failed) return ret;
					pushFollow(FOLLOW_zero_or_more_expressions_in_term7209);
					l=zero_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term7211); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            FunctionParseNode f = factory.functionDistinct(field, l);
					            if (!contextStack.isEmpty()) {
					            	contextStack.peek().setAggregate(f.isAggregate());
					            }
					            if(f instanceof UDFParseNode) udfParseNodes.put(f.getName(),(UDFParseNode)f);
					            ret = f;
					        }
					}
					break;
				case 8 :
					// PhoenixSQL.g:1002:9: e= case_statement
					{
					pushFollow(FOLLOW_case_statement_in_term7234);
					e=case_statement();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = e; }
					}
					break;
				case 9 :
					// PhoenixSQL.g:1003:9: LPAREN l= one_or_more_expressions RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_term7246); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_term7250);
					l=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term7252); if (state.failed) return ret;
					if ( state.backtracking==0 ) { 
					    		if(l.size() == 1) {
					    			ret = l.get(0);
					    		}	
					    		else {
					    			ret = factory.rowValueConstructor(l);
					    		}	 
					    	}
					}
					break;
				case 10 :
					// PhoenixSQL.g:1012:9: CAST LPAREN e= expression AS dt= identifier ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )? ar= ( ARRAY | ( LSQUARE RSQUARE ) )? RPAREN
					{
					match(input,CAST,FOLLOW_CAST_in_term7270); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term7272); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_term7276);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,AS,FOLLOW_AS_in_term7278); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_term7282);
					dt=identifier();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:1012:51: ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )?
					int alt168=2;
					int LA168_0 = input.LA(1);
					if ( (LA168_0==LPAREN) ) {
						alt168=1;
					}
					switch (alt168) {
						case 1 :
							// PhoenixSQL.g:1012:52: LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN
							{
							match(input,LPAREN,FOLLOW_LPAREN_in_term7285); if (state.failed) return ret;
							length=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_term7289); if (state.failed) return ret;
							// PhoenixSQL.g:1012:73: ( COMMA scale= NUMBER )?
							int alt167=2;
							int LA167_0 = input.LA(1);
							if ( (LA167_0==COMMA) ) {
								alt167=1;
							}
							switch (alt167) {
								case 1 :
									// PhoenixSQL.g:1012:74: COMMA scale= NUMBER
									{
									match(input,COMMA,FOLLOW_COMMA_in_term7292); if (state.failed) return ret;
									scale=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_term7296); if (state.failed) return ret;
									}
									break;

							}

							match(input,RPAREN,FOLLOW_RPAREN_in_term7300); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:1012:107: ( ARRAY | ( LSQUARE RSQUARE ) )?
					int alt169=3;
					int LA169_0 = input.LA(1);
					if ( (LA169_0==ARRAY) ) {
						alt169=1;
					}
					else if ( (LA169_0==LSQUARE) ) {
						alt169=2;
					}
					switch (alt169) {
						case 1 :
							// PhoenixSQL.g:1012:108: ARRAY
							{
							ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_term7307); if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:1012:116: ( LSQUARE RSQUARE )
							{
							// PhoenixSQL.g:1012:116: ( LSQUARE RSQUARE )
							// PhoenixSQL.g:1012:117: LSQUARE RSQUARE
							{
							ar=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_term7312); if (state.failed) return ret;
							ar=(Token)match(input,RSQUARE,FOLLOW_RSQUARE_in_term7314); if (state.failed) return ret;
							}

							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_term7319); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.cast(e, dt,
					                     length == null ? null : Integer.parseInt(length.getText()),
					                     scale == null ? null : Integer.parseInt(scale.getText()),
					                     ar!=null);
					        }
					}
					break;
				case 11 :
					// PhoenixSQL.g:1018:9: (n= NEXT | CURRENT ) VALUE FOR s= from_table_name
					{
					// PhoenixSQL.g:1018:9: (n= NEXT | CURRENT )
					int alt170=2;
					int LA170_0 = input.LA(1);
					if ( (LA170_0==NEXT) ) {
						alt170=1;
					}
					else if ( (LA170_0==CURRENT) ) {
						alt170=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 170, 0, input);
						throw nvae;
					}

					switch (alt170) {
						case 1 :
							// PhoenixSQL.g:1018:10: n= NEXT
							{
							n=(Token)match(input,NEXT,FOLLOW_NEXT_in_term7342); if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:1018:19: CURRENT
							{
							match(input,CURRENT,FOLLOW_CURRENT_in_term7346); if (state.failed) return ret;
							}
							break;

					}

					match(input,VALUE,FOLLOW_VALUE_in_term7349); if (state.failed) return ret;
					match(input,FOR,FOLLOW_FOR_in_term7351); if (state.failed) return ret;
					pushFollow(FOLLOW_from_table_name_in_term7355);
					s=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { contextStack.peek().hasSequences(true);
					          ret = n==null ? factory.currentValueFor(s) : factory.nextValueFor(s, null); }
					}
					break;
				case 12 :
					// PhoenixSQL.g:1021:9: (n= NEXT ) lorb= literal_or_bind VALUES FOR s= from_table_name
					{
					// PhoenixSQL.g:1021:9: (n= NEXT )
					// PhoenixSQL.g:1021:10: n= NEXT
					{
					n=(Token)match(input,NEXT,FOLLOW_NEXT_in_term7383); if (state.failed) return ret;
					}

					pushFollow(FOLLOW_literal_or_bind_in_term7388);
					lorb=literal_or_bind();
					state._fsp--;
					if (state.failed) return ret;
					match(input,VALUES,FOLLOW_VALUES_in_term7390); if (state.failed) return ret;
					match(input,FOR,FOLLOW_FOR_in_term7392); if (state.failed) return ret;
					pushFollow(FOLLOW_from_table_name_in_term7396);
					s=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { contextStack.peek().hasSequences(true);
					          ret = factory.nextValueFor(s, lorb); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "term"



	// $ANTLR start "one_or_more_expressions"
	// PhoenixSQL.g:1026:1: one_or_more_expressions returns [List<ParseNode> ret] : e= expression ( COMMA e= expression )* ;
	public final List<ParseNode> one_or_more_expressions() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode e =null;

		ret = new ArrayList<ParseNode>(); 
		try {
			// PhoenixSQL.g:1028:5: (e= expression ( COMMA e= expression )* )
			// PhoenixSQL.g:1028:8: e= expression ( COMMA e= expression )*
			{
			pushFollow(FOLLOW_expression_in_one_or_more_expressions7441);
			e=expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(e);}
			// PhoenixSQL.g:1028:39: ( COMMA e= expression )*
			loop172:
			while (true) {
				int alt172=2;
				int LA172_0 = input.LA(1);
				if ( (LA172_0==COMMA) ) {
					alt172=1;
				}

				switch (alt172) {
				case 1 :
					// PhoenixSQL.g:1028:40: COMMA e= expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_one_or_more_expressions7447); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_one_or_more_expressions7453);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(e);}
					}
					break;

				default :
					break loop172;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "one_or_more_expressions"



	// $ANTLR start "one_or_more_jarpaths"
	// PhoenixSQL.g:1031:1: one_or_more_jarpaths returns [List<LiteralParseNode> ret] : jarPath= jar_path ( COMMA jarPath= jar_path )* ;
	public final List<LiteralParseNode> one_or_more_jarpaths() throws RecognitionException {
		List<LiteralParseNode> ret = null;


		LiteralParseNode jarPath =null;

		ret = new ArrayList<LiteralParseNode>(); 
		try {
			// PhoenixSQL.g:1033:5: (jarPath= jar_path ( COMMA jarPath= jar_path )* )
			// PhoenixSQL.g:1033:8: jarPath= jar_path ( COMMA jarPath= jar_path )*
			{
			pushFollow(FOLLOW_jar_path_in_one_or_more_jarpaths7484);
			jarPath=jar_path();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(jarPath);}
			// PhoenixSQL.g:1033:49: ( COMMA jarPath= jar_path )*
			loop173:
			while (true) {
				int alt173=2;
				int LA173_0 = input.LA(1);
				if ( (LA173_0==COMMA) ) {
					alt173=1;
				}

				switch (alt173) {
				case 1 :
					// PhoenixSQL.g:1033:50: COMMA jarPath= jar_path
					{
					match(input,COMMA,FOLLOW_COMMA_in_one_or_more_jarpaths7490); if (state.failed) return ret;
					pushFollow(FOLLOW_jar_path_in_one_or_more_jarpaths7496);
					jarPath=jar_path();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(jarPath);}
					}
					break;

				default :
					break loop173;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "one_or_more_jarpaths"



	// $ANTLR start "zero_or_more_expressions"
	// PhoenixSQL.g:1036:1: zero_or_more_expressions returns [List<ParseNode> ret] : (v= expression )? ( COMMA v= expression )* ;
	public final List<ParseNode> zero_or_more_expressions() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode v =null;

		ret = new ArrayList<ParseNode>(); 
		try {
			// PhoenixSQL.g:1038:5: ( (v= expression )? ( COMMA v= expression )* )
			// PhoenixSQL.g:1038:8: (v= expression )? ( COMMA v= expression )*
			{
			// PhoenixSQL.g:1038:8: (v= expression )?
			int alt174=2;
			int LA174_0 = input.LA(1);
			if ( (LA174_0==ARRAY||LA174_0==BIND_NAME||(LA174_0 >= CASE && LA174_0 <= CAST)||LA174_0==CURRENT||LA174_0==DECIMAL||LA174_0==DOUBLE||LA174_0==EXISTS||LA174_0==FALSE||LA174_0==LPAREN||LA174_0==MINUS||(LA174_0 >= NAME && LA174_0 <= NEXT)||(LA174_0 >= NOT && LA174_0 <= NULL)||LA174_0==NUMBER||LA174_0==QUESTION||LA174_0==STRING_LITERAL||LA174_0==TRUE) ) {
				alt174=1;
			}
			switch (alt174) {
				case 1 :
					// PhoenixSQL.g:1038:9: v= expression
					{
					pushFollow(FOLLOW_expression_in_zero_or_more_expressions7529);
					v=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

			}

			// PhoenixSQL.g:1038:42: ( COMMA v= expression )*
			loop175:
			while (true) {
				int alt175=2;
				int LA175_0 = input.LA(1);
				if ( (LA175_0==COMMA) ) {
					alt175=1;
				}

				switch (alt175) {
				case 1 :
					// PhoenixSQL.g:1038:43: COMMA v= expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_zero_or_more_expressions7537); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_zero_or_more_expressions7543);
					v=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop175;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "zero_or_more_expressions"



	// $ANTLR start "zero_or_more_data_types"
	// PhoenixSQL.g:1041:1: zero_or_more_data_types returns [List<FunctionArgument> ret] : (fa= function_argument )? ( COMMA fa= function_argument )* ;
	public final List<FunctionArgument> zero_or_more_data_types() throws RecognitionException {
		List<FunctionArgument> ret = null;


		FunctionArgument fa =null;

		ret = new ArrayList<FunctionArgument>(); 
		try {
			// PhoenixSQL.g:1043:5: ( (fa= function_argument )? ( COMMA fa= function_argument )* )
			// PhoenixSQL.g:1043:7: (fa= function_argument )? ( COMMA fa= function_argument )*
			{
			// PhoenixSQL.g:1043:7: (fa= function_argument )?
			int alt176=2;
			int LA176_0 = input.LA(1);
			if ( (LA176_0==NAME) ) {
				alt176=1;
			}
			switch (alt176) {
				case 1 :
					// PhoenixSQL.g:1043:8: fa= function_argument
					{
					pushFollow(FOLLOW_function_argument_in_zero_or_more_data_types7574);
					fa=function_argument();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(fa);}
					}
					break;

			}

			// PhoenixSQL.g:1043:49: ( COMMA fa= function_argument )*
			loop177:
			while (true) {
				int alt177=2;
				int LA177_0 = input.LA(1);
				if ( (LA177_0==COMMA) ) {
					alt177=1;
				}

				switch (alt177) {
				case 1 :
					// PhoenixSQL.g:1043:50: COMMA fa= function_argument
					{
					match(input,COMMA,FOLLOW_COMMA_in_zero_or_more_data_types7581); if (state.failed) return ret;
					pushFollow(FOLLOW_function_argument_in_zero_or_more_data_types7587);
					fa=function_argument();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(fa);}
					}
					break;

				default :
					break loop177;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "zero_or_more_data_types"



	// $ANTLR start "function_argument"
	// PhoenixSQL.g:1046:1: function_argument returns [FunctionArgument ret] : (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? ) ;
	public final FunctionArgument function_argument() throws RecognitionException {
		FunctionArgument ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		Token c=null;
		String dt =null;
		ParseNode dv =null;
		ParseNode minv =null;
		ParseNode maxv =null;

		try {
			// PhoenixSQL.g:1047:2: ( (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? ) )
			// PhoenixSQL.g:1047:4: (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? )
			{
			// PhoenixSQL.g:1047:4: (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? )
			// PhoenixSQL.g:1047:5: dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )?
			{
			pushFollow(FOLLOW_identifier_in_function_argument7612);
			dt=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:1047:21: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
			int alt179=2;
			int LA179_0 = input.LA(1);
			if ( (LA179_0==LPAREN) ) {
				alt179=1;
			}
			switch (alt179) {
				case 1 :
					// PhoenixSQL.g:1047:22: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_function_argument7615); if (state.failed) return ret;
					l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_function_argument7619); if (state.failed) return ret;
					// PhoenixSQL.g:1047:38: ( COMMA s= NUMBER )?
					int alt178=2;
					int LA178_0 = input.LA(1);
					if ( (LA178_0==COMMA) ) {
						alt178=1;
					}
					switch (alt178) {
						case 1 :
							// PhoenixSQL.g:1047:39: COMMA s= NUMBER
							{
							match(input,COMMA,FOLLOW_COMMA_in_function_argument7622); if (state.failed) return ret;
							s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_function_argument7626); if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_function_argument7630); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1047:67: (ar= ARRAY )?
			int alt180=2;
			int LA180_0 = input.LA(1);
			if ( (LA180_0==ARRAY) ) {
				alt180=1;
			}
			switch (alt180) {
				case 1 :
					// PhoenixSQL.g:1047:67: ar= ARRAY
					{
					ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_function_argument7636); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1047:75: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			int alt182=2;
			int LA182_0 = input.LA(1);
			if ( (LA182_0==LSQUARE) ) {
				alt182=1;
			}
			switch (alt182) {
				case 1 :
					// PhoenixSQL.g:1047:76: lsq= LSQUARE (a= NUMBER )? RSQUARE
					{
					lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_function_argument7642); if (state.failed) return ret;
					// PhoenixSQL.g:1047:88: (a= NUMBER )?
					int alt181=2;
					int LA181_0 = input.LA(1);
					if ( (LA181_0==NUMBER) ) {
						alt181=1;
					}
					switch (alt181) {
						case 1 :
							// PhoenixSQL.g:1047:89: a= NUMBER
							{
							a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_function_argument7647); if (state.failed) return ret;
							}
							break;

					}

					match(input,RSQUARE,FOLLOW_RSQUARE_in_function_argument7651); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1047:110: (c= CONSTANT )?
			int alt183=2;
			int LA183_0 = input.LA(1);
			if ( (LA183_0==CONSTANT) ) {
				alt183=1;
			}
			switch (alt183) {
				case 1 :
					// PhoenixSQL.g:1047:111: c= CONSTANT
					{
					c=(Token)match(input,CONSTANT,FOLLOW_CONSTANT_in_function_argument7660); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1047:126: ( DEFAULTVALUE EQ dv= expression )?
			int alt184=2;
			int LA184_0 = input.LA(1);
			if ( (LA184_0==DEFAULTVALUE) ) {
				alt184=1;
			}
			switch (alt184) {
				case 1 :
					// PhoenixSQL.g:1047:127: DEFAULTVALUE EQ dv= expression
					{
					match(input,DEFAULTVALUE,FOLLOW_DEFAULTVALUE_in_function_argument7665); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_function_argument7667); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_function_argument7673);
					dv=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1047:161: ( MINVALUE EQ minv= expression )?
			int alt185=2;
			int LA185_0 = input.LA(1);
			if ( (LA185_0==MINVALUE) ) {
				alt185=1;
			}
			switch (alt185) {
				case 1 :
					// PhoenixSQL.g:1047:162: MINVALUE EQ minv= expression
					{
					match(input,MINVALUE,FOLLOW_MINVALUE_in_function_argument7678); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_function_argument7680); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_function_argument7686);
					minv=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1047:195: ( MAXVALUE EQ maxv= expression )?
			int alt186=2;
			int LA186_0 = input.LA(1);
			if ( (LA186_0==MAXVALUE) ) {
				alt186=1;
			}
			switch (alt186) {
				case 1 :
					// PhoenixSQL.g:1047:196: MAXVALUE EQ maxv= expression
					{
					match(input,MAXVALUE,FOLLOW_MAXVALUE_in_function_argument7692); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_function_argument7694); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_function_argument7700);
					maxv=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = new FunctionArgument(dt,  ar != null || lsq != null, c!=null, 
			    dv == null ? null : LiteralExpression.newConstant(((LiteralParseNode)dv).getValue()), 
			    minv == null ? null : LiteralExpression.newConstant(((LiteralParseNode)minv).getValue()), 
			    maxv == null ? null : LiteralExpression.newConstant(((LiteralParseNode)maxv).getValue()));}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "function_argument"



	// $ANTLR start "value_expression_list"
	// PhoenixSQL.g:1054:1: value_expression_list returns [List<ParseNode> ret] : LPAREN e= value_expression ( COMMA e= value_expression )* RPAREN ;
	public final List<ParseNode> value_expression_list() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode e =null;

		ret = new ArrayList<ParseNode>(); 
		try {
			// PhoenixSQL.g:1056:5: ( LPAREN e= value_expression ( COMMA e= value_expression )* RPAREN )
			// PhoenixSQL.g:1056:8: LPAREN e= value_expression ( COMMA e= value_expression )* RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_value_expression_list7730); if (state.failed) return ret;
			pushFollow(FOLLOW_value_expression_in_value_expression_list7736);
			e=value_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(e);}
			// PhoenixSQL.g:1056:52: ( COMMA e= value_expression )*
			loop187:
			while (true) {
				int alt187=2;
				int LA187_0 = input.LA(1);
				if ( (LA187_0==COMMA) ) {
					alt187=1;
				}

				switch (alt187) {
				case 1 :
					// PhoenixSQL.g:1056:53: COMMA e= value_expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_value_expression_list7742); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_value_expression_list7748);
					e=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(e);}
					}
					break;

				default :
					break loop187;
				}
			}

			match(input,RPAREN,FOLLOW_RPAREN_in_value_expression_list7755); if (state.failed) return ret;
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "value_expression_list"



	// $ANTLR start "index_name"
	// PhoenixSQL.g:1059:1: index_name returns [NamedNode ret] : name= identifier ;
	public final NamedNode index_name() throws RecognitionException {
		NamedNode ret = null;


		String name =null;

		try {
			// PhoenixSQL.g:1060:5: (name= identifier )
			// PhoenixSQL.g:1060:9: name= identifier
			{
			pushFollow(FOLLOW_identifier_in_index_name7776);
			name=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.indexName(name); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "index_name"



	// $ANTLR start "cursor_name"
	// PhoenixSQL.g:1063:1: cursor_name returns [CursorName ret] : name= identifier ;
	public final CursorName cursor_name() throws RecognitionException {
		CursorName ret = null;


		String name =null;

		try {
			// PhoenixSQL.g:1064:5: (name= identifier )
			// PhoenixSQL.g:1064:9: name= identifier
			{
			pushFollow(FOLLOW_identifier_in_cursor_name7803);
			name=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.cursorName(name);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_name"



	// $ANTLR start "table_name"
	// PhoenixSQL.g:1068:1: table_name returns [TableName ret] : (t= identifier |s= identifier DOT t= identifier );
	public final TableName table_name() throws RecognitionException {
		TableName ret = null;


		String t =null;
		String s =null;

		try {
			// PhoenixSQL.g:1069:5: (t= identifier |s= identifier DOT t= identifier )
			int alt188=2;
			int LA188_0 = input.LA(1);
			if ( (LA188_0==NAME) ) {
				int LA188_1 = input.LA(2);
				if ( (LA188_1==DOT) ) {
					int LA188_2 = input.LA(3);
					if ( (LA188_2==NAME) ) {
						int LA188_3 = input.LA(4);
						if ( (LA188_3==EOF||LA188_3==AND||(LA188_3 >= AS && LA188_3 <= ASTERISK)||LA188_3==BETWEEN||LA188_3==CACHE||LA188_3==COMMA||LA188_3==CONCAT||LA188_3==CONSTRAINT||LA188_3==CYCLE||LA188_3==DESC||LA188_3==DIVIDE||(LA188_3 >= ELSE && LA188_3 <= END)||LA188_3==EQ||LA188_3==FETCH||(LA188_3 >= FROM && LA188_3 <= FULL)||(LA188_3 >= GROUP && LA188_3 <= HAVING)||LA188_3==ILIKE||LA188_3==IN||LA188_3==INCREMENT||LA188_3==INNER||LA188_3==IS||LA188_3==JOIN||LA188_3==LEFT||(LA188_3 >= LIKE && LA188_3 <= LIMIT)||(LA188_3 >= LSQUARE && LA188_3 <= MINVALUE)||LA188_3==NAME||(LA188_3 >= NOEQ1 && LA188_3 <= NOT)||LA188_3==NULLS||LA188_3==OFFSET||(LA188_3 >= OR && LA188_3 <= ORDER)||(LA188_3 >= PERCENT && LA188_3 <= PLUS)||LA188_3==PRIMARY||LA188_3==RIGHT||(LA188_3 >= RPAREN && LA188_3 <= RSQUARE)||LA188_3==SEMICOLON||LA188_3==THEN||LA188_3==UNION||(LA188_3 >= WHEN && LA188_3 <= WHERE)) ) {
							alt188=1;
						}
						else if ( (LA188_3==DOT) ) {
							alt188=2;
						}

						else {
							if (state.backtracking>0) {state.failed=true; return ret;}
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 188, 3, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 188, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 188, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 188, 0, input);
				throw nvae;
			}

			switch (alt188) {
				case 1 :
					// PhoenixSQL.g:1069:9: t= identifier
					{
					pushFollow(FOLLOW_identifier_in_table_name7831);
					t=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(null, t); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1070:9: s= identifier DOT t= identifier
					{
					pushFollow(FOLLOW_identifier_in_table_name7845);
					s=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_table_name7847); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_table_name7851);
					t=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(s, t); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_name"



	// $ANTLR start "from_table_name"
	// PhoenixSQL.g:1074:1: from_table_name returns [TableName ret] : (t= identifier |s= identifier DOT t= identifier );
	public final TableName from_table_name() throws RecognitionException {
		TableName ret = null;


		String t =null;
		String s =null;

		try {
			// PhoenixSQL.g:1075:5: (t= identifier |s= identifier DOT t= identifier )
			int alt189=2;
			int LA189_0 = input.LA(1);
			if ( (LA189_0==NAME) ) {
				int LA189_1 = input.LA(2);
				if ( (LA189_1==EOF||(LA189_1 >= ACTIVE && LA189_1 <= ALL)||LA189_1==AND||(LA189_1 >= AS && LA189_1 <= ASTERISK)||LA189_1==BETWEEN||(LA189_1 >= CACHE && LA189_1 <= CASCADE)||(LA189_1 >= COLUMNS && LA189_1 <= COMMA)||LA189_1==CONCAT||LA189_1==CONSTRAINT||LA189_1==CYCLE||LA189_1==DESC||LA189_1==DISABLE||LA189_1==DIVIDE||LA189_1==DROP||(LA189_1 >= ELSE && LA189_1 <= END)||LA189_1==EQ||LA189_1==FETCH||(LA189_1 >= FROM && LA189_1 <= FULL)||(LA189_1 >= GROUP && LA189_1 <= HAVING)||LA189_1==ILIKE||LA189_1==IN||(LA189_1 >= INCREMENT && LA189_1 <= INNER)||LA189_1==IS||LA189_1==JOIN||LA189_1==LEFT||(LA189_1 >= LIKE && LA189_1 <= LIMIT)||(LA189_1 >= LPAREN && LA189_1 <= MINVALUE)||LA189_1==NAME||(LA189_1 >= NOEQ1 && LA189_1 <= NOT)||LA189_1==NULLS||(LA189_1 >= OFFSET && LA189_1 <= ON)||(LA189_1 >= OR && LA189_1 <= ORDER)||(LA189_1 >= PERCENT && LA189_1 <= PLUS)||LA189_1==PRIMARY||LA189_1==REBUILD||LA189_1==RIGHT||(LA189_1 >= RPAREN && LA189_1 <= RSQUARE)||(LA189_1 >= SELECT && LA189_1 <= SEMICOLON)||LA189_1==SET||LA189_1==START||LA189_1==THEN||(LA189_1 >= UNION && LA189_1 <= UNUSABLE)||LA189_1==USABLE||LA189_1==VALUES||(LA189_1 >= WHEN && LA189_1 <= WHERE)) ) {
					alt189=1;
				}
				else if ( (LA189_1==DOT) ) {
					alt189=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 189, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 189, 0, input);
				throw nvae;
			}

			switch (alt189) {
				case 1 :
					// PhoenixSQL.g:1075:9: t= identifier
					{
					pushFollow(FOLLOW_identifier_in_from_table_name7879);
					t=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(null, t); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1076:9: s= identifier DOT t= identifier
					{
					pushFollow(FOLLOW_identifier_in_from_table_name7893);
					s=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_from_table_name7895); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_from_table_name7899);
					t=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(s, t); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "from_table_name"



	// $ANTLR start "literal_or_bind"
	// PhoenixSQL.g:1080:1: literal_or_bind returns [ParseNode ret] : (e= literal |b= bind_name );
	public final ParseNode literal_or_bind() throws RecognitionException {
		ParseNode ret = null;


		LiteralParseNode e =null;
		String b =null;

		try {
			// PhoenixSQL.g:1081:5: (e= literal |b= bind_name )
			int alt190=2;
			int LA190_0 = input.LA(1);
			if ( (LA190_0==DECIMAL||LA190_0==DOUBLE||LA190_0==FALSE||LA190_0==NAME||LA190_0==NULL||LA190_0==NUMBER||LA190_0==STRING_LITERAL||LA190_0==TRUE) ) {
				alt190=1;
			}
			else if ( (LA190_0==BIND_NAME||LA190_0==QUESTION) ) {
				alt190=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 190, 0, input);
				throw nvae;
			}

			switch (alt190) {
				case 1 :
					// PhoenixSQL.g:1081:9: e= literal
					{
					pushFollow(FOLLOW_literal_in_literal_or_bind7931);
					e=literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = e; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1082:9: b= bind_name
					{
					pushFollow(FOLLOW_bind_name_in_literal_or_bind7945);
					b=bind_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.bind(b); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "literal_or_bind"



	// $ANTLR start "literal"
	// PhoenixSQL.g:1086:1: literal returns [LiteralParseNode ret] : (s= STRING_LITERAL |n= NUMBER |d= DECIMAL |dbl= DOUBLE | NULL | TRUE | FALSE |dt= identifier t= STRING_LITERAL );
	public final LiteralParseNode literal() throws RecognitionException {
		LiteralParseNode ret = null;


		Token s=null;
		Token n=null;
		Token d=null;
		Token dbl=null;
		Token t=null;
		String dt =null;

		try {
			// PhoenixSQL.g:1087:5: (s= STRING_LITERAL |n= NUMBER |d= DECIMAL |dbl= DOUBLE | NULL | TRUE | FALSE |dt= identifier t= STRING_LITERAL )
			int alt191=8;
			switch ( input.LA(1) ) {
			case STRING_LITERAL:
				{
				alt191=1;
				}
				break;
			case NUMBER:
				{
				alt191=2;
				}
				break;
			case DECIMAL:
				{
				alt191=3;
				}
				break;
			case DOUBLE:
				{
				alt191=4;
				}
				break;
			case NULL:
				{
				alt191=5;
				}
				break;
			case TRUE:
				{
				alt191=6;
				}
				break;
			case FALSE:
				{
				alt191=7;
				}
				break;
			case NAME:
				{
				alt191=8;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 191, 0, input);
				throw nvae;
			}
			switch (alt191) {
				case 1 :
					// PhoenixSQL.g:1087:9: s= STRING_LITERAL
					{
					s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_literal7977); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.literal(s.getText()); 
					        }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1090:9: n= NUMBER
					{
					n=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_literal7991); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.wholeNumber(n.getText());
					        }
					}
					break;
				case 3 :
					// PhoenixSQL.g:1093:9: d= DECIMAL
					{
					d=(Token)match(input,DECIMAL,FOLLOW_DECIMAL_in_literal8005); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.realNumber(d.getText());
					        }
					}
					break;
				case 4 :
					// PhoenixSQL.g:1096:9: dbl= DOUBLE
					{
					dbl=(Token)match(input,DOUBLE,FOLLOW_DOUBLE_in_literal8020); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.literal(Double.valueOf(dbl.getText()));
					        }
					}
					break;
				case 5 :
					// PhoenixSQL.g:1099:9: NULL
					{
					match(input,NULL,FOLLOW_NULL_in_literal8037); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.literal(null);}
					}
					break;
				case 6 :
					// PhoenixSQL.g:1100:9: TRUE
					{
					match(input,TRUE,FOLLOW_TRUE_in_literal8049); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.literal(Boolean.TRUE);}
					}
					break;
				case 7 :
					// PhoenixSQL.g:1101:9: FALSE
					{
					match(input,FALSE,FOLLOW_FALSE_in_literal8062); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.literal(Boolean.FALSE);}
					}
					break;
				case 8 :
					// PhoenixSQL.g:1102:9: dt= identifier t= STRING_LITERAL
					{
					pushFollow(FOLLOW_identifier_in_literal8076);
					dt=identifier();
					state._fsp--;
					if (state.failed) return ret;
					t=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_literal8080); if (state.failed) return ret;
					if ( state.backtracking==0 ) { 
					            try {
					                ret = factory.literal(t.getText(), dt);
					            } catch (SQLException e) {
					                throw new RuntimeException(e);
					            }
					        }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "literal"



	// $ANTLR start "int_or_long_literal"
	// PhoenixSQL.g:1111:1: int_or_long_literal returns [LiteralParseNode ret] : n= NUMBER ;
	public final LiteralParseNode int_or_long_literal() throws RecognitionException {
		LiteralParseNode ret = null;


		Token n=null;

		try {
			// PhoenixSQL.g:1112:5: (n= NUMBER )
			// PhoenixSQL.g:1112:9: n= NUMBER
			{
			n=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_int_or_long_literal8111); if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			            ret = factory.intOrLong(n.getText());
			        }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "int_or_long_literal"



	// $ANTLR start "bind_name"
	// PhoenixSQL.g:1118:1: bind_name returns [String ret] : (n= BIND_NAME | QUESTION );
	public final String bind_name() throws RecognitionException {
		String ret = null;


		Token n=null;

		try {
			// PhoenixSQL.g:1119:5: (n= BIND_NAME | QUESTION )
			int alt192=2;
			int LA192_0 = input.LA(1);
			if ( (LA192_0==BIND_NAME) ) {
				alt192=1;
			}
			else if ( (LA192_0==QUESTION) ) {
				alt192=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 192, 0, input);
				throw nvae;
			}

			switch (alt192) {
				case 1 :
					// PhoenixSQL.g:1119:9: n= BIND_NAME
					{
					n=(Token)match(input,BIND_NAME,FOLLOW_BIND_NAME_in_bind_name8139); if (state.failed) return ret;
					if ( state.backtracking==0 ) { String bind = n.getText().substring(1); updateBind(bind); ret = bind; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1120:9: QUESTION
					{
					match(input,QUESTION,FOLLOW_QUESTION_in_bind_name8152); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = nextBind(); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "bind_name"



	// $ANTLR start "identifier"
	// PhoenixSQL.g:1124:1: identifier returns [String ret] : c= parseNoReserved ;
	public final String identifier() throws RecognitionException {
		String ret = null;


		String c =null;

		try {
			// PhoenixSQL.g:1125:5: (c= parseNoReserved )
			// PhoenixSQL.g:1125:9: c= parseNoReserved
			{
			pushFollow(FOLLOW_parseNoReserved_in_identifier8181);
			c=parseNoReserved();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = c; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "identifier"



	// $ANTLR start "parseNoReserved"
	// PhoenixSQL.g:1128:1: parseNoReserved returns [String ret] : n= NAME ;
	public final String parseNoReserved() throws RecognitionException {
		String ret = null;


		Token n=null;

		try {
			// PhoenixSQL.g:1129:5: (n= NAME )
			// PhoenixSQL.g:1129:9: n= NAME
			{
			n=(Token)match(input,NAME,FOLLOW_NAME_in_parseNoReserved8208); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = n.getText(); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseNoReserved"



	// $ANTLR start "case_statement"
	// PhoenixSQL.g:1132:1: case_statement returns [ParseNode ret] : ( CASE e1= expression ( WHEN e2= expression THEN t= expression )+ ( ELSE el= expression )? END | CASE ( WHEN c= expression THEN t= expression )+ ( ELSE el= expression )? END );
	public final ParseNode case_statement() throws RecognitionException {
		ParseNode ret = null;


		ParseNode e1 =null;
		ParseNode e2 =null;
		ParseNode t =null;
		ParseNode el =null;
		ParseNode c =null;

		List<ParseNode> w = new ArrayList<ParseNode>(4);
		try {
			// PhoenixSQL.g:1134:5: ( CASE e1= expression ( WHEN e2= expression THEN t= expression )+ ( ELSE el= expression )? END | CASE ( WHEN c= expression THEN t= expression )+ ( ELSE el= expression )? END )
			int alt197=2;
			int LA197_0 = input.LA(1);
			if ( (LA197_0==CASE) ) {
				int LA197_1 = input.LA(2);
				if ( (LA197_1==ARRAY||LA197_1==BIND_NAME||(LA197_1 >= CASE && LA197_1 <= CAST)||LA197_1==CURRENT||LA197_1==DECIMAL||LA197_1==DOUBLE||LA197_1==EXISTS||LA197_1==FALSE||LA197_1==LPAREN||LA197_1==MINUS||(LA197_1 >= NAME && LA197_1 <= NEXT)||(LA197_1 >= NOT && LA197_1 <= NULL)||LA197_1==NUMBER||LA197_1==QUESTION||LA197_1==STRING_LITERAL||LA197_1==TRUE) ) {
					alt197=1;
				}
				else if ( (LA197_1==WHEN) ) {
					alt197=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 197, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 197, 0, input);
				throw nvae;
			}

			switch (alt197) {
				case 1 :
					// PhoenixSQL.g:1134:7: CASE e1= expression ( WHEN e2= expression THEN t= expression )+ ( ELSE el= expression )? END
					{
					match(input,CASE,FOLLOW_CASE_in_case_statement8235); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_case_statement8239);
					e1=expression();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:1134:26: ( WHEN e2= expression THEN t= expression )+
					int cnt193=0;
					loop193:
					while (true) {
						int alt193=2;
						int LA193_0 = input.LA(1);
						if ( (LA193_0==WHEN) ) {
							alt193=1;
						}

						switch (alt193) {
						case 1 :
							// PhoenixSQL.g:1134:27: WHEN e2= expression THEN t= expression
							{
							match(input,WHEN,FOLLOW_WHEN_in_case_statement8242); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8246);
							e2=expression();
							state._fsp--;
							if (state.failed) return ret;
							match(input,THEN,FOLLOW_THEN_in_case_statement8248); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8252);
							t=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(t);w.add(factory.equal(e1,e2));}
							}
							break;

						default :
							if ( cnt193 >= 1 ) break loop193;
							if (state.backtracking>0) {state.failed=true; return ret;}
							EarlyExitException eee = new EarlyExitException(193, input);
							throw eee;
						}
						cnt193++;
					}

					// PhoenixSQL.g:1134:106: ( ELSE el= expression )?
					int alt194=2;
					int LA194_0 = input.LA(1);
					if ( (LA194_0==ELSE) ) {
						alt194=1;
					}
					switch (alt194) {
						case 1 :
							// PhoenixSQL.g:1134:107: ELSE el= expression
							{
							match(input,ELSE,FOLLOW_ELSE_in_case_statement8259); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8263);
							el=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(el);}
							}
							break;

					}

					match(input,END,FOLLOW_END_in_case_statement8269); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.caseWhen(w);}
					}
					break;
				case 2 :
					// PhoenixSQL.g:1135:7: CASE ( WHEN c= expression THEN t= expression )+ ( ELSE el= expression )? END
					{
					match(input,CASE,FOLLOW_CASE_in_case_statement8279); if (state.failed) return ret;
					// PhoenixSQL.g:1135:12: ( WHEN c= expression THEN t= expression )+
					int cnt195=0;
					loop195:
					while (true) {
						int alt195=2;
						int LA195_0 = input.LA(1);
						if ( (LA195_0==WHEN) ) {
							alt195=1;
						}

						switch (alt195) {
						case 1 :
							// PhoenixSQL.g:1135:13: WHEN c= expression THEN t= expression
							{
							match(input,WHEN,FOLLOW_WHEN_in_case_statement8282); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8286);
							c=expression();
							state._fsp--;
							if (state.failed) return ret;
							match(input,THEN,FOLLOW_THEN_in_case_statement8288); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8292);
							t=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(t);w.add(c);}
							}
							break;

						default :
							if ( cnt195 >= 1 ) break loop195;
							if (state.backtracking>0) {state.failed=true; return ret;}
							EarlyExitException eee = new EarlyExitException(195, input);
							throw eee;
						}
						cnt195++;
					}

					// PhoenixSQL.g:1135:72: ( ELSE el= expression )?
					int alt196=2;
					int LA196_0 = input.LA(1);
					if ( (LA196_0==ELSE) ) {
						alt196=1;
					}
					switch (alt196) {
						case 1 :
							// PhoenixSQL.g:1135:73: ELSE el= expression
							{
							match(input,ELSE,FOLLOW_ELSE_in_case_statement8299); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8303);
							el=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(el);}
							}
							break;

					}

					match(input,END,FOLLOW_END_in_case_statement8309); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.caseWhen(w);}
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "case_statement"

	// $ANTLR start synpred1_PhoenixSQL
	public final void synpred1_PhoenixSQL_fragment() throws RecognitionException {
		// PhoenixSQL.g:888:9: ( ( NOT )? boolean_expression )
		// PhoenixSQL.g:888:10: ( NOT )? boolean_expression
		{
		// PhoenixSQL.g:888:10: ( NOT )?
		int alt198=2;
		int LA198_0 = input.LA(1);
		if ( (LA198_0==NOT) ) {
			alt198=1;
		}
		switch (alt198) {
			case 1 :
				// PhoenixSQL.g:888:10: NOT
				{
				match(input,NOT,FOLLOW_NOT_in_synpred1_PhoenixSQL6006); if (state.failed) return;
				}
				break;

		}

		pushFollow(FOLLOW_boolean_expression_in_synpred1_PhoenixSQL6009);
		boolean_expression();
		state._fsp--;
		if (state.failed) return;
		}

	}
	// $ANTLR end synpred1_PhoenixSQL

	// Delegated rules

	public final boolean synpred1_PhoenixSQL() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred1_PhoenixSQL_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}



	public static final BitSet FOLLOW_oneStatement_in_nextStatement1235 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_SEMICOLON_in_nextStatement1239 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EOF_in_nextStatement1248 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_oneStatement_in_statement1274 = new BitSet(new long[]{0x0000000000000000L});
	public static final BitSet FOLLOW_EOF_in_statement1278 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_select_node_in_query1304 = new BitSet(new long[]{0x0000000000000000L});
	public static final BitSet FOLLOW_EOF_in_query1306 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_select_node_in_oneStatement1338 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_upsert_node_in_oneStatement1348 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_delete_node_in_oneStatement1360 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_table_node_in_oneStatement1372 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_schema_node_in_oneStatement1384 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_view_node_in_oneStatement1396 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_index_node_in_oneStatement1408 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cursor_open_node_in_oneStatement1420 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cursor_close_node_in_oneStatement1432 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cursor_fetch_node_in_oneStatement1444 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_declare_cursor_node_in_oneStatement1456 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_table_node_in_oneStatement1468 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_index_node_in_oneStatement1480 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alter_index_node_in_oneStatement1492 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alter_table_node_in_oneStatement1504 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_trace_node_in_oneStatement1516 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_function_node_in_oneStatement1528 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_function_node_in_oneStatement1540 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_add_jars_node_in_oneStatement1552 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_list_jars_node_in_oneStatement1564 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_delete_jar_node_in_oneStatement1576 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alter_session_node_in_oneStatement1588 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_sequence_node_in_oneStatement1598 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_sequence_node_in_oneStatement1608 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_schema_node_in_oneStatement1618 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_use_schema_node_in_oneStatement1628 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_update_statistics_node_in_oneStatement1640 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_execute_upgrade_node_in_oneStatement1652 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_explain_node_in_oneStatement1664 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXPLAIN_in_explain_node1697 = new BitSet(new long[]{0x50401208020000A0L,0x0080000200000002L,0x0000015100004000L});
	public static final BitSet FOLLOW_oneStatement_in_explain_node1701 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_table_node1727 = new BitSet(new long[]{0x0000000000000000L,0x0000000000008000L,0x0000000008000000L});
	public static final BitSet FOLLOW_IMMUTABLE_in_create_table_node1732 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_TABLE_in_create_table_node1736 = new BitSet(new long[]{0x0000000000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_IF_in_create_table_node1739 = new BitSet(new long[]{0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_NOT_in_create_table_node1741 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_create_table_node1745 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_table_node1751 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_table_node1763 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_column_defs_in_create_table_node1767 = new BitSet(new long[]{0x0000000420000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_pk_constraint_in_create_table_node1772 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_create_table_node1776 = new BitSet(new long[]{0x0000000000000002L,0x0000080000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_fam_properties_in_create_table_node1790 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_SPLIT_in_create_table_node1803 = new BitSet(new long[]{0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_ON_in_create_table_node1805 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_value_expression_list_in_create_table_node1809 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_schema_node1848 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_SCHEMA_in_create_schema_node1850 = new BitSet(new long[]{0x0000040000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_IF_in_create_schema_node1853 = new BitSet(new long[]{0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_NOT_in_create_schema_node1855 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_create_schema_node1859 = new BitSet(new long[]{0x0000040000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_DEFAULT_in_create_schema_node1864 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_create_schema_node1870 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_view_node1905 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_VIEW_in_create_view_node1907 = new BitSet(new long[]{0x0000000000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_IF_in_create_view_node1910 = new BitSet(new long[]{0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_NOT_in_create_view_node1912 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_create_view_node1916 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_view_node1922 = new BitSet(new long[]{0x0000000000000802L,0x0000080800000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_view_node1934 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_column_defs_in_create_view_node1938 = new BitSet(new long[]{0x0000000420000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_pk_constraint_in_create_view_node1943 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_create_view_node1947 = new BitSet(new long[]{0x0000000000000802L,0x0000080000000000L});
	public static final BitSet FOLLOW_AS_in_create_view_node1961 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_SELECT_in_create_view_node1963 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_create_view_node1965 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_FROM_in_create_view_node1977 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_view_node1981 = new BitSet(new long[]{0x0000000000000002L,0x0000080000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_WHERE_in_create_view_node1994 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_expression_in_create_view_node1998 = new BitSet(new long[]{0x0000000000000002L,0x0000080000000000L});
	public static final BitSet FOLLOW_fam_properties_in_create_view_node2016 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_index_node2052 = new BitSet(new long[]{0x0000000000000000L,0x0000000400080000L});
	public static final BitSet FOLLOW_LOCAL_in_create_index_node2056 = new BitSet(new long[]{0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_INDEX_in_create_index_node2059 = new BitSet(new long[]{0x0000000000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_IF_in_create_index_node2062 = new BitSet(new long[]{0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_NOT_in_create_index_node2064 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_create_index_node2068 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_index_name_in_create_index_node2074 = new BitSet(new long[]{0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_ON_in_create_index_node2076 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_index_node2080 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_index_node2091 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_ik_constraint_in_create_index_node2095 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_create_index_node2097 = new BitSet(new long[]{0x0000000000004002L,0x0000080000020000L,0x0000000000800000L});
	public static final BitSet FOLLOW_INCLUDE_in_create_index_node2109 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_index_node2112 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_column_names_in_create_index_node2116 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_create_index_node2118 = new BitSet(new long[]{0x0000000000004002L,0x0000080000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_ASYNC_in_create_index_node2134 = new BitSet(new long[]{0x0000000000000002L,0x0000080000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_fam_properties_in_create_index_node2149 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_SPLIT_in_create_index_node2162 = new BitSet(new long[]{0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_ON_in_create_index_node2164 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_value_expression_list_in_create_index_node2168 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_sequence_node2204 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_SEQUENCE_in_create_sequence_node2206 = new BitSet(new long[]{0x0000000000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_IF_in_create_sequence_node2210 = new BitSet(new long[]{0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_NOT_in_create_sequence_node2212 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_create_sequence_node2216 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_sequence_node2222 = new BitSet(new long[]{0x0000004000080002L,0x0000014000040000L,0x0000000001000000L});
	public static final BitSet FOLLOW_START_in_create_sequence_node2233 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000800204000002L});
	public static final BitSet FOLLOW_WITH_in_create_sequence_node2235 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node2240 = new BitSet(new long[]{0x0000004000080002L,0x0000014000040000L});
	public static final BitSet FOLLOW_INCREMENT_in_create_sequence_node2253 = new BitSet(new long[]{0x0008011000660400L,0x0005188800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_BY_in_create_sequence_node2255 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node2260 = new BitSet(new long[]{0x0000004000080002L,0x0000014000000000L});
	public static final BitSet FOLLOW_MINVALUE_in_create_sequence_node2273 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node2277 = new BitSet(new long[]{0x0000004000080002L,0x0000004000000000L});
	public static final BitSet FOLLOW_MAXVALUE_in_create_sequence_node2290 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node2294 = new BitSet(new long[]{0x0000004000080002L});
	public static final BitSet FOLLOW_CYCLE_in_create_sequence_node2309 = new BitSet(new long[]{0x0000000000080002L});
	public static final BitSet FOLLOW_CACHE_in_create_sequence_node2323 = new BitSet(new long[]{0x0000000000020000L,0x0004000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_int_literal_or_bind_in_create_sequence_node2327 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_int_or_long_literal_in_int_literal_or_bind2358 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_expression_in_int_literal_or_bind2370 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_sequence_node2396 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_SEQUENCE_in_drop_sequence_node2398 = new BitSet(new long[]{0x0000000000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_IF_in_drop_sequence_node2402 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_drop_sequence_node2406 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_drop_sequence_node2412 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COMMA_in_pk_constraint2441 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_CONSTRAINT_in_pk_constraint2444 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_pk_constraint2448 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_PRIMARY_in_pk_constraint2450 = new BitSet(new long[]{0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_KEY_in_pk_constraint2452 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_pk_constraint2454 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_col_name_with_sort_order_rowtimestamp_list_in_pk_constraint2458 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_pk_constraint2460 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list2491 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_col_name_with_sort_order_rowtimestamp_list2497 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list2503 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_identifier_in_col_name_with_sort_order_rowtimestamp2530 = new BitSet(new long[]{0x0000200000001002L,0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_ASC_in_col_name_with_sort_order_rowtimestamp2535 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_DESC_in_col_name_with_sort_order_rowtimestamp2539 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_ROW_TIMESTAMP_in_col_name_with_sort_order_rowtimestamp2546 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_with_sort_order_list_in_ik_constraint2581 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list2608 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_expression_with_sort_order_list2614 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list2620 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_expression_in_expression_with_sort_order2647 = new BitSet(new long[]{0x0000200000001002L});
	public static final BitSet FOLLOW_ASC_in_expression_with_sort_order2653 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DESC_in_expression_with_sort_order2657 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_fam_prop_name_in_fam_properties2685 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_fam_properties2687 = new BitSet(new long[]{0x0008010000000000L,0x0005080000000001L,0x0000000204000000L});
	public static final BitSet FOLLOW_prop_value_in_fam_properties2691 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_fam_properties2697 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_fam_prop_name_in_fam_properties2701 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_fam_properties2703 = new BitSet(new long[]{0x0008010000000000L,0x0005080000000001L,0x0000000204000000L});
	public static final BitSet FOLLOW_prop_value_in_fam_properties2707 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_identifier_in_fam_prop_name2737 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_fam_prop_name2751 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_fam_prop_name2753 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_fam_prop_name2757 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_prop_value2788 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_prop_value2802 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_column_name2833 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_column_name2847 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_column_name2849 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_column_name2853 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_column_name_in_column_names2885 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_column_names2891 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_column_name_in_column_names2897 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_DROP_in_drop_table_node2924 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100008000000L});
	public static final BitSet FOLLOW_VIEW_in_drop_table_node2929 = new BitSet(new long[]{0x0000000000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_TABLE_in_drop_table_node2933 = new BitSet(new long[]{0x0000000000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_IF_in_drop_table_node2937 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_drop_table_node2941 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_drop_table_node2947 = new BitSet(new long[]{0x0000000000100002L});
	public static final BitSet FOLLOW_CASCADE_in_drop_table_node2952 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_schema_node2987 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_SCHEMA_in_drop_schema_node2989 = new BitSet(new long[]{0x0000000000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_IF_in_drop_schema_node2992 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_drop_schema_node2996 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_drop_schema_node3002 = new BitSet(new long[]{0x0000000000100002L});
	public static final BitSet FOLLOW_CASCADE_in_drop_schema_node3007 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_index_node3042 = new BitSet(new long[]{0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_INDEX_in_drop_index_node3044 = new BitSet(new long[]{0x0000000000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_IF_in_drop_index_node3047 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_drop_index_node3051 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_index_name_in_drop_index_node3057 = new BitSet(new long[]{0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_ON_in_drop_index_node3059 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_drop_index_node3063 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALTER_in_alter_index_node3093 = new BitSet(new long[]{0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_INDEX_in_alter_index_node3095 = new BitSet(new long[]{0x0000000000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_IF_in_alter_index_node3098 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_alter_index_node3102 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_index_name_in_alter_index_node3108 = new BitSet(new long[]{0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_ON_in_alter_index_node3110 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_alter_index_node3114 = new BitSet(new long[]{0x0000800000000010L,0x0000000000000000L,0x0000008800000008L});
	public static final BitSet FOLLOW_set_in_alter_index_node3118 = new BitSet(new long[]{0x0000000000004002L});
	public static final BitSet FOLLOW_ASYNC_in_alter_index_node3141 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRACE_in_trace_node3175 = new BitSet(new long[]{0x0000000000000000L,0x0028000000000000L});
	public static final BitSet FOLLOW_ON_in_trace_node3183 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_WITH_in_trace_node3188 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_SAMPLING_in_trace_node3190 = new BitSet(new long[]{0x0008010000000000L,0x0005080000000001L,0x0000000204000000L});
	public static final BitSet FOLLOW_sampling_rate_in_trace_node3196 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OFF_in_trace_node3207 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_function_node3241 = new BitSet(new long[]{0x0000000000000000L,0x0100000000000080L,0x0000000020000000L});
	public static final BitSet FOLLOW_OR_in_create_function_node3244 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_REPLACE_in_create_function_node3248 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L,0x0000000020000000L});
	public static final BitSet FOLLOW_TEMPORARY_in_create_function_node3255 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_FUNCTION_in_create_function_node3259 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_create_function_node3263 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_function_node3274 = new BitSet(new long[]{0x0000000020000000L,0x0000080000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_zero_or_more_data_types_in_create_function_node3278 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_create_function_node3280 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_RETURNS_in_create_function_node3290 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_create_function_node3294 = new BitSet(new long[]{0x0000000000000800L});
	public static final BitSet FOLLOW_AS_in_create_function_node3296 = new BitSet(new long[]{0x0008010000000000L,0x0005080000000001L,0x0000000204000000L});
	public static final BitSet FOLLOW_jar_path_in_create_function_node3302 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000020000000000L});
	public static final BitSet FOLLOW_USING_in_create_function_node3313 = new BitSet(new long[]{0x0000000000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_JAR_in_create_function_node3315 = new BitSet(new long[]{0x0008010000000000L,0x0005080000000001L,0x0000000204000000L});
	public static final BitSet FOLLOW_jar_path_in_create_function_node3322 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_jar_path3359 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_function_node3382 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_FUNCTION_in_drop_function_node3384 = new BitSet(new long[]{0x0000000000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_IF_in_drop_function_node3387 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_drop_function_node3391 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_drop_function_node3397 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ADD_in_add_jars_node3420 = new BitSet(new long[]{0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_JARS_in_add_jars_node3422 = new BitSet(new long[]{0x0008010000000000L,0x0005080000000001L,0x0000000204000000L});
	public static final BitSet FOLLOW_one_or_more_jarpaths_in_add_jars_node3428 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LIST_in_list_jars_node3451 = new BitSet(new long[]{0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_JARS_in_list_jars_node3453 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DELETE_in_delete_jar_node3476 = new BitSet(new long[]{0x0000000000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_JAR_in_delete_jar_node3478 = new BitSet(new long[]{0x0008010000000000L,0x0005080000000001L,0x0000000204000000L});
	public static final BitSet FOLLOW_jar_path_in_delete_jar_node3484 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALTER_in_alter_session_node3510 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_SESSION_in_alter_session_node3512 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_SET_in_alter_session_node3515 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_properties_in_alter_session_node3519 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALTER_in_alter_table_node3553 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100008000000L});
	public static final BitSet FOLLOW_TABLE_in_alter_table_node3556 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_VIEW_in_alter_table_node3562 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_alter_table_node3567 = new BitSet(new long[]{0x0040000000000020L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_DROP_in_alter_table_node3580 = new BitSet(new long[]{0x0000000008000000L});
	public static final BitSet FOLLOW_COLUMN_in_alter_table_node3582 = new BitSet(new long[]{0x0000000000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_IF_in_alter_table_node3585 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_alter_table_node3589 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_column_names_in_alter_table_node3595 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ADD_in_alter_table_node3601 = new BitSet(new long[]{0x0000000000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_IF_in_alter_table_node3604 = new BitSet(new long[]{0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_NOT_in_alter_table_node3606 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_alter_table_node3610 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_column_defs_in_alter_table_node3617 = new BitSet(new long[]{0x0000000000000002L,0x0000080000000000L});
	public static final BitSet FOLLOW_fam_properties_in_alter_table_node3623 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SET_in_alter_table_node3631 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_fam_properties_in_alter_table_node3636 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UPDATE_in_update_statistics_node3670 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_STATISTICS_in_update_statistics_node3672 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_update_statistics_node3676 = new BitSet(new long[]{0x0000000010000042L,0x0000000000080000L,0x0000000000040000L});
	public static final BitSet FOLLOW_INDEX_in_update_statistics_node3681 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_ALL_in_update_statistics_node3687 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_COLUMNS_in_update_statistics_node3693 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_SET_in_update_statistics_node3698 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_properties_in_update_statistics_node3703 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXECUTE_in_execute_upgrade_node3727 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_UPGRADE_in_execute_upgrade_node3729 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_prop_name3755 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prop_name_in_properties3789 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_properties3791 = new BitSet(new long[]{0x0008010000000000L,0x0005080000000001L,0x0000000204000000L});
	public static final BitSet FOLLOW_prop_value_in_properties3795 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_properties3801 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_prop_name_in_properties3805 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_properties3807 = new BitSet(new long[]{0x0008010000000000L,0x0005080000000001L,0x0000000204000000L});
	public static final BitSet FOLLOW_prop_value_in_properties3811 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_column_def_in_column_defs3846 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_column_defs3852 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_column_def_in_column_defs3858 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_column_name_in_column_def3884 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_column_def3888 = new BitSet(new long[]{0x0000040000000402L,0x0001801800000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_LPAREN_in_column_def3891 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_column_def3895 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_COMMA_in_column_def3898 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_column_def3902 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_column_def3906 = new BitSet(new long[]{0x0000040000000402L,0x0001801000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_ARRAY_in_column_def3912 = new BitSet(new long[]{0x0000040000000002L,0x0001801000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_LSQUARE_in_column_def3918 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_NUMBER_in_column_def3923 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RSQUARE_in_column_def3927 = new BitSet(new long[]{0x0000040000000002L,0x0001800000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_NOT_in_column_def3934 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_NULL_in_column_def3939 = new BitSet(new long[]{0x0000040000000002L,0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_DEFAULT_in_column_def3944 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_expression_in_column_def3948 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_PRIMARY_in_column_def3955 = new BitSet(new long[]{0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_KEY_in_column_def3957 = new BitSet(new long[]{0x0000200000001002L,0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_ASC_in_column_def3962 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_DESC_in_column_def3966 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_ROW_TIMESTAMP_in_column_def3972 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dyn_column_def_in_dyn_column_defs4015 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_dyn_column_defs4021 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_dyn_column_def_in_dyn_column_defs4027 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_column_name_in_dyn_column_def4053 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_dyn_column_def4057 = new BitSet(new long[]{0x0000000000000402L,0x0000001800000000L});
	public static final BitSet FOLLOW_LPAREN_in_dyn_column_def4060 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_def4064 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_COMMA_in_dyn_column_def4067 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_def4071 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_dyn_column_def4075 = new BitSet(new long[]{0x0000000000000402L,0x0000001000000000L});
	public static final BitSet FOLLOW_ARRAY_in_dyn_column_def4081 = new BitSet(new long[]{0x0000000000000002L,0x0000001000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_dyn_column_def4087 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_def4092 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RSQUARE_in_dyn_column_def4096 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_column_name_in_dyn_column_name_or_def4133 = new BitSet(new long[]{0x0000000000000002L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_dyn_column_name_or_def4138 = new BitSet(new long[]{0x0000000000000402L,0x0000001800000000L});
	public static final BitSet FOLLOW_LPAREN_in_dyn_column_name_or_def4141 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_name_or_def4145 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_COMMA_in_dyn_column_name_or_def4148 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_name_or_def4152 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_dyn_column_name_or_def4156 = new BitSet(new long[]{0x0000000000000402L,0x0000001000000000L});
	public static final BitSet FOLLOW_ARRAY_in_dyn_column_name_or_def4162 = new BitSet(new long[]{0x0000000000000002L,0x0000001000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_dyn_column_name_or_def4168 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_name_or_def4173 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RSQUARE_in_dyn_column_name_or_def4177 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_select_node_in_subquery_expression4217 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SELECT_in_single_select4250 = new BitSet(new long[]{0x2009011000622440L,0x00059C8800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_hintClause_in_single_select4255 = new BitSet(new long[]{0x2009011000622440L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_DISTINCT_in_single_select4271 = new BitSet(new long[]{0x2008011000622400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_ALL_in_single_select4275 = new BitSet(new long[]{0x2008011000622400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_select_list_in_single_select4281 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000520L,0x0000400000000000L});
	public static final BitSet FOLLOW_FROM_in_single_select4292 = new BitSet(new long[]{0x0000000000020000L,0x0000080800000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_parseFrom_in_single_select4296 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000500L,0x0000400000000000L});
	public static final BitSet FOLLOW_WHERE_in_single_select4309 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_expression_in_single_select4313 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000500L});
	public static final BitSet FOLLOW_GROUP_in_single_select4326 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_BY_in_single_select4328 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_group_by_in_single_select4332 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000400L});
	public static final BitSet FOLLOW_HAVING_in_single_select4345 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_expression_in_single_select4349 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_single_select_in_unioned_selects4393 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_UNION_in_unioned_selects4398 = new BitSet(new long[]{0x0000000000000040L});
	public static final BitSet FOLLOW_ALL_in_unioned_selects4400 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_single_select_in_unioned_selects4404 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_unioned_selects_in_select_node4442 = new BitSet(new long[]{0x0000000000000002L,0x0210000100000002L});
	public static final BitSet FOLLOW_ORDER_in_select_node4453 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_BY_in_select_node4455 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_order_by_in_select_node4459 = new BitSet(new long[]{0x0000000000000002L,0x0010000100000002L});
	public static final BitSet FOLLOW_LIMIT_in_select_node4472 = new BitSet(new long[]{0x0000000000020000L,0x0004000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_limit_in_select_node4476 = new BitSet(new long[]{0x0000000000000002L,0x0010000000000002L});
	public static final BitSet FOLLOW_OFFSET_in_select_node4489 = new BitSet(new long[]{0x0000000000020000L,0x0004000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_offset_in_select_node4493 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000002L,0x0000000000000180L});
	public static final BitSet FOLLOW_FETCH_in_select_node4515 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000008L});
	public static final BitSet FOLLOW_set_in_select_node4517 = new BitSet(new long[]{0x0000000000020000L,0x0004000000000000L,0x0000000000000182L});
	public static final BitSet FOLLOW_limit_in_select_node4528 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000180L});
	public static final BitSet FOLLOW_set_in_select_node4532 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_ONLY_in_select_node4540 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UPSERT_in_upsert_node4579 = new BitSet(new long[]{0x0000000000000000L,0x0000040000200000L});
	public static final BitSet FOLLOW_hintClause_in_upsert_node4584 = new BitSet(new long[]{0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_INTO_in_upsert_node4588 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_upsert_node4592 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L,0x0000080000004000L});
	public static final BitSet FOLLOW_LPAREN_in_upsert_node4603 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_upsert_column_refs_in_upsert_node4607 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_upsert_node4609 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000004000L});
	public static final BitSet FOLLOW_VALUES_in_upsert_node4623 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_upsert_node4625 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_upsert_node4629 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_upsert_node4631 = new BitSet(new long[]{0x0000000000000002L,0x0020000000000000L});
	public static final BitSet FOLLOW_ON_in_upsert_node4635 = new BitSet(new long[]{0x0080000000000000L});
	public static final BitSet FOLLOW_DUPLICATE_in_upsert_node4637 = new BitSet(new long[]{0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_KEY_in_upsert_node4639 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L,0x0000001000000000L});
	public static final BitSet FOLLOW_IGNORE_in_upsert_node4645 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UPDATE_in_upsert_node4651 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_update_column_pairs_in_upsert_node4655 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_select_node_in_upsert_node4670 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_update_column_pair_in_update_column_pairs4711 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_update_column_pairs4723 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_update_column_pair_in_update_column_pairs4727 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_column_name_in_update_column_pair4752 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_update_column_pair4754 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_expression_in_update_column_pair4758 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dyn_column_name_or_def_in_upsert_column_refs4787 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_upsert_column_refs4800 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_dyn_column_name_or_def_in_upsert_column_refs4804 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_DECLARE_in_declare_cursor_node4832 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_cursor_name_in_declare_cursor_node4836 = new BitSet(new long[]{0x0000002000000000L});
	public static final BitSet FOLLOW_CURSOR_in_declare_cursor_node4838 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_FOR_in_declare_cursor_node4840 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_select_node_in_declare_cursor_node4844 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_in_cursor_open_node4878 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_cursor_name_in_cursor_open_node4882 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CLOSE_in_cursor_close_node4909 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_cursor_name_in_cursor_close_node4913 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FETCH_in_cursor_fetch_node4939 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_NEXT_in_cursor_fetch_node4941 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000020L,0x0000000000000180L});
	public static final BitSet FOLLOW_NUMBER_in_cursor_fetch_node4946 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000020L,0x0000000000000180L});
	public static final BitSet FOLLOW_FROM_in_cursor_fetch_node4957 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_cursor_name_in_cursor_fetch_node4961 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DELETE_in_delete_node4987 = new BitSet(new long[]{0x0000000000000000L,0x0000040000000020L});
	public static final BitSet FOLLOW_hintClause_in_delete_node4992 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_FROM_in_delete_node4996 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_delete_node5000 = new BitSet(new long[]{0x0000000000000002L,0x0200000100000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_WHERE_in_delete_node5011 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_expression_in_delete_node5015 = new BitSet(new long[]{0x0000000000000002L,0x0200000100000000L});
	public static final BitSet FOLLOW_ORDER_in_delete_node5028 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_BY_in_delete_node5030 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_order_by_in_delete_node5034 = new BitSet(new long[]{0x0000000000000002L,0x0000000100000000L});
	public static final BitSet FOLLOW_LIMIT_in_delete_node5047 = new BitSet(new long[]{0x0000000000020000L,0x0004000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_limit_in_delete_node5051 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_expression_in_limit5086 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_int_or_long_literal_in_limit5098 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_expression_in_offset5124 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_int_or_long_literal_in_offset5136 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_sampling_rate5161 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ML_HINT_in_hintClause5187 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectable_in_select_list5219 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_select_list5224 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_selectable_in_select_list5228 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_ASTERISK_in_select_list5240 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_in_selectable5269 = new BitSet(new long[]{0x0000000000000802L,0x0000080000000000L});
	public static final BitSet FOLLOW_parseAlias_in_selectable5274 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_selectable5289 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_selectable5291 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_selectable5293 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_selectable5308 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_selectable5310 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_selectable5314 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_selectable5316 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_selectable5318 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_in_group_by5351 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_group_by5364 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_expression_in_group_by5370 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_parseOrderByField_in_order_by5404 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_order_by5417 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_parseOrderByField_in_order_by5423 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_expression_in_parseOrderByField5460 = new BitSet(new long[]{0x0000200000001002L,0x0002000000000000L});
	public static final BitSet FOLLOW_ASC_in_parseOrderByField5472 = new BitSet(new long[]{0x0000000000000002L,0x0002000000000000L});
	public static final BitSet FOLLOW_DESC_in_parseOrderByField5478 = new BitSet(new long[]{0x0000000000000002L,0x0002000000000000L});
	public static final BitSet FOLLOW_NULLS_in_parseOrderByField5493 = new BitSet(new long[]{0x0000000000000000L,0x0000000008000008L});
	public static final BitSet FOLLOW_FIRST_in_parseOrderByField5496 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LAST_in_parseOrderByField5502 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_list_in_parseFrom5542 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_ref_in_table_list5573 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_table_list5578 = new BitSet(new long[]{0x0000000000020000L,0x0000080800000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_table_ref_in_table_list5582 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_table_factor_in_table_ref5606 = new BitSet(new long[]{0x0000000000000002L,0x0000000022100040L,0x0000000000000040L});
	public static final BitSet FOLLOW_join_type_in_table_ref5613 = new BitSet(new long[]{0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_JOIN_in_table_ref5615 = new BitSet(new long[]{0x0000000000020000L,0x0000080800000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_table_factor_in_table_ref5619 = new BitSet(new long[]{0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_ON_in_table_ref5621 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_expression_in_table_ref5625 = new BitSet(new long[]{0x0000000000000002L,0x0000000022100040L,0x0000000000000040L});
	public static final BitSet FOLLOW_LPAREN_in_table_factor5649 = new BitSet(new long[]{0x0000000000020000L,0x0000080800000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_table_list_in_table_factor5653 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_table_factor5655 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_name_in_table_factor5669 = new BitSet(new long[]{0x0000000000000802L,0x0000080000000000L});
	public static final BitSet FOLLOW_AS_in_table_factor5673 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_table_factor5679 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_from_table_name_in_table_factor5696 = new BitSet(new long[]{0x0000000000000802L,0x0000080800000000L});
	public static final BitSet FOLLOW_AS_in_table_factor5700 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_table_factor5706 = new BitSet(new long[]{0x0000000000000002L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_table_factor5711 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_dyn_column_defs_in_table_factor5715 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_table_factor5717 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_table_factor5731 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_select_node_in_table_factor5735 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_table_factor5737 = new BitSet(new long[]{0x0000000000000802L,0x0000080000000000L});
	public static final BitSet FOLLOW_AS_in_table_factor5741 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_table_factor5747 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INNER_in_join_type5774 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LEFT_in_join_type5789 = new BitSet(new long[]{0x0000000000000002L,0x0800000000000000L});
	public static final BitSet FOLLOW_OUTER_in_join_type5791 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RIGHT_in_join_type5806 = new BitSet(new long[]{0x0000000000000002L,0x0800000000000000L});
	public static final BitSet FOLLOW_OUTER_in_join_type5808 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FULL_in_join_type5822 = new BitSet(new long[]{0x0000000000000002L,0x0800000000000000L});
	public static final BitSet FOLLOW_OUTER_in_join_type5825 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AS_in_parseAlias5856 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_parseNoReserved_in_parseAlias5861 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_or_expression_in_expression5889 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_and_expression_in_or_expression5921 = new BitSet(new long[]{0x0000000000000002L,0x0100000000000000L});
	public static final BitSet FOLLOW_OR_in_or_expression5926 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_and_expression_in_or_expression5930 = new BitSet(new long[]{0x0000000000000002L,0x0100000000000000L});
	public static final BitSet FOLLOW_not_expression_in_and_expression5966 = new BitSet(new long[]{0x0000000000000102L});
	public static final BitSet FOLLOW_AND_in_and_expression5971 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_not_expression_in_and_expression5975 = new BitSet(new long[]{0x0000000000000102L});
	public static final BitSet FOLLOW_NOT_in_not_expression6017 = new BitSet(new long[]{0x2008011000620400L,0x0005188800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_boolean_expression_in_not_expression6022 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_not_expression6036 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_not_expression6039 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_expression_in_not_expression6043 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_not_expression6045 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EQ_in_comparison_op6065 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LT_in_comparison_op6072 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GT_in_comparison_op6079 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LT_in_comparison_op6086 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_comparison_op6088 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GT_in_comparison_op6095 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_comparison_op6097 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_comparison_op6104 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6135 = new BitSet(new long[]{0x0800000000010002L,0x0000E02080414200L});
	public static final BitSet FOLLOW_comparison_op_in_boolean_expression6141 = new BitSet(new long[]{0x0008011000620640L,0x0005188800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6146 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6151 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression6155 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6157 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALL_in_boolean_expression6166 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_ANY_in_boolean_expression6172 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6175 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6179 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6181 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALL_in_boolean_expression6191 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_ANY_in_boolean_expression6197 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6200 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression6204 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6206 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IS_in_boolean_expression6236 = new BitSet(new long[]{0x0000000000000000L,0x0001800000000000L});
	public static final BitSet FOLLOW_NOT_in_boolean_expression6240 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_NULL_in_boolean_expression6243 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_boolean_expression6274 = new BitSet(new long[]{0x0000000000010000L,0x0000000080014000L});
	public static final BitSet FOLLOW_LIKE_in_boolean_expression6279 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6283 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ILIKE_in_boolean_expression6321 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6325 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BETWEEN_in_boolean_expression6363 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6367 = new BitSet(new long[]{0x0000000000000100L});
	public static final BitSet FOLLOW_AND_in_boolean_expression6369 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6373 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IN_in_boolean_expression6412 = new BitSet(new long[]{0x0000000000020000L,0x0000000800000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_bind_expression_in_boolean_expression6418 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6459 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression6463 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6465 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6506 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_boolean_expression6510 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6512 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXISTS_in_boolean_expression6612 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6614 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression6618 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6620 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_name_in_bind_expression6648 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_add_expression_in_value_expression6679 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_subtract_expression_in_add_expression6710 = new BitSet(new long[]{0x0000000000000002L,0x4000000000000000L});
	public static final BitSet FOLLOW_PLUS_in_add_expression6715 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_subtract_expression_in_add_expression6719 = new BitSet(new long[]{0x0000000000000002L,0x4000000000000000L});
	public static final BitSet FOLLOW_concat_expression_in_subtract_expression6754 = new BitSet(new long[]{0x0000000000000002L,0x0000008000000000L});
	public static final BitSet FOLLOW_MINUS_in_subtract_expression6759 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_concat_expression_in_subtract_expression6763 = new BitSet(new long[]{0x0000000000000002L,0x0000008000000000L});
	public static final BitSet FOLLOW_multiply_divide_modulo_expression_in_concat_expression6798 = new BitSet(new long[]{0x0000000100000002L});
	public static final BitSet FOLLOW_CONCAT_in_concat_expression6803 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_multiply_divide_modulo_expression_in_concat_expression6807 = new BitSet(new long[]{0x0000000100000002L});
	public static final BitSet FOLLOW_negate_expression_in_multiply_divide_modulo_expression6842 = new BitSet(new long[]{0x0002000000002002L,0x2000000000000000L});
	public static final BitSet FOLLOW_set_in_multiply_divide_modulo_expression6858 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_negate_expression_in_multiply_divide_modulo_expression6872 = new BitSet(new long[]{0x0002000000002002L,0x2000000000000000L});
	public static final BitSet FOLLOW_USE_in_use_schema_node6915 = new BitSet(new long[]{0x0000040000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_DEFAULT_in_use_schema_node6918 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_use_schema_node6924 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_in_negate_expression6960 = new BitSet(new long[]{0x0008011000620400L,0x0005180800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_array_expression_in_negate_expression6965 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_term_in_array_expression6993 = new BitSet(new long[]{0x0000000000000002L,0x0000001000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_array_expression6996 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_value_expression_in_array_expression7000 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RSQUARE_in_array_expression7002 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_or_bind_in_term7035 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term7049 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ARRAY_in_term7063 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_term7065 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_term7069 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RSQUARE_in_term7071 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_name_in_term7085 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_term7087 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_term7091 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term7105 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7107 = new BitSet(new long[]{0x2008011020620400L,0x0005988800000001L,0x0000000204000402L});
	public static final BitSet FOLLOW_zero_or_more_expressions_in_term7111 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_term7113 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_WITHIN_in_term7118 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000100L});
	public static final BitSet FOLLOW_GROUP_in_term7120 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7122 = new BitSet(new long[]{0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_ORDER_in_term7124 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_BY_in_term7126 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_term7130 = new BitSet(new long[]{0x0000200000001000L});
	public static final BitSet FOLLOW_ASC_in_term7135 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_DESC_in_term7139 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_term7142 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term7167 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7169 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_term7173 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_term7175 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term7199 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7201 = new BitSet(new long[]{0x0001000000000000L});
	public static final BitSet FOLLOW_DISTINCT_in_term7205 = new BitSet(new long[]{0x2008011020620400L,0x0005988800000001L,0x0000000204000402L});
	public static final BitSet FOLLOW_zero_or_more_expressions_in_term7209 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_term7211 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_case_statement_in_term7234 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_term7246 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_term7250 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_term7252 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CAST_in_term7270 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7272 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_expression_in_term7276 = new BitSet(new long[]{0x0000000000000800L});
	public static final BitSet FOLLOW_AS_in_term7278 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_term7282 = new BitSet(new long[]{0x0000000000000400L,0x0000001800000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_LPAREN_in_term7285 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_term7289 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_COMMA_in_term7292 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_term7296 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_term7300 = new BitSet(new long[]{0x0000000000000400L,0x0000001000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_ARRAY_in_term7307 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_LSQUARE_in_term7312 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RSQUARE_in_term7314 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_term7319 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NEXT_in_term7342 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000040000000000L});
	public static final BitSet FOLLOW_CURRENT_in_term7346 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000040000000000L});
	public static final BitSet FOLLOW_VALUE_in_term7349 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_FOR_in_term7351 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_term7355 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NEXT_in_term7383 = new BitSet(new long[]{0x0008010000020000L,0x0005080000000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_literal_or_bind_in_term7388 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_VALUES_in_term7390 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_FOR_in_term7392 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_term7396 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_in_one_or_more_expressions7441 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_one_or_more_expressions7447 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_expression_in_one_or_more_expressions7453 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_jar_path_in_one_or_more_jarpaths7484 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_one_or_more_jarpaths7490 = new BitSet(new long[]{0x0008010000000000L,0x0005080000000001L,0x0000000204000000L});
	public static final BitSet FOLLOW_jar_path_in_one_or_more_jarpaths7496 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_expression_in_zero_or_more_expressions7529 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_zero_or_more_expressions7537 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_expression_in_zero_or_more_expressions7543 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_function_argument_in_zero_or_more_data_types7574 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_zero_or_more_data_types7581 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_function_argument_in_zero_or_more_data_types7587 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_identifier_in_function_argument7612 = new BitSet(new long[]{0x0000080200000402L,0x0000015800000000L});
	public static final BitSet FOLLOW_LPAREN_in_function_argument7615 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_function_argument7619 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_COMMA_in_function_argument7622 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_function_argument7626 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_function_argument7630 = new BitSet(new long[]{0x0000080200000402L,0x0000015000000000L});
	public static final BitSet FOLLOW_ARRAY_in_function_argument7636 = new BitSet(new long[]{0x0000080200000002L,0x0000015000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_function_argument7642 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_NUMBER_in_function_argument7647 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RSQUARE_in_function_argument7651 = new BitSet(new long[]{0x0000080200000002L,0x0000014000000000L});
	public static final BitSet FOLLOW_CONSTANT_in_function_argument7660 = new BitSet(new long[]{0x0000080000000002L,0x0000014000000000L});
	public static final BitSet FOLLOW_DEFAULTVALUE_in_function_argument7665 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_function_argument7667 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_expression_in_function_argument7673 = new BitSet(new long[]{0x0000000000000002L,0x0000014000000000L});
	public static final BitSet FOLLOW_MINVALUE_in_function_argument7678 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_function_argument7680 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_expression_in_function_argument7686 = new BitSet(new long[]{0x0000000000000002L,0x0000004000000000L});
	public static final BitSet FOLLOW_MAXVALUE_in_function_argument7692 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_function_argument7694 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_expression_in_function_argument7700 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_value_expression_list7730 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_value_expression_in_value_expression_list7736 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_COMMA_in_value_expression_list7742 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_value_expression_in_value_expression_list7748 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_value_expression_list7755 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_index_name7776 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_cursor_name7803 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_table_name7831 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_table_name7845 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_table_name7847 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_table_name7851 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_from_table_name7879 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_from_table_name7893 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_from_table_name7895 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_from_table_name7899 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_literal_or_bind7931 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_name_in_literal_or_bind7945 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_literal7977 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NUMBER_in_literal7991 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DECIMAL_in_literal8005 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLE_in_literal8020 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NULL_in_literal8037 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRUE_in_literal8049 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FALSE_in_literal8062 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_literal8076 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_literal8080 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NUMBER_in_int_or_long_literal8111 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BIND_NAME_in_bind_name8139 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUESTION_in_bind_name8152 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_parseNoReserved_in_identifier8181 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_parseNoReserved8208 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CASE_in_case_statement8235 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_expression_in_case_statement8239 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_WHEN_in_case_statement8242 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_expression_in_case_statement8246 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_THEN_in_case_statement8248 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_expression_in_case_statement8252 = new BitSet(new long[]{0x0300000000000000L,0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_ELSE_in_case_statement8259 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_expression_in_case_statement8263 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_END_in_case_statement8269 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CASE_in_case_statement8279 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_WHEN_in_case_statement8282 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_expression_in_case_statement8286 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_THEN_in_case_statement8288 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_expression_in_case_statement8292 = new BitSet(new long[]{0x0300000000000000L,0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_ELSE_in_case_statement8299 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_expression_in_case_statement8303 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_END_in_case_statement8309 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_synpred1_PhoenixSQL6006 = new BitSet(new long[]{0x2008011000620400L,0x0005188800000001L,0x0000000204000002L});
	public static final BitSet FOLLOW_boolean_expression_in_synpred1_PhoenixSQL6009 = new BitSet(new long[]{0x0000000000000002L});
}
