/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.Weigher;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.cache.TenantCache;
import org.apache.phoenix.cache.TenantCacheImpl;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.memory.ChildMemoryManager;
import org.apache.phoenix.memory.GlobalMemoryManager;
import org.apache.phoenix.schema.PMetaDataEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalCache
extends TenantCacheImpl {
    private static final Logger logger = LoggerFactory.getLogger(GlobalCache.class);
    private static volatile GlobalCache INSTANCE;
    private final Configuration config;
    private final ConcurrentMap<ImmutableBytesWritable, TenantCache> perTenantCacheMap = new ConcurrentHashMap<ImmutableBytesWritable, TenantCache>();
    private volatile Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache;

    public long clearTenantCache() {
        long unfreedBytes = this.getMemoryManager().getMaxMemory() - this.getMemoryManager().getAvailableMemory();
        if (unfreedBytes != 0L && logger.isDebugEnabled()) {
            logger.debug("Found " + (this.getMemoryManager().getMaxMemory() - this.getMemoryManager().getAvailableMemory()) + " bytes not freed from global cache");
        }
        this.removeAllServerCache();
        for (Map.Entry entry : this.perTenantCacheMap.entrySet()) {
            TenantCache cache = (TenantCache)entry.getValue();
            long unfreedTenantBytes = cache.getMemoryManager().getMaxMemory() - cache.getMemoryManager().getAvailableMemory();
            if (unfreedTenantBytes != 0L && logger.isDebugEnabled()) {
                ImmutableBytesWritable cacheId = (ImmutableBytesWritable)entry.getKey();
                logger.debug("Found " + unfreedTenantBytes + " bytes not freed for tenant " + Bytes.toStringBinary((byte[])cacheId.get(), (int)cacheId.getOffset(), (int)cacheId.getLength()));
            }
            unfreedBytes += unfreedTenantBytes;
            cache.removeAllServerCache();
        }
        this.perTenantCacheMap.clear();
        return unfreedBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache<ImmutableBytesPtr, PMetaDataEntity> getMetaDataCache() {
        Cache result = this.metaDataCache;
        if (result == null) {
            GlobalCache globalCache = this;
            synchronized (globalCache) {
                result = this.metaDataCache;
                if (result == null) {
                    long maxTTL = Math.min(this.config.getLong("phoenix.coprocessor.maxMetaDataCacheTimeToLiveMs", 1800000L), this.config.getLong("phoenix.stats.updateFrequency", 900000L));
                    long maxSize = this.config.getLong("phoenix.coprocessor.maxMetaDataCacheSize", 0x1400000L);
                    this.metaDataCache = result = CacheBuilder.newBuilder().maximumWeight(maxSize).expireAfterAccess(maxTTL, TimeUnit.MILLISECONDS).weigher((Weigher)new Weigher<ImmutableBytesPtr, PMetaDataEntity>(){

                        public int weigh(ImmutableBytesPtr key, PMetaDataEntity table) {
                            return 52 + key.getLength() + table.getEstimatedSize();
                        }
                    }).build();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GlobalCache getInstance(RegionCoprocessorEnvironment env) {
        GlobalCache result = INSTANCE;
        if (result != null) return result;
        Class<GlobalCache> clazz = GlobalCache.class;
        synchronized (GlobalCache.class) {
            result = INSTANCE;
            if (result != null) return result;
            INSTANCE = result = new GlobalCache(env.getConfiguration());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    public static TenantCache getTenantCache(RegionCoprocessorEnvironment env, ImmutableBytesPtr tenantId) {
        GlobalCache globalCache = GlobalCache.getInstance(env);
        GlobalCache tenantCache = tenantId == null ? globalCache : globalCache.getChildTenantCache(tenantId);
        return tenantCache;
    }

    private static long getMaxMemorySize(Configuration config) {
        long maxSize = Runtime.getRuntime().maxMemory() * (long)config.getInt("phoenix.query.maxGlobalMemoryPercentage", 15) / 100L;
        maxSize = Math.min(maxSize, config.getLong("phoenix.query.maxGlobalMemorySize", Long.MAX_VALUE));
        return maxSize;
    }

    private GlobalCache(Configuration config) {
        super(new GlobalMemoryManager(GlobalCache.getMaxMemorySize(config), config.getInt("phoenix.query.maxGlobalMemoryWaitMs", 10000)), config.getInt("phoenix.coprocessor.maxServerCacheTimeToLiveMs", 30000));
        this.config = config;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public TenantCache getChildTenantCache(ImmutableBytesPtr tenantId) {
        TenantCache tenantCache = (TenantCache)this.perTenantCacheMap.get((Object)tenantId);
        if (tenantCache == null) {
            int maxTenantMemoryPerc = this.config.getInt("phoenix.query.maxTenantMemoryPercentage", 100);
            int maxServerCacheTimeToLive = this.config.getInt("phoenix.coprocessor.maxServerCacheTimeToLiveMs", 30000);
            TenantCacheImpl newTenantCache = new TenantCacheImpl(new ChildMemoryManager(this.getMemoryManager(), maxTenantMemoryPerc), maxServerCacheTimeToLive);
            tenantCache = this.perTenantCacheMap.putIfAbsent(tenantId, newTenantCache);
            if (tenantCache == null) {
                tenantCache = newTenantCache;
            }
        }
        return tenantCache;
    }

    public static class FunctionBytesPtr
    extends ImmutableBytesPtr {
        public FunctionBytesPtr(byte[] key) {
            super(key);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof FunctionBytesPtr) {
                return super.equals(obj);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

