/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.cache;

import com.google.common.collect.ImmutableSet;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import java.io.Closeable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.ipc.BlockingRpcCallback;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.coprocessor.ServerCachingProtocol;
import org.apache.phoenix.coprocessor.generated.ServerCacheFactoryProtos;
import org.apache.phoenix.coprocessor.generated.ServerCachingProtos;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.job.JobManager;
import org.apache.phoenix.memory.MemoryManager;
import org.apache.phoenix.monitoring.TaskExecutionMetricsHolder;
import org.apache.phoenix.protobuf.ProtobufUtil;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.Closeables;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.SQLCloseable;
import org.apache.phoenix.util.SQLCloseables;
import org.apache.phoenix.util.ScanUtil;

public class ServerCacheClient {
    public static final int UUID_LENGTH = 8;
    public static final byte[] KEY_IN_FIRST_REGION = new byte[]{0};
    private static final Log LOG = LogFactory.getLog(ServerCacheClient.class);
    private static final Random RANDOM = new Random();
    private final PhoenixConnection connection;
    private final Map<Integer, TableRef> cacheUsingTableRefMap = new ConcurrentHashMap<Integer, TableRef>();

    public ServerCacheClient(PhoenixConnection connection) {
        this.connection = connection;
    }

    public PhoenixConnection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServerCache addServerCache(ScanRanges keyRanges, final ImmutableBytesWritable cachePtr, final byte[] txState, final ServerCachingProtocol.ServerCacheFactory cacheFactory, TableRef cacheUsingTableRef) throws SQLException {
        byte[] cacheId;
        ServerCache hashCacheSpec;
        block56: {
            ConnectionQueryServices services = this.connection.getQueryServices();
            MemoryManager.MemoryChunk chunk = services.getMemoryManager().allocate(cachePtr.getLength());
            ArrayList<MemoryManager.MemoryChunk> closeables = new ArrayList<MemoryManager.MemoryChunk>();
            closeables.add(chunk);
            hashCacheSpec = null;
            SQLException firstException = null;
            cacheId = ServerCacheClient.generateId();
            boolean success = false;
            ThreadPoolExecutor executor = services.getExecutor();
            List<Future> futures = Collections.emptyList();
            try {
                final PTable cacheUsingTable = cacheUsingTableRef.getTable();
                List<HRegionLocation> locations = services.getAllTableRegions(cacheUsingTable.getPhysicalName().getBytes());
                int nRegions = locations.size();
                futures = new ArrayList<Future>(nRegions);
                HashSet<HRegionLocation> servers = new HashSet<HRegionLocation>(nRegions);
                for (HRegionLocation entry : locations) {
                    byte[] regionStartKey = entry.getRegionInfo().getStartKey();
                    byte[] regionEndKey = entry.getRegionInfo().getEndKey();
                    if (!servers.contains(entry) && keyRanges.intersectRegion(regionStartKey, regionEndKey, cacheUsingTable.getIndexType() == PTable.IndexType.LOCAL)) {
                        servers.add(entry);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)LogUtil.addCustomAnnotations("Adding cache entry to be sent for " + entry, this.connection));
                        }
                        final byte[] key = ServerCacheClient.getKeyInRegion(entry.getRegionInfo().getStartKey());
                        final HTableInterface htable = services.getTable(cacheUsingTableRef.getTable().getPhysicalName().getBytes());
                        closeables.add((MemoryManager.MemoryChunk)htable);
                        futures.add(executor.submit(new JobManager.JobCallable<Boolean>(){

                            @Override
                            public Boolean call() throws Exception {
                                Map results;
                                try {
                                    results = htable.coprocessorService(ServerCachingProtos.ServerCachingService.class, key, key, (Batch.Call)new Batch.Call<ServerCachingProtos.ServerCachingService, ServerCachingProtos.AddServerCacheResponse>(){

                                        public ServerCachingProtos.AddServerCacheResponse call(ServerCachingProtos.ServerCachingService instance) throws IOException {
                                            byte[] tenantIdBytes;
                                            ServerRpcController controller = new ServerRpcController();
                                            BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                                            ServerCachingProtos.AddServerCacheRequest.Builder builder = ServerCachingProtos.AddServerCacheRequest.newBuilder();
                                            if (cacheUsingTable.isMultiTenant()) {
                                                try {
                                                    tenantIdBytes = ServerCacheClient.this.connection.getTenantId() == null ? null : ScanUtil.getTenantIdBytes(cacheUsingTable.getRowKeySchema(), cacheUsingTable.getBucketNum() != null, ServerCacheClient.this.connection.getTenantId(), cacheUsingTable.getViewIndexId() != null);
                                                }
                                                catch (SQLException e) {
                                                    throw new IOException(e);
                                                }
                                            } else {
                                                byte[] byArray = tenantIdBytes = ServerCacheClient.this.connection.getTenantId() == null ? null : ServerCacheClient.this.connection.getTenantId().getBytes();
                                            }
                                            if (tenantIdBytes != null) {
                                                builder.setTenantId(ByteStringer.wrap((byte[])tenantIdBytes));
                                            }
                                            builder.setCacheId(ByteStringer.wrap((byte[])cacheId));
                                            builder.setCachePtr(ProtobufUtil.toProto(cachePtr));
                                            builder.setHasProtoBufIndexMaintainer(true);
                                            ServerCacheFactoryProtos.ServerCacheFactory.Builder svrCacheFactoryBuider = ServerCacheFactoryProtos.ServerCacheFactory.newBuilder();
                                            svrCacheFactoryBuider.setClassName(cacheFactory.getClass().getName());
                                            builder.setCacheFactory(svrCacheFactoryBuider.build());
                                            builder.setTxState(ByteStringer.wrap((byte[])txState));
                                            instance.addServerCache((RpcController)controller, builder.build(), (RpcCallback<ServerCachingProtos.AddServerCacheResponse>)rpcCallback);
                                            if (controller.getFailedOn() != null) {
                                                throw controller.getFailedOn();
                                            }
                                            return (ServerCachingProtos.AddServerCacheResponse)rpcCallback.get();
                                        }
                                    });
                                }
                                catch (Throwable t) {
                                    throw new Exception(t);
                                }
                                if (results != null && results.size() == 1) {
                                    return ((ServerCachingProtos.AddServerCacheResponse)results.values().iterator().next()).getReturn();
                                }
                                return false;
                            }

                            @Override
                            public Object getJobId() {
                                return ServerCacheClient.this;
                            }

                            @Override
                            public TaskExecutionMetricsHolder getTaskExecutionMetric() {
                                return TaskExecutionMetricsHolder.NO_OP_INSTANCE;
                            }
                        }));
                        continue;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)LogUtil.addCustomAnnotations("NOT adding cache entry to be sent for " + entry + " since one already exists for that entry", this.connection));
                }
                hashCacheSpec = new ServerCache(cacheId, servers, cachePtr.getLength());
                int timeoutMs = services.getProps().getInt("phoenix.query.timeoutMs", 600000);
                for (Future future : futures) {
                    future.get(timeoutMs, TimeUnit.MILLISECONDS);
                }
                this.cacheUsingTableRefMap.put(Bytes.mapKey((byte[])cacheId), cacheUsingTableRef);
                success = true;
            }
            catch (SQLException e) {
                firstException = e;
                return firstException;
            }
            catch (Exception e) {
                firstException = new SQLException(e);
                return firstException;
            }
            finally {
                try {
                    if (success) {
                    }
                    SQLCloseables.closeAllQuietly(Collections.singletonList(hashCacheSpec));
                    for (Future future : futures) {
                        future.cancel(true);
                    }
                }
                finally {
                    try {
                        Closeables.closeAll(closeables);
                    }
                    catch (IOException e) {
                        if (firstException == null) {
                            firstException = new SQLException(e);
                            return firstException;
                        }
                    }
                    finally {
                        if (firstException == null) break block56;
                        throw firstException;
                    }
                }
            }
        }
        if (!LOG.isDebugEnabled()) return hashCacheSpec;
        LOG.debug((Object)LogUtil.addCustomAnnotations("Cache " + cacheId + " successfully added to servers.", this.connection));
        return hashCacheSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeServerCache(final byte[] cacheId, Set<HRegionLocation> servers) throws SQLException {
        ConnectionQueryServices services = this.connection.getQueryServices();
        Throwable lastThrowable = null;
        TableRef cacheUsingTableRef = this.cacheUsingTableRefMap.get(Bytes.mapKey((byte[])cacheId));
        final PTable cacheUsingTable = cacheUsingTableRef.getTable();
        byte[] tableName = cacheUsingTableRef.getTable().getPhysicalName().getBytes();
        HTableInterface iterateOverTable = services.getTable(tableName);
        try {
            List<HRegionLocation> locations = services.getAllTableRegions(tableName);
            HashSet<HRegionLocation> remainingOnServers = new HashSet<HRegionLocation>(servers);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)LogUtil.addCustomAnnotations("Removing Cache " + cacheId + " from servers.", this.connection));
            }
            for (HRegionLocation entry : locations) {
                if (!remainingOnServers.contains(entry)) continue;
                try {
                    byte[] key = ServerCacheClient.getKeyInRegion(entry.getRegionInfo().getStartKey());
                    iterateOverTable.coprocessorService(ServerCachingProtos.ServerCachingService.class, key, key, (Batch.Call)new Batch.Call<ServerCachingProtos.ServerCachingService, ServerCachingProtos.RemoveServerCacheResponse>(){

                        public ServerCachingProtos.RemoveServerCacheResponse call(ServerCachingProtos.ServerCachingService instance) throws IOException {
                            byte[] tenantIdBytes;
                            ServerRpcController controller = new ServerRpcController();
                            BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                            ServerCachingProtos.RemoveServerCacheRequest.Builder builder = ServerCachingProtos.RemoveServerCacheRequest.newBuilder();
                            if (cacheUsingTable.isMultiTenant()) {
                                try {
                                    tenantIdBytes = ServerCacheClient.this.connection.getTenantId() == null ? null : ScanUtil.getTenantIdBytes(cacheUsingTable.getRowKeySchema(), cacheUsingTable.getBucketNum() != null, ServerCacheClient.this.connection.getTenantId(), cacheUsingTable.getViewIndexId() != null);
                                }
                                catch (SQLException e) {
                                    throw new IOException(e);
                                }
                            } else {
                                byte[] byArray = tenantIdBytes = ServerCacheClient.this.connection.getTenantId() == null ? null : ServerCacheClient.this.connection.getTenantId().getBytes();
                            }
                            if (tenantIdBytes != null) {
                                builder.setTenantId(ByteStringer.wrap((byte[])tenantIdBytes));
                            }
                            builder.setCacheId(ByteStringer.wrap((byte[])cacheId));
                            instance.removeServerCache((RpcController)controller, builder.build(), (RpcCallback<ServerCachingProtos.RemoveServerCacheResponse>)rpcCallback);
                            if (controller.getFailedOn() != null) {
                                throw controller.getFailedOn();
                            }
                            return (ServerCachingProtos.RemoveServerCacheResponse)rpcCallback.get();
                        }
                    });
                    remainingOnServers.remove(entry);
                }
                catch (Throwable t) {
                    lastThrowable = t;
                    LOG.error((Object)LogUtil.addCustomAnnotations("Error trying to remove hash cache for " + entry, this.connection), t);
                }
            }
            if (!remainingOnServers.isEmpty()) {
                LOG.warn((Object)LogUtil.addCustomAnnotations("Unable to remove hash cache for " + remainingOnServers, this.connection), lastThrowable);
            }
        }
        finally {
            Closeables.closeQuietly((Closeable)iterateOverTable);
        }
    }

    public static byte[] generateId() {
        long rand = RANDOM.nextLong();
        return Bytes.toBytes((long)rand);
    }

    public static String idToString(byte[] uuid) {
        assert (uuid.length == 8);
        return Long.toString(Bytes.toLong((byte[])uuid));
    }

    private static byte[] getKeyInRegion(byte[] regionStartKey) {
        assert (regionStartKey != null);
        if (Bytes.equals((byte[])regionStartKey, (byte[])HConstants.EMPTY_START_ROW)) {
            return KEY_IN_FIRST_REGION;
        }
        return regionStartKey;
    }

    public class ServerCache
    implements SQLCloseable {
        private final int size;
        private final byte[] id;
        private final ImmutableSet<HRegionLocation> servers;

        public ServerCache(byte[] id, Set<HRegionLocation> servers, int size) {
            this.id = id;
            this.servers = ImmutableSet.copyOf(servers);
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }

        public byte[] getId() {
            return this.id;
        }

        @Override
        public void close() throws SQLException {
            ServerCacheClient.this.removeServerCache(this.id, this.servers);
        }
    }
}

