/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Set;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.schema.TableRef;

public abstract class BaseMutationPlan
implements MutationPlan {
    private final StatementContext context;
    private final PhoenixStatement.Operation operation;

    public BaseMutationPlan(StatementContext context, PhoenixStatement.Operation operation) {
        this.context = context;
        this.operation = operation;
    }

    @Override
    public PhoenixStatement.Operation getOperation() {
        return this.operation;
    }

    @Override
    public StatementContext getContext() {
        return this.context;
    }

    @Override
    public ParameterMetaData getParameterMetaData() {
        return this.context.getBindManager().getParameterMetaData();
    }

    @Override
    public ExplainPlan getExplainPlan() throws SQLException {
        return ExplainPlan.EMPTY_PLAN;
    }

    @Override
    public TableRef getTargetRef() {
        return this.context.getCurrentTable();
    }

    @Override
    public Set<TableRef> getSourceRefs() {
        return Collections.emptySet();
    }

    @Override
    public Long getEstimatedRowsToScan() throws SQLException {
        return 0L;
    }

    @Override
    public Long getEstimatedBytesToScan() throws SQLException {
        return 0L;
    }
}

