/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.MutatingParallelIteratorFactory;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.ProjectionCompiler;
import org.apache.phoenix.compile.QueryCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.SequenceManager;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.StatementNormalizer;
import org.apache.phoenix.compile.SubqueryRewriter;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.AggregatePlan;
import org.apache.phoenix.execute.BaseQueryPlan;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.optimize.QueryOptimizer;
import org.apache.phoenix.parse.DeleteStatement;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.MetaDataEntityNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PRow;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.ReadOnlyTableException;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.NumberUtil;
import org.apache.phoenix.util.ScanUtil;

public class DeleteCompiler {
    private static ParseNodeFactory FACTORY = new ParseNodeFactory();
    private final PhoenixStatement statement;
    private final PhoenixStatement.Operation operation;

    public DeleteCompiler(PhoenixStatement statement, PhoenixStatement.Operation operation) {
        this.statement = statement;
        this.operation = operation;
    }

    private static MutationState deleteRows(StatementContext childContext, TableRef targetTableRef, List<TableRef> indexTableRefs, ResultIterator iterator, RowProjector projector, TableRef sourceTableRef) throws SQLException {
        PTable table = targetTableRef.getTable();
        PhoenixStatement statement = childContext.getStatement();
        PhoenixConnection connection = statement.getConnection();
        PName tenantId = connection.getTenantId();
        byte[] tenantIdBytes = null;
        if (tenantId != null) {
            tenantIdBytes = ScanUtil.getTenantIdBytes(table.getRowKeySchema(), table.getBucketNum() != null, tenantId, table.getViewIndexId() != null);
        }
        boolean isAutoCommit = connection.getAutoCommit();
        ConnectionQueryServices services = connection.getQueryServices();
        int maxSize = services.getProps().getInt("phoenix.mutate.maxSize", 500000);
        int maxSizeBytes = services.getProps().getInt("phoenix.mutate.maxSizeBytes", 0x6400000);
        int batchSize = Math.min(connection.getMutateBatchSize(), maxSize);
        HashMap mutations = Maps.newHashMapWithExpectedSize((int)batchSize);
        ArrayList indexMutations = null;
        if (!indexTableRefs.isEmpty()) {
            indexMutations = Lists.newArrayListWithExpectedSize((int)indexTableRefs.size());
            for (int i = 0; i < indexTableRefs.size(); ++i) {
                indexMutations.add(Maps.newHashMapWithExpectedSize((int)batchSize));
            }
        }
        List<PColumn> pkColumns = table.getPKColumns();
        boolean isMultiTenant = table.isMultiTenant() && tenantIdBytes != null;
        boolean isSharedViewIndex = table.getViewIndexId() != null;
        int offset = table.getBucketNum() == null ? 0 : 1;
        byte[][] values = new byte[pkColumns.size()][];
        if (isSharedViewIndex) {
            values[offset++] = MetaDataUtil.getViewIndexIdDataType().toBytes(table.getViewIndexId());
        }
        if (isMultiTenant) {
            values[offset++] = tenantIdBytes;
        }
        try (PhoenixResultSet rs = new PhoenixResultSet(iterator, projector, childContext);){
            MutationState indexState;
            int rowCount = 0;
            while (rs.next()) {
                int i;
                ImmutableBytesPtr ptr = new ImmutableBytesPtr();
                if (sourceTableRef.equals(targetTableRef)) {
                    rs.getCurrentRow().getKey(ptr);
                } else {
                    for (i = offset; i < values.length; ++i) {
                        byte[] byteValue = rs.getBytes(i + 1 - offset);
                        if (pkColumns.get(i).getSortOrder() == SortOrder.DESC) {
                            byte[] tempByteValue = Arrays.copyOf(byteValue, byteValue.length);
                            byteValue = SortOrder.invert(byteValue, 0, tempByteValue, 0, byteValue.length);
                        }
                        values[i] = byteValue;
                    }
                    table.newKey(ptr, values);
                }
                mutations.put(ptr, new MutationState.RowMutationState(PRow.DELETE_MARKER, statement.getConnection().getStatementExecutionCounter(), MutationState.RowTimestampColInfo.NULL_ROWTIMESTAMP_INFO, null));
                for (i = 0; i < indexTableRefs.size(); ++i) {
                    ImmutableBytesPtr indexPtr = new ImmutableBytesPtr();
                    rs.getCurrentRow().getKey(indexPtr);
                    ((Map)indexMutations.get(i)).put(indexPtr, new MutationState.RowMutationState(PRow.DELETE_MARKER, statement.getConnection().getStatementExecutionCounter(), MutationState.RowTimestampColInfo.NULL_ROWTIMESTAMP_INFO, null));
                }
                if (mutations.size() > maxSize) {
                    throw new IllegalArgumentException("MutationState size of " + mutations.size() + " is bigger than max allowed size of " + maxSize);
                }
                if (!isAutoCommit || ++rowCount % batchSize != 0) continue;
                MutationState state2 = new MutationState(targetTableRef, mutations, 0L, maxSize, maxSizeBytes, connection);
                connection.getMutationState().join(state2);
                for (int i2 = 0; i2 < indexTableRefs.size(); ++i2) {
                    indexState = new MutationState(indexTableRefs.get(i2), (Map)indexMutations.get(i2), 0L, maxSize, maxSizeBytes, connection);
                    connection.getMutationState().join(indexState);
                }
                connection.getMutationState().send();
                mutations.clear();
                if (indexMutations == null) continue;
                indexMutations.clear();
            }
            int nCommittedRows = isAutoCommit ? rowCount / batchSize * batchSize : 0;
            MutationState state3 = new MutationState(targetTableRef, mutations, nCommittedRows, maxSize, maxSizeBytes, connection);
            for (int i = 0; i < indexTableRefs.size(); ++i) {
                indexState = new MutationState(indexTableRefs.get(i), (Map)indexMutations.get(i), 0L, maxSize, maxSizeBytes, connection);
                state3.join(indexState);
            }
            MutationState mutationState = state3;
            return mutationState;
        }
    }

    private Map<PTableKey, PTable> getNonDisabledImmutableIndexes(TableRef tableRef) {
        PTable table = tableRef.getTable();
        if (table.isImmutableRows() && !table.getIndexes().isEmpty()) {
            HashMap<PTableKey, PTable> nonDisabledIndexes = new HashMap<PTableKey, PTable>(table.getIndexes().size());
            for (PTable index : table.getIndexes()) {
                if (index.getIndexState() == PIndexState.DISABLE) continue;
                nonDisabledIndexes.put(index.getKey(), index);
            }
            return nonDisabledIndexes;
        }
        return Collections.emptyMap();
    }

    private static boolean hasNonPKIndexedColumns(Collection<PTable> immutableIndexes) {
        for (PTable index : immutableIndexes) {
            for (PColumn column : index.getPKColumns()) {
                if (IndexUtil.isDataPKColumn(column)) continue;
                return true;
            }
        }
        return false;
    }

    public MutationPlan compile(DeleteStatement delete) throws SQLException {
        boolean hasImmutableIndexes;
        ArrayList queryPlans;
        DeletingParallelIteratorFactory parallelIteratorFactory;
        TableRef tableRefToBe;
        final PhoenixConnection connection = this.statement.getConnection();
        boolean isAutoCommit = connection.getAutoCommit();
        final boolean hasLimit = delete.getLimit() != null;
        ConnectionQueryServices services = connection.getQueryServices();
        NamedTableNode tableNode = delete.getTable();
        String tableName = tableNode.getName().getTableName();
        String schemaName = tableNode.getName().getSchemaName();
        boolean retryOnce = !isAutoCommit;
        boolean noQueryReqd = false;
        boolean runOnServer = false;
        SelectStatement select = null;
        ColumnResolver resolverToBe = null;
        Map<Object, Object> immutableIndex = Collections.emptyMap();
        QueryPlan dataPlanToBe = null;
        while (true) {
            try {
                resolverToBe = FromCompiler.getResolverForMutation(delete, connection);
                tableRefToBe = resolverToBe.getTables().get(0);
                PTable table = tableRefToBe.getTable();
                if (table.getType() == PTableType.VIEW && table.getViewType().isReadOnly()) {
                    throw new ReadOnlyTableException(schemaName, tableName);
                }
                if (table.isTransactional() && connection.getSCN() != null) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SPECIFY_SCN_FOR_TXN_TABLE).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                }
                immutableIndex = this.getNonDisabledImmutableIndexes(tableRefToBe);
                boolean mayHaveImmutableIndexes = !immutableIndex.isEmpty();
                noQueryReqd = !hasLimit;
                runOnServer = isAutoCommit && noQueryReqd && !table.isTransactional();
                HintNode hint = delete.getHint();
                if (runOnServer && !delete.getHint().hasHint(HintNode.Hint.USE_INDEX_OVER_DATA_TABLE)) {
                    hint = HintNode.create(hint, HintNode.Hint.USE_DATA_OVER_INDEX_TABLE);
                }
                ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)table.getPKColumns().size());
                boolean isSalted = table.getBucketNum() != null;
                boolean isMultiTenant = connection.getTenantId() != null && table.isMultiTenant();
                boolean bl = table.getViewIndexId() != null;
                for (int i = (isSalted ? 1 : 0) + (isMultiTenant ? 1 : 0) + (bl ? 1 : 0); i < table.getPKColumns().size(); ++i) {
                    PColumn column = table.getPKColumns().get(i);
                    arrayList.add(FACTORY.aliasedNode(null, FACTORY.column(null, '\"' + column.getName().getString() + '\"', null)));
                }
                select = FACTORY.select(delete.getTable(), hint, false, arrayList, delete.getWhere(), Collections.emptyList(), null, delete.getOrderBy(), delete.getLimit(), null, delete.getBindCount(), false, false, Collections.emptyList(), delete.getUdfParseNodes());
                SelectStatement transformedSelect = SubqueryRewriter.transform(select = StatementNormalizer.normalize(select, resolverToBe), resolverToBe, connection);
                if (transformedSelect != select) {
                    resolverToBe = FromCompiler.getResolverForQuery(transformedSelect, connection, false, delete.getTable().getName());
                    select = StatementNormalizer.normalize(transformedSelect, resolverToBe);
                }
                parallelIteratorFactory = hasLimit ? null : new DeletingParallelIteratorFactory(connection);
                QueryOptimizer optimizer = new QueryOptimizer(services);
                QueryCompiler compiler = new QueryCompiler(this.statement, select, resolverToBe, Collections.emptyList(), parallelIteratorFactory, new SequenceManager(this.statement));
                dataPlanToBe = compiler.compile();
                queryPlans = Lists.newArrayList(mayHaveImmutableIndexes ? optimizer.getApplicablePlans(dataPlanToBe, this.statement, select, resolverToBe, Collections.emptyList(), parallelIteratorFactory) : optimizer.getBestPlan(dataPlanToBe, this.statement, select, resolverToBe, Collections.emptyList(), parallelIteratorFactory));
                if (!mayHaveImmutableIndexes) break;
                table = connection.getTable(new PTableKey(table.getTenantId(), table.getName().getString()));
                tableRefToBe.setTable(table);
                immutableIndex = this.getNonDisabledImmutableIndexes(tableRefToBe);
            }
            catch (MetaDataEntityNotFoundException e) {
                if (retryOnce) {
                    MetaDataProtocol.MetaDataMutationResult result;
                    retryOnce = false;
                    if ((result = new MetaDataClient(connection).updateCache(schemaName, tableName)).wasUpdated()) continue;
                }
                throw e;
            }
            break;
        }
        boolean isBuildingImmutable = false;
        boolean bl = hasImmutableIndexes = !immutableIndex.isEmpty();
        if (hasImmutableIndexes) {
            for (PTable pTable : immutableIndex.values()) {
                if (pTable.getIndexState() != PIndexState.BUILDING) continue;
                isBuildingImmutable = true;
                break;
            }
        }
        final QueryPlan dataPlan = dataPlanToBe;
        TableRef[] tableRefArray = new TableRef[hasImmutableIndexes ? immutableIndex.size() : 1];
        if (hasImmutableIndexes) {
            int i = 0;
            Iterator plans = queryPlans.iterator();
            while (plans.hasNext()) {
                QueryPlan queryPlan = (QueryPlan)plans.next();
                PTable table = queryPlan.getTableRef().getTable();
                if (table.getType() == PTableType.INDEX) {
                    tableRefArray[i++] = queryPlan.getTableRef();
                    immutableIndex.remove(table.getKey());
                    continue;
                }
                if (isBuildingImmutable) continue;
                plans.remove();
            }
            if (!immutableIndex.isEmpty()) {
                Collection<Object> collection = immutableIndex.values();
                if (!isBuildingImmutable || DeleteCompiler.hasNonPKIndexedColumns(collection)) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_FILTER_ON_IMMUTABLE_ROWS).setSchemaName(tableRefToBe.getTable().getSchemaName().getString()).setTableName(tableRefToBe.getTable().getTableName().getString()).build().buildException();
                }
                runOnServer = false;
            }
        }
        ArrayList buildingImmutableIndexes = Lists.newArrayListWithExpectedSize((int)immutableIndex.values().size());
        for (PTable pTable : immutableIndex.values()) {
            buildingImmutableIndexes.add(new TableRef(pTable, dataPlan.getTableRef().getTimeStamp(), dataPlan.getTableRef().getLowerBoundTimeStamp()));
        }
        final TableRef dataTableRef = tableRefArray[0] = tableRefToBe;
        ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)tableRefArray.length);
        for (int i = 0; i < tableRefArray.length; ++i) {
            final TableRef tableRef = tableRefArray[i];
            final QueryPlan plan = (QueryPlan)queryPlans.get(i);
            if (!plan.getTableRef().equals(tableRef) || !(plan instanceof BaseQueryPlan)) {
                runOnServer = false;
                noQueryReqd = false;
            }
            final int maxSize = services.getProps().getInt("phoenix.mutate.maxSize", 500000);
            final int maxSizeBytes = services.getProps().getInt("phoenix.mutate.maxSizeBytes", 0x6400000);
            final StatementContext context = plan.getContext();
            if (noQueryReqd && (!context.getScan().hasFilter() || context.getScan().getFilter() instanceof SkipScanFilter) && context.getScanRanges().isPointLookup()) {
                arrayList.add(new MutationPlan(){

                    @Override
                    public ParameterMetaData getParameterMetaData() {
                        return context.getBindManager().getParameterMetaData();
                    }

                    @Override
                    public MutationState execute() throws SQLException {
                        ScanRanges ranges = context.getScanRanges();
                        Iterator<KeyRange> iterator = ranges.getPointLookupKeyIterator();
                        HashMap mutation = Maps.newHashMapWithExpectedSize((int)ranges.getPointLookupCount());
                        while (iterator.hasNext()) {
                            mutation.put(new ImmutableBytesPtr(iterator.next().getLowerRange()), new MutationState.RowMutationState(PRow.DELETE_MARKER, DeleteCompiler.this.statement.getConnection().getStatementExecutionCounter(), MutationState.RowTimestampColInfo.NULL_ROWTIMESTAMP_INFO, null));
                        }
                        return new MutationState(tableRef, mutation, 0L, maxSize, maxSizeBytes, connection);
                    }

                    @Override
                    public ExplainPlan getExplainPlan() throws SQLException {
                        return new ExplainPlan(Collections.singletonList("DELETE SINGLE ROW"));
                    }

                    @Override
                    public StatementContext getContext() {
                        return context;
                    }

                    @Override
                    public TableRef getTargetRef() {
                        return dataTableRef;
                    }

                    @Override
                    public Set<TableRef> getSourceRefs() {
                        return Collections.emptySet();
                    }

                    @Override
                    public PhoenixStatement.Operation getOperation() {
                        return DeleteCompiler.this.operation;
                    }

                    @Override
                    public Long getEstimatedRowsToScan() throws SQLException {
                        return 0L;
                    }

                    @Override
                    public Long getEstimatedBytesToScan() throws SQLException {
                        return 0L;
                    }
                });
                continue;
            }
            if (runOnServer) {
                Scan scan = context.getScan();
                scan.setAttribute("_IGNORE_NEWER_MUTATIONS", PDataType.TRUE_BYTES);
                scan.setAttribute("_DeleteAgg", QueryConstants.TRUE);
                SelectStatement aggSelect = SelectStatement.create(SelectStatement.COUNT_ONE, delete.getHint());
                RowProjector projectorToBe = ProjectionCompiler.compile(context, aggSelect, GroupByCompiler.GroupBy.EMPTY_GROUP_BY);
                context.getAggregationManager().compile(context, GroupByCompiler.GroupBy.EMPTY_GROUP_BY);
                if (plan.getProjector().projectEveryRow()) {
                    projectorToBe = new RowProjector(projectorToBe, true);
                }
                final RowProjector projector = projectorToBe;
                final AggregatePlan aggPlan = new AggregatePlan(context, select, tableRef, projector, null, null, OrderByCompiler.OrderBy.EMPTY_ORDER_BY, null, GroupByCompiler.GroupBy.EMPTY_GROUP_BY, null);
                arrayList.add(new MutationPlan(){

                    @Override
                    public ParameterMetaData getParameterMetaData() {
                        return context.getBindManager().getParameterMetaData();
                    }

                    @Override
                    public StatementContext getContext() {
                        return context;
                    }

                    @Override
                    public TableRef getTargetRef() {
                        return dataTableRef;
                    }

                    @Override
                    public Set<TableRef> getSourceRefs() {
                        return dataPlan.getSourceRefs();
                    }

                    @Override
                    public PhoenixStatement.Operation getOperation() {
                        return DeleteCompiler.this.operation;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public MutationState execute() throws SQLException {
                        ImmutableBytesWritable ptr = context.getTempPtr();
                        PTable table = tableRef.getTable();
                        table.getIndexMaintainers(ptr, context.getConnection());
                        byte[] txState = table.isTransactional() ? connection.getMutationState().encodeTransaction() : ByteUtil.EMPTY_BYTE_ARRAY;
                        try (ServerCacheClient.ServerCache cache = null;){
                            MutationState mutationState;
                            if (ptr.getLength() > 0) {
                                byte[] uuidValue = ServerCacheClient.generateId();
                                context.getScan().setAttribute("IdxUUID", uuidValue);
                                context.getScan().setAttribute("IdxProtoMD", ptr.get());
                                context.getScan().setAttribute("_TxState", txState);
                            }
                            ResultIterator iterator = aggPlan.iterator();
                            try {
                                Tuple row = iterator.next();
                                final long mutationCount = (Long)projector.getColumnProjector(0).getValue(row, PLong.INSTANCE, ptr);
                                mutationState = new MutationState(maxSize, maxSizeBytes, connection){

                                    @Override
                                    public long getUpdateCount() {
                                        return mutationCount;
                                    }
                                };
                            }
                            catch (Throwable throwable) {
                                iterator.close();
                                throw throwable;
                            }
                            iterator.close();
                            return mutationState;
                        }
                    }

                    @Override
                    public ExplainPlan getExplainPlan() throws SQLException {
                        List<String> queryPlanSteps = aggPlan.getExplainPlan().getPlanSteps();
                        ArrayList planSteps = Lists.newArrayListWithExpectedSize((int)(queryPlanSteps.size() + 1));
                        planSteps.add("DELETE ROWS");
                        planSteps.addAll(queryPlanSteps);
                        return new ExplainPlan(planSteps);
                    }

                    @Override
                    public Long getEstimatedRowsToScan() throws SQLException {
                        return aggPlan.getEstimatedRowsToScan();
                    }

                    @Override
                    public Long getEstimatedBytesToScan() throws SQLException {
                        return aggPlan.getEstimatedBytesToScan();
                    }
                });
                continue;
            }
            List<Object> immutableIndexRefsToBe = Lists.newArrayListWithExpectedSize((int)dataPlan.getTableRef().getTable().getIndexes().size());
            if (!buildingImmutableIndexes.isEmpty()) {
                immutableIndexRefsToBe = buildingImmutableIndexes;
            } else if (hasImmutableIndexes && !plan.getTableRef().equals(tableRef)) {
                immutableIndexRefsToBe = Collections.singletonList(plan.getTableRef());
            }
            final ArrayList immutableIndexRefs = immutableIndexRefsToBe;
            final DeletingParallelIteratorFactory parallelIteratorFactory2 = parallelIteratorFactory;
            arrayList.add(new MutationPlan(){

                @Override
                public ParameterMetaData getParameterMetaData() {
                    return context.getBindManager().getParameterMetaData();
                }

                @Override
                public StatementContext getContext() {
                    return context;
                }

                @Override
                public TableRef getTargetRef() {
                    return dataTableRef;
                }

                @Override
                public Set<TableRef> getSourceRefs() {
                    return dataPlan.getSourceRefs();
                }

                @Override
                public PhoenixStatement.Operation getOperation() {
                    return DeleteCompiler.this.operation;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public MutationState execute() throws SQLException {
                    try (ResultIterator iterator = plan.iterator();){
                        if (!hasLimit) {
                            Tuple tuple;
                            long totalRowCount = 0L;
                            if (parallelIteratorFactory2 != null) {
                                parallelIteratorFactory2.setRowProjector(plan.getProjector());
                                parallelIteratorFactory2.setTargetTableRef(tableRef);
                                parallelIteratorFactory2.setSourceTableRef(plan.getTableRef());
                                parallelIteratorFactory2.setIndexTargetTableRefs(immutableIndexRefs);
                            }
                            while ((tuple = iterator.next()) != null) {
                                Cell kv = tuple.getValue(0);
                                totalRowCount += PLong.INSTANCE.getCodec().decodeLong(kv.getValueArray(), kv.getValueOffset(), SortOrder.getDefault());
                            }
                            MutationState state2 = new MutationState((long)maxSize, (long)maxSizeBytes, connection, totalRowCount);
                            state2.setReadMetricQueue(plan.getContext().getReadMetricsQueue());
                            MutationState mutationState = state2;
                            return mutationState;
                        }
                        MutationState mutationState = DeleteCompiler.deleteRows(plan.getContext(), tableRef, immutableIndexRefs, iterator, plan.getProjector(), plan.getTableRef());
                        return mutationState;
                    }
                }

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    List<String> queryPlanSteps = plan.getExplainPlan().getPlanSteps();
                    ArrayList planSteps = Lists.newArrayListWithExpectedSize((int)(queryPlanSteps.size() + 1));
                    planSteps.add("DELETE ROWS");
                    planSteps.addAll(queryPlanSteps);
                    return new ExplainPlan(planSteps);
                }

                @Override
                public Long getEstimatedRowsToScan() throws SQLException {
                    return plan.getEstimatedRowsToScan();
                }

                @Override
                public Long getEstimatedBytesToScan() throws SQLException {
                    return plan.getEstimatedBytesToScan();
                }
            });
        }
        return arrayList.size() == 1 ? (MutationPlan)arrayList.get(0) : new MultiDeleteMutationPlan(arrayList);
    }

    private class MultiDeleteMutationPlan
    implements MutationPlan {
        private final List<MutationPlan> plans;
        private final MutationPlan firstPlan;

        public MultiDeleteMutationPlan(List<MutationPlan> plans) {
            Preconditions.checkArgument((!plans.isEmpty() ? 1 : 0) != 0);
            this.plans = plans;
            this.firstPlan = plans.get(0);
        }

        @Override
        public StatementContext getContext() {
            return this.firstPlan.getContext();
        }

        @Override
        public ParameterMetaData getParameterMetaData() {
            return this.firstPlan.getParameterMetaData();
        }

        @Override
        public ExplainPlan getExplainPlan() throws SQLException {
            return this.firstPlan.getExplainPlan();
        }

        @Override
        public MutationState execute() throws SQLException {
            MutationState state2 = this.firstPlan.execute();
            for (MutationPlan plan : this.plans.subList(1, this.plans.size())) {
                plan.execute();
            }
            return state2;
        }

        @Override
        public TableRef getTargetRef() {
            return this.firstPlan.getTargetRef();
        }

        @Override
        public Set<TableRef> getSourceRefs() {
            return this.firstPlan.getSourceRefs();
        }

        @Override
        public PhoenixStatement.Operation getOperation() {
            return DeleteCompiler.this.operation;
        }

        @Override
        public Long getEstimatedRowsToScan() throws SQLException {
            Long estRows = null;
            for (MutationPlan plan : this.plans) {
                estRows = NumberUtil.add(estRows, plan.getEstimatedRowsToScan());
            }
            return estRows;
        }

        @Override
        public Long getEstimatedBytesToScan() throws SQLException {
            Long estBytes = null;
            for (MutationPlan plan : this.plans) {
                estBytes = NumberUtil.add(estBytes, plan.getEstimatedBytesToScan());
            }
            return estBytes;
        }
    }

    private static class DeletingParallelIteratorFactory
    extends MutatingParallelIteratorFactory {
        private RowProjector projector;
        private TableRef targetTableRef;
        private List<TableRef> indexTableRefs;
        private TableRef sourceTableRef;

        private DeletingParallelIteratorFactory(PhoenixConnection connection) {
            super(connection);
        }

        @Override
        protected MutationState mutate(StatementContext parentContext, ResultIterator iterator, PhoenixConnection connection) throws SQLException {
            PhoenixStatement statement = new PhoenixStatement(connection);
            StatementContext ctx = new StatementContext(statement, false);
            MutationState state2 = DeleteCompiler.deleteRows(ctx, this.targetTableRef, this.indexTableRefs, iterator, this.projector, this.sourceTableRef);
            return state2;
        }

        public void setTargetTableRef(TableRef tableRef) {
            this.targetTableRef = tableRef;
        }

        public void setSourceTableRef(TableRef tableRef) {
            this.sourceTableRef = tableRef;
        }

        public void setRowProjector(RowProjector projector) {
            this.projector = projector;
        }

        public void setIndexTargetTableRefs(List<TableRef> indexTableRefs) {
            this.indexTableRefs = indexTableRefs;
        }
    }
}

