/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.FamilyWildcardParseNode;
import org.apache.phoenix.parse.OrderByNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.StatelessTraverseAllParseNodeVisitor;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.WildcardParseNode;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.LocalIndexDataColumnRef;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.ProjectedColumn;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.SchemaUtil;

public class TupleProjectionCompiler {
    public static final PName PROJECTED_TABLE_SCHEMA = PNameFactory.newName(".");
    private static final ParseNodeFactory NODE_FACTORY = new ParseNodeFactory();

    public static PTable createProjectedTable(SelectStatement select, StatementContext context) throws SQLException {
        ColumnRef sourceColumnRef;
        int position;
        Preconditions.checkArgument((!select.isJoin() ? 1 : 0) != 0);
        if (select.getInnerSelectStatement() != null || select.getFrom() == null || select.isAggregate() || select.isDistinct() || context.getResolver().getTables().get(0).getTable().getType() != PTableType.TABLE && context.getResolver().getTables().get(0).getTable().getType() != PTableType.INDEX && context.getResolver().getTables().get(0).getTable().getType() != PTableType.VIEW) {
            return null;
        }
        ArrayList<PColumn> projectedColumns = new ArrayList<PColumn>();
        boolean isWildcard = false;
        HashSet<String> families = new HashSet<String>();
        ColumnRefVisitor visitor = new ColumnRefVisitor(context);
        TableRef tableRef = context.getCurrentTable();
        PTable table = tableRef.getTable();
        for (AliasedNode aliasedNode : select.getSelect()) {
            ParseNode node = aliasedNode.getNode();
            if (node instanceof WildcardParseNode) {
                if (((WildcardParseNode)node).isRewrite()) {
                    TableRef parentTableRef = FromCompiler.getResolver(NODE_FACTORY.namedTable(null, TableName.create(table.getSchemaName().getString(), table.getParentTableName().getString())), context.getConnection()).resolveTable(table.getSchemaName().getString(), table.getParentTableName().getString());
                    for (PColumn pColumn : parentTableRef.getTable().getColumns()) {
                        NODE_FACTORY.column(null, '\"' + IndexUtil.getIndexColumnName(pColumn) + '\"', null).accept(visitor);
                    }
                }
                isWildcard = true;
                continue;
            }
            if (node instanceof FamilyWildcardParseNode) {
                FamilyWildcardParseNode familyWildcardNode = (FamilyWildcardParseNode)node;
                String familyName = familyWildcardNode.getName();
                if (familyWildcardNode.isRewrite()) {
                    TableRef tableRef2 = FromCompiler.getResolver(NODE_FACTORY.namedTable(null, TableName.create(table.getSchemaName().getString(), table.getParentTableName().getString())), context.getConnection()).resolveTable(table.getSchemaName().getString(), table.getParentTableName().getString());
                    for (PColumn column3 : tableRef2.getTable().getColumnFamily(familyName).getColumns()) {
                        NODE_FACTORY.column(null, '\"' + IndexUtil.getIndexColumnName(column3) + '\"', null).accept(visitor);
                    }
                }
                families.add(familyName);
                continue;
            }
            node.accept(visitor);
        }
        if (!isWildcard) {
            for (OrderByNode orderBy : select.getOrderBy()) {
                orderBy.getNode().accept(visitor);
            }
        }
        boolean hasSaltingColumn = table.getBucketNum() != null;
        for (int i = position = hasSaltingColumn ? 1 : 0; i < table.getPKColumns().size(); ++i) {
            PColumn sourceColumn = table.getPKColumns().get(i);
            sourceColumnRef = new ColumnRef(tableRef, sourceColumn.getPosition());
            ProjectedColumn projectedColumn = new ProjectedColumn(sourceColumn.getName(), sourceColumn.getFamilyName(), position++, sourceColumn.isNullable(), sourceColumnRef, null);
            projectedColumns.add(projectedColumn);
        }
        for (PColumn sourceColumn : table.getColumns()) {
            if (SchemaUtil.isPKColumn(sourceColumn)) continue;
            sourceColumnRef = new ColumnRef(tableRef, sourceColumn.getPosition());
            if (!isWildcard && !visitor.columnRefSet.contains(sourceColumnRef) && !families.contains(sourceColumn.getFamilyName().getString())) continue;
            ProjectedColumn projectedColumn = new ProjectedColumn(sourceColumn.getName(), sourceColumn.getFamilyName(), position++, sourceColumn.isNullable(), sourceColumnRef, sourceColumn.getColumnQualifierBytes());
            projectedColumns.add(projectedColumn);
            if (isWildcard || families.contains(sourceColumn.getFamilyName())) continue;
            EncodedColumnsUtil.setColumns(projectedColumn, table, context.getScan());
        }
        for (LocalIndexDataColumnRef sourceColumnRef2 : visitor.localIndexColumnRefSet) {
            ProjectedColumn column4 = new ProjectedColumn(sourceColumnRef2.getColumn().getName(), sourceColumnRef2.getColumn().getFamilyName(), position++, sourceColumnRef2.getColumn().isNullable(), sourceColumnRef2, sourceColumnRef2.getColumn().getColumnQualifierBytes());
            projectedColumns.add(column4);
        }
        return PTableImpl.makePTable(table.getTenantId(), table.getSchemaName(), table.getTableName(), PTableType.PROJECTED, table.getIndexState(), table.getTimeStamp(), table.getSequenceNumber(), table.getPKName(), table.getBucketNum(), projectedColumns, table.getParentSchemaName(), table.getParentName(), table.getIndexes(), table.isImmutableRows(), Collections.emptyList(), null, null, table.isWALDisabled(), table.isMultiTenant(), table.getStoreNulls(), table.getViewType(), table.getViewIndexId(), table.getIndexType(), table.rowKeyOrderOptimizable(), table.isTransactional(), table.getUpdateCacheFrequency(), table.getIndexDisableTimestamp(), table.isNamespaceMapped(), table.getAutoPartitionSeqName(), table.isAppendOnlySchema(), table.getImmutableStorageScheme(), table.getEncodingScheme(), table.getEncodedCQCounter(), table.useStatsForParallelization());
    }

    public static PTable createProjectedTable(TableRef tableRef, List<ColumnRef> sourceColumnRefs, boolean retainPKColumns) throws SQLException {
        int position;
        PTable table = tableRef.getTable();
        boolean hasSaltingColumn = retainPKColumns && table.getBucketNum() != null;
        ArrayList<PColumn> projectedColumns = new ArrayList<PColumn>();
        for (int i = position = hasSaltingColumn ? 1 : 0; i < sourceColumnRefs.size(); ++i) {
            String aliasedName;
            ColumnRef sourceColumnRef = sourceColumnRefs.get(i);
            PColumn sourceColumn = sourceColumnRef.getColumn();
            String colName = sourceColumn.getName().getString();
            String string = aliasedName = tableRef.getTableAlias() == null ? SchemaUtil.getColumnName(table.getName().getString(), colName) : SchemaUtil.getColumnName(tableRef.getTableAlias(), colName);
            PName familyName = SchemaUtil.isPKColumn(sourceColumn) ? (retainPKColumns ? null : PNameFactory.newName(QueryConstants.VALUE_COLUMN_FAMILY)) : sourceColumn.getFamilyName();
            ProjectedColumn column = new ProjectedColumn(PNameFactory.newName(aliasedName), familyName, position++, sourceColumn.isNullable(), sourceColumnRef, sourceColumn.getColumnQualifierBytes());
            projectedColumns.add(column);
        }
        PTable.EncodedCQCounter cqCounter = PTable.EncodedCQCounter.NULL_COUNTER;
        if (EncodedColumnsUtil.usesEncodedColumnNames(table)) {
            cqCounter = PTable.EncodedCQCounter.copy(table.getEncodedCQCounter());
        }
        return PTableImpl.makePTable(table.getTenantId(), PROJECTED_TABLE_SCHEMA, table.getName(), PTableType.PROJECTED, null, table.getTimeStamp(), table.getSequenceNumber(), table.getPKName(), retainPKColumns ? table.getBucketNum() : null, projectedColumns, null, null, Collections.emptyList(), table.isImmutableRows(), Collections.emptyList(), null, null, table.isWALDisabled(), table.isMultiTenant(), table.getStoreNulls(), table.getViewType(), table.getViewIndexId(), null, table.rowKeyOrderOptimizable(), table.isTransactional(), table.getUpdateCacheFrequency(), table.getIndexDisableTimestamp(), table.isNamespaceMapped(), table.getAutoPartitionSeqName(), table.isAppendOnlySchema(), table.getImmutableStorageScheme(), table.getEncodingScheme(), cqCounter, table.useStatsForParallelization());
    }

    private static class ColumnRefVisitor
    extends StatelessTraverseAllParseNodeVisitor {
        private final StatementContext context;
        private final Set<ColumnRef> columnRefSet;
        private final Set<LocalIndexDataColumnRef> localIndexColumnRefSet;

        private ColumnRefVisitor(StatementContext context) {
            this.context = context;
            this.columnRefSet = new HashSet<ColumnRef>();
            this.localIndexColumnRefSet = new HashSet<LocalIndexDataColumnRef>();
        }

        @Override
        public Void visit(ColumnParseNode node) throws SQLException {
            try {
                this.columnRefSet.add(this.context.getResolver().resolveColumn(node.getSchemaName(), node.getTableName(), node.getName()));
            }
            catch (ColumnNotFoundException e) {
                if (this.context.getCurrentTable().getTable().getIndexType() == PTable.IndexType.LOCAL) {
                    try {
                        this.localIndexColumnRefSet.add(new LocalIndexDataColumnRef(this.context, node.getName()));
                    }
                    catch (ColumnFamilyNotFoundException c) {
                        throw e;
                    }
                }
                throw e;
            }
            return null;
        }
    }
}

