/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.phoenix.cache.GlobalCache;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.WhereCompiler;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.coprocessor.SuffixFilter;
import org.apache.phoenix.coprocessor.generated.MetaDataProtos;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.ProjectedColumnExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.expression.visitor.StatelessTraverseAllExpressionVisitor;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.metrics.Metrics;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.PSchema;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.protobuf.ProtobufUtil;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PMetaDataEntity;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SequenceAllocation;
import org.apache.phoenix.schema.SequenceAlreadyExistsException;
import org.apache.phoenix.schema.SequenceKey;
import org.apache.phoenix.schema.SequenceNotFoundException;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.TableProperty;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.KeyValueUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;
import org.apache.phoenix.util.UpgradeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataEndpointImpl
extends MetaDataProtocol
implements CoprocessorService,
Coprocessor {
    private static final Logger logger = LoggerFactory.getLogger(MetaDataEndpointImpl.class);
    public static final String ROW_KEY_ORDER_OPTIMIZABLE = "ROW_KEY_ORDER_OPTIMIZABLE";
    public static final byte[] ROW_KEY_ORDER_OPTIMIZABLE_BYTES = Bytes.toBytes((String)"ROW_KEY_ORDER_OPTIMIZABLE");
    private static final KeyValue TABLE_TYPE_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.TABLE_TYPE_BYTES);
    private static final KeyValue TABLE_SEQ_NUM_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.TABLE_SEQ_NUM_BYTES);
    private static final KeyValue COLUMN_COUNT_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.COLUMN_COUNT_BYTES);
    private static final KeyValue SALT_BUCKETS_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.SALT_BUCKETS_BYTES);
    private static final KeyValue PK_NAME_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.PK_NAME_BYTES);
    private static final KeyValue DATA_TABLE_NAME_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.DATA_TABLE_NAME_BYTES);
    private static final KeyValue INDEX_STATE_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.INDEX_STATE_BYTES);
    private static final KeyValue IMMUTABLE_ROWS_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.IMMUTABLE_ROWS_BYTES);
    private static final KeyValue VIEW_EXPRESSION_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.VIEW_STATEMENT_BYTES);
    private static final KeyValue DEFAULT_COLUMN_FAMILY_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.DEFAULT_COLUMN_FAMILY_NAME_BYTES);
    private static final KeyValue DISABLE_WAL_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.DISABLE_WAL_BYTES);
    private static final KeyValue MULTI_TENANT_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.MULTI_TENANT_BYTES);
    private static final KeyValue VIEW_TYPE_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.VIEW_TYPE_BYTES);
    private static final KeyValue VIEW_INDEX_ID_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.VIEW_INDEX_ID_BYTES);
    private static final KeyValue INDEX_TYPE_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.INDEX_TYPE_BYTES);
    private static final KeyValue INDEX_DISABLE_TIMESTAMP_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.INDEX_DISABLE_TIMESTAMP_BYTES);
    private static final KeyValue STORE_NULLS_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.STORE_NULLS_BYTES);
    private static final KeyValue EMPTY_KEYVALUE_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])QueryConstants.EMPTY_COLUMN_BYTES);
    private static final KeyValue BASE_COLUMN_COUNT_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.BASE_COLUMN_COUNT_BYTES);
    private static final KeyValue ROW_KEY_ORDER_OPTIMIZABLE_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])ROW_KEY_ORDER_OPTIMIZABLE_BYTES);
    private static final KeyValue TRANSACTIONAL_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.TRANSACTIONAL_BYTES);
    private static final KeyValue UPDATE_CACHE_FREQUENCY_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.UPDATE_CACHE_FREQUENCY_BYTES);
    private static final KeyValue IS_NAMESPACE_MAPPED_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.IS_NAMESPACE_MAPPED_BYTES);
    private static final KeyValue AUTO_PARTITION_SEQ_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.AUTO_PARTITION_SEQ_BYTES);
    private static final KeyValue APPEND_ONLY_SCHEMA_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.APPEND_ONLY_SCHEMA_BYTES);
    private static final KeyValue STORAGE_SCHEME_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.STORAGE_SCHEME_BYTES);
    private static final KeyValue ENCODING_SCHEME_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.ENCODING_SCHEME_BYTES);
    private static final KeyValue USE_STATS_FOR_PARALLELIZATION_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.USE_STATS_FOR_PARALLELIZATION_BYTES);
    private static final List<KeyValue> TABLE_KV_COLUMNS = Arrays.asList(EMPTY_KEYVALUE_KV, TABLE_TYPE_KV, TABLE_SEQ_NUM_KV, COLUMN_COUNT_KV, SALT_BUCKETS_KV, PK_NAME_KV, DATA_TABLE_NAME_KV, INDEX_STATE_KV, IMMUTABLE_ROWS_KV, VIEW_EXPRESSION_KV, DEFAULT_COLUMN_FAMILY_KV, DISABLE_WAL_KV, MULTI_TENANT_KV, VIEW_TYPE_KV, VIEW_INDEX_ID_KV, INDEX_TYPE_KV, INDEX_DISABLE_TIMESTAMP_KV, STORE_NULLS_KV, BASE_COLUMN_COUNT_KV, ROW_KEY_ORDER_OPTIMIZABLE_KV, TRANSACTIONAL_KV, UPDATE_CACHE_FREQUENCY_KV, IS_NAMESPACE_MAPPED_KV, AUTO_PARTITION_SEQ_KV, APPEND_ONLY_SCHEMA_KV, STORAGE_SCHEME_KV, ENCODING_SCHEME_KV, USE_STATS_FOR_PARALLELIZATION_KV);
    private static final int TABLE_TYPE_INDEX;
    private static final int TABLE_SEQ_NUM_INDEX;
    private static final int COLUMN_COUNT_INDEX;
    private static final int SALT_BUCKETS_INDEX;
    private static final int PK_NAME_INDEX;
    private static final int DATA_TABLE_NAME_INDEX;
    private static final int INDEX_STATE_INDEX;
    private static final int IMMUTABLE_ROWS_INDEX;
    private static final int VIEW_STATEMENT_INDEX;
    private static final int DEFAULT_COLUMN_FAMILY_INDEX;
    private static final int DISABLE_WAL_INDEX;
    private static final int MULTI_TENANT_INDEX;
    private static final int VIEW_TYPE_INDEX;
    private static final int VIEW_INDEX_ID_INDEX;
    private static final int INDEX_TYPE_INDEX;
    private static final int STORE_NULLS_INDEX;
    private static final int BASE_COLUMN_COUNT_INDEX;
    private static final int ROW_KEY_ORDER_OPTIMIZABLE_INDEX;
    private static final int TRANSACTIONAL_INDEX;
    private static final int UPDATE_CACHE_FREQUENCY_INDEX;
    private static final int INDEX_DISABLE_TIMESTAMP;
    private static final int IS_NAMESPACE_MAPPED_INDEX;
    private static final int AUTO_PARTITION_SEQ_INDEX;
    private static final int APPEND_ONLY_SCHEMA_INDEX;
    private static final int STORAGE_SCHEME_INDEX;
    private static final int QUALIFIER_ENCODING_SCHEME_INDEX;
    private static final int USE_STATS_FOR_PARALLELIZATION_INDEX;
    private static final KeyValue DECIMAL_DIGITS_KV;
    private static final KeyValue COLUMN_SIZE_KV;
    private static final KeyValue NULLABLE_KV;
    private static final KeyValue DATA_TYPE_KV;
    private static final KeyValue ORDINAL_POSITION_KV;
    private static final KeyValue SORT_ORDER_KV;
    private static final KeyValue ARRAY_SIZE_KV;
    private static final KeyValue VIEW_CONSTANT_KV;
    private static final KeyValue IS_VIEW_REFERENCED_KV;
    private static final KeyValue COLUMN_DEF_KV;
    private static final KeyValue IS_ROW_TIMESTAMP_KV;
    private static final KeyValue COLUMN_QUALIFIER_KV;
    private static final List<KeyValue> COLUMN_KV_COLUMNS;
    private static final KeyValue QUALIFIER_COUNTER_KV;
    private static final int DECIMAL_DIGITS_INDEX;
    private static final int COLUMN_SIZE_INDEX;
    private static final int NULLABLE_INDEX;
    private static final int DATA_TYPE_INDEX;
    private static final int ORDINAL_POSITION_INDEX;
    private static final int SORT_ORDER_INDEX;
    private static final int ARRAY_SIZE_INDEX;
    private static final int VIEW_CONSTANT_INDEX;
    private static final int IS_VIEW_REFERENCED_INDEX;
    private static final int COLUMN_DEF_INDEX;
    private static final int IS_ROW_TIMESTAMP_INDEX;
    private static final int COLUMN_QUALIFIER_INDEX;
    private static final int LINK_TYPE_INDEX = 0;
    private static final KeyValue CLASS_NAME_KV;
    private static final KeyValue JAR_PATH_KV;
    private static final KeyValue RETURN_TYPE_KV;
    private static final KeyValue NUM_ARGS_KV;
    private static final KeyValue TYPE_KV;
    private static final KeyValue IS_CONSTANT_KV;
    private static final KeyValue DEFAULT_VALUE_KV;
    private static final KeyValue MIN_VALUE_KV;
    private static final KeyValue MAX_VALUE_KV;
    private static final KeyValue IS_ARRAY_KV;
    private static final List<KeyValue> FUNCTION_KV_COLUMNS;
    private static final int CLASS_NAME_INDEX;
    private static final int JAR_PATH_INDEX;
    private static final int RETURN_TYPE_INDEX;
    private static final int NUM_ARGS_INDEX;
    private static final List<KeyValue> FUNCTION_ARG_KV_COLUMNS;
    private static final int IS_ARRAY_INDEX;
    private static final int IS_CONSTANT_INDEX;
    private static final int DEFAULT_VALUE_INDEX;
    private static final int MIN_VALUE_INDEX;
    private static final int MAX_VALUE_INDEX;
    private RegionCoprocessorEnvironment env;
    private static final byte[] CHILD_TABLE_BYTES;
    private static final byte[] PHYSICAL_TABLE_BYTES;

    private static PName newPName(byte[] keyBuffer, int keyOffset, int keyLength) {
        if (keyLength <= 0) {
            return null;
        }
        int length = SchemaUtil.getVarCharLength(keyBuffer, keyOffset, keyLength);
        return PNameFactory.newName(keyBuffer, keyOffset, length);
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        if (!(env instanceof RegionCoprocessorEnvironment)) {
            throw new CoprocessorException("Must be loaded on a table region!");
        }
        this.env = (RegionCoprocessorEnvironment)env;
        logger.info("Starting Tracing-Metrics Systems");
        Tracing.addTraceMetricsSource();
        Metrics.ensureConfigured();
    }

    public void stop(CoprocessorEnvironment env) throws IOException {
    }

    public Service getService() {
        return this;
    }

    @Override
    public void getTable(RpcController controller, MetaDataProtos.GetTableRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        MetaDataProtos.MetaDataResponse.Builder builder = MetaDataProtos.MetaDataResponse.newBuilder();
        byte[] tenantId = request.getTenantId().toByteArray();
        byte[] schemaName = request.getSchemaName().toByteArray();
        byte[] tableName = request.getTableName().toByteArray();
        byte[] key = SchemaUtil.getTableKey(tenantId, schemaName, tableName);
        long tableTimeStamp = request.getTableTimestamp();
        try {
            Region region = this.env.getRegion();
            MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkTableKeyInRegion(key, region);
            if (result != null) {
                done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                return;
            }
            long currentTime = EnvironmentEdgeManager.currentTimeMillis();
            PTable table = this.doGetTable(key, request.getClientTimestamp());
            if (table == null) {
                builder.setReturnCode(MetaDataProtos.MutationCode.TABLE_NOT_FOUND);
                builder.setMutationTime(currentTime);
                done.run((Object)builder.build());
                return;
            }
            builder.setReturnCode(MetaDataProtos.MutationCode.TABLE_ALREADY_EXISTS);
            long disableIndexTimestamp = table.getIndexDisableTimestamp();
            long minNonZerodisableIndexTimestamp = disableIndexTimestamp > 0L ? disableIndexTimestamp : Long.MAX_VALUE;
            for (PTable index : table.getIndexes()) {
                disableIndexTimestamp = index.getIndexDisableTimestamp();
                if (disableIndexTimestamp <= 0L || index.getIndexState() != PIndexState.ACTIVE || disableIndexTimestamp >= minNonZerodisableIndexTimestamp) continue;
                minNonZerodisableIndexTimestamp = disableIndexTimestamp;
            }
            if (minNonZerodisableIndexTimestamp == Long.MAX_VALUE) {
                builder.setMutationTime(currentTime);
            } else {
                builder.setMutationTime(minNonZerodisableIndexTimestamp - 1L);
            }
            if (table.getTimeStamp() != tableTimeStamp) {
                builder.setTable(PTableImpl.toProto(table));
            }
            done.run((Object)builder.build());
            return;
        }
        catch (Throwable t) {
            logger.error("getTable failed", t);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(SchemaUtil.getTableName(schemaName, tableName), t));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PTable buildTable(byte[] key, ImmutableBytesPtr cacheKey, Region region, long clientTimeStamp) throws IOException, SQLException {
        Scan scan = MetaDataUtil.newTableRowsScan(key, 0L, clientTimeStamp);
        Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
        try (RegionScanner scanner = region.getScanner(scan);){
            PTable oldTable = (PTable)metaDataCache.getIfPresent((Object)cacheKey);
            long tableTimeStamp = oldTable == null ? -1L : oldTable.getTimeStamp();
            boolean blockWriteRebuildIndex = this.env.getConfiguration().getBoolean("phoenix.index.failure.block.write", false);
            PTable newTable = this.getTable(scanner, clientTimeStamp, tableTimeStamp);
            if (newTable == null) {
                PTable pTable = null;
                return pTable;
            }
            if (oldTable == null || tableTimeStamp < newTable.getTimeStamp() || blockWriteRebuildIndex && newTable.getIndexDisableTimestamp() > 0L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Caching table " + Bytes.toStringBinary((byte[])cacheKey.get(), (int)cacheKey.getOffset(), (int)cacheKey.getLength()) + " at seqNum " + newTable.getSequenceNumber() + " with newer timestamp " + newTable.getTimeStamp() + " versus " + tableTimeStamp);
                }
                metaDataCache.put((Object)cacheKey, (Object)newTable);
            }
            PTable pTable = newTable;
            return pTable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PFunction> buildFunctions(List<byte[]> keys, Region region, long clientTimeStamp, boolean isReplace, List<Mutation> deleteMutationsForReplace) throws IOException, SQLException {
        ArrayList keyRanges = Lists.newArrayListWithExpectedSize((int)keys.size());
        for (byte[] key : keys) {
            byte[] stopKey = ByteUtil.concat(key, new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY});
            ByteUtil.nextKey(stopKey, stopKey.length);
            keyRanges.add(PVarbinary.INSTANCE.getKeyRange(key, true, stopKey, false));
        }
        Scan scan = new Scan();
        scan.setTimeRange(0L, clientTimeStamp);
        ScanRanges scanRanges = ScanRanges.createPointLookup(keyRanges);
        scanRanges.initializeScan(scan);
        scan.setFilter((Filter)scanRanges.getSkipScanFilter());
        RegionScanner scanner = region.getScanner(scan);
        Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
        ArrayList<PFunction> functions = new ArrayList<PFunction>();
        PFunction function = null;
        try {
            for (int i = 0; i < keys.size(); ++i) {
                function = null;
                function = this.getFunction(scanner, isReplace, clientTimeStamp, deleteMutationsForReplace);
                if (function == null) {
                    List<PFunction> list = null;
                    return list;
                }
                byte[] functionKey = SchemaUtil.getFunctionKey(function.getTenantId() == null ? ByteUtil.EMPTY_BYTE_ARRAY : function.getTenantId().getBytes(), Bytes.toBytes((String)function.getFunctionName()));
                metaDataCache.put((Object)new GlobalCache.FunctionBytesPtr(functionKey), (Object)function);
                functions.add(function);
            }
            ArrayList<PFunction> arrayList = functions;
            return arrayList;
        }
        finally {
            scanner.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PSchema> buildSchemas(List<byte[]> keys, Region region, long clientTimeStamp, ImmutableBytesPtr cacheKey) throws IOException, SQLException {
        ArrayList keyRanges = Lists.newArrayListWithExpectedSize((int)keys.size());
        for (byte[] key : keys) {
            byte[] stopKey = ByteUtil.concat(key, new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY});
            ByteUtil.nextKey(stopKey, stopKey.length);
            keyRanges.add(PVarbinary.INSTANCE.getKeyRange(key, true, stopKey, false));
        }
        Scan scan = new Scan();
        scan.setTimeRange(0L, clientTimeStamp);
        ScanRanges scanRanges = ScanRanges.createPointLookup(keyRanges);
        scanRanges.initializeScan(scan);
        scan.setFilter((Filter)scanRanges.getSkipScanFilter());
        RegionScanner scanner = region.getScanner(scan);
        Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
        ArrayList<PSchema> schemas = new ArrayList<PSchema>();
        PSchema schema = null;
        try {
            for (int i = 0; i < keys.size(); ++i) {
                schema = null;
                schema = this.getSchema(scanner, clientTimeStamp);
                if (schema == null) {
                    List<PSchema> list = null;
                    return list;
                }
                metaDataCache.put((Object)cacheKey, (Object)schema);
                schemas.add(schema);
            }
            ArrayList<PSchema> arrayList = schemas;
            return arrayList;
        }
        finally {
            scanner.close();
        }
    }

    private void addIndexToTable(PName tenantId, PName schemaName, PName indexName, PName tableName, long clientTimeStamp, List<PTable> indexes) throws IOException, SQLException {
        byte[] key = SchemaUtil.getTableKey(tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : tenantId.getBytes(), schemaName.getBytes(), indexName.getBytes());
        PTable indexTable = this.doGetTable(key, clientTimeStamp);
        if (indexTable == null) {
            ServerUtil.throwIOException("Index not found", new TableNotFoundException(schemaName.getString(), indexName.getString()));
            return;
        }
        indexes.add(indexTable);
    }

    private void addColumnToTable(List<Cell> results, PName colName, PName famName, Cell[] colKeyValues, List<PColumn> columns, boolean isSalted) {
        Cell sortOrderKv;
        int i = 0;
        int j = 0;
        while (i < results.size() && j < COLUMN_KV_COLUMNS.size()) {
            Cell kv = results.get(i);
            Cell searchKv = (Cell)COLUMN_KV_COLUMNS.get(j);
            int cmp = Bytes.compareTo((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength(), (byte[])searchKv.getQualifierArray(), (int)searchKv.getQualifierOffset(), (int)searchKv.getQualifierLength());
            if (cmp == 0) {
                colKeyValues[j++] = kv;
                ++i;
                continue;
            }
            if (cmp > 0) {
                colKeyValues[j++] = null;
                continue;
            }
            ++i;
        }
        if (colKeyValues[DATA_TYPE_INDEX] == null || colKeyValues[NULLABLE_INDEX] == null || colKeyValues[ORDINAL_POSITION_INDEX] == null) {
            throw new IllegalStateException("Didn't find all required key values in '" + colName.getString() + "' column metadata row");
        }
        Cell columnSizeKv = colKeyValues[COLUMN_SIZE_INDEX];
        Integer maxLength = columnSizeKv == null ? null : Integer.valueOf(PInteger.INSTANCE.getCodec().decodeInt(columnSizeKv.getValueArray(), columnSizeKv.getValueOffset(), SortOrder.getDefault()));
        Cell decimalDigitKv = colKeyValues[DECIMAL_DIGITS_INDEX];
        Integer scale = decimalDigitKv == null ? null : Integer.valueOf(PInteger.INSTANCE.getCodec().decodeInt(decimalDigitKv.getValueArray(), decimalDigitKv.getValueOffset(), SortOrder.getDefault()));
        Cell ordinalPositionKv = colKeyValues[ORDINAL_POSITION_INDEX];
        int position = PInteger.INSTANCE.getCodec().decodeInt(ordinalPositionKv.getValueArray(), ordinalPositionKv.getValueOffset(), SortOrder.getDefault()) + (isSalted ? 1 : 0);
        Cell nullableKv = colKeyValues[NULLABLE_INDEX];
        boolean isNullable = PInteger.INSTANCE.getCodec().decodeInt(nullableKv.getValueArray(), nullableKv.getValueOffset(), SortOrder.getDefault()) != 0;
        Cell dataTypeKv = colKeyValues[DATA_TYPE_INDEX];
        PDataType dataType = PDataType.fromTypeId(PInteger.INSTANCE.getCodec().decodeInt(dataTypeKv.getValueArray(), dataTypeKv.getValueOffset(), SortOrder.getDefault()));
        if (maxLength == null && dataType == PBinary.INSTANCE) {
            dataType = PVarbinary.INSTANCE;
        }
        SortOrder sortOrder = (sortOrderKv = colKeyValues[SORT_ORDER_INDEX]) == null ? SortOrder.getDefault() : SortOrder.fromSystemValue(PInteger.INSTANCE.getCodec().decodeInt(sortOrderKv.getValueArray(), sortOrderKv.getValueOffset(), SortOrder.getDefault()));
        Cell arraySizeKv = colKeyValues[ARRAY_SIZE_INDEX];
        Integer arraySize = arraySizeKv == null ? null : Integer.valueOf(PInteger.INSTANCE.getCodec().decodeInt(arraySizeKv.getValueArray(), arraySizeKv.getValueOffset(), SortOrder.getDefault()));
        Cell viewConstantKv = colKeyValues[VIEW_CONSTANT_INDEX];
        byte[] viewConstant = viewConstantKv == null ? null : viewConstantKv.getValue();
        Cell isViewReferencedKv = colKeyValues[IS_VIEW_REFERENCED_INDEX];
        boolean isViewReferenced = isViewReferencedKv != null && Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(isViewReferencedKv.getValueArray(), isViewReferencedKv.getValueOffset(), isViewReferencedKv.getValueLength()));
        Cell columnDefKv = colKeyValues[COLUMN_DEF_INDEX];
        String expressionStr = columnDefKv == null ? null : (String)PVarchar.INSTANCE.toObject(columnDefKv.getValueArray(), columnDefKv.getValueOffset(), columnDefKv.getValueLength());
        Cell isRowTimestampKV = colKeyValues[IS_ROW_TIMESTAMP_INDEX];
        boolean isRowTimestamp = isRowTimestampKV == null ? false : Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(isRowTimestampKV.getValueArray(), isRowTimestampKV.getValueOffset(), isRowTimestampKV.getValueLength()));
        boolean isPkColumn = famName == null || famName.getString() == null;
        Cell columnQualifierKV = colKeyValues[COLUMN_QUALIFIER_INDEX];
        byte[] columnQualifierBytes = columnQualifierKV != null ? Arrays.copyOfRange(columnQualifierKV.getValueArray(), columnQualifierKV.getValueOffset(), columnQualifierKV.getValueOffset() + columnQualifierKV.getValueLength()) : (isPkColumn ? null : colName.getBytes());
        PColumnImpl column = new PColumnImpl(colName, famName, dataType, maxLength, scale, isNullable, position - 1, sortOrder, arraySize, viewConstant, isViewReferenced, expressionStr, isRowTimestamp, false, columnQualifierBytes);
        columns.add(column);
    }

    private void addArgumentToFunction(List<Cell> results, PName functionName, PName type, Cell[] functionKeyValues, List<PFunction.FunctionArgument> arguments, short argPosition) throws SQLException {
        int i = 0;
        int j = 0;
        while (i < results.size() && j < FUNCTION_ARG_KV_COLUMNS.size()) {
            Cell kv = results.get(i);
            Cell searchKv = (Cell)FUNCTION_ARG_KV_COLUMNS.get(j);
            int cmp = Bytes.compareTo((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength(), (byte[])searchKv.getQualifierArray(), (int)searchKv.getQualifierOffset(), (int)searchKv.getQualifierLength());
            if (cmp == 0) {
                functionKeyValues[j++] = kv;
                ++i;
                continue;
            }
            if (cmp > 0) {
                functionKeyValues[j++] = null;
                continue;
            }
            ++i;
        }
        Cell isArrayKv = functionKeyValues[IS_ARRAY_INDEX];
        boolean isArrayType = isArrayKv == null ? false : Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(isArrayKv.getValueArray(), isArrayKv.getValueOffset(), isArrayKv.getValueLength()));
        Cell isConstantKv = functionKeyValues[IS_CONSTANT_INDEX];
        boolean isConstant = isConstantKv == null ? false : Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(isConstantKv.getValueArray(), isConstantKv.getValueOffset(), isConstantKv.getValueLength()));
        Cell defaultValueKv = functionKeyValues[DEFAULT_VALUE_INDEX];
        String defaultValue = defaultValueKv == null ? null : (String)PVarchar.INSTANCE.toObject(defaultValueKv.getValueArray(), defaultValueKv.getValueOffset(), defaultValueKv.getValueLength());
        Cell minValueKv = functionKeyValues[MIN_VALUE_INDEX];
        String minValue = minValueKv == null ? null : (String)PVarchar.INSTANCE.toObject(minValueKv.getValueArray(), minValueKv.getValueOffset(), minValueKv.getValueLength());
        Cell maxValueKv = functionKeyValues[MAX_VALUE_INDEX];
        String maxValue = maxValueKv == null ? null : (String)PVarchar.INSTANCE.toObject(maxValueKv.getValueArray(), maxValueKv.getValueOffset(), maxValueKv.getValueLength());
        PFunction.FunctionArgument arg = new PFunction.FunctionArgument(type.getString(), isArrayType, isConstant, defaultValue == null ? null : LiteralExpression.newConstant(new LiteralParseNode(defaultValue).getValue()), minValue == null ? null : LiteralExpression.newConstant(new LiteralParseNode(minValue).getValue()), maxValue == null ? null : LiteralExpression.newConstant(new LiteralParseNode(maxValue).getValue()), argPosition);
        arguments.add(arg);
    }

    private PTable getTable(RegionScanner scanner, long clientTimeStamp, long tableTimeStamp) throws IOException, SQLException {
        Cell dataTableNameKv;
        Integer saltBucketNum;
        int tenantIdLength;
        ArrayList results = Lists.newArrayList();
        scanner.next((List)results);
        if (results.isEmpty()) {
            return null;
        }
        Cell[] tableKeyValues = new Cell[TABLE_KV_COLUMNS.size()];
        Cell[] colKeyValues = new Cell[COLUMN_KV_COLUMNS.size()];
        Cell keyValue = (Cell)results.get(0);
        byte[] keyBuffer = keyValue.getRowArray();
        short keyLength = keyValue.getRowLength();
        int keyOffset = keyValue.getRowOffset();
        PName tenantId = MetaDataEndpointImpl.newPName(keyBuffer, keyOffset, keyLength);
        int n = tenantIdLength = tenantId == null ? 0 : tenantId.getBytes().length;
        if (tenantIdLength == 0) {
            tenantId = null;
        }
        PName schemaName = MetaDataEndpointImpl.newPName(keyBuffer, keyOffset + tenantIdLength + 1, keyLength);
        int schemaNameLength = schemaName.getBytes().length;
        int tableNameLength = keyLength - schemaNameLength - 1 - tenantIdLength - 1;
        byte[] tableNameBytes = new byte[tableNameLength];
        System.arraycopy(keyBuffer, keyOffset + schemaNameLength + 1 + tenantIdLength + 1, tableNameBytes, 0, tableNameLength);
        PName tableName = PNameFactory.newName(tableNameBytes);
        int offset = tenantIdLength + schemaNameLength + tableNameLength + 3;
        long timeStamp = keyValue.getTimestamp();
        int i = 0;
        int j = 0;
        while (i < results.size() && j < TABLE_KV_COLUMNS.size()) {
            Cell kv = (Cell)results.get(i);
            Cell searchKv = (Cell)TABLE_KV_COLUMNS.get(j);
            int cmp = Bytes.compareTo((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength(), (byte[])searchKv.getQualifierArray(), (int)searchKv.getQualifierOffset(), (int)searchKv.getQualifierLength());
            if (cmp == 0) {
                timeStamp = Math.max(timeStamp, kv.getTimestamp());
                tableKeyValues[j++] = kv;
                ++i;
                continue;
            }
            if (cmp > 0) {
                timeStamp = Math.max(timeStamp, kv.getTimestamp());
                tableKeyValues[j++] = null;
                continue;
            }
            ++i;
        }
        if (tableKeyValues[TABLE_TYPE_INDEX] == null || tableKeyValues[TABLE_SEQ_NUM_INDEX] == null || tableKeyValues[COLUMN_COUNT_INDEX] == null) {
            throw new IllegalStateException("Didn't find expected key values for table row in metadata row");
        }
        Cell tableTypeKv = tableKeyValues[TABLE_TYPE_INDEX];
        PTableType tableType = PTableType.fromSerializedValue(tableTypeKv.getValueArray()[tableTypeKv.getValueOffset()]);
        Cell tableSeqNumKv = tableKeyValues[TABLE_SEQ_NUM_INDEX];
        long tableSeqNum = PLong.INSTANCE.getCodec().decodeLong(tableSeqNumKv.getValueArray(), tableSeqNumKv.getValueOffset(), SortOrder.getDefault());
        Cell columnCountKv = tableKeyValues[COLUMN_COUNT_INDEX];
        int columnCount = PInteger.INSTANCE.getCodec().decodeInt(columnCountKv.getValueArray(), columnCountKv.getValueOffset(), SortOrder.getDefault());
        Cell pkNameKv = tableKeyValues[PK_NAME_INDEX];
        PName pkName = pkNameKv != null ? MetaDataEndpointImpl.newPName(pkNameKv.getValueArray(), pkNameKv.getValueOffset(), pkNameKv.getValueLength()) : null;
        Cell saltBucketNumKv = tableKeyValues[SALT_BUCKETS_INDEX];
        Integer n2 = saltBucketNum = saltBucketNumKv != null ? Integer.valueOf(PInteger.INSTANCE.getCodec().decodeInt(saltBucketNumKv.getValueArray(), saltBucketNumKv.getValueOffset(), SortOrder.getDefault())) : null;
        if (saltBucketNum != null && saltBucketNum == 0) {
            saltBucketNum = null;
        }
        PName dataTableName = (dataTableNameKv = tableKeyValues[DATA_TABLE_NAME_INDEX]) != null ? MetaDataEndpointImpl.newPName(dataTableNameKv.getValueArray(), dataTableNameKv.getValueOffset(), dataTableNameKv.getValueLength()) : null;
        Cell indexStateKv = tableKeyValues[INDEX_STATE_INDEX];
        PIndexState indexState = indexStateKv == null ? null : PIndexState.fromSerializedValue(indexStateKv.getValueArray()[indexStateKv.getValueOffset()]);
        Cell immutableRowsKv = tableKeyValues[IMMUTABLE_ROWS_INDEX];
        boolean isImmutableRows = immutableRowsKv == null ? false : (Boolean)PBoolean.INSTANCE.toObject(immutableRowsKv.getValueArray(), immutableRowsKv.getValueOffset(), immutableRowsKv.getValueLength());
        Cell defaultFamilyNameKv = tableKeyValues[DEFAULT_COLUMN_FAMILY_INDEX];
        PName defaultFamilyName = defaultFamilyNameKv != null ? MetaDataEndpointImpl.newPName(defaultFamilyNameKv.getValueArray(), defaultFamilyNameKv.getValueOffset(), defaultFamilyNameKv.getValueLength()) : null;
        Cell viewStatementKv = tableKeyValues[VIEW_STATEMENT_INDEX];
        String viewStatement = viewStatementKv != null ? (String)PVarchar.INSTANCE.toObject(viewStatementKv.getValueArray(), viewStatementKv.getValueOffset(), viewStatementKv.getValueLength()) : null;
        Cell disableWALKv = tableKeyValues[DISABLE_WAL_INDEX];
        boolean disableWAL = disableWALKv == null ? false : Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(disableWALKv.getValueArray(), disableWALKv.getValueOffset(), disableWALKv.getValueLength()));
        Cell multiTenantKv = tableKeyValues[MULTI_TENANT_INDEX];
        boolean multiTenant = multiTenantKv == null ? false : Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(multiTenantKv.getValueArray(), multiTenantKv.getValueOffset(), multiTenantKv.getValueLength()));
        Cell storeNullsKv = tableKeyValues[STORE_NULLS_INDEX];
        boolean storeNulls = storeNullsKv == null ? false : Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(storeNullsKv.getValueArray(), storeNullsKv.getValueOffset(), storeNullsKv.getValueLength()));
        Cell transactionalKv = tableKeyValues[TRANSACTIONAL_INDEX];
        boolean transactional = transactionalKv == null ? false : Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(transactionalKv.getValueArray(), transactionalKv.getValueOffset(), transactionalKv.getValueLength()));
        Cell viewTypeKv = tableKeyValues[VIEW_TYPE_INDEX];
        PTable.ViewType viewType = viewTypeKv == null ? null : PTable.ViewType.fromSerializedValue(viewTypeKv.getValueArray()[viewTypeKv.getValueOffset()]);
        Cell viewIndexIdKv = tableKeyValues[VIEW_INDEX_ID_INDEX];
        Short viewIndexId = viewIndexIdKv == null ? null : Short.valueOf(MetaDataUtil.getViewIndexIdDataType().getCodec().decodeShort(viewIndexIdKv.getValueArray(), viewIndexIdKv.getValueOffset(), SortOrder.getDefault()));
        Cell indexTypeKv = tableKeyValues[INDEX_TYPE_INDEX];
        PTable.IndexType indexType = indexTypeKv == null ? null : PTable.IndexType.fromSerializedValue(indexTypeKv.getValueArray()[indexTypeKv.getValueOffset()]);
        Cell baseColumnCountKv = tableKeyValues[BASE_COLUMN_COUNT_INDEX];
        int baseColumnCount = baseColumnCountKv == null ? 0 : PInteger.INSTANCE.getCodec().decodeInt(baseColumnCountKv.getValueArray(), baseColumnCountKv.getValueOffset(), SortOrder.getDefault());
        Cell rowKeyOrderOptimizableKv = tableKeyValues[ROW_KEY_ORDER_OPTIMIZABLE_INDEX];
        boolean rowKeyOrderOptimizable = rowKeyOrderOptimizableKv == null ? false : Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(rowKeyOrderOptimizableKv.getValueArray(), rowKeyOrderOptimizableKv.getValueOffset(), rowKeyOrderOptimizableKv.getValueLength()));
        Cell updateCacheFrequencyKv = tableKeyValues[UPDATE_CACHE_FREQUENCY_INDEX];
        long updateCacheFrequency = updateCacheFrequencyKv == null ? 0L : PLong.INSTANCE.getCodec().decodeLong(updateCacheFrequencyKv.getValueArray(), updateCacheFrequencyKv.getValueOffset(), SortOrder.getDefault());
        Cell indexDisableTimestampKv = tableKeyValues[INDEX_DISABLE_TIMESTAMP];
        long indexDisableTimestamp = indexDisableTimestampKv == null ? 0L : PLong.INSTANCE.getCodec().decodeLong(indexDisableTimestampKv.getValueArray(), indexDisableTimestampKv.getValueOffset(), SortOrder.getDefault());
        Cell isNamespaceMappedKv = tableKeyValues[IS_NAMESPACE_MAPPED_INDEX];
        boolean isNamespaceMapped = isNamespaceMappedKv == null ? false : Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(isNamespaceMappedKv.getValueArray(), isNamespaceMappedKv.getValueOffset(), isNamespaceMappedKv.getValueLength()));
        Cell autoPartitionSeqKv = tableKeyValues[AUTO_PARTITION_SEQ_INDEX];
        String autoPartitionSeq = autoPartitionSeqKv != null ? (String)PVarchar.INSTANCE.toObject(autoPartitionSeqKv.getValueArray(), autoPartitionSeqKv.getValueOffset(), autoPartitionSeqKv.getValueLength()) : null;
        Cell isAppendOnlySchemaKv = tableKeyValues[APPEND_ONLY_SCHEMA_INDEX];
        boolean isAppendOnlySchema = isAppendOnlySchemaKv == null ? false : Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(isAppendOnlySchemaKv.getValueArray(), isAppendOnlySchemaKv.getValueOffset(), isAppendOnlySchemaKv.getValueLength()));
        Cell storageSchemeKv = tableKeyValues[STORAGE_SCHEME_INDEX];
        PTable.ImmutableStorageScheme storageScheme = storageSchemeKv == null ? PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN : PTable.ImmutableStorageScheme.fromSerializedValue((Byte)PTinyint.INSTANCE.toObject(storageSchemeKv.getValueArray(), storageSchemeKv.getValueOffset(), storageSchemeKv.getValueLength()));
        Cell encodingSchemeKv = tableKeyValues[QUALIFIER_ENCODING_SCHEME_INDEX];
        PTable.QualifierEncodingScheme encodingScheme = encodingSchemeKv == null ? PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS : PTable.QualifierEncodingScheme.fromSerializedValue((Byte)PTinyint.INSTANCE.toObject(encodingSchemeKv.getValueArray(), encodingSchemeKv.getValueOffset(), encodingSchemeKv.getValueLength()));
        Cell useStatsForParallelizationKv = tableKeyValues[USE_STATS_FOR_PARALLELIZATION_INDEX];
        boolean useStatsForParallelization = useStatsForParallelizationKv == null ? true : Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(useStatsForParallelizationKv.getValueArray(), useStatsForParallelizationKv.getValueOffset(), useStatsForParallelizationKv.getValueLength()));
        ArrayList columns = Lists.newArrayListWithExpectedSize((int)columnCount);
        ArrayList indexes = Lists.newArrayList();
        ArrayList physicalTables = Lists.newArrayList();
        PName parentTableName = tableType == PTableType.INDEX ? dataTableName : null;
        PName parentSchemaName = tableType == PTableType.INDEX ? schemaName : null;
        PTable.EncodedCQCounter cqCounter = !EncodedColumnsUtil.usesEncodedColumnNames(encodingScheme) || tableType == PTableType.VIEW ? PTable.EncodedCQCounter.NULL_COUNTER : new PTable.EncodedCQCounter();
        while (true) {
            results.clear();
            scanner.next((List)results);
            if (results.isEmpty()) break;
            Cell colKv = (Cell)results.get(0);
            short colKeyLength = colKv.getRowLength();
            PName colName = MetaDataEndpointImpl.newPName(colKv.getRowArray(), colKv.getRowOffset() + offset, colKeyLength - offset);
            int colKeyOffset = offset + colName.getBytes().length + 1;
            PName famName = MetaDataEndpointImpl.newPName(colKv.getRowArray(), colKv.getRowOffset() + colKeyOffset, colKeyLength - colKeyOffset);
            if (this.isQualifierCounterKV(colKv)) {
                Integer value = PInteger.INSTANCE.getCodec().decodeInt(colKv.getValueArray(), colKv.getValueOffset(), SortOrder.ASC);
                cqCounter.setValue(famName.getString(), value);
                continue;
            }
            if (Bytes.compareTo((byte[])PhoenixDatabaseMetaData.LINK_TYPE_BYTES, (int)0, (int)PhoenixDatabaseMetaData.LINK_TYPE_BYTES.length, (byte[])colKv.getQualifierArray(), (int)colKv.getQualifierOffset(), (int)colKv.getQualifierLength()) == 0) {
                PTable.LinkType linkType = PTable.LinkType.fromSerializedValue(colKv.getValueArray()[colKv.getValueOffset()]);
                if (linkType == PTable.LinkType.INDEX_TABLE) {
                    this.addIndexToTable(tenantId, schemaName, famName, tableName, clientTimeStamp, indexes);
                    continue;
                }
                if (linkType == PTable.LinkType.PHYSICAL_TABLE) {
                    physicalTables.add(famName);
                    continue;
                }
                if (linkType != PTable.LinkType.PARENT_TABLE) continue;
                parentTableName = PNameFactory.newName(SchemaUtil.getTableNameFromFullName(famName.getBytes()));
                parentSchemaName = PNameFactory.newName(SchemaUtil.getSchemaNameFromFullName(famName.getBytes()));
                continue;
            }
            this.addColumnToTable(results, colName, famName, colKeyValues, columns, saltBucketNum != null);
        }
        return PTableImpl.makePTable(tenantId, schemaName, tableName, tableType, indexState, timeStamp, tableSeqNum, pkName, saltBucketNum, columns, parentSchemaName, parentTableName, indexes, isImmutableRows, physicalTables, defaultFamilyName, viewStatement, disableWAL, multiTenant, storeNulls, viewType, viewIndexId, indexType, rowKeyOrderOptimizable, transactional, updateCacheFrequency, baseColumnCount, indexDisableTimestamp, isNamespaceMapped, autoPartitionSeq, isAppendOnlySchema, storageScheme, encodingScheme, cqCounter, useStatsForParallelization);
    }

    private boolean isQualifierCounterKV(Cell kv) {
        int cmp = Bytes.compareTo((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength(), (byte[])QUALIFIER_COUNTER_KV.getQualifierArray(), (int)QUALIFIER_COUNTER_KV.getQualifierOffset(), (int)QUALIFIER_COUNTER_KV.getQualifierLength());
        return cmp == 0;
    }

    private PSchema getSchema(RegionScanner scanner, long clientTimeStamp) throws IOException, SQLException {
        int tenantIdLength;
        ArrayList results = Lists.newArrayList();
        scanner.next((List)results);
        if (results.isEmpty()) {
            return null;
        }
        Cell keyValue = (Cell)results.get(0);
        byte[] keyBuffer = keyValue.getRowArray();
        short keyLength = keyValue.getRowLength();
        int keyOffset = keyValue.getRowOffset();
        PName tenantId = MetaDataEndpointImpl.newPName(keyBuffer, keyOffset, keyLength);
        int n = tenantIdLength = tenantId == null ? 0 : tenantId.getBytes().length;
        if (tenantIdLength == 0) {
            tenantId = null;
        }
        PName schemaName = MetaDataEndpointImpl.newPName(keyBuffer, keyOffset + tenantIdLength + 1, keyLength - tenantIdLength - 1);
        long timeStamp = keyValue.getTimestamp();
        return new PSchema(schemaName.getString(), timeStamp);
    }

    private PFunction getFunction(RegionScanner scanner, boolean isReplace, long clientTimeStamp, List<Mutation> deleteMutationsForReplace) throws IOException, SQLException {
        PName tenantId;
        int tenantIdLength;
        ArrayList results = Lists.newArrayList();
        scanner.next((List)results);
        if (results.isEmpty()) {
            return null;
        }
        Cell[] functionKeyValues = new Cell[FUNCTION_KV_COLUMNS.size()];
        Cell[] functionArgKeyValues = new Cell[FUNCTION_ARG_KV_COLUMNS.size()];
        Cell keyValue = (Cell)results.get(0);
        byte[] keyBuffer = keyValue.getRowArray();
        short keyLength = keyValue.getRowLength();
        int keyOffset = keyValue.getRowOffset();
        long currentTimeMillis = EnvironmentEdgeManager.currentTimeMillis();
        if (isReplace) {
            long deleteTimeStamp = clientTimeStamp == Long.MAX_VALUE ? currentTimeMillis - 1L : (keyValue.getTimestamp() < clientTimeStamp ? clientTimeStamp - 1L : keyValue.getTimestamp());
            deleteMutationsForReplace.add((Mutation)new Delete(keyBuffer, keyOffset, (int)keyLength, deleteTimeStamp));
        }
        int n = tenantIdLength = (tenantId = MetaDataEndpointImpl.newPName(keyBuffer, keyOffset, keyLength)) == null ? 0 : tenantId.getBytes().length;
        if (tenantIdLength == 0) {
            tenantId = null;
        }
        PName functionName = MetaDataEndpointImpl.newPName(keyBuffer, keyOffset + tenantIdLength + 1, keyLength - tenantIdLength - 1);
        int functionNameLength = functionName.getBytes().length + 1;
        int offset = tenantIdLength + functionNameLength + 1;
        long timeStamp = keyValue.getTimestamp();
        int i = 0;
        int j = 0;
        while (i < results.size() && j < FUNCTION_KV_COLUMNS.size()) {
            Cell kv = (Cell)results.get(i);
            Cell searchKv = (Cell)FUNCTION_KV_COLUMNS.get(j);
            int cmp = Bytes.compareTo((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength(), (byte[])searchKv.getQualifierArray(), (int)searchKv.getQualifierOffset(), (int)searchKv.getQualifierLength());
            if (cmp == 0) {
                timeStamp = Math.max(timeStamp, kv.getTimestamp());
                functionKeyValues[j++] = kv;
                ++i;
                continue;
            }
            if (cmp > 0) {
                timeStamp = Math.max(timeStamp, kv.getTimestamp());
                functionKeyValues[j++] = null;
                continue;
            }
            ++i;
        }
        if (functionKeyValues[CLASS_NAME_INDEX] == null || functionKeyValues[NUM_ARGS_INDEX] == null) {
            throw new IllegalStateException("Didn't find expected key values for function row in metadata row");
        }
        Cell classNameKv = functionKeyValues[CLASS_NAME_INDEX];
        PName className = MetaDataEndpointImpl.newPName(classNameKv.getValueArray(), classNameKv.getValueOffset(), classNameKv.getValueLength());
        Cell jarPathKv = functionKeyValues[JAR_PATH_INDEX];
        PName jarPath = null;
        if (jarPathKv != null) {
            jarPath = MetaDataEndpointImpl.newPName(jarPathKv.getValueArray(), jarPathKv.getValueOffset(), jarPathKv.getValueLength());
        }
        Cell numArgsKv = functionKeyValues[NUM_ARGS_INDEX];
        int numArgs = PInteger.INSTANCE.getCodec().decodeInt(numArgsKv.getValueArray(), numArgsKv.getValueOffset(), SortOrder.getDefault());
        Cell returnTypeKv = functionKeyValues[RETURN_TYPE_INDEX];
        PName returnType = returnTypeKv == null ? null : MetaDataEndpointImpl.newPName(returnTypeKv.getValueArray(), returnTypeKv.getValueOffset(), returnTypeKv.getValueLength());
        ArrayList arguments = Lists.newArrayListWithExpectedSize((int)numArgs);
        for (int k = 0; k < numArgs; ++k) {
            results.clear();
            scanner.next((List)results);
            if (results.isEmpty()) break;
            Cell typeKv = (Cell)results.get(0);
            if (isReplace) {
                long deleteTimeStamp = clientTimeStamp == Long.MAX_VALUE ? currentTimeMillis - 1L : (typeKv.getTimestamp() < clientTimeStamp ? clientTimeStamp - 1L : typeKv.getTimestamp());
                deleteMutationsForReplace.add((Mutation)new Delete(typeKv.getRowArray(), typeKv.getRowOffset(), (int)typeKv.getRowLength(), deleteTimeStamp));
            }
            short typeKeyLength = typeKv.getRowLength();
            PName typeName = MetaDataEndpointImpl.newPName(typeKv.getRowArray(), typeKv.getRowOffset() + offset, typeKeyLength - offset - 3);
            int argPositionOffset = offset + typeName.getBytes().length + 1;
            short argPosition = Bytes.toShort((byte[])typeKv.getRowArray(), (int)(typeKv.getRowOffset() + argPositionOffset), (int)(typeKeyLength - argPositionOffset));
            this.addArgumentToFunction(results, functionName, typeName, functionArgKeyValues, arguments, argPosition);
        }
        Collections.sort(arguments, new Comparator<PFunction.FunctionArgument>(){

            @Override
            public int compare(PFunction.FunctionArgument o1, PFunction.FunctionArgument o2) {
                return o1.getArgPosition() - o2.getArgPosition();
            }
        });
        return new PFunction(tenantId, functionName.getString(), arguments, returnType.getString(), className.getString(), jarPath == null ? null : jarPath.getString(), timeStamp);
    }

    private PTable buildDeletedTable(byte[] key, ImmutableBytesPtr cacheKey, Region region, long clientTimeStamp) throws IOException {
        if (clientTimeStamp == Long.MAX_VALUE) {
            return null;
        }
        Scan scan = MetaDataUtil.newTableRowsScan(key, clientTimeStamp, Long.MAX_VALUE);
        scan.setFilter((Filter)new FirstKeyOnlyFilter());
        scan.setRaw(true);
        ArrayList results = Lists.newArrayList();
        try (RegionScanner scanner = region.getScanner(scan);){
            scanner.next((List)results);
        }
        for (Cell kv : results) {
            KeyValue.Type type = KeyValue.Type.codeToType((byte)kv.getTypeByte());
            if (type != KeyValue.Type.DeleteFamily) continue;
            Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
            PTable table = MetaDataEndpointImpl.newDeletedTableMarker(kv.getTimestamp());
            metaDataCache.put((Object)cacheKey, (Object)table);
            return table;
        }
        return null;
    }

    private PFunction buildDeletedFunction(byte[] key, ImmutableBytesPtr cacheKey, Region region, long clientTimeStamp) throws IOException {
        Cell kv;
        if (clientTimeStamp == Long.MAX_VALUE) {
            return null;
        }
        Scan scan = MetaDataUtil.newTableRowsScan(key, clientTimeStamp, Long.MAX_VALUE);
        scan.setFilter((Filter)new FirstKeyOnlyFilter());
        scan.setRaw(true);
        ArrayList results = Lists.newArrayList();
        try (RegionScanner scanner = region.getScanner(scan);){
            scanner.next((List)results);
        }
        if (!results.isEmpty() && ((Cell)results.get(0)).getTimestamp() > clientTimeStamp && (kv = (Cell)results.get(0)).getTypeByte() == KeyValue.Type.Delete.getCode()) {
            Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
            PFunction function = MetaDataEndpointImpl.newDeletedFunctionMarker(kv.getTimestamp());
            metaDataCache.put((Object)cacheKey, (Object)function);
            return function;
        }
        return null;
    }

    private PSchema buildDeletedSchema(byte[] key, ImmutableBytesPtr cacheKey, Region region, long clientTimeStamp) throws IOException {
        Cell kv;
        if (clientTimeStamp == Long.MAX_VALUE) {
            return null;
        }
        Scan scan = MetaDataUtil.newTableRowsScan(key, clientTimeStamp, Long.MAX_VALUE);
        scan.setFilter((Filter)new FirstKeyOnlyFilter());
        scan.setRaw(true);
        ArrayList results = Lists.newArrayList();
        try (RegionScanner scanner = region.getScanner(scan);){
            scanner.next((List)results);
        }
        if (!results.isEmpty() && ((Cell)results.get(0)).getTimestamp() > clientTimeStamp && (kv = (Cell)results.get(0)).getTypeByte() == KeyValue.Type.Delete.getCode()) {
            Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
            PSchema schema = MetaDataEndpointImpl.newDeletedSchemaMarker(kv.getTimestamp());
            metaDataCache.put((Object)cacheKey, (Object)schema);
            return schema;
        }
        return null;
    }

    private static PTable newDeletedTableMarker(long timestamp) {
        return new PTableImpl(timestamp);
    }

    private static PFunction newDeletedFunctionMarker(long timestamp) {
        return new PFunction(timestamp);
    }

    private static PSchema newDeletedSchemaMarker(long timestamp) {
        return new PSchema(timestamp);
    }

    private static boolean isTableDeleted(PTable table) {
        return table.getName() == null;
    }

    private static boolean isSchemaDeleted(PSchema schema) {
        return schema.getSchemaName() == null;
    }

    private static boolean isFunctionDeleted(PFunction function) {
        return function.getFunctionName() == null;
    }

    private PTable loadTable(RegionCoprocessorEnvironment env, byte[] key, ImmutableBytesPtr cacheKey, long clientTimeStamp, long asOfTimeStamp) throws IOException, SQLException {
        Region region = env.getRegion();
        Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
        PTable table = (PTable)metaDataCache.getIfPresent((Object)cacheKey);
        if (table != null || (table = this.buildTable(key, cacheKey, region, asOfTimeStamp)) != null) {
            return table;
        }
        if (table == null && (table = this.buildDeletedTable(key, cacheKey, region, clientTimeStamp)) != null) {
            return table;
        }
        return null;
    }

    private PFunction loadFunction(RegionCoprocessorEnvironment env, byte[] key, ImmutableBytesPtr cacheKey, long clientTimeStamp, long asOfTimeStamp, boolean isReplace, List<Mutation> deleteMutationsForReplace) throws IOException, SQLException {
        Region region = env.getRegion();
        Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
        PFunction function = (PFunction)metaDataCache.getIfPresent((Object)cacheKey);
        if (function != null && !isReplace) {
            return function;
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(1);
        arrayList.add(key);
        List<PFunction> functions = this.buildFunctions(arrayList, region, asOfTimeStamp, isReplace, deleteMutationsForReplace);
        if (functions != null) {
            return functions.get(0);
        }
        if (function == null && (function = this.buildDeletedFunction(key, cacheKey, region, clientTimeStamp)) != null) {
            return function;
        }
        return null;
    }

    private PSchema loadSchema(RegionCoprocessorEnvironment env, byte[] key, ImmutableBytesPtr cacheKey, long clientTimeStamp, long asOfTimeStamp) throws IOException, SQLException {
        Region region = env.getRegion();
        Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
        PSchema schema = (PSchema)metaDataCache.getIfPresent((Object)cacheKey);
        if (schema != null) {
            return schema;
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(1);
        arrayList.add(key);
        List<PSchema> schemas = this.buildSchemas(arrayList, region, asOfTimeStamp, cacheKey);
        if (schemas != null) {
            return schemas.get(0);
        }
        if (schema == null && (schema = this.buildDeletedSchema(key, cacheKey, region, clientTimeStamp)) != null) {
            return schema;
        }
        return null;
    }

    private static Mutation getPhysicalTableForView(List<Mutation> tableMetadata, byte[][] parentSchemaTableNames) {
        int size = tableMetadata.size();
        byte[][] rowKeyMetaData = new byte[3][];
        MetaDataUtil.getTenantIdAndSchemaAndTableName(tableMetadata, rowKeyMetaData);
        Mutation physicalTableRow = null;
        boolean physicalTableLinkFound = false;
        if (size >= 2) {
            for (int i = size - 1; i >= 1; --i) {
                PTable.LinkType linkType;
                Mutation m = tableMetadata.get(i);
                if (!(m instanceof Put) || (linkType = MetaDataUtil.getLinkType(m)) != PTable.LinkType.PHYSICAL_TABLE) continue;
                physicalTableRow = m;
                physicalTableLinkFound = true;
                break;
            }
        }
        if (!physicalTableLinkFound) {
            parentSchemaTableNames[0] = null;
            parentSchemaTableNames[1] = null;
            return null;
        }
        rowKeyMetaData = new byte[5][];
        SchemaUtil.getVarChars(physicalTableRow.getRow(), 5, rowKeyMetaData);
        byte[] colBytes = rowKeyMetaData[3];
        byte[] famBytes = rowKeyMetaData[4];
        if ((colBytes == null || colBytes.length == 0) && famBytes != null && famBytes.length > 0) {
            byte[] sName = SchemaUtil.getSchemaNameFromFullName(famBytes).getBytes();
            byte[] tName = SchemaUtil.getTableNameFromFullName(famBytes).getBytes();
            parentSchemaTableNames[0] = sName;
            parentSchemaTableNames[1] = tName;
        }
        return physicalTableRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTable(RpcController controller, MetaDataProtos.CreateTableRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        MetaDataProtos.MetaDataResponse.Builder builder = MetaDataProtos.MetaDataResponse.newBuilder();
        byte[][] rowKeyMetaData = new byte[3][];
        byte[] schemaName = null;
        byte[] tableName = null;
        try {
            List<Mutation> tableMetadata = ProtobufUtil.getMutations(request);
            MetaDataUtil.getTenantIdAndSchemaAndTableName(tableMetadata, rowKeyMetaData);
            byte[] tenantIdBytes = rowKeyMetaData[0];
            schemaName = rowKeyMetaData[1];
            tableName = rowKeyMetaData[2];
            byte[] parentSchemaName = null;
            byte[] parentTableName = null;
            PTableType tableType = MetaDataUtil.getTableType(tableMetadata, GenericKeyValueBuilder.INSTANCE, new ImmutableBytesWritable());
            byte[] parentTableKey = null;
            Mutation viewPhysicalTableRow = null;
            if (tableType == PTableType.VIEW) {
                byte[][] parentSchemaTableNames = new byte[2][];
                viewPhysicalTableRow = MetaDataEndpointImpl.getPhysicalTableForView(tableMetadata, parentSchemaTableNames);
                parentSchemaName = parentSchemaTableNames[0];
                parentTableName = parentSchemaTableNames[1];
                if (parentTableName != null) {
                    parentTableKey = SchemaUtil.getTableKey(ByteUtil.EMPTY_BYTE_ARRAY, parentSchemaName, parentTableName);
                }
            } else if (tableType == PTableType.INDEX) {
                parentSchemaName = schemaName;
                parentTableName = MetaDataUtil.getParentTableName(tableMetadata);
                parentTableKey = SchemaUtil.getTableKey(tenantIdBytes, parentSchemaName, parentTableName);
            }
            Region region = this.env.getRegion();
            ArrayList locks = Lists.newArrayList();
            byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes, schemaName, tableName);
            try {
                Throwable throwable;
                PhoenixConnection connection;
                ImmutableBytesPtr cacheKey;
                PTable table;
                MetaDataEndpointImpl.acquireLock(region, tableKey, locks);
                MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkTableKeyInRegion(tableKey, region);
                if (result != null) {
                    done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                    return;
                }
                long clientTimeStamp = MetaDataUtil.getClientTimeStamp(tableMetadata);
                ImmutableBytesPtr parentCacheKey = null;
                PTable parentTable = null;
                if (parentTableName != null && (result = MetaDataEndpointImpl.checkTableKeyInRegion(parentTableKey, region)) == null) {
                    MetaDataEndpointImpl.acquireLock(region, parentTableKey, locks);
                    parentCacheKey = new ImmutableBytesPtr(parentTableKey);
                    parentTable = this.loadTable(this.env, parentTableKey, parentCacheKey, clientTimeStamp, clientTimeStamp);
                    if (parentTable == null || MetaDataEndpointImpl.isTableDeleted(parentTable)) {
                        builder.setReturnCode(MetaDataProtos.MutationCode.PARENT_TABLE_NOT_FOUND);
                        builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                        done.run((Object)builder.build());
                        return;
                    }
                    long parentTableSeqNumber = tableType == PTableType.VIEW && viewPhysicalTableRow != null && request.hasClientVersion() ? MetaDataUtil.getSequenceNumber(viewPhysicalTableRow) : (tableType == PTableType.VIEW && !request.hasClientVersion() ? parentTable.getSequenceNumber() : MetaDataUtil.getParentSequenceNumber(tableMetadata));
                    if (parentTable.getSequenceNumber() != parentTableSeqNumber) {
                        builder.setReturnCode(MetaDataProtos.MutationCode.CONCURRENT_TABLE_MUTATION);
                        builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                        builder.setTable(PTableImpl.toProto(parentTable));
                        done.run((Object)builder.build());
                        return;
                    }
                }
                if ((table = this.loadTable(this.env, tableKey, cacheKey = new ImmutableBytesPtr(tableKey), clientTimeStamp, Long.MAX_VALUE)) != null) {
                    if (table.getTimeStamp() < clientTimeStamp) {
                        if (!MetaDataEndpointImpl.isTableDeleted(table)) {
                            builder.setReturnCode(MetaDataProtos.MutationCode.TABLE_ALREADY_EXISTS);
                            builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                            builder.setTable(PTableImpl.toProto(table));
                            done.run((Object)builder.build());
                            return;
                        }
                    } else {
                        builder.setReturnCode(MetaDataProtos.MutationCode.NEWER_TABLE_FOUND);
                        builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                        builder.setTable(PTableImpl.toProto(table));
                        done.run((Object)builder.build());
                        return;
                    }
                }
                if (tableType != PTableType.VIEW) {
                    UpgradeUtil.addRowKeyOrderOptimizableCell(tableMetadata, tableKey, clientTimeStamp);
                }
                if (parentTable != null && parentTable.getAutoPartitionSeqName() != null) {
                    long autoPartitionNum = 1L;
                    try {
                        connection = QueryUtil.getConnectionOnServer(this.env.getConfiguration()).unwrap(PhoenixConnection.class);
                        throwable = null;
                        try (Statement stmt = connection.createStatement();){
                            String seqName = parentTable.getAutoPartitionSeqName();
                            String seqNextValueSql = String.format("SELECT NEXT VALUE FOR %s", seqName);
                            PhoenixStatement ps = stmt.unwrap(PhoenixStatement.class);
                            QueryPlan plan = ps.compileQuery(seqNextValueSql);
                            ResultIterator resultIterator = plan.iterator();
                            PhoenixResultSet rs = ps.newResultSet(resultIterator, plan.getProjector(), plan.getContext());
                            rs.next();
                            autoPartitionNum = rs.getLong(1);
                        }
                        catch (Throwable x2) {
                            throwable = x2;
                            throw x2;
                        }
                        finally {
                            if (connection != null) {
                                if (throwable != null) {
                                    try {
                                        connection.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                } else {
                                    connection.close();
                                }
                            }
                        }
                    }
                    catch (SequenceNotFoundException e) {
                        builder.setReturnCode(MetaDataProtos.MutationCode.AUTO_PARTITION_SEQUENCE_NOT_FOUND);
                        builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                        done.run((Object)builder.build());
                        region.releaseRowLocks((List)locks);
                        return;
                    }
                    PColumn autoPartitionCol = parentTable.getPKColumns().get(MetaDataUtil.getAutoPartitionColIndex(parentTable));
                    if (!PLong.INSTANCE.isCoercibleTo(autoPartitionCol.getDataType(), autoPartitionNum)) {
                        builder.setReturnCode(MetaDataProtos.MutationCode.CANNOT_COERCE_AUTO_PARTITION_ID);
                        builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                        done.run((Object)builder.build());
                        return;
                    }
                    builder.setAutoPartitionNum(autoPartitionNum);
                    Put tableHeaderPut = MetaDataUtil.getPutOnlyTableHeaderRow(tableMetadata);
                    NavigableMap familyCellMap = tableHeaderPut.getFamilyCellMap();
                    List cells = (List)familyCellMap.get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES);
                    Cell cell = (Cell)cells.get(0);
                    String autoPartitionWhere = QueryUtil.getViewPartitionClause(MetaDataUtil.getAutoPartitionColumnName(parentTable), autoPartitionNum);
                    String hbaseVersion = VersionInfo.getVersion();
                    ImmutableBytesPtr ptr = new ImmutableBytesPtr();
                    KeyValueBuilder kvBuilder = KeyValueBuilder.get(hbaseVersion);
                    MetaDataUtil.getMutationValue((Mutation)tableHeaderPut, PhoenixDatabaseMetaData.VIEW_STATEMENT_BYTES, kvBuilder, ptr);
                    byte[] value = ptr.copyBytesIfNecessary();
                    byte[] viewStatement = null;
                    viewStatement = !Bytes.equals((byte[])value, (byte[])QueryConstants.EMPTY_COLUMN_VALUE_BYTES) ? Bytes.add((byte[])value, (byte[])Bytes.toBytes((String)" AND "), (byte[])Bytes.toBytes((String)autoPartitionWhere)) : Bytes.toBytes((String)QueryUtil.getViewStatement(parentTable.getSchemaName().getString(), parentTable.getTableName().getString(), autoPartitionWhere));
                    KeyValue viewStatementCell = new KeyValue(cell.getRow(), cell.getFamily(), PhoenixDatabaseMetaData.VIEW_STATEMENT_BYTES, cell.getTimestamp(), KeyValue.Type.codeToType((byte)cell.getTypeByte()), viewStatement);
                    cells.add(viewStatementCell);
                    Put autoPartitionPut = MetaDataUtil.getPutOnlyAutoPartitionColumn(parentTable, tableMetadata);
                    familyCellMap = autoPartitionPut.getFamilyCellMap();
                    cells = (List)familyCellMap.get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES);
                    cell = (Cell)cells.get(0);
                    PDataType dataType = autoPartitionCol.getDataType();
                    Object val = dataType.toObject(autoPartitionNum, (PDataType)PLong.INSTANCE);
                    byte[] bytes = new byte[dataType.getByteSize() + 1];
                    dataType.toBytes(val, bytes, 0);
                    KeyValue viewConstantCell = new KeyValue(cell.getRow(), cell.getFamily(), PhoenixDatabaseMetaData.VIEW_CONSTANT_BYTES, cell.getTimestamp(), KeyValue.Type.codeToType((byte)cell.getTypeByte()), bytes);
                    cells.add(viewConstantCell);
                }
                Short indexId = null;
                if (request.hasAllocateIndexId() && request.getAllocateIndexId()) {
                    String tenantIdStr = tenantIdBytes.length == 0 ? null : Bytes.toString((byte[])tenantIdBytes);
                    connection = QueryUtil.getConnectionOnServer(this.env.getConfiguration()).unwrap(PhoenixConnection.class);
                    throwable = null;
                    try {
                        PName physicalName = parentTable.getPhysicalName();
                        int nSequenceSaltBuckets = connection.getQueryServices().getSequenceSaltBuckets();
                        SequenceKey key = MetaDataUtil.getViewIndexSequenceKey(tenantIdStr, physicalName, nSequenceSaltBuckets, parentTable.isNamespaceMapped());
                        long sequenceTimestamp = Long.MAX_VALUE;
                        try {
                            connection.getQueryServices().createSequence(key.getTenantId(), key.getSchemaName(), key.getSequenceName(), -32768L, 1L, 1L, Long.MIN_VALUE, Long.MAX_VALUE, false, sequenceTimestamp);
                        }
                        catch (SequenceAlreadyExistsException ptr) {
                            // empty catch block
                        }
                        long[] seqValues = new long[1];
                        SQLException[] sqlExceptions = new SQLException[1];
                        connection.getQueryServices().incrementSequences(Collections.singletonList(new SequenceAllocation(key, 1L)), Long.MAX_VALUE, seqValues, sqlExceptions);
                        if (sqlExceptions[0] != null) {
                            throw sqlExceptions[0];
                        }
                        long seqValue = seqValues[0];
                        if (seqValue > 32767L) {
                            builder.setReturnCode(MetaDataProtos.MutationCode.TOO_MANY_INDEXES);
                            builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                            done.run((Object)builder.build());
                            return;
                        }
                        Put tableHeaderPut = MetaDataUtil.getPutOnlyTableHeaderRow(tableMetadata);
                        NavigableMap familyCellMap = tableHeaderPut.getFamilyCellMap();
                        List cells = (List)familyCellMap.get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES);
                        Cell cell = (Cell)cells.get(0);
                        PDataType dataType = MetaDataUtil.getViewIndexIdDataType();
                        Object val = dataType.toObject(seqValue, (PDataType)PLong.INSTANCE);
                        byte[] bytes = new byte[dataType.getByteSize() + 1];
                        dataType.toBytes(val, bytes, 0);
                        KeyValue indexIdCell = new KeyValue(cell.getRow(), cell.getFamily(), PhoenixDatabaseMetaData.VIEW_INDEX_ID_BYTES, cell.getTimestamp(), KeyValue.Type.codeToType((byte)cell.getTypeByte()), bytes);
                        cells.add(indexIdCell);
                        indexId = (short)seqValue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (connection != null) {
                            if (throwable != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                connection.close();
                            }
                        }
                    }
                }
                region.mutateRowsWithLocks(tableMetadata, Collections.emptySet(), 0L, 0L);
                Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
                if (parentCacheKey != null) {
                    metaDataCache.invalidate((Object)parentCacheKey);
                }
                metaDataCache.invalidate((Object)cacheKey);
                long currentTimeStamp = MetaDataUtil.getClientTimeStamp(tableMetadata);
                builder.setReturnCode(MetaDataProtos.MutationCode.TABLE_NOT_FOUND);
                if (indexId != null) {
                    builder.setViewIndexId(indexId.shortValue());
                }
                builder.setMutationTime(currentTimeStamp);
                done.run((Object)builder.build());
                return;
            }
            finally {
                region.releaseRowLocks((List)locks);
            }
        }
        catch (Throwable t) {
            logger.error("createTable failed", t);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(SchemaUtil.getTableName(schemaName, tableName), t));
            return;
        }
    }

    private static Region.RowLock acquireLock(Region region, byte[] key, List<Region.RowLock> locks) throws IOException {
        Region.RowLock rowLock = region.getRowLock(key, true);
        if (rowLock == null) {
            throw new IOException("Failed to acquire lock on " + Bytes.toStringBinary((byte[])key));
        }
        locks.add(rowLock);
        return rowLock;
    }

    private void findAllChildViews(Region region, byte[] tenantId, PTable table, TableViewFinder result, long clientTimeStamp) throws IOException, SQLException {
        TableViewFinder currResult = this.findChildViews(region, tenantId, table);
        result.addResult(currResult);
        for (ViewInfo viewInfo : currResult.getViewInfoList()) {
            byte[] viewtenantId = viewInfo.getTenantId();
            byte[] viewSchema = viewInfo.getSchemaName();
            byte[] viewTable = viewInfo.getViewName();
            byte[] tableKey = SchemaUtil.getTableKey(viewtenantId, viewSchema, viewTable);
            ImmutableBytesPtr cacheKey = new ImmutableBytesPtr(tableKey);
            PTable view = this.loadTable(this.env, tableKey, cacheKey, clientTimeStamp, clientTimeStamp);
            this.findAllChildViews(region, viewtenantId, view, result, clientTimeStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private TableViewFinder findChildViews_deprecated(Region region, byte[] tenantId, PTable table, byte[] linkTypeBytes) throws IOException {
        byte[] schemaName = table.getSchemaName().getBytes();
        byte[] tableName = table.getTableName().getBytes();
        boolean isMultiTenant = table.isMultiTenant();
        Scan scan = new Scan();
        if (!isMultiTenant) {
            byte[] startRow = ByteUtil.concat(tenantId, new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY});
            byte[] stopRow = ByteUtil.nextKey(startRow);
            scan.setStartRow(startRow);
            scan.setStopRow(stopRow);
        }
        SingleColumnValueFilter linkFilter = new SingleColumnValueFilter(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.LINK_TYPE_BYTES, CompareFilter.CompareOp.EQUAL, linkTypeBytes);
        SingleColumnValueFilter tableTypeFilter = new SingleColumnValueFilter(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.TABLE_TYPE_BYTES, CompareFilter.CompareOp.EQUAL, PTableType.VIEW.getSerializedValue().getBytes());
        tableTypeFilter.setFilterIfMissing(false);
        linkFilter.setFilterIfMissing(true);
        byte[] suffix = ByteUtil.concat(QueryConstants.SEPARATOR_BYTE_ARRAY, new byte[][]{SchemaUtil.getPhysicalTableName(SchemaUtil.getTableNameAsBytes(schemaName, tableName), table.isNamespaceMapped()).getName()});
        SuffixFilter rowFilter = new SuffixFilter(suffix);
        FilterList filter = new FilterList(new Filter[]{linkFilter, tableTypeFilter, rowFilter});
        scan.setFilter((Filter)filter);
        scan.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.LINK_TYPE_BYTES);
        scan.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.TABLE_TYPE_BYTES);
        scan.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.TABLE_SEQ_NUM_BYTES);
        try (HTableInterface hTable = ServerUtil.getHTableForCoprocessorScan(this.env, region.getTableDesc().getTableName().getName());){
            TableViewFinder tableViewFinder;
            boolean allViewsInCurrentRegion = true;
            int numOfChildViews = 0;
            ArrayList viewInfoList = Lists.newArrayList();
            ResultScanner scanner = hTable.getScanner(scan);
            try {
                Result result = scanner.next();
                while (result != null) {
                    ++numOfChildViews;
                    ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                    ResultTuple resultTuple = new ResultTuple(result);
                    resultTuple.getKey(ptr);
                    byte[] key = ptr.copyBytes();
                    if (MetaDataEndpointImpl.checkTableKeyInRegion(key, region) != null) {
                        allViewsInCurrentRegion = false;
                    }
                    byte[][] rowKeyMetaData = new byte[3][];
                    SchemaUtil.getVarChars(result.getRow(), 3, rowKeyMetaData);
                    byte[] viewTenantId = rowKeyMetaData[0];
                    byte[] viewSchemaName = rowKeyMetaData[1];
                    byte[] viewName = rowKeyMetaData[2];
                    viewInfoList.add(new ViewInfo(viewTenantId, viewSchemaName, viewName));
                    result = scanner.next();
                }
                TableViewFinder tableViewFinderResult = new TableViewFinder(viewInfoList);
                if (numOfChildViews > 0 && !allViewsInCurrentRegion) {
                    tableViewFinderResult.setAllViewsNotInSingleRegion();
                }
                tableViewFinder = tableViewFinderResult;
            }
            catch (Throwable throwable) {
                scanner.close();
                throw throwable;
            }
            scanner.close();
            return tableViewFinder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableViewFinder findChildViews_4_11(Region region, byte[] tenantId, byte[] schemaName, byte[] tableName) throws IOException {
        Scan scan = new Scan();
        byte[] startRow = SchemaUtil.getTableKey(tenantId, schemaName, tableName);
        byte[] stopRow = ByteUtil.nextKey(startRow);
        scan.setStartRow(startRow);
        scan.setStopRow(stopRow);
        SingleColumnValueFilter linkFilter = new SingleColumnValueFilter(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.LINK_TYPE_BYTES, CompareFilter.CompareOp.EQUAL, CHILD_TABLE_BYTES);
        linkFilter.setFilterIfMissing(true);
        scan.setFilter((Filter)linkFilter);
        scan.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.LINK_TYPE_BYTES);
        scan.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.PARENT_TENANT_ID_BYTES);
        try (HTableInterface hTable = ServerUtil.getHTableForCoprocessorScan(this.env, region.getTableDesc().getTableName().getName());){
            TableViewFinder tableViewFinder;
            boolean allViewsInCurrentRegion = true;
            int numOfChildViews = 0;
            ArrayList viewInfoList = Lists.newArrayList();
            ResultScanner scanner = hTable.getScanner(scan);
            try {
                Result result = scanner.next();
                while (result != null) {
                    ++numOfChildViews;
                    ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                    ResultTuple resultTuple = new ResultTuple(result);
                    resultTuple.getKey(ptr);
                    byte[] key = ptr.copyBytes();
                    if (MetaDataEndpointImpl.checkTableKeyInRegion(key, region) != null) {
                        allViewsInCurrentRegion = false;
                    }
                    byte[][] rowViewKeyMetaData = new byte[5][];
                    SchemaUtil.getVarChars(result.getRow(), 5, rowViewKeyMetaData);
                    byte[] viewTenantId = rowViewKeyMetaData[3];
                    byte[] viewSchemaName = SchemaUtil.getSchemaNameFromFullName(rowViewKeyMetaData[4]).getBytes();
                    byte[] viewName = SchemaUtil.getTableNameFromFullName(rowViewKeyMetaData[4]).getBytes();
                    viewInfoList.add(new ViewInfo(viewTenantId, viewSchemaName, viewName));
                    result = scanner.next();
                }
                TableViewFinder tableViewFinderResult = new TableViewFinder(viewInfoList);
                if (numOfChildViews > 0 && !allViewsInCurrentRegion) {
                    tableViewFinderResult.setAllViewsNotInSingleRegion();
                }
                tableViewFinder = tableViewFinderResult;
            }
            catch (Throwable throwable) {
                scanner.close();
                throw throwable;
            }
            scanner.close();
            return tableViewFinder;
        }
    }

    private TableViewFinder findChildViews(Region region, byte[] tenantId, PTable table) throws IOException, SQLException {
        ImmutableBytesPtr cacheKey;
        byte[] tableKey = SchemaUtil.getTableKey(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.SYSTEM_CATALOG_SCHEMA_BYTES, PhoenixDatabaseMetaData.SYSTEM_CATALOG_TABLE_BYTES);
        PTable systemCatalog = this.loadTable(this.env, tableKey, cacheKey = new ImmutableBytesPtr(tableKey), 27L, Long.MAX_VALUE);
        if (systemCatalog.getTimeStamp() < 27L) {
            return this.findChildViews_deprecated(region, tenantId, table, PHYSICAL_TABLE_BYTES);
        }
        return this.findChildViews_4_11(region, tenantId, table.getSchemaName().getBytes(), table.getTableName().getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropTable(RpcController controller, MetaDataProtos.DropTableRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        MetaDataProtos.MetaDataResponse.Builder builder = MetaDataProtos.MetaDataResponse.newBuilder();
        boolean isCascade = request.getCascade();
        byte[][] rowKeyMetaData = new byte[3][];
        String tableType = request.getTableType();
        byte[] schemaName = null;
        byte[] tableName = null;
        try {
            Region region;
            List<Mutation> tableMetadata = ProtobufUtil.getMutations(request);
            MetaDataUtil.getTenantIdAndSchemaAndTableName(tableMetadata, rowKeyMetaData);
            byte[] tenantIdBytes = rowKeyMetaData[0];
            schemaName = rowKeyMetaData[1];
            tableName = rowKeyMetaData[2];
            if (tableType.equals(PTableType.SYSTEM.getSerializedValue())) {
                builder.setReturnCode(MetaDataProtos.MutationCode.UNALLOWED_TABLE_MUTATION);
                builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                done.run((Object)builder.build());
                return;
            }
            ArrayList tableNamesToDelete = Lists.newArrayList();
            ArrayList sharedTablesToDelete = Lists.newArrayList();
            byte[] parentTableName = MetaDataUtil.getParentTableName(tableMetadata);
            byte[] lockTableName = parentTableName == null ? tableName : parentTableName;
            byte[] lockKey = SchemaUtil.getTableKey(tenantIdBytes, schemaName, lockTableName);
            byte[] key = parentTableName == null ? lockKey : SchemaUtil.getTableKey(tenantIdBytes, schemaName, tableName);
            MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkTableKeyInRegion(key, region = this.env.getRegion());
            if (result != null) {
                done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                return;
            }
            ArrayList locks = Lists.newArrayList();
            try {
                MetaDataEndpointImpl.acquireLock(region, lockKey, locks);
                if (key != lockKey) {
                    MetaDataEndpointImpl.acquireLock(region, key, locks);
                }
                ArrayList<ImmutableBytesPtr> invalidateList = new ArrayList<ImmutableBytesPtr>();
                result = this.doDropTable(key, tenantIdBytes, schemaName, tableName, parentTableName, PTableType.fromSerializedValue(tableType), tableMetadata, invalidateList, locks, tableNamesToDelete, sharedTablesToDelete, isCascade);
                if (result.getMutationCode() != MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
                    done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                    return;
                }
                Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
                region.mutateRowsWithLocks(tableMetadata, Collections.emptySet(), 0L, 0L);
                long currentTime = MetaDataUtil.getClientTimeStamp(tableMetadata);
                for (ImmutableBytesPtr ckey : invalidateList) {
                    metaDataCache.put((Object)ckey, (Object)MetaDataEndpointImpl.newDeletedTableMarker(currentTime));
                }
                if (parentTableName != null) {
                    ImmutableBytesPtr parentCacheKey = new ImmutableBytesPtr(lockKey);
                    metaDataCache.invalidate((Object)parentCacheKey);
                }
                done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                return;
            }
            finally {
                region.releaseRowLocks((List)locks);
            }
        }
        catch (Throwable t) {
            logger.error("dropTable failed", t);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(SchemaUtil.getTableName(schemaName, tableName), t));
            return;
        }
    }

    private MetaDataProtocol.MetaDataMutationResult doDropTable(byte[] key, byte[] tenantId, byte[] schemaName, byte[] tableName, byte[] parentTableName, PTableType tableType, List<Mutation> rowsToDelete, List<ImmutableBytesPtr> invalidateList, List<Region.RowLock> locks, List<byte[]> tableNamesToDelete, List<MetaDataProtocol.SharedTableState> sharedTablesToDelete, boolean isCascade) throws IOException, SQLException {
        long clientTimeStamp = MetaDataUtil.getClientTimeStamp(rowsToDelete);
        Region region = this.env.getRegion();
        ImmutableBytesPtr cacheKey = new ImmutableBytesPtr(key);
        Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
        PTable table = (PTable)metaDataCache.getIfPresent((Object)cacheKey);
        if (table != null || (table = this.buildTable(key, cacheKey, region, Long.MAX_VALUE)) != null) {
            if (table.getTimeStamp() < clientTimeStamp) {
                if (MetaDataEndpointImpl.isTableDeleted(table) || tableType != table.getType()) {
                    return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
                }
            } else {
                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.NEWER_TABLE_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
            }
        }
        if (table == null) {
            if (this.buildDeletedTable(key, cacheKey, region, clientTimeStamp) != null) {
                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.NEWER_TABLE_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
            }
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
        }
        if (parentTableName != null && table.getParentTableName() != null && !Arrays.equals(parentTableName, table.getParentTableName().getBytes())) {
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
        }
        Scan scan = MetaDataUtil.newTableRowsScan(key, 0L, clientTimeStamp);
        ArrayList indexNames = Lists.newArrayList();
        ArrayList results = Lists.newArrayList();
        try (RegionScanner scanner = region.getScanner(scan);){
            TableViewFinder tableViewFinderResult;
            scanner.next((List)results);
            if (results.isEmpty()) {
                MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
                return metaDataMutationResult;
            }
            if ((tableType == PTableType.TABLE || tableType == PTableType.SYSTEM) && (tableViewFinderResult = this.findChildViews(region, tenantId, table)).hasViews()) {
                if (isCascade) {
                    if (tableViewFinderResult.allViewsInMultipleRegions()) {
                        MetaDataProtocol.MetaDataMutationResult x2 = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), null);
                        return x2;
                    }
                    if (tableViewFinderResult.allViewsInSingleRegion()) {
                        for (ViewInfo viewInfo : tableViewFinderResult.getViewInfoList()) {
                            byte[] viewTenantId = viewInfo.getTenantId();
                            byte[] viewSchemaName = viewInfo.getSchemaName();
                            byte[] viewName = viewInfo.getViewName();
                            byte[] viewKey = SchemaUtil.getTableKey(viewTenantId, viewSchemaName, viewName);
                            Delete delete = new Delete(viewKey, clientTimeStamp);
                            rowsToDelete.add((Mutation)delete);
                            MetaDataEndpointImpl.acquireLock(region, viewKey, locks);
                            MetaDataProtocol.MetaDataMutationResult result = this.doDropTable(viewKey, viewTenantId, viewSchemaName, viewName, null, PTableType.VIEW, rowsToDelete, invalidateList, locks, tableNamesToDelete, sharedTablesToDelete, false);
                            if (result.getMutationCode() == MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) continue;
                            MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = result;
                            return metaDataMutationResult;
                        }
                    }
                } else {
                    MetaDataProtocol.MetaDataMutationResult i$ = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), null);
                    return i$;
                }
            }
            if (tableType != PTableType.VIEW && table.getViewIndexId() == null) {
                tableNamesToDelete.add(table.getPhysicalName().getBytes());
            } else {
                sharedTablesToDelete.add(new MetaDataProtocol.SharedTableState(table));
            }
            invalidateList.add(cacheKey);
            byte[][] rowKeyMetaData = new byte[5][];
            do {
                Cell kv;
                int nColumns;
                if ((nColumns = SchemaUtil.getVarChars((kv = (Cell)results.get(0)).getRowArray(), kv.getRowOffset(), kv.getRowLength(), 0, rowKeyMetaData)) == 5 && rowKeyMetaData[4].length > 0 && Bytes.compareTo((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength(), (byte[])PhoenixDatabaseMetaData.LINK_TYPE_BYTES, (int)0, (int)PhoenixDatabaseMetaData.LINK_TYPE_BYTES.length) == 0) {
                    PTable.LinkType linkType = PTable.LinkType.fromSerializedValue(kv.getValueArray()[kv.getValueOffset()]);
                    if (rowKeyMetaData[3].length == 0 && linkType == PTable.LinkType.INDEX_TABLE) {
                        indexNames.add(rowKeyMetaData[4]);
                    } else if (linkType == PTable.LinkType.PARENT_TABLE || linkType == PTable.LinkType.PHYSICAL_TABLE) {
                        Cell parentTenantIdCell = MetaDataUtil.getCell(results, PhoenixDatabaseMetaData.PARENT_TENANT_ID_BYTES);
                        PName parentTenantId = parentTenantIdCell != null ? PNameFactory.newName(parentTenantIdCell.getValueArray(), parentTenantIdCell.getValueOffset(), parentTenantIdCell.getValueLength()) : null;
                        byte[] linkKey = MetaDataUtil.getChildLinkKey(parentTenantId, table.getParentSchemaName(), table.getParentTableName(), table.getTenantId(), table.getName());
                        Delete linkDelete = new Delete(linkKey, clientTimeStamp);
                        rowsToDelete.add((Mutation)linkDelete);
                    }
                }
                Delete delete = new Delete(kv.getRowArray(), kv.getRowOffset(), (int)kv.getRowLength(), clientTimeStamp);
                rowsToDelete.add((Mutation)delete);
                results.clear();
                scanner.next((List)results);
            } while (!results.isEmpty());
        }
        for (byte[] indexName : indexNames) {
            byte[] indexKey = SchemaUtil.getTableKey(tenantId, schemaName, indexName);
            Delete delete = new Delete(indexKey, clientTimeStamp);
            rowsToDelete.add((Mutation)delete);
            MetaDataEndpointImpl.acquireLock(region, indexKey, locks);
            MetaDataProtocol.MetaDataMutationResult result = this.doDropTable(indexKey, tenantId, schemaName, indexName, tableName, PTableType.INDEX, rowsToDelete, invalidateList, locks, tableNamesToDelete, sharedTablesToDelete, false);
            if (result.getMutationCode() == MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) continue;
            return result;
        }
        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS, EnvironmentEdgeManager.currentTimeMillis(), table, tableNamesToDelete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MetaDataProtocol.MetaDataMutationResult mutateColumn(List<Mutation> tableMetadata, ColumnMutator mutator) throws IOException {
        byte[][] rowKeyMetaData = new byte[5][];
        MetaDataUtil.getTenantIdAndSchemaAndTableName(tableMetadata, rowKeyMetaData);
        byte[] tenantId = rowKeyMetaData[0];
        byte[] schemaName = rowKeyMetaData[1];
        byte[] tableName = rowKeyMetaData[2];
        byte[] key = SchemaUtil.getTableKey(tenantId, schemaName, tableName);
        try {
            Region region = this.env.getRegion();
            MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkTableKeyInRegion(key, region);
            if (result != null) {
                return result;
            }
            ArrayList locks = Lists.newArrayList();
            try {
                MetaDataEndpointImpl.acquireLock(region, key, locks);
                ImmutableBytesPtr cacheKey = new ImmutableBytesPtr(key);
                ArrayList<ImmutableBytesPtr> invalidateList = new ArrayList<ImmutableBytesPtr>();
                invalidateList.add(cacheKey);
                Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
                PTable table = (PTable)metaDataCache.getIfPresent((Object)cacheKey);
                if (logger.isDebugEnabled()) {
                    if (table == null) {
                        logger.debug("Table " + Bytes.toStringBinary((byte[])key) + " not found in cache. Will build through scan");
                    } else {
                        logger.debug("Table " + Bytes.toStringBinary((byte[])key) + " found in cache with timestamp " + table.getTimeStamp() + " seqNum " + table.getSequenceNumber());
                    }
                }
                long clientTimeStamp = MetaDataUtil.getClientTimeStamp(tableMetadata);
                if (table == null && (table = this.buildTable(key, cacheKey, region, Long.MAX_VALUE)) == null) {
                    table = this.buildDeletedTable(key, cacheKey, region, clientTimeStamp);
                    if (table != null) {
                        logger.info("Found newer table deleted as of " + table.getTimeStamp() + " versus client timestamp of " + clientTimeStamp);
                        MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.NEWER_TABLE_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
                        return metaDataMutationResult;
                    }
                    MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
                    return metaDataMutationResult;
                }
                if (table.getTimeStamp() >= clientTimeStamp) {
                    logger.info("Found newer table as of " + table.getTimeStamp() + " versus client timestamp of " + clientTimeStamp);
                    MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.NEWER_TABLE_FOUND, EnvironmentEdgeManager.currentTimeMillis(), table);
                    return metaDataMutationResult;
                }
                if (MetaDataEndpointImpl.isTableDeleted(table)) {
                    MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
                    return metaDataMutationResult;
                }
                long expectedSeqNum = MetaDataUtil.getSequenceNumber(tableMetadata) - 1L;
                if (logger.isDebugEnabled()) {
                    logger.debug("For table " + Bytes.toStringBinary((byte[])key) + " expecting seqNum " + expectedSeqNum + " and found seqNum " + table.getSequenceNumber() + " with " + table.getColumns().size() + " columns: " + table.getColumns());
                }
                if (expectedSeqNum != table.getSequenceNumber()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("For table " + Bytes.toStringBinary((byte[])key) + " returning CONCURRENT_TABLE_MUTATION due to unexpected seqNum");
                    }
                    MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.CONCURRENT_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), table);
                    return metaDataMutationResult;
                }
                PTableType type = table.getType();
                if (type == PTableType.INDEX) {
                    MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), null);
                    return metaDataMutationResult;
                }
                Object expectedType = MetaDataUtil.getTableType(tableMetadata, GenericKeyValueBuilder.INSTANCE, new ImmutableBytesWritable());
                if (type != expectedType) {
                    MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
                    return metaDataMutationResult;
                }
                result = mutator.updateMutation(table, rowKeyMetaData, tableMetadata, region, invalidateList, locks, clientTimeStamp);
                if (result != null && result.getMutationCode() != MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
                    expectedType = result;
                    return expectedType;
                }
                region.mutateRowsWithLocks(tableMetadata, Collections.emptySet(), 0L, 0L);
                for (ImmutableBytesPtr invalidateKey : invalidateList) {
                    metaDataCache.invalidate((Object)invalidateKey);
                }
                long currentTime = MetaDataUtil.getClientTimeStamp(tableMetadata);
                if (result != null) {
                    MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = result;
                    return metaDataMutationResult;
                }
                table = this.buildTable(key, cacheKey, region, Long.MAX_VALUE);
                MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS, currentTime, table);
                return metaDataMutationResult;
            }
            finally {
                region.releaseRowLocks((List)locks);
            }
        }
        catch (Throwable t) {
            ServerUtil.throwIOException(SchemaUtil.getTableName(schemaName, tableName), t);
            return null;
        }
    }

    private static int getOrdinalPosition(PTable table, PColumn col) {
        return table.getBucketNum() == null ? col.getPosition() + 1 : col.getPosition();
    }

    private static boolean isDivergedView(PTable view) {
        return view.getBaseColumnCount() == -100;
    }

    private static byte[] getColumnKey(byte[] viewKey, PColumn column) {
        return MetaDataEndpointImpl.getColumnKey(viewKey, column.getName().getString(), column.getFamilyName() != null ? column.getFamilyName().getString() : null);
    }

    private static byte[] getColumnKey(byte[] viewKey, String columnName, String columnFamily) {
        byte[] columnKey = ByteUtil.concat(viewKey, QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)columnName));
        if (columnFamily != null) {
            columnKey = ByteUtil.concat(columnKey, QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)columnFamily));
        }
        return columnKey;
    }

    private boolean switchAttribute(PTable table, boolean currAttribute, List<Mutation> tableMetaData, byte[] attrQualifier) {
        for (Mutation m : tableMetaData) {
            Put p;
            List cells;
            if (!(m instanceof Put) || (cells = (p = (Put)m).get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, attrQualifier)) == null || cells.size() <= 0) continue;
            Cell cell = (Cell)cells.get(0);
            boolean newAttribute = (Boolean)PBoolean.INSTANCE.toObject(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            return currAttribute != newAttribute;
        }
        return false;
    }

    private MetaDataProtocol.MetaDataMutationResult addColumnsAndTablePropertiesToChildViews(PTable basePhysicalTable, List<Mutation> tableMetadata, List<Mutation> mutationsForAddingColumnsToViews, byte[] schemaName, byte[] tableName, List<ImmutableBytesPtr> invalidateList, long clientTimeStamp, TableViewFinder childViewsResult, Region region, List<Region.RowLock> locks) throws IOException, SQLException {
        ArrayList columnPutsForBaseTable = Lists.newArrayListWithExpectedSize((int)tableMetadata.size());
        HashMap tablePropertyCellMap = Maps.newHashMapWithExpectedSize((int)tableMetadata.size());
        for (Mutation m : tableMetadata) {
            if (!(m instanceof Put)) continue;
            byte[][] rkmd = new byte[5][];
            int pkCount = SchemaUtil.getVarChars(m.getRow(), rkmd);
            if (pkCount > 3 && rkmd[3] != null && rkmd[3].length > 0 && Bytes.compareTo((byte[])schemaName, (byte[])rkmd[1]) == 0 && Bytes.compareTo((byte[])tableName, (byte[])rkmd[2]) == 0) {
                columnPutsForBaseTable.add(new PutWithOrdinalPosition((Put)m, this.getInteger((Put)m, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.ORDINAL_POSITION_BYTES)));
                continue;
            }
            if (pkCount > 3 || Bytes.compareTo((byte[])schemaName, (byte[])rkmd[1]) != 0 || Bytes.compareTo((byte[])tableName, (byte[])rkmd[2]) != 0) continue;
            for (Cell cell : (List)m.getFamilyCellMap().get(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES)) {
                for (TableProperty tableProp : TableProperty.values()) {
                    byte[] propNameBytes = Bytes.toBytes((String)tableProp.getPropertyName());
                    if (Bytes.compareTo((byte[])propNameBytes, (int)0, (int)propNameBytes.length, (byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength()) != 0 || !tableProp.isValidOnView() || !tableProp.isMutable()) continue;
                    Cell tablePropCell = CellUtil.createCell((byte[])cell.getRow(), (byte[])CellUtil.cloneFamily((Cell)cell), (byte[])CellUtil.cloneQualifier((Cell)cell), (long)cell.getTimestamp(), (byte)cell.getTypeByte(), (byte[])CellUtil.cloneValue((Cell)cell));
                    tablePropertyCellMap.put(tableProp, tablePropCell);
                }
            }
        }
        Collections.sort(columnPutsForBaseTable);
        for (ViewInfo viewInfo : childViewsResult.getViewInfoList()) {
            short deltaNumPkColsSoFar = 0;
            short columnsAddedToView = 0;
            short columnsAddedToBaseTable = 0;
            byte[] tenantId = viewInfo.getTenantId();
            byte[] schema = viewInfo.getSchemaName();
            byte[] table = viewInfo.getViewName();
            byte[] viewKey = SchemaUtil.getTableKey(tenantId, schema, table);
            Region.RowLock viewRowLock = MetaDataEndpointImpl.acquireLock(region, viewKey, locks);
            PTable view = this.doGetTable(viewKey, clientTimeStamp, viewRowLock);
            ColumnOrdinalPositionUpdateList ordinalPositionList = new ColumnOrdinalPositionUpdateList();
            ArrayList<PColumn> viewPkCols = new ArrayList<PColumn>(view.getPKColumns());
            boolean addingExistingPkCol = false;
            int numCols = view.getColumns().size();
            for (PutWithOrdinalPosition p : columnPutsForBaseTable) {
                int newOrdinalPosition;
                Put baseTableColumnPut = p.put;
                PColumn existingViewColumn = null;
                byte[][] rkmd = new byte[5][];
                SchemaUtil.getVarChars(baseTableColumnPut.getRow(), rkmd);
                String columnName = Bytes.toString((byte[])rkmd[3]);
                String columnFamily = rkmd[4] == null ? null : Bytes.toString((byte[])rkmd[4]);
                try {
                    existingViewColumn = columnFamily == null ? view.getColumnForColumnName(columnName) : view.getColumnFamily(columnFamily).getPColumnForColumnName(columnName);
                }
                catch (ColumnFamilyNotFoundException columnFamilyNotFoundException) {
                }
                catch (ColumnNotFoundException columnNotFoundException) {
                    // empty catch block
                }
                boolean isPkCol = columnFamily == null;
                byte[] columnKey = MetaDataEndpointImpl.getColumnKey(viewKey, columnName, columnFamily);
                if (existingViewColumn != null) {
                    MetaDataProtocol.MetaDataMutationResult result = this.validateColumnForAddToBaseTable(existingViewColumn, baseTableColumnPut, basePhysicalTable, isPkCol, view);
                    if (result != null) {
                        return result;
                    }
                    if (isPkCol) {
                        viewPkCols.remove(existingViewColumn);
                        addingExistingPkCol = true;
                    }
                    if (MetaDataEndpointImpl.isDivergedView(view)) continue;
                    newOrdinalPosition = p.ordinalPosition;
                    int existingOrdinalPos = ordinalPositionList.getOrdinalPositionOfColumn(columnKey);
                    if (ordinalPositionList.size() == 0) {
                        existingOrdinalPos = MetaDataEndpointImpl.getOrdinalPosition(view, existingViewColumn);
                        if (existingOrdinalPos != newOrdinalPosition) {
                            ordinalPositionList.setOffset(newOrdinalPosition);
                            ordinalPositionList.addColumn(columnKey, newOrdinalPosition);
                            for (PColumn col : view.getColumns()) {
                                int ordinalPos = MetaDataEndpointImpl.getOrdinalPosition(view, col);
                                if (ordinalPos < newOrdinalPosition) continue;
                                if (ordinalPos != existingOrdinalPos) {
                                    int updatedPos = ordinalPos + 1;
                                    ordinalPositionList.addColumn(MetaDataEndpointImpl.getColumnKey(viewKey, col), updatedPos);
                                    continue;
                                }
                                break;
                            }
                        }
                    } else if (existingOrdinalPos != newOrdinalPosition) {
                        ordinalPositionList.addColumn(columnKey, newOrdinalPosition);
                    }
                    columnsAddedToBaseTable = (short)(columnsAddedToBaseTable + 1);
                    continue;
                }
                Put viewColumnPut = new Put(columnKey, clientTimeStamp);
                for (Cell cell : (List)baseTableColumnPut.getFamilyCellMap().values().iterator().next()) {
                    viewColumnPut.add(CellUtil.createCell((byte[])columnKey, (byte[])CellUtil.cloneFamily((Cell)cell), (byte[])CellUtil.cloneQualifier((Cell)cell), (long)cell.getTimestamp(), (byte)cell.getTypeByte(), (byte[])CellUtil.cloneValue((Cell)cell)));
                }
                if (MetaDataEndpointImpl.isDivergedView(view)) {
                    if (!isPkCol) continue;
                    int lastOrdinalPos = MetaDataEndpointImpl.getOrdinalPosition(view, view.getColumns().get(numCols - 1));
                    int newPosition = ++lastOrdinalPos;
                    byte[] ptr = new byte[PInteger.INSTANCE.getByteSize().intValue()];
                    PInteger.INSTANCE.getCodec().encodeInt(newPosition, ptr, 0);
                    viewColumnPut.add(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.ORDINAL_POSITION_BYTES, clientTimeStamp, ptr);
                    mutationsForAddingColumnsToViews.add((Mutation)viewColumnPut);
                } else {
                    newOrdinalPosition = p.ordinalPosition;
                    if (ordinalPositionList.size() == 0) {
                        ordinalPositionList.setOffset(newOrdinalPosition);
                        ordinalPositionList.addColumn(columnKey, newOrdinalPosition);
                        for (PColumn col : view.getColumns()) {
                            int ordinalPos = MetaDataEndpointImpl.getOrdinalPosition(view, col);
                            if (ordinalPos < newOrdinalPosition) continue;
                            int updatedPos = ordinalPos + 1;
                            ordinalPositionList.addColumn(MetaDataEndpointImpl.getColumnKey(viewKey, col), updatedPos);
                        }
                    } else {
                        ordinalPositionList.addColumn(columnKey, newOrdinalPosition);
                    }
                    mutationsForAddingColumnsToViews.add((Mutation)viewColumnPut);
                }
                if (isPkCol) {
                    deltaNumPkColsSoFar = (short)(deltaNumPkColsSoFar + 1);
                    short currentKeySeq = SchemaUtil.getMaxKeySeq(view);
                    short newKeySeq = (short)(currentKeySeq + deltaNumPkColsSoFar);
                    byte[] keySeqBytes = new byte[PSmallint.INSTANCE.getByteSize().intValue()];
                    PSmallint.INSTANCE.getCodec().encodeShort(newKeySeq, keySeqBytes, 0);
                    viewColumnPut.add(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.KEY_SEQ_BYTES, keySeqBytes);
                    this.addMutationsForAddingPkColsToViewIndexes(mutationsForAddingColumnsToViews, clientTimeStamp, view, deltaNumPkColsSoFar, columnName, viewColumnPut);
                }
                columnsAddedToView = (short)(columnsAddedToView + 1);
                columnsAddedToBaseTable = (short)(columnsAddedToBaseTable + 1);
            }
            if (addingExistingPkCol && !viewPkCols.equals(basePhysicalTable.getPKColumns())) {
                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), basePhysicalTable);
            }
            this.addViewIndexesHeaderRowMutations(mutationsForAddingColumnsToViews, invalidateList, clientTimeStamp, view, deltaNumPkColsSoFar);
            if (!tablePropertyCellMap.isEmpty()) {
                Put viewHeaderRowPut = new Put(viewKey, clientTimeStamp);
                for (TableProperty tableProp : TableProperty.values()) {
                    Cell tablePropertyCell = (Cell)tablePropertyCellMap.get((Object)tableProp);
                    if (tablePropertyCell == null || tableProp.isMutableOnView() && !tableProp.getPTableValue(view).equals(tableProp.getPTableValue(basePhysicalTable))) continue;
                    viewHeaderRowPut.add(CellUtil.createCell((byte[])viewKey, (byte[])CellUtil.cloneFamily((Cell)tablePropertyCell), (byte[])CellUtil.cloneQualifier((Cell)tablePropertyCell), (long)clientTimeStamp, (byte)tablePropertyCell.getTypeByte(), (byte[])CellUtil.cloneValue((Cell)tablePropertyCell)));
                }
                byte[] viewSequencePtr = new byte[PLong.INSTANCE.getByteSize().intValue()];
                PLong.INSTANCE.getCodec().encodeLong(view.getSequenceNumber() + 1L, viewSequencePtr, 0);
                viewHeaderRowPut.add(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.TABLE_SEQ_NUM_BYTES, clientTimeStamp, viewSequencePtr);
                invalidateList.add(new ImmutableBytesPtr(viewKey));
                mutationsForAddingColumnsToViews.add((Mutation)viewHeaderRowPut);
            }
            boolean changeSequenceNumber = MetaDataEndpointImpl.isDivergedView(view) && columnsAddedToView > 0 || !MetaDataEndpointImpl.isDivergedView(view) && columnsAddedToBaseTable > 0;
            this.updateViewHeaderRow(basePhysicalTable, tableMetadata, mutationsForAddingColumnsToViews, invalidateList, clientTimeStamp, columnsAddedToView, columnsAddedToBaseTable, viewKey, view, ordinalPositionList, numCols, changeSequenceNumber);
        }
        return null;
    }

    private void updateViewHeaderRow(PTable basePhysicalTable, List<Mutation> tableMetadata, List<Mutation> mutationsForAddingColumnsToViews, List<ImmutableBytesPtr> invalidateList, long clientTimeStamp, short viewColumnDelta, short baseTableColumnDelta, byte[] viewKey, PTable view, ColumnOrdinalPositionUpdateList ordinalPositionList, int numCols, boolean changeSequenceNumber) {
        Put viewHeaderRowPut = new Put(viewKey, clientTimeStamp);
        if (!MetaDataEndpointImpl.isDivergedView(view) && baseTableColumnDelta != 0) {
            int oldBaseColumnCount = view.getBaseColumnCount();
            byte[] baseColumnCountPtr = new byte[PInteger.INSTANCE.getByteSize().intValue()];
            PInteger.INSTANCE.getCodec().encodeInt(oldBaseColumnCount + baseTableColumnDelta, baseColumnCountPtr, 0);
            viewHeaderRowPut.add(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.BASE_COLUMN_COUNT_BYTES, clientTimeStamp, baseColumnCountPtr);
        }
        if (viewColumnDelta != 0) {
            byte[] columnCountPtr = new byte[PInteger.INSTANCE.getByteSize().intValue()];
            PInteger.INSTANCE.getCodec().encodeInt(numCols + viewColumnDelta, columnCountPtr, 0);
            viewHeaderRowPut.add(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.COLUMN_COUNT_BYTES, clientTimeStamp, columnCountPtr);
        }
        if (changeSequenceNumber) {
            byte[] viewSequencePtr = new byte[PLong.INSTANCE.getByteSize().intValue()];
            PLong.INSTANCE.getCodec().encodeLong(view.getSequenceNumber() + 1L, viewSequencePtr, 0);
            viewHeaderRowPut.add(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.TABLE_SEQ_NUM_BYTES, clientTimeStamp, viewSequencePtr);
            mutationsForAddingColumnsToViews.add((Mutation)viewHeaderRowPut);
            invalidateList.add(new ImmutableBytesPtr(viewKey));
            int i = 0;
            for (byte[] columnKey : ordinalPositionList.columnKeys) {
                int ordinalPosition = ordinalPositionList.getOrdinalPositionFromListIdx(i);
                Put positionUpdatePut = new Put(columnKey, clientTimeStamp);
                byte[] ptr = new byte[PInteger.INSTANCE.getByteSize().intValue()];
                PInteger.INSTANCE.getCodec().encodeInt(ordinalPosition, ptr, 0);
                positionUpdatePut.add(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.ORDINAL_POSITION_BYTES, clientTimeStamp, ptr);
                mutationsForAddingColumnsToViews.add((Mutation)positionUpdatePut);
                ++i;
            }
        }
        if (view.rowKeyOrderOptimizable()) {
            UpgradeUtil.addRowKeyOrderOptimizableCell(mutationsForAddingColumnsToViews, viewKey, clientTimeStamp);
        }
        if (!basePhysicalTable.isTransactional() && this.switchAttribute(basePhysicalTable, basePhysicalTable.isTransactional(), tableMetadata, PhoenixDatabaseMetaData.TRANSACTIONAL_BYTES)) {
            invalidateList.add(new ImmutableBytesPtr(viewKey));
            Put put = new Put(viewKey);
            put.add(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.TRANSACTIONAL_BYTES, clientTimeStamp, PBoolean.INSTANCE.toBytes(true));
            mutationsForAddingColumnsToViews.add((Mutation)put);
        }
    }

    private MetaDataProtocol.MetaDataMutationResult dropColumnsFromChildViews(Region region, PTable basePhysicalTable, List<Region.RowLock> locks, List<Mutation> tableMetadata, List<Mutation> mutationsForAddingColumnsToViews, byte[] schemaName, byte[] tableName, List<ImmutableBytesPtr> invalidateList, long clientTimeStamp, TableViewFinder childViewsResult, List<byte[]> tableNamesToDelete, List<MetaDataProtocol.SharedTableState> sharedTablesToDelete) throws IOException, SQLException {
        ArrayList<Delete> columnDeletesForBaseTable = new ArrayList<Delete>(tableMetadata.size());
        for (Mutation m : tableMetadata) {
            if (!(m instanceof Delete)) continue;
            byte[][] rkmd = new byte[5][];
            int pkCount = SchemaUtil.getVarChars(m.getRow(), rkmd);
            if (pkCount <= 3 || Bytes.compareTo((byte[])schemaName, (byte[])rkmd[1]) != 0 || Bytes.compareTo((byte[])tableName, (byte[])rkmd[2]) != 0) continue;
            columnDeletesForBaseTable.add((Delete)m);
        }
        for (ViewInfo viewInfo : childViewsResult.getViewInfoList()) {
            short numColsDeleted = 0;
            byte[] viewTenantId = viewInfo.getTenantId();
            byte[] viewSchemaName = viewInfo.getSchemaName();
            byte[] viewName = viewInfo.getViewName();
            byte[] viewKey = SchemaUtil.getTableKey(viewTenantId, viewSchemaName, viewName);
            Region.RowLock viewRowLock = MetaDataEndpointImpl.acquireLock(region, viewKey, locks);
            PTable view = this.doGetTable(viewKey, clientTimeStamp, viewRowLock);
            ColumnOrdinalPositionUpdateList ordinalPositionList = new ColumnOrdinalPositionUpdateList();
            int numCols = view.getColumns().size();
            int minDroppedColOrdinalPos = Integer.MAX_VALUE;
            for (Delete columnDeleteForBaseTable : columnDeletesForBaseTable) {
                PColumn existingViewColumn = null;
                byte[][] rkmd = new byte[5][];
                SchemaUtil.getVarChars(columnDeleteForBaseTable.getRow(), rkmd);
                String columnName = Bytes.toString((byte[])rkmd[3]);
                String columnFamily = rkmd[4] == null ? null : Bytes.toString((byte[])rkmd[4]);
                byte[] columnKey = MetaDataEndpointImpl.getColumnKey(viewKey, columnName, columnFamily);
                try {
                    existingViewColumn = columnFamily == null ? view.getColumnForColumnName(columnName) : view.getColumnFamily(columnFamily).getPColumnForColumnName(columnName);
                }
                catch (ColumnFamilyNotFoundException columnFamilyNotFoundException) {
                }
                catch (ColumnNotFoundException columnNotFoundException) {
                    // empty catch block
                }
                if (existingViewColumn != null && view.getViewStatement() != null) {
                    ParseNode viewWhere = new SQLParser(view.getViewStatement()).parseQuery().getWhere();
                    PhoenixConnection conn = null;
                    try {
                        conn = QueryUtil.getConnectionOnServer(this.env.getConfiguration()).unwrap(PhoenixConnection.class);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    PhoenixStatement statement = new PhoenixStatement(conn);
                    TableRef baseTableRef = new TableRef(basePhysicalTable);
                    ColumnResolver columnResolver = FromCompiler.getResolver(baseTableRef);
                    StatementContext context = new StatementContext(statement, columnResolver);
                    Expression whereExpression = WhereCompiler.compile(context, viewWhere);
                    Expression colExpression = new ColumnRef(baseTableRef, existingViewColumn.getPosition()).newColumnExpression();
                    ColumnFinder columnFinder = new ColumnFinder(colExpression);
                    whereExpression.accept(columnFinder);
                    if (columnFinder.getColumnFound()) {
                        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), basePhysicalTable);
                    }
                }
                minDroppedColOrdinalPos = Math.min(MetaDataEndpointImpl.getOrdinalPosition(view, existingViewColumn), minDroppedColOrdinalPos);
                if (existingViewColumn == null) continue;
                numColsDeleted = (short)(numColsDeleted - 1);
                if (ordinalPositionList.size() == 0) {
                    ordinalPositionList.setOffset(view.getBucketNum() == null ? 1 : 0);
                    for (PColumn col : view.getColumns()) {
                        ordinalPositionList.addColumn(MetaDataEndpointImpl.getColumnKey(viewKey, col));
                    }
                }
                ordinalPositionList.dropColumn(columnKey);
                Delete viewColumnDelete = new Delete(columnKey, clientTimeStamp);
                mutationsForAddingColumnsToViews.add((Mutation)viewColumnDelete);
                this.dropIndexes(view, region, invalidateList, locks, clientTimeStamp, schemaName, view.getName().getBytes(), mutationsForAddingColumnsToViews, existingViewColumn, tableNamesToDelete, sharedTablesToDelete);
            }
            this.updateViewHeaderRow(basePhysicalTable, tableMetadata, mutationsForAddingColumnsToViews, invalidateList, clientTimeStamp, numColsDeleted, numColsDeleted, viewKey, view, ordinalPositionList, numCols, true);
        }
        return null;
    }

    private MetaDataProtocol.MetaDataMutationResult validateColumnForAddToBaseTable(PColumn existingViewColumn, Put columnToBeAdded, PTable basePhysicalTable, boolean isColumnToBeAddPkCol, PTable view) {
        if (existingViewColumn != null) {
            List keySeqCells;
            int existingScale;
            int existingMaxLength;
            if (EncodedColumnsUtil.usesEncodedColumnNames(basePhysicalTable) && !SchemaUtil.isPKColumn(existingViewColumn)) {
                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), basePhysicalTable);
            }
            int baseColumnDataType = this.getInteger(columnToBeAdded, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DATA_TYPE_BYTES);
            if (baseColumnDataType != existingViewColumn.getDataType().getSqlType()) {
                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), basePhysicalTable);
            }
            int maxLength = this.getInteger(columnToBeAdded, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.COLUMN_SIZE_BYTES);
            int n = existingMaxLength = existingViewColumn.getMaxLength() == null ? 0 : existingViewColumn.getMaxLength();
            if (maxLength != existingMaxLength) {
                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), basePhysicalTable);
            }
            int scale = this.getInteger(columnToBeAdded, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DECIMAL_DIGITS_BYTES);
            int n2 = existingScale = existingViewColumn.getScale() == null ? 0 : existingViewColumn.getScale();
            if (scale != existingScale) {
                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), basePhysicalTable);
            }
            int sortOrder = this.getInteger(columnToBeAdded, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.SORT_ORDER_BYTES);
            if (sortOrder != existingViewColumn.getSortOrder().getSystemValue()) {
                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), basePhysicalTable);
            }
            if (isColumnToBeAddPkCol && (keySeqCells = columnToBeAdded.get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.KEY_SEQ_BYTES)) != null && keySeqCells.size() > 0) {
                Cell cell = (Cell)keySeqCells.get(0);
                int keySeq = PSmallint.INSTANCE.getCodec().decodeInt(cell.getValueArray(), cell.getValueOffset(), SortOrder.getDefault());
                int pkPosition = SchemaUtil.getPKPosition(view, existingViewColumn) + 1;
                if (pkPosition != keySeq) {
                    return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), basePhysicalTable);
                }
            }
        }
        return null;
    }

    private int getInteger(Put p, byte[] family, byte[] qualifier) {
        List cells = p.get(family, qualifier);
        if (cells != null && cells.size() > 0) {
            Cell cell = (Cell)cells.get(0);
            return (Integer)PInteger.INSTANCE.toObject(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
        }
        return 0;
    }

    private void addViewIndexesHeaderRowMutations(List<Mutation> mutationsForAddingColumnsToViews, List<ImmutableBytesPtr> invalidateList, long clientTimeStamp, PTable view, short deltaNumPkColsSoFar) {
        if (deltaNumPkColsSoFar > 0) {
            for (PTable index : view.getIndexes()) {
                byte[] indexHeaderRowKey = this.getViewIndexHeaderRowKey(index);
                Put indexHeaderRowMutation = new Put(indexHeaderRowKey);
                long newSequenceNumber = index.getSequenceNumber() + 1L;
                byte[] newSequenceNumberPtr = new byte[PLong.INSTANCE.getByteSize().intValue()];
                PLong.INSTANCE.getCodec().encodeLong(newSequenceNumber, newSequenceNumberPtr, 0);
                indexHeaderRowMutation.add(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.TABLE_SEQ_NUM_BYTES, newSequenceNumberPtr);
                int newColumnCount = index.getColumns().size() + deltaNumPkColsSoFar;
                byte[] newColumnCountPtr = new byte[PInteger.INSTANCE.getByteSize().intValue()];
                PInteger.INSTANCE.getCodec().encodeInt(newColumnCount, newColumnCountPtr, 0);
                indexHeaderRowMutation.add(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.COLUMN_COUNT_BYTES, newColumnCountPtr);
                invalidateList.add(new ImmutableBytesPtr(indexHeaderRowKey));
                if (index.rowKeyOrderOptimizable()) {
                    UpgradeUtil.addRowKeyOrderOptimizableCell(mutationsForAddingColumnsToViews, indexHeaderRowKey, clientTimeStamp);
                }
                mutationsForAddingColumnsToViews.add((Mutation)indexHeaderRowMutation);
            }
        }
    }

    private void addMutationsForAddingPkColsToViewIndexes(List<Mutation> mutationsForAddingColumnsToViews, long clientTimeStamp, PTable view, short deltaNumPkColsSoFar, String viewPkColumnName, Put viewColumnDefinitionPut) {
        for (PTable index : view.getIndexes()) {
            List dataTableNames;
            List sortOrders;
            List columnSizes;
            int oldNumberOfColsInIndex = index.getColumns().size();
            byte[] indexColumnKey = ByteUtil.concat(this.getViewIndexHeaderRowKey(index), QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)IndexUtil.getIndexColumnName(null, viewPkColumnName)));
            Put indexColumnDefinitionPut = new Put(indexColumnKey, clientTimeStamp);
            int viewPkColumnDataType = this.getInteger(viewColumnDefinitionPut, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DATA_TYPE_BYTES);
            byte[] indexColumnDataTypeBytes = new byte[PInteger.INSTANCE.getByteSize().intValue()];
            int indexColumnDataType = IndexUtil.getIndexColumnDataType(true, PDataType.fromTypeId(viewPkColumnDataType)).getSqlType();
            PInteger.INSTANCE.getCodec().encodeInt(indexColumnDataType, indexColumnDataTypeBytes, 0);
            indexColumnDefinitionPut.add(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DATA_TYPE_BYTES, indexColumnDataTypeBytes);
            List decimalDigits = viewColumnDefinitionPut.get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DECIMAL_DIGITS_BYTES);
            if (decimalDigits != null && decimalDigits.size() > 0) {
                Cell decimalDigit = (Cell)decimalDigits.get(0);
                indexColumnDefinitionPut.add(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DECIMAL_DIGITS_BYTES, decimalDigit.getValueArray());
            }
            if ((columnSizes = viewColumnDefinitionPut.get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.COLUMN_SIZE_BYTES)) != null && columnSizes.size() > 0) {
                Cell columnSize = (Cell)columnSizes.get(0);
                indexColumnDefinitionPut.add(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.COLUMN_SIZE_BYTES, columnSize.getValueArray());
            }
            if ((sortOrders = viewColumnDefinitionPut.get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.SORT_ORDER_BYTES)) != null && sortOrders.size() > 0) {
                Cell sortOrder = (Cell)sortOrders.get(0);
                indexColumnDefinitionPut.add(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.SORT_ORDER_BYTES, sortOrder.getValueArray());
            }
            if ((dataTableNames = viewColumnDefinitionPut.get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DATA_TABLE_NAME_BYTES)) != null && dataTableNames.size() > 0) {
                Cell dataTableName = (Cell)dataTableNames.get(0);
                indexColumnDefinitionPut.add(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DATA_TABLE_NAME_BYTES, dataTableName.getValueArray());
            }
            byte[] ordinalPositionBytes = new byte[PInteger.INSTANCE.getByteSize().intValue()];
            int ordinalPositionOfNewCol = oldNumberOfColsInIndex + deltaNumPkColsSoFar;
            PInteger.INSTANCE.getCodec().encodeInt(ordinalPositionOfNewCol, ordinalPositionBytes, 0);
            indexColumnDefinitionPut.add(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.ORDINAL_POSITION_BYTES, ordinalPositionBytes);
            byte[] isNullableBytes = PBoolean.INSTANCE.toBytes(true);
            indexColumnDefinitionPut.add(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.NULLABLE_BYTES, isNullableBytes);
            short currentKeySeq = SchemaUtil.getMaxKeySeq(index);
            short newKeySeq = (short)(currentKeySeq + deltaNumPkColsSoFar);
            byte[] keySeqBytes = new byte[PSmallint.INSTANCE.getByteSize().intValue()];
            PSmallint.INSTANCE.getCodec().encodeShort(newKeySeq, keySeqBytes, 0);
            indexColumnDefinitionPut.add(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.KEY_SEQ_BYTES, keySeqBytes);
            mutationsForAddingColumnsToViews.add((Mutation)indexColumnDefinitionPut);
        }
    }

    private byte[] getViewIndexHeaderRowKey(PTable index) {
        byte[] tenantIdBytes = index.getKey().getTenantId() != null ? index.getKey().getTenantId().getBytes() : ByteUtil.EMPTY_BYTE_ARRAY;
        byte[] schemaNameBytes = index.getSchemaName() != null ? index.getSchemaName().getBytes() : ByteUtil.EMPTY_BYTE_ARRAY;
        byte[] tableNameBytes = index.getTableName().getBytes();
        return ByteUtil.concat(tenantIdBytes, QueryConstants.SEPARATOR_BYTE_ARRAY, schemaNameBytes, QueryConstants.SEPARATOR_BYTE_ARRAY, tableNameBytes);
    }

    @Override
    public void addColumn(RpcController controller, final MetaDataProtos.AddColumnRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        try {
            List<Mutation> tableMetaData = ProtobufUtil.getMutations(request);
            MetaDataProtocol.MetaDataMutationResult result = this.mutateColumn(tableMetaData, new ColumnMutator(){

                @Override
                public MetaDataProtocol.MetaDataMutationResult updateMutation(PTable table, byte[][] rowKeyMetaData, List<Mutation> tableMetaData, Region region, List<ImmutableBytesPtr> invalidateList, List<Region.RowLock> locks, long clientTimeStamp) throws IOException, SQLException {
                    byte[] tenantId = rowKeyMetaData[0];
                    byte[] schemaName = rowKeyMetaData[1];
                    byte[] tableName = rowKeyMetaData[2];
                    PTableType type = table.getType();
                    byte[] tableHeaderRowKey = SchemaUtil.getTableKey(tenantId, schemaName, tableName);
                    ArrayList<Mutation> mutationsForAddingColumnsToViews = Lists.newArrayListWithExpectedSize((int)(tableMetaData.size() * (1 + table.getIndexes().size())));
                    if (type == PTableType.TABLE || type == PTableType.SYSTEM) {
                        TableViewFinder childViewsResult = new TableViewFinder();
                        MetaDataEndpointImpl.this.findAllChildViews(region, tenantId, table, childViewsResult, clientTimeStamp);
                        if (childViewsResult.hasViews()) {
                            if (!childViewsResult.allViewsInSingleRegion() || table.getBaseColumnCount() == 0 || !request.hasClientVersion() || MetaDataEndpointImpl.this.switchAttribute(table, table.isMultiTenant(), tableMetaData, PhoenixDatabaseMetaData.MULTI_TENANT_BYTES)) {
                                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), null);
                            }
                            mutationsForAddingColumnsToViews = new ArrayList<Mutation>(childViewsResult.getViewInfoList().size() * tableMetaData.size());
                            MetaDataProtocol.MetaDataMutationResult mutationResult = MetaDataEndpointImpl.this.addColumnsAndTablePropertiesToChildViews(table, tableMetaData, mutationsForAddingColumnsToViews, schemaName, tableName, invalidateList, clientTimeStamp, childViewsResult, region, locks);
                            if (mutationResult != null) {
                                return mutationResult;
                            }
                        }
                    } else if (type == PTableType.VIEW && EncodedColumnsUtil.usesEncodedColumnNames(table)) {
                        invalidateList.add(new ImmutableBytesPtr(MetaDataUtil.getPhysicalTableRowForView(table)));
                    }
                    for (Mutation m : tableMetaData) {
                        byte[] key = m.getRow();
                        boolean addingPKColumn = false;
                        int pkCount = SchemaUtil.getVarChars(key, rowKeyMetaData);
                        if (pkCount > 3 && Bytes.compareTo((byte[])schemaName, (byte[])rowKeyMetaData[1]) == 0 && Bytes.compareTo((byte[])tableName, (byte[])rowKeyMetaData[2]) == 0) {
                            try {
                                if (pkCount > 4 && rowKeyMetaData[4].length > 0) {
                                    PColumnFamily family = table.getColumnFamily(rowKeyMetaData[4]);
                                    family.getPColumnForColumnNameBytes(rowKeyMetaData[3]);
                                } else {
                                    if (pkCount <= 3 || rowKeyMetaData[3].length <= 0) continue;
                                    addingPKColumn = true;
                                    table.getPKColumn(new String(rowKeyMetaData[3]));
                                }
                                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.COLUMN_ALREADY_EXISTS, EnvironmentEdgeManager.currentTimeMillis(), table);
                            }
                            catch (ColumnFamilyNotFoundException e) {
                                continue;
                            }
                            catch (ColumnNotFoundException e) {
                                if (!addingPKColumn) continue;
                                if (table.rowKeyOrderOptimizable()) {
                                    UpgradeUtil.addRowKeyOrderOptimizableCell(mutationsForAddingColumnsToViews, tableHeaderRowKey, clientTimeStamp);
                                } else if (table.getType() == PTableType.VIEW) {
                                    return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), null);
                                }
                                for (PTable index : table.getIndexes()) {
                                    invalidateList.add(new ImmutableBytesPtr(SchemaUtil.getTableKey(tenantId, index.getSchemaName().getBytes(), index.getTableName().getBytes())));
                                    if (!index.rowKeyOrderOptimizable()) continue;
                                    byte[] indexHeaderRowKey = SchemaUtil.getTableKey(index.getTenantId() == null ? ByteUtil.EMPTY_BYTE_ARRAY : index.getTenantId().getBytes(), index.getSchemaName().getBytes(), index.getTableName().getBytes());
                                    UpgradeUtil.addRowKeyOrderOptimizableCell(mutationsForAddingColumnsToViews, indexHeaderRowKey, clientTimeStamp);
                                }
                                continue;
                            }
                        }
                        if (pkCount != 3 || Bytes.compareTo((byte[])schemaName, (byte[])rowKeyMetaData[1]) == 0 && Bytes.compareTo((byte[])tableName, (byte[])rowKeyMetaData[2]) == 0) continue;
                        invalidateList.add(new ImmutableBytesPtr(SchemaUtil.getTableKey(tenantId, rowKeyMetaData[1], rowKeyMetaData[2])));
                    }
                    tableMetaData.addAll((Collection<Mutation>)mutationsForAddingColumnsToViews);
                    return null;
                }
            });
            if (result != null) {
                done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
            }
        }
        catch (IOException ioe) {
            ProtobufUtil.setControllerException(controller, ioe);
        }
    }

    private PTable doGetTable(byte[] key, long clientTimeStamp) throws IOException, SQLException {
        return this.doGetTable(key, clientTimeStamp, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PTable doGetTable(byte[] key, long clientTimeStamp, Region.RowLock rowLock) throws IOException, SQLException {
        ImmutableBytesPtr cacheKey = new ImmutableBytesPtr(key);
        Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
        Region region = this.env.getRegion();
        boolean wasLocked = rowLock != null;
        boolean blockWriteRebuildIndex = this.env.getConfiguration().getBoolean("phoenix.index.failure.block.write", false);
        if (!wasLocked && (rowLock = region.getRowLock(key, true)) == null) {
            throw new IOException("Failed to acquire lock on " + Bytes.toStringBinary((byte[])key));
        }
        try {
            PTable table = (PTable)metaDataCache.getIfPresent((Object)cacheKey);
            if (table != null && table.getTimeStamp() < clientTimeStamp) {
                if (MetaDataEndpointImpl.isTableDeleted(table)) {
                    PTable pTable = null;
                    return pTable;
                }
                PTable pTable = table;
                return pTable;
            }
            table = (PTable)metaDataCache.getIfPresent((Object)cacheKey);
            if (table != null && table.getTimeStamp() < clientTimeStamp) {
                if (MetaDataEndpointImpl.isTableDeleted(table)) {
                    PTable pTable = null;
                    return pTable;
                }
                PTable pTable = table;
                return pTable;
            }
            table = this.buildTable(key, cacheKey, region, Long.MAX_VALUE);
            if (table != null && table.getTimeStamp() < clientTimeStamp || blockWriteRebuildIndex && table.getIndexDisableTimestamp() > 0L) {
                PTable pTable = table;
                return pTable;
            }
            PTable pTable = this.buildTable(key, cacheKey, region, clientTimeStamp);
            return pTable;
        }
        finally {
            if (!wasLocked) {
                rowLock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PFunction> doGetFunctions(List<byte[]> keys, long clientTimeStamp) throws IOException, SQLException {
        Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
        Region region = this.env.getRegion();
        Collections.sort(keys, new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                return Bytes.compareTo((byte[])o1, (byte[])o2);
            }
        });
        ArrayList<Region.RowLock> rowLocks = new ArrayList<Region.RowLock>(keys.size());
        try {
            ArrayList<PFunction> arrayList;
            Object key;
            rowLocks = new ArrayList(keys.size());
            for (int i = 0; i < keys.size(); ++i) {
                Region.RowLock rowLock = region.getRowLock(keys.get(i), true);
                if (rowLock == null) {
                    throw new IOException("Failed to acquire lock on " + Bytes.toStringBinary((byte[])keys.get(i)));
                }
                rowLocks.add(rowLock);
            }
            ArrayList<PFunction> functionsAvailable = new ArrayList<PFunction>(keys.size());
            int numFunctions = keys.size();
            Iterator<byte[]> iterator = keys.iterator();
            while (iterator.hasNext()) {
                key = iterator.next();
                PFunction function = (PFunction)metaDataCache.getIfPresent((Object)new GlobalCache.FunctionBytesPtr((byte[])key));
                if (function == null || function.getTimeStamp() >= clientTimeStamp) continue;
                if (MetaDataEndpointImpl.isFunctionDeleted(function)) {
                    List<PFunction> list = null;
                    return list;
                }
                functionsAvailable.add(function);
                iterator.remove();
            }
            if (functionsAvailable.size() == numFunctions) {
                key = functionsAvailable;
                return key;
            }
            List<PFunction> buildFunctions = this.buildFunctions(keys, region, clientTimeStamp, false, Collections.emptyList());
            if (buildFunctions == null || buildFunctions.isEmpty()) {
                arrayList = null;
                return arrayList;
            }
            functionsAvailable.addAll(buildFunctions);
            if (functionsAvailable.size() == numFunctions) {
                arrayList = functionsAvailable;
                return arrayList;
            }
            arrayList = null;
            return arrayList;
        }
        finally {
            for (Region.RowLock lock : rowLocks) {
                lock.release();
            }
            rowLocks.clear();
        }
    }

    @Override
    public void dropColumn(RpcController controller, MetaDataProtos.DropColumnRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        List<Mutation> tableMetaData = null;
        final ArrayList tableNamesToDelete = Lists.newArrayList();
        final ArrayList sharedTablesToDelete = Lists.newArrayList();
        try {
            tableMetaData = ProtobufUtil.getMutations(request);
            MetaDataProtocol.MetaDataMutationResult result = this.mutateColumn(tableMetaData, new ColumnMutator(){

                @Override
                public MetaDataProtocol.MetaDataMutationResult updateMutation(PTable table, byte[][] rowKeyMetaData, List<Mutation> tableMetaData, Region region, List<ImmutableBytesPtr> invalidateList, List<Region.RowLock> locks, long clientTimeStamp) throws IOException, SQLException {
                    byte[] tenantId = rowKeyMetaData[0];
                    byte[] schemaName = rowKeyMetaData[1];
                    byte[] tableName = rowKeyMetaData[2];
                    boolean deletePKColumn = false;
                    ArrayList additionalTableMetaData = Lists.newArrayList();
                    PTableType type = table.getType();
                    if (type == PTableType.TABLE || type == PTableType.SYSTEM) {
                        MetaDataProtocol.MetaDataMutationResult mutationResult;
                        TableViewFinder childViewsResult = new TableViewFinder();
                        MetaDataEndpointImpl.this.findAllChildViews(region, tenantId, table, childViewsResult, clientTimeStamp);
                        if (childViewsResult.hasViews() && (mutationResult = MetaDataEndpointImpl.this.dropColumnsFromChildViews(region, table, locks, tableMetaData, additionalTableMetaData, schemaName, tableName, invalidateList, clientTimeStamp, childViewsResult, tableNamesToDelete, sharedTablesToDelete)) != null) {
                            return mutationResult;
                        }
                    }
                    for (Mutation m : tableMetaData) {
                        byte[] key;
                        int pkCount;
                        if (!(m instanceof Delete) || (pkCount = SchemaUtil.getVarChars(key = m.getRow(), rowKeyMetaData)) <= 3 || Bytes.compareTo((byte[])schemaName, (byte[])rowKeyMetaData[1]) != 0 || Bytes.compareTo((byte[])tableName, (byte[])rowKeyMetaData[2]) != 0) continue;
                        PColumn columnToDelete = null;
                        try {
                            if (pkCount > 4 && rowKeyMetaData[4].length > 0) {
                                PColumnFamily family = table.getColumnFamily(rowKeyMetaData[4]);
                                columnToDelete = family.getPColumnForColumnNameBytes(rowKeyMetaData[3]);
                            } else {
                                if (pkCount <= 3 || rowKeyMetaData[3].length <= 0) continue;
                                deletePKColumn = true;
                                columnToDelete = table.getPKColumn(new String(rowKeyMetaData[3]));
                            }
                            if (table.getType() == PTableType.VIEW && table.getBaseColumnCount() != -100 && columnToDelete.getPosition() < table.getBaseColumnCount()) {
                                byte[] viewKey = SchemaUtil.getTableKey(tenantId, schemaName, tableName);
                                Put updateBaseColumnCountPut = new Put(viewKey);
                                byte[] baseColumnCountPtr = new byte[PInteger.INSTANCE.getByteSize().intValue()];
                                PInteger.INSTANCE.getCodec().encodeInt(-100, baseColumnCountPtr, 0);
                                updateBaseColumnCountPut.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.BASE_COLUMN_COUNT_BYTES, clientTimeStamp, baseColumnCountPtr);
                                additionalTableMetaData.add(updateBaseColumnCountPut);
                            }
                            if (columnToDelete.isViewReferenced()) {
                                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), table, columnToDelete);
                            }
                            MetaDataEndpointImpl.this.dropIndexes(table, region, invalidateList, locks, clientTimeStamp, schemaName, tableName, additionalTableMetaData, columnToDelete, tableNamesToDelete, sharedTablesToDelete);
                        }
                        catch (ColumnFamilyNotFoundException e) {
                            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.COLUMN_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), table, columnToDelete);
                        }
                        catch (ColumnNotFoundException e) {
                            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.COLUMN_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), table, columnToDelete);
                        }
                    }
                    if (deletePKColumn && table.getPKColumns().size() == 1) {
                        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.NO_PK_COLUMNS, EnvironmentEdgeManager.currentTimeMillis(), null);
                    }
                    tableMetaData.addAll(additionalTableMetaData);
                    long currentTime = MetaDataUtil.getClientTimeStamp(tableMetaData);
                    return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS, currentTime, null, tableNamesToDelete, sharedTablesToDelete);
                }
            });
            if (result != null) {
                done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
            }
        }
        catch (IOException ioe) {
            ProtobufUtil.setControllerException(controller, ioe);
        }
    }

    private void dropIndexes(PTable table, Region region, List<ImmutableBytesPtr> invalidateList, List<Region.RowLock> locks, long clientTimeStamp, byte[] schemaName, byte[] tableName, List<Mutation> additionalTableMetaData, PColumn columnToDelete, List<byte[]> tableNamesToDelete, List<MetaDataProtocol.SharedTableState> sharedTablesToDelete) throws IOException, SQLException {
        PhoenixConnection connection = null;
        try {
            connection = table.getIndexes().isEmpty() ? null : QueryUtil.getConnectionOnServer(this.env.getConfiguration()).unwrap(PhoenixConnection.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        for (PTable index : table.getIndexes()) {
            byte[] tenantId = index.getTenantId() == null ? ByteUtil.EMPTY_BYTE_ARRAY : index.getTenantId().getBytes();
            IndexMaintainer indexMaintainer = index.getIndexMaintainer(table, connection);
            byte[] indexKey = SchemaUtil.getTableKey(tenantId, index.getSchemaName().getBytes(), index.getTableName().getBytes());
            Pair columnToDeleteInfo = new Pair((Object)columnToDelete.getFamilyName().getString(), (Object)columnToDelete.getName().getString());
            ColumnReference colDropRef = new ColumnReference(columnToDelete.getFamilyName().getBytes(), columnToDelete.getColumnQualifierBytes());
            boolean isColumnIndexed = indexMaintainer.getIndexedColumnInfo().contains(columnToDeleteInfo);
            boolean isCoveredColumn = indexMaintainer.getCoveredColumns().contains(colDropRef);
            if (isColumnIndexed) {
                MetaDataEndpointImpl.acquireLock(region, indexKey, locks);
                additionalTableMetaData.add((Mutation)new Delete(indexKey, clientTimeStamp));
                byte[] linkKey = MetaDataUtil.getParentLinkKey(tenantId, schemaName, tableName, index.getTableName().getBytes());
                additionalTableMetaData.add((Mutation)new Delete(linkKey, clientTimeStamp));
                this.doDropTable(indexKey, tenantId, index.getSchemaName().getBytes(), index.getTableName().getBytes(), tableName, index.getType(), additionalTableMetaData, invalidateList, locks, tableNamesToDelete, sharedTablesToDelete, false);
                invalidateList.add(new ImmutableBytesPtr(indexKey));
                continue;
            }
            if (!isCoveredColumn) continue;
            invalidateList.add(new ImmutableBytesPtr(indexKey));
        }
    }

    @Override
    public void clearCache(RpcController controller, MetaDataProtos.ClearCacheRequest request, RpcCallback<MetaDataProtos.ClearCacheResponse> done) {
        GlobalCache cache = GlobalCache.getInstance(this.env);
        Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
        metaDataCache.invalidateAll();
        long unfreedBytes = cache.clearTenantCache();
        MetaDataProtos.ClearCacheResponse.Builder builder = MetaDataProtos.ClearCacheResponse.newBuilder();
        builder.setUnfreedBytes(unfreedBytes);
        done.run((Object)builder.build());
    }

    @Override
    public void getVersion(RpcController controller, MetaDataProtos.GetVersionRequest request, RpcCallback<MetaDataProtos.GetVersionResponse> done) {
        MetaDataProtos.GetVersionResponse.Builder builder = MetaDataProtos.GetVersionResponse.newBuilder();
        Configuration config = this.env.getConfiguration();
        boolean isTablesMappingEnabled = SchemaUtil.isNamespaceMappingEnabled(PTableType.TABLE, new ReadOnlyProps(config.iterator()));
        if (isTablesMappingEnabled && PhoenixDatabaseMetaData.MIN_NAMESPACE_MAPPED_PHOENIX_VERSION > request.getClientVersion()) {
            logger.error("Old client is not compatible when system tables are upgraded to map to namespace");
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(SchemaUtil.getPhysicalHBaseTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, isTablesMappingEnabled, PTableType.SYSTEM).getString(), (Throwable)new DoNotRetryIOException("Old client is not compatible when system tables are upgraded to map to namespace")));
        }
        long version = MetaDataUtil.encodeVersion(this.env.getHBaseVersion(), config);
        builder.setVersion(version);
        done.run((Object)builder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateIndexState(RpcController controller, MetaDataProtos.UpdateIndexStateRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        MetaDataProtos.MetaDataResponse.Builder builder = MetaDataProtos.MetaDataResponse.newBuilder();
        byte[] schemaName = null;
        byte[] tableName = null;
        try {
            byte[][] rowKeyMetaData = new byte[3][];
            List<Mutation> tableMetadata = ProtobufUtil.getMutations(request);
            MetaDataUtil.getTenantIdAndSchemaAndTableName(tableMetadata, rowKeyMetaData);
            byte[] tenantId = rowKeyMetaData[0];
            schemaName = rowKeyMetaData[1];
            tableName = rowKeyMetaData[2];
            byte[] key = SchemaUtil.getTableKey(tenantId, schemaName, tableName);
            Region region = this.env.getRegion();
            MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkTableKeyInRegion(key, region);
            if (result != null) {
                done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                return;
            }
            long timeStamp = MetaDataUtil.getClientTimeStamp(tableMetadata);
            ImmutableBytesPtr cacheKey = new ImmutableBytesPtr(key);
            List newKVs = (List)tableMetadata.get(0).getFamilyCellMap().get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES);
            Cell newKV = null;
            int disableTimeStampKVIndex = -1;
            int indexStateKVIndex = 0;
            int index = 0;
            for (Cell cell : newKVs) {
                if (Bytes.compareTo((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength(), (byte[])PhoenixDatabaseMetaData.INDEX_STATE_BYTES, (int)0, (int)PhoenixDatabaseMetaData.INDEX_STATE_BYTES.length) == 0) {
                    newKV = cell;
                    indexStateKVIndex = index;
                } else if (Bytes.compareTo((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength(), (byte[])PhoenixDatabaseMetaData.INDEX_DISABLE_TIMESTAMP_BYTES, (int)0, (int)PhoenixDatabaseMetaData.INDEX_DISABLE_TIMESTAMP_BYTES.length) == 0) {
                    disableTimeStampKVIndex = index;
                }
                ++index;
            }
            PIndexState newState = PIndexState.fromSerializedValue(newKV.getValueArray()[newKV.getValueOffset()]);
            Region.RowLock rowLock = region.getRowLock(key, true);
            if (rowLock == null) {
                throw new IOException("Failed to acquire lock on " + Bytes.toStringBinary((byte[])key));
            }
            try {
                Get get = new Get(key);
                get.setTimeRange(0L, timeStamp);
                get.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DATA_TABLE_NAME_BYTES);
                get.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_STATE_BYTES);
                get.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_DISABLE_TIMESTAMP_BYTES);
                get.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, ROW_KEY_ORDER_OPTIMIZABLE_BYTES);
                Result currentResult = region.get(get);
                if (currentResult.rawCells().length == 0) {
                    builder.setReturnCode(MetaDataProtos.MutationCode.TABLE_NOT_FOUND);
                    builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                    done.run((Object)builder.build());
                    return;
                }
                Cell dataTableKV = currentResult.getColumnLatestCell(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DATA_TABLE_NAME_BYTES);
                Cell currentStateKV = currentResult.getColumnLatestCell(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_STATE_BYTES);
                Cell currentDisableTimeStamp = currentResult.getColumnLatestCell(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_DISABLE_TIMESTAMP_BYTES);
                boolean rowKeyOrderOptimizable = currentResult.getColumnLatestCell(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, ROW_KEY_ORDER_OPTIMIZABLE_BYTES) != null;
                PIndexState currentState = PIndexState.fromSerializedValue(currentStateKV.getValueArray()[currentStateKV.getValueOffset()]);
                if (currentDisableTimeStamp != null && currentDisableTimeStamp.getValueLength() > 0 && disableTimeStampKVIndex >= 0) {
                    long curTimeStampVal = (Long)PLong.INSTANCE.toObject(currentDisableTimeStamp.getValueArray(), currentDisableTimeStamp.getValueOffset(), currentDisableTimeStamp.getValueLength());
                    Cell newDisableTimeStampCell = (Cell)newKVs.get(disableTimeStampKVIndex);
                    long newDisableTimeStamp = (Long)PLong.INSTANCE.toObject(newDisableTimeStampCell.getValueArray(), newDisableTimeStampCell.getValueOffset(), newDisableTimeStampCell.getValueLength());
                    if (curTimeStampVal != 0L && Math.abs(curTimeStampVal) < Math.abs(newDisableTimeStamp)) {
                        newKVs.remove(disableTimeStampKVIndex);
                        disableTimeStampKVIndex = -1;
                    }
                }
                if (currentState == PIndexState.BUILDING) {
                    if (newState == PIndexState.USABLE) {
                        builder.setReturnCode(MetaDataProtos.MutationCode.UNALLOWED_TABLE_MUTATION);
                        builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                        done.run((Object)builder.build());
                        return;
                    }
                } else if (currentState == PIndexState.DISABLE) {
                    if (newState != PIndexState.BUILDING && newState != PIndexState.DISABLE && newState != PIndexState.INACTIVE) {
                        builder.setReturnCode(MetaDataProtos.MutationCode.UNALLOWED_TABLE_MUTATION);
                        builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                        done.run((Object)builder.build());
                        return;
                    }
                    if (newState == PIndexState.ACTIVE) {
                        newState = PIndexState.DISABLE;
                    }
                }
                if (currentState == PIndexState.BUILDING && newState != PIndexState.ACTIVE) {
                    timeStamp = currentStateKV.getTimestamp();
                }
                if (currentState == PIndexState.UNUSABLE && newState == PIndexState.ACTIVE || currentState == PIndexState.ACTIVE && newState == PIndexState.UNUSABLE) {
                    newState = PIndexState.INACTIVE;
                    newKVs.set(indexStateKVIndex, KeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_STATE_BYTES, timeStamp, Bytes.toBytes((String)newState.getSerializedValue())));
                } else if (currentState == PIndexState.INACTIVE && newState == PIndexState.USABLE) {
                    newState = PIndexState.ACTIVE;
                    newKVs.set(indexStateKVIndex, KeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_STATE_BYTES, timeStamp, Bytes.toBytes((String)newState.getSerializedValue())));
                }
                PTable returnTable = null;
                if (currentState != newState || disableTimeStampKVIndex != -1) {
                    boolean setRowKeyOrderOptimizableCell;
                    byte[] dataTableKey = null;
                    if (dataTableKV != null) {
                        dataTableKey = SchemaUtil.getTableKey(tenantId, schemaName, dataTableKV.getValue());
                    }
                    if (dataTableKey != null) {
                        tableMetadata = new ArrayList<Mutation>(tableMetadata);
                        Put p = new Put(dataTableKey);
                        p.add(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, timeStamp, QueryConstants.EMPTY_COLUMN_VALUE_BYTES);
                        tableMetadata.add((Mutation)p);
                    }
                    boolean bl = setRowKeyOrderOptimizableCell = newState == PIndexState.BUILDING && !rowKeyOrderOptimizable;
                    if (setRowKeyOrderOptimizableCell) {
                        UpgradeUtil.addRowKeyOrderOptimizableCell(tableMetadata, key, timeStamp);
                    }
                    region.mutateRowsWithLocks(tableMetadata, Collections.emptySet(), 0L, 0L);
                    Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
                    metaDataCache.invalidate((Object)cacheKey);
                    if (dataTableKey != null) {
                        metaDataCache.invalidate((Object)new ImmutableBytesPtr(dataTableKey));
                    }
                    if (setRowKeyOrderOptimizableCell || disableTimeStampKVIndex != -1 || currentState == PIndexState.DISABLE || newState == PIndexState.BUILDING) {
                        returnTable = this.doGetTable(key, Long.MAX_VALUE, rowLock);
                    }
                }
                long currentTime = MetaDataUtil.getClientTimeStamp(tableMetadata);
                builder.setReturnCode(MetaDataProtos.MutationCode.TABLE_ALREADY_EXISTS);
                builder.setMutationTime(currentTime);
                if (returnTable != null) {
                    builder.setTable(PTableImpl.toProto(returnTable));
                }
                done.run((Object)builder.build());
                return;
            }
            finally {
                rowLock.release();
            }
        }
        catch (Throwable t) {
            logger.error("updateIndexState failed", t);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(SchemaUtil.getTableName(schemaName, tableName), t));
            return;
        }
    }

    private static MetaDataProtocol.MetaDataMutationResult checkKeyInRegion(byte[] key, Region region, MetaDataProtocol.MutationCode code) {
        byte[] startKey = region.getRegionInfo().getStartKey();
        byte[] endKey = region.getRegionInfo().getEndKey();
        if (Bytes.compareTo((byte[])startKey, (byte[])key) <= 0 && (Bytes.compareTo((byte[])HConstants.LAST_ROW, (byte[])endKey) == 0 || Bytes.compareTo((byte[])key, (byte[])endKey) < 0)) {
            return null;
        }
        return new MetaDataProtocol.MetaDataMutationResult(code, EnvironmentEdgeManager.currentTimeMillis(), null);
    }

    private static MetaDataProtocol.MetaDataMutationResult checkTableKeyInRegion(byte[] key, Region region) {
        return MetaDataEndpointImpl.checkKeyInRegion(key, region, MetaDataProtocol.MutationCode.TABLE_NOT_IN_REGION);
    }

    private static MetaDataProtocol.MetaDataMutationResult checkFunctionKeyInRegion(byte[] key, Region region) {
        return MetaDataEndpointImpl.checkKeyInRegion(key, region, MetaDataProtocol.MutationCode.FUNCTION_NOT_IN_REGION);
    }

    private static MetaDataProtocol.MetaDataMutationResult checkSchemaKeyInRegion(byte[] key, Region region) {
        return MetaDataEndpointImpl.checkKeyInRegion(key, region, MetaDataProtocol.MutationCode.SCHEMA_NOT_IN_REGION);
    }

    @Override
    public void clearTableFromCache(RpcController controller, MetaDataProtos.ClearTableFromCacheRequest request, RpcCallback<MetaDataProtos.ClearTableFromCacheResponse> done) {
        byte[] schemaName = request.getSchemaName().toByteArray();
        byte[] tableName = request.getTableName().toByteArray();
        try {
            byte[] tenantId = request.getTenantId().toByteArray();
            byte[] key = SchemaUtil.getTableKey(tenantId, schemaName, tableName);
            ImmutableBytesPtr cacheKey = new ImmutableBytesPtr(key);
            Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
            metaDataCache.invalidate((Object)cacheKey);
        }
        catch (Throwable t) {
            logger.error("incrementTableTimeStamp failed", t);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(SchemaUtil.getTableName(schemaName, tableName), t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getSchema(RpcController controller, MetaDataProtos.GetSchemaRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        MetaDataProtos.MetaDataResponse.Builder builder = MetaDataProtos.MetaDataResponse.newBuilder();
        Region region = this.env.getRegion();
        String schemaName = request.getSchemaName();
        byte[] lockKey = SchemaUtil.getSchemaKey(schemaName);
        MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkSchemaKeyInRegion(lockKey, region);
        if (result != null) {
            done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
            return;
        }
        long clientTimeStamp = request.getClientTimestamp();
        ArrayList locks = Lists.newArrayList();
        try {
            MetaDataEndpointImpl.acquireLock(region, lockKey, locks);
            ImmutableBytesPtr cacheKey = new ImmutableBytesPtr(lockKey);
            PSchema schema = this.loadSchema(this.env, lockKey, cacheKey, clientTimeStamp, clientTimeStamp);
            if (schema != null && schema.getTimeStamp() < clientTimeStamp) {
                if (!MetaDataEndpointImpl.isSchemaDeleted(schema)) {
                    builder.setReturnCode(MetaDataProtos.MutationCode.SCHEMA_ALREADY_EXISTS);
                    builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                    builder.setSchema(PSchema.toProto(schema));
                    done.run((Object)builder.build());
                    return;
                }
                builder.setReturnCode(MetaDataProtos.MutationCode.NEWER_SCHEMA_FOUND);
                builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                builder.setSchema(PSchema.toProto(schema));
                done.run((Object)builder.build());
                return;
            }
        }
        catch (Exception e) {
            long currentTime = EnvironmentEdgeManager.currentTimeMillis();
            builder.setReturnCode(MetaDataProtos.MutationCode.SCHEMA_NOT_FOUND);
            builder.setMutationTime(currentTime);
            done.run((Object)builder.build());
            return;
        }
        finally {
            region.releaseRowLocks((List)locks);
        }
    }

    @Override
    public void getFunctions(RpcController controller, MetaDataProtos.GetFunctionsRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        MetaDataProtos.MetaDataResponse.Builder builder = MetaDataProtos.MetaDataResponse.newBuilder();
        byte[] tenantId = request.getTenantId().toByteArray();
        ArrayList<String> functionNames = new ArrayList<String>(request.getFunctionNamesCount());
        try {
            Region region = this.env.getRegion();
            List<ByteString> functionNamesList = request.getFunctionNamesList();
            List<Long> functionTimestampsList = request.getFunctionTimestampsList();
            ArrayList<byte[]> keys = new ArrayList<byte[]>(request.getFunctionNamesCount());
            ArrayList<Pair> functions = new ArrayList<Pair>(request.getFunctionNamesCount());
            for (int i = 0; i < functionNamesList.size(); ++i) {
                byte[] functionName = functionNamesList.get(i).toByteArray();
                functionNames.add(Bytes.toString((byte[])functionName));
                byte[] key = SchemaUtil.getFunctionKey(tenantId, functionName);
                MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkFunctionKeyInRegion(key, region);
                if (result != null) {
                    done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                    return;
                }
                functions.add(new Pair((Object)functionName, (Object)functionTimestampsList.get(i)));
                keys.add(key);
            }
            long currentTime = EnvironmentEdgeManager.currentTimeMillis();
            List<PFunction> functionsAvailable = this.doGetFunctions(keys, request.getClientTimestamp());
            if (functionsAvailable == null) {
                builder.setReturnCode(MetaDataProtos.MutationCode.FUNCTION_NOT_FOUND);
                builder.setMutationTime(currentTime);
                done.run((Object)builder.build());
                return;
            }
            builder.setReturnCode(MetaDataProtos.MutationCode.FUNCTION_ALREADY_EXISTS);
            builder.setMutationTime(currentTime);
            for (PFunction function : functionsAvailable) {
                builder.addFunction(PFunction.toProto(function));
            }
            done.run((Object)builder.build());
            return;
        }
        catch (Throwable t) {
            logger.error("getFunctions failed", t);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(((Object)functionNames).toString(), t));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createFunction(RpcController controller, MetaDataProtos.CreateFunctionRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        MetaDataProtos.MetaDataResponse.Builder builder = MetaDataProtos.MetaDataResponse.newBuilder();
        byte[][] rowKeyMetaData = new byte[2][];
        byte[] functionName = null;
        try {
            List<Mutation> functionMetaData = ProtobufUtil.getMutations(request);
            boolean temporaryFunction = request.getTemporary();
            MetaDataUtil.getTenantIdAndFunctionName(functionMetaData, rowKeyMetaData);
            byte[] tenantIdBytes = rowKeyMetaData[0];
            functionName = rowKeyMetaData[1];
            byte[] lockKey = SchemaUtil.getFunctionKey(tenantIdBytes, functionName);
            Region region = this.env.getRegion();
            MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkFunctionKeyInRegion(lockKey, region);
            if (result != null) {
                done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                return;
            }
            ArrayList locks = Lists.newArrayList();
            long clientTimeStamp = MetaDataUtil.getClientTimeStamp(functionMetaData);
            try {
                MetaDataEndpointImpl.acquireLock(region, lockKey, locks);
                GlobalCache.FunctionBytesPtr cacheKey = new GlobalCache.FunctionBytesPtr(lockKey);
                PFunction function = this.loadFunction(this.env, lockKey, cacheKey, clientTimeStamp, clientTimeStamp, request.getReplace(), functionMetaData);
                if (function != null) {
                    if (function.getTimeStamp() < clientTimeStamp) {
                        if (!MetaDataEndpointImpl.isFunctionDeleted(function)) {
                            builder.setReturnCode(MetaDataProtos.MutationCode.FUNCTION_ALREADY_EXISTS);
                            builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                            builder.addFunction(PFunction.toProto(function));
                            done.run((Object)builder.build());
                            if (!request.getReplace()) {
                                return;
                            }
                        }
                    } else {
                        builder.setReturnCode(MetaDataProtos.MutationCode.NEWER_FUNCTION_FOUND);
                        builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                        builder.addFunction(PFunction.toProto(function));
                        done.run((Object)builder.build());
                        return;
                    }
                }
                if (!temporaryFunction) {
                    region.mutateRowsWithLocks(functionMetaData, Collections.emptySet(), 0L, 0L);
                }
                Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
                metaDataCache.invalidate((Object)cacheKey);
                long currentTimeStamp = MetaDataUtil.getClientTimeStamp(functionMetaData);
                builder.setReturnCode(MetaDataProtos.MutationCode.FUNCTION_NOT_FOUND);
                builder.setMutationTime(currentTimeStamp);
                done.run((Object)builder.build());
                return;
            }
            finally {
                region.releaseRowLocks((List)locks);
            }
        }
        catch (Throwable t) {
            logger.error("createFunction failed", t);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(Bytes.toString(functionName), t));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropFunction(RpcController controller, MetaDataProtos.DropFunctionRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        byte[][] rowKeyMetaData = new byte[2][];
        byte[] functionName = null;
        try {
            List<Mutation> functionMetaData = ProtobufUtil.getMutations(request);
            MetaDataUtil.getTenantIdAndFunctionName(functionMetaData, rowKeyMetaData);
            byte[] tenantIdBytes = rowKeyMetaData[0];
            functionName = rowKeyMetaData[1];
            byte[] lockKey = SchemaUtil.getFunctionKey(tenantIdBytes, functionName);
            Region region = this.env.getRegion();
            MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkFunctionKeyInRegion(lockKey, region);
            if (result != null) {
                done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                return;
            }
            ArrayList locks = Lists.newArrayList();
            long clientTimeStamp = MetaDataUtil.getClientTimeStamp(functionMetaData);
            try {
                MetaDataEndpointImpl.acquireLock(region, lockKey, locks);
                ArrayList<byte[]> keys = new ArrayList<byte[]>(1);
                keys.add(lockKey);
                ArrayList<ImmutableBytesPtr> invalidateList = new ArrayList<ImmutableBytesPtr>();
                result = this.doDropFunction(clientTimeStamp, keys, functionMetaData, invalidateList);
                if (result.getMutationCode() != MetaDataProtocol.MutationCode.FUNCTION_ALREADY_EXISTS) {
                    done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                    return;
                }
                region.mutateRowsWithLocks(functionMetaData, Collections.emptySet(), 0L, 0L);
                Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
                long currentTime = MetaDataUtil.getClientTimeStamp(functionMetaData);
                for (ImmutableBytesPtr ptr : invalidateList) {
                    metaDataCache.invalidate((Object)ptr);
                    metaDataCache.put((Object)ptr, (Object)MetaDataEndpointImpl.newDeletedFunctionMarker(currentTime));
                }
                done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                return;
            }
            finally {
                region.releaseRowLocks((List)locks);
            }
        }
        catch (Throwable t) {
            logger.error("dropFunction failed", t);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(Bytes.toString(functionName), t));
            return;
        }
    }

    private MetaDataProtocol.MetaDataMutationResult doDropFunction(long clientTimeStamp, List<byte[]> keys, List<Mutation> functionMetaData, List<ImmutableBytesPtr> invalidateList) throws IOException, SQLException {
        ArrayList<byte[]> keysClone = new ArrayList<byte[]>(keys);
        List<PFunction> functions = this.doGetFunctions(keysClone, clientTimeStamp);
        if (functions == null || functions.isEmpty()) {
            if (this.buildDeletedFunction(keys.get(0), new GlobalCache.FunctionBytesPtr(keys.get(0)), this.env.getRegion(), clientTimeStamp) != null) {
                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.FUNCTION_ALREADY_EXISTS, EnvironmentEdgeManager.currentTimeMillis(), null);
            }
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.FUNCTION_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
        }
        if (functions != null && !functions.isEmpty() && functions.get(0).getTimeStamp() < clientTimeStamp) {
            if (MetaDataEndpointImpl.isFunctionDeleted(functions.get(0))) {
                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.FUNCTION_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
            }
            invalidateList.add(new GlobalCache.FunctionBytesPtr(keys.get(0)));
            Region region = this.env.getRegion();
            Scan scan = MetaDataUtil.newTableRowsScan(keys.get(0), 0L, clientTimeStamp);
            ArrayList results = Lists.newArrayList();
            try (RegionScanner scanner = region.getScanner(scan);){
                scanner.next((List)results);
                if (results.isEmpty()) {
                    MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.FUNCTION_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
                    return metaDataMutationResult;
                }
                do {
                    Cell kv = (Cell)results.get(0);
                    Delete delete = new Delete(kv.getRowArray(), kv.getRowOffset(), (int)kv.getRowLength(), clientTimeStamp);
                    functionMetaData.add((Mutation)delete);
                    results.clear();
                    scanner.next((List)results);
                } while (!results.isEmpty());
            }
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.FUNCTION_ALREADY_EXISTS, EnvironmentEdgeManager.currentTimeMillis(), functions, true);
        }
        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.FUNCTION_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSchema(RpcController controller, MetaDataProtos.CreateSchemaRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        MetaDataProtos.MetaDataResponse.Builder builder = MetaDataProtos.MetaDataResponse.newBuilder();
        String schemaName = null;
        try {
            List<Mutation> schemaMutations = ProtobufUtil.getMutations(request);
            schemaName = request.getSchemaName();
            Put m = MetaDataUtil.getPutOnlyTableHeaderRow(schemaMutations);
            byte[] lockKey = m.getRow();
            Region region = this.env.getRegion();
            MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkSchemaKeyInRegion(lockKey, region);
            if (result != null) {
                done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                return;
            }
            ArrayList locks = Lists.newArrayList();
            long clientTimeStamp = MetaDataUtil.getClientTimeStamp(schemaMutations);
            try {
                MetaDataEndpointImpl.acquireLock(region, lockKey, locks);
                ImmutableBytesPtr cacheKey = new ImmutableBytesPtr(lockKey);
                PSchema schema = this.loadSchema(this.env, lockKey, cacheKey, clientTimeStamp, clientTimeStamp);
                if (schema != null) {
                    if (schema.getTimeStamp() < clientTimeStamp) {
                        if (!MetaDataEndpointImpl.isSchemaDeleted(schema)) {
                            builder.setReturnCode(MetaDataProtos.MutationCode.SCHEMA_ALREADY_EXISTS);
                            builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                            builder.setSchema(PSchema.toProto(schema));
                            done.run((Object)builder.build());
                            return;
                        }
                    } else {
                        builder.setReturnCode(MetaDataProtos.MutationCode.NEWER_SCHEMA_FOUND);
                        builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                        builder.setSchema(PSchema.toProto(schema));
                        done.run((Object)builder.build());
                        return;
                    }
                }
                region.mutateRowsWithLocks(schemaMutations, Collections.emptySet(), 0L, 0L);
                Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
                if (cacheKey != null) {
                    metaDataCache.invalidate((Object)cacheKey);
                }
                long currentTimeStamp = MetaDataUtil.getClientTimeStamp(schemaMutations);
                builder.setReturnCode(MetaDataProtos.MutationCode.SCHEMA_NOT_FOUND);
                builder.setMutationTime(currentTimeStamp);
                done.run((Object)builder.build());
                return;
            }
            finally {
                region.releaseRowLocks((List)locks);
            }
        }
        catch (Throwable t) {
            logger.error("Creating the schema" + schemaName + "failed", t);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(schemaName, t));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropSchema(RpcController controller, MetaDataProtos.DropSchemaRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        String schemaName = null;
        try {
            List<Mutation> schemaMetaData = ProtobufUtil.getMutations(request);
            schemaName = request.getSchemaName();
            byte[] lockKey = SchemaUtil.getSchemaKey(schemaName);
            Region region = this.env.getRegion();
            MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkSchemaKeyInRegion(lockKey, region);
            if (result != null) {
                done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                return;
            }
            ArrayList locks = Lists.newArrayList();
            long clientTimeStamp = MetaDataUtil.getClientTimeStamp(schemaMetaData);
            try {
                MetaDataEndpointImpl.acquireLock(region, lockKey, locks);
                ArrayList<ImmutableBytesPtr> invalidateList = new ArrayList<ImmutableBytesPtr>(1);
                result = this.doDropSchema(clientTimeStamp, schemaName, lockKey, schemaMetaData, invalidateList);
                if (result.getMutationCode() != MetaDataProtocol.MutationCode.SCHEMA_ALREADY_EXISTS) {
                    done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                    return;
                }
                region.mutateRowsWithLocks(schemaMetaData, Collections.emptySet(), 0L, 0L);
                Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
                long currentTime = MetaDataUtil.getClientTimeStamp(schemaMetaData);
                for (ImmutableBytesPtr ptr : invalidateList) {
                    metaDataCache.invalidate((Object)ptr);
                    metaDataCache.put((Object)ptr, (Object)MetaDataEndpointImpl.newDeletedSchemaMarker(currentTime));
                }
                done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                return;
            }
            finally {
                region.releaseRowLocks((List)locks);
            }
        }
        catch (Throwable t) {
            logger.error("drop schema failed:", t);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(schemaName, t));
            return;
        }
    }

    private MetaDataProtocol.MetaDataMutationResult doDropSchema(long clientTimeStamp, String schemaName, byte[] key, List<Mutation> schemaMutations, List<ImmutableBytesPtr> invalidateList) throws IOException, SQLException {
        PSchema schema = this.loadSchema(this.env, key, new ImmutableBytesPtr(key), clientTimeStamp, clientTimeStamp);
        boolean areTablesExists = false;
        if (schema == null) {
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.SCHEMA_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
        }
        if (schema.getTimeStamp() < clientTimeStamp) {
            Region region = this.env.getRegion();
            Scan scan = MetaDataUtil.newTableRowsScan(SchemaUtil.getKeyForSchema(null, schemaName), 0L, clientTimeStamp);
            ArrayList results = Lists.newArrayList();
            try (RegionScanner scanner = region.getScanner(scan);){
                scanner.next((List)results);
                if (results.isEmpty()) {
                    MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.SCHEMA_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
                    return metaDataMutationResult;
                }
                do {
                    Cell kv;
                    if (Bytes.compareTo((byte[])(kv = (Cell)results.get(0)).getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength(), (byte[])key, (int)0, (int)key.length) != 0) {
                        areTablesExists = true;
                        break;
                    }
                    results.clear();
                    scanner.next((List)results);
                } while (!results.isEmpty());
            }
            if (areTablesExists) {
                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLES_EXIST_ON_SCHEMA, schema, EnvironmentEdgeManager.currentTimeMillis());
            }
            invalidateList.add(new ImmutableBytesPtr(key));
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.SCHEMA_ALREADY_EXISTS, schema, EnvironmentEdgeManager.currentTimeMillis());
        }
        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.SCHEMA_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
    }

    static {
        Collections.sort(TABLE_KV_COLUMNS, KeyValue.COMPARATOR);
        TABLE_TYPE_INDEX = TABLE_KV_COLUMNS.indexOf(TABLE_TYPE_KV);
        TABLE_SEQ_NUM_INDEX = TABLE_KV_COLUMNS.indexOf(TABLE_SEQ_NUM_KV);
        COLUMN_COUNT_INDEX = TABLE_KV_COLUMNS.indexOf(COLUMN_COUNT_KV);
        SALT_BUCKETS_INDEX = TABLE_KV_COLUMNS.indexOf(SALT_BUCKETS_KV);
        PK_NAME_INDEX = TABLE_KV_COLUMNS.indexOf(PK_NAME_KV);
        DATA_TABLE_NAME_INDEX = TABLE_KV_COLUMNS.indexOf(DATA_TABLE_NAME_KV);
        INDEX_STATE_INDEX = TABLE_KV_COLUMNS.indexOf(INDEX_STATE_KV);
        IMMUTABLE_ROWS_INDEX = TABLE_KV_COLUMNS.indexOf(IMMUTABLE_ROWS_KV);
        VIEW_STATEMENT_INDEX = TABLE_KV_COLUMNS.indexOf(VIEW_EXPRESSION_KV);
        DEFAULT_COLUMN_FAMILY_INDEX = TABLE_KV_COLUMNS.indexOf(DEFAULT_COLUMN_FAMILY_KV);
        DISABLE_WAL_INDEX = TABLE_KV_COLUMNS.indexOf(DISABLE_WAL_KV);
        MULTI_TENANT_INDEX = TABLE_KV_COLUMNS.indexOf(MULTI_TENANT_KV);
        VIEW_TYPE_INDEX = TABLE_KV_COLUMNS.indexOf(VIEW_TYPE_KV);
        VIEW_INDEX_ID_INDEX = TABLE_KV_COLUMNS.indexOf(VIEW_INDEX_ID_KV);
        INDEX_TYPE_INDEX = TABLE_KV_COLUMNS.indexOf(INDEX_TYPE_KV);
        STORE_NULLS_INDEX = TABLE_KV_COLUMNS.indexOf(STORE_NULLS_KV);
        BASE_COLUMN_COUNT_INDEX = TABLE_KV_COLUMNS.indexOf(BASE_COLUMN_COUNT_KV);
        ROW_KEY_ORDER_OPTIMIZABLE_INDEX = TABLE_KV_COLUMNS.indexOf(ROW_KEY_ORDER_OPTIMIZABLE_KV);
        TRANSACTIONAL_INDEX = TABLE_KV_COLUMNS.indexOf(TRANSACTIONAL_KV);
        UPDATE_CACHE_FREQUENCY_INDEX = TABLE_KV_COLUMNS.indexOf(UPDATE_CACHE_FREQUENCY_KV);
        INDEX_DISABLE_TIMESTAMP = TABLE_KV_COLUMNS.indexOf(INDEX_DISABLE_TIMESTAMP_KV);
        IS_NAMESPACE_MAPPED_INDEX = TABLE_KV_COLUMNS.indexOf(IS_NAMESPACE_MAPPED_KV);
        AUTO_PARTITION_SEQ_INDEX = TABLE_KV_COLUMNS.indexOf(AUTO_PARTITION_SEQ_KV);
        APPEND_ONLY_SCHEMA_INDEX = TABLE_KV_COLUMNS.indexOf(APPEND_ONLY_SCHEMA_KV);
        STORAGE_SCHEME_INDEX = TABLE_KV_COLUMNS.indexOf(STORAGE_SCHEME_KV);
        QUALIFIER_ENCODING_SCHEME_INDEX = TABLE_KV_COLUMNS.indexOf(ENCODING_SCHEME_KV);
        USE_STATS_FOR_PARALLELIZATION_INDEX = TABLE_KV_COLUMNS.indexOf(USE_STATS_FOR_PARALLELIZATION_KV);
        DECIMAL_DIGITS_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.DECIMAL_DIGITS_BYTES);
        COLUMN_SIZE_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.COLUMN_SIZE_BYTES);
        NULLABLE_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.NULLABLE_BYTES);
        DATA_TYPE_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.DATA_TYPE_BYTES);
        ORDINAL_POSITION_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.ORDINAL_POSITION_BYTES);
        SORT_ORDER_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.SORT_ORDER_BYTES);
        ARRAY_SIZE_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.ARRAY_SIZE_BYTES);
        VIEW_CONSTANT_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.VIEW_CONSTANT_BYTES);
        IS_VIEW_REFERENCED_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.IS_VIEW_REFERENCED_BYTES);
        COLUMN_DEF_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.COLUMN_DEF_BYTES);
        IS_ROW_TIMESTAMP_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.IS_ROW_TIMESTAMP_BYTES);
        COLUMN_QUALIFIER_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.COLUMN_QUALIFIER_BYTES);
        COLUMN_KV_COLUMNS = Arrays.asList(DECIMAL_DIGITS_KV, COLUMN_SIZE_KV, NULLABLE_KV, DATA_TYPE_KV, ORDINAL_POSITION_KV, SORT_ORDER_KV, DATA_TABLE_NAME_KV, ARRAY_SIZE_KV, VIEW_CONSTANT_KV, IS_VIEW_REFERENCED_KV, COLUMN_DEF_KV, IS_ROW_TIMESTAMP_KV, COLUMN_QUALIFIER_KV);
        Collections.sort(COLUMN_KV_COLUMNS, KeyValue.COMPARATOR);
        QUALIFIER_COUNTER_KV = KeyValue.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.COLUMN_QUALIFIER_COUNTER_BYTES);
        DECIMAL_DIGITS_INDEX = COLUMN_KV_COLUMNS.indexOf(DECIMAL_DIGITS_KV);
        COLUMN_SIZE_INDEX = COLUMN_KV_COLUMNS.indexOf(COLUMN_SIZE_KV);
        NULLABLE_INDEX = COLUMN_KV_COLUMNS.indexOf(NULLABLE_KV);
        DATA_TYPE_INDEX = COLUMN_KV_COLUMNS.indexOf(DATA_TYPE_KV);
        ORDINAL_POSITION_INDEX = COLUMN_KV_COLUMNS.indexOf(ORDINAL_POSITION_KV);
        SORT_ORDER_INDEX = COLUMN_KV_COLUMNS.indexOf(SORT_ORDER_KV);
        ARRAY_SIZE_INDEX = COLUMN_KV_COLUMNS.indexOf(ARRAY_SIZE_KV);
        VIEW_CONSTANT_INDEX = COLUMN_KV_COLUMNS.indexOf(VIEW_CONSTANT_KV);
        IS_VIEW_REFERENCED_INDEX = COLUMN_KV_COLUMNS.indexOf(IS_VIEW_REFERENCED_KV);
        COLUMN_DEF_INDEX = COLUMN_KV_COLUMNS.indexOf(COLUMN_DEF_KV);
        IS_ROW_TIMESTAMP_INDEX = COLUMN_KV_COLUMNS.indexOf(IS_ROW_TIMESTAMP_KV);
        COLUMN_QUALIFIER_INDEX = COLUMN_KV_COLUMNS.indexOf(COLUMN_QUALIFIER_KV);
        CLASS_NAME_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.CLASS_NAME_BYTES);
        JAR_PATH_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.JAR_PATH_BYTES);
        RETURN_TYPE_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.RETURN_TYPE_BYTES);
        NUM_ARGS_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.NUM_ARGS_BYTES);
        TYPE_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.TYPE_BYTES);
        IS_CONSTANT_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.IS_CONSTANT_BYTES);
        DEFAULT_VALUE_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.DEFAULT_VALUE_BYTES);
        MIN_VALUE_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.MIN_VALUE_BYTES);
        MAX_VALUE_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.MAX_VALUE_BYTES);
        IS_ARRAY_KV = org.apache.hadoop.hbase.KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.IS_ARRAY_BYTES);
        FUNCTION_KV_COLUMNS = Arrays.asList(EMPTY_KEYVALUE_KV, CLASS_NAME_KV, JAR_PATH_KV, RETURN_TYPE_KV, NUM_ARGS_KV);
        Collections.sort(FUNCTION_KV_COLUMNS, KeyValue.COMPARATOR);
        CLASS_NAME_INDEX = FUNCTION_KV_COLUMNS.indexOf(CLASS_NAME_KV);
        JAR_PATH_INDEX = FUNCTION_KV_COLUMNS.indexOf(JAR_PATH_KV);
        RETURN_TYPE_INDEX = FUNCTION_KV_COLUMNS.indexOf(RETURN_TYPE_KV);
        NUM_ARGS_INDEX = FUNCTION_KV_COLUMNS.indexOf(NUM_ARGS_KV);
        FUNCTION_ARG_KV_COLUMNS = Arrays.asList(TYPE_KV, IS_ARRAY_KV, IS_CONSTANT_KV, DEFAULT_VALUE_KV, MIN_VALUE_KV, MAX_VALUE_KV);
        Collections.sort(FUNCTION_ARG_KV_COLUMNS, KeyValue.COMPARATOR);
        IS_ARRAY_INDEX = FUNCTION_ARG_KV_COLUMNS.indexOf(IS_ARRAY_KV);
        IS_CONSTANT_INDEX = FUNCTION_ARG_KV_COLUMNS.indexOf(IS_CONSTANT_KV);
        DEFAULT_VALUE_INDEX = FUNCTION_ARG_KV_COLUMNS.indexOf(DEFAULT_VALUE_KV);
        MIN_VALUE_INDEX = FUNCTION_ARG_KV_COLUMNS.indexOf(MIN_VALUE_KV);
        MAX_VALUE_INDEX = FUNCTION_ARG_KV_COLUMNS.indexOf(MAX_VALUE_KV);
        CHILD_TABLE_BYTES = new byte[]{PTable.LinkType.CHILD_TABLE.getSerializedValue()};
        PHYSICAL_TABLE_BYTES = new byte[]{PTable.LinkType.PHYSICAL_TABLE.getSerializedValue()};
    }

    private static class TableViewFinder {
        private List<ViewInfo> viewInfoList = Lists.newArrayList();
        private boolean allViewsNotInSingleRegion = false;

        private TableViewFinder() {
        }

        private TableViewFinder(List<ViewInfo> viewInfoList) {
            this.viewInfoList = viewInfoList;
        }

        public boolean hasViews() {
            return !this.viewInfoList.isEmpty();
        }

        private void setAllViewsNotInSingleRegion() {
            this.allViewsNotInSingleRegion = true;
        }

        private List<ViewInfo> getViewInfoList() {
            return this.viewInfoList;
        }

        private boolean allViewsInSingleRegion() {
            return this.viewInfoList.size() > 0 && !this.allViewsNotInSingleRegion;
        }

        private boolean allViewsInMultipleRegions() {
            return this.viewInfoList.size() > 0 && this.allViewsNotInSingleRegion;
        }

        private void addResult(TableViewFinder result) {
            this.viewInfoList.addAll(result.getViewInfoList());
            if (result.allViewsInMultipleRegions()) {
                this.setAllViewsNotInSingleRegion();
            }
        }
    }

    private static class ViewInfo {
        private byte[] tenantId;
        private byte[] schemaName;
        private byte[] viewName;

        public ViewInfo(byte[] tenantId, byte[] schemaName, byte[] viewName) {
            this.tenantId = tenantId;
            this.schemaName = schemaName;
            this.viewName = viewName;
        }

        public byte[] getTenantId() {
            return this.tenantId;
        }

        public byte[] getSchemaName() {
            return this.schemaName;
        }

        public byte[] getViewName() {
            return this.viewName;
        }
    }

    private class ColumnFinder
    extends StatelessTraverseAllExpressionVisitor<Void> {
        private boolean columnFound;
        private final Expression columnExpression;

        public ColumnFinder(Expression columnExpression) {
            this.columnExpression = columnExpression;
            this.columnFound = false;
        }

        private Void process(Expression expression) {
            if (expression.equals(this.columnExpression)) {
                this.columnFound = true;
            }
            return null;
        }

        @Override
        public Void visit(KeyValueColumnExpression expression) {
            return this.process(expression);
        }

        @Override
        public Void visit(RowKeyColumnExpression expression) {
            return this.process(expression);
        }

        @Override
        public Void visit(ProjectedColumnExpression expression) {
            return this.process(expression);
        }

        public boolean getColumnFound() {
            return this.columnFound;
        }
    }

    private static class ColumnOrdinalPositionUpdateList {
        final List<byte[]> columnKeys = new ArrayList<byte[]>(10);
        int offset;

        private ColumnOrdinalPositionUpdateList() {
        }

        int size() {
            return this.columnKeys.size();
        }

        private void setOffset(int lowestOrdinalPos) {
            this.offset = lowestOrdinalPos;
        }

        private void addColumn(byte[] columnKey) {
            this.columnKeys.add(columnKey);
        }

        private void dropColumn(byte[] columnKey) {
            int index = -1;
            for (int i = 0; i < this.columnKeys.size(); ++i) {
                if (!Bytes.equals((byte[])this.columnKeys.get(i), (byte[])columnKey)) continue;
                index = i;
                break;
            }
            if (index != -1) {
                this.columnKeys.remove(index);
            }
        }

        private void addColumn(byte[] columnKey, int position) {
            int i;
            Preconditions.checkArgument((position >= this.offset ? 1 : 0) != 0);
            int index = position - this.offset;
            int size = this.columnKeys.size();
            Preconditions.checkState((index <= size ? 1 : 0) != 0);
            if (size == 0) {
                this.columnKeys.add(columnKey);
                return;
            }
            int stopIndex = size;
            for (i = 0; i < size; ++i) {
                if (!Bytes.equals((byte[])this.columnKeys.get(i), (byte[])columnKey)) continue;
                stopIndex = i;
                break;
            }
            if (stopIndex == size) {
                this.columnKeys.add(index, columnKey);
            } else {
                for (i = stopIndex; i > index; --i) {
                    this.columnKeys.set(i, this.columnKeys.get(i - 1));
                }
                this.columnKeys.set(index, columnKey);
            }
        }

        private int getOrdinalPositionFromListIdx(int listIndex) {
            Preconditions.checkArgument((listIndex < this.columnKeys.size() ? 1 : 0) != 0);
            return listIndex + this.offset;
        }

        private int getOrdinalPositionOfColumn(byte[] columnKey) {
            int i = 0;
            for (byte[] key : this.columnKeys) {
                if (Bytes.equals((byte[])key, (byte[])columnKey)) {
                    return i + this.offset;
                }
                ++i;
            }
            return -1;
        }
    }

    private final class PutWithOrdinalPosition
    implements Comparable<PutWithOrdinalPosition> {
        private final Put put;
        private final int ordinalPosition;

        public PutWithOrdinalPosition(Put put, int ordinalPos) {
            this.put = put;
            this.ordinalPosition = ordinalPos;
        }

        @Override
        public int compareTo(PutWithOrdinalPosition o) {
            return this.ordinalPosition < o.ordinalPosition ? -1 : (this.ordinalPosition > o.ordinalPosition ? 1 : 0);
        }
    }

    private static interface ColumnMutator {
        public MetaDataProtocol.MetaDataMutationResult updateMutation(PTable var1, byte[][] var2, List<Mutation> var3, Region var4, List<ImmutableBytesPtr> var5, List<Region.RowLock> var6, long var7) throws IOException, SQLException;
    }
}

