/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimerTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.phoenix.cache.GlobalCache;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.PostDDLCompiler;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.hbase.index.util.IndexManagementUtil;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.UpgradeUtil;

public class MetaDataRegionObserver
extends BaseRegionObserver {
    public static final Log LOG = LogFactory.getLog(MetaDataRegionObserver.class);
    protected ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
    private boolean enableRebuildIndex = true;
    private long rebuildIndexTimeInterval = 60000L;
    private static Map<PName, Long> batchExecutedPerTableMap = new HashMap<PName, Long>();

    public void preClose(ObserverContext<RegionCoprocessorEnvironment> c, boolean abortRequested) {
        this.executor.shutdownNow();
        GlobalCache.getInstance((RegionCoprocessorEnvironment)c.getEnvironment()).getMetaDataCache().invalidateAll();
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        long sleepTime = env.getConfiguration().getLong("phoenix.clock.skew.interval", 2000L);
        try {
            if (sleepTime > 0L) {
                Thread.sleep(sleepTime);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        this.enableRebuildIndex = env.getConfiguration().getBoolean("phoenix.index.failure.handling.rebuild", true);
        this.rebuildIndexTimeInterval = env.getConfiguration().getLong("phoenix.index.failure.handling.rebuild.interval", 60000L);
    }

    public void postOpen(ObserverContext<RegionCoprocessorEnvironment> e) {
        final RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)e.getEnvironment();
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HTableInterface metaTable = null;
                HTableInterface statsTable = null;
                try {
                    ReadOnlyProps props = new ReadOnlyProps(env.getConfiguration().iterator());
                    Thread.sleep(1000L);
                    metaTable = env.getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, props));
                    statsTable = env.getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_STATS_NAME_BYTES, props));
                    if (UpgradeUtil.truncateStats(metaTable, statsTable)) {
                        LOG.info((Object)"Stats are successfully truncated for upgrade 4.7!!");
                    }
                }
                catch (Exception exception) {
                    LOG.warn((Object)"Exception while truncate stats.., please check and delete stats manually inorder to get proper result with old client!!");
                    LOG.warn((Object)exception.getStackTrace());
                }
                finally {
                    try {
                        if (metaTable != null) {
                            metaTable.close();
                        }
                        if (statsTable != null) {
                            statsTable.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.start();
        if (!this.enableRebuildIndex) {
            LOG.info((Object)"Failure Index Rebuild is skipped by configuration.");
            return;
        }
        Logger deprecationLogger = Logger.getLogger((String)"org.apache.hadoop.conf.Configuration.deprecation");
        if (deprecationLogger != null) {
            deprecationLogger.setLevel(Level.WARN);
        }
        try {
            Class.forName(PhoenixDriver.class.getName());
            BuildIndexScheduleTask task = new BuildIndexScheduleTask((RegionCoprocessorEnvironment)e.getEnvironment());
            this.executor.scheduleAtFixedRate(task, 10000L, this.rebuildIndexTimeInterval, TimeUnit.MILLISECONDS);
        }
        catch (ClassNotFoundException ex) {
            LOG.error((Object)"BuildIndexScheduleTask cannot start!", (Throwable)ex);
        }
    }

    private static void updateIndexState(PhoenixConnection conn, String indexTableName, RegionCoprocessorEnvironment env, PIndexState oldState, PIndexState newState) throws ServiceException, Throwable {
        byte[] indexTableKey = SchemaUtil.getTableKeyFromFullName(indexTableName);
        String schemaName = SchemaUtil.getSchemaNameFromFullName(indexTableName);
        String indexName = SchemaUtil.getTableNameFromFullName(indexTableName);
        Put put = new Put(indexTableKey);
        put.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_STATE_BYTES, newState.getSerializedBytes());
        if (newState == PIndexState.ACTIVE) {
            put.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_DISABLE_TIMESTAMP_BYTES, PLong.INSTANCE.toBytes(0));
            put.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.ASYNC_REBUILD_TIMESTAMP_BYTES, PLong.INSTANCE.toBytes(0));
        }
        List<Put> tableMetadata = Collections.singletonList(put);
        MetaDataProtocol.MetaDataMutationResult result = conn.getQueryServices().updateIndexState(tableMetadata, null);
        MetaDataProtocol.MutationCode code = result.getMutationCode();
        if (code == MetaDataProtocol.MutationCode.TABLE_NOT_FOUND) {
            throw new TableNotFoundException(schemaName, indexName);
        }
        if (code == MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_INDEX_STATE_TRANSITION).setMessage(" currentState=" + (Object)((Object)oldState) + ". requestedState=" + (Object)((Object)newState)).setSchemaName(schemaName).setTableName(indexName).build().buildException();
        }
    }

    private static void updateDisableTimestamp(PhoenixConnection conn, String indexTableName, RegionCoprocessorEnvironment env, long disabledTimestamp, HTableInterface metaTable) throws IOException {
        byte[] indexTableKey = SchemaUtil.getTableKeyFromFullName(indexTableName);
        Put put = new Put(indexTableKey);
        put.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_DISABLE_TIMESTAMP_BYTES, PLong.INSTANCE.toBytes(disabledTimestamp));
        metaTable.checkAndPut(indexTableKey, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_DISABLE_TIMESTAMP_BYTES, CompareFilter.CompareOp.NOT_EQUAL, PLong.INSTANCE.toBytes(0), put);
    }

    public static class BuildIndexScheduleTask
    extends TimerTask {
        private static final AtomicInteger inProgress = new AtomicInteger(0);
        RegionCoprocessorEnvironment env;
        private long rebuildIndexBatchSize = Long.MAX_VALUE;
        private long configuredBatches = 10L;

        public BuildIndexScheduleTask(RegionCoprocessorEnvironment env) {
            this.env = env;
            this.rebuildIndexBatchSize = env.getConfiguration().getLong("phoenix.index.failure.handling.rebuild.period", Long.MAX_VALUE);
            this.configuredBatches = env.getConfiguration().getLong("phoenix.index.rebuild.batch.perTable", this.configuredBatches);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block49: {
                RegionScanner scanner = null;
                PhoenixConnection conn = null;
                if (inProgress.getAndIncrement() > 0) {
                    inProgress.decrementAndGet();
                    LOG.debug((Object)"New ScheduledBuildIndexTask skipped as there is already one running");
                    return;
                }
                try {
                    Scan scan = new Scan();
                    SingleColumnValueFilter filter = new SingleColumnValueFilter(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_DISABLE_TIMESTAMP_BYTES, CompareFilter.CompareOp.NOT_EQUAL, PLong.INSTANCE.toBytes(0L));
                    filter.setFilterIfMissing(true);
                    scan.setFilter((Filter)filter);
                    scan.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.TABLE_NAME_BYTES);
                    scan.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DATA_TABLE_NAME_BYTES);
                    scan.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_STATE_BYTES);
                    scan.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_DISABLE_TIMESTAMP_BYTES);
                    Map dataTableToIndexesMap = null;
                    boolean hasMore = false;
                    ArrayList results = new ArrayList();
                    scanner = this.env.getRegion().getScanner(scan);
                    do {
                        List indexesToPartiallyRebuild;
                        byte[] dataTable;
                        results.clear();
                        hasMore = scanner.next(results);
                        if (results.isEmpty()) break;
                        Result r = Result.create(results);
                        byte[] disabledTimeStamp = r.getValue(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_DISABLE_TIMESTAMP_BYTES);
                        byte[] indexState = r.getValue(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_STATE_BYTES);
                        if (disabledTimeStamp == null || disabledTimeStamp.length == 0 || (dataTable = r.getValue(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DATA_TABLE_NAME_BYTES)) == null || dataTable.length == 0 || indexState == null || indexState.length == 0) continue;
                        byte[][] rowKeyMetaData = new byte[3][];
                        SchemaUtil.getVarChars(r.getRow(), 3, rowKeyMetaData);
                        byte[] schemaName = rowKeyMetaData[1];
                        byte[] indexTable = rowKeyMetaData[2];
                        if (indexTable == null || indexTable.length == 0) {
                            LOG.debug((Object)("We find IndexTable empty during rebuild scan:" + scan + "so, Index rebuild has been skipped for row=" + r));
                            continue;
                        }
                        if (conn == null) {
                            Properties props = new Properties();
                            props.setProperty("CurrentSCN", Long.toString(Long.MAX_VALUE));
                            props.setProperty("phoenix.query.timeoutMs", Long.toString(Long.MAX_VALUE));
                            props.setProperty("hbase.client.scanner.timeout.period", Long.toString(Long.MAX_VALUE));
                            props.setProperty("hbase.rpc.timeout", Long.toString(Long.MAX_VALUE));
                            props.setProperty("phoenix.index.population.wait.time", "0");
                            conn = QueryUtil.getConnectionOnServer(props, this.env.getConfiguration()).unwrap(PhoenixConnection.class);
                            dataTableToIndexesMap = Maps.newHashMap();
                        }
                        String dataTableFullName = SchemaUtil.getTableName(schemaName, dataTable);
                        PTable dataPTable = PhoenixRuntime.getTableNoCache(conn, dataTableFullName);
                        String indexTableFullName = SchemaUtil.getTableName(schemaName, indexTable);
                        PTable indexPTable = PhoenixRuntime.getTableNoCache(conn, indexTableFullName);
                        if (!dataPTable.getIndexes().contains(indexPTable)) continue;
                        if (!MetaDataUtil.tableRegionsOnline(this.env.getConfiguration(), indexPTable)) {
                            LOG.debug((Object)("Index rebuild has been skipped because not all regions of index table=" + indexPTable.getName() + " are online."));
                            continue;
                        }
                        if (Bytes.compareTo((byte[])PIndexState.DISABLE.getSerializedBytes(), (byte[])indexState) == 0) {
                            MetaDataRegionObserver.updateIndexState(conn, indexTableFullName, this.env, PIndexState.DISABLE, PIndexState.INACTIVE);
                        }
                        if ((indexesToPartiallyRebuild = (List)dataTableToIndexesMap.get(dataPTable)) == null) {
                            indexesToPartiallyRebuild = Lists.newArrayListWithExpectedSize((int)dataPTable.getIndexes().size());
                            dataTableToIndexesMap.put(dataPTable, indexesToPartiallyRebuild);
                        }
                        LOG.debug((Object)("We have found " + (Object)((Object)indexPTable.getIndexState()) + " Index:" + indexPTable.getName() + " on data table:" + dataPTable.getName() + " which failed to be updated at " + indexPTable.getIndexDisableTimestamp()));
                        indexesToPartiallyRebuild.add(indexPTable);
                    } while (hasMore);
                    if (dataTableToIndexesMap == null) break block49;
                    long overlapTime = this.env.getConfiguration().getLong("phoenix.index.failure.handling.rebuild.overlap.time", 1L);
                    for (Map.Entry entry : dataTableToIndexesMap.entrySet()) {
                        PTable dataPTable = (PTable)entry.getKey();
                        List indexesToPartiallyRebuild = (List)entry.getValue();
                        ReadOnlyProps props = new ReadOnlyProps(this.env.getConfiguration().iterator());
                        try {
                            HTableInterface metaTable = this.env.getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, props));
                            Throwable throwable = null;
                            try {
                                long earliestDisableTimestamp = Long.MAX_VALUE;
                                ArrayList maintainers = Lists.newArrayListWithExpectedSize((int)indexesToPartiallyRebuild.size());
                                int signOfDisableTimeStamp = 0;
                                for (PTable index : indexesToPartiallyRebuild) {
                                    long disabledTimeStampVal = index.getIndexDisableTimestamp();
                                    if (disabledTimeStampVal == 0L) continue;
                                    if (signOfDisableTimeStamp != 0 && signOfDisableTimeStamp != Long.signum(disabledTimeStampVal)) {
                                        LOG.warn((Object)("Found unexpected mix of signs with INDEX_DISABLE_TIMESTAMP for " + dataPTable.getName().getString() + " with " + indexesToPartiallyRebuild));
                                    }
                                    signOfDisableTimeStamp = Long.signum(disabledTimeStampVal);
                                    if ((disabledTimeStampVal = Math.abs(disabledTimeStampVal)) < earliestDisableTimestamp) {
                                        earliestDisableTimestamp = disabledTimeStampVal;
                                    }
                                    maintainers.add(index.getIndexMaintainer(dataPTable, conn));
                                }
                                if (earliestDisableTimestamp == Long.MAX_VALUE) continue;
                                long timeStamp = Math.max(0L, earliestDisableTimestamp - overlapTime);
                                LOG.info((Object)("Starting to build " + dataPTable + " indexes " + indexesToPartiallyRebuild + " from timestamp=" + timeStamp));
                                TableRef tableRef = new TableRef(null, dataPTable, Long.MAX_VALUE, false);
                                PostDDLCompiler compiler = new PostDDLCompiler(conn);
                                MutationPlan plan = compiler.compile(Collections.singletonList(tableRef), null, null, null, Long.MAX_VALUE);
                                Scan dataTableScan = IndexManagementUtil.newLocalStateScan(plan.getContext().getScan(), maintainers);
                                long scanEndTime = this.getTimestampForBatch(timeStamp, (Long)batchExecutedPerTableMap.get(dataPTable.getName()));
                                dataTableScan.setTimeRange(timeStamp, scanEndTime);
                                dataTableScan.setCacheBlocks(false);
                                dataTableScan.setAttribute("_RebuildIndexes", PDataType.TRUE_BYTES);
                                ImmutableBytesWritable indexMetaDataPtr = new ImmutableBytesWritable(ByteUtil.EMPTY_BYTE_ARRAY);
                                IndexMaintainer.serializeAdditional(dataPTable, indexMetaDataPtr, indexesToPartiallyRebuild, conn);
                                byte[] attribValue = ByteUtil.copyKeyBytesIfNecessary(indexMetaDataPtr);
                                dataTableScan.setAttribute("IdxProtoMD", attribValue);
                                LOG.info((Object)("Starting to partially build indexes:" + indexesToPartiallyRebuild + " on data table:" + dataPTable.getName() + " with the earliest disable timestamp:" + earliestDisableTimestamp + " till " + (scanEndTime == Long.MAX_VALUE ? "LATEST_TIMESTAMP" : Long.valueOf(scanEndTime))));
                                MutationState mutationState = plan.execute();
                                long rowCount = mutationState.getUpdateCount();
                                if (scanEndTime == Long.MAX_VALUE) {
                                    LOG.info((Object)("Rebuild completed for all inactive/disabled indexes in data table:" + dataPTable.getName()));
                                }
                                LOG.info((Object)(" no. of datatable rows read in rebuilding process is " + rowCount));
                                for (PTable indexPTable : indexesToPartiallyRebuild) {
                                    String indexTableFullName = SchemaUtil.getTableName(indexPTable.getSchemaName().getString(), indexPTable.getTableName().getString());
                                    if (scanEndTime == Long.MAX_VALUE) {
                                        MetaDataRegionObserver.updateIndexState(conn, indexTableFullName, this.env, PIndexState.INACTIVE, PIndexState.ACTIVE);
                                        batchExecutedPerTableMap.remove(dataPTable.getName());
                                        LOG.info((Object)("Making Index:" + indexPTable.getTableName() + " active after rebuilding"));
                                        continue;
                                    }
                                    MetaDataRegionObserver.updateDisableTimestamp(conn, indexTableFullName, this.env, scanEndTime * (long)signOfDisableTimeStamp, metaTable);
                                    Long noOfBatches = (Long)batchExecutedPerTableMap.get(dataPTable.getName());
                                    if (noOfBatches == null) {
                                        noOfBatches = 0L;
                                    }
                                    noOfBatches = noOfBatches + 1L;
                                    batchExecutedPerTableMap.put(dataPTable.getName(), noOfBatches);
                                    new MetaDataClient(conn).updateCache(dataPTable.getSchemaName().getString(), dataPTable.getTableName().getString());
                                    new MetaDataClient(conn).updateCache(indexPTable.getSchemaName().getString(), indexPTable.getTableName().getString());
                                    LOG.info((Object)("During Round-robin build: Successfully updated index disabled timestamp  for " + indexTableFullName + " to " + scanEndTime));
                                }
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (metaTable == null) continue;
                                if (throwable != null) {
                                    try {
                                        metaTable.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                    continue;
                                }
                                metaTable.close();
                            }
                        }
                        catch (Exception e) {
                            LOG.warn((Object)("Unable to rebuild " + dataPTable + " indexes " + indexesToPartiallyRebuild + ". Will try again next on next scheduled invocation."), (Throwable)e);
                        }
                    }
                }
                catch (Throwable t) {
                    LOG.warn((Object)"ScheduledBuildIndexTask failed!", t);
                }
                finally {
                    inProgress.decrementAndGet();
                    if (scanner != null) {
                        try {
                            scanner.close();
                        }
                        catch (IOException ignored) {
                            LOG.debug((Object)"ScheduledBuildIndexTask can't close scanner.", (Throwable)ignored);
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException ignored) {
                            LOG.debug((Object)"ScheduledBuildIndexTask can't close connection", (Throwable)ignored);
                        }
                    }
                }
            }
        }

        private long getTimestampForBatch(long disabledTimeStamp, Long noOfBatches) {
            if (disabledTimeStamp < 0L || this.rebuildIndexBatchSize > Long.MAX_VALUE - disabledTimeStamp) {
                return Long.MAX_VALUE;
            }
            long timestampForNextBatch = disabledTimeStamp + this.rebuildIndexBatchSize;
            if (timestampForNextBatch < 0L || timestampForNextBatch > System.currentTimeMillis() || noOfBatches != null && noOfBatches > this.configuredBatches) {
                timestampForNextBatch = Long.MAX_VALUE;
            }
            return timestampForNextBatch;
        }
    }
}

