/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.apache.htrace.TraceScope;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.WhereCompiler;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ProjectedColumnExpression;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.iterate.DefaultParallelScanGrouper;
import org.apache.phoenix.iterate.DelegateResultIterator;
import org.apache.phoenix.iterate.ParallelIteratorFactory;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.trace.TracingIterator;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.SQLCloseable;
import org.apache.phoenix.util.SQLCloseables;
import org.apache.phoenix.util.ScanUtil;

public abstract class BaseQueryPlan
implements QueryPlan {
    private static final Log LOG = LogFactory.getLog(BaseQueryPlan.class);
    protected static final long DEFAULT_ESTIMATED_SIZE = 10240L;
    protected final TableRef tableRef;
    protected final Set<TableRef> tableRefs;
    protected final StatementContext context;
    protected final FilterableStatement statement;
    protected final RowProjector projection;
    protected final ParameterMetaData paramMetaData;
    protected final Integer limit;
    protected final Integer offset;
    protected final OrderByCompiler.OrderBy orderBy;
    protected final GroupByCompiler.GroupBy groupBy;
    protected final ParallelIteratorFactory parallelIteratorFactory;
    protected final Expression dynamicFilter;
    protected Long estimatedRows;
    protected Long estimatedSize;
    private boolean explainPlanCalled;

    protected BaseQueryPlan(StatementContext context, FilterableStatement statement, TableRef table, RowProjector projection, ParameterMetaData paramMetaData, Integer limit, Integer offset, OrderByCompiler.OrderBy orderBy, GroupByCompiler.GroupBy groupBy, ParallelIteratorFactory parallelIteratorFactory, Expression dynamicFilter) {
        this.context = context;
        this.statement = statement;
        this.tableRef = table;
        this.tableRefs = ImmutableSet.of((Object)table);
        this.projection = projection;
        this.paramMetaData = paramMetaData;
        this.limit = limit;
        this.offset = offset;
        this.orderBy = orderBy;
        this.groupBy = groupBy;
        this.parallelIteratorFactory = parallelIteratorFactory;
        this.dynamicFilter = dynamicFilter;
    }

    @Override
    public PhoenixStatement.Operation getOperation() {
        return PhoenixStatement.Operation.QUERY;
    }

    @Override
    public boolean isDegenerate() {
        return this.context.getScanRanges() == ScanRanges.NOTHING;
    }

    @Override
    public GroupByCompiler.GroupBy getGroupBy() {
        return this.groupBy;
    }

    @Override
    public OrderByCompiler.OrderBy getOrderBy() {
        return this.orderBy;
    }

    @Override
    public TableRef getTableRef() {
        return this.tableRef;
    }

    @Override
    public Set<TableRef> getSourceRefs() {
        return this.tableRefs;
    }

    @Override
    public Integer getLimit() {
        return this.limit;
    }

    @Override
    public Integer getOffset() {
        return this.offset;
    }

    @Override
    public RowProjector getProjector() {
        return this.projection;
    }

    public Expression getDynamicFilter() {
        return this.dynamicFilter;
    }

    @Override
    public final ResultIterator iterator() throws SQLException {
        return this.iterator(Collections.emptyList(), DefaultParallelScanGrouper.getInstance(), null);
    }

    @Override
    public final ResultIterator iterator(ParallelScanGrouper scanGrouper) throws SQLException {
        return this.iterator(Collections.emptyList(), scanGrouper, null);
    }

    @Override
    public final ResultIterator iterator(ParallelScanGrouper scanGrouper, Scan scan) throws SQLException {
        return this.iterator(Collections.emptyList(), scanGrouper, scan);
    }

    public final ResultIterator iterator(final List<? extends SQLCloseable> dependencies, ParallelScanGrouper scanGrouper, Scan scan) throws SQLException {
        TraceScope scope;
        if (scan == null) {
            scan = this.context.getScan();
        }
        if (this.context.getScanRanges() == ScanRanges.NOTHING && !this.getStatement().isAggregate()) {
            return ResultIterator.EMPTY_ITERATOR;
        }
        if (this.tableRef == TableRef.EMPTY_TABLE_REF) {
            return this.newIterator(scanGrouper, scan);
        }
        TableRef tableRef = this.context.getCurrentTable();
        PTable table = tableRef.getTable();
        if (this.dynamicFilter != null) {
            WhereCompiler.compile(this.context, this.statement, null, Collections.singletonList(this.dynamicFilter), false, null);
        }
        if (OrderByCompiler.OrderBy.REV_ROW_KEY_ORDER_BY.equals(this.orderBy)) {
            ScanUtil.setReversed(scan);
            int scannerCacheSize = this.context.getStatement().getFetchSize();
            if (this.limit != null && this.limit % scannerCacheSize == 0) {
                scan.setCaching(scannerCacheSize + 1);
            }
        }
        if (this.statement.getHint().hasHint(HintNode.Hint.SMALL)) {
            scan.setSmall(true);
        }
        PhoenixConnection connection = this.context.getConnection();
        if (table.getType() != PTableType.SYSTEM) {
            scan.setConsistency(connection.getConsistency());
        }
        if (!table.isTransactional()) {
            TimeRange rowTimestampRange = this.context.getScanRanges().getRowTimestampRange();
            TimeRange scanTimeRange = scan.getTimeRange();
            Long scn = connection.getSCN();
            if (scn == null && (scn = Long.valueOf(tableRef.getTimeStamp())) == -1L) {
                scn = Long.MAX_VALUE;
            }
            try {
                TimeRange timeRangeToUse = ScanUtil.intersectTimeRange(rowTimestampRange, scanTimeRange, scn);
                if (timeRangeToUse == null) {
                    return ResultIterator.EMPTY_ITERATOR;
                }
                scan.setTimeRange(timeRangeToUse.getMin(), timeRangeToUse.getMax());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        byte[] tenantIdBytes = table.isMultiTenant() ? (connection.getTenantId() == null ? null : ScanUtil.getTenantIdBytes(table.getRowKeySchema(), table.getBucketNum() != null, connection.getTenantId(), table.getViewIndexId() != null)) : (connection.getTenantId() == null ? null : connection.getTenantId().getBytes());
        ScanUtil.setTenantId(scan, tenantIdBytes);
        String customAnnotations = LogUtil.customAnnotationsToString(connection);
        ScanUtil.setCustomAnnotations(scan, customAnnotations == null ? null : customAnnotations.getBytes());
        if (table.getIndexType() == PTable.IndexType.LOCAL) {
            ScanUtil.setLocalIndex(scan);
            Set<PColumn> dataColumns = this.context.getDataColumns();
            if (!dataColumns.isEmpty()) {
                PTable parentTable = this.context.getCurrentTable().getTable();
                String parentSchemaName = parentTable.getParentSchemaName().getString();
                String parentTableName = parentTable.getParentTableName().getString();
                ParseNodeFactory FACTORY = new ParseNodeFactory();
                TableRef dataTableRef = FromCompiler.getResolver(FACTORY.namedTable(null, TableName.create(parentSchemaName, parentTableName)), this.context.getConnection()).resolveTable(parentSchemaName, parentTableName);
                PTable dataTable = dataTableRef.getTable();
                this.serializeDataTableColumnsToJoin(scan, dataColumns, dataTable);
                KeyValueSchema schema = ProjectedColumnExpression.buildSchema(dataColumns);
                this.serializeSchemaIntoScan(scan, schema);
                this.serializeIndexMaintainerIntoScan(scan, dataTable);
                this.serializeViewConstantsIntoScan(scan, dataTable);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)LogUtil.addCustomAnnotations("Scan ready for iteration: " + scan, connection));
        }
        ResultIterator iterator = this.newIterator(scanGrouper, scan);
        ResultIterator resultIterator = iterator = dependencies.isEmpty() ? iterator : new DelegateResultIterator(iterator){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws SQLException {
                try {
                    super.close();
                }
                finally {
                    SQLCloseables.closeAll(dependencies);
                }
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)LogUtil.addCustomAnnotations("Iterator ready: " + iterator, connection));
        }
        return (scope = Tracing.startNewSpan(this.context.getConnection(), "Creating basic query for " + this.getPlanSteps(iterator))).getSpan() != null ? new TracingIterator(scope, iterator) : iterator;
    }

    private void serializeIndexMaintainerIntoScan(Scan scan, PTable dataTable) throws SQLException {
        PName name = this.context.getCurrentTable().getTable().getName();
        ArrayList indexes = Lists.newArrayListWithExpectedSize((int)1);
        for (PTable index : dataTable.getIndexes()) {
            if (!index.getName().equals(name) || index.getIndexType() != PTable.IndexType.LOCAL) continue;
            indexes.add(index);
            break;
        }
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        IndexMaintainer.serialize(dataTable, ptr, indexes, this.context.getConnection());
        scan.setAttribute("_LocalIndexBuild", ByteUtil.copyKeyBytesIfNecessary(ptr));
        if (dataTable.isTransactional()) {
            scan.setAttribute("_TxState", this.context.getConnection().getMutationState().encodeTransaction());
        }
    }

    private void serializeViewConstantsIntoScan(Scan scan, PTable dataTable) {
        int dataPosOffset = (dataTable.getBucketNum() != null ? 1 : 0) + (dataTable.isMultiTenant() ? 1 : 0);
        int nViewConstants = 0;
        if (dataTable.getType() == PTableType.VIEW) {
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            List<PColumn> dataPkColumns = dataTable.getPKColumns();
            for (int i = dataPosOffset; i < dataPkColumns.size(); ++i) {
                PColumn dataPKColumn = dataPkColumns.get(i);
                if (dataPKColumn.getViewConstant() == null) continue;
                ++nViewConstants;
            }
            if (nViewConstants > 0) {
                byte[][] viewConstants = new byte[nViewConstants][];
                int j = 0;
                for (int i = dataPosOffset; i < dataPkColumns.size(); ++i) {
                    PColumn dataPkColumn = dataPkColumns.get(i);
                    if (dataPkColumn.getViewConstant() == null) continue;
                    if (IndexUtil.getViewConstantValue(dataPkColumn, ptr)) {
                        viewConstants[j++] = ByteUtil.copyKeyBytesIfNecessary(ptr);
                        continue;
                    }
                    throw new IllegalStateException();
                }
                this.serializeViewConstantsIntoScan(viewConstants, scan);
            }
        }
    }

    private void serializeViewConstantsIntoScan(byte[][] viewConstants, Scan scan) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            DataOutputStream output = new DataOutputStream(stream);
            WritableUtils.writeVInt((DataOutput)output, (int)viewConstants.length);
            for (byte[] viewConstant : viewConstants) {
                Bytes.writeByteArray((DataOutput)output, (byte[])viewConstant);
            }
            scan.setAttribute("_ViewConstants", stream.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void serializeDataTableColumnsToJoin(Scan scan, Set<PColumn> dataColumns, PTable dataTable) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            boolean storeColsInSingleCell;
            DataOutputStream output = new DataOutputStream(stream);
            boolean bl = storeColsInSingleCell = dataTable.getImmutableStorageScheme() == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS;
            if (storeColsInSingleCell) {
                scan.setAttribute("_ColumnsStoredInSingleCell", QueryConstants.EMPTY_COLUMN_VALUE_BYTES);
            }
            WritableUtils.writeVInt((DataOutput)output, (int)dataColumns.size());
            for (PColumn column : dataColumns) {
                byte[] cf = column.getFamilyName().getBytes();
                byte[] cq = column.getColumnQualifierBytes();
                Bytes.writeByteArray((DataOutput)output, (byte[])cf);
                Bytes.writeByteArray((DataOutput)output, (byte[])cq);
            }
            scan.setAttribute("_DataTableColumnsToJoin", stream.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void serializeSchemaIntoScan(Scan scan, KeyValueSchema schema) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(schema.getEstimatedByteSize());
        try {
            DataOutputStream output = new DataOutputStream(stream);
            schema.write(output);
            scan.setAttribute("_LocalIndexJoinSchema", stream.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected abstract ResultIterator newIterator(ParallelScanGrouper var1, Scan var2) throws SQLException;

    @Override
    public long getEstimatedSize() {
        return 10240L;
    }

    @Override
    public ParameterMetaData getParameterMetaData() {
        return this.paramMetaData;
    }

    @Override
    public FilterableStatement getStatement() {
        return this.statement;
    }

    @Override
    public StatementContext getContext() {
        return this.context;
    }

    @Override
    public ExplainPlan getExplainPlan() throws SQLException {
        this.explainPlanCalled = true;
        if (this.context.getScanRanges() == ScanRanges.NOTHING) {
            return new ExplainPlan(Collections.singletonList("DEGENERATE SCAN OVER " + this.getTableRef().getTable().getName().getString()));
        }
        QueryPlan plan = this.context.getConnection().getQueryServices().getOptimizer().optimize(this.context.getStatement(), this);
        ExplainPlan exp = plan instanceof BaseQueryPlan ? new ExplainPlan(this.getPlanSteps(plan.iterator())) : plan.getExplainPlan();
        return exp;
    }

    private List<String> getPlanSteps(ResultIterator iterator) {
        ArrayList planSteps = Lists.newArrayListWithExpectedSize((int)5);
        iterator.explain(planSteps);
        return planSteps;
    }

    @Override
    public boolean isRowKeyOrdered() {
        return this.groupBy.isEmpty() ? this.orderBy.getOrderByExpressions().isEmpty() : this.groupBy.isOrderPreserving();
    }

    @Override
    public Long getEstimatedRowsToScan() throws SQLException {
        if (!this.explainPlanCalled) {
            this.getExplainPlan();
        }
        return this.estimatedRows;
    }

    @Override
    public Long getEstimatedBytesToScan() throws SQLException {
        if (!this.explainPlanCalled) {
            this.getExplainPlan();
        }
        return this.estimatedSize;
    }
}

