/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.htrace.Span;
import org.apache.htrace.TraceScope;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.CommitException;
import org.apache.phoenix.execute.DelegateHTable;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.index.IndexMetaDataCacheClient;
import org.apache.phoenix.index.PhoenixIndexBuilder;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.monitoring.MutationMetricQueue;
import org.apache.phoenix.monitoring.ReadMetricQueue;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PMetaData;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PRow;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableRef;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.ValueSchema;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.KeyValueUtil;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.SQLCloseable;
import org.apache.phoenix.util.SQLCloseables;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.ServerUtil;
import org.apache.phoenix.util.TransactionUtil;
import org.apache.tephra.Transaction;
import org.apache.tephra.TransactionAware;
import org.apache.tephra.TransactionCodec;
import org.apache.tephra.TransactionConflictException;
import org.apache.tephra.TransactionContext;
import org.apache.tephra.TransactionFailureException;
import org.apache.tephra.TransactionSystemClient;
import org.apache.tephra.hbase.TransactionAwareHTable;
import org.apache.tephra.visibility.FenceWait;
import org.apache.tephra.visibility.VisibilityFence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutationState
implements SQLCloseable {
    private static final Logger logger = LoggerFactory.getLogger(MutationState.class);
    private static final TransactionCodec CODEC = new TransactionCodec();
    private static final int[] EMPTY_STATEMENT_INDEX_ARRAY = new int[0];
    private static final int MAX_COMMIT_RETRIES = 3;
    private final PhoenixConnection connection;
    private final long maxSize;
    private final long maxSizeBytes;
    private final long batchSize;
    private final long batchSizeBytes;
    private long batchCount = 0L;
    private final Map<TableRef, Map<ImmutableBytesPtr, RowMutationState>> mutations;
    private final List<TransactionAware> txAwares;
    private final TransactionContext txContext;
    private final Set<String> uncommittedPhysicalNames = Sets.newHashSetWithExpectedSize((int)10);
    private Transaction tx;
    private long sizeOffset;
    private int numRows = 0;
    private int[] uncommittedStatementIndexes = EMPTY_STATEMENT_INDEX_ARRAY;
    private boolean isExternalTxContext = false;
    private Map<TableRef, Map<ImmutableBytesPtr, RowMutationState>> txMutations = Collections.emptyMap();
    private final MutationMetricQueue mutationMetricQueue;
    private ReadMetricQueue readMetricQueue;

    public MutationState(long maxSize, long maxSizeBytes, PhoenixConnection connection) {
        this(maxSize, maxSizeBytes, connection, null, null);
    }

    public MutationState(long maxSize, long maxSizeBytes, PhoenixConnection connection, TransactionContext txContext) {
        this(maxSize, maxSizeBytes, connection, null, txContext);
    }

    public MutationState(MutationState mutationState) {
        this(mutationState.maxSize, mutationState.maxSizeBytes, mutationState.connection, mutationState.getTransaction(), null);
    }

    public MutationState(long maxSize, long maxSizeBytes, PhoenixConnection connection, long sizeOffset) {
        this(maxSize, maxSizeBytes, connection, null, null, sizeOffset);
    }

    private MutationState(long maxSize, long maxSizeBytes, PhoenixConnection connection, Transaction tx, TransactionContext txContext) {
        this(maxSize, maxSizeBytes, connection, tx, txContext, 0L);
    }

    private MutationState(long maxSize, long maxSizeBytes, PhoenixConnection connection, Transaction tx, TransactionContext txContext, long sizeOffset) {
        this(maxSize, maxSizeBytes, connection, Maps.newHashMapWithExpectedSize((int)5), tx, txContext);
        this.sizeOffset = sizeOffset;
    }

    MutationState(long maxSize, long maxSizeBytes, PhoenixConnection connection, Map<TableRef, Map<ImmutableBytesPtr, RowMutationState>> mutations, Transaction tx, TransactionContext txContext) {
        this.maxSize = maxSize;
        this.maxSizeBytes = maxSizeBytes;
        this.connection = connection;
        this.batchSize = connection.getMutateBatchSize();
        this.batchSizeBytes = connection.getMutateBatchSizeBytes();
        this.mutations = mutations;
        boolean isMetricsEnabled = connection.isRequestLevelMetricsEnabled();
        this.mutationMetricQueue = isMetricsEnabled ? new MutationMetricQueue() : MutationMetricQueue.NoOpMutationMetricsQueue.NO_OP_MUTATION_METRICS_QUEUE;
        this.tx = tx;
        if (tx == null) {
            this.txAwares = Collections.emptyList();
            if (txContext == null) {
                TransactionSystemClient txServiceClient = this.connection.getQueryServices().getTransactionSystemClient();
                this.txContext = new TransactionContext(txServiceClient, new TransactionAware[0]);
            } else {
                this.isExternalTxContext = true;
                this.txContext = txContext;
            }
        } else {
            this.txAwares = Lists.newArrayList();
            this.txContext = null;
        }
    }

    public MutationState(TableRef table, Map<ImmutableBytesPtr, RowMutationState> mutations, long sizeOffset, long maxSize, long maxSizeBytes, PhoenixConnection connection) throws SQLException {
        this(maxSize, maxSizeBytes, connection, null, null, sizeOffset);
        this.mutations.put(table, mutations);
        this.numRows = mutations.size();
        this.tx = connection.getMutationState().getTransaction();
        this.throwIfTooBig();
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public long getMaxSizeBytes() {
        return this.maxSizeBytes;
    }

    public void commitDDLFence(PTable dataTable) throws SQLException {
        if (dataTable.isTransactional()) {
            byte[] key = dataTable.getName().getBytes();
            boolean success = false;
            try {
                FenceWait fenceWait = VisibilityFence.prepareWait((byte[])key, (TransactionSystemClient)this.connection.getQueryServices().getTransactionSystemClient());
                fenceWait.await(10000L, TimeUnit.MILLISECONDS);
                success = true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
            }
            catch (TimeoutException | TransactionFailureException e) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.TX_UNABLE_TO_GET_WRITE_FENCE).setSchemaName(dataTable.getSchemaName().getString()).setTableName(dataTable.getTableName().getString()).build().buildException();
            }
            finally {
                try {
                    this.txContext.start();
                    if (logger.isInfoEnabled() && success) {
                        logger.info("Added write fence at ~" + this.getTransaction().getReadPointer());
                    }
                }
                catch (TransactionFailureException e) {
                    throw TransactionUtil.getTransactionFailureException(e);
                }
            }
        }
    }

    private void addDMLFence(PTable table) throws SQLException {
        if (table.getType() == PTableType.INDEX || !table.isTransactional()) {
            return;
        }
        byte[] logicalKey = table.getName().getBytes();
        TransactionAware logicalTxAware = VisibilityFence.create((byte[])logicalKey);
        if (this.txContext == null) {
            this.txAwares.add(logicalTxAware);
        } else {
            this.txContext.addTransactionAware(logicalTxAware);
        }
        byte[] physicalKey = table.getPhysicalName().getBytes();
        if (Bytes.compareTo((byte[])physicalKey, (byte[])logicalKey) != 0) {
            TransactionAware physicalTxAware = VisibilityFence.create((byte[])physicalKey);
            if (this.txContext == null) {
                this.txAwares.add(physicalTxAware);
            } else {
                this.txContext.addTransactionAware(physicalTxAware);
            }
        }
    }

    public boolean checkpointIfNeccessary(MutationPlan plan) throws SQLException {
        Transaction currentTx = this.getTransaction();
        if (this.getTransaction() == null || plan.getTargetRef() == null || plan.getTargetRef().getTable() == null || !plan.getTargetRef().getTable().isTransactional()) {
            return false;
        }
        Set<TableRef> sources = plan.getSourceRefs();
        if (sources.isEmpty()) {
            return false;
        }
        TableRef ignoreForExcludeCurrent = plan.getOperation() == PhoenixStatement.Operation.DELETE && sources.size() == 1 ? plan.getTargetRef() : null;
        boolean excludeCurrent = false;
        String targetPhysicalName = plan.getTargetRef().getTable().getPhysicalName().getString();
        for (TableRef source : sources) {
            String sourcePhysicalName;
            if (!source.getTable().isTransactional() || source.equals(ignoreForExcludeCurrent) || !targetPhysicalName.equals(sourcePhysicalName = source.getTable().getPhysicalName().getString())) continue;
            excludeCurrent = true;
            break;
        }
        if (excludeCurrent) {
            boolean hasUncommittedData = false;
            for (TableRef source : sources) {
                String sourcePhysicalName = source.getTable().getPhysicalName().getString();
                if (!source.getTable().isTransactional() || !this.isExternalTxContext && !this.uncommittedPhysicalNames.contains(sourcePhysicalName)) continue;
                hasUncommittedData = true;
                break;
            }
            if (hasUncommittedData) {
                try {
                    if (this.txContext == null) {
                        currentTx = this.tx = this.connection.getQueryServices().getTransactionSystemClient().checkpoint(currentTx);
                    } else {
                        this.txContext.checkpoint();
                        currentTx = this.tx = this.txContext.getCurrentTransaction();
                    }
                    this.uncommittedPhysicalNames.clear();
                }
                catch (TransactionFailureException e) {
                    throw new SQLException(e);
                }
            }
            currentTx.setVisibility(Transaction.VisibilityLevel.SNAPSHOT_EXCLUDE_CURRENT);
            return true;
        }
        return false;
    }

    private void addTransactionParticipant(TransactionAware txAware) throws SQLException {
        if (this.txContext == null) {
            this.txAwares.add(txAware);
            assert (this.tx != null);
            txAware.startTx(this.tx);
        } else {
            this.txContext.addTransactionAware(txAware);
        }
    }

    public HTableInterface getHTable(PTable table) throws SQLException {
        Transaction currentTx;
        HTableInterface htable = this.getConnection().getQueryServices().getTable(table.getPhysicalName().getBytes());
        if (table.isTransactional() && (currentTx = this.getTransaction()) != null) {
            TransactionAwareHTable txAware = TransactionUtil.getTransactionAwareHTable(htable, table.isImmutableRows());
            txAware.startTx(currentTx);
            htable = txAware;
        }
        return htable;
    }

    public PhoenixConnection getConnection() {
        return this.connection;
    }

    private Transaction getTransaction() {
        return this.tx != null ? this.tx : (this.txContext != null ? this.txContext.getCurrentTransaction() : null);
    }

    public boolean isTransactionStarted() {
        return this.getTransaction() != null;
    }

    public long getInitialWritePointer() {
        Transaction tx = this.getTransaction();
        return tx == null ? Long.MAX_VALUE : tx.getTransactionId();
    }

    public long getWritePointer() {
        Transaction tx = this.getTransaction();
        return tx == null ? Long.MAX_VALUE : tx.getWritePointer();
    }

    public Transaction.VisibilityLevel getVisibilityLevel() {
        Transaction tx = this.getTransaction();
        return tx == null ? null : tx.getVisibilityLevel();
    }

    public boolean startTransaction() throws SQLException {
        if (this.txContext == null) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.NULL_TRANSACTION_CONTEXT).build().buildException();
        }
        if (this.connection.getSCN() != null) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_START_TRANSACTION_WITH_SCN_SET).build().buildException();
        }
        try {
            if (!this.isTransactionStarted()) {
                this.resetTransactionalState();
                this.txContext.start();
                return true;
            }
        }
        catch (TransactionFailureException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TRANSACTION_FAILED).setRootCause(e).build().buildException();
        }
        return false;
    }

    public static MutationState emptyMutationState(long maxSize, long maxSizeBytes, PhoenixConnection connection) {
        MutationState state2 = new MutationState(maxSize, maxSizeBytes, connection, Collections.emptyMap(), null, null);
        state2.sizeOffset = 0L;
        return state2;
    }

    private void throwIfTooBig() throws SQLException {
        if ((long)this.numRows > this.maxSize) {
            this.resetState();
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.MAX_MUTATION_SIZE_EXCEEDED).build().buildException();
        }
        long estimatedSize = KeyValueUtil.getEstimatedRowSize(this.mutations);
        if (estimatedSize > this.maxSizeBytes) {
            this.resetState();
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.MAX_MUTATION_SIZE_BYTES_EXCEEDED).build().buildException();
        }
    }

    public long getUpdateCount() {
        return this.sizeOffset + (long)this.numRows;
    }

    private void joinMutationState(TableRef tableRef, Map<ImmutableBytesPtr, RowMutationState> srcRows, Map<TableRef, Map<ImmutableBytesPtr, RowMutationState>> dstMutations) {
        PTable table = tableRef.getTable();
        boolean isIndex = table.getType() == PTableType.INDEX;
        boolean incrementRowCount = dstMutations == this.mutations;
        Map<ImmutableBytesPtr, RowMutationState> existingRows = dstMutations.put(tableRef, srcRows);
        if (existingRows != null) {
            for (Map.Entry<ImmutableBytesPtr, RowMutationState> rowEntry : srcRows.entrySet()) {
                RowMutationState existingRowMutationState = existingRows.put(rowEntry.getKey(), rowEntry.getValue());
                if (existingRowMutationState != null) {
                    Map<PColumn, byte[]> newRow;
                    Map<PColumn, byte[]> existingValues = existingRowMutationState.getColumnValues();
                    if (existingValues == PRow.DELETE_MARKER || (newRow = rowEntry.getValue().getColumnValues()) == PRow.DELETE_MARKER) continue;
                    existingRowMutationState.join(rowEntry.getValue());
                    existingRows.put(rowEntry.getKey(), existingRowMutationState);
                    continue;
                }
                if (!incrementRowCount || isIndex) continue;
                ++this.numRows;
            }
            dstMutations.put(tableRef, existingRows);
        } else {
            HashMap newRows = Maps.newHashMapWithExpectedSize((int)this.connection.getMutateBatchSize());
            newRows.putAll(srcRows);
            dstMutations.put(tableRef, newRows);
            if (incrementRowCount && !isIndex) {
                this.numRows += srcRows.size();
            }
        }
    }

    private void joinMutationState(Map<TableRef, Map<ImmutableBytesPtr, RowMutationState>> srcMutations, Map<TableRef, Map<ImmutableBytesPtr, RowMutationState>> dstMutations) {
        for (Map.Entry<TableRef, Map<ImmutableBytesPtr, RowMutationState>> entry : srcMutations.entrySet()) {
            TableRef tableRef = entry.getKey();
            Map<ImmutableBytesPtr, RowMutationState> srcRows = entry.getValue();
            this.joinMutationState(tableRef, srcRows, dstMutations);
        }
    }

    public void join(MutationState newMutationState) throws SQLException {
        if (this == newMutationState) {
            return;
        }
        if (this.txContext != null) {
            for (TransactionAware txAware : newMutationState.txAwares) {
                this.txContext.addTransactionAware(txAware);
            }
        } else {
            this.txAwares.addAll(newMutationState.txAwares);
        }
        this.sizeOffset += newMutationState.sizeOffset;
        this.joinMutationState(newMutationState.mutations, this.mutations);
        if (!newMutationState.txMutations.isEmpty()) {
            if (this.txMutations.isEmpty()) {
                this.txMutations = Maps.newHashMapWithExpectedSize((int)this.mutations.size());
            }
            this.joinMutationState(newMutationState.txMutations, this.txMutations);
        }
        this.mutationMetricQueue.combineMetricQueues(newMutationState.mutationMetricQueue);
        if (this.readMetricQueue == null) {
            this.readMetricQueue = newMutationState.readMetricQueue;
        } else if (this.readMetricQueue != null && newMutationState.readMetricQueue != null) {
            this.readMetricQueue.combineReadMetrics(newMutationState.readMetricQueue);
        }
        this.throwIfTooBig();
    }

    private static ImmutableBytesPtr getNewRowKeyWithRowTimestamp(ImmutableBytesPtr ptr, long rowTimestamp, PTable table) {
        RowKeySchema schema = table.getRowKeySchema();
        int rowTimestampColPos = table.getRowTimestampColPos();
        ValueSchema.Field rowTimestampField = schema.getField(rowTimestampColPos);
        byte[] rowTimestampBytes = PLong.INSTANCE.toBytes(rowTimestamp, rowTimestampField.getSortOrder());
        int oldOffset = ptr.getOffset();
        int oldLength = ptr.getLength();
        schema.position(ptr, 0, rowTimestampColPos);
        byte[] b = ptr.get();
        int newOffset = ptr.getOffset();
        int length = ptr.getLength();
        for (int i = newOffset; i < newOffset + length; ++i) {
            b[i] = rowTimestampBytes[i - newOffset];
        }
        ptr.set(ptr.get(), oldOffset, oldLength);
        return ptr;
    }

    private Iterator<Pair<PName, List<Mutation>>> addRowMutations(TableRef tableRef, Map<ImmutableBytesPtr, RowMutationState> values, long timestamp, boolean includeAllIndexes, boolean sendAll) {
        PTable table = tableRef.getTable();
        UnmodifiableIterator indexes = includeAllIndexes || table.isWALDisabled() ? IndexMaintainer.nonDisabledIndexIterator(table.getIndexes().iterator()) : (table.isImmutableRows() ? IndexMaintainer.enabledGlobalIndexIterator(table.getIndexes().iterator()) : Iterators.emptyIterator());
        ArrayList mutationList = Lists.newArrayListWithExpectedSize((int)values.size());
        ArrayList mutationsPertainingToIndex = indexes.hasNext() ? Lists.newArrayListWithExpectedSize((int)values.size()) : null;
        this.generateMutations(tableRef, timestamp, values, mutationList, mutationsPertainingToIndex);
        return new Iterator<Pair<PName, List<Mutation>>>((Iterator)indexes, table, (List)mutationList, values, (List)mutationsPertainingToIndex, sendAll, tableRef, timestamp){
            boolean isFirst = true;
            final /* synthetic */ Iterator val$indexes;
            final /* synthetic */ PTable val$table;
            final /* synthetic */ List val$mutationList;
            final /* synthetic */ Map val$values;
            final /* synthetic */ List val$mutationsPertainingToIndex;
            final /* synthetic */ boolean val$sendAll;
            final /* synthetic */ TableRef val$tableRef;
            final /* synthetic */ long val$timestamp;
            {
                this.val$indexes = iterator;
                this.val$table = pTable;
                this.val$mutationList = list;
                this.val$values = map;
                this.val$mutationsPertainingToIndex = list2;
                this.val$sendAll = bl;
                this.val$tableRef = tableRef;
                this.val$timestamp = l;
            }

            @Override
            public boolean hasNext() {
                return this.isFirst || this.val$indexes.hasNext();
            }

            @Override
            public Pair<PName, List<Mutation>> next() {
                List<Mutation> indexMutations;
                if (this.isFirst) {
                    this.isFirst = false;
                    return new Pair((Object)this.val$table.getPhysicalName(), (Object)this.val$mutationList);
                }
                PTable index = (PTable)this.val$indexes.next();
                try {
                    indexMutations = IndexUtil.generateIndexData(this.val$table, index, this.val$values, this.val$mutationsPertainingToIndex, MutationState.this.connection.getKeyValueBuilder(), MutationState.this.connection);
                    if (!this.val$sendAll) {
                        TableRef key = new TableRef(index);
                        Map rowToColumnMap = (Map)MutationState.this.mutations.remove(key);
                        if (rowToColumnMap != null) {
                            ArrayList deleteMutations = Lists.newArrayList();
                            MutationState.this.generateMutations(this.val$tableRef, this.val$timestamp, rowToColumnMap, deleteMutations, null);
                            indexMutations.addAll(deleteMutations);
                        }
                    }
                }
                catch (SQLException e) {
                    throw new IllegalDataException(e);
                }
                return new Pair((Object)index.getPhysicalName(), indexMutations);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void generateMutations(TableRef tableRef, long timestamp, Map<ImmutableBytesPtr, RowMutationState> values, List<Mutation> mutationList, List<Mutation> mutationsPertainingToIndex) {
        PTable table = tableRef.getTable();
        boolean tableWithRowTimestampCol = table.getRowTimestampColPos() != -1;
        Iterator<Map.Entry<ImmutableBytesPtr, RowMutationState>> iterator = values.entrySet().iterator();
        long timestampToUse = timestamp;
        HashMap modifiedValues = Maps.newHashMap();
        while (iterator.hasNext()) {
            List<Object> rowMutationsPertainingToIndex;
            List<Mutation> rowMutations;
            Map.Entry<ImmutableBytesPtr, RowMutationState> rowEntry = iterator.next();
            byte[] onDupKeyBytes = rowEntry.getValue().getOnDupKeyBytes();
            boolean hasOnDupKey = onDupKeyBytes != null;
            ImmutableBytesPtr key = rowEntry.getKey();
            RowMutationState state2 = rowEntry.getValue();
            if (tableWithRowTimestampCol) {
                RowTimestampColInfo rowTsColInfo = state2.getRowTimestampColInfo();
                if (rowTsColInfo.useServerTimestamp()) {
                    modifiedValues.put(key, state2);
                    iterator.remove();
                    key = MutationState.getNewRowKeyWithRowTimestamp(key, timestampToUse, table);
                } else if (rowTsColInfo.getTimestamp() != null) {
                    timestampToUse = rowTsColInfo.getTimestamp();
                }
            }
            PRow row = tableRef.getTable().newRow(this.connection.getKeyValueBuilder(), timestampToUse, key, hasOnDupKey, (byte[][])new byte[0][]);
            if (rowEntry.getValue().getColumnValues() == PRow.DELETE_MARKER) {
                row.delete();
                rowMutations = row.toRowMutations();
                rowMutationsPertainingToIndex = Collections.emptyList();
            } else {
                for (Map.Entry<PColumn, byte[]> valueEntry : rowEntry.getValue().getColumnValues().entrySet()) {
                    row.setValue(valueEntry.getKey(), valueEntry.getValue());
                }
                rowMutations = row.toRowMutations();
                for (Mutation mutation : rowMutations) {
                    if (onDupKeyBytes == null) continue;
                    mutation.setAttribute("_ATOMIC_OP_ATTRIB", onDupKeyBytes);
                }
                rowMutationsPertainingToIndex = rowMutations;
            }
            mutationList.addAll(rowMutations);
            if (this.connection.isReplayMutations()) {
                for (Mutation mutation : rowMutations) {
                    mutation.setAttribute("_IGNORE_NEWER_MUTATIONS", PDataType.TRUE_BYTES);
                }
            }
            if (mutationsPertainingToIndex == null) continue;
            mutationsPertainingToIndex.addAll(rowMutationsPertainingToIndex);
        }
        values.putAll(modifiedValues);
    }

    public Iterator<Pair<byte[], List<Mutation>>> toMutations(Long timestamp) {
        return this.toMutations(false, timestamp);
    }

    public Iterator<Pair<byte[], List<Mutation>>> toMutations() {
        return this.toMutations(false, null);
    }

    public Iterator<Pair<byte[], List<Mutation>>> toMutations(boolean includeMutableIndexes) {
        return this.toMutations(includeMutableIndexes, null);
    }

    public Iterator<Pair<byte[], List<Mutation>>> toMutations(final boolean includeMutableIndexes, Long tableTimestamp) {
        final Iterator<Map.Entry<TableRef, Map<ImmutableBytesPtr, RowMutationState>>> iterator = this.mutations.entrySet().iterator();
        if (!iterator.hasNext()) {
            return Iterators.emptyIterator();
        }
        Long scn = this.connection.getSCN();
        final long timestamp = MutationState.getMutationTimestamp(tableTimestamp, scn);
        return new Iterator<Pair<byte[], List<Mutation>>>(){
            private Map.Entry<TableRef, Map<ImmutableBytesPtr, RowMutationState>> current;
            private Iterator<Pair<byte[], List<Mutation>>> innerIterator;
            {
                this.current = (Map.Entry)iterator.next();
                this.innerIterator = this.init();
            }

            private Iterator<Pair<byte[], List<Mutation>>> init() {
                final Iterator mutationIterator = MutationState.this.addRowMutations(this.current.getKey(), this.current.getValue(), timestamp, includeMutableIndexes, true);
                return new Iterator<Pair<byte[], List<Mutation>>>(){

                    @Override
                    public boolean hasNext() {
                        return mutationIterator.hasNext();
                    }

                    @Override
                    public Pair<byte[], List<Mutation>> next() {
                        Pair pair = (Pair)mutationIterator.next();
                        return new Pair((Object)((PName)pair.getFirst()).getBytes(), pair.getSecond());
                    }

                    @Override
                    public void remove() {
                        mutationIterator.remove();
                    }
                };
            }

            @Override
            public boolean hasNext() {
                return this.innerIterator.hasNext() || iterator.hasNext();
            }

            @Override
            public Pair<byte[], List<Mutation>> next() {
                if (!this.innerIterator.hasNext()) {
                    this.current = (Map.Entry)iterator.next();
                    this.innerIterator = this.init();
                }
                return this.innerIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static long getMutationTimestamp(Long tableTimestamp, Long scn) {
        return tableTimestamp != null && tableTimestamp != -1L ? tableTimestamp : (scn == null ? Long.MAX_VALUE : scn);
    }

    private long[] validateAll() throws SQLException {
        int i = 0;
        long[] timeStamps = new long[this.mutations.size()];
        for (Map.Entry<TableRef, Map<ImmutableBytesPtr, RowMutationState>> entry : this.mutations.entrySet()) {
            TableRef tableRef = entry.getKey();
            timeStamps[i++] = this.validate(tableRef, entry.getValue());
        }
        return timeStamps;
    }

    private long validate(TableRef tableRef, Map<ImmutableBytesPtr, RowMutationState> rowKeyToColumnMap) throws SQLException {
        Long scn = this.connection.getSCN();
        MetaDataClient client = new MetaDataClient(this.connection);
        long serverTimeStamp = tableRef.getTimeStamp();
        PTable table = tableRef.getTable();
        MetaDataProtocol.MetaDataMutationResult result = client.updateCache(table.getSchemaName().getString(), table.getTableName().getString());
        PTable resolvedTable = result.getTable();
        if (resolvedTable == null) {
            throw new TableNotFoundException(table.getSchemaName().getString(), table.getTableName().getString());
        }
        tableRef.setTable(resolvedTable);
        List<PTable> indexes = resolvedTable.getIndexes();
        for (PTable idxTtable : indexes) {
            if (idxTtable.getIndexState() != PIndexState.ACTIVE || idxTtable.getIndexDisableTimestamp() <= 0L) continue;
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INDEX_FAILURE_BLOCK_WRITE).setSchemaName(table.getSchemaName().getString()).setTableName(table.getTableName().getString()).build().buildException();
        }
        long timestamp = result.getMutationTime();
        if (timestamp != -1L) {
            serverTimeStamp = timestamp;
            if (result.wasUpdated()) {
                ArrayList columns = Lists.newArrayListWithExpectedSize((int)table.getColumns().size());
                for (Map.Entry<ImmutableBytesPtr, RowMutationState> rowEntry : rowKeyToColumnMap.entrySet()) {
                    Map<PColumn, byte[]> colValues;
                    RowMutationState valueEntry = rowEntry.getValue();
                    if (valueEntry == null || (colValues = valueEntry.getColumnValues()) == PRow.DELETE_MARKER) continue;
                    for (PColumn column : colValues.keySet()) {
                        if (column.isDynamic()) continue;
                        columns.add(column);
                    }
                }
                for (PColumn column : columns) {
                    if (column == null) continue;
                    resolvedTable.getColumnFamily(column.getFamilyName().getString()).getPColumnForColumnName(column.getName().getString());
                }
            }
        }
        return scn == null ? (serverTimeStamp == -1L ? Long.MAX_VALUE : serverTimeStamp) : scn;
    }

    private static long calculateMutationSize(List<Mutation> mutations) {
        long byteSize = 0L;
        if (GlobalClientMetrics.isMetricsEnabled()) {
            for (Mutation mutation : mutations) {
                byteSize += KeyValueUtil.calculateMutationDiskSize(mutation);
            }
        }
        GlobalClientMetrics.GLOBAL_MUTATION_BYTES.update(byteSize);
        return byteSize;
    }

    private boolean hasKeyValueColumn(PTable table, PTable index) {
        IndexMaintainer maintainer = index.getIndexMaintainer(table, this.connection);
        return !maintainer.getAllColumns().isEmpty();
    }

    private void divideImmutableIndexes(Iterator<PTable> enabledImmutableIndexes, PTable table, List<PTable> rowKeyIndexes, List<PTable> keyValueIndexes) {
        while (enabledImmutableIndexes.hasNext()) {
            PTable index = enabledImmutableIndexes.next();
            if (index.getIndexType() == PTable.IndexType.LOCAL) continue;
            if (this.hasKeyValueColumn(table, index)) {
                keyValueIndexes.add(index);
                continue;
            }
            rowKeyIndexes.add(index);
        }
    }

    public long getBatchSizeBytes() {
        return this.batchSizeBytes;
    }

    public long getBatchCount() {
        return this.batchCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(Iterator<TableRef> tableRefIterator) throws SQLException {
        int i = 0;
        long[] serverTimeStamps = null;
        boolean sendAll = false;
        if (tableRefIterator == null) {
            serverTimeStamps = this.validateAll();
            tableRefIterator = this.mutations.keySet().iterator();
            sendAll = true;
        }
        ArrayList txTableRefs = Lists.newArrayListWithExpectedSize((int)this.mutations.size());
        LinkedHashMap physicalTableMutationMap = Maps.newLinkedHashMap();
        try (TraceScope trace = Tracing.startNewSpan(this.connection, "Committing mutations to tables");){
            Span span = trace.getSpan();
            ImmutableBytesWritable indexMetaDataPtr = new ImmutableBytesWritable();
            while (tableRefIterator.hasNext()) {
                TableRef tableRef = tableRefIterator.next();
                Map<ImmutableBytesPtr, RowMutationState> valuesMap = this.mutations.get(tableRef);
                if (valuesMap == null || valuesMap.isEmpty()) continue;
                long serverTimestamp = serverTimeStamps == null ? this.validate(tableRef, valuesMap) : serverTimeStamps[i++];
                PTable table = tableRef.getTable();
                Iterator<Pair<PName, List<Mutation>>> mutationsIterator = this.addRowMutations(tableRef, valuesMap, serverTimestamp, false, sendAll);
                boolean isDataTable = true;
                while (mutationsIterator.hasNext()) {
                    List mutationList;
                    Pair<PName, List<Mutation>> pair = mutationsIterator.next();
                    PName hTableName = (PName)pair.getFirst();
                    TableInfo tableInfo = new TableInfo(isDataTable, hTableName, tableRef);
                    List oldMutationList = physicalTableMutationMap.put(tableInfo, mutationList = (List)pair.getSecond());
                    if (oldMutationList != null) {
                        mutationList.addAll(0, oldMutationList);
                    }
                    isDataTable = false;
                }
                if (!table.isTransactional()) continue;
                this.addUncommittedStatementIndexes(valuesMap.values());
                if (this.txMutations.isEmpty()) {
                    this.txMutations = Maps.newHashMapWithExpectedSize((int)this.mutations.size());
                }
                this.joinMutationState(new TableRef(tableRef), valuesMap, this.txMutations);
            }
            long serverTimestamp = Long.MAX_VALUE;
            for (Map.Entry pair : physicalTableMutationMap.entrySet()) {
                TableInfo tableInfo = (TableInfo)pair.getKey();
                byte[] htableName = tableInfo.getHTableName().getBytes();
                List mutationList = (List)pair.getValue();
                Span child = Tracing.child(span, "Writing mutation batch for table: " + Bytes.toString((byte[])htableName));
                int retryCount = 0;
                boolean shouldRetry = false;
                do {
                    TableRef origTableRef = tableInfo.getOrigTableRef();
                    PTable table = origTableRef.getTable();
                    table.getIndexMaintainers(indexMetaDataPtr, this.connection);
                    ServerCacheClient.ServerCache cache = tableInfo.isDataTable() ? this.setMetaDataOnMutations(origTableRef, mutationList, indexMetaDataPtr) : null;
                    shouldRetry = cache != null;
                    SQLException sqlE = null;
                    HTableInterface hTable = this.connection.getQueryServices().getTable(htableName);
                    try {
                        if (table.isTransactional()) {
                            txTableRefs.add(origTableRef);
                            this.addDMLFence(table);
                            this.uncommittedPhysicalNames.add(table.getPhysicalName().getString());
                            if (!table.getIndexes().isEmpty()) {
                                hTable = new MetaDataAwareHTable(hTable, origTableRef);
                            }
                            TransactionAwareHTable txnAware = TransactionUtil.getTransactionAwareHTable(hTable, table.isImmutableRows());
                            if (tableInfo.isDataTable()) {
                                this.addTransactionParticipant((TransactionAware)txnAware);
                            } else {
                                txnAware.startTx(this.getTransaction());
                            }
                            hTable = txnAware;
                        }
                        long numMutations = mutationList.size();
                        GlobalClientMetrics.GLOBAL_MUTATION_BATCH_SIZE.update(numMutations);
                        long startTime = System.currentTimeMillis();
                        child.addTimelineAnnotation("Attempt " + retryCount);
                        List<List<Mutation>> mutationBatchList = MutationState.getMutationBatchList(this.batchSize, this.batchSizeBytes, mutationList);
                        for (List<Mutation> mutationBatch : mutationBatchList) {
                            hTable.batch(mutationBatch);
                            ++this.batchCount;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("Sent batch of " + numMutations + " for " + Bytes.toString((byte[])htableName));
                        }
                        child.stop();
                        child.stop();
                        shouldRetry = false;
                        long mutationCommitTime = System.currentTimeMillis() - startTime;
                        GlobalClientMetrics.GLOBAL_MUTATION_COMMIT_TIME.update(mutationCommitTime);
                        long mutationSizeBytes = MutationState.calculateMutationSize(mutationList);
                        MutationMetricQueue.MutationMetric mutationsMetric = new MutationMetricQueue.MutationMetric(numMutations, mutationSizeBytes, mutationCommitTime);
                        this.mutationMetricQueue.addMetricsForTable(Bytes.toString((byte[])htableName), mutationsMetric);
                        if (tableInfo.isDataTable()) {
                            this.numRows = (int)((long)this.numRows - numMutations);
                        }
                        this.mutations.remove(origTableRef);
                    }
                    catch (Exception e2) {
                        SQLException e2;
                        serverTimestamp = ServerUtil.parseServerTimestamp(e2);
                        SQLException inferredE = ServerUtil.parseServerExceptionOrNull(e2);
                        if (inferredE != null) {
                            if (shouldRetry && retryCount == 0 && inferredE.getErrorCode() == SQLExceptionCode.INDEX_METADATA_NOT_FOUND.getErrorCode()) {
                                String msg = "Swallowing exception and retrying after clearing meta cache on connection. " + inferredE;
                                logger.warn(LogUtil.addCustomAnnotations(msg, this.connection));
                                this.connection.getQueryServices().clearTableRegionCache(htableName);
                                child.addTimelineAnnotation(msg);
                                child.stop();
                                child = Tracing.child(span, "Failed batch, attempting retry");
                            }
                            e2 = inferredE;
                        }
                        sqlE = new CommitException(e2, this.getUncommittedStatementIndexes(), serverTimestamp);
                    }
                    finally {
                        try {
                            if (cache != null) {
                                cache.close();
                            }
                        }
                        finally {
                            try {
                                hTable.close();
                            }
                            catch (IOException e) {
                                if (sqlE != null) {
                                    sqlE.setNextException(ServerUtil.parseServerException(e));
                                }
                                sqlE = ServerUtil.parseServerException(e);
                            }
                            if (sqlE == null) continue;
                            throw sqlE;
                        }
                    }
                } while (shouldRetry && retryCount++ < 1);
            }
        }
    }

    public static List<List<Mutation>> getMutationBatchList(long batchSize, long batchSizeBytes, List<Mutation> allMutationList) {
        ArrayList mutationBatchList = Lists.newArrayList();
        ArrayList currentList = Lists.newArrayList();
        long currentBatchSizeBytes = 0L;
        for (Mutation mutation : allMutationList) {
            long mutationSizeBytes = KeyValueUtil.calculateMutationDiskSize(mutation);
            if (((long)currentList.size() == batchSize || currentBatchSizeBytes + mutationSizeBytes > batchSizeBytes) && currentList.size() > 0) {
                mutationBatchList.add(currentList);
                currentList = Lists.newArrayList();
                currentBatchSizeBytes = 0L;
            }
            currentList.add(mutation);
            currentBatchSizeBytes += mutationSizeBytes;
        }
        if (currentList.size() > 0) {
            mutationBatchList.add(currentList);
        }
        return mutationBatchList;
    }

    public byte[] encodeTransaction() throws SQLException {
        try {
            return CODEC.encode(this.getTransaction());
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    public static Transaction decodeTransaction(byte[] txnBytes) throws IOException {
        return txnBytes == null || txnBytes.length == 0 ? null : CODEC.decode(txnBytes);
    }

    private ServerCacheClient.ServerCache setMetaDataOnMutations(TableRef tableRef, List<? extends Mutation> mutations, ImmutableBytesWritable indexMetaDataPtr) throws SQLException {
        boolean hasIndexMetaData;
        PTable table = tableRef.getTable();
        byte[] tenantIdBytes = table.isMultiTenant() ? (this.connection.getTenantId() == null ? null : ScanUtil.getTenantIdBytes(table.getRowKeySchema(), table.getBucketNum() != null, this.connection.getTenantId(), table.getViewIndexId() != null)) : (this.connection.getTenantId() == null ? null : this.connection.getTenantId().getBytes());
        ServerCacheClient.ServerCache cache = null;
        byte[] attribValue = null;
        byte[] uuidValue = null;
        byte[] txState = ByteUtil.EMPTY_BYTE_ARRAY;
        if (table.isTransactional()) {
            txState = this.encodeTransaction();
        }
        boolean bl = hasIndexMetaData = indexMetaDataPtr.getLength() > 0;
        if (hasIndexMetaData) {
            if (IndexMetaDataCacheClient.useIndexMetadataCache(this.connection, mutations, indexMetaDataPtr.getLength() + txState.length)) {
                IndexMetaDataCacheClient client = new IndexMetaDataCacheClient(this.connection, tableRef);
                cache = client.addIndexMetadataCache(mutations, indexMetaDataPtr, txState);
                uuidValue = cache.getId();
            } else {
                attribValue = ByteUtil.copyKeyBytesIfNecessary(indexMetaDataPtr);
                uuidValue = ServerCacheClient.generateId();
            }
        } else if (txState.length == 0) {
            return null;
        }
        for (Mutation mutation : mutations) {
            if (this.connection.getTenantId() != null) {
                mutation.setAttribute("TenantId", tenantIdBytes);
            }
            mutation.setAttribute("IdxUUID", uuidValue);
            if (attribValue != null) {
                mutation.setAttribute("IdxProtoMD", attribValue);
                if (txState.length <= 0) continue;
                mutation.setAttribute("_TxState", txState);
                continue;
            }
            if (hasIndexMetaData || txState.length <= 0) continue;
            mutation.setAttribute("_TxState", txState);
        }
        return cache;
    }

    private void addUncommittedStatementIndexes(Collection<RowMutationState> rowMutations) {
        for (RowMutationState rowMutationState : rowMutations) {
            this.uncommittedStatementIndexes = MutationState.joinSortedIntArrays(this.uncommittedStatementIndexes, rowMutationState.getStatementIndexes());
        }
    }

    private int[] getUncommittedStatementIndexes() {
        for (Map<ImmutableBytesPtr, RowMutationState> rowMutationMap : this.mutations.values()) {
            this.addUncommittedStatementIndexes(rowMutationMap.values());
        }
        return this.uncommittedStatementIndexes;
    }

    @Override
    public void close() throws SQLException {
    }

    private void resetState() {
        this.numRows = 0;
        this.mutations.clear();
        this.resetTransactionalState();
    }

    private void resetTransactionalState() {
        this.tx = null;
        this.txAwares.clear();
        this.txMutations = Collections.emptyMap();
        this.uncommittedPhysicalNames.clear();
        this.uncommittedStatementIndexes = EMPTY_STATEMENT_INDEX_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SQLException {
        block5: {
            try {
                if (this.txContext == null || !this.isTransactionStarted()) break block5;
                try {
                    this.txContext.abort();
                }
                catch (TransactionFailureException e) {
                    throw TransactionUtil.getTransactionFailureException(e);
                }
            }
            finally {
                this.resetState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void commit() throws SQLException {
        txMutations = Collections.emptyMap();
        retryCount = 0;
        while (true) {
            sendSuccessful = false;
            retryCommit = false;
            sqlE = null;
            this.send();
            txMutations = this.txMutations;
            sendSuccessful = true;
            try {
                if (this.txContext == null || !this.isTransactionStarted()) ** GOTO lbl312
                txFailure = null;
                finishSuccessful = false;
                if (sendSuccessful) {
                    this.txContext.finish();
                    finishSuccessful = true;
                }
                if (finishSuccessful) ** GOTO lbl312
                try {
                    this.txContext.abort(txFailure);
                    if (!MutationState.logger.isInfoEnabled()) ** GOTO lbl312
                    MutationState.logger.info("Abort successful");
                }
                catch (TransactionFailureException e) {
                    if (MutationState.logger.isInfoEnabled()) {
                        MutationState.logger.info("Abort failed with " + (Object)e);
                    }
                    nextE = TransactionUtil.getTransactionFailureException(e);
                    if (sqlE == null) {
                        sqlE = nextE;
                    }
                    sqlE.setNextException(nextE);
                }
                catch (TransactionFailureException e) {
                    try {
                        if (MutationState.logger.isInfoEnabled()) {
                            MutationState.logger.info(e.getClass().getName() + " at timestamp " + this.getInitialWritePointer() + " with retry count of " + retryCount);
                        }
                        retryCommit = e instanceof TransactionConflictException != false && retryCount < 3;
                        txFailure = e;
                        nextE = TransactionUtil.getTransactionFailureException(e);
                        if (sqlE == null) {
                            sqlE = nextE;
                        } else {
                            sqlE.setNextException(nextE);
                        }
                        if (finishSuccessful) ** GOTO lbl312
                    }
                    catch (Throwable var10_22) {
                        block135: {
                            if (!finishSuccessful) {
                                try {
                                    this.txContext.abort(txFailure);
                                    if (MutationState.logger.isInfoEnabled()) {
                                        MutationState.logger.info("Abort successful");
                                    }
                                }
                                catch (TransactionFailureException e) {
                                    if (MutationState.logger.isInfoEnabled()) {
                                        MutationState.logger.info("Abort failed with " + (Object)e);
                                    }
                                    nextE = TransactionUtil.getTransactionFailureException(e);
                                    if (sqlE == null) {
                                        sqlE = nextE;
                                        break block135;
                                    }
                                    sqlE.setNextException(nextE);
                                }
                            }
                        }
                        throw var10_22;
                    }
                    try {
                        this.txContext.abort(txFailure);
                        if (!MutationState.logger.isInfoEnabled()) ** GOTO lbl312
                        MutationState.logger.info("Abort successful");
                    }
                    catch (TransactionFailureException e) {
                        if (MutationState.logger.isInfoEnabled()) {
                            MutationState.logger.info("Abort failed with " + (Object)e);
                        }
                        nextE = TransactionUtil.getTransactionFailureException(e);
                        if (sqlE == null) {
                            sqlE = nextE;
                        }
                        sqlE.setNextException(nextE);
                    }
                }
            }
            finally {
                try {
                    this.resetState();
                }
                finally {
                    if (retryCommit) {
                        this.startTransaction();
                        txTableRefs = txMutations.keySet();
                        for (TableRef tableRef : txTableRefs) {
                            dataTable = tableRef.getTable();
                            this.addDMLFence(dataTable);
                        }
                        try {
                            retryCommit = this.shouldResubmitTransaction(txTableRefs);
                        }
                        catch (SQLException e) {
                            retryCommit = false;
                            if (sqlE == null) {
                                sqlE = e;
                            }
                            sqlE.setNextException(e);
                        }
                    }
                    if (sqlE != null && !retryCommit) {
                        throw sqlE;
                    }
                }
            }
            catch (SQLException e) {
                sqlE = e;
                try {
                    block145: {
                        if (this.txContext == null) break block145;
                        if (!this.isTransactionStarted()) break;
                        txFailure = null;
                        finishSuccessful = false;
                        if (sendSuccessful) {
                            this.txContext.finish();
                            finishSuccessful = true;
                        }
                        if (finishSuccessful) break;
                        try {
                            this.txContext.abort(txFailure);
                            if (MutationState.logger.isInfoEnabled()) {
                                MutationState.logger.info("Abort successful");
                            }
                            ** break block147
                        }
                        catch (TransactionFailureException e) {
                            if (MutationState.logger.isInfoEnabled()) {
                                MutationState.logger.info("Abort failed with " + (Object)e);
                            }
                            nextE = TransactionUtil.getTransactionFailureException(e);
                            if (sqlE == null) {
                                sqlE = nextE;
                            }
                            sqlE.setNextException(nextE);
                        }
                        catch (TransactionFailureException e) {
                            try {
                                if (MutationState.logger.isInfoEnabled()) {
                                    MutationState.logger.info(e.getClass().getName() + " at timestamp " + this.getInitialWritePointer() + " with retry count of " + retryCount);
                                }
                                retryCommit = e instanceof TransactionConflictException != false && retryCount < 3;
                                txFailure = e;
                                nextE = TransactionUtil.getTransactionFailureException(e);
                                if (sqlE == null) {
                                    sqlE = nextE;
                                } else {
                                    sqlE.setNextException(nextE);
                                }
                                if (finishSuccessful) ** break block138
                            }
                            catch (Throwable var28_43) {
                                block139: {
                                    if (!finishSuccessful) {
                                        try {
                                            this.txContext.abort(txFailure);
                                            if (MutationState.logger.isInfoEnabled()) {
                                                MutationState.logger.info("Abort successful");
                                            }
                                        }
                                        catch (TransactionFailureException e) {
                                            if (MutationState.logger.isInfoEnabled()) {
                                                MutationState.logger.info("Abort failed with " + (Object)e);
                                            }
                                            nextE = TransactionUtil.getTransactionFailureException(e);
                                            if (sqlE == null) {
                                                sqlE = nextE;
                                                break block139;
                                            }
                                            sqlE.setNextException(nextE);
                                        }
                                    }
                                }
                                throw var28_43;
                            }
                            try {
                                this.txContext.abort(txFailure);
                                if (MutationState.logger.isInfoEnabled()) {
                                    MutationState.logger.info("Abort successful");
                                }
                                ** break block148
                            }
                            catch (TransactionFailureException e) {
                                if (MutationState.logger.isInfoEnabled()) {
                                    MutationState.logger.info("Abort failed with " + (Object)e);
                                }
                                nextE = TransactionUtil.getTransactionFailureException(e);
                                if (sqlE == null) {
                                    sqlE = nextE;
                                }
                                sqlE.setNextException(nextE);
                            }
                        }
                    }
                    {
lbl-1000:
                        // 1 sources

                        {
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                    }
                }
                finally {
                    try {
                        this.resetState();
                    }
                    finally {
                        block140: {
                            if (retryCommit) {
                                this.startTransaction();
                                txTableRefs = txMutations.keySet();
                                for (TableRef tableRef : txTableRefs) {
                                    dataTable = tableRef.getTable();
                                    this.addDMLFence(dataTable);
                                }
                                try {
                                    retryCommit = this.shouldResubmitTransaction(txTableRefs);
                                }
                                catch (SQLException e) {
                                    retryCommit = false;
                                    if (sqlE == null) {
                                        sqlE = e;
                                        break block140;
                                    }
                                    sqlE.setNextException(e);
                                }
                            }
                        }
                        if (sqlE != null && !retryCommit) {
                            throw sqlE;
                        }
                    }
                }
                catch (Throwable var46_64) {
                    block141: {
                        try {
                            if (this.txContext == null || !this.isTransactionStarted()) break block141;
                            txFailure = null;
                            finishSuccessful = false;
                            if (sendSuccessful) {
                                this.txContext.finish();
                                finishSuccessful = true;
                            }
                            if (finishSuccessful) break block141;
                            try {
                                this.txContext.abort(txFailure);
                                if (MutationState.logger.isInfoEnabled()) {
                                    MutationState.logger.info("Abort successful");
                                }
                                break block141;
                            }
                            catch (TransactionFailureException e) {
                                if (MutationState.logger.isInfoEnabled()) {
                                    MutationState.logger.info("Abort failed with " + (Object)e);
                                }
                                nextE = TransactionUtil.getTransactionFailureException(e);
                                if (sqlE == null) {
                                    sqlE = nextE;
                                    break block141;
                                }
                                sqlE.setNextException(nextE);
                            }
                            break block141;
                            catch (TransactionFailureException e) {
                                try {
                                    if (MutationState.logger.isInfoEnabled()) {
                                        MutationState.logger.info(e.getClass().getName() + " at timestamp " + this.getInitialWritePointer() + " with retry count of " + retryCount);
                                    }
                                    retryCommit = e instanceof TransactionConflictException != false && retryCount < 3;
                                    txFailure = e;
                                    nextE = TransactionUtil.getTransactionFailureException(e);
                                    if (sqlE == null) {
                                        sqlE = nextE;
                                    } else {
                                        sqlE.setNextException(nextE);
                                    }
                                    if (finishSuccessful) break block141;
                                }
                                catch (Throwable var51_74) {
                                    block142: {
                                        if (!finishSuccessful) {
                                            try {
                                                this.txContext.abort(txFailure);
                                                if (MutationState.logger.isInfoEnabled()) {
                                                    MutationState.logger.info("Abort successful");
                                                }
                                            }
                                            catch (TransactionFailureException e) {
                                                if (MutationState.logger.isInfoEnabled()) {
                                                    MutationState.logger.info("Abort failed with " + (Object)e);
                                                }
                                                nextE = TransactionUtil.getTransactionFailureException(e);
                                                if (sqlE == null) {
                                                    sqlE = nextE;
                                                    break block142;
                                                }
                                                sqlE.setNextException(nextE);
                                            }
                                        }
                                    }
                                    throw var51_74;
                                }
                                try {
                                    this.txContext.abort(txFailure);
                                    if (MutationState.logger.isInfoEnabled()) {
                                        MutationState.logger.info("Abort successful");
                                    }
                                }
                                catch (TransactionFailureException e) {
                                    if (MutationState.logger.isInfoEnabled()) {
                                        MutationState.logger.info("Abort failed with " + (Object)e);
                                    }
                                    nextE = TransactionUtil.getTransactionFailureException(e);
                                    if (sqlE == null) {
                                        sqlE = nextE;
                                        break block141;
                                    }
                                    sqlE.setNextException(nextE);
                                }
                            }
                        }
                        finally {
                            try {
                                this.resetState();
                            }
                            finally {
                                block144: {
                                    if (retryCommit) {
                                        this.startTransaction();
                                        txTableRefs = txMutations.keySet();
                                        for (TableRef tableRef : txTableRefs) {
                                            dataTable = tableRef.getTable();
                                            this.addDMLFence(dataTable);
                                        }
                                        try {
                                            retryCommit = this.shouldResubmitTransaction(txTableRefs);
                                        }
                                        catch (SQLException e) {
                                            retryCommit = false;
                                            if (sqlE == null) {
                                                sqlE = e;
                                                break block144;
                                            }
                                            sqlE.setNextException(e);
                                        }
                                    }
                                }
                                if (sqlE != null && !retryCommit) {
                                    throw sqlE;
                                }
                            }
                        }
                    }
                    throw var46_64;
                }
            }
lbl312:
            // 12 sources

            if (!retryCommit) break;
            ++retryCount;
            this.mutations.putAll(txMutations);
        }
    }

    private boolean shouldResubmitTransaction(Set<TableRef> txTableRefs) throws SQLException {
        if (logger.isInfoEnabled()) {
            logger.info("Checking for index updates as of " + this.getInitialWritePointer());
        }
        MetaDataClient client = new MetaDataClient(this.connection);
        PMetaData cache = this.connection.getMetaDataCache();
        boolean addedAnyIndexes = false;
        boolean allImmutableTables = !txTableRefs.isEmpty();
        for (TableRef tableRef : txTableRefs) {
            PTable dataTable = tableRef.getTable();
            PTableRef ptableRef = cache.getTableRef(dataTable.getKey());
            List<PTable> oldIndexes = ptableRef.getTable().getIndexes();
            MetaDataProtocol.MetaDataMutationResult result = client.updateCache(dataTable.getTenantId(), dataTable.getSchemaName().getString(), dataTable.getTableName().getString(), true);
            long timestamp = TransactionUtil.getResolvedTime(this.connection, result);
            tableRef.setTimeStamp(timestamp);
            PTable updatedDataTable = result.getTable();
            if (updatedDataTable == null) {
                throw new TableNotFoundException(dataTable.getSchemaName().getString(), dataTable.getTableName().getString());
            }
            allImmutableTables &= updatedDataTable.isImmutableRows();
            tableRef.setTable(updatedDataTable);
            if (addedAnyIndexes) continue;
            boolean bl = addedAnyIndexes = !oldIndexes.equals(updatedDataTable.getIndexes());
            if (!logger.isInfoEnabled()) continue;
            logger.info((addedAnyIndexes ? "Updates " : "No updates ") + "as of " + timestamp + " to " + updatedDataTable.getName().getString() + " with indexes " + updatedDataTable.getIndexes());
        }
        if (logger.isInfoEnabled()) {
            logger.info((addedAnyIndexes ? "Updates " : "No updates ") + "to indexes as of " + this.getInitialWritePointer() + " over " + (allImmutableTables ? " all immutable tables" : " some mutable tables"));
        }
        return allImmutableTables || addedAnyIndexes;
    }

    public boolean sendUncommitted() throws SQLException {
        return this.sendUncommitted(this.mutations.keySet().iterator());
    }

    public boolean sendUncommitted(Iterator<TableRef> tableRefs) throws SQLException {
        UnmodifiableIterator filteredTableRefs;
        Transaction currentTx = this.getTransaction();
        if (currentTx != null) {
            currentTx.setVisibility(Transaction.VisibilityLevel.SNAPSHOT);
        }
        if ((filteredTableRefs = Iterators.filter(tableRefs, (Predicate)new Predicate<TableRef>(){

            public boolean apply(TableRef tableRef) {
                return tableRef.getTable().isTransactional();
            }
        })).hasNext()) {
            ArrayList strippedAliases = Lists.newArrayListWithExpectedSize((int)this.mutations.keySet().size());
            while (filteredTableRefs.hasNext()) {
                TableRef tableRef = (TableRef)filteredTableRefs.next();
                strippedAliases.add(new TableRef(null, tableRef.getTable(), tableRef.getTimeStamp(), tableRef.getLowerBoundTimeStamp(), tableRef.hasDynamicCols()));
            }
            this.startTransaction();
            this.send(strippedAliases.iterator());
            return true;
        }
        return false;
    }

    public void send() throws SQLException {
        this.send(null);
    }

    public static int[] joinSortedIntArrays(int[] a, int[] b) {
        int current;
        int[] result = new int[a.length + b.length];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < a.length && j < b.length) {
            int n = current = a[i] < b[j] ? a[i++] : b[j++];
            while (i < a.length && a[i] == current) {
                ++i;
            }
            while (j < b.length && b[j] == current) {
                ++j;
            }
            result[k++] = current;
        }
        while (i < a.length) {
            current = a[i++];
            while (i < a.length && a[i] == current) {
                ++i;
            }
            result[k++] = current;
        }
        while (j < b.length) {
            current = b[j++];
            while (j < b.length && b[j] == current) {
                ++j;
            }
            result[k++] = current;
        }
        return Arrays.copyOf(result, k);
    }

    public ReadMetricQueue getReadMetricQueue() {
        return this.readMetricQueue;
    }

    public void setReadMetricQueue(ReadMetricQueue readMetricQueue) {
        this.readMetricQueue = readMetricQueue;
    }

    public MutationMetricQueue getMutationMetricQueue() {
        return this.mutationMetricQueue;
    }

    public static class RowMutationState {
        @Nonnull
        private Map<PColumn, byte[]> columnValues;
        private int[] statementIndexes;
        @Nonnull
        private final RowTimestampColInfo rowTsColInfo;
        private byte[] onDupKeyBytes;

        public RowMutationState(@Nonnull Map<PColumn, byte[]> columnValues, int statementIndex, @Nonnull RowTimestampColInfo rowTsColInfo, byte[] onDupKeyBytes) {
            Preconditions.checkNotNull(columnValues);
            Preconditions.checkNotNull((Object)rowTsColInfo);
            this.columnValues = columnValues;
            this.statementIndexes = new int[]{statementIndex};
            this.rowTsColInfo = rowTsColInfo;
            this.onDupKeyBytes = onDupKeyBytes;
        }

        byte[] getOnDupKeyBytes() {
            return this.onDupKeyBytes;
        }

        public Map<PColumn, byte[]> getColumnValues() {
            return this.columnValues;
        }

        int[] getStatementIndexes() {
            return this.statementIndexes;
        }

        void join(RowMutationState newRow) {
            if (newRow.onDupKeyBytes == null) {
                this.getColumnValues().putAll(newRow.getColumnValues());
            }
            this.onDupKeyBytes = PhoenixIndexBuilder.combineOnDupKey(this.onDupKeyBytes, newRow.onDupKeyBytes);
            this.statementIndexes = MutationState.joinSortedIntArrays(this.statementIndexes, newRow.getStatementIndexes());
        }

        @Nonnull
        RowTimestampColInfo getRowTimestampColInfo() {
            return this.rowTsColInfo;
        }
    }

    @Immutable
    public static class RowTimestampColInfo {
        private final boolean useServerTimestamp;
        private final Long rowTimestamp;
        public static final RowTimestampColInfo NULL_ROWTIMESTAMP_INFO = new RowTimestampColInfo(false, null);

        public RowTimestampColInfo(boolean autoGenerate, Long value) {
            this.useServerTimestamp = autoGenerate;
            this.rowTimestamp = value;
        }

        public boolean useServerTimestamp() {
            return this.useServerTimestamp;
        }

        public Long getTimestamp() {
            return this.rowTimestamp;
        }
    }

    private static class TableInfo {
        private final boolean isDataTable;
        @Nonnull
        private final PName hTableName;
        @Nonnull
        private final TableRef origTableRef;

        public TableInfo(boolean isDataTable, PName hTableName, TableRef origTableRef) {
            Preconditions.checkNotNull((Object)hTableName);
            Preconditions.checkNotNull((Object)origTableRef);
            this.isDataTable = isDataTable;
            this.hTableName = hTableName;
            this.origTableRef = origTableRef;
        }

        public boolean isDataTable() {
            return this.isDataTable;
        }

        public PName getHTableName() {
            return this.hTableName;
        }

        public TableRef getOrigTableRef() {
            return this.origTableRef;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.hTableName.hashCode();
            result = 31 * result + (this.isDataTable ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TableInfo other = (TableInfo)obj;
            if (!this.hTableName.equals(other.hTableName)) {
                return false;
            }
            return this.isDataTable == other.isDataTable;
        }
    }

    private class MetaDataAwareHTable
    extends DelegateHTable {
        private final TableRef tableRef;

        private MetaDataAwareHTable(HTableInterface delegate, TableRef tableRef) {
            super(delegate);
            this.tableRef = tableRef;
        }

        @Override
        public void delete(List<Delete> deletes) throws IOException {
            ServerCacheClient.ServerCache cache = null;
            try {
                PTable table = this.tableRef.getTable();
                List<PTable> indexes = table.getIndexes();
                Iterator<PTable> enabledIndexes = IndexMaintainer.nonDisabledIndexIterator(indexes.iterator());
                if (enabledIndexes.hasNext()) {
                    ArrayList keyValueIndexes = Collections.emptyList();
                    ImmutableBytesWritable indexMetaDataPtr = new ImmutableBytesWritable();
                    boolean attachMetaData = table.getIndexMaintainers(indexMetaDataPtr, MutationState.this.connection);
                    if (table.isImmutableRows()) {
                        ArrayList rowKeyIndexes = Lists.newArrayListWithExpectedSize((int)indexes.size());
                        keyValueIndexes = Lists.newArrayListWithExpectedSize((int)indexes.size());
                        MutationState.this.divideImmutableIndexes(enabledIndexes, table, rowKeyIndexes, keyValueIndexes);
                        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                        for (PTable index : rowKeyIndexes) {
                            List<Delete> indexDeletes = IndexUtil.generateDeleteIndexData(table, index, deletes, ptr, MutationState.this.connection.getKeyValueBuilder(), MutationState.this.connection);
                            HTableInterface hindex = MutationState.this.connection.getQueryServices().getTable(index.getPhysicalName().getBytes());
                            hindex.delete(indexDeletes);
                        }
                    }
                    if (!keyValueIndexes.isEmpty()) {
                        attachMetaData = true;
                        IndexMaintainer.serializeAdditional(table, indexMetaDataPtr, keyValueIndexes, MutationState.this.connection);
                    }
                    if (attachMetaData) {
                        cache = MutationState.this.setMetaDataOnMutations(this.tableRef, deletes, indexMetaDataPtr);
                    }
                }
                this.delegate.delete(deletes);
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
            finally {
                if (cache != null) {
                    SQLCloseables.closeAllQuietly(Collections.singletonList(cache));
                }
            }
        }
    }
}

