/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.iterate.DefaultParallelScanGrouper;
import org.apache.phoenix.iterate.MappedByteBufferQueue;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixParameterMetaData;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.JoinTableNode;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.ValueBitSet;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.NumberUtil;
import org.apache.phoenix.util.ResultUtil;
import org.apache.phoenix.util.SchemaUtil;

public class SortMergeJoinPlan
implements QueryPlan {
    private static final byte[] EMPTY_PTR = new byte[0];
    private final StatementContext context;
    private final FilterableStatement statement;
    private final TableRef table;
    private final JoinTableNode.JoinType type;
    private final QueryPlan lhsPlan;
    private final QueryPlan rhsPlan;
    private final List<Expression> lhsKeyExpressions;
    private final List<Expression> rhsKeyExpressions;
    private final KeyValueSchema joinedSchema;
    private final KeyValueSchema lhsSchema;
    private final KeyValueSchema rhsSchema;
    private final int rhsFieldPosition;
    private final boolean isSingleValueOnly;
    private final Set<TableRef> tableRefs;
    private final int thresholdBytes;
    private Long estimatedBytes;
    private Long estimatedRows;
    private boolean explainPlanCalled;

    public SortMergeJoinPlan(StatementContext context, FilterableStatement statement, TableRef table, JoinTableNode.JoinType type, QueryPlan lhsPlan, QueryPlan rhsPlan, List<Expression> lhsKeyExpressions, List<Expression> rhsKeyExpressions, PTable joinedTable, PTable lhsTable, PTable rhsTable, int rhsFieldPosition, boolean isSingleValueOnly) {
        if (type == JoinTableNode.JoinType.Right) {
            throw new IllegalArgumentException("JoinType should not be " + (Object)((Object)type));
        }
        this.context = context;
        this.statement = statement;
        this.table = table;
        this.type = type;
        this.lhsPlan = lhsPlan;
        this.rhsPlan = rhsPlan;
        this.lhsKeyExpressions = lhsKeyExpressions;
        this.rhsKeyExpressions = rhsKeyExpressions;
        this.joinedSchema = SortMergeJoinPlan.buildSchema(joinedTable);
        this.lhsSchema = SortMergeJoinPlan.buildSchema(lhsTable);
        this.rhsSchema = SortMergeJoinPlan.buildSchema(rhsTable);
        this.rhsFieldPosition = rhsFieldPosition;
        this.isSingleValueOnly = isSingleValueOnly;
        this.tableRefs = Sets.newHashSetWithExpectedSize((int)(lhsPlan.getSourceRefs().size() + rhsPlan.getSourceRefs().size()));
        this.tableRefs.addAll(lhsPlan.getSourceRefs());
        this.tableRefs.addAll(rhsPlan.getSourceRefs());
        this.thresholdBytes = context.getConnection().getQueryServices().getProps().getInt("phoenix.query.spoolThresholdBytes", 0x1400000);
    }

    @Override
    public PhoenixStatement.Operation getOperation() {
        return this.statement.getOperation();
    }

    private static KeyValueSchema buildSchema(PTable table) {
        KeyValueSchema.KeyValueSchemaBuilder builder = new KeyValueSchema.KeyValueSchemaBuilder(0);
        if (table != null) {
            for (PColumn column : table.getColumns()) {
                if (SchemaUtil.isPKColumn(column)) continue;
                builder.addField(column);
            }
        }
        return builder.build();
    }

    @Override
    public ResultIterator iterator(ParallelScanGrouper scanGrouper) throws SQLException {
        return this.iterator(scanGrouper, null);
    }

    @Override
    public ResultIterator iterator(ParallelScanGrouper scanGrouper, Scan scan) throws SQLException {
        return this.type == JoinTableNode.JoinType.Semi || this.type == JoinTableNode.JoinType.Anti ? new SemiAntiJoinIterator(this.lhsPlan.iterator(scanGrouper), this.rhsPlan.iterator(scanGrouper)) : new BasicJoinIterator(this.lhsPlan.iterator(scanGrouper), this.rhsPlan.iterator(scanGrouper));
    }

    @Override
    public ResultIterator iterator() throws SQLException {
        return this.iterator(DefaultParallelScanGrouper.getInstance());
    }

    @Override
    public ExplainPlan getExplainPlan() throws SQLException {
        this.explainPlanCalled = true;
        ArrayList steps = Lists.newArrayList();
        steps.add("SORT-MERGE-JOIN (" + this.type.toString().toUpperCase() + ") TABLES");
        for (String step : this.lhsPlan.getExplainPlan().getPlanSteps()) {
            steps.add("    " + step);
        }
        steps.add("AND" + (this.rhsSchema.getFieldCount() == 0 ? " (SKIP MERGE)" : ""));
        for (String step : this.rhsPlan.getExplainPlan().getPlanSteps()) {
            steps.add("    " + step);
        }
        this.estimatedBytes = NumberUtil.add(NumberUtil.add(this.estimatedBytes, this.lhsPlan.getEstimatedBytesToScan()), this.rhsPlan.getEstimatedBytesToScan());
        this.estimatedRows = NumberUtil.add(NumberUtil.add(this.estimatedRows, this.lhsPlan.getEstimatedRowsToScan()), this.rhsPlan.getEstimatedRowsToScan());
        return new ExplainPlan(steps);
    }

    @Override
    public StatementContext getContext() {
        return this.context;
    }

    @Override
    public ParameterMetaData getParameterMetaData() {
        return PhoenixParameterMetaData.EMPTY_PARAMETER_META_DATA;
    }

    @Override
    public long getEstimatedSize() {
        return this.lhsPlan.getEstimatedSize() + this.rhsPlan.getEstimatedSize();
    }

    @Override
    public TableRef getTableRef() {
        return this.table;
    }

    @Override
    public RowProjector getProjector() {
        return null;
    }

    @Override
    public Integer getLimit() {
        return null;
    }

    @Override
    public Integer getOffset() {
        return null;
    }

    @Override
    public OrderByCompiler.OrderBy getOrderBy() {
        return null;
    }

    @Override
    public GroupByCompiler.GroupBy getGroupBy() {
        return null;
    }

    @Override
    public List<KeyRange> getSplits() {
        return Collections.emptyList();
    }

    @Override
    public List<List<Scan>> getScans() {
        return Collections.emptyList();
    }

    @Override
    public FilterableStatement getStatement() {
        return this.statement;
    }

    @Override
    public boolean isDegenerate() {
        return false;
    }

    @Override
    public boolean isRowKeyOrdered() {
        return false;
    }

    @Override
    public boolean useRoundRobinIterator() {
        return false;
    }

    @Override
    public Set<TableRef> getSourceRefs() {
        return this.tableRefs;
    }

    public QueryPlan getLhsPlan() {
        return this.lhsPlan;
    }

    public QueryPlan getRhsPlan() {
        return this.rhsPlan;
    }

    @Override
    public Long getEstimatedRowsToScan() throws SQLException {
        if (!this.explainPlanCalled) {
            this.getExplainPlan();
        }
        return this.estimatedRows;
    }

    @Override
    public Long getEstimatedBytesToScan() throws SQLException {
        if (!this.explainPlanCalled) {
            this.getExplainPlan();
        }
        return this.estimatedBytes;
    }

    private static class MappedByteBufferTupleQueue
    extends MappedByteBufferQueue<Tuple> {
        public MappedByteBufferTupleQueue(int thresholdBytes) {
            super(thresholdBytes);
        }

        @Override
        protected MappedByteBufferQueue.MappedByteBufferSegmentQueue<Tuple> createSegmentQueue(int index, int thresholdBytes) {
            return new MappedByteBufferTupleSegmentQueue(index, thresholdBytes, false);
        }

        @Override
        protected Comparator<MappedByteBufferQueue.MappedByteBufferSegmentQueue<Tuple>> getSegmentQueueComparator() {
            return new Comparator<MappedByteBufferQueue.MappedByteBufferSegmentQueue<Tuple>>(){

                @Override
                public int compare(MappedByteBufferQueue.MappedByteBufferSegmentQueue<Tuple> q1, MappedByteBufferQueue.MappedByteBufferSegmentQueue<Tuple> q2) {
                    return q1.index() - q2.index();
                }
            };
        }

        @Override
        public Iterator<Tuple> iterator() {
            return new Iterator<Tuple>(){
                private Iterator<MappedByteBufferQueue.MappedByteBufferSegmentQueue<Tuple>> queueIter;
                private Iterator<Tuple> currentIter;
                {
                    this.queueIter = MappedByteBufferTupleQueue.this.getSegmentQueues().iterator();
                    this.currentIter = this.queueIter.hasNext() ? this.queueIter.next().iterator() : null;
                }

                @Override
                public boolean hasNext() {
                    return this.currentIter != null && this.currentIter.hasNext();
                }

                @Override
                public Tuple next() {
                    if (!this.hasNext()) {
                        return null;
                    }
                    Tuple ret = this.currentIter.next();
                    if (!this.currentIter.hasNext()) {
                        this.currentIter = this.queueIter.hasNext() ? this.queueIter.next().iterator() : null;
                    }
                    return ret;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        private static class MappedByteBufferTupleSegmentQueue
        extends MappedByteBufferQueue.MappedByteBufferSegmentQueue<Tuple> {
            private LinkedList<Tuple> results = Lists.newLinkedList();

            public MappedByteBufferTupleSegmentQueue(int index, int thresholdBytes, boolean hasMaxQueueSize) {
                super(index, thresholdBytes, hasMaxQueueSize);
            }

            @Override
            protected Queue<Tuple> getInMemoryQueue() {
                return this.results;
            }

            @Override
            protected int sizeOf(Tuple e) {
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)e.getValue(0));
                return 8 + kv.getLength();
            }

            @Override
            protected void writeToBuffer(MappedByteBuffer buffer, Tuple e) {
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)e.getValue(0));
                buffer.putInt(kv.getLength() + 4);
                buffer.putInt(kv.getLength());
                buffer.put(kv.getBuffer(), kv.getOffset(), kv.getLength());
            }

            @Override
            protected Tuple readFromBuffer(MappedByteBuffer buffer) {
                int length = buffer.getInt();
                if (length < 0) {
                    return null;
                }
                byte[] b = new byte[length];
                buffer.get(b);
                Result result = ResultUtil.toResult(new ImmutableBytesWritable(b));
                return new ResultTuple(result);
            }
        }
    }

    private static class JoinKey
    implements Comparable<JoinKey> {
        private final List<Expression> expressions;
        private final List<ImmutableBytesWritable> keys;

        public JoinKey(List<Expression> expressions) {
            this.expressions = expressions;
            this.keys = Lists.newArrayListWithExpectedSize((int)expressions.size());
            for (int i = 0; i < expressions.size(); ++i) {
                this.keys.add(new ImmutableBytesWritable(EMPTY_PTR));
            }
        }

        public void evaluate(Tuple tuple) {
            for (int i = 0; i < this.keys.size(); ++i) {
                if (this.expressions.get(i).evaluate(tuple, this.keys.get(i))) continue;
                this.keys.get(i).set(EMPTY_PTR);
            }
        }

        public void set(JoinKey other) {
            for (int i = 0; i < this.keys.size(); ++i) {
                ImmutableBytesWritable key = other.keys.get(i);
                this.keys.get(i).set(key.get(), key.getOffset(), key.getLength());
            }
        }

        public void clear() {
            for (int i = 0; i < this.keys.size(); ++i) {
                this.keys.get(i).set(EMPTY_PTR);
            }
        }

        public boolean equals(Object other) {
            if (!(other instanceof JoinKey)) {
                return false;
            }
            return this.compareTo((JoinKey)other) == 0;
        }

        @Override
        public int compareTo(JoinKey other) {
            for (int i = 0; i < this.keys.size(); ++i) {
                int comp = this.keys.get(i).compareTo(other.keys.get(i));
                if (comp == 0) continue;
                return comp;
            }
            return 0;
        }
    }

    private class SemiAntiJoinIterator
    implements ResultIterator {
        private final ResultIterator lhsIterator;
        private final ResultIterator rhsIterator;
        private final boolean isSemi;
        private boolean initialized;
        private Tuple lhsTuple;
        private Tuple rhsTuple;
        private JoinKey lhsKey;
        private JoinKey rhsKey;

        public SemiAntiJoinIterator(ResultIterator lhsIterator, ResultIterator rhsIterator) {
            if (SortMergeJoinPlan.this.type != JoinTableNode.JoinType.Semi && SortMergeJoinPlan.this.type != JoinTableNode.JoinType.Anti) {
                throw new IllegalArgumentException("Type " + (Object)((Object)SortMergeJoinPlan.this.type) + " is not allowed by " + SemiAntiJoinIterator.class.getName());
            }
            this.lhsIterator = lhsIterator;
            this.rhsIterator = rhsIterator;
            this.isSemi = SortMergeJoinPlan.this.type == JoinTableNode.JoinType.Semi;
            this.initialized = false;
            this.lhsTuple = null;
            this.rhsTuple = null;
            this.lhsKey = new JoinKey(SortMergeJoinPlan.this.lhsKeyExpressions);
            this.rhsKey = new JoinKey(SortMergeJoinPlan.this.rhsKeyExpressions);
        }

        @Override
        public void close() throws SQLException {
            this.lhsIterator.close();
            this.rhsIterator.close();
        }

        @Override
        public Tuple next() throws SQLException {
            if (!this.initialized) {
                this.advance(true);
                this.advance(false);
                this.initialized = true;
            }
            Tuple next = null;
            while (this.lhsTuple != null && next == null) {
                if (this.rhsTuple != null) {
                    if (this.lhsKey.equals(this.rhsKey)) {
                        if (this.isSemi) {
                            next = this.lhsTuple;
                        }
                        this.advance(true);
                        continue;
                    }
                    if (this.lhsKey.compareTo(this.rhsKey) < 0) {
                        if (!this.isSemi) {
                            next = this.lhsTuple;
                        }
                        this.advance(true);
                        continue;
                    }
                    this.advance(false);
                    continue;
                }
                if (!this.isSemi) {
                    next = this.lhsTuple;
                }
                this.advance(true);
            }
            return next;
        }

        @Override
        public void explain(List<String> planSteps) {
        }

        private void advance(boolean lhs) throws SQLException {
            if (lhs) {
                this.lhsTuple = this.lhsIterator.next();
                if (this.lhsTuple != null) {
                    this.lhsKey.evaluate(this.lhsTuple);
                } else {
                    this.lhsKey.clear();
                }
            } else {
                this.rhsTuple = this.rhsIterator.next();
                if (this.rhsTuple != null) {
                    this.rhsKey.evaluate(this.rhsTuple);
                } else {
                    this.rhsKey.clear();
                }
            }
        }
    }

    private class BasicJoinIterator
    implements ResultIterator {
        private final ResultIterator lhsIterator;
        private final ResultIterator rhsIterator;
        private boolean initialized;
        private Tuple lhsTuple;
        private Tuple rhsTuple;
        private JoinKey lhsKey;
        private JoinKey rhsKey;
        private Tuple nextLhsTuple;
        private Tuple nextRhsTuple;
        private JoinKey nextLhsKey;
        private JoinKey nextRhsKey;
        private ValueBitSet destBitSet;
        private ValueBitSet lhsBitSet;
        private ValueBitSet rhsBitSet;
        private byte[] emptyProjectedValue;
        private MappedByteBufferTupleQueue queue;
        private Iterator<Tuple> queueIterator;

        public BasicJoinIterator(ResultIterator lhsIterator, ResultIterator rhsIterator) {
            this.lhsIterator = lhsIterator;
            this.rhsIterator = rhsIterator;
            this.initialized = false;
            this.lhsTuple = null;
            this.rhsTuple = null;
            this.lhsKey = new JoinKey(SortMergeJoinPlan.this.lhsKeyExpressions);
            this.rhsKey = new JoinKey(SortMergeJoinPlan.this.rhsKeyExpressions);
            this.nextLhsTuple = null;
            this.nextRhsTuple = null;
            this.nextLhsKey = new JoinKey(SortMergeJoinPlan.this.lhsKeyExpressions);
            this.nextRhsKey = new JoinKey(SortMergeJoinPlan.this.rhsKeyExpressions);
            this.destBitSet = ValueBitSet.newInstance(SortMergeJoinPlan.this.joinedSchema);
            this.lhsBitSet = ValueBitSet.newInstance(SortMergeJoinPlan.this.lhsSchema);
            this.rhsBitSet = ValueBitSet.newInstance(SortMergeJoinPlan.this.rhsSchema);
            this.lhsBitSet.clear();
            int len = this.lhsBitSet.getEstimatedLength();
            this.emptyProjectedValue = new byte[len];
            this.lhsBitSet.toBytes(this.emptyProjectedValue, 0);
            this.queue = new MappedByteBufferTupleQueue(SortMergeJoinPlan.this.thresholdBytes);
            this.queueIterator = null;
        }

        @Override
        public void close() throws SQLException {
            this.lhsIterator.close();
            this.rhsIterator.close();
            this.queue.close();
        }

        @Override
        public Tuple next() throws SQLException {
            if (!this.initialized) {
                this.init();
            }
            Tuple next = null;
            while (next == null && !this.isEnd()) {
                if (this.queueIterator != null) {
                    if (this.queueIterator.hasNext()) {
                        next = this.join(this.lhsTuple, this.queueIterator.next());
                        continue;
                    }
                    boolean eq = this.nextLhsTuple != null && this.lhsKey.equals(this.nextLhsKey);
                    this.advance(true);
                    if (eq) {
                        this.queueIterator = this.queue.iterator();
                        continue;
                    }
                    this.queue.clear();
                    this.queueIterator = null;
                    continue;
                }
                if (this.lhsTuple != null) {
                    if (this.rhsTuple != null) {
                        if (this.lhsKey.equals(this.rhsKey)) {
                            next = this.join(this.lhsTuple, this.rhsTuple);
                            if (this.nextLhsTuple != null && this.lhsKey.equals(this.nextLhsKey)) {
                                this.queue.offer(this.rhsTuple);
                                if (this.nextRhsTuple == null || !this.rhsKey.equals(this.nextRhsKey)) {
                                    this.queueIterator = this.queue.iterator();
                                    this.advance(true);
                                } else if (SortMergeJoinPlan.this.isSingleValueOnly) {
                                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.SINGLE_ROW_SUBQUERY_RETURNS_MULTIPLE_ROWS).build().buildException();
                                }
                            } else if (this.nextRhsTuple == null || !this.rhsKey.equals(this.nextRhsKey)) {
                                this.advance(true);
                            } else if (SortMergeJoinPlan.this.isSingleValueOnly) {
                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.SINGLE_ROW_SUBQUERY_RETURNS_MULTIPLE_ROWS).build().buildException();
                            }
                            this.advance(false);
                            continue;
                        }
                        if (this.lhsKey.compareTo(this.rhsKey) < 0) {
                            if (SortMergeJoinPlan.this.type == JoinTableNode.JoinType.Full || SortMergeJoinPlan.this.type == JoinTableNode.JoinType.Left) {
                                next = this.join(this.lhsTuple, null);
                            }
                            this.advance(true);
                            continue;
                        }
                        if (SortMergeJoinPlan.this.type == JoinTableNode.JoinType.Full) {
                            next = this.join(null, this.rhsTuple);
                        }
                        this.advance(false);
                        continue;
                    }
                    next = this.join(this.lhsTuple, null);
                    this.advance(true);
                    continue;
                }
                next = this.join(null, this.rhsTuple);
                this.advance(false);
            }
            return next;
        }

        @Override
        public void explain(List<String> planSteps) {
        }

        private void init() throws SQLException {
            this.nextLhsTuple = this.lhsIterator.next();
            if (this.nextLhsTuple != null) {
                this.nextLhsKey.evaluate(this.nextLhsTuple);
            }
            this.advance(true);
            this.nextRhsTuple = this.rhsIterator.next();
            if (this.nextRhsTuple != null) {
                this.nextRhsKey.evaluate(this.nextRhsTuple);
            }
            this.advance(false);
            this.initialized = true;
        }

        private void advance(boolean lhs) throws SQLException {
            if (lhs) {
                this.lhsTuple = this.nextLhsTuple;
                this.lhsKey.set(this.nextLhsKey);
                if (this.lhsTuple != null) {
                    this.nextLhsTuple = this.lhsIterator.next();
                    if (this.nextLhsTuple != null) {
                        this.nextLhsKey.evaluate(this.nextLhsTuple);
                    } else {
                        this.nextLhsKey.clear();
                    }
                }
            } else {
                this.rhsTuple = this.nextRhsTuple;
                this.rhsKey.set(this.nextRhsKey);
                if (this.rhsTuple != null) {
                    this.nextRhsTuple = this.rhsIterator.next();
                    if (this.nextRhsTuple != null) {
                        this.nextRhsKey.evaluate(this.nextRhsTuple);
                    } else {
                        this.nextRhsKey.clear();
                    }
                }
            }
        }

        private boolean isEnd() {
            return this.lhsTuple == null && (this.rhsTuple == null || SortMergeJoinPlan.this.type != JoinTableNode.JoinType.Full) || this.queueIterator == null && this.rhsTuple == null && SortMergeJoinPlan.this.type == JoinTableNode.JoinType.Inner;
        }

        private Tuple join(Tuple lhs, Tuple rhs) throws SQLException {
            try {
                TupleProjector.ProjectedValueTuple t = null;
                if (lhs == null) {
                    t = new TupleProjector.ProjectedValueTuple(rhs, rhs.getValue(0).getTimestamp(), this.emptyProjectedValue, 0, this.emptyProjectedValue.length, this.emptyProjectedValue.length);
                } else if (lhs instanceof TupleProjector.ProjectedValueTuple) {
                    t = (TupleProjector.ProjectedValueTuple)lhs;
                } else {
                    ImmutableBytesWritable ptr = SortMergeJoinPlan.this.context.getTempPtr();
                    TupleProjector.decodeProjectedValue(lhs, ptr);
                    this.lhsBitSet.clear();
                    this.lhsBitSet.or(ptr);
                    int bitSetLen = this.lhsBitSet.getEstimatedLength();
                    t = new TupleProjector.ProjectedValueTuple(lhs, lhs.getValue(0).getTimestamp(), ptr.get(), ptr.getOffset(), ptr.getLength(), bitSetLen);
                }
                return this.rhsBitSet == ValueBitSet.EMPTY_VALUE_BITSET ? t : TupleProjector.mergeProjectedValue(t, SortMergeJoinPlan.this.joinedSchema, this.destBitSet, rhs, SortMergeJoinPlan.this.rhsSchema, this.rhsBitSet, SortMergeJoinPlan.this.rhsFieldPosition, true);
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
    }
}

