/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.expression.BaseCompoundExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PArrayDataTypeEncoder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.TrustedByteArrayOutputStream;

public class ArrayConstructorExpression
extends BaseCompoundExpression {
    private PDataType baseType;
    private int position = -1;
    private Object[] elements;
    private final ImmutableBytesWritable valuePtr = new ImmutableBytesWritable();
    private int estimatedSize = 0;
    private boolean rowKeyOrderOptimizable;

    public ArrayConstructorExpression() {
    }

    public ArrayConstructorExpression(List<Expression> children, PDataType baseType, boolean rowKeyOrderOptimizable) {
        super(children);
        this.init(baseType, rowKeyOrderOptimizable);
    }

    public ArrayConstructorExpression clone(List<Expression> children) {
        return new ArrayConstructorExpression(children, this.baseType, this.rowKeyOrderOptimizable);
    }

    private void init(PDataType baseType, boolean rowKeyOrderOptimizable) {
        this.baseType = baseType;
        this.rowKeyOrderOptimizable = rowKeyOrderOptimizable;
        this.elements = new Object[this.getChildren().size()];
        this.valuePtr.set(ByteUtil.EMPTY_BYTE_ARRAY);
        this.estimatedSize = PArrayDataType.estimateSize(this.children.size(), this.baseType);
    }

    @Override
    public PDataType getDataType() {
        return PDataType.fromTypeId(this.baseType.getSqlType() + 3000);
    }

    @Override
    public void reset() {
        super.reset();
        this.position = 0;
        Arrays.fill(this.elements, null);
        this.valuePtr.set(ByteUtil.EMPTY_BYTE_ARRAY);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        int i;
        if (this.position == this.elements.length) {
            ptr.set(this.valuePtr.get(), this.valuePtr.getOffset(), this.valuePtr.getLength());
            return true;
        }
        TrustedByteArrayOutputStream byteStream = new TrustedByteArrayOutputStream(this.estimatedSize);
        DataOutputStream oStream = new DataOutputStream(byteStream);
        PArrayDataTypeEncoder builder = new PArrayDataTypeEncoder(byteStream, oStream, this.children.size(), this.baseType, this.getSortOrder(), this.rowKeyOrderOptimizable, 1);
        int n = i = this.position >= 0 ? this.position : 0;
        while (i < this.elements.length) {
            Expression child = (Expression)this.children.get(i);
            if (!child.evaluate(tuple, ptr)) {
                if (tuple != null && !tuple.isImmutable()) {
                    if (this.position >= 0) {
                        this.position = i;
                    }
                    return false;
                }
            } else {
                builder.appendValue(ptr.get(), ptr.getOffset(), ptr.getLength());
            }
            ++i;
        }
        if (this.position >= 0) {
            this.position = this.elements.length;
        }
        byte[] bytes = builder.encode();
        ptr.set(bytes, 0, bytes.length);
        this.valuePtr.set(ptr.get(), ptr.getOffset(), ptr.getLength());
        return true;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        boolean rowKeyOrderOptimizable = false;
        int baseTypeOrdinal = WritableUtils.readVInt((DataInput)input);
        if (baseTypeOrdinal < 0) {
            rowKeyOrderOptimizable = true;
            baseTypeOrdinal = -(baseTypeOrdinal + 1);
        }
        this.init(PDataType.values()[baseTypeOrdinal], rowKeyOrderOptimizable);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        if (this.rowKeyOrderOptimizable) {
            WritableUtils.writeVInt((DataOutput)output, (int)(-(this.baseType.ordinal() + 1)));
        } else {
            WritableUtils.writeVInt((DataOutput)output, (int)this.baseType.ordinal());
        }
    }

    @Override
    public boolean requiresFinalEvaluation() {
        return true;
    }

    @Override
    public final <T> T accept(ExpressionVisitor<T> visitor) {
        List<T> l = this.acceptChildren(visitor, visitor.visitEnter(this));
        T t = visitor.visitLeave(this, l);
        if (t == null) {
            t = visitor.defaultReturn(this, l);
        }
        return t;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("ARRAY[");
        if (this.children.size() == 0) {
            return buf.append("]").toString();
        }
        for (int i = 0; i < this.children.size() - 1; ++i) {
            buf.append(this.children.get(i) + ",");
        }
        buf.append(this.children.get(this.children.size() - 1) + "]");
        return buf.toString();
    }
}

