/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.filter;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.ValueSchema;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;

public class SkipScanFilter
extends FilterBase
implements Writable {
    private List<List<KeyRange>> slots;
    private int[] slotSpan;
    private RowKeySchema schema;
    private boolean includeMultipleVersions;
    private int[] position;
    private int maxKeyLength;
    private byte[] startKey;
    private int startKeyLength;
    private byte[] endKey;
    private int endKeyLength;
    private boolean isDone;
    private int offset;
    private Map<ImmutableBytesWritable, Cell> nextCellHintMap = new HashMap<ImmutableBytesWritable, Cell>();
    private final ImmutableBytesWritable ptr = new ImmutableBytesWritable();
    private static final int KEY_RANGE_LENGTH_BITS = 21;
    private static final int SLOT_SPAN_BITS = 11;

    public SkipScanFilter() {
    }

    public SkipScanFilter(SkipScanFilter filter, boolean includeMultipleVersions) {
        this(filter.slots, filter.slotSpan, filter.schema, includeMultipleVersions);
    }

    public SkipScanFilter(List<List<KeyRange>> slots, RowKeySchema schema) {
        this(slots, ScanUtil.getDefaultSlotSpans(slots.size()), schema);
    }

    public SkipScanFilter(List<List<KeyRange>> slots, int[] slotSpan, RowKeySchema schema) {
        this(slots, slotSpan, schema, false);
    }

    private SkipScanFilter(List<List<KeyRange>> slots, int[] slotSpan, RowKeySchema schema, boolean includeMultipleVersions) {
        this.init(slots, slotSpan, schema, includeMultipleVersions);
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    private void init(List<List<KeyRange>> slots, int[] slotSpan, RowKeySchema schema, boolean includeMultipleVersions) {
        for (List<KeyRange> ranges : slots) {
            if (!ranges.isEmpty()) continue;
            throw new IllegalStateException();
        }
        this.slots = slots;
        this.slotSpan = slotSpan;
        this.schema = schema;
        this.maxKeyLength = SchemaUtil.getMaxKeyLength(schema, slots);
        this.position = new int[slots.size()];
        this.startKey = new byte[this.maxKeyLength];
        this.endKey = new byte[this.maxKeyLength];
        this.endKeyLength = 0;
        this.includeMultipleVersions = includeMultipleVersions;
    }

    public List<List<KeyRange>> getSlots() {
        return this.slots;
    }

    public boolean filterAllRemaining() {
        return this.isDone;
    }

    public Filter.ReturnCode filterKeyValue(Cell kv) {
        Filter.ReturnCode code = this.navigate(kv.getRowArray(), kv.getRowOffset() + this.offset, kv.getRowLength() - this.offset, Terminate.AFTER);
        if (code == Filter.ReturnCode.SEEK_NEXT_USING_HINT) {
            this.setNextCellHint(kv);
        }
        return code;
    }

    private void setNextCellHint(Cell kv) {
        boolean isHintAfterPrevious;
        ImmutableBytesWritable family = new ImmutableBytesWritable(kv.getFamilyArray(), kv.getFamilyOffset(), (int)kv.getFamilyLength());
        KeyValue nextCellHint = null;
        if (this.offset == 0) {
            nextCellHint = new KeyValue(this.startKey, 0, this.startKeyLength, null, 0, 0, null, 0, 0, Long.MAX_VALUE, KeyValue.Type.Maximum, null, 0, 0);
        } else {
            byte[] nextKey = new byte[this.offset + this.startKeyLength];
            System.arraycopy(kv.getRowArray(), kv.getRowOffset(), nextKey, 0, this.offset);
            System.arraycopy(this.startKey, 0, nextKey, this.offset, this.startKeyLength);
            nextCellHint = new KeyValue(nextKey, 0, nextKey.length, null, 0, 0, null, 0, 0, Long.MAX_VALUE, KeyValue.Type.Maximum, null, 0, 0);
        }
        Cell previousCellHint = this.nextCellHintMap.put(family, (Cell)nextCellHint);
        boolean bl = isHintAfterPrevious = previousCellHint == null || Bytes.compareTo((byte[])nextCellHint.getRowArray(), (int)nextCellHint.getRowOffset(), (int)nextCellHint.getRowLength(), (byte[])previousCellHint.getRowArray(), (int)previousCellHint.getRowOffset(), (int)previousCellHint.getRowLength()) > 0;
        if (!isHintAfterPrevious) {
            String msg = "The next hint must come after previous hint (prev=" + previousCellHint + ", next=" + nextCellHint + ", kv=" + kv + ")";
            throw new IllegalStateException(msg);
        }
    }

    public Cell getNextCellHint(Cell kv) {
        return this.isDone ? null : this.nextCellHintMap.get(new ImmutableBytesWritable(kv.getFamilyArray(), kv.getFamilyOffset(), (int)kv.getFamilyLength()));
    }

    public boolean hasIntersect(byte[] lowerInclusiveKey, byte[] upperExclusiveKey) {
        return this.intersect(lowerInclusiveKey, upperExclusiveKey, null);
    }

    public SkipScanFilter intersect(byte[] lowerInclusiveKey, byte[] upperExclusiveKey) {
        ArrayList newSlots = Lists.newArrayListWithCapacity((int)this.slots.size());
        if (this.intersect(lowerInclusiveKey, upperExclusiveKey, newSlots)) {
            return new SkipScanFilter(newSlots, this.slotSpan, this.schema);
        }
        return null;
    }

    private boolean areSlotsSingleKey(int startPosInclusive, int endPosExclusive) {
        for (int i = startPosInclusive; i < endPosExclusive; ++i) {
            if (this.slots.get(i).get(this.position[i]).isSingleKey()) continue;
            return false;
        }
        return true;
    }

    private void resetState() {
        this.isDone = false;
        this.endKeyLength = 0;
        Arrays.fill(this.position, 0);
    }

    private boolean intersect(byte[] lowerInclusiveKey, byte[] upperExclusiveKey, List<List<KeyRange>> newSlots) {
        this.resetState();
        boolean lowerUnbound = lowerInclusiveKey.length == 0;
        int startPos = 0;
        int lastSlot = this.slots.size() - 1;
        if (!lowerUnbound) {
            this.schema.next(this.ptr, 0, this.schema.iterator(lowerInclusiveKey, this.ptr), this.slotSpan[0]);
            startPos = ScanUtil.searchClosestKeyRangeWithUpperHigherThanPtr(this.slots.get(0), this.ptr, 0, this.schema.getField(0));
            if (startPos >= this.slots.get(0).size()) {
                return false;
            }
        }
        boolean upperUnbound = upperExclusiveKey.length == 0;
        int endPos = this.slots.get(0).size() - 1;
        if (!upperUnbound) {
            this.schema.next(this.ptr, 0, this.schema.iterator(upperExclusiveKey, this.ptr), this.slotSpan[0]);
            endPos = ScanUtil.searchClosestKeyRangeWithUpperHigherThanPtr(this.slots.get(0), this.ptr, startPos, this.schema.getField(0));
            if (endPos >= this.slots.get(0).size()) {
                upperUnbound = true;
                endPos = this.slots.get(0).size() - 1;
            } else if (this.slots.get(0).get(endPos).compareLowerToUpperBound(upperExclusiveKey, ScanUtil.getComparator(this.schema.getField(0))) >= 0) {
                --endPos;
            }
            if (endPos < startPos) {
                return false;
            }
        }
        if (this.slots.size() == 1) {
            if (newSlots != null) {
                List<KeyRange> newRanges = this.slots.get(0).subList(startPos, endPos + 1);
                newSlots.add(newRanges);
            }
            return true;
        }
        if (!lowerUnbound) {
            this.position[0] = startPos;
            this.navigate(lowerInclusiveKey, 0, lowerInclusiveKey.length, Terminate.AFTER);
            if (this.filterAllRemaining()) {
                return false;
            }
        }
        if (upperUnbound) {
            if (newSlots != null) {
                newSlots.add(this.slots.get(0).subList(startPos, endPos + 1));
                newSlots.addAll(this.slots.subList(1, this.slots.size()));
            }
            return true;
        }
        int[] lowerPosition = Arrays.copyOf(this.position, this.position.length);
        Filter.ReturnCode endCode = this.navigate(upperExclusiveKey, 0, upperExclusiveKey.length, Terminate.AT);
        if (endCode == Filter.ReturnCode.INCLUDE || endCode == Filter.ReturnCode.INCLUDE_AND_NEXT_COL) {
            this.setStartKey();
            if (Bytes.compareTo((byte[])this.startKey, (int)0, (int)this.startKeyLength, (byte[])upperExclusiveKey, (int)0, (int)upperExclusiveKey.length) == 0 && (this.previousPosition(lastSlot) < 0 || this.position[0] < lowerPosition[0])) {
                return false;
            }
        } else if (endCode == Filter.ReturnCode.SEEK_NEXT_USING_HINT) {
            if (Arrays.equals(lowerPosition, this.position) && this.areSlotsSingleKey(0, this.position.length - 1)) {
                return false;
            }
        } else if (this.filterAllRemaining()) {
            for (int i = 0; i <= lastSlot; ++i) {
                this.position[i] = this.slots.get(i).size() - 1;
            }
        }
        int prevRowKeyPos = -1;
        ImmutableBytesWritable lowerPtr = new ImmutableBytesWritable();
        ImmutableBytesWritable upperPtr = new ImmutableBytesWritable();
        this.schema.iterator(lowerInclusiveKey, lowerPtr);
        this.schema.iterator(upperExclusiveKey, upperPtr);
        for (int i = 0; i <= lastSlot; ++i) {
            List<KeyRange> newRanges = this.slots.get(i).subList(lowerPosition[i], Math.min(this.position[i] + 1, this.slots.get(i).size()));
            if (newRanges.isEmpty()) {
                return false;
            }
            if (newSlots != null) {
                newSlots.add(newRanges);
            }
            if (this.position[i] > lowerPosition[i]) {
                if (newSlots == null) break;
                newSlots.addAll(this.slots.subList(i + 1, this.slots.size()));
                break;
            }
            if (this.slots.get(i).get(this.position[i]).isSingleKey()) continue;
            int rowKeyPos = ScanUtil.getRowKeyPosition(this.slotSpan, i);
            this.schema.reposition(lowerPtr, prevRowKeyPos, rowKeyPos, 0, lowerInclusiveKey.length, this.slotSpan[i]);
            this.schema.reposition(upperPtr, prevRowKeyPos, rowKeyPos, 0, upperExclusiveKey.length, this.slotSpan[i]);
            if (lowerPtr.compareTo(upperPtr) != 0) {
                if (newSlots == null) break;
                newSlots.addAll(this.slots.subList(i + 1, this.slots.size()));
                break;
            }
            prevRowKeyPos = rowKeyPos;
        }
        return true;
    }

    private int previousPosition(int i) {
        while (i >= 0) {
            int n = i;
            this.position[n] = this.position[n] - 1;
            if (this.position[n] >= 0) break;
            this.position[i] = this.slots.get(i).size() - 1;
            --i;
        }
        return i;
    }

    private Filter.ReturnCode getIncludeReturnCode() {
        return this.includeMultipleVersions ? Filter.ReturnCode.INCLUDE : Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
    }

    @SuppressWarnings(value={"QBA_QUESTIONABLE_BOOLEAN_ASSIGNMENT"}, justification="Assignment designed to work this way.")
    private Filter.ReturnCode navigate(byte[] currentKey, int offset, int length, Terminate terminate) {
        int minOffset;
        boolean seek;
        int i;
        block20: {
            int nSlots = this.slots.size();
            if (this.endKeyLength > 0) {
                if (Bytes.compareTo((byte[])currentKey, (int)offset, (int)length, (byte[])this.endKey, (int)0, (int)this.endKeyLength) < 0) {
                    return this.getIncludeReturnCode();
                }
                if (this.slots.get(nSlots - 1).get(this.position[nSlots - 1]).isSingleKey()) {
                    if (this.nextPosition(nSlots - 1) < 0) {
                        this.isDone = true;
                        return Filter.ReturnCode.NEXT_ROW;
                    }
                } else {
                    int earliestRangeIndex = nSlots - 1;
                    for (int i2 = 0; i2 < nSlots; ++i2) {
                        if (this.slots.get(i2).get(this.position[i2]).isSingleKey()) continue;
                        earliestRangeIndex = i2;
                        break;
                    }
                    Arrays.fill(this.position, earliestRangeIndex + 1, this.position.length, 0);
                }
            }
            this.endKeyLength = 0;
            if (this.isDone) {
                return Filter.ReturnCode.NEXT_ROW;
            }
            i = 0;
            seek = false;
            int earliestRangeIndex = nSlots - 1;
            minOffset = offset;
            int maxOffset = this.schema.iterator(currentKey, minOffset, length, this.ptr);
            this.schema.next(this.ptr, ScanUtil.getRowKeyPosition(this.slotSpan, i), maxOffset, this.slotSpan[i]);
            while (true) {
                ScanUtil.BytesComparator comparator = ScanUtil.getComparator(this.schema.getField(ScanUtil.getRowKeyPosition(this.slotSpan, i)));
                while (this.position[i] < this.slots.get(i).size() && this.slots.get(i).get(this.position[i]).compareUpperToLowerBound(this.ptr, comparator) < 0) {
                    int n = i;
                    this.position[n] = this.position[n] + 1;
                }
                Arrays.fill(this.position, i + 1, this.position.length, 0);
                if (this.position[i] >= this.slots.get(i).size()) {
                    int j;
                    if (terminate == Terminate.AT) {
                        return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
                    }
                    if (i == 0) {
                        this.isDone = true;
                        return Filter.ReturnCode.NEXT_ROW;
                    }
                    seek = true;
                    Arrays.fill(this.position, i, this.position.length, 0);
                    boolean incremented = false;
                    for (j = i - 1; j >= 0 && this.slots.get(j).get(this.position[j]).isSingleKey(); --j) {
                        incremented = true;
                        if (!true || (this.position[j] = (this.position[j] + 1) % this.slots.get(j).size()) != 0) break;
                        incremented = false;
                    }
                    if (j < 0) {
                        this.isDone = true;
                        return Filter.ReturnCode.NEXT_ROW;
                    }
                    if (incremented) {
                        this.setStartKey();
                        this.schema.reposition(this.ptr, ScanUtil.getRowKeyPosition(this.slotSpan, i), ScanUtil.getRowKeyPosition(this.slotSpan, j), minOffset, maxOffset, this.slotSpan[j]);
                    } else {
                        this.schema.reposition(this.ptr, ScanUtil.getRowKeyPosition(this.slotSpan, i), ScanUtil.getRowKeyPosition(this.slotSpan, j + 1), minOffset, maxOffset, this.slotSpan[j + 1]);
                        int currentLength = this.setStartKey(this.ptr, minOffset, j + 1, nSlots, false);
                        minOffset = 0;
                        maxOffset = this.startKeyLength;
                        this.schema.iterator(this.startKey, minOffset, maxOffset, this.ptr, ScanUtil.getRowKeyPosition(this.slotSpan, j) + 1, this.slotSpan[j]);
                        ByteUtil.nextKey(this.startKey, currentLength);
                    }
                    i = j;
                    continue;
                }
                if (this.slots.get(i).get(this.position[i]).compareLowerToUpperBound(this.ptr, comparator) > 0) {
                    this.setStartKey(this.ptr, minOffset, i, nSlots, false);
                    return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
                }
                if (!this.slots.get(i).get(this.position[i]).isSingleKey() && i < earliestRangeIndex) {
                    earliestRangeIndex = i;
                }
                if (i == nSlots - 1 || seek) break block20;
                if (this.schema.next(this.ptr, ScanUtil.getRowKeyPosition(this.slotSpan, ++i), maxOffset, this.slotSpan[i]) == null) break;
            }
            if (!this.allTrailingNulls(i)) {
                this.setStartKey(this.ptr, minOffset, i, nSlots, true);
                return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
            }
        }
        if (seek) {
            return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
        }
        this.setEndKey(this.ptr, minOffset, i);
        return this.getIncludeReturnCode();
    }

    private boolean allTrailingNulls(int i) {
        while (i < this.slots.size()) {
            List<KeyRange> keyRanges = this.slots.get(i);
            if (keyRanges.size() != 1) {
                return false;
            }
            KeyRange keyRange = keyRanges.get(0);
            if (!keyRange.isSingleKey()) {
                return false;
            }
            if (keyRange.getLowerRange().length != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int nextPosition(int i) {
        while (i >= 0 && this.slots.get(i).get(this.position[i]).isSingleKey() && (this.position[i] = (this.position[i] + 1) % this.slots.get(i).size()) == 0) {
            --i;
        }
        return i;
    }

    private void setStartKey() {
        this.startKeyLength = this.setKey(KeyRange.Bound.LOWER, this.startKey, 0, 0);
    }

    private int setStartKey(ImmutableBytesWritable ptr, int offset, int i, int nSlots, boolean atEndOfKey) {
        ValueSchema.Field field;
        int length = ptr.getOffset() - offset;
        this.startKey = SkipScanFilter.copyKey(this.startKey, length + this.maxKeyLength, ptr.get(), offset, length);
        this.startKeyLength = length;
        if (atEndOfKey && i > 0 && i - 1 < nSlots && !(field = this.schema.getField(i - 1)).getDataType().isFixedWidth()) {
            this.startKey[this.startKeyLength++] = SchemaUtil.getSeparatorByte(this.schema.rowKeyOrderOptimizable(), true, field);
        }
        this.startKeyLength += this.setKey(KeyRange.Bound.LOWER, this.startKey, this.startKeyLength, i);
        return length;
    }

    private int setEndKey(ImmutableBytesWritable ptr, int offset, int i) {
        int length = ptr.getOffset() - offset;
        this.endKey = SkipScanFilter.copyKey(this.endKey, length + this.maxKeyLength, ptr.get(), offset, length);
        this.endKeyLength = length;
        this.endKeyLength += this.setKey(KeyRange.Bound.UPPER, this.endKey, length, i);
        return length;
    }

    private int setKey(KeyRange.Bound bound, byte[] key, int keyOffset, int slotStartIndex) {
        return ScanUtil.setKey(this.schema, this.slots, this.slotSpan, this.position, bound, key, keyOffset, slotStartIndex, this.position.length);
    }

    private static byte[] copyKey(byte[] targetKey, int targetLength, byte[] sourceKey, int offset, int length) {
        if (targetLength > targetKey.length) {
            targetKey = new byte[targetLength];
        }
        System.arraycopy(sourceKey, offset, targetKey, 0, length);
        return targetKey;
    }

    public void readFields(DataInput in) throws IOException {
        RowKeySchema schema = new RowKeySchema();
        schema.readFields(in);
        int andLen = in.readInt();
        boolean includeMultipleVersions = false;
        if (andLen < 0) {
            andLen = -andLen;
            includeMultipleVersions = true;
        }
        int[] slotSpan = new int[andLen];
        ArrayList slots = Lists.newArrayListWithExpectedSize((int)andLen);
        for (int i = 0; i < andLen; ++i) {
            int orLenWithSlotSpan;
            int orLen = orLenWithSlotSpan = in.readInt();
            if (orLenWithSlotSpan < 0) {
                orLenWithSlotSpan = -orLenWithSlotSpan - 1;
                slotSpan[i] = orLenWithSlotSpan >>> 21;
                orLen = orLenWithSlotSpan << 11 >>> 11;
            }
            ArrayList orClause = Lists.newArrayListWithExpectedSize((int)orLen);
            slots.add(orClause);
            for (int j = 0; j < orLen; ++j) {
                KeyRange range = KeyRange.read(in);
                orClause.add(range);
            }
        }
        this.init(slots, slotSpan, schema, includeMultipleVersions);
    }

    public void write(DataOutput out) throws IOException {
        assert (this.slots.size() == this.slotSpan.length);
        this.schema.write(out);
        int nSlots = this.slots.size();
        out.writeInt(this.includeMultipleVersions ? -nSlots : nSlots);
        for (int i = 0; i < nSlots; ++i) {
            List<KeyRange> orLen = this.slots.get(i);
            int span = this.slotSpan[i];
            int orLenWithSlotSpan = -((span << 21 | orLen.size()) + 1);
            out.writeInt(orLenWithSlotSpan);
            for (KeyRange range : orLen) {
                range.write(out);
            }
        }
    }

    public byte[] toByteArray() throws IOException {
        return Writables.getBytes((Writable)this);
    }

    public static SkipScanFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        try {
            return (SkipScanFilter)Writables.getWritable((byte[])pbBytes, (Writable)new SkipScanFilter());
        }
        catch (IOException e) {
            throw new DeserializationException((Throwable)e);
        }
    }

    public int hashCode() {
        HashFunction hf = Hashing.goodFastHash((int)32);
        Hasher h = hf.newHasher();
        h.putInt(this.slots.size());
        for (int i = 0; i < this.slots.size(); ++i) {
            h.putInt(this.slots.get(i).size());
            for (int j = 0; j < this.slots.size(); ++j) {
                h.putBytes(this.slots.get(i).get(j).getLowerRange());
                h.putBytes(this.slots.get(i).get(j).getUpperRange());
            }
        }
        return h.hash().asInt();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SkipScanFilter)) {
            return false;
        }
        SkipScanFilter other = (SkipScanFilter)((Object)obj);
        return Objects.equal(this.slots, other.slots) && Objects.equal((Object)this.schema, (Object)other.schema);
    }

    public String toString() {
        return "SkipScanFilter " + this.slots.toString();
    }

    private static enum Terminate {
        AT,
        AFTER;

    }
}

