/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered;

import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.hbase.index.builder.BaseIndexBuilder;
import org.apache.phoenix.hbase.index.covered.Batch;
import org.apache.phoenix.hbase.index.covered.IndexMetaData;
import org.apache.phoenix.hbase.index.covered.IndexUpdate;
import org.apache.phoenix.hbase.index.covered.LocalTableState;
import org.apache.phoenix.hbase.index.covered.data.LocalHBaseState;
import org.apache.phoenix.hbase.index.covered.data.LocalTable;
import org.apache.phoenix.hbase.index.covered.update.ColumnTracker;
import org.apache.phoenix.hbase.index.covered.update.IndexUpdateManager;

public class NonTxIndexBuilder
extends BaseIndexBuilder {
    private static final Log LOG = LogFactory.getLog(NonTxIndexBuilder.class);
    protected LocalHBaseState localTable;

    @Override
    public void setup(RegionCoprocessorEnvironment env) throws IOException {
        super.setup(env);
        this.localTable = new LocalTable(env);
    }

    @Override
    public Collection<Pair<Mutation, byte[]>> getIndexUpdate(Mutation mutation, IndexMetaData indexMetaData) throws IOException {
        LocalTableState state2 = new LocalTableState(this.env, this.localTable, mutation);
        IndexUpdateManager manager = new IndexUpdateManager(indexMetaData);
        this.batchMutationAndAddUpdates(manager, state2, mutation, indexMetaData);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Found index updates for Mutation: " + mutation + "\n" + manager));
        }
        return manager.toMap();
    }

    private void batchMutationAndAddUpdates(IndexUpdateManager manager, LocalTableState state2, Mutation m, IndexMetaData indexMetaData) throws IOException {
        Collection<Batch> batches = this.createTimestampBatchesFromMutation(m);
        boolean cleanupCurrentState = !indexMetaData.isImmutableRows();
        for (Batch batch : batches) {
            if (!this.addMutationsForBatch(manager, batch, state2, cleanupCurrentState, indexMetaData)) continue;
            cleanupCurrentState = false;
        }
    }

    protected Collection<Batch> createTimestampBatchesFromMutation(Mutation m) {
        HashMap<Long, Batch> batches = new HashMap<Long, Batch>();
        for (List family : m.getFamilyCellMap().values()) {
            List familyKVs = KeyValueUtil.ensureKeyValues((List)family);
            this.createTimestampBatchesFromKeyValues(familyKVs, batches);
        }
        ArrayList<Batch> sorted = new ArrayList<Batch>(batches.values());
        Collections.sort(sorted, new Comparator<Batch>(){

            @Override
            public int compare(Batch o1, Batch o2) {
                return Longs.compare((long)o1.getTimestamp(), (long)o2.getTimestamp());
            }
        });
        return sorted;
    }

    protected void createTimestampBatchesFromKeyValues(Collection<KeyValue> kvs, Map<Long, Batch> batches) {
        long now = EnvironmentEdgeManager.currentTime();
        byte[] nowBytes = Bytes.toBytes((long)now);
        for (KeyValue kv : kvs) {
            Batch batch;
            long ts = kv.getTimestamp();
            if (kv.updateLatestStamp(nowBytes)) {
                ts = now;
            }
            if ((batch = batches.get(ts)) == null) {
                batch = new Batch(ts);
                batches.put(ts, batch);
            }
            batch.add(kv);
        }
    }

    private boolean addMutationsForBatch(IndexUpdateManager updateMap, Batch batch, LocalTableState state2, boolean requireCurrentStateCleanup, IndexMetaData indexMetaData) throws IOException {
        long batchTs = batch.getTimestamp();
        state2.setPendingUpdates(batch.getKvs());
        if (!indexMetaData.isImmutableRows()) {
            this.addCleanupForCurrentBatch(updateMap, batchTs, state2, indexMetaData);
        }
        state2.applyPendingUpdates();
        long minTs = this.addUpdateForGivenTimestamp(batchTs, state2, updateMap, indexMetaData);
        if (ColumnTracker.isNewestTime(minTs)) {
            return false;
        }
        while (!ColumnTracker.isNewestTime(minTs)) {
            minTs = this.addUpdateForGivenTimestamp(minTs, state2, updateMap, indexMetaData);
        }
        if (requireCurrentStateCleanup) {
            state2.rollback(batch.getKvs());
            state2.setPendingUpdates(batch.getKvs());
            this.cleanupIndexStateFromBatchOnward(updateMap, batchTs, state2, indexMetaData);
            state2.applyPendingUpdates();
            return true;
        }
        return false;
    }

    private long addUpdateForGivenTimestamp(long ts, LocalTableState state2, IndexUpdateManager updateMap, IndexMetaData indexMetaData) throws IOException {
        state2.setCurrentTimestamp(ts);
        ts = this.addCurrentStateMutationsForBatch(updateMap, state2, indexMetaData);
        return ts;
    }

    private void addCleanupForCurrentBatch(IndexUpdateManager updateMap, long batchTs, LocalTableState state2, IndexMetaData indexMetaData) throws IOException {
        state2.setCurrentTimestamp(batchTs);
        this.addDeleteUpdatesToMap(updateMap, state2, batchTs, indexMetaData);
        state2.resetTrackedColumns();
    }

    private long addCurrentStateMutationsForBatch(IndexUpdateManager updateMap, LocalTableState state2, IndexMetaData indexMetaData) throws IOException {
        Iterable<IndexUpdate> upserts = this.codec.getIndexUpserts(state2, indexMetaData);
        state2.resetTrackedColumns();
        long minTs = Long.MAX_VALUE;
        ArrayList<ColumnTracker> columnHints = new ArrayList<ColumnTracker>();
        for (IndexUpdate update : upserts) {
            ColumnTracker tracker = update.getIndexedColumns();
            long trackerTs = tracker.getTS();
            if (trackerTs < minTs) {
                minTs = tracker.getTS();
            }
            boolean needsCleanup = false;
            if (tracker.hasNewerTimestamps()) {
                columnHints.add(tracker);
                needsCleanup = true;
            }
            if (!update.isValid()) continue;
            byte[] table = update.getTableName();
            Mutation mutation = update.getUpdate();
            updateMap.addIndexUpdate(table, mutation);
            if (!needsCleanup) continue;
            Delete d = new Delete(mutation.getRow());
            d.setTimestamp(tracker.getTS());
            updateMap.addIndexUpdate(table, (Mutation)d);
        }
        return minTs;
    }

    private void cleanupIndexStateFromBatchOnward(IndexUpdateManager updateMap, long batchTs, LocalTableState state2, IndexMetaData indexMetaData) throws IOException {
        state2.setCurrentTimestamp(batchTs);
        this.addDeleteUpdatesToMap(updateMap, state2, batchTs, indexMetaData);
        Set<ColumnTracker> trackers = state2.getTrackedColumns();
        long minTs = Long.MAX_VALUE;
        for (ColumnTracker tracker : trackers) {
            if (tracker.getTS() >= minTs) continue;
            minTs = tracker.getTS();
        }
        state2.resetTrackedColumns();
        if (!ColumnTracker.isNewestTime(minTs)) {
            state2.setHints(Lists.newArrayList(trackers));
            this.cleanupIndexStateFromBatchOnward(updateMap, minTs, state2, indexMetaData);
        }
    }

    protected void addDeleteUpdatesToMap(IndexUpdateManager updateMap, LocalTableState state2, long ts, IndexMetaData indexMetaData) throws IOException {
        if (indexMetaData.isImmutableRows()) {
            return;
        }
        Iterable<IndexUpdate> cleanup = this.codec.getIndexDeletes(state2, indexMetaData);
        if (cleanup != null) {
            for (IndexUpdate d : cleanup) {
                if (!d.isValid()) continue;
                Delete remove = (Delete)d.getUpdate();
                remove.setTimestamp(ts);
                updateMap.addIndexUpdate(d.getTableName(), (Mutation)remove);
            }
        }
    }

    @Override
    public Collection<Pair<Mutation, byte[]>> getIndexUpdateForFilteredRows(Collection<KeyValue> filtered, IndexMetaData indexMetaData) throws IOException {
        return null;
    }
}

