/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered.data;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.scanner.Scanner;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;

public class LazyValueGetter
implements ValueGetter {
    private Scanner scan;
    private volatile Map<ColumnReference, ImmutableBytesWritable> values;
    private byte[] row;

    public LazyValueGetter(Scanner scan, byte[] currentRow) {
        this.scan = scan;
        this.row = currentRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableBytesWritable getLatestValue(ColumnReference ref) throws IOException {
        ImmutableBytesWritable value;
        if (this.values == null) {
            LazyValueGetter lazyValueGetter = this;
            synchronized (lazyValueGetter) {
                this.values = Collections.synchronizedMap(new HashMap());
            }
        }
        if ((value = this.values.get(ref)) == null) {
            value = this.get(ref);
            this.values.put(ref, value);
        }
        return value;
    }

    private ImmutableBytesPtr get(ColumnReference ref) throws IOException {
        KeyValue first = ref.getFirstKeyValueForRow(this.row);
        if (!this.scan.seek((Cell)first)) {
            return null;
        }
        Cell next = this.scan.next();
        if (ref.matches((Cell)KeyValueUtil.ensureKeyValue((Cell)next))) {
            return new ImmutableBytesPtr(next.getValueArray(), next.getValueOffset(), next.getValueLength());
        }
        return null;
    }

    @Override
    public byte[] getRowKey() {
        return this.row;
    }
}

