/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered.example;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.covered.example.CoveredColumn;

public class ColumnGroup
implements Iterable<CoveredColumn> {
    private List<CoveredColumn> columns = new ArrayList<CoveredColumn>();
    private String table;

    public ColumnGroup(String tableName) {
        this.table = tableName;
    }

    public void add(CoveredColumn column) {
        this.columns.add(column);
    }

    public String getTable() {
        return this.table;
    }

    public boolean matches(String family) {
        for (CoveredColumn column : this.columns) {
            if (!column.matchesFamily(family)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(byte[] family, byte[] qualifier) {
        String fam = Bytes.toString((byte[])family);
        for (CoveredColumn column : this.columns) {
            if (!column.matchesFamily(fam) || !column.matchesQualifier(qualifier)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.columns.size();
    }

    @Override
    public Iterator<CoveredColumn> iterator() {
        return this.columns.iterator();
    }

    public CoveredColumn getColumnForTesting(int index) {
        return this.columns.get(index);
    }

    public String toString() {
        return "ColumnGroup - table: " + this.table + ", columns: " + this.columns;
    }

    public List<CoveredColumn> getColumns() {
        return this.columns;
    }
}

