/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered.example;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.hbase.index.builder.BaseIndexCodec;
import org.apache.phoenix.hbase.index.covered.IndexMetaData;
import org.apache.phoenix.hbase.index.covered.IndexUpdate;
import org.apache.phoenix.hbase.index.covered.LocalTableState;
import org.apache.phoenix.hbase.index.covered.TableState;
import org.apache.phoenix.hbase.index.covered.example.ColumnGroup;
import org.apache.phoenix.hbase.index.covered.example.CoveredColumn;
import org.apache.phoenix.hbase.index.covered.example.CoveredColumnIndexSpecifierBuilder;
import org.apache.phoenix.hbase.index.scanner.Scanner;

public class CoveredColumnIndexCodec
extends BaseIndexCodec {
    private static final byte[] EMPTY_BYTES = new byte[0];
    public static final byte[] INDEX_ROW_COLUMN_FAMILY = Bytes.toBytes((String)"INDEXED_COLUMNS");
    private List<ColumnGroup> groups;

    public static CoveredColumnIndexCodec getCodecForTesting(List<ColumnGroup> groups) {
        CoveredColumnIndexCodec codec = new CoveredColumnIndexCodec();
        codec.groups = Lists.newArrayList(groups);
        return codec;
    }

    @Override
    public void initialize(RegionCoprocessorEnvironment env) {
        this.groups = CoveredColumnIndexSpecifierBuilder.getColumns(env.getConfiguration());
    }

    @Override
    public Iterable<IndexUpdate> getIndexUpserts(TableState state2, IndexMetaData indexMetaData) {
        ArrayList<IndexUpdate> updates = new ArrayList<IndexUpdate>();
        for (ColumnGroup group : this.groups) {
            IndexUpdate update = this.getIndexUpdateForGroup(group, state2, indexMetaData);
            updates.add(update);
        }
        return updates;
    }

    private IndexUpdate getIndexUpdateForGroup(ColumnGroup group, TableState state2, IndexMetaData indexMetaData) {
        List<CoveredColumn> refs = group.getColumns();
        try {
            Pair<Scanner, IndexUpdate> stateInfo = ((LocalTableState)state2).getIndexedColumnsTableState(refs, false, false, indexMetaData);
            Scanner kvs = (Scanner)stateInfo.getFirst();
            Pair<Integer, List<ColumnEntry>> columns = this.getNextEntries(refs, kvs, state2.getCurrentRowKey());
            kvs.close();
            if ((Integer)columns.getFirst() == 0) {
                return (IndexUpdate)stateInfo.getSecond();
            }
            byte[] rowKey = CoveredColumnIndexCodec.composeRowKey(state2.getCurrentRowKey(), (Integer)columns.getFirst(), (List)columns.getSecond());
            Put p = new Put(rowKey, state2.getCurrentTimestamp());
            CoveredColumnIndexCodec.addColumnsToPut(p, (List)columns.getSecond());
            IndexUpdate update = (IndexUpdate)stateInfo.getSecond();
            update.setTable(Bytes.toBytes((String)group.getTable()));
            update.setUpdate((Mutation)p);
            return update;
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception when getting state for columns: " + refs);
        }
    }

    private static void addColumnsToPut(Put indexInsert, List<ColumnEntry> columns) {
        int count = 0;
        for (ColumnEntry column : columns) {
            indexInsert.add(INDEX_ROW_COLUMN_FAMILY, ArrayUtils.addAll((byte[])Bytes.toBytes((int)count++), (byte[])CoveredColumnIndexCodec.toIndexQualifier(column.ref)), null);
        }
    }

    private static byte[] toIndexQualifier(CoveredColumn column) {
        return ArrayUtils.addAll((byte[])Bytes.toBytes((String)(column.familyString + ":")), (byte[])column.getQualifier());
    }

    @Override
    public Iterable<IndexUpdate> getIndexDeletes(TableState state2, IndexMetaData context) {
        ArrayList<IndexUpdate> deletes = new ArrayList<IndexUpdate>();
        for (ColumnGroup group : this.groups) {
            deletes.add(this.getDeleteForGroup(group, state2, context));
        }
        return deletes;
    }

    private IndexUpdate getDeleteForGroup(ColumnGroup group, TableState state2, IndexMetaData indexMetaData) {
        List<CoveredColumn> refs = group.getColumns();
        try {
            Pair<Scanner, IndexUpdate> kvs = ((LocalTableState)state2).getIndexedColumnsTableState(refs, false, false, indexMetaData);
            Pair<Integer, List<ColumnEntry>> columns = this.getNextEntries(refs, (Scanner)kvs.getFirst(), state2.getCurrentRowKey());
            ((Scanner)kvs.getFirst()).close();
            if ((Integer)columns.getFirst() == 0) {
                return (IndexUpdate)kvs.getSecond();
            }
            byte[] rowKey = CoveredColumnIndexCodec.composeRowKey(state2.getCurrentRowKey(), (Integer)columns.getFirst(), (List)columns.getSecond());
            Delete d = new Delete(rowKey);
            d.setTimestamp(state2.getCurrentTimestamp());
            IndexUpdate update = (IndexUpdate)kvs.getSecond();
            update.setUpdate((Mutation)d);
            update.setTable(Bytes.toBytes((String)group.getTable()));
            return update;
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception when getting state for columns: " + refs);
        }
    }

    private Pair<Integer, List<ColumnEntry>> getNextEntries(List<CoveredColumn> refs, Scanner kvs, byte[] currentRow) throws IOException {
        int totalValueLength = 0;
        ArrayList<ColumnEntry> entries = new ArrayList<ColumnEntry>(refs.size());
        for (CoveredColumn ref : refs) {
            byte[] v;
            KeyValue first = ref.getFirstKeyValueForRow(currentRow);
            if (!kvs.seek((Cell)first)) {
                entries.add(new ColumnEntry(null, ref));
                continue;
            }
            Cell next = kvs.next();
            if (ref.matchesFamily(next.getFamily()) && ref.matchesQualifier(next.getQualifier())) {
                v = next.getValue();
                totalValueLength += v.length;
            } else {
                entries.add(new ColumnEntry(null, ref));
                continue;
            }
            entries.add(new ColumnEntry(v, ref));
            if (!ref.allColumns()) continue;
            byte[] lastQual = next.getQualifier();
            byte[] nextQual = null;
            while ((next = kvs.next()) != null && ref.matchesFamily(next.getFamily())) {
                nextQual = next.getQualifier();
                if (Arrays.equals(lastQual, nextQual)) continue;
                byte[] v2 = next.getValue();
                totalValueLength += v2.length;
                entries.add(new ColumnEntry(v2, ref));
                lastQual = nextQual;
            }
        }
        return new Pair((Object)totalValueLength, entries);
    }

    static byte[] composeRowKey(byte[] pk, int length, List<ColumnEntry> values) {
        byte[] output = new byte[length + pk.length];
        int pos = 0;
        int[] lengths = new int[values.size()];
        int i = 0;
        for (ColumnEntry entry : values) {
            byte[] v = entry.value;
            if (v.length != 0) {
                System.arraycopy(v, 0, output, pos, v.length);
                pos += v.length;
            }
            lengths[i++] = v.length;
        }
        System.arraycopy(pk, 0, output, pos, pk.length);
        for (int l : lengths) {
            output = ArrayUtils.addAll((byte[])output, (byte[])Bytes.toBytes((int)l));
        }
        return ArrayUtils.addAll((byte[])output, (byte[])Bytes.toBytes((int)values.size()));
    }

    public static List<KeyValue> getIndexKeyValueForTesting(byte[] pk, long timestamp, List<Pair<byte[], CoveredColumn>> values) {
        int length = 0;
        ArrayList<ColumnEntry> expected = new ArrayList<ColumnEntry>(values.size());
        for (Pair<byte[], CoveredColumn> value : values) {
            ColumnEntry entry = new ColumnEntry((byte[])value.getFirst(), (CoveredColumn)value.getSecond());
            length += ((byte[])value.getFirst()).length;
            expected.add(entry);
        }
        byte[] rowKey = CoveredColumnIndexCodec.composeRowKey(pk, length, expected);
        Put p = new Put(rowKey, timestamp);
        CoveredColumnIndexCodec.addColumnsToPut(p, expected);
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        for (Map.Entry entry : p.getFamilyMap().entrySet()) {
            kvs.addAll((Collection)entry.getValue());
        }
        return kvs;
    }

    public static List<byte[]> getValues(byte[] bytes) {
        int keyCount = CoveredColumnIndexCodec.getPreviousInteger(bytes, bytes.length);
        ArrayList<byte[]> keys = new ArrayList<byte[]>(keyCount);
        int[] lengths = new int[keyCount];
        int lengthPos = keyCount - 1;
        int pos = bytes.length - 4;
        for (int i = 0; i < keyCount; ++i) {
            lengths[lengthPos--] = CoveredColumnIndexCodec.getPreviousInteger(bytes, pos);
            pos -= 4;
        }
        int current = 0;
        for (int length : lengths) {
            byte[] key = Arrays.copyOfRange(bytes, current, current + length);
            keys.add(key);
            current += length;
        }
        return keys;
    }

    private static int getPreviousInteger(byte[] bytes, int start) {
        return Bytes.toInt((byte[])bytes, (int)(start - 4));
    }

    public static boolean checkRowKeyForAllNulls(byte[] bytes) {
        int keyCount = CoveredColumnIndexCodec.getPreviousInteger(bytes, bytes.length);
        int pos = bytes.length - 4;
        for (int i = 0; i < keyCount; ++i) {
            int next = CoveredColumnIndexCodec.getPreviousInteger(bytes, pos);
            if (next > 0) {
                return false;
            }
            pos -= 4;
        }
        return true;
    }

    @Override
    public boolean isEnabled(Mutation m) {
        return this.groups.size() > 0;
    }

    static class ColumnEntry {
        byte[] value = CoveredColumnIndexCodec.access$000();
        CoveredColumn ref;

        public ColumnEntry(byte[] value, CoveredColumn ref) {
            this.value = value == null ? EMPTY_BYTES : value;
            this.ref = ref;
        }
    }
}

