/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.table;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.map.AbstractLinkedMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.phoenix.execute.DelegateHTable;
import org.apache.phoenix.hbase.index.table.HTableFactory;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;

public class CachingHTableFactory
implements HTableFactory {
    private static final Log LOG = LogFactory.getLog(CachingHTableFactory.class);
    private static final String CACHE_SIZE_KEY = "index.tablefactory.cache.size";
    private static final int DEFAULT_CACHE_SIZE = 1000;
    private HTableFactory delegate;
    Map openTables;
    private ThreadPoolExecutor pool;

    public static int getCacheSize(Configuration conf) {
        return conf.getInt(CACHE_SIZE_KEY, 1000);
    }

    public CachingHTableFactory(HTableFactory tableFactory, Configuration conf, RegionCoprocessorEnvironment env) {
        this(tableFactory, CachingHTableFactory.getCacheSize(conf), env);
    }

    public CachingHTableFactory(HTableFactory factory, int cacheSize, RegionCoprocessorEnvironment env) {
        this.delegate = factory;
        this.openTables = new HTableInterfaceLRUMap(cacheSize);
        this.pool = new ThreadPoolExecutor(1, env.getConfiguration().getInt("phoenix.index.writes.threads.max", Integer.MAX_VALUE), (long)env.getConfiguration().getInt("hbase.htable.threads.keepalivetime", 60), TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Threads.newDaemonThreadFactory((String)"CachedHtables"));
        this.pool.allowCoreThreadTimeOut(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTableInterface getTable(ImmutableBytesPtr tablename, ExecutorService pool) throws IOException {
        ImmutableBytesPtr tableBytes = new ImmutableBytesPtr(tablename);
        Map map = this.openTables;
        synchronized (map) {
            CachedHTableWrapper table = (CachedHTableWrapper)this.openTables.get((Object)tableBytes);
            if (table == null) {
                table = new CachedHTableWrapper(this.delegate.getTable(tablename, pool));
                this.openTables.put(tableBytes, table);
            }
            table.incrementReferenceCount();
            return table;
        }
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
        this.pool.shutdown();
        try {
            boolean terminated = false;
            while (!(terminated = this.pool.awaitTermination(60L, TimeUnit.SECONDS))) {
            }
        }
        catch (InterruptedException e) {
            this.pool.shutdownNow();
            LOG.warn((Object)"waitForTermination interrupted");
        }
    }

    @Override
    public HTableInterface getTable(ImmutableBytesPtr tablename) throws IOException {
        return this.getTable(tablename, this.pool);
    }

    @VisibleForTesting
    public ThreadPoolExecutor getPool() {
        return this.pool;
    }

    public static class CachedHTableWrapper
    extends DelegateHTable {
        private AtomicInteger referenceCount = new AtomicInteger();

        public CachedHTableWrapper(HTableInterface table) {
            super(table);
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.getReferenceCount() > 0) {
                this.referenceCount.decrementAndGet();
            } else {
                super.close();
            }
        }

        public void incrementReferenceCount() {
            this.referenceCount.incrementAndGet();
        }

        public int getReferenceCount() {
            return this.referenceCount.get();
        }
    }

    public class HTableInterfaceLRUMap
    extends LRUMap {
        public HTableInterfaceLRUMap(int cacheSize) {
            super(cacheSize, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean removeLRU(AbstractLinkedMap.LinkEntry entry) {
            HTableInterface table = (HTableInterface)entry.getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Closing connection to table: " + Bytes.toString((byte[])table.getTableName()) + " because it was evicted from the cache."));
            }
            try {
                HTableInterfaceLRUMap hTableInterfaceLRUMap = this;
                synchronized (hTableInterfaceLRUMap) {
                    if (((CachedHTableWrapper)table).getReferenceCount() <= 0) {
                        table.close();
                        return true;
                    }
                }
            }
            catch (IOException e) {
                LOG.info((Object)("Failed to correctly close HTable: " + Bytes.toString((byte[])table.getTableName()) + " ignoring since being removed from queue."));
            }
            return false;
        }
    }
}

