/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.write;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.phoenix.hbase.index.table.CoprocessorHTableFactory;
import org.apache.phoenix.hbase.index.table.HTableFactory;
import org.apache.phoenix.hbase.index.util.IndexManagementUtil;

public class IndexWriterUtils {
    private static final Log LOG = LogFactory.getLog(IndexWriterUtils.class);
    private static final String INDEX_WRITER_PER_TABLE_THREADS_CONF_KEY = "index.writer.threads.pertable.max";
    private static final int DEFAULT_NUM_PER_TABLE_THREADS = Integer.MAX_VALUE;
    public static final String HTABLE_THREAD_KEY = "hbase.htable.threads.max";
    public static final String INDEX_WRITES_THREAD_MAX_PER_REGIONSERVER_KEY = "phoenix.index.writes.threads.max";
    public static final String HTABLE_KEEP_ALIVE_KEY = "hbase.htable.threads.keepalivetime";

    private IndexWriterUtils() {
    }

    public static HTableFactory getDefaultDelegateHTableFactory(CoprocessorEnvironment env) {
        Configuration conf = env.getConfiguration();
        int htableThreads = conf.getInt(INDEX_WRITER_PER_TABLE_THREADS_CONF_KEY, Integer.MAX_VALUE);
        LOG.trace((Object)("Creating HTableFactory with " + htableThreads + " threads for each HTable."));
        IndexManagementUtil.setIfNotSet(conf, HTABLE_THREAD_KEY, htableThreads);
        return new CoprocessorHTableFactory(env);
    }
}

