/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.write.recovery;

import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.phoenix.hbase.index.CapturingAbortable;
import org.apache.phoenix.hbase.index.exception.MultiIndexWriteFailureException;
import org.apache.phoenix.hbase.index.exception.SingleIndexWriteFailureException;
import org.apache.phoenix.hbase.index.parallel.EarlyExitFailure;
import org.apache.phoenix.hbase.index.parallel.Task;
import org.apache.phoenix.hbase.index.parallel.TaskBatch;
import org.apache.phoenix.hbase.index.parallel.TaskRunner;
import org.apache.phoenix.hbase.index.parallel.ThreadPoolBuilder;
import org.apache.phoenix.hbase.index.parallel.ThreadPoolManager;
import org.apache.phoenix.hbase.index.parallel.WaitForCompletionTaskRunner;
import org.apache.phoenix.hbase.index.table.CachingHTableFactory;
import org.apache.phoenix.hbase.index.table.HTableFactory;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;
import org.apache.phoenix.hbase.index.write.IndexCommitter;
import org.apache.phoenix.hbase.index.write.IndexWriter;
import org.apache.phoenix.hbase.index.write.IndexWriterUtils;
import org.apache.phoenix.util.IndexUtil;

public class TrackingParallelWriterIndexCommitter
implements IndexCommitter {
    private static final Log LOG = LogFactory.getLog(TrackingParallelWriterIndexCommitter.class);
    public static final String NUM_CONCURRENT_INDEX_WRITER_THREADS_CONF_KEY = "index.trackingwriter.threads.max";
    private static final int DEFAULT_CONCURRENT_INDEX_WRITER_THREADS = 10;
    private static final String INDEX_WRITER_KEEP_ALIVE_TIME_CONF_KEY = "index.trackingwriter.threads.keepalivetime";
    private TaskRunner pool;
    private HTableFactory factory;
    private CapturingAbortable abortable;
    private Stoppable stopped;
    private RegionCoprocessorEnvironment env;

    @Override
    public void setup(IndexWriter parent, RegionCoprocessorEnvironment env, String name) {
        this.env = env;
        Configuration conf = env.getConfiguration();
        this.setup(IndexWriterUtils.getDefaultDelegateHTableFactory((CoprocessorEnvironment)env), ThreadPoolManager.getExecutor(new ThreadPoolBuilder(name, conf).setMaxThread(NUM_CONCURRENT_INDEX_WRITER_THREADS_CONF_KEY, 10).setCoreTimeout(INDEX_WRITER_KEEP_ALIVE_TIME_CONF_KEY), env), (Abortable)env.getRegionServerServices(), parent, CachingHTableFactory.getCacheSize(conf), env);
    }

    void setup(HTableFactory factory, ExecutorService pool, Abortable abortable, Stoppable stop, int cacheSize, RegionCoprocessorEnvironment env) {
        this.pool = new WaitForCompletionTaskRunner(pool);
        this.factory = new CachingHTableFactory(factory, cacheSize, env);
        this.abortable = new CapturingAbortable(abortable);
        this.stopped = stop;
    }

    @Override
    public void write(Multimap<HTableInterfaceReference, Mutation> toWrite, final boolean allowLocalUpdates) throws MultiIndexWriteFailureException {
        Set entries = toWrite.asMap().entrySet();
        TaskBatch<Boolean> tasks = new TaskBatch<Boolean>(entries.size());
        ArrayList<HTableInterfaceReference> tables = new ArrayList<HTableInterfaceReference>(entries.size());
        for (Map.Entry entry : entries) {
            final List mutations = (List)entry.getValue();
            final HTableInterfaceReference tableReference = (HTableInterfaceReference)entry.getKey();
            final RegionCoprocessorEnvironment env = this.env;
            if (env != null && !allowLocalUpdates && tableReference.getTableName().equals(env.getRegion().getTableDesc().getNameAsString())) continue;
            tables.add(tableReference);
            tasks.add(new Task<Boolean>(){

                /*
                 * Unable to fully structure code
                 */
                @Override
                public Boolean call() throws Exception {
                    table = null;
                    try {
                        this.throwFailureIfDone();
                        if (!allowLocalUpdates || env == null || !tableReference.getTableName().equals(env.getRegion().getTableDesc().getNameAsString())) ** GOTO lbl14
                        try {
                            this.throwFailureIfDone();
                            IndexUtil.writeLocalUpdates(env.getRegion(), mutations, true);
                            var2_2 = Boolean.TRUE;
                            return var2_2;
                        }
                        catch (IOException ignord) {
                            try {
                                if (TrackingParallelWriterIndexCommitter.access$000().isTraceEnabled()) {
                                    TrackingParallelWriterIndexCommitter.access$000().trace((Object)("indexRegion.batchMutate failed and fall back to HTable.batch(). Got error=" + ignord));
                                }
lbl14:
                                // 4 sources

                                if (TrackingParallelWriterIndexCommitter.access$000().isTraceEnabled()) {
                                    TrackingParallelWriterIndexCommitter.access$000().trace((Object)("Writing index update:" + mutations + " to table: " + tableReference));
                                }
                                table = TrackingParallelWriterIndexCommitter.access$100(TrackingParallelWriterIndexCommitter.this).getTable(tableReference.get());
                                this.throwFailureIfDone();
                                table.batch(mutations);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                throw e;
                            }
                            catch (Exception e) {
                                throw e;
                            }
                            catch (Throwable var3_6) {
                                throw var3_6;
                            }
                        }
                    }
                    finally {
                        if (table != null) {
                            table.close();
                        }
                    }
                    return Boolean.TRUE;
                }

                private void throwFailureIfDone() throws SingleIndexWriteFailureException {
                    if (TrackingParallelWriterIndexCommitter.this.stopped.isStopped() || TrackingParallelWriterIndexCommitter.this.abortable.isAborted() || Thread.currentThread().isInterrupted()) {
                        throw new SingleIndexWriteFailureException("Pool closed, not attempting to write to the index!", null);
                    }
                }
            });
        }
        List results = null;
        try {
            LOG.debug((Object)"Waiting on index update tasks to complete...");
            results = this.pool.submitUninterruptible(tasks);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Should not fail on the results while using a WaitForCompletionTaskRunner", e);
        }
        catch (EarlyExitFailure e) {
            throw new RuntimeException("Stopped while waiting for batch, quiting!", e);
        }
        ArrayList failures = new ArrayList();
        int index = 0;
        for (Boolean result : results) {
            if (result == null) {
                failures.add(tables.get(index));
            }
            ++index;
        }
        if (failures.size() > 0) {
            throw new MultiIndexWriteFailureException(Collections.unmodifiableList(failures));
        }
    }

    public void stop(String why) {
        LOG.info((Object)("Shutting down " + this.getClass().getSimpleName()));
        this.pool.stop(why);
        this.factory.shutdown();
    }

    public boolean isStopped() {
        return this.stopped.isStopped();
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }

    static /* synthetic */ HTableFactory access$100(TrackingParallelWriterIndexCommitter x0) {
        return x0.factory;
    }
}

