/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.cache.IndexMetaDataCache;
import org.apache.phoenix.coprocessor.ServerCachingProtocol;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.memory.MemoryManager;
import org.apache.tephra.Transaction;

public class IndexMetaDataCacheFactory
implements ServerCachingProtocol.ServerCacheFactory {
    public void readFields(DataInput arg0) throws IOException {
    }

    public void write(DataOutput arg0) throws IOException {
    }

    @Override
    public Closeable newCache(ImmutableBytesWritable cachePtr, byte[] txState, final MemoryManager.MemoryChunk chunk, boolean useProtoForIndexMaintainer) throws SQLException {
        Transaction txn;
        final List<IndexMaintainer> maintainers = IndexMaintainer.deserialize(cachePtr, GenericKeyValueBuilder.INSTANCE, useProtoForIndexMaintainer);
        try {
            txn = txState.length != 0 ? MutationState.decodeTransaction(txState) : null;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return new IndexMetaDataCache(){

            @Override
            public void close() throws IOException {
                chunk.close();
            }

            @Override
            public List<IndexMaintainer> getIndexMaintainers() {
                return maintainers;
            }

            @Override
            public Transaction getTransaction() {
                return txn;
            }
        };
    }
}

