/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import com.google.common.collect.Multimap;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;
import org.apache.phoenix.hbase.index.write.DelegateIndexFailurePolicy;
import org.apache.phoenix.hbase.index.write.KillServerOnFailurePolicy;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;

public class PhoenixIndexFailurePolicy
extends DelegateIndexFailurePolicy {
    private static final Log LOG = LogFactory.getLog(PhoenixIndexFailurePolicy.class);
    public static final String DISABLE_INDEX_ON_WRITE_FAILURE = "DISABLE_INDEX_ON_WRITE_FAILURE";
    public static final String REBUILD_INDEX_ON_WRITE_FAILURE = "REBUILD_INDEX_ON_WRITE_FAILURE";
    public static final String BLOCK_DATA_TABLE_WRITES_ON_WRITE_FAILURE = "BLOCK_DATA_TABLE_WRITES_ON_WRITE_FAILURE";
    private RegionCoprocessorEnvironment env;
    private boolean blockDataTableWritesOnFailure;
    private boolean disableIndexOnFailure;
    private boolean rebuildIndexOnFailure;

    public PhoenixIndexFailurePolicy() {
        super(new KillServerOnFailurePolicy());
    }

    @Override
    public void setup(Stoppable parent, RegionCoprocessorEnvironment env) {
        String value;
        super.setup(parent, env);
        this.env = env;
        this.rebuildIndexOnFailure = env.getConfiguration().getBoolean("phoenix.index.failure.handling.rebuild", true);
        HTableDescriptor htd = env.getRegion().getTableDesc();
        if (this.rebuildIndexOnFailure && (value = htd.getValue(REBUILD_INDEX_ON_WRITE_FAILURE)) != null) {
            this.rebuildIndexOnFailure = Boolean.parseBoolean(value);
        }
        this.disableIndexOnFailure = (value = htd.getValue(DISABLE_INDEX_ON_WRITE_FAILURE)) == null ? env.getConfiguration().getBoolean("phoenix.index.failure.disable.index", true) : Boolean.parseBoolean(value);
        value = htd.getValue(BLOCK_DATA_TABLE_WRITES_ON_WRITE_FAILURE);
        this.blockDataTableWritesOnFailure = value == null ? env.getConfiguration().getBoolean("phoenix.index.failure.block.write", false) : Boolean.parseBoolean(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleFailure(Multimap<HTableInterfaceReference, Mutation> attempted, Exception cause) throws IOException {
        boolean throwing = true;
        long timestamp = Long.MAX_VALUE;
        try {
            timestamp = this.handleFailureWithExceptions(attempted, cause);
            throwing = false;
        }
        catch (Throwable t) {
            LOG.warn((Object)"handleFailure failed", t);
            super.handleFailure(attempted, cause);
            throwing = false;
        }
        finally {
            if (!throwing) {
                throw ServerUtil.wrapInDoNotRetryIOException("Unable to update the following indexes: " + attempted.keySet(), cause, timestamp);
            }
        }
    }

    private long handleFailureWithExceptions(Multimap<HTableInterfaceReference, Mutation> attempted, Exception cause) throws Throwable {
        Set refs = attempted.asMap().keySet();
        HashMap<String, Long> indexTableNames = new HashMap<String, Long>(refs.size());
        long timestamp = 0L;
        boolean leaveIndexActive = this.blockDataTableWritesOnFailure || !this.disableIndexOnFailure;
        for (HTableInterfaceReference ref : refs) {
            long minTimeStamp = 0L;
            Collection mutations = attempted.get((Object)ref);
            if (mutations != null) {
                for (Mutation mutation : mutations) {
                    for (List kvs : mutation.getFamilyCellMap().values()) {
                        for (Cell kv : kvs) {
                            if (minTimeStamp != 0L && (kv.getTimestamp() < 0L || minTimeStamp <= kv.getTimestamp())) continue;
                            minTimeStamp = kv.getTimestamp();
                        }
                    }
                }
            }
            timestamp = minTimeStamp;
            if (ref.getTableName().equals(this.env.getRegion().getTableDesc().getNameAsString()) && MetaDataUtil.hasLocalIndexColumnFamily(this.env.getRegion().getTableDesc())) {
                for (String string : this.getLocalIndexNames(ref, mutations)) {
                    indexTableNames.put(string, minTimeStamp);
                }
                continue;
            }
            indexTableNames.put(ref.getTableName(), minTimeStamp);
        }
        if (!this.disableIndexOnFailure && !this.rebuildIndexOnFailure) {
            return timestamp;
        }
        PIndexState newState = this.disableIndexOnFailure ? PIndexState.DISABLE : PIndexState.ACTIVE;
        for (Map.Entry tableTimeElement : indexTableNames.entrySet()) {
            HTableInterface hTableInterface;
            MetaDataProtocol.MetaDataMutationResult result;
            String indexTableName = (String)tableTimeElement.getKey();
            long minTimeStamp = (Long)tableTimeElement.getValue();
            if (!this.disableIndexOnFailure && !this.blockDataTableWritesOnFailure) {
                minTimeStamp *= -1L;
            }
            if ((result = IndexUtil.setIndexDisableTimeStamp(indexTableName, minTimeStamp, hTableInterface = this.env.getTable(SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, this.env.getConfiguration())), newState)).getMutationCode() == MetaDataProtocol.MutationCode.TABLE_NOT_FOUND) {
                LOG.info((Object)("Index " + indexTableName + " has been dropped. Ignore uncommitted mutations"));
                continue;
            }
            if (result.getMutationCode() != MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
                if (leaveIndexActive) {
                    LOG.warn((Object)("Attempt to update INDEX_DISABLE_TIMESTAMP  failed with code = " + (Object)((Object)result.getMutationCode())));
                    if (this.blockDataTableWritesOnFailure) {
                        throw new DoNotRetryIOException("Attempt to update INDEX_DISABLE_TIMESTAMP failed.");
                    }
                } else {
                    LOG.warn((Object)("Attempt to disable index " + indexTableName + " failed with code = " + (Object)((Object)result.getMutationCode()) + ". Will use default failure policy instead."));
                    throw new DoNotRetryIOException("Attempt to disable " + indexTableName + " failed.");
                }
            }
            if (leaveIndexActive) {
                LOG.info((Object)("Successfully update INDEX_DISABLE_TIMESTAMP for " + indexTableName + " due to an exception while writing updates."), (Throwable)cause);
                continue;
            }
            LOG.info((Object)("Successfully disabled index " + indexTableName + " due to an exception while writing updates."), (Throwable)cause);
        }
        return timestamp;
    }

    private Collection<? extends String> getLocalIndexNames(HTableInterfaceReference ref, Collection<Mutation> mutations) throws IOException {
        HashSet<String> indexTableNames = new HashSet<String>(1);
        PhoenixConnection conn = null;
        try {
            conn = QueryUtil.getConnectionOnServer(this.env.getConfiguration()).unwrap(PhoenixConnection.class);
            PTable dataTable = PhoenixRuntime.getTableNoCache(conn, ref.getTableName());
            List<PTable> indexes = dataTable.getIndexes();
            PTable localIndex = null;
            HashMap<ImmutableBytesWritable, String> localIndexNames = new HashMap<ImmutableBytesWritable, String>();
            for (PTable index : indexes) {
                if (index.getIndexType() != PTable.IndexType.LOCAL || index.getIndexState() != PIndexState.ACTIVE) continue;
                if (localIndex == null) {
                    localIndex = index;
                }
                localIndexNames.put(new ImmutableBytesWritable(MetaDataUtil.getViewIndexIdDataType().toBytes(index.getViewIndexId())), index.getName().getString());
            }
            if (localIndex == null) {
                Set i$ = Collections.emptySet();
                return i$;
            }
            IndexMaintainer indexMaintainer = localIndex.getIndexMaintainer(dataTable, conn);
            HRegionInfo regionInfo = this.env.getRegion().getRegionInfo();
            int offset = regionInfo.getStartKey().length == 0 ? regionInfo.getEndKey().length : regionInfo.getStartKey().length;
            byte[] viewId = null;
            for (Mutation mutation : mutations) {
                viewId = indexMaintainer.getViewIndexIdFromIndexRowKey(new ImmutableBytesWritable(mutation.getRow(), offset, mutation.getRow().length - offset));
                String indexTableName = (String)localIndexNames.get(new ImmutableBytesWritable(viewId));
                indexTableNames.add(indexTableName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
        }
        return indexTableNames;
    }
}

