/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.coprocessor.UngroupedAggregateRegionObserver;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.filter.ColumnProjectionFilter;
import org.apache.phoenix.filter.DistinctPrefixFilter;
import org.apache.phoenix.filter.EncodedQualifiersColumnProjectionFilter;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.VersionUtil;
import org.apache.phoenix.iterate.ConcatResultIterator;
import org.apache.phoenix.iterate.ExplainTable;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterators;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.StaleRegionBoundaryCacheException;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.stats.GuidePostsInfo;
import org.apache.phoenix.schema.stats.GuidePostsKey;
import org.apache.phoenix.schema.stats.StatisticsUtil;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.Closeables;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.PrefixByteCodec;
import org.apache.phoenix.util.PrefixByteDecoder;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SQLCloseables;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResultIterators
extends ExplainTable
implements ResultIterators {
    private static final Logger logger = LoggerFactory.getLogger(BaseResultIterators.class);
    private static final int ESTIMATED_GUIDEPOSTS_PER_REGION = 20;
    private static final int MIN_SEEK_TO_COLUMN_VERSION = VersionUtil.encodeVersion("0", "98", "12");
    private final List<List<Scan>> scans;
    private final List<KeyRange> splits;
    private final byte[] physicalTableName;
    protected final QueryPlan plan;
    protected final String scanId;
    protected final MutationState mutationState;
    protected final ParallelScanGrouper scanGrouper;
    private final List<List<List<Pair<Scan, Future<PeekingResultIterator>>>>> allFutures;
    private Long estimatedRows;
    private Long estimatedSize;
    private boolean hasGuidePosts;
    private Scan scan;
    private boolean useStatsForParallelization;
    static final Function<HRegionLocation, KeyRange> TO_KEY_RANGE = new Function<HRegionLocation, KeyRange>(){

        public KeyRange apply(HRegionLocation region) {
            return KeyRange.getKeyRange(region.getRegionInfo().getStartKey(), region.getRegionInfo().getEndKey());
        }
    };

    private PTable getTable() {
        return this.plan.getTableRef().getTable();
    }

    protected boolean useStats() {
        return !ScanUtil.isAnalyzeTable(this.scan);
    }

    private static void initializeScan(QueryPlan plan, Integer perScanLimit, Integer offset, Scan scan) throws SQLException {
        StatementContext context = plan.getContext();
        TableRef tableRef = plan.getTableRef();
        PTable table = tableRef.getTable();
        Map familyMap = scan.getFamilyMap();
        if (context.getConnection().isDescVarLengthRowKeyUpgrade()) {
            familyMap.clear();
            scan.setMaxVersions();
            scan.setFilter(null);
            scan.setRaw(true);
            scan.setAttribute("_UPGRADE_DESC_ROW_KEY", UngroupedAggregateRegionObserver.serialize(table));
        } else {
            int cols;
            boolean keyOnlyFilter;
            FilterableStatement statement = plan.getStatement();
            RowProjector projector = plan.getProjector();
            boolean optimizeProjection = false;
            boolean bl = keyOnlyFilter = familyMap.isEmpty() && context.getWhereConditionColumns().isEmpty();
            if (!projector.projectEverything()) {
                if (keyOnlyFilter && table.getColumnFamilies().size() == 1) {
                    scan.addFamily(table.getColumnFamilies().get(0).getName().getBytes());
                } else {
                    optimizeProjection = true;
                    if (projector.projectEveryRow()) {
                        if (table.getViewType() == PTable.ViewType.MAPPED) {
                            context.getWhereConditionColumns().clear();
                            for (PColumnFamily family : table.getColumnFamilies()) {
                                context.addWhereConditionColumn(family.getName().getBytes(), null);
                            }
                        } else {
                            byte[] ecf = SchemaUtil.getEmptyColumnFamily(table);
                            if (!familyMap.containsKey(ecf) || familyMap.get(ecf) != null) {
                                scan.addColumn(ecf, (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo(table).getFirst());
                            }
                        }
                    }
                }
            }
            if (keyOnlyFilter) {
                ScanUtil.andFilterAtBeginning(scan, (Filter)new FirstKeyOnlyFilter());
            }
            if (perScanLimit != null) {
                ScanUtil.andFilterAtEnd(scan, (Filter)new PageFilter((long)perScanLimit.intValue()));
            }
            if (offset != null) {
                ScanUtil.addOffsetAttribute(scan, offset);
            }
            if ((cols = plan.getGroupBy().getOrderPreservingColumnCount()) > 0 && keyOnlyFilter && !plan.getStatement().getHint().hasHint(HintNode.Hint.RANGE_SCAN) && cols < plan.getTableRef().getTable().getRowKeySchema().getFieldCount() && plan.getGroupBy().isOrderPreserving() && (context.getAggregationManager().isEmpty() || plan.getGroupBy().isUngroupedAggregate())) {
                ScanUtil.andFilterAtEnd(scan, (Filter)new DistinctPrefixFilter(plan.getTableRef().getTable().getRowKeySchema(), cols));
                if (plan.getLimit() != null) {
                    ScanUtil.andFilterAtEnd(scan, (Filter)new PageFilter((long)plan.getLimit().intValue()));
                }
            }
            scan.setAttribute("_QualifierEncodingScheme", new byte[]{table.getEncodingScheme().getSerializedMetadataValue()});
            scan.setAttribute("_ImmutableStorageEncodingScheme", new byte[]{table.getImmutableStorageScheme().getSerializedMetadataValue()});
            scan.setAttribute("_UseNewValueColumnQualifier", Bytes.toBytes((boolean)true));
            if (!ScanUtil.isAnalyzeTable(scan)) {
                BaseResultIterators.setQualifierRanges(keyOnlyFilter, table, scan, context);
            }
            if (optimizeProjection) {
                BaseResultIterators.optimizeProjection(context, scan, table, statement);
            }
        }
    }

    private static void setQualifierRanges(boolean keyOnlyFilter, PTable table, Scan scan, StatementContext context) throws SQLException {
        if (EncodedColumnsUtil.useEncodedQualifierListOptimization(table, scan)) {
            Pair minMaxQualifiers = new Pair();
            for (Pair<byte[], byte[]> whereCol : context.getWhereConditionColumns()) {
                byte[] cq = (byte[])whereCol.getSecond();
                if (cq == null) continue;
                int qualifier = table.getEncodingScheme().decode(cq);
                BaseResultIterators.adjustQualifierRange(qualifier, (Pair<Integer, Integer>)minMaxQualifiers);
            }
            Map familyMap = scan.getFamilyMap();
            for (Map.Entry entry : familyMap.entrySet()) {
                if (entry.getValue() != null) {
                    for (byte[] cq : (NavigableSet)entry.getValue()) {
                        if (cq == null) continue;
                        int qualifier = table.getEncodingScheme().decode(cq);
                        BaseResultIterators.adjustQualifierRange(qualifier, (Pair<Integer, Integer>)minMaxQualifiers);
                    }
                    continue;
                }
                byte[] cf = (byte[])entry.getKey();
                String family = Bytes.toString((byte[])cf);
                if (table.getType() == PTableType.INDEX && table.getIndexType() == PTable.IndexType.LOCAL && !IndexUtil.isLocalIndexFamily(family)) {
                    family = IndexUtil.getLocalIndexColumnFamily(family);
                }
                byte[] familyBytes = Bytes.toBytes((String)family);
                TreeSet<byte[]> qualifierSet = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
                if (Bytes.equals((byte[])familyBytes, (byte[])SchemaUtil.getEmptyColumnFamily(table))) {
                    Pair<byte[], byte[]> emptyKeyValueInfo = EncodedColumnsUtil.getEmptyKeyValueInfo(table);
                    qualifierSet.add((byte[])emptyKeyValueInfo.getFirst());
                }
                if (keyOnlyFilter) continue;
                Pair<Integer, Integer> qualifierRangeForFamily = EncodedColumnsUtil.setQualifiersForColumnsInFamily(table, family, qualifierSet);
                familyMap.put(familyBytes, qualifierSet);
                if (qualifierRangeForFamily == null) continue;
                BaseResultIterators.adjustQualifierRange((Integer)qualifierRangeForFamily.getFirst(), (Pair<Integer, Integer>)minMaxQualifiers);
                BaseResultIterators.adjustQualifierRange((Integer)qualifierRangeForFamily.getSecond(), (Pair<Integer, Integer>)minMaxQualifiers);
            }
            if (minMaxQualifiers.getFirst() != null) {
                scan.setAttribute("_MinQualifier", Bytes.toBytes((int)((Integer)minMaxQualifiers.getFirst())));
                scan.setAttribute("_MaxQualifier", Bytes.toBytes((int)((Integer)minMaxQualifiers.getSecond())));
                ScanUtil.setQualifierRangesOnFilter(scan, (Pair<Integer, Integer>)minMaxQualifiers);
            }
        }
    }

    private static void adjustQualifierRange(Integer qualifier, Pair<Integer, Integer> minMaxQualifiers) {
        if (minMaxQualifiers.getFirst() == null) {
            minMaxQualifiers.setFirst((Object)qualifier);
            minMaxQualifiers.setSecond((Object)qualifier);
        } else if ((Integer)minMaxQualifiers.getFirst() > qualifier) {
            minMaxQualifiers.setFirst((Object)qualifier);
        } else if ((Integer)minMaxQualifiers.getSecond() < qualifier) {
            minMaxQualifiers.setSecond((Object)qualifier);
        }
    }

    private static void optimizeProjection(StatementContext context, Scan scan, PTable table, FilterableStatement statement) {
        PTable.ImmutableStorageScheme storageScheme;
        Map familyMap = scan.getFamilyMap();
        TreeMap<ImmutableBytesPtr, NavigableSet<ImmutableBytesPtr>> columnsTracker = new TreeMap<ImmutableBytesPtr, NavigableSet<ImmutableBytesPtr>>();
        TreeSet<byte[]> conditionOnlyCfs = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        int referencedCfCount = familyMap.size();
        PTable.QualifierEncodingScheme encodingScheme = table.getEncodingScheme();
        BitSet trackedColumnsBitset = EncodedColumnsUtil.isPossibleToUseEncodedCQFilter(encodingScheme, storageScheme = table.getImmutableStorageScheme()) && !ScanUtil.hasDynamicColumns(table) ? new BitSet(10) : null;
        boolean filteredColumnNotInProjection = false;
        for (Pair<byte[], byte[]> whereCol : context.getWhereConditionColumns()) {
            NavigableSet projectedColumns;
            byte[] byArray = (byte[])whereCol.getFirst();
            if (!familyMap.containsKey(byArray)) {
                ++referencedCfCount;
                filteredColumnNotInProjection = true;
                continue;
            }
            if (filteredColumnNotInProjection || (projectedColumns = (NavigableSet)familyMap.get(byArray)) == null) continue;
            byte[] filteredColumn = (byte[])whereCol.getSecond();
            if (filteredColumn == null) {
                filteredColumnNotInProjection = true;
                continue;
            }
            filteredColumnNotInProjection = !projectedColumns.contains(filteredColumn);
        }
        boolean preventSeekToColumn = false;
        if (statement.getHint().hasHint(HintNode.Hint.SEEK_TO_COLUMN)) {
            preventSeekToColumn = false;
        } else if (!EncodedColumnsUtil.useEncodedQualifierListOptimization(table, scan)) {
            if (statement.getHint().hasHint(HintNode.Hint.NO_SEEK_TO_COLUMN)) {
                preventSeekToColumn = true;
            } else {
                int hbaseServerVersion = context.getConnection().getQueryServices().getLowestClusterHBaseVersion();
                preventSeekToColumn = referencedCfCount == 1 && hbaseServerVersion < MIN_SEEK_TO_COLUMN_VERSION;
            }
        }
        for (Map.Entry entry : familyMap.entrySet()) {
            ImmutableBytesPtr cf = new ImmutableBytesPtr((byte[])entry.getKey());
            NavigableSet qs = (NavigableSet)entry.getValue();
            TreeSet<ImmutableBytesPtr> cols = null;
            if (qs != null) {
                cols = new TreeSet<ImmutableBytesPtr>();
                for (byte[] q : qs) {
                    cols.add(new ImmutableBytesPtr(q));
                    if (trackedColumnsBitset == null) continue;
                    int qualifier = encodingScheme.decode(q);
                    trackedColumnsBitset.set(qualifier);
                }
            }
            columnsTracker.put(cf, cols);
        }
        for (Pair pair : context.getWhereConditionColumns()) {
            byte[] family = (byte[])pair.getFirst();
            if (preventSeekToColumn) {
                if (!familyMap.containsKey(family)) {
                    conditionOnlyCfs.add(family);
                }
                scan.addFamily(family);
                continue;
            }
            if (familyMap.containsKey(family)) {
                NavigableSet cols = (NavigableSet)familyMap.get(family);
                if (cols == null) continue;
                if (pair.getSecond() == null) {
                    scan.addFamily(family);
                    continue;
                }
                scan.addColumn(family, (byte[])pair.getSecond());
                continue;
            }
            if (pair.getSecond() == null) {
                scan.addFamily(family);
                continue;
            }
            scan.addColumn(family, (byte[])pair.getSecond());
        }
        if (!columnsTracker.isEmpty()) {
            if (preventSeekToColumn) {
                for (ImmutableBytesPtr immutableBytesPtr : columnsTracker.keySet()) {
                    scan.addFamily(immutableBytesPtr.get());
                }
            }
            if (!statement.isAggregate() && filteredColumnNotInProjection) {
                ScanUtil.andFilterAtEnd(scan, (Filter)(trackedColumnsBitset != null ? new EncodedQualifiersColumnProjectionFilter(SchemaUtil.getEmptyColumnFamily(table), trackedColumnsBitset, conditionOnlyCfs, table.getEncodingScheme()) : new ColumnProjectionFilter(SchemaUtil.getEmptyColumnFamily(table), columnsTracker, conditionOnlyCfs, EncodedColumnsUtil.usesEncodedColumnNames(table.getEncodingScheme()))));
            }
        }
    }

    public BaseResultIterators(QueryPlan plan, Integer perScanLimit, Integer offset, ParallelScanGrouper scanGrouper, Scan scan) throws SQLException {
        super(plan.getContext(), plan.getTableRef(), plan.getGroupBy(), plan.getOrderBy(), plan.getStatement().getHint(), QueryUtil.getOffsetLimit(plan.getLimit(), plan.getOffset()), offset);
        this.plan = plan;
        this.scan = scan;
        this.scanGrouper = scanGrouper;
        StatementContext context = plan.getContext();
        this.mutationState = new MutationState(context.getConnection().getMutationState());
        TableRef tableRef = plan.getTableRef();
        PTable table = tableRef.getTable();
        this.physicalTableName = table.getPhysicalName().getBytes();
        Long currentSCN = context.getConnection().getSCN();
        if (null == currentSCN) {
            currentSCN = Long.MAX_VALUE;
        }
        this.scanId = new UUID(ThreadLocalRandom.current().nextLong(), ThreadLocalRandom.current().nextLong()).toString();
        BaseResultIterators.initializeScan(plan, perScanLimit, offset, scan);
        this.useStatsForParallelization = context.getConnection().getQueryServices().getConfiguration().getBoolean("phoenix.use.stats.parallelization", true);
        this.scans = this.getParallelScans();
        ArrayList splitRanges = Lists.newArrayListWithExpectedSize((int)(this.scans.size() * 20));
        for (List<Scan> scanList : this.scans) {
            for (Scan aScan : scanList) {
                splitRanges.add(KeyRange.getKeyRange(aScan.getStartRow(), aScan.getStopRow()));
            }
        }
        this.splits = ImmutableList.copyOf((Collection)splitRanges);
        this.allFutures = Lists.newArrayListWithExpectedSize((int)1);
    }

    @Override
    public List<KeyRange> getSplits() {
        if (this.splits == null) {
            return Collections.emptyList();
        }
        return this.splits;
    }

    @Override
    public List<List<Scan>> getScans() {
        if (this.scans == null) {
            return Collections.emptyList();
        }
        return this.scans;
    }

    private List<HRegionLocation> getRegionBoundaries(ParallelScanGrouper scanGrouper) throws SQLException {
        return scanGrouper.getRegionBoundaries(this.context, this.physicalTableName);
    }

    private static List<byte[]> toBoundaries(List<HRegionLocation> regionLocations) {
        int nBoundaries = regionLocations.size() - 1;
        ArrayList ranges = Lists.newArrayListWithExpectedSize((int)nBoundaries);
        for (int i = 0; i < nBoundaries; ++i) {
            HRegionInfo regionInfo = regionLocations.get(i).getRegionInfo();
            ranges.add(regionInfo.getEndKey());
        }
        return ranges;
    }

    private static int getIndexContainingInclusive(List<byte[]> boundaries, byte[] inclusiveKey) {
        int guideIndex = Collections.binarySearch(boundaries, inclusiveKey, Bytes.BYTES_COMPARATOR);
        guideIndex = guideIndex < 0 ? -(guideIndex + 1) : guideIndex + 1;
        return guideIndex;
    }

    private static int getIndexContainingExclusive(List<byte[]> boundaries, byte[] exclusiveKey) {
        int guideIndex = Collections.binarySearch(boundaries, exclusiveKey, Bytes.BYTES_COMPARATOR);
        guideIndex = guideIndex < 0 ? -(guideIndex + 1) : guideIndex;
        return guideIndex;
    }

    private GuidePostsInfo getGuidePosts() throws SQLException {
        byte[] cf;
        if (!this.useStats() || !StatisticsUtil.isStatsEnabled(TableName.valueOf((byte[])this.physicalTableName))) {
            return GuidePostsInfo.NO_GUIDEPOST;
        }
        TreeSet<byte[]> whereConditions = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (Pair<byte[], byte[]> where : this.context.getWhereConditionColumns()) {
            cf = (byte[])where.getFirst();
            if (cf == null) continue;
            whereConditions.add(cf);
        }
        PTable table = this.getTable();
        byte[] defaultCF = SchemaUtil.getEmptyColumnFamily(this.getTable());
        cf = null;
        if (!table.getColumnFamilies().isEmpty() && !whereConditions.isEmpty()) {
            for (Pair<byte[], byte[]> where : this.context.getWhereConditionColumns()) {
                byte[] whereCF = (byte[])where.getFirst();
                if (Bytes.compareTo((byte[])defaultCF, (byte[])whereCF) != 0) continue;
                cf = defaultCF;
                break;
            }
            if (cf == null) {
                cf = (byte[])this.context.getWhereConditionColumns().get(0).getFirst();
            }
        }
        if (cf == null) {
            cf = defaultCF;
        }
        GuidePostsKey key = new GuidePostsKey(this.physicalTableName, cf);
        return this.context.getConnection().getQueryServices().getTableStats(key);
    }

    private List<Scan> addNewScan(List<List<Scan>> parallelScans, List<Scan> scans, Scan scan, byte[] startKey, boolean crossedRegionBoundary, HRegionLocation regionLocation) {
        boolean startNewScan = this.scanGrouper.shouldStartNewScan(this.plan, scans, startKey, crossedRegionBoundary);
        if (scan != null) {
            if (regionLocation.getServerName() != null) {
                scan.setAttribute("_SCAN_REGION_SERVER", regionLocation.getServerName().getVersionedBytes());
            }
            scans.add((Scan)scan);
        }
        if (startNewScan && !scans.isEmpty()) {
            parallelScans.add(scans);
            scans = Lists.newArrayListWithExpectedSize((int)1);
        }
        return scans;
    }

    private List<List<Scan>> getParallelScans() throws SQLException {
        if (!ScanUtil.isContextScan(this.scan, this.context)) {
            return this.getParallelScans(this.scan);
        }
        return this.getParallelScans(ByteUtil.EMPTY_BYTE_ARRAY, ByteUtil.EMPTY_BYTE_ARRAY);
    }

    private List<List<Scan>> getParallelScans(Scan scan) throws SQLException {
        List<HRegionLocation> regionLocations = this.getRegionBoundaries(this.scanGrouper);
        List<byte[]> regionBoundaries = BaseResultIterators.toBoundaries(regionLocations);
        int regionIndex = 0;
        int stopIndex = regionBoundaries.size();
        if (scan.getStartRow().length > 0) {
            regionIndex = BaseResultIterators.getIndexContainingInclusive(regionBoundaries, scan.getStartRow());
        }
        if (scan.getStopRow().length > 0) {
            stopIndex = Math.min(stopIndex, regionIndex + BaseResultIterators.getIndexContainingExclusive(regionBoundaries.subList(regionIndex, stopIndex), scan.getStopRow()));
        }
        ArrayList parallelScans = Lists.newArrayListWithExpectedSize((int)(stopIndex - regionIndex + 1));
        List<Object> scans = Lists.newArrayListWithExpectedSize((int)2);
        while (regionIndex <= stopIndex) {
            HRegionLocation regionLocation = regionLocations.get(regionIndex);
            HRegionInfo regionInfo = regionLocation.getRegionInfo();
            Scan newScan = ScanUtil.newScan(scan);
            byte[] endKey = regionIndex == stopIndex ? scan.getStopRow() : regionBoundaries.get(regionIndex);
            if (ScanUtil.isLocalIndex(scan)) {
                ScanUtil.setLocalIndexAttributes(newScan, 0, regionInfo.getStartKey(), regionInfo.getEndKey(), newScan.getAttribute("_ScanStartRowSuffix"), newScan.getAttribute("_ScanStopRowSuffix"));
            } else {
                if (Bytes.compareTo((byte[])scan.getStartRow(), (byte[])regionInfo.getStartKey()) <= 0) {
                    newScan.setAttribute("_ScanActualStartRow", regionInfo.getStartKey());
                    newScan.setStartRow(regionInfo.getStartKey());
                }
                if (scan.getStopRow().length == 0 || regionInfo.getEndKey().length != 0 && Bytes.compareTo((byte[])scan.getStopRow(), (byte[])regionInfo.getEndKey()) > 0) {
                    newScan.setStopRow(regionInfo.getEndKey());
                }
            }
            scans = this.addNewScan(parallelScans, scans, newScan, endKey, true, regionLocation);
            ++regionIndex;
        }
        if (!scans.isEmpty()) {
            parallelScans.add(scans);
        }
        return parallelScans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<List<Scan>> getParallelScans(byte[] startKey, byte[] stopKey) throws SQLException {
        boolean traverseAllRegions;
        List<HRegionLocation> regionLocations = this.getRegionBoundaries(this.scanGrouper);
        List<byte[]> regionBoundaries = BaseResultIterators.toBoundaries(regionLocations);
        ScanRanges scanRanges = this.context.getScanRanges();
        PTable table = this.getTable();
        boolean isSalted = table.getBucketNum() != null;
        boolean isLocalIndex = table.getIndexType() == PTable.IndexType.LOCAL;
        GuidePostsInfo gps = this.getGuidePosts();
        this.hasGuidePosts = gps != GuidePostsInfo.NO_GUIDEPOST;
        boolean bl = traverseAllRegions = isSalted || isLocalIndex;
        if (!traverseAllRegions) {
            byte[] scanStartRow = this.scan.getStartRow();
            if (scanStartRow.length != 0 && Bytes.compareTo((byte[])scanStartRow, (byte[])startKey) > 0) {
                startKey = scanStartRow;
            }
            byte[] scanStopRow = this.scan.getStopRow();
            if (stopKey.length == 0 || scanStopRow.length != 0 && Bytes.compareTo((byte[])scanStopRow, (byte[])stopKey) < 0) {
                stopKey = scanStopRow;
            }
        }
        int regionIndex = 0;
        int stopIndex = regionBoundaries.size();
        if (startKey.length > 0) {
            regionIndex = BaseResultIterators.getIndexContainingInclusive(regionBoundaries, startKey);
        }
        if (stopKey.length > 0) {
            stopIndex = Math.min(stopIndex, regionIndex + BaseResultIterators.getIndexContainingExclusive(regionBoundaries.subList(regionIndex, stopIndex), stopKey));
            if (isLocalIndex) {
                stopKey = regionLocations.get(stopIndex).getRegionInfo().getEndKey();
            }
        }
        ArrayList parallelScans = Lists.newArrayListWithExpectedSize((int)(stopIndex - regionIndex + 1));
        ImmutableBytesWritable currentKey = new ImmutableBytesWritable(startKey);
        int gpsSize = gps.getGuidePostsCount();
        int estGuidepostsPerRegion = gpsSize == 0 ? 1 : gpsSize / regionLocations.size() + 1;
        int keyOffset = 0;
        ImmutableBytesWritable currentGuidePost = ByteUtil.EMPTY_IMMUTABLE_BYTE_ARRAY;
        ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)estGuidepostsPerRegion);
        ImmutableBytesWritable guidePosts = gps.getGuidePosts();
        ByteArrayInputStream stream = null;
        DataInputStream input = null;
        PrefixByteDecoder decoder = null;
        int guideIndex = 0;
        long estimatedRows = 0L;
        long estimatedSize = 0L;
        try {
            void var19_22;
            if (gpsSize > 0) {
                stream = new ByteArrayInputStream(guidePosts.get(), guidePosts.getOffset(), guidePosts.getLength());
                input = new DataInputStream(stream);
                decoder = new PrefixByteDecoder(gps.getMaxLength());
                try {
                    while (currentKey.compareTo(currentGuidePost = PrefixByteCodec.decode(decoder, input)) >= 0 && currentKey.getLength() != 0) {
                        ++guideIndex;
                    }
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
            }
            byte[] currentKeyBytes = currentKey.copyBytes();
            while (regionIndex <= stopIndex) {
                void var19_23;
                HRegionLocation regionLocation = regionLocations.get(regionIndex);
                HRegionInfo regionInfo = regionLocation.getRegionInfo();
                byte[] currentGuidePostBytes = currentGuidePost.copyBytes();
                byte[] endRegionKey = ByteUtil.EMPTY_BYTE_ARRAY;
                byte[] endKey = regionIndex == stopIndex ? stopKey : regionBoundaries.get(regionIndex);
                if (isLocalIndex) {
                    endRegionKey = regionInfo.getEndKey();
                    keyOffset = ScanUtil.getRowKeyOffset(regionInfo.getStartKey(), endRegionKey);
                }
                try {
                    while (guideIndex < gpsSize && (endKey.length == 0 || currentGuidePost.compareTo(endKey) <= 0)) {
                        Scan newScan = scanRanges.intersectScan(this.scan, currentKeyBytes, currentGuidePostBytes, keyOffset, false);
                        if (newScan != null) {
                            ScanUtil.setLocalIndexAttributes(newScan, keyOffset, regionInfo.getStartKey(), regionInfo.getEndKey(), newScan.getStartRow(), newScan.getStopRow());
                            estimatedRows += gps.getRowCounts()[guideIndex];
                            estimatedSize += gps.getByteCounts()[guideIndex];
                        }
                        if (this.useStatsForParallelization) {
                            List<Scan> list = this.addNewScan(parallelScans, (List<Scan>)var19_23, newScan, currentGuidePostBytes, false, regionLocation);
                        }
                        currentKeyBytes = currentGuidePostBytes;
                        currentGuidePost = PrefixByteCodec.decode(decoder, input);
                        currentGuidePostBytes = currentGuidePost.copyBytes();
                        ++guideIndex;
                    }
                }
                catch (EOFException newScan) {
                    // empty catch block
                }
                if ((newScan = scanRanges.intersectScan(this.scan, currentKeyBytes, endKey, keyOffset, true)) != null) {
                    ScanUtil.setLocalIndexAttributes(newScan, keyOffset, regionInfo.getStartKey(), regionInfo.getEndKey(), newScan.getStartRow(), newScan.getStopRow());
                }
                List<Scan> list = this.addNewScan(parallelScans, (List<Scan>)var19_23, newScan, endKey, true, regionLocation);
                currentKeyBytes = endKey;
                ++regionIndex;
            }
            if (scanRanges.isPointLookup()) {
                this.estimatedRows = scanRanges.getPointLookupCount();
                this.estimatedSize = this.estimatedRows * SchemaUtil.estimateRowSize(table);
            } else if (this.hasGuidePosts) {
                this.estimatedRows = estimatedRows;
                this.estimatedSize = estimatedSize;
            } else {
                this.estimatedRows = null;
                this.estimatedSize = null;
            }
            if (!var19_22.isEmpty()) {
                parallelScans.add(var19_22);
            }
            if (stream == null) return parallelScans;
        }
        catch (Throwable throwable) {
            if (stream == null) throw throwable;
            Closeables.closeQuietly(stream);
            throw throwable;
        }
        Closeables.closeQuietly(stream);
        return parallelScans;
    }

    public static <T> List<T> reverseIfNecessary(List<T> list, boolean reverse) {
        if (!reverse) {
            return list;
        }
        return Lists.reverse(list);
    }

    @Override
    public List<PeekingResultIterator> getIterators() throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug(LogUtil.addCustomAnnotations("Getting iterators for " + this, ScanUtil.getCustomAnnotations(this.scan)));
        }
        boolean isReverse = ScanUtil.isReversed(this.scan);
        boolean isLocalIndex = this.getTable().getIndexType() == PTable.IndexType.LOCAL;
        ConnectionQueryServices services = this.context.getConnection().getQueryServices();
        long startTime = System.currentTimeMillis();
        long maxQueryEndTime = startTime + (long)this.context.getStatement().getQueryTimeoutInMillis();
        int numScans = this.size();
        ConcurrentLinkedQueue<PeekingResultIterator> allIterators = new ConcurrentLinkedQueue<PeekingResultIterator>();
        ArrayList<PeekingResultIterator> iterators = new ArrayList<PeekingResultIterator>(numScans);
        ScanWrapper previousScan = new ScanWrapper(null);
        return this.getIterators(this.scans, services, isLocalIndex, allIterators, iterators, isReverse, maxQueryEndTime, this.splits.size(), previousScan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Iterators could be improved
     * Loose catch block
     */
    private List<PeekingResultIterator> getIterators(List<List<Scan>> scan, ConnectionQueryServices services, boolean isLocalIndex, Queue<PeekingResultIterator> allIterators, List<PeekingResultIterator> iterators, boolean isReverse, long maxQueryEndTime, int splitSize, ScanWrapper previousScan) throws SQLException {
        block85: {
            boolean success = false;
            ArrayList futures = Lists.newArrayListWithExpectedSize((int)splitSize);
            this.allFutures.add(futures);
            SQLException toThrow = null;
            int queryTimeOut = this.context.getStatement().getQueryTimeoutInMillis();
            try {
                this.submitWork(scan, futures, allIterators, splitSize, isReverse, this.scanGrouper);
                boolean clearedCache = false;
                for (List future : BaseResultIterators.reverseIfNecessary(futures, isReverse)) {
                    ArrayList concatIterators = Lists.newArrayListWithExpectedSize((int)future.size());
                    Iterator scanPairItr = BaseResultIterators.reverseIfNecessary(future, isReverse).iterator();
                    while (scanPairItr.hasNext()) {
                        Pair scanPair = (Pair)scanPairItr.next();
                        try {
                            long timeOutForScan = maxQueryEndTime - System.currentTimeMillis();
                            if (timeOutForScan < 0L) {
                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.OPERATION_TIMED_OUT).setMessage(". Query couldn't be completed in the alloted time: " + queryTimeOut + " ms").build().buildException();
                            }
                            if (isLocalIndex && previousScan != null && previousScan.getScan() != null && (!isReverse && Bytes.compareTo((byte[])((Scan)scanPair.getFirst()).getAttribute("_ScanActualStartRow"), (byte[])previousScan.getScan().getStopRow()) < 0 || isReverse && Bytes.compareTo((byte[])((Scan)scanPair.getFirst()).getAttribute("_ScanActualStartRow"), (byte[])previousScan.getScan().getStopRow()) > 0 || Bytes.compareTo((byte[])((Scan)scanPair.getFirst()).getStopRow(), (byte[])previousScan.getScan().getStopRow()) == 0) && Bytes.compareTo((byte[])((Scan)scanPair.getFirst()).getAttribute("_ScanStartRowSuffix"), (byte[])previousScan.getScan().getAttribute("_ScanStartRowSuffix")) == 0) continue;
                            PeekingResultIterator iterator = (PeekingResultIterator)((Future)scanPair.getSecond()).get(timeOutForScan, TimeUnit.MILLISECONDS);
                            concatIterators.add(iterator);
                            previousScan.setScan((Scan)scanPair.getFirst());
                        }
                        catch (ExecutionException e) {
                            try {
                                throw ServerUtil.parseServerException(e);
                            }
                            catch (StaleRegionBoundaryCacheException e2) {
                                scanPairItr.remove();
                                if (!clearedCache) {
                                    services.clearTableRegionCache(this.physicalTableName);
                                    this.context.getOverallQueryMetrics().cacheRefreshedDueToSplits();
                                }
                                Scan oldScan = (Scan)scanPair.getFirst();
                                byte[] startKey = oldScan.getAttribute("_ScanActualStartRow");
                                byte[] endKey = oldScan.getStopRow();
                                List<List<Scan>> newNestedScans = this.getParallelScans(startKey, endKey);
                                this.addIterator(iterators, concatIterators);
                                concatIterators = Lists.newArrayList();
                                this.getIterators(newNestedScans, services, isLocalIndex, allIterators, iterators, isReverse, maxQueryEndTime, newNestedScans.size(), previousScan);
                            }
                        }
                    }
                    this.addIterator(iterators, concatIterators);
                }
                success = true;
                List<PeekingResultIterator> list = iterators;
                return list;
            }
            catch (TimeoutException e) {
                this.context.getOverallQueryMetrics().queryTimedOut();
                GlobalClientMetrics.GLOBAL_QUERY_TIMEOUT_COUNTER.increment();
                toThrow = new SQLExceptionInfo.Builder(SQLExceptionCode.OPERATION_TIMED_OUT).setMessage(". Query couldn't be completed in the alloted time: " + queryTimeOut + " ms").setRootCause(e).build().buildException();
                return toThrow;
            }
            catch (SQLException e) {
                toThrow = e;
                return toThrow;
            }
            catch (Exception e) {
                toThrow = ServerUtil.parseServerException(e);
                return toThrow;
            }
            finally {
                try {
                    if (!success) {
                        this.close();
                        try {
                            SQLCloseables.closeAll(allIterators);
                        }
                        catch (Exception e) {
                            if (toThrow == null) {
                                toThrow = ServerUtil.parseServerException(e);
                            }
                            toThrow.setNextException(ServerUtil.parseServerException(e));
                        }
                        catch (Exception e) {
                            block83: {
                                try {
                                    if (toThrow == null) {
                                        toThrow = ServerUtil.parseServerException(e);
                                        break block83;
                                    }
                                    toThrow.setNextException(ServerUtil.parseServerException(e));
                                }
                                catch (Throwable throwable) {
                                    block84: {
                                        try {
                                            SQLCloseables.closeAll(allIterators);
                                        }
                                        catch (Exception e2) {
                                            if (toThrow == null) {
                                                toThrow = ServerUtil.parseServerException(e2);
                                                break block84;
                                            }
                                            toThrow.setNextException(ServerUtil.parseServerException(e2));
                                        }
                                    }
                                    throw throwable;
                                }
                            }
                            try {
                                SQLCloseables.closeAll(allIterators);
                            }
                            catch (Exception e3) {
                                if (toThrow == null) {
                                    toThrow = ServerUtil.parseServerException(e3);
                                }
                                toThrow.setNextException(ServerUtil.parseServerException(e3));
                            }
                        }
                    }
                }
                finally {
                    if (toThrow == null) break block85;
                    GlobalClientMetrics.GLOBAL_FAILED_QUERY_COUNTER.increment();
                    this.context.getOverallQueryMetrics().queryFailed();
                    throw toThrow;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.allFutures.isEmpty()) {
            return;
        }
        boolean cancelledWork = false;
        try {
            ArrayList futuresToClose = Lists.newArrayListWithExpectedSize((int)this.getSplits().size());
            for (List<List<Pair<Scan, Future<PeekingResultIterator>>>> futures : this.allFutures) {
                for (List<Pair<Scan, Future<PeekingResultIterator>>> futureScans : futures) {
                    for (Pair<Scan, Future<PeekingResultIterator>> futurePair : futureScans) {
                        Future future;
                        if (futurePair == null || (future = (Future)futurePair.getSecond()) == null) continue;
                        if (future.cancel(false)) {
                            cancelledWork = true;
                            continue;
                        }
                        futuresToClose.add(future);
                    }
                }
            }
            for (Future future : futuresToClose) {
                try {
                    PeekingResultIterator iterator = (PeekingResultIterator)future.get();
                    iterator.close();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    logger.info("Failed to execute task during cancel", (Throwable)e);
                }
            }
        }
        finally {
            if (cancelledWork) {
                this.context.getConnection().getQueryServices().getExecutor().purge();
            }
            this.allFutures.clear();
        }
    }

    private void addIterator(List<PeekingResultIterator> parentIterators, List<PeekingResultIterator> childIterators) throws SQLException {
        if (!childIterators.isEmpty()) {
            if (this.plan.useRoundRobinIterator()) {
                parentIterators.addAll(childIterators);
            } else {
                parentIterators.add(ConcatResultIterator.newIterator(childIterators));
            }
        }
    }

    protected abstract String getName();

    protected abstract void submitWork(List<List<Scan>> var1, List<List<Pair<Scan, Future<PeekingResultIterator>>>> var2, Queue<PeekingResultIterator> var3, int var4, boolean var5, ParallelScanGrouper var6) throws SQLException;

    @Override
    public int size() {
        return this.scans.size();
    }

    @Override
    public void explain(List<String> planSteps) {
        boolean displayChunkCount = this.context.getConnection().getQueryServices().getProps().getBoolean("phoenix.explain.displayChunkCount", true);
        StringBuilder buf = new StringBuilder();
        buf.append("CLIENT ");
        if (displayChunkCount) {
            boolean displayRowCount = this.context.getConnection().getQueryServices().getProps().getBoolean("phoenix.explain.displayRowCount", true);
            buf.append(this.splits.size()).append("-CHUNK ");
            if (displayRowCount && this.estimatedRows != null) {
                buf.append(this.estimatedRows).append(" ROWS ");
                buf.append(this.estimatedSize).append(" BYTES ");
            }
        }
        buf.append(this.getName()).append(" ").append(this.size()).append("-WAY ");
        try {
            if (this.plan.useRoundRobinIterator()) {
                buf.append("ROUND ROBIN ");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.explain(buf.toString(), planSteps);
    }

    public Long getEstimatedRowCount() {
        return this.estimatedRows;
    }

    public Long getEstimatedByteCount() {
        return this.estimatedSize;
    }

    public String toString() {
        return "ResultIterators [name=" + this.getName() + ",id=" + this.scanId + ",scans=" + this.scans + "]";
    }

    protected static final class ScanLocator {
        private final int outerListIndex;
        private final int innerListIndex;
        private final Scan scan;
        private final boolean isFirstScan;
        private final boolean isLastScan;

        public ScanLocator(Scan scan, int outerListIndex, int innerListIndex, boolean isFirstScan, boolean isLastScan) {
            this.outerListIndex = outerListIndex;
            this.innerListIndex = innerListIndex;
            this.scan = scan;
            this.isFirstScan = isFirstScan;
            this.isLastScan = isLastScan;
        }

        public int getOuterListIndex() {
            return this.outerListIndex;
        }

        public int getInnerListIndex() {
            return this.innerListIndex;
        }

        public Scan getScan() {
            return this.scan;
        }

        public boolean isFirstScan() {
            return this.isFirstScan;
        }

        public boolean isLastScan() {
            return this.isLastScan;
        }
    }

    class ScanWrapper {
        Scan scan;

        public Scan getScan() {
            return this.scan;
        }

        public void setScan(Scan scan) {
            this.scan = scan;
        }

        public ScanWrapper(Scan scan) {
            this.scan = scan;
        }
    }
}

