/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.execute.DescVarLengthFastByteComparisons;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.OrderByExpression;
import org.apache.phoenix.iterate.MappedByteBufferSortedQueue;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ServerUtil;

public class OrderedResultIterator
implements PeekingResultIterator {
    private static final Function<OrderByExpression, Expression> TO_EXPRESSION = new Function<OrderByExpression, Expression>(){

        public Expression apply(OrderByExpression column) {
            return column.getExpression();
        }
    };
    private final int thresholdBytes;
    private final Integer limit;
    private final Integer offset;
    private final ResultIterator delegate;
    private final List<OrderByExpression> orderByExpressions;
    private final long estimatedByteSize;
    private PeekingResultIterator resultIterator;
    private long byteSize;

    protected ResultIterator getDelegate() {
        return this.delegate;
    }

    public OrderedResultIterator(ResultIterator delegate, List<OrderByExpression> orderByExpressions, int thresholdBytes, Integer limit, Integer offset) {
        this(delegate, orderByExpressions, thresholdBytes, limit, offset, 0);
    }

    public OrderedResultIterator(ResultIterator delegate, List<OrderByExpression> orderByExpressions, int thresholdBytes) throws SQLException {
        this(delegate, orderByExpressions, thresholdBytes, null, null);
    }

    public OrderedResultIterator(ResultIterator delegate, List<OrderByExpression> orderByExpressions, int thresholdBytes, Integer limit, Integer offset, int estimatedRowSize) {
        Preconditions.checkArgument((!orderByExpressions.isEmpty() ? 1 : 0) != 0);
        this.delegate = delegate;
        this.orderByExpressions = orderByExpressions;
        this.thresholdBytes = thresholdBytes;
        this.offset = offset == null ? 0 : offset;
        this.limit = limit != null ? Integer.valueOf(limit + this.offset) : null;
        long estimatedEntrySize = 40 + orderByExpressions.size() * 48 + 16 + estimatedRowSize;
        assert (limit == null || Long.MAX_VALUE / estimatedEntrySize >= (long)(limit + this.offset));
        this.estimatedByteSize = limit == null ? 0L : (long)(limit + this.offset) * estimatedEntrySize;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public long getEstimatedByteSize() {
        return this.estimatedByteSize;
    }

    public long getByteSize() {
        return this.byteSize;
    }

    private static Comparator<ResultEntry> buildComparator(List<OrderByExpression> orderByExpressions) {
        Ordering ordering = null;
        int pos = 0;
        for (OrderByExpression col : orderByExpressions) {
            Expression e = col.getExpression();
            ImmutableBytesWritable.Comparator comparator = e.getSortOrder() == SortOrder.DESC && !e.getDataType().isFixedWidth() ? OrderedResultIterator.buildDescVarLengthComparator() : new ImmutableBytesWritable.Comparator();
            Ordering o = Ordering.from((Comparator)comparator);
            if (!col.isAscending()) {
                o = o.reverse();
            }
            o = col.isNullsLast() ? o.nullsLast() : o.nullsFirst();
            Ordering entryOrdering = o.onResultOf((Function)new NthKey(pos++));
            ordering = ordering == null ? entryOrdering : ordering.compound((Comparator)entryOrdering);
        }
        return ordering;
    }

    private static Comparator<ImmutableBytesWritable> buildDescVarLengthComparator() {
        return new Comparator<ImmutableBytesWritable>(){

            @Override
            public int compare(ImmutableBytesWritable o1, ImmutableBytesWritable o2) {
                return DescVarLengthFastByteComparisons.compareTo(o1.get(), o1.getOffset(), o1.getLength(), o2.get(), o2.getOffset(), o2.getLength());
            }
        };
    }

    @Override
    public Tuple next() throws SQLException {
        return this.getResultIterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PeekingResultIterator getResultIterator() throws SQLException {
        if (this.resultIterator != null) {
            return this.resultIterator;
        }
        int numSortKeys = this.orderByExpressions.size();
        ArrayList expressions = Lists.newArrayList((Iterable)Collections2.transform(this.orderByExpressions, TO_EXPRESSION));
        Comparator<ResultEntry> comparator = OrderedResultIterator.buildComparator(this.orderByExpressions);
        try {
            final MappedByteBufferSortedQueue queueEntries = new MappedByteBufferSortedQueue(comparator, this.limit, this.thresholdBytes);
            this.resultIterator = new PeekingResultIterator(){
                int count = 0;

                @Override
                public Tuple next() throws SQLException {
                    ResultEntry entry = (ResultEntry)queueEntries.poll();
                    while (entry != null && OrderedResultIterator.this.offset != null && this.count < OrderedResultIterator.this.offset) {
                        ++this.count;
                        if (entry.getResult() == null) {
                            return null;
                        }
                        entry = (ResultEntry)queueEntries.poll();
                    }
                    if (entry == null || OrderedResultIterator.this.limit != null && this.count++ > OrderedResultIterator.this.limit) {
                        OrderedResultIterator.this.resultIterator.close();
                        OrderedResultIterator.this.resultIterator = PeekingResultIterator.EMPTY_ITERATOR;
                        return null;
                    }
                    return entry.getResult();
                }

                @Override
                public Tuple peek() throws SQLException {
                    ResultEntry entry = (ResultEntry)queueEntries.peek();
                    while (entry != null && OrderedResultIterator.this.offset != null && this.count < OrderedResultIterator.this.offset) {
                        entry = (ResultEntry)queueEntries.poll();
                        ++this.count;
                        if (entry != null) continue;
                        return null;
                    }
                    if (OrderedResultIterator.this.limit != null && this.count > OrderedResultIterator.this.limit) {
                        return null;
                    }
                    entry = (ResultEntry)queueEntries.peek();
                    if (entry == null) {
                        return null;
                    }
                    return entry.getResult();
                }

                @Override
                public void explain(List<String> planSteps) {
                }

                @Override
                public void close() throws SQLException {
                    queueEntries.close();
                }
            };
            Tuple result = this.delegate.next();
            while (result != null) {
                int pos = 0;
                ImmutableBytesWritable[] sortKeys = new ImmutableBytesWritable[numSortKeys];
                for (Expression expression : expressions) {
                    ImmutableBytesWritable sortKey = new ImmutableBytesWritable();
                    boolean evaluated = expression.evaluate(result, sortKey);
                    sortKeys[pos++] = evaluated && sortKey.getLength() > 0 ? sortKey : null;
                }
                queueEntries.add(new ResultEntry(sortKeys, result));
                result = this.delegate.next();
            }
            this.byteSize = queueEntries.getByteSize();
        }
        catch (IOException e) {
            ServerUtil.createIOException(e.getMessage(), e);
        }
        finally {
            this.delegate.close();
        }
        return this.resultIterator;
    }

    @Override
    public Tuple peek() throws SQLException {
        return this.getResultIterator().peek();
    }

    @Override
    public void close() throws SQLException {
        if (null != this.resultIterator) {
            this.resultIterator.close();
        }
        this.resultIterator = PeekingResultIterator.EMPTY_ITERATOR;
    }

    @Override
    public void explain(List<String> planSteps) {
        this.delegate.explain(planSteps);
        planSteps.add("CLIENT" + (this.offset != null ? "" : " OFFSET " + this.offset) + (this.limit == null ? "" : " TOP " + this.limit + " ROW" + (this.limit == 1 ? "" : "S")) + " SORTED BY " + this.orderByExpressions.toString());
    }

    public String toString() {
        return "OrderedResultIterator [thresholdBytes=" + this.thresholdBytes + ", limit=" + this.limit + ", offset=" + this.offset + ", delegate=" + this.delegate + ", orderByExpressions=" + this.orderByExpressions + ", estimatedByteSize=" + this.estimatedByteSize + ", resultIterator=" + this.resultIterator + ", byteSize=" + this.byteSize + "]";
    }

    private static class NthKey
    implements Function<ResultEntry, ImmutableBytesWritable> {
        private final int index;

        NthKey(int index) {
            this.index = index;
        }

        public ImmutableBytesWritable apply(ResultEntry entry) {
            return entry.getSortKey(this.index);
        }
    }

    protected static class ResultEntry {
        protected final ImmutableBytesWritable[] sortKeys;
        protected final Tuple result;

        ResultEntry(ImmutableBytesWritable[] sortKeys, Tuple result) {
            this.sortKeys = sortKeys;
            this.result = result;
        }

        ImmutableBytesWritable getSortKey(int index) {
            Preconditions.checkPositionIndex((int)index, (int)this.sortKeys.length);
            return this.sortKeys[index];
        }

        Tuple getResult() {
            return this.result;
        }
    }
}

