/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.hbase.client.AbstractClientScanner;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.ScanningResultIterator;
import org.apache.phoenix.monitoring.ScanMetricsHolder;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.StaleRegionBoundaryCacheException;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.Closeables;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.ServerUtil;

public class TableResultIterator
implements ResultIterator {
    private final Scan scan;
    private final HTableInterface htable;
    private final ScanMetricsHolder scanMetricsHolder;
    private static final ResultIterator UNINITIALIZED_SCANNER = ResultIterator.EMPTY_ITERATOR;
    private final long renewLeaseThreshold;
    private final QueryPlan plan;
    private final ParallelScanGrouper scanGrouper;
    private Tuple lastTuple = null;
    private ImmutableBytesWritable ptr = new ImmutableBytesWritable();
    @GuardedBy(value="renewLeaseLock")
    private ResultIterator scanIterator;
    @GuardedBy(value="renewLeaseLock")
    private boolean closed = false;
    @GuardedBy(value="renewLeaseLock")
    private long renewLeaseTime = 0L;
    private final Lock renewLeaseLock = new ReentrantLock();

    @VisibleForTesting
    TableResultIterator() {
        this.scanMetricsHolder = null;
        this.renewLeaseThreshold = 0L;
        this.htable = null;
        this.scan = null;
        this.plan = null;
        this.scanGrouper = null;
    }

    public TableResultIterator(MutationState mutationState, Scan scan, ScanMetricsHolder scanMetricsHolder, long renewLeaseThreshold, QueryPlan plan, ParallelScanGrouper scanGrouper) throws SQLException {
        this.scan = scan;
        this.scanMetricsHolder = scanMetricsHolder;
        this.plan = plan;
        PTable table = plan.getTableRef().getTable();
        this.htable = mutationState.getHTable(table);
        this.scanIterator = UNINITIALIZED_SCANNER;
        this.renewLeaseThreshold = renewLeaseThreshold;
        this.scanGrouper = scanGrouper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try {
            this.renewLeaseLock.lock();
            this.closed = true;
            try {
                this.scanIterator.close();
            }
            finally {
                try {
                    this.scanIterator = UNINITIALIZED_SCANNER;
                    this.htable.close();
                }
                catch (IOException e) {
                    throw ServerUtil.parseServerException(e);
                }
            }
        }
        finally {
            this.renewLeaseLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tuple next() throws SQLException {
        try {
            block12: {
                this.renewLeaseLock.lock();
                this.initScanner();
                try {
                    this.lastTuple = this.scanIterator.next();
                    if (this.lastTuple != null) {
                        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                        this.lastTuple.getKey(ptr);
                    }
                }
                catch (SQLException e) {
                    try {
                        throw ServerUtil.parseServerException(e);
                    }
                    catch (StaleRegionBoundaryCacheException e1) {
                        if (ScanUtil.isNonAggregateScan(this.scan)) {
                            Scan newScan = ScanUtil.newScan(this.scan);
                            newScan.setStartRow(newScan.getAttribute("_ScanActualStartRow"));
                            if (this.lastTuple != null) {
                                this.lastTuple.getKey(this.ptr);
                                byte[] startRowSuffix = ByteUtil.copyKeyBytesIfNecessary(this.ptr);
                                if (ScanUtil.isLocalIndex(newScan)) {
                                    newScan.setAttribute("_ScanStartRowSuffix", ByteUtil.nextKey(startRowSuffix));
                                } else {
                                    newScan.setStartRow(ByteUtil.nextKey(startRowSuffix));
                                }
                            }
                            this.plan.getContext().getConnection().getQueryServices().clearTableRegionCache(this.htable.getTableName());
                            this.scanIterator = this.plan.iterator(this.scanGrouper, newScan);
                            this.lastTuple = this.scanIterator.next();
                            break block12;
                        }
                        throw e;
                    }
                }
            }
            Tuple tuple = this.lastTuple;
            return tuple;
        }
        finally {
            this.renewLeaseLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initScanner() throws SQLException {
        block7: {
            try {
                this.renewLeaseLock.lock();
                if (this.closed) {
                    return;
                }
                ResultIterator delegate = this.scanIterator;
                if (delegate != UNINITIALIZED_SCANNER) break block7;
                try {
                    this.scanIterator = new ScanningResultIterator(this.htable.getScanner(this.scan), this.scan, this.scanMetricsHolder);
                }
                catch (IOException e) {
                    Closeables.closeQuietly((Closeable)this.htable);
                    throw ServerUtil.parseServerException(e);
                }
            }
            finally {
                this.renewLeaseLock.unlock();
            }
        }
    }

    public String toString() {
        return "TableResultIterator [htable=" + this.htable + ", scan=" + this.scan + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenewLeaseStatus renewLease() {
        boolean lockAcquired = false;
        try {
            lockAcquired = this.renewLeaseLock.tryLock();
            if (lockAcquired) {
                if (this.closed) {
                    RenewLeaseStatus renewLeaseStatus = RenewLeaseStatus.CLOSED;
                    return renewLeaseStatus;
                }
                if (this.scanIterator == UNINITIALIZED_SCANNER) {
                    RenewLeaseStatus renewLeaseStatus = RenewLeaseStatus.UNINITIALIZED;
                    return renewLeaseStatus;
                }
                long delay = TableResultIterator.now() - this.renewLeaseTime;
                if (delay < this.renewLeaseThreshold) {
                    RenewLeaseStatus renewLeaseStatus = RenewLeaseStatus.THRESHOLD_NOT_REACHED;
                    return renewLeaseStatus;
                }
                if (this.scanIterator instanceof ScanningResultIterator && ((ScanningResultIterator)this.scanIterator).getScanner() instanceof AbstractClientScanner) {
                    boolean leaseRenewed = ((AbstractClientScanner)((ScanningResultIterator)this.scanIterator).getScanner()).renewLease();
                    if (leaseRenewed) {
                        this.renewLeaseTime = TableResultIterator.now();
                        RenewLeaseStatus renewLeaseStatus = RenewLeaseStatus.RENEWED;
                        return renewLeaseStatus;
                    }
                    RenewLeaseStatus renewLeaseStatus = RenewLeaseStatus.NOT_RENEWED;
                    return renewLeaseStatus;
                }
                RenewLeaseStatus renewLeaseStatus = RenewLeaseStatus.NOT_SUPPORTED;
                return renewLeaseStatus;
            }
            RenewLeaseStatus renewLeaseStatus = RenewLeaseStatus.LOCK_NOT_ACQUIRED;
            return renewLeaseStatus;
        }
        finally {
            if (lockAcquired) {
                this.renewLeaseLock.unlock();
            }
        }
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    @Override
    public void explain(List<String> planSteps) {
        this.scanIterator.explain(planSteps);
    }

    public static enum RenewLeaseStatus {
        RENEWED,
        NOT_RENEWED,
        CLOSED,
        UNINITIALIZED,
        THRESHOLD_NOT_REACHED,
        LOCK_NOT_ACQUIRED,
        NOT_SUPPORTED;

    }
}

