/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import com.google.common.base.Throwables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.math.IntMath;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.call.CallRunner;
import org.apache.phoenix.compile.BaseMutationPlan;
import org.apache.phoenix.compile.CloseStatementCompiler;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.CreateFunctionCompiler;
import org.apache.phoenix.compile.CreateIndexCompiler;
import org.apache.phoenix.compile.CreateSchemaCompiler;
import org.apache.phoenix.compile.CreateSequenceCompiler;
import org.apache.phoenix.compile.CreateTableCompiler;
import org.apache.phoenix.compile.DeclareCursorCompiler;
import org.apache.phoenix.compile.DeleteCompiler;
import org.apache.phoenix.compile.DropSequenceCompiler;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExpressionProjector;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.ListJarsQueryPlan;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.OpenStatementCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.QueryCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.SequenceManager;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.StatementNormalizer;
import org.apache.phoenix.compile.StatementPlan;
import org.apache.phoenix.compile.SubqueryRewriter;
import org.apache.phoenix.compile.SubselectRewriter;
import org.apache.phoenix.compile.TraceQueryPlan;
import org.apache.phoenix.compile.UpsertCompiler;
import org.apache.phoenix.exception.BatchUpdateExecution;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.exception.UpgradeRequiredException;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.iterate.MaterializedResultIterator;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixParameterMetaData;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.parse.AddColumnStatement;
import org.apache.phoenix.parse.AddJarsStatement;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.AlterIndexStatement;
import org.apache.phoenix.parse.AlterSessionStatement;
import org.apache.phoenix.parse.BindableStatement;
import org.apache.phoenix.parse.CloseStatement;
import org.apache.phoenix.parse.ColumnDef;
import org.apache.phoenix.parse.ColumnName;
import org.apache.phoenix.parse.CreateFunctionStatement;
import org.apache.phoenix.parse.CreateIndexStatement;
import org.apache.phoenix.parse.CreateSchemaStatement;
import org.apache.phoenix.parse.CreateSequenceStatement;
import org.apache.phoenix.parse.CreateTableStatement;
import org.apache.phoenix.parse.CursorName;
import org.apache.phoenix.parse.DeclareCursorStatement;
import org.apache.phoenix.parse.DeleteJarStatement;
import org.apache.phoenix.parse.DeleteStatement;
import org.apache.phoenix.parse.DropColumnStatement;
import org.apache.phoenix.parse.DropFunctionStatement;
import org.apache.phoenix.parse.DropIndexStatement;
import org.apache.phoenix.parse.DropSchemaStatement;
import org.apache.phoenix.parse.DropSequenceStatement;
import org.apache.phoenix.parse.DropTableStatement;
import org.apache.phoenix.parse.ExecuteUpgradeStatement;
import org.apache.phoenix.parse.ExplainStatement;
import org.apache.phoenix.parse.FetchStatement;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.IndexKeyConstraint;
import org.apache.phoenix.parse.LimitNode;
import org.apache.phoenix.parse.ListJarsStatement;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.NamedNode;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.OffsetNode;
import org.apache.phoenix.parse.OpenStatement;
import org.apache.phoenix.parse.OrderByNode;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.PrimaryKeyConstraint;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.TableNode;
import org.apache.phoenix.parse.TraceStatement;
import org.apache.phoenix.parse.UDFParseNode;
import org.apache.phoenix.parse.UpdateStatisticsStatement;
import org.apache.phoenix.parse.UpsertStatement;
import org.apache.phoenix.parse.UseSchemaStatement;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ExecuteQueryNotApplicableException;
import org.apache.phoenix.schema.ExecuteUpdateNotApplicableException;
import org.apache.phoenix.schema.FunctionNotFoundException;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.MetaDataEntityNotFoundException;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeyValueAccessor;
import org.apache.phoenix.schema.Sequence;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.stats.StatisticsCollectionScope;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.CursorUtil;
import org.apache.phoenix.util.KeyValueUtil;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.PhoenixContextExecutor;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SQLCloseable;
import org.apache.phoenix.util.SQLCloseables;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixStatement
implements Statement,
SQLCloseable {
    private static final Logger logger = LoggerFactory.getLogger(PhoenixStatement.class);
    protected final PhoenixConnection connection;
    private static final int NO_UPDATE = -1;
    private List<PhoenixResultSet> resultSets = new ArrayList<PhoenixResultSet>();
    private QueryPlan lastQueryPlan;
    private PhoenixResultSet lastResultSet;
    private int lastUpdateCount = -1;
    private Operation lastUpdateOperation;
    private boolean isClosed = false;
    private int maxRows;
    private int fetchSize = -1;
    private int queryTimeoutMillis;
    private boolean lastExplainQuery = false;
    private static final byte[] EXPLAIN_PLAN_FAMILY = QueryConstants.SINGLE_COLUMN_FAMILY;
    private static final byte[] EXPLAIN_PLAN_COLUMN = PVarchar.INSTANCE.toBytes("Plan");
    private static final String EXPLAIN_PLAN_ALIAS = "PLAN";
    private static final String EXPLAIN_PLAN_TABLE_NAME = "PLAN_TABLE";
    private static final PDatum EXPLAIN_PLAN_DATUM = new PDatum(){

        @Override
        public boolean isNullable() {
            return false;
        }

        @Override
        public PDataType getDataType() {
            return PVarchar.INSTANCE;
        }

        @Override
        public Integer getMaxLength() {
            return null;
        }

        @Override
        public Integer getScale() {
            return null;
        }

        @Override
        public SortOrder getSortOrder() {
            return SortOrder.getDefault();
        }
    };
    private static final String EXPLAIN_PLAN_BYTES_ESTIMATE_COLUMN_NAME = "BytesEstimate";
    private static final byte[] EXPLAIN_PLAN_BYTES_ESTIMATE = PVarchar.INSTANCE.toBytes("BytesEstimate");
    private static final String EXPLAIN_PLAN_ROWS_ESTIMATE_COLUMN_NAME = "RowsEstimate";
    private static final byte[] EXPLAIN_PLAN_ROWS_ESTIMATE = PVarchar.INSTANCE.toBytes("RowsEstimate");
    public static final String EXPLAIN_PLAN_BYTES_ESTIMATE_COLUMN_ALIAS = "EST_BYTES_READ";
    public static final String EXPLAIN_PLAN_ROWS_COLUMN_ALIAS = "EST_ROWS_READ";
    private static final PColumnImpl EXPLAIN_PLAN_BYTES_ESTIMATE_COLUMN = new PColumnImpl(PNameFactory.newName(EXPLAIN_PLAN_BYTES_ESTIMATE), PNameFactory.newName(EXPLAIN_PLAN_FAMILY), PLong.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, EXPLAIN_PLAN_BYTES_ESTIMATE);
    private static final PColumnImpl EXPLAIN_PLAN_ROWS_ESTIMATE_COLUMN = new PColumnImpl(PNameFactory.newName(EXPLAIN_PLAN_ROWS_ESTIMATE), PNameFactory.newName(EXPLAIN_PLAN_FAMILY), PLong.INSTANCE, null, null, false, 2, SortOrder.getDefault(), 0, null, false, null, false, false, EXPLAIN_PLAN_ROWS_ESTIMATE);
    private static final RowProjector EXPLAIN_PLAN_ROW_PROJECTOR_WITH_BYTE_ROW_ESTIMATES = new RowProjector(Arrays.asList(new ExpressionProjector("PLAN", "PLAN_TABLE", new RowKeyColumnExpression(EXPLAIN_PLAN_DATUM, new RowKeyValueAccessor(Collections.singletonList(EXPLAIN_PLAN_DATUM), 0)), false), new ExpressionProjector("EST_BYTES_READ", "PLAN_TABLE", new KeyValueColumnExpression(EXPLAIN_PLAN_BYTES_ESTIMATE_COLUMN), false), new ExpressionProjector("EST_ROWS_READ", "PLAN_TABLE", new KeyValueColumnExpression(EXPLAIN_PLAN_ROWS_ESTIMATE_COLUMN), false)), 0, true);
    protected final List<PhoenixPreparedStatement> batch = Lists.newArrayList();

    public PhoenixStatement(PhoenixConnection connection) {
        this.connection = connection;
        this.queryTimeoutMillis = this.getDefaultQueryTimeoutMillis();
    }

    private int getDefaultQueryTimeoutMillis() {
        return this.connection.getQueryServices().getProps().getInt("phoenix.query.timeoutMs", 600000);
    }

    protected List<PhoenixResultSet> getResultSets() {
        return this.resultSets;
    }

    public PhoenixResultSet newResultSet(ResultIterator iterator, RowProjector projector, StatementContext context) throws SQLException {
        return new PhoenixResultSet(iterator, projector, context);
    }

    protected boolean execute(CompilableStatement stmt) throws SQLException {
        if (stmt.getOperation().isMutation()) {
            this.executeMutation(stmt);
            return false;
        }
        this.executeQuery(stmt);
        return true;
    }

    protected QueryPlan optimizeQuery(CompilableStatement stmt) throws SQLException {
        QueryPlan plan = (QueryPlan)stmt.compilePlan(this, Sequence.ValueOp.VALIDATE_SEQUENCE);
        return this.connection.getQueryServices().getOptimizer().optimize(this, plan);
    }

    protected PhoenixResultSet executeQuery(CompilableStatement stmt) throws SQLException {
        return this.executeQuery(stmt, true);
    }

    private PhoenixResultSet executeQuery(final CompilableStatement stmt, final boolean doRetryOnMetaNotFoundError) throws SQLException {
        this.lastExplainQuery = false;
        GlobalClientMetrics.GLOBAL_SELECT_SQL_COUNTER.increment();
        try {
            return (PhoenixResultSet)CallRunner.run(new CallRunner.CallableThrowable<PhoenixResultSet, SQLException>(){

                @Override
                public PhoenixResultSet call() throws SQLException {
                    long startTime = System.currentTimeMillis();
                    try {
                        PhoenixConnection conn = PhoenixStatement.this.getConnection();
                        if (conn.getQueryServices().isUpgradeRequired() && !conn.isRunningUpgrade() && stmt.getOperation() != Operation.UPGRADE) {
                            throw new UpgradeRequiredException();
                        }
                        QueryPlan plan = (QueryPlan)stmt.compilePlan(PhoenixStatement.this, Sequence.ValueOp.VALIDATE_SEQUENCE);
                        Iterator<TableRef> tableRefs = plan.getSourceRefs().iterator();
                        PhoenixStatement.this.connection.getMutationState().sendUncommitted(tableRefs);
                        plan = PhoenixStatement.this.connection.getQueryServices().getOptimizer().optimize(PhoenixStatement.this, plan);
                        ResultIterator resultIterator = plan.iterator();
                        if (logger.isDebugEnabled()) {
                            String explainPlan = QueryUtil.getExplainPlan(resultIterator);
                            logger.debug(LogUtil.addCustomAnnotations("Explain plan: " + explainPlan, PhoenixStatement.this.connection));
                        }
                        StatementContext context = plan.getContext();
                        context.getOverallQueryMetrics().startQuery();
                        PhoenixResultSet rs = PhoenixStatement.this.newResultSet(resultIterator, plan.getProjector(), plan.getContext());
                        PhoenixStatement.this.resultSets.add(rs);
                        PhoenixStatement.this.setLastQueryPlan(plan);
                        PhoenixStatement.this.setLastResultSet(rs);
                        PhoenixStatement.this.setLastUpdateCount(-1);
                        PhoenixStatement.this.setLastUpdateOperation(stmt.getOperation());
                        if (PhoenixStatement.this.connection.getAutoCommit()) {
                            PhoenixStatement.this.connection.commit();
                        }
                        PhoenixStatement.this.connection.incrementStatementExecutionCounter();
                        PhoenixResultSet phoenixResultSet = rs;
                        return phoenixResultSet;
                    }
                    catch (MetaDataEntityNotFoundException e) {
                        if (doRetryOnMetaNotFoundError && e.getTableName() != null) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Reloading table " + e.getTableName() + " data from server");
                            }
                            if (new MetaDataClient(PhoenixStatement.this.connection).updateCache(PhoenixStatement.this.connection.getTenantId(), e.getSchemaName(), e.getTableName(), true).wasUpdated()) {
                                PhoenixResultSet phoenixResultSet = PhoenixStatement.this.executeQuery(stmt, false);
                                return phoenixResultSet;
                            }
                        }
                        throw e;
                    }
                    catch (RuntimeException e) {
                        if (e.getCause() instanceof SQLException) {
                            throw (SQLException)e.getCause();
                        }
                        throw e;
                    }
                    finally {
                        GlobalClientMetrics.GLOBAL_QUERY_TIME.update(System.currentTimeMillis() - startTime);
                    }
                }
            }, PhoenixContextExecutor.inContext());
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, SQLException.class);
            Throwables.propagate((Throwable)e);
            throw new IllegalStateException();
        }
    }

    protected int executeMutation(CompilableStatement stmt) throws SQLException {
        return this.executeMutation(stmt, true);
    }

    private int executeMutation(final CompilableStatement stmt, final boolean doRetryOnMetaNotFoundError) throws SQLException {
        this.lastExplainQuery = false;
        if (this.connection.isReadOnly()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.READ_ONLY_CONNECTION).build().buildException();
        }
        GlobalClientMetrics.GLOBAL_MUTATION_SQL_COUNTER.increment();
        try {
            return (Integer)CallRunner.run(new CallRunner.CallableThrowable<Integer, SQLException>(){

                @Override
                public Integer call() throws SQLException {
                    try {
                        PhoenixConnection conn = PhoenixStatement.this.getConnection();
                        if (conn.getQueryServices().isUpgradeRequired() && !conn.isRunningUpgrade() && stmt.getOperation() != Operation.UPGRADE) {
                            throw new UpgradeRequiredException();
                        }
                        MutationState state2 = PhoenixStatement.this.connection.getMutationState();
                        MutationPlan plan = (MutationPlan)stmt.compilePlan(PhoenixStatement.this, Sequence.ValueOp.VALIDATE_SEQUENCE);
                        if (plan.getTargetRef() != null && plan.getTargetRef().getTable() != null && plan.getTargetRef().getTable().isTransactional()) {
                            state2.startTransaction();
                        }
                        Iterator<TableRef> tableRefs = plan.getSourceRefs().iterator();
                        state2.sendUncommitted(tableRefs);
                        state2.checkpointIfNeccessary(plan);
                        MutationState lastState = plan.execute();
                        state2.join(lastState);
                        if (PhoenixStatement.this.connection.getAutoCommit()) {
                            PhoenixStatement.this.connection.commit();
                        }
                        PhoenixStatement.this.setLastResultSet(null);
                        PhoenixStatement.this.setLastQueryPlan(null);
                        int lastUpdateCount = (int)Math.min(Integer.MAX_VALUE, lastState.getUpdateCount());
                        PhoenixStatement.this.setLastUpdateCount(lastUpdateCount);
                        PhoenixStatement.this.setLastUpdateOperation(stmt.getOperation());
                        PhoenixStatement.this.connection.incrementStatementExecutionCounter();
                        return lastUpdateCount;
                    }
                    catch (MetaDataEntityNotFoundException e) {
                        if (doRetryOnMetaNotFoundError && e.getTableName() != null) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Reloading table " + e.getTableName() + " data from server");
                            }
                            if (new MetaDataClient(PhoenixStatement.this.connection).updateCache(PhoenixStatement.this.connection.getTenantId(), e.getSchemaName(), e.getTableName(), true).wasUpdated()) {
                                return PhoenixStatement.this.executeMutation(stmt, false);
                            }
                        }
                        throw e;
                    }
                    catch (RuntimeException e) {
                        if (e.getCause() instanceof SQLException) {
                            throw (SQLException)e.getCause();
                        }
                        throw e;
                    }
                }
            }, PhoenixContextExecutor.inContext(), Tracing.withTracing(this.connection, this.toString()));
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, SQLException.class);
            Throwables.propagate((Throwable)e);
            throw new IllegalStateException();
        }
    }

    public Format getFormatter(PDataType type) {
        return this.connection.getFormatter(type);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.batch.add(new PhoenixPreparedStatement(this.connection, sql));
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batch.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int i = 0;
        try {
            int[] returnCodes = new int[this.batch.size()];
            for (i = 0; i < returnCodes.length; ++i) {
                PhoenixPreparedStatement statement = this.batch.get(i);
                returnCodes[i] = statement.execute(true) ? -2 : statement.getUpdateCount();
            }
            this.flushIfNecessary();
            this.clearBatch();
            return returnCodes;
        }
        catch (Throwable t) {
            throw new BatchUpdateExecution(t, i);
        }
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try {
            List<PhoenixResultSet> resultSets = this.resultSets;
            this.resultSets = Lists.newArrayList();
            SQLCloseables.closeAll(resultSets);
        }
        finally {
            try {
                this.connection.removeStatement(this);
            }
            finally {
                this.isClosed = true;
            }
        }
    }

    public List<Object> getParameters() {
        return Collections.emptyList();
    }

    protected CompilableStatement parseStatement(String sql) throws SQLException {
        PhoenixStatementParser parser = null;
        try {
            parser = new PhoenixStatementParser(sql, (ParseNodeFactory)new ExecutableNodeFactory());
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
        CompilableStatement statement = parser.parseStatement();
        return statement;
    }

    public QueryPlan optimizeQuery(String sql) throws SQLException {
        QueryPlan plan = this.compileQuery(sql);
        return this.connection.getQueryServices().getOptimizer().optimize(this, plan);
    }

    public QueryPlan compileQuery(String sql) throws SQLException {
        CompilableStatement stmt = this.parseStatement(sql);
        return this.compileQuery(stmt, sql);
    }

    public QueryPlan compileQuery(CompilableStatement stmt, String query) throws SQLException {
        if (stmt.getOperation().isMutation()) {
            throw new ExecuteQueryNotApplicableException(query);
        }
        return (QueryPlan)stmt.compilePlan(this, Sequence.ValueOp.VALIDATE_SEQUENCE);
    }

    public MutationPlan compileMutation(CompilableStatement stmt, String query) throws SQLException {
        if (!stmt.getOperation().isMutation()) {
            throw new ExecuteUpdateNotApplicableException(query);
        }
        return (MutationPlan)stmt.compilePlan(this, Sequence.ValueOp.VALIDATE_SEQUENCE);
    }

    public MutationPlan compileMutation(String sql) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug(LogUtil.addCustomAnnotations("Execute update: " + sql, this.connection));
        }
        CompilableStatement stmt = this.parseStatement(sql);
        return this.compileMutation(stmt, sql);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        CompilableStatement stmt;
        if (logger.isDebugEnabled()) {
            logger.debug(LogUtil.addCustomAnnotations("Execute query: " + sql, this.connection));
        }
        if ((stmt = this.parseStatement(sql)).getOperation().isMutation()) {
            throw new ExecuteQueryNotApplicableException(sql);
        }
        return this.executeQuery(stmt);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        CompilableStatement stmt = this.parseStatement(sql);
        if (!stmt.getOperation().isMutation) {
            throw new ExecuteUpdateNotApplicableException(sql);
        }
        if (!this.batch.isEmpty()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.EXECUTE_UPDATE_WITH_NON_EMPTY_BATCH).build().buildException();
        }
        int updateCount = this.executeMutation(stmt);
        this.flushIfNecessary();
        return updateCount;
    }

    private void flushIfNecessary() throws SQLException {
        if (this.connection.getAutoFlush()) {
            this.connection.flush();
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        CompilableStatement stmt = this.parseStatement(sql);
        if (stmt.getOperation().isMutation()) {
            if (!this.batch.isEmpty()) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.EXECUTE_UPDATE_WITH_NON_EMPTY_BATCH).build().buildException();
            }
            this.executeMutation(stmt);
            this.flushIfNecessary();
            return false;
        }
        this.executeQuery(stmt);
        return true;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public PhoenixConnection getConnection() {
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.fetchSize > 0) {
            return this.fetchSize;
        }
        return this.connection.getQueryServices().getProps().getInt("hbase.client.scanner.caching", 1000);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    public QueryPlan getQueryPlan() {
        return this.getLastQueryPlan();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        PhoenixResultSet rs = this.getLastResultSet();
        this.setLastResultSet(null);
        return rs;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1003;
    }

    public Operation getUpdateOperation() {
        return this.getLastUpdateOperation();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        int updateCount = this.getLastUpdateCount();
        this.setLastUpdateCount(-1);
        return updateCount;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.fetchSize = fetchSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.maxRows = max;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        if (poolable) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeoutMillis = seconds < 0 ? this.getDefaultQueryTimeoutMillis() : (seconds == 0 ? Integer.MAX_VALUE : seconds * 1000);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        int scaledValue;
        try {
            scaledValue = IntMath.checkedAdd((int)this.queryTimeoutMillis, (int)999);
        }
        catch (ArithmeticException e) {
            scaledValue = Integer.MAX_VALUE;
        }
        return scaledValue / 1000;
    }

    public int getQueryTimeoutInMillis() {
        return this.queryTimeoutMillis;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!iface.isInstance(this)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CLASS_NOT_UNWRAPPABLE).setMessage(this.getClass().getName() + " not unwrappable from " + iface.getName()).build().buildException();
        }
        return (T)this;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    private PhoenixResultSet getLastResultSet() {
        return this.lastResultSet;
    }

    private void setLastResultSet(PhoenixResultSet lastResultSet) {
        this.lastResultSet = lastResultSet;
    }

    private int getLastUpdateCount() {
        return this.lastUpdateCount;
    }

    private void setLastUpdateCount(int lastUpdateCount) {
        this.lastUpdateCount = lastUpdateCount;
    }

    private Operation getLastUpdateOperation() {
        return this.lastUpdateOperation;
    }

    private void setLastUpdateOperation(Operation lastUpdateOperation) {
        this.lastUpdateOperation = lastUpdateOperation;
    }

    private QueryPlan getLastQueryPlan() {
        return this.lastQueryPlan;
    }

    private void setLastQueryPlan(QueryPlan lastQueryPlan) {
        this.lastQueryPlan = lastQueryPlan;
    }

    private void throwIfUnallowedUserDefinedFunctions(Map<String, UDFParseNode> udfParseNodes) throws SQLException {
        if (!this.connection.getQueryServices().getProps().getBoolean("phoenix.functions.allowUserDefinedFunctions", false)) {
            if (udfParseNodes.isEmpty()) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.UNALLOWED_USER_DEFINED_FUNCTIONS).build().buildException();
            }
            throw new FunctionNotFoundException(udfParseNodes.keySet().toString());
        }
    }

    public boolean isLastExplainQuery() {
        return this.lastExplainQuery;
    }

    public void setLastExplainQuery(boolean lastExplainQuery) {
        this.lastExplainQuery = lastExplainQuery;
    }

    static class PhoenixStatementParser
    extends SQLParser {
        PhoenixStatementParser(String query, ParseNodeFactory nodeFactory) throws IOException {
            super(query, nodeFactory);
        }

        PhoenixStatementParser(Reader reader) throws IOException {
            super(reader);
        }

        @Override
        public CompilableStatement nextStatement(ParseNodeFactory nodeFactory) throws SQLException {
            return (CompilableStatement)super.nextStatement(nodeFactory);
        }

        @Override
        public CompilableStatement parseStatement() throws SQLException {
            return (CompilableStatement)super.parseStatement();
        }
    }

    protected static class ExecutableNodeFactory
    extends ParseNodeFactory {
        protected ExecutableNodeFactory() {
        }

        @Override
        public ExecutableSelectStatement select(TableNode from, HintNode hint, boolean isDistinct, List<AliasedNode> select, ParseNode where, List<ParseNode> groupBy, ParseNode having, List<OrderByNode> orderBy, LimitNode limit, OffsetNode offset, int bindCount, boolean isAggregate, boolean hasSequence, List<SelectStatement> selects, Map<String, UDFParseNode> udfParseNodes) {
            return new ExecutableSelectStatement(from, hint, isDistinct, select, where, groupBy == null ? Collections.emptyList() : groupBy, having, orderBy == null ? Collections.emptyList() : orderBy, limit, offset, bindCount, isAggregate, hasSequence, selects == null ? Collections.emptyList() : selects, udfParseNodes);
        }

        @Override
        public ExecutableUpsertStatement upsert(NamedTableNode table, HintNode hintNode, List<ColumnName> columns, List<ParseNode> values, SelectStatement select, int bindCount, Map<String, UDFParseNode> udfParseNodes, List<Pair<ColumnName, ParseNode>> onDupKeyPairs) {
            return new ExecutableUpsertStatement(table, hintNode, columns, values, select, bindCount, udfParseNodes, onDupKeyPairs);
        }

        @Override
        public ExecutableDeclareCursorStatement declareCursor(CursorName cursor, SelectStatement select) {
            return new ExecutableDeclareCursorStatement(cursor, select);
        }

        @Override
        public ExecutableFetchStatement fetch(CursorName cursor, boolean isNext, int fetchLimit) {
            return new ExecutableFetchStatement(cursor, isNext, fetchLimit);
        }

        @Override
        public ExecutableOpenStatement open(CursorName cursor) {
            return new ExecutableOpenStatement(cursor);
        }

        @Override
        public ExecutableCloseStatement close(CursorName cursor) {
            return new ExecutableCloseStatement(cursor);
        }

        @Override
        public ExecutableDeleteStatement delete(NamedTableNode table, HintNode hint, ParseNode whereNode, List<OrderByNode> orderBy, LimitNode limit, int bindCount, Map<String, UDFParseNode> udfParseNodes) {
            return new ExecutableDeleteStatement(table, hint, whereNode, orderBy, limit, bindCount, udfParseNodes);
        }

        @Override
        public CreateTableStatement createTable(TableName tableName, ListMultimap<String, Pair<String, Object>> props, List<ColumnDef> columns, PrimaryKeyConstraint pkConstraint, List<ParseNode> splits, PTableType tableType, boolean ifNotExists, TableName baseTableName, ParseNode tableTypeIdNode, int bindCount, Boolean immutableRows) {
            return new ExecutableCreateTableStatement(tableName, props, columns, pkConstraint, splits, tableType, ifNotExists, baseTableName, tableTypeIdNode, bindCount, immutableRows);
        }

        @Override
        public CreateSchemaStatement createSchema(String schemaName, boolean ifNotExists) {
            return new ExecutableCreateSchemaStatement(schemaName, ifNotExists);
        }

        @Override
        public CreateSequenceStatement createSequence(TableName tableName, ParseNode startsWith, ParseNode incrementBy, ParseNode cacheSize, ParseNode minValue, ParseNode maxValue, boolean cycle, boolean ifNotExists, int bindCount) {
            return new ExecutableCreateSequenceStatement(tableName, startsWith, incrementBy, cacheSize, minValue, maxValue, cycle, ifNotExists, bindCount);
        }

        @Override
        public CreateFunctionStatement createFunction(PFunction functionInfo, boolean temporary, boolean isReplace) {
            return new ExecutableCreateFunctionStatement(functionInfo, temporary, isReplace);
        }

        @Override
        public AddJarsStatement addJars(List<LiteralParseNode> jarPaths) {
            return new ExecutableAddJarsStatement(jarPaths);
        }

        @Override
        public DeleteJarStatement deleteJar(LiteralParseNode jarPath) {
            return new ExecutableDeleteJarStatement(jarPath);
        }

        @Override
        public ListJarsStatement listJars() {
            return new ExecutableListJarsStatement();
        }

        @Override
        public DropSequenceStatement dropSequence(TableName tableName, boolean ifExists, int bindCount) {
            return new ExecutableDropSequenceStatement(tableName, ifExists, bindCount);
        }

        @Override
        public CreateIndexStatement createIndex(NamedNode indexName, NamedTableNode dataTable, IndexKeyConstraint ikConstraint, List<ColumnName> includeColumns, List<ParseNode> splits, ListMultimap<String, Pair<String, Object>> props, boolean ifNotExists, PTable.IndexType indexType, boolean async, int bindCount, Map<String, UDFParseNode> udfParseNodes) {
            return new ExecutableCreateIndexStatement(indexName, dataTable, ikConstraint, includeColumns, splits, props, ifNotExists, indexType, async, bindCount, udfParseNodes);
        }

        @Override
        public AddColumnStatement addColumn(NamedTableNode table, PTableType tableType, List<ColumnDef> columnDefs, boolean ifNotExists, ListMultimap<String, Pair<String, Object>> props) {
            return new ExecutableAddColumnStatement(table, tableType, columnDefs, ifNotExists, props);
        }

        @Override
        public DropColumnStatement dropColumn(NamedTableNode table, PTableType tableType, List<ColumnName> columnNodes, boolean ifExists) {
            return new ExecutableDropColumnStatement(table, tableType, columnNodes, ifExists);
        }

        @Override
        public DropTableStatement dropTable(TableName tableName, PTableType tableType, boolean ifExists, boolean cascade) {
            return new ExecutableDropTableStatement(tableName, tableType, ifExists, cascade);
        }

        @Override
        public DropSchemaStatement dropSchema(String schemaName, boolean ifExists, boolean cascade) {
            return new ExecutableDropSchemaStatement(schemaName, ifExists, cascade);
        }

        @Override
        public UseSchemaStatement useSchema(String schemaName) {
            return new ExecutableUseSchemaStatement(schemaName);
        }

        @Override
        public DropFunctionStatement dropFunction(String functionName, boolean ifExists) {
            return new ExecutableDropFunctionStatement(functionName, ifExists);
        }

        @Override
        public DropIndexStatement dropIndex(NamedNode indexName, TableName tableName, boolean ifExists) {
            return new ExecutableDropIndexStatement(indexName, tableName, ifExists);
        }

        @Override
        public AlterIndexStatement alterIndex(NamedTableNode indexTableNode, String dataTableName, boolean ifExists, PIndexState state2, boolean async) {
            return new ExecutableAlterIndexStatement(indexTableNode, dataTableName, ifExists, state2, async);
        }

        @Override
        public TraceStatement trace(boolean isTraceOn, double samplingRate) {
            return new ExecutableTraceStatement(isTraceOn, samplingRate);
        }

        @Override
        public AlterSessionStatement alterSession(Map<String, Object> props) {
            return new ExecutableAlterSessionStatement(props);
        }

        @Override
        public ExplainStatement explain(BindableStatement statement) {
            return new ExecutableExplainStatement(statement);
        }

        @Override
        public UpdateStatisticsStatement updateStatistics(NamedTableNode table, StatisticsCollectionScope scope, Map<String, Object> props) {
            return new ExecutableUpdateStatisticsStatement(table, scope, props);
        }

        @Override
        public ExecuteUpgradeStatement executeUpgrade() {
            return new ExecutableExecuteUpgradeStatement();
        }
    }

    private static class ExecutableDropColumnStatement
    extends DropColumnStatement
    implements CompilableStatement {
        ExecutableDropColumnStatement(NamedTableNode table, PTableType tableType, List<ColumnName> columnRefs, boolean ifExists) {
            super(table, tableType, columnRefs, ifExists);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            StatementContext context = new StatementContext(stmt);
            return new BaseMutationPlan(context, this.getOperation()){

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("ALTER " + (Object)((Object)ExecutableDropColumnStatement.this.getTableType()) + " DROP COLUMN"));
                }

                @Override
                public MutationState execute() throws SQLException {
                    MetaDataClient client = new MetaDataClient(this.getContext().getConnection());
                    return client.dropColumn(ExecutableDropColumnStatement.this);
                }
            };
        }
    }

    private static class ExecutableAddColumnStatement
    extends AddColumnStatement
    implements CompilableStatement {
        ExecutableAddColumnStatement(NamedTableNode table, PTableType tableType, List<ColumnDef> columnDefs, boolean ifNotExists, ListMultimap<String, Pair<String, Object>> props) {
            super(table, tableType, columnDefs, ifNotExists, props);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            StatementContext context = new StatementContext(stmt);
            return new BaseMutationPlan(context, this.getOperation()){

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("ALTER " + (Object)((Object)ExecutableAddColumnStatement.this.getTableType()) + " ADD COLUMN"));
                }

                @Override
                public MutationState execute() throws SQLException {
                    MetaDataClient client = new MetaDataClient(this.getContext().getConnection());
                    return client.addColumn(ExecutableAddColumnStatement.this);
                }
            };
        }
    }

    private static class ExecutableExecuteUpgradeStatement
    extends ExecuteUpgradeStatement
    implements CompilableStatement {
        private ExecutableExecuteUpgradeStatement() {
        }

        public MutationPlan compilePlan(final PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            return new MutationPlan(){

                @Override
                public Set<TableRef> getSourceRefs() {
                    return Collections.emptySet();
                }

                @Override
                public ParameterMetaData getParameterMetaData() {
                    return PhoenixParameterMetaData.EMPTY_PARAMETER_META_DATA;
                }

                @Override
                public Operation getOperation() {
                    return Operation.UPGRADE;
                }

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("EXECUTE UPGRADE"));
                }

                @Override
                public StatementContext getContext() {
                    return new StatementContext(stmt);
                }

                @Override
                public TableRef getTargetRef() {
                    return TableRef.EMPTY_TABLE_REF;
                }

                @Override
                public MutationState execute() throws SQLException {
                    PhoenixConnection phxConn = stmt.getConnection();
                    Properties props = new Properties();
                    phxConn.getQueryServices().upgradeSystemTables(phxConn.getURL(), props);
                    return MutationState.emptyMutationState(-1L, -1L, phxConn);
                }

                @Override
                public Long getEstimatedRowsToScan() throws SQLException {
                    return 0L;
                }

                @Override
                public Long getEstimatedBytesToScan() throws SQLException {
                    return 0L;
                }
            };
        }
    }

    private static class ExecutableUpdateStatisticsStatement
    extends UpdateStatisticsStatement
    implements CompilableStatement {
        public ExecutableUpdateStatisticsStatement(NamedTableNode table, StatisticsCollectionScope scope, Map<String, Object> props) {
            super(table, scope, props);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            StatementContext context = new StatementContext(stmt);
            return new BaseMutationPlan(context, this.getOperation()){

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("UPDATE STATISTICS"));
                }

                @Override
                public MutationState execute() throws SQLException {
                    MetaDataClient client = new MetaDataClient(this.getContext().getConnection());
                    return client.updateStatistics(ExecutableUpdateStatisticsStatement.this);
                }
            };
        }
    }

    private static class ExecutableAlterSessionStatement
    extends AlterSessionStatement
    implements CompilableStatement {
        public ExecutableAlterSessionStatement(Map<String, Object> props) {
            super(props);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            final StatementContext context = new StatementContext(stmt);
            return new BaseMutationPlan(context, this.getOperation()){

                @Override
                public StatementContext getContext() {
                    return context;
                }

                @Override
                public ParameterMetaData getParameterMetaData() {
                    return PhoenixParameterMetaData.EMPTY_PARAMETER_META_DATA;
                }

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("ALTER SESSION"));
                }

                @Override
                public MutationState execute() throws SQLException {
                    Object consistency = ExecutableAlterSessionStatement.this.getProps().get("Consistency".toUpperCase());
                    if (consistency != null) {
                        if (((String)consistency).equalsIgnoreCase(Consistency.TIMELINE.toString())) {
                            this.getContext().getConnection().setConsistency(Consistency.TIMELINE);
                        } else {
                            this.getContext().getConnection().setConsistency(Consistency.STRONG);
                        }
                    }
                    return new MutationState(0L, 0L, context.getConnection());
                }
            };
        }
    }

    private static class ExecutableTraceStatement
    extends TraceStatement
    implements CompilableStatement {
        public ExecutableTraceStatement(boolean isTraceOn, double samplingRate) {
            super(isTraceOn, samplingRate);
        }

        public QueryPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            return new TraceQueryPlan(this, stmt);
        }
    }

    private static class ExecutableAlterIndexStatement
    extends AlterIndexStatement
    implements CompilableStatement {
        public ExecutableAlterIndexStatement(NamedTableNode indexTableNode, String dataTableName, boolean ifExists, PIndexState state2, boolean async) {
            super(indexTableNode, dataTableName, ifExists, state2, async);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            StatementContext context = new StatementContext(stmt);
            return new BaseMutationPlan(context, this.getOperation()){

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("ALTER INDEX"));
                }

                @Override
                public MutationState execute() throws SQLException {
                    MetaDataClient client = new MetaDataClient(this.getContext().getConnection());
                    return client.alterIndex(ExecutableAlterIndexStatement.this);
                }
            };
        }
    }

    private static class ExecutableDropIndexStatement
    extends DropIndexStatement
    implements CompilableStatement {
        public ExecutableDropIndexStatement(NamedNode indexName, TableName tableName, boolean ifExists) {
            super(indexName, tableName, ifExists);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            StatementContext context = new StatementContext(stmt);
            return new BaseMutationPlan(context, this.getOperation()){

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("DROP INDEX"));
                }

                @Override
                public MutationState execute() throws SQLException {
                    MetaDataClient client = new MetaDataClient(this.getContext().getConnection());
                    return client.dropIndex(ExecutableDropIndexStatement.this);
                }
            };
        }
    }

    private static class ExecutableUseSchemaStatement
    extends UseSchemaStatement
    implements CompilableStatement {
        ExecutableUseSchemaStatement(String schemaName) {
            super(schemaName);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            StatementContext context = new StatementContext(stmt);
            return new BaseMutationPlan(context, this.getOperation()){

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("USE SCHEMA"));
                }

                @Override
                public MutationState execute() throws SQLException {
                    MetaDataClient client = new MetaDataClient(this.getContext().getConnection());
                    return client.useSchema(ExecutableUseSchemaStatement.this);
                }
            };
        }
    }

    private static class ExecutableDropSchemaStatement
    extends DropSchemaStatement
    implements CompilableStatement {
        ExecutableDropSchemaStatement(String schemaName, boolean ifExists, boolean cascade) {
            super(schemaName, ifExists, cascade);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            StatementContext context = new StatementContext(stmt);
            return new BaseMutationPlan(context, this.getOperation()){

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("DROP SCHEMA"));
                }

                @Override
                public MutationState execute() throws SQLException {
                    MetaDataClient client = new MetaDataClient(this.getContext().getConnection());
                    return client.dropSchema(ExecutableDropSchemaStatement.this);
                }
            };
        }
    }

    private static class ExecutableDropTableStatement
    extends DropTableStatement
    implements CompilableStatement {
        ExecutableDropTableStatement(TableName tableName, PTableType tableType, boolean ifExists, boolean cascade) {
            super(tableName, tableType, ifExists, cascade);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            StatementContext context = new StatementContext(stmt);
            return new BaseMutationPlan(context, this.getOperation()){

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("DROP TABLE"));
                }

                @Override
                public MutationState execute() throws SQLException {
                    MetaDataClient client = new MetaDataClient(this.getContext().getConnection());
                    return client.dropTable(ExecutableDropTableStatement.this);
                }
            };
        }
    }

    private static class ExecutableDropSequenceStatement
    extends DropSequenceStatement
    implements CompilableStatement {
        public ExecutableDropSequenceStatement(TableName sequenceName, boolean ifExists, int bindCount) {
            super(sequenceName, ifExists, bindCount);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            DropSequenceCompiler compiler = new DropSequenceCompiler(stmt, this.getOperation());
            return compiler.compile(this);
        }
    }

    private static class ExecutableCreateSequenceStatement
    extends CreateSequenceStatement
    implements CompilableStatement {
        public ExecutableCreateSequenceStatement(TableName sequenceName, ParseNode startWith, ParseNode incrementBy, ParseNode cacheSize, ParseNode minValue, ParseNode maxValue, boolean cycle, boolean ifNotExists, int bindCount) {
            super(sequenceName, startWith, incrementBy, cacheSize, minValue, maxValue, cycle, ifNotExists, bindCount);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            CreateSequenceCompiler compiler = new CreateSequenceCompiler(stmt, this.getOperation());
            return compiler.compile(this);
        }
    }

    private static class ExecutableCreateIndexStatement
    extends CreateIndexStatement
    implements CompilableStatement {
        public ExecutableCreateIndexStatement(NamedNode indexName, NamedTableNode dataTable, IndexKeyConstraint ikConstraint, List<ColumnName> includeColumns, List<ParseNode> splits, ListMultimap<String, Pair<String, Object>> props, boolean ifNotExists, PTable.IndexType indexType, boolean async, int bindCount, Map<String, UDFParseNode> udfParseNodes) {
            super(indexName, dataTable, ikConstraint, includeColumns, splits, props, ifNotExists, indexType, async, bindCount, udfParseNodes);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            if (!this.getUdfParseNodes().isEmpty()) {
                stmt.throwIfUnallowedUserDefinedFunctions(this.getUdfParseNodes());
            }
            CreateIndexCompiler compiler = new CreateIndexCompiler(stmt, this.getOperation());
            return compiler.compile(this);
        }
    }

    private static class ExecutableListJarsStatement
    extends ListJarsStatement
    implements CompilableStatement {
        public QueryPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            return new ListJarsQueryPlan(stmt);
        }
    }

    private static class ExecutableDeleteJarStatement
    extends DeleteJarStatement
    implements CompilableStatement {
        public ExecutableDeleteJarStatement(LiteralParseNode jarPath) {
            super(jarPath);
        }

        public MutationPlan compilePlan(final PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            final StatementContext context = new StatementContext(stmt);
            return new BaseMutationPlan(context, this.getOperation()){

                @Override
                public ParameterMetaData getParameterMetaData() {
                    return PhoenixParameterMetaData.EMPTY_PARAMETER_META_DATA;
                }

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("DELETE JAR"));
                }

                @Override
                public MutationState execute() throws SQLException {
                    String dynamicJarsDir = stmt.getConnection().getQueryServices().getProps().get("hbase.dynamic.jars.dir");
                    if (dynamicJarsDir == null) {
                        throw new SQLException("hbase.dynamic.jars.dir is not configured.");
                    }
                    dynamicJarsDir = dynamicJarsDir.endsWith("/") ? dynamicJarsDir : dynamicJarsDir + '/';
                    Configuration conf = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
                    Path dynamicJarsDirPath = new Path(dynamicJarsDir);
                    try {
                        FileSystem fs = dynamicJarsDirPath.getFileSystem(conf);
                        String jarPathStr = (String)ExecutableDeleteJarStatement.this.getJarPath().getValue();
                        if (!jarPathStr.endsWith(".jar")) {
                            throw new SQLException(jarPathStr + " is not a valid jar file path.");
                        }
                        Path p = new Path(jarPathStr);
                        if (fs.exists(p)) {
                            fs.delete(p, false);
                        }
                    }
                    catch (IOException e) {
                        throw new SQLException(e);
                    }
                    return new MutationState(0L, 0L, context.getConnection());
                }
            };
        }
    }

    private static class ExecutableFetchStatement
    extends FetchStatement
    implements CompilableStatement {
        public ExecutableFetchStatement(CursorName cursor, boolean isNext, int fetchLimit) {
            super(cursor, isNext, fetchLimit);
        }

        public QueryPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            return CursorUtil.getFetchPlan(this.getCursorName().getName(), this.isNext(), this.getFetchSize());
        }
    }

    private static class ExecutableCloseStatement
    extends CloseStatement
    implements CompilableStatement {
        public ExecutableCloseStatement(CursorName cursor) {
            super(cursor);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            CloseStatementCompiler compiler = new CloseStatementCompiler(stmt, this.getOperation());
            return compiler.compile(this);
        }
    }

    private static class ExecutableOpenStatement
    extends OpenStatement
    implements CompilableStatement {
        public ExecutableOpenStatement(CursorName cursor) {
            super(cursor);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            OpenStatementCompiler compiler = new OpenStatementCompiler(stmt, this.getOperation());
            return compiler.compile(this);
        }
    }

    private static class ExecutableDeclareCursorStatement
    extends DeclareCursorStatement
    implements CompilableStatement {
        public ExecutableDeclareCursorStatement(CursorName cursor, SelectStatement select) {
            super(cursor, select);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            ExecutableSelectStatement wrappedSelect = new ExecutableSelectStatement((ExecutableSelectStatement)stmt.parseStatement(this.getQuerySQL()));
            DeclareCursorCompiler compiler = new DeclareCursorCompiler(stmt, this.getOperation(), wrappedSelect.compilePlan(stmt, seqAction));
            return compiler.compile(this);
        }
    }

    private static class ExecutableAddJarsStatement
    extends AddJarsStatement
    implements CompilableStatement {
        public ExecutableAddJarsStatement(List<LiteralParseNode> jarPaths) {
            super(jarPaths);
        }

        public MutationPlan compilePlan(final PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            final StatementContext context = new StatementContext(stmt);
            return new BaseMutationPlan(context, this.getOperation()){

                @Override
                public ParameterMetaData getParameterMetaData() {
                    return PhoenixParameterMetaData.EMPTY_PARAMETER_META_DATA;
                }

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("ADD JARS"));
                }

                @Override
                public MutationState execute() throws SQLException {
                    String dynamicJarsDir = stmt.getConnection().getQueryServices().getProps().get("hbase.dynamic.jars.dir");
                    if (dynamicJarsDir == null) {
                        throw new SQLException("hbase.dynamic.jars.dir is not configured for placing the jars.");
                    }
                    dynamicJarsDir = dynamicJarsDir.endsWith("/") ? dynamicJarsDir : dynamicJarsDir + '/';
                    Configuration conf = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
                    Path dynamicJarsDirPath = new Path(dynamicJarsDir);
                    for (LiteralParseNode jarPath : ExecutableAddJarsStatement.this.getJarPaths()) {
                        String jarPathStr = (String)jarPath.getValue();
                        if (jarPathStr.endsWith(".jar")) continue;
                        throw new SQLException(jarPathStr + " is not a valid jar file path.");
                    }
                    try {
                        FileSystem fs = dynamicJarsDirPath.getFileSystem(conf);
                        List<LiteralParseNode> jarPaths = ExecutableAddJarsStatement.this.getJarPaths();
                        for (LiteralParseNode jarPath : jarPaths) {
                            File f = new File((String)jarPath.getValue());
                            fs.copyFromLocalFile(new Path(f.getAbsolutePath()), new Path(dynamicJarsDir + f.getName()));
                        }
                    }
                    catch (IOException e) {
                        throw new SQLException(e);
                    }
                    return new MutationState(0L, 0L, context.getConnection());
                }
            };
        }
    }

    private static class ExecutableDropFunctionStatement
    extends DropFunctionStatement
    implements CompilableStatement {
        public ExecutableDropFunctionStatement(String functionName, boolean ifNotExists) {
            super(functionName, ifNotExists);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            StatementContext context = new StatementContext(stmt);
            return new BaseMutationPlan(context, this.getOperation()){

                @Override
                public ParameterMetaData getParameterMetaData() {
                    return PhoenixParameterMetaData.EMPTY_PARAMETER_META_DATA;
                }

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("DROP FUNCTION"));
                }

                @Override
                public MutationState execute() throws SQLException {
                    MetaDataClient client = new MetaDataClient(this.getContext().getConnection());
                    return client.dropFunction(ExecutableDropFunctionStatement.this);
                }
            };
        }
    }

    private static class ExecutableCreateFunctionStatement
    extends CreateFunctionStatement
    implements CompilableStatement {
        public ExecutableCreateFunctionStatement(PFunction functionInfo, boolean temporary, boolean isReplace) {
            super(functionInfo, temporary, isReplace);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            stmt.throwIfUnallowedUserDefinedFunctions(Collections.EMPTY_MAP);
            CreateFunctionCompiler compiler = new CreateFunctionCompiler(stmt);
            return compiler.compile(this);
        }
    }

    private static class ExecutableCreateSchemaStatement
    extends CreateSchemaStatement
    implements CompilableStatement {
        ExecutableCreateSchemaStatement(String schemaName, boolean ifNotExists) {
            super(schemaName, ifNotExists);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            CreateSchemaCompiler compiler = new CreateSchemaCompiler(stmt);
            return compiler.compile(this);
        }
    }

    private static class ExecutableCreateTableStatement
    extends CreateTableStatement
    implements CompilableStatement {
        ExecutableCreateTableStatement(TableName tableName, ListMultimap<String, Pair<String, Object>> props, List<ColumnDef> columnDefs, PrimaryKeyConstraint pkConstraint, List<ParseNode> splitNodes, PTableType tableType, boolean ifNotExists, TableName baseTableName, ParseNode tableTypeIdNode, int bindCount, Boolean immutableRows) {
            super(tableName, props, columnDefs, pkConstraint, splitNodes, tableType, ifNotExists, baseTableName, tableTypeIdNode, bindCount, immutableRows);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            CreateTableCompiler compiler = new CreateTableCompiler(stmt, this.getOperation());
            return compiler.compile(this);
        }
    }

    private static class ExecutableDeleteStatement
    extends DeleteStatement
    implements CompilableStatement {
        private ExecutableDeleteStatement(NamedTableNode table, HintNode hint, ParseNode whereNode, List<OrderByNode> orderBy, LimitNode limit, int bindCount, Map<String, UDFParseNode> udfParseNodes) {
            super(table, hint, whereNode, orderBy, limit, bindCount, udfParseNodes);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            if (!this.getUdfParseNodes().isEmpty()) {
                stmt.throwIfUnallowedUserDefinedFunctions(this.getUdfParseNodes());
            }
            DeleteCompiler compiler = new DeleteCompiler(stmt, this.getOperation());
            MutationPlan plan = compiler.compile(this);
            plan.getContext().getSequenceManager().validateSequences(seqAction);
            return plan;
        }
    }

    private static class ExecutableUpsertStatement
    extends UpsertStatement
    implements CompilableStatement {
        private ExecutableUpsertStatement(NamedTableNode table, HintNode hintNode, List<ColumnName> columns, List<ParseNode> values, SelectStatement select, int bindCount, Map<String, UDFParseNode> udfParseNodes, List<Pair<ColumnName, ParseNode>> onDupKeyPairs) {
            super(table, hintNode, columns, values, select, bindCount, udfParseNodes, onDupKeyPairs);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            if (!this.getUdfParseNodes().isEmpty()) {
                stmt.throwIfUnallowedUserDefinedFunctions(this.getUdfParseNodes());
            }
            UpsertCompiler compiler = new UpsertCompiler(stmt, this.getOperation());
            MutationPlan plan = compiler.compile(this);
            plan.getContext().getSequenceManager().validateSequences(seqAction);
            return plan;
        }
    }

    private static class ExecutableExplainStatement
    extends ExplainStatement
    implements CompilableStatement {
        public ExecutableExplainStatement(BindableStatement statement) {
            super(statement);
        }

        @Override
        public CompilableStatement getStatement() {
            return (CompilableStatement)super.getStatement();
        }

        @Override
        public int getBindCount() {
            return this.getStatement().getBindCount();
        }

        public QueryPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            stmt.setLastExplainQuery(true);
            CompilableStatement compilableStmt = this.getStatement();
            Object plan = compilableStmt.compilePlan(stmt, Sequence.ValueOp.VALIDATE_SEQUENCE);
            List<String> planSteps = plan.getExplainPlan().getPlanSteps();
            ArrayList tuples = Lists.newArrayListWithExpectedSize((int)planSteps.size());
            Long estimatedBytesToScan = plan.getEstimatedBytesToScan();
            Long estimatedRowsToScan = plan.getEstimatedRowsToScan();
            for (String planStep : planSteps) {
                byte[] row = PVarchar.INSTANCE.toBytes(planStep);
                ArrayList cells = Lists.newArrayListWithCapacity((int)3);
                cells.add(KeyValueUtil.newKeyValue(row, EXPLAIN_PLAN_FAMILY, EXPLAIN_PLAN_COLUMN, 0L, ByteUtil.EMPTY_BYTE_ARRAY));
                if (estimatedBytesToScan != null) {
                    cells.add(KeyValueUtil.newKeyValue(row, EXPLAIN_PLAN_FAMILY, EXPLAIN_PLAN_BYTES_ESTIMATE, 0L, PLong.INSTANCE.toBytes(estimatedBytesToScan)));
                }
                if (estimatedRowsToScan != null) {
                    cells.add(KeyValueUtil.newKeyValue(row, EXPLAIN_PLAN_FAMILY, EXPLAIN_PLAN_ROWS_ESTIMATE, 0L, PLong.INSTANCE.toBytes(estimatedRowsToScan)));
                }
                MultiKeyValueTuple tuple = new MultiKeyValueTuple(cells);
                tuples.add(tuple);
            }
            Long estimatedBytes = estimatedBytesToScan;
            Long estimatedRows = estimatedRowsToScan;
            final MaterializedResultIterator iterator = new MaterializedResultIterator(tuples);
            return new QueryPlan((StatementPlan)plan, estimatedRows, estimatedBytes){
                final /* synthetic */ StatementPlan val$plan;
                final /* synthetic */ Long val$estimatedRows;
                final /* synthetic */ Long val$estimatedBytes;
                {
                    this.val$plan = statementPlan;
                    this.val$estimatedRows = l;
                    this.val$estimatedBytes = l2;
                }

                @Override
                public ParameterMetaData getParameterMetaData() {
                    return PhoenixParameterMetaData.EMPTY_PARAMETER_META_DATA;
                }

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("EXPLAIN PLAN"));
                }

                @Override
                public ResultIterator iterator() throws SQLException {
                    return iterator;
                }

                @Override
                public ResultIterator iterator(ParallelScanGrouper scanGrouper) throws SQLException {
                    return iterator;
                }

                @Override
                public ResultIterator iterator(ParallelScanGrouper scanGrouper, Scan scan) throws SQLException {
                    return iterator;
                }

                @Override
                public long getEstimatedSize() {
                    return 0L;
                }

                @Override
                public TableRef getTableRef() {
                    return null;
                }

                @Override
                public Set<TableRef> getSourceRefs() {
                    return Collections.emptySet();
                }

                @Override
                public RowProjector getProjector() {
                    return EXPLAIN_PLAN_ROW_PROJECTOR_WITH_BYTE_ROW_ESTIMATES;
                }

                @Override
                public Integer getLimit() {
                    return null;
                }

                @Override
                public Integer getOffset() {
                    return null;
                }

                @Override
                public OrderByCompiler.OrderBy getOrderBy() {
                    return OrderByCompiler.OrderBy.EMPTY_ORDER_BY;
                }

                @Override
                public GroupByCompiler.GroupBy getGroupBy() {
                    return GroupByCompiler.GroupBy.EMPTY_GROUP_BY;
                }

                @Override
                public List<KeyRange> getSplits() {
                    return Collections.emptyList();
                }

                @Override
                public List<List<Scan>> getScans() {
                    return Collections.emptyList();
                }

                @Override
                public StatementContext getContext() {
                    return this.val$plan.getContext();
                }

                @Override
                public FilterableStatement getStatement() {
                    return null;
                }

                @Override
                public boolean isDegenerate() {
                    return false;
                }

                @Override
                public boolean isRowKeyOrdered() {
                    return true;
                }

                @Override
                public Operation getOperation() {
                    return this.getOperation();
                }

                @Override
                public boolean useRoundRobinIterator() throws SQLException {
                    return false;
                }

                @Override
                public Long getEstimatedRowsToScan() {
                    return this.val$estimatedRows;
                }

                @Override
                public Long getEstimatedBytesToScan() {
                    return this.val$estimatedBytes;
                }
            };
        }
    }

    private static class ExecutableSelectStatement
    extends SelectStatement
    implements CompilableStatement {
        private ExecutableSelectStatement(TableNode from, HintNode hint, boolean isDistinct, List<AliasedNode> select, ParseNode where, List<ParseNode> groupBy, ParseNode having, List<OrderByNode> orderBy, LimitNode limit, OffsetNode offset, int bindCount, boolean isAggregate, boolean hasSequence, Map<String, UDFParseNode> udfParseNodes) {
            this(from, hint, isDistinct, select, where, groupBy, having, orderBy, limit, offset, bindCount, isAggregate, hasSequence, Collections.emptyList(), udfParseNodes);
        }

        private ExecutableSelectStatement(TableNode from, HintNode hint, boolean isDistinct, List<AliasedNode> select, ParseNode where, List<ParseNode> groupBy, ParseNode having, List<OrderByNode> orderBy, LimitNode limit, OffsetNode offset, int bindCount, boolean isAggregate, boolean hasSequence, List<SelectStatement> selects, Map<String, UDFParseNode> udfParseNodes) {
            super(from, hint, isDistinct, select, where, groupBy, having, orderBy, limit, offset, bindCount, isAggregate, hasSequence, selects, udfParseNodes);
        }

        private ExecutableSelectStatement(ExecutableSelectStatement select) {
            this(select.getFrom(), select.getHint(), select.isDistinct(), select.getSelect(), select.getWhere(), select.getGroupBy(), select.getHaving(), select.getOrderBy(), select.getLimit(), select.getOffset(), select.getBindCount(), select.isAggregate(), select.hasSequence(), select.getSelects(), select.getUdfParseNodes());
        }

        public QueryPlan compilePlan(PhoenixStatement stmt, Sequence.ValueOp seqAction) throws SQLException {
            if (!this.getUdfParseNodes().isEmpty()) {
                stmt.throwIfUnallowedUserDefinedFunctions(this.getUdfParseNodes());
            }
            SelectStatement select = SubselectRewriter.flatten(this, stmt.getConnection());
            ColumnResolver resolver = FromCompiler.getResolverForQuery(select, stmt.getConnection());
            SelectStatement transformedSelect = SubqueryRewriter.transform(select = StatementNormalizer.normalize(select, resolver), resolver, stmt.getConnection());
            if (transformedSelect != select) {
                resolver = FromCompiler.getResolverForQuery(transformedSelect, stmt.getConnection());
                select = StatementNormalizer.normalize(transformedSelect, resolver);
            }
            QueryPlan plan = new QueryCompiler(stmt, select, resolver, Collections.emptyList(), stmt.getConnection().getIteratorFactory(), new SequenceManager(stmt), true).compile();
            plan.getContext().getSequenceManager().validateSequences(seqAction);
            return plan;
        }
    }

    protected static interface CompilableStatement
    extends BindableStatement {
        public <T extends StatementPlan> T compilePlan(PhoenixStatement var1, Sequence.ValueOp var2) throws SQLException;
    }

    public static enum Operation {
        QUERY("queried", false),
        DELETE("deleted", true),
        UPSERT("upserted", true),
        UPGRADE("upgrade", true);

        private final String toString;
        private final boolean isMutation;

        private Operation(String toString, boolean isMutation) {
            this.toString = toString;
            this.isMutation = isMutation;
        }

        public boolean isMutation() {
            return this.isMutation;
        }

        public String toString() {
            return this.toString;
        }
    }
}

