/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.join;

import com.google.common.collect.Lists;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.RowValueConstructorExpression;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.join.HashCacheFactory;
import org.apache.phoenix.join.MaxServerCacheSizeExceededException;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ServerUtil;
import org.apache.phoenix.util.TrustedByteArrayOutputStream;
import org.apache.phoenix.util.TupleUtil;
import org.iq80.snappy.Snappy;

public class HashCacheClient {
    private final ServerCacheClient serverCache;

    public HashCacheClient(PhoenixConnection connection) {
        this.serverCache = new ServerCacheClient(connection);
    }

    public ServerCacheClient.ServerCache addHashCache(ScanRanges keyRanges, ResultIterator iterator, long estimatedSize, List<Expression> onExpressions, boolean singleValueOnly, TableRef cacheUsingTableRef, Expression keyRangeRhsExpression, List<Expression> keyRangeRhsValues) throws SQLException {
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        this.serialize(ptr, iterator, estimatedSize, onExpressions, singleValueOnly, keyRangeRhsExpression, keyRangeRhsValues);
        return this.serverCache.addServerCache(keyRanges, ptr, ByteUtil.EMPTY_BYTE_ARRAY, new HashCacheFactory(), cacheUsingTableRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serialize(ImmutableBytesWritable ptr, ResultIterator iterator, long estimatedSize, List<Expression> onExpressions, boolean singleValueOnly, Expression keyRangeRhsExpression, List<Expression> keyRangeRhsValues) throws SQLException {
        long maxSize = this.serverCache.getConnection().getQueryServices().getProps().getLong("phoenix.query.maxServerCacheBytes", 0x6400000L);
        if ((estimatedSize = Math.min(estimatedSize, maxSize)) > Integer.MAX_VALUE) {
            throw new IllegalStateException("Estimated size(" + estimatedSize + ") must not be greater than Integer.MAX_VALUE(" + Integer.MAX_VALUE + ")");
        }
        try {
            TrustedByteArrayOutputStream baOut = new TrustedByteArrayOutputStream((int)estimatedSize);
            DataOutputStream out = new DataOutputStream(baOut);
            out.writeInt(onExpressions.size());
            for (Expression expression : onExpressions) {
                WritableUtils.writeVInt((DataOutput)out, (int)ExpressionType.valueOf(expression).ordinal());
                expression.write(out);
            }
            int exprSize = baOut.size() + 4;
            out.writeInt(exprSize * (singleValueOnly ? -1 : 1));
            int nRows = 0;
            out.writeInt(nRows);
            ImmutableBytesWritable tempPtr = new ImmutableBytesWritable();
            Tuple result = iterator.next();
            while (result != null) {
                TupleUtil.write(result, out);
                if ((long)baOut.size() > maxSize) {
                    throw new MaxServerCacheSizeExceededException("Size of hash cache (" + baOut.size() + " bytes) exceeds the maximum allowed size (" + maxSize + " bytes)");
                }
                if (keyRangeRhsExpression != null) {
                    keyRangeRhsValues.add(HashCacheClient.evaluateKeyExpression(keyRangeRhsExpression, result, tempPtr));
                }
                ++nRows;
                result = iterator.next();
            }
            TrustedByteArrayOutputStream sizeOut = new TrustedByteArrayOutputStream(4);
            try (DataOutputStream dataOut = new DataOutputStream(sizeOut);){
                dataOut.writeInt(nRows);
                dataOut.flush();
                byte[] cache = baOut.getBuffer();
                System.arraycopy(sizeOut.getBuffer(), 0, cache, exprSize, sizeOut.size());
                int maxCompressedSize = Snappy.maxCompressedLength((int)baOut.size());
                byte[] compressed = new byte[maxCompressedSize];
                int compressedSize = Snappy.compress((byte[])baOut.getBuffer(), (int)0, (int)baOut.size(), (byte[])compressed, (int)0);
                ptr.set(compressed, 0, compressedSize);
            }
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
        finally {
            iterator.close();
        }
    }

    public static Expression evaluateKeyExpression(Expression keyExpression, Tuple tuple, ImmutableBytesWritable ptr) throws SQLException {
        if (!(keyExpression instanceof RowValueConstructorExpression)) {
            PDataType type = keyExpression.getDataType();
            keyExpression.reset();
            if (keyExpression.evaluate(tuple, ptr)) {
                return LiteralExpression.newConstant(type.toObject(ptr, keyExpression.getSortOrder()), type);
            }
            return LiteralExpression.newConstant(null, type);
        }
        List<Expression> children = keyExpression.getChildren();
        ArrayList values = Lists.newArrayListWithExpectedSize((int)children.size());
        for (Expression child : children) {
            PDataType type = child.getDataType();
            child.reset();
            if (child.evaluate(tuple, ptr)) {
                values.add(LiteralExpression.newConstant(type.toObject(ptr, child.getSortOrder()), type));
                continue;
            }
            values.add(LiteralExpression.newConstant(null, type));
        }
        return new RowValueConstructorExpression(values, false);
    }
}

