/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.db.DBInputFormat;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.FormatToBytesWritableMapper;
import org.apache.phoenix.mapreduce.ImportPreUpsertKeyValueProcessor;
import org.apache.phoenix.mapreduce.PhoenixInputFormat;
import org.apache.phoenix.mapreduce.util.ColumnInfoToStringEncoderDecoder;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;

public final class PhoenixConfigurationUtil {
    private static final Log LOG = LogFactory.getLog(PhoenixInputFormat.class);
    public static final String SESSION_ID = "phoenix.sessionid";
    public static final String UPSERT_STATEMENT = "phoenix.upsert.stmt";
    public static final String SELECT_STATEMENT = "phoenix.select.stmt";
    public static final String UPSERT_BATCH_SIZE = "phoenix.upsert.batch.size";
    public static final String SCHEMA_TYPE = "phoenix.select.schema.type";
    public static final String MAPREDUCE_SELECT_COLUMN_VALUE_PREFIX = "phoenix.mr.select.column.value";
    public static final String MAPREDUCE_SELECT_COLUMN_COUNT = "phoenix.mr.select.column.count";
    public static final String MAPREDUCE_UPSERT_COLUMN_VALUE_PREFIX = "phoenix.mr.upsert.column.value";
    public static final String MAPREDUCE_UPSERT_COLUMN_COUNT = "phoenix.mr.upsert.column.count";
    public static final String INPUT_TABLE_NAME = "phoenix.input.table.name";
    public static final String OUTPUT_TABLE_NAME = "phoenix.colinfo.table.name";
    public static final String INPUT_TABLE_CONDITIONS = "phoenix.input.table.conditions";
    public static final String PHYSICAL_TABLE_NAME = "phoenix.output.table.name";
    public static final long DEFAULT_UPSERT_BATCH_SIZE = 1000L;
    public static final String INPUT_CLASS = "phoenix.input.class";
    public static final String CURRENT_SCN_VALUE = "phoenix.mr.currentscn.value";
    public static final String TX_SCN_VALUE = "phoenix.mr.txscn.value";
    public static final String UPSERT_HOOK_CLASS_CONFKEY = "phoenix.mapreduce.import.kvprocessor";
    public static final String MAPREDUCE_INPUT_CLUSTER_QUORUM = "phoenix.mapreduce.input.cluster.quorum";
    public static final String MAPREDUCE_OUTPUT_CLUSTER_QUORUM = "phoneix.mapreduce.output.cluster.quorum";
    public static final String INDEX_DISABLED_TIMESTAMP_VALUE = "phoenix.mr.index.disableTimestamp";
    public static final String INDEX_MAINTAINERS = "phoenix.mr.index.maintainers";
    public static final String DISABLED_INDEXES = "phoenix.mr.index.disabledIndexes";
    public static final String MAPREDUCE_SPLIT_BY_STATS = "phoenix.mapreduce.split.by.stats";
    public static final boolean DEFAULT_SPLIT_BY_STATS = true;
    public static final String SNAPSHOT_NAME_KEY = "phoenix.mapreduce.snapshot.name";
    public static final String RESTORE_DIR_KEY = "phoenix.tableSnapshot.restore.dir";

    private PhoenixConfigurationUtil() {
    }

    public static void setInputTableName(Configuration configuration, String tableName) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)tableName);
        configuration.set(INPUT_TABLE_NAME, tableName);
    }

    public static void setInputTableConditions(Configuration configuration, String conditions) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)conditions);
        configuration.set(INPUT_TABLE_CONDITIONS, conditions);
    }

    private static void setValues(Configuration configuration, String[] columns, String VALUE_COUNT, String VALUE_NAME) {
        Preconditions.checkNotNull((Object)configuration);
        configuration.setInt(VALUE_COUNT, columns.length);
        for (int i = 0; i < columns.length; ++i) {
            configuration.set(String.format("%s_%d", VALUE_NAME, i), columns[i]);
        }
    }

    private static List<String> getValues(Configuration configuration, String VALUE_COUNT, String VALUE_NAME) {
        Preconditions.checkNotNull((Object)configuration);
        int numCols = configuration.getInt(VALUE_COUNT, 0);
        ArrayList cols = Lists.newArrayListWithExpectedSize((int)numCols);
        for (int i = 0; i < numCols; ++i) {
            cols.add(configuration.get(String.format("%s_%d", VALUE_NAME, i)));
        }
        return cols;
    }

    public static void setSelectColumnNames(Configuration configuration, String[] columns) {
        PhoenixConfigurationUtil.setValues(configuration, columns, MAPREDUCE_SELECT_COLUMN_COUNT, MAPREDUCE_SELECT_COLUMN_VALUE_PREFIX);
    }

    public static List<String> getSelectColumnNames(Configuration configuration) {
        return PhoenixConfigurationUtil.getValues(configuration, MAPREDUCE_SELECT_COLUMN_COUNT, MAPREDUCE_SELECT_COLUMN_VALUE_PREFIX);
    }

    public static void setInputClass(Configuration configuration, Class<? extends DBWritable> inputClass) {
        Preconditions.checkNotNull((Object)configuration);
        configuration.setClass(INPUT_CLASS, inputClass, DBWritable.class);
    }

    public static void setInputQuery(Configuration configuration, String inputQuery) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)inputQuery);
        configuration.set(SELECT_STATEMENT, inputQuery);
    }

    public static void setSchemaType(Configuration configuration, SchemaType schemaType) {
        Preconditions.checkNotNull((Object)configuration);
        configuration.set(SCHEMA_TYPE, schemaType.name());
    }

    public static void setPhysicalTableName(Configuration configuration, String tableName) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)tableName);
        configuration.set(PHYSICAL_TABLE_NAME, tableName);
    }

    public static void setOutputTableName(Configuration configuration, String tableName) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)tableName);
        configuration.set(OUTPUT_TABLE_NAME, tableName);
    }

    public static void setUpsertColumnNames(Configuration configuration, String[] columns) {
        PhoenixConfigurationUtil.setValues(configuration, columns, MAPREDUCE_UPSERT_COLUMN_COUNT, MAPREDUCE_UPSERT_COLUMN_VALUE_PREFIX);
    }

    public static void setSnapshotNameKey(Configuration configuration, String snapshotName) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)snapshotName);
        configuration.set(SNAPSHOT_NAME_KEY, snapshotName);
    }

    public static void setRestoreDirKey(Configuration configuration, String restoreDir) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)restoreDir);
        configuration.set(RESTORE_DIR_KEY, restoreDir);
    }

    public static List<String> getUpsertColumnNames(Configuration configuration) {
        return PhoenixConfigurationUtil.getValues(configuration, MAPREDUCE_UPSERT_COLUMN_COUNT, MAPREDUCE_UPSERT_COLUMN_VALUE_PREFIX);
    }

    public static void setBatchSize(Configuration configuration, Long batchSize) {
        Preconditions.checkNotNull((Object)configuration);
        configuration.setLong(UPSERT_BATCH_SIZE, batchSize.longValue());
    }

    public static void setInputCluster(Configuration configuration, String quorum) {
        Preconditions.checkNotNull((Object)configuration);
        configuration.set(MAPREDUCE_INPUT_CLUSTER_QUORUM, quorum);
    }

    public static void setOutputCluster(Configuration configuration, String quorum) {
        Preconditions.checkNotNull((Object)configuration);
        configuration.set(MAPREDUCE_OUTPUT_CLUSTER_QUORUM, quorum);
    }

    public static Class<?> getInputClass(Configuration configuration) {
        return configuration.getClass(INPUT_CLASS, DBInputFormat.NullDBWritable.class);
    }

    public static SchemaType getSchemaType(Configuration configuration) {
        String schemaTp = configuration.get(SCHEMA_TYPE);
        Preconditions.checkNotNull((Object)schemaTp);
        return SchemaType.valueOf(schemaTp);
    }

    public static List<ColumnInfo> getUpsertColumnMetadataList(Configuration configuration) throws SQLException {
        Preconditions.checkNotNull((Object)configuration);
        List<ColumnInfo> columnMetadataList = null;
        columnMetadataList = ColumnInfoToStringEncoderDecoder.decode(configuration);
        if (columnMetadataList != null && !columnMetadataList.isEmpty()) {
            return columnMetadataList;
        }
        String tableName = PhoenixConfigurationUtil.getOutputTableName(configuration);
        Preconditions.checkNotNull((Object)tableName);
        Connection connection = ConnectionUtil.getOutputConnection(configuration);
        List<String> upsertColumnList = PhoenixConfigurationUtil.getUpsertColumnNames(configuration);
        if (!upsertColumnList.isEmpty()) {
            LOG.info((Object)String.format("UseUpsertColumns=%s, upsertColumnList.size()=%s, upsertColumnList=%s ", !upsertColumnList.isEmpty(), upsertColumnList.size(), Joiner.on((String)",").join(upsertColumnList)));
        }
        columnMetadataList = PhoenixRuntime.generateColumnInfo(connection, tableName, upsertColumnList);
        ColumnInfoToStringEncoderDecoder.encode(configuration, columnMetadataList);
        connection.close();
        return columnMetadataList;
    }

    public static String getUpsertStatement(Configuration configuration) throws SQLException {
        Preconditions.checkNotNull((Object)configuration);
        String upsertStmt = configuration.get(UPSERT_STATEMENT);
        if (StringUtils.isNotEmpty((String)upsertStmt)) {
            return upsertStmt;
        }
        String tableName = PhoenixConfigurationUtil.getOutputTableName(configuration);
        Preconditions.checkNotNull((Object)tableName);
        List<String> upsertColumnNames = PhoenixConfigurationUtil.getUpsertColumnNames(configuration);
        List<ColumnInfo> columnMetadataList = PhoenixConfigurationUtil.getUpsertColumnMetadataList(configuration);
        if (!upsertColumnNames.isEmpty()) {
            upsertStmt = QueryUtil.constructUpsertStatement(tableName, columnMetadataList);
            LOG.info((Object)("Phoenix Custom Upsert Statement: " + upsertStmt));
        } else {
            upsertStmt = QueryUtil.constructGenericUpsertStatement(tableName, columnMetadataList.size());
            LOG.info((Object)("Phoenix Generic Upsert Statement: " + upsertStmt));
        }
        configuration.set(UPSERT_STATEMENT, upsertStmt);
        return upsertStmt;
    }

    public static List<ColumnInfo> getSelectColumnMetadataList(Configuration configuration) throws SQLException {
        Preconditions.checkNotNull((Object)configuration);
        List<ColumnInfo> columnMetadataList = null;
        columnMetadataList = ColumnInfoToStringEncoderDecoder.decode(configuration);
        if (columnMetadataList != null && !columnMetadataList.isEmpty()) {
            return columnMetadataList;
        }
        String tableName = PhoenixConfigurationUtil.getInputTableName(configuration);
        Preconditions.checkNotNull((Object)tableName);
        Connection connection = ConnectionUtil.getInputConnection(configuration);
        List<String> selectColumnList = PhoenixConfigurationUtil.getSelectColumnList(configuration);
        columnMetadataList = PhoenixRuntime.generateColumnInfo(connection, tableName, selectColumnList);
        ColumnInfoToStringEncoderDecoder.encode(configuration, columnMetadataList);
        connection.close();
        return columnMetadataList;
    }

    private static List<String> getSelectColumnList(Configuration configuration) {
        List<String> selectColumnList = PhoenixConfigurationUtil.getSelectColumnNames(configuration);
        if (!selectColumnList.isEmpty()) {
            LOG.info((Object)String.format("UseSelectColumns=%s, selectColumnList.size()=%s, selectColumnList=%s ", !selectColumnList.isEmpty(), selectColumnList.size(), Joiner.on((String)",").join(selectColumnList)));
        }
        return selectColumnList;
    }

    public static String getSelectStatement(Configuration configuration) throws SQLException {
        Preconditions.checkNotNull((Object)configuration);
        String selectStmt = configuration.get(SELECT_STATEMENT);
        if (StringUtils.isNotEmpty((String)selectStmt)) {
            return selectStmt;
        }
        String tableName = PhoenixConfigurationUtil.getInputTableName(configuration);
        Preconditions.checkNotNull((Object)tableName);
        List<ColumnInfo> columnMetadataList = PhoenixConfigurationUtil.getSelectColumnMetadataList(configuration);
        String conditions = configuration.get(INPUT_TABLE_CONDITIONS);
        selectStmt = QueryUtil.constructSelectStatement(tableName, columnMetadataList, conditions);
        LOG.info((Object)("Select Statement: " + selectStmt));
        configuration.set(SELECT_STATEMENT, selectStmt);
        return selectStmt;
    }

    public static long getBatchSize(Configuration configuration) throws SQLException {
        Preconditions.checkNotNull((Object)configuration);
        long batchSize = configuration.getLong(UPSERT_BATCH_SIZE, 1000L);
        if (batchSize <= 0L) {
            Connection conn = ConnectionUtil.getOutputConnection(configuration);
            batchSize = ((PhoenixConnection)conn).getMutateBatchSize();
            conn.close();
        }
        configuration.setLong(UPSERT_BATCH_SIZE, batchSize);
        return batchSize;
    }

    public static int getSelectColumnsCount(Configuration configuration, String tableName) throws SQLException {
        List<ColumnInfo> columnInfos;
        List<String> selectedColumnList;
        Preconditions.checkNotNull((Object)configuration);
        String schemaTp = configuration.get(SCHEMA_TYPE);
        SchemaType schemaType = SchemaType.valueOf(schemaTp);
        int count = 0;
        count = SchemaType.QUERY.equals((Object)schemaType) ? ((selectedColumnList = PhoenixConfigurationUtil.getSelectColumnList(configuration)) == null ? 0 : selectedColumnList.size()) : ((columnInfos = PhoenixConfigurationUtil.getSelectColumnMetadataList(configuration)) == null ? 0 : columnInfos.size());
        return count;
    }

    public static String getInputTableName(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return configuration.get(INPUT_TABLE_NAME);
    }

    public static String getPhysicalTableName(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return configuration.get(PHYSICAL_TABLE_NAME);
    }

    public static String getOutputTableName(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return configuration.get(OUTPUT_TABLE_NAME);
    }

    public static String getInputCluster(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        String quorum = configuration.get(MAPREDUCE_INPUT_CLUSTER_QUORUM);
        if (quorum == null) {
            quorum = configuration.get("hbase.zookeeper.quorum");
        }
        return quorum;
    }

    public static String getOutputCluster(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        String quorum = configuration.get(MAPREDUCE_OUTPUT_CLUSTER_QUORUM);
        if (quorum == null) {
            quorum = configuration.get("hbase.zookeeper.quorum");
        }
        return quorum;
    }

    public static Integer getClientPort(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        String clientPortString = configuration.get("hbase.zookeeper.property.clientPort");
        return clientPortString == null ? null : Integer.valueOf(Integer.parseInt(clientPortString));
    }

    public static String getZNodeParent(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return configuration.get("zookeeper.znode.parent");
    }

    public static void loadHBaseConfiguration(Job job) throws IOException {
        Configuration hbaseConf = HBaseConfiguration.create();
        for (Map.Entry entry : hbaseConf) {
            if (job.getConfiguration().get((String)entry.getKey()) != null) continue;
            job.getConfiguration().set((String)entry.getKey(), (String)entry.getValue());
        }
        TableMapReduceUtil.initCredentials((Job)job);
    }

    public static ImportPreUpsertKeyValueProcessor loadPreUpsertProcessor(Configuration conf) {
        Class processorClass = null;
        try {
            processorClass = conf.getClass(UPSERT_HOOK_CLASS_CONFKEY, FormatToBytesWritableMapper.DefaultImportPreUpsertKeyValueProcessor.class, ImportPreUpsertKeyValueProcessor.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't load upsert hook class", e);
        }
        return (ImportPreUpsertKeyValueProcessor)ReflectionUtils.newInstance((Class)processorClass, (Configuration)conf);
    }

    public static byte[] getIndexMaintainers(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return Base64.decode((String)configuration.get(INDEX_MAINTAINERS));
    }

    public static void setIndexMaintainers(Configuration configuration, ImmutableBytesWritable indexMetaDataPtr) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)indexMetaDataPtr);
        configuration.set(INDEX_MAINTAINERS, Base64.encodeBytes((byte[])indexMetaDataPtr.get()));
    }

    public static void setDisableIndexes(Configuration configuration, String indexName) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)indexName);
        configuration.set(DISABLED_INDEXES, indexName);
    }

    public static String getDisableIndexes(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return configuration.get(DISABLED_INDEXES);
    }

    public static boolean getSplitByStats(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        boolean split = configuration.getBoolean(MAPREDUCE_SPLIT_BY_STATS, true);
        return split;
    }

    public static enum SchemaType {
        TABLE,
        QUERY;

    }
}

