/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.memory;

import com.google.common.annotations.VisibleForTesting;
import org.apache.http.annotation.GuardedBy;
import org.apache.phoenix.memory.InsufficientMemoryException;
import org.apache.phoenix.memory.MemoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalMemoryManager
implements MemoryManager {
    private static final Logger logger = LoggerFactory.getLogger(GlobalMemoryManager.class);
    private final Object sync = new Object();
    private final long maxMemoryBytes;
    private final int maxWaitMs;
    @GuardedBy(value="sync")
    private volatile long usedMemoryBytes;

    public GlobalMemoryManager(long maxBytes, int maxWaitMs) {
        if (maxBytes <= 0L) {
            throw new IllegalStateException("Total number of available bytes (" + maxBytes + ") must be greater than zero");
        }
        if (maxWaitMs < 0) {
            throw new IllegalStateException("Maximum wait time (" + maxWaitMs + ") must be greater than or equal to zero");
        }
        this.maxMemoryBytes = maxBytes;
        this.maxWaitMs = maxWaitMs;
        this.usedMemoryBytes = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAvailableMemory() {
        Object object = this.sync;
        synchronized (object) {
            return this.maxMemoryBytes - this.usedMemoryBytes;
        }
    }

    @Override
    public long getMaxMemory() {
        return this.maxMemoryBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long allocateBytes(long minBytes, long reqBytes) {
        long nBytes;
        if (minBytes < 0L || reqBytes < 0L) {
            throw new IllegalStateException("Minimum requested bytes (" + minBytes + ") and requested bytes (" + reqBytes + ") must be greater than zero");
        }
        if (minBytes > this.maxMemoryBytes) {
            throw new InsufficientMemoryException("Requested memory of " + minBytes + " bytes is larger than global pool of " + this.maxMemoryBytes + " bytes.");
        }
        long startTimeMs = System.currentTimeMillis();
        Object object = this.sync;
        synchronized (object) {
            while (this.usedMemoryBytes + minBytes > this.maxMemoryBytes) {
                this.waitForBytesToFree(minBytes, startTimeMs);
            }
            nBytes = Math.min(reqBytes, this.maxMemoryBytes - this.usedMemoryBytes);
            if (nBytes < minBytes) {
                throw new IllegalStateException("Allocated bytes (" + nBytes + ") should be at least the minimum requested bytes (" + minBytes + ")");
            }
            this.usedMemoryBytes += nBytes;
        }
        return nBytes;
    }

    @VisibleForTesting
    void waitForBytesToFree(long minBytes, long startTimeMs) {
        try {
            logger.debug("Waiting for " + (this.usedMemoryBytes + minBytes - this.maxMemoryBytes) + " bytes to be free " + startTimeMs);
            long remainingWaitTimeMs = (long)this.maxWaitMs - (System.currentTimeMillis() - startTimeMs);
            if (remainingWaitTimeMs <= 0L) {
                throw new InsufficientMemoryException("Requested memory of " + minBytes + " bytes could not be allocated. Using memory of " + this.usedMemoryBytes + " bytes from global pool of " + this.maxMemoryBytes + " bytes after waiting for " + this.maxWaitMs + "ms.");
            }
            this.sync.wait(remainingWaitTimeMs);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted allocation of " + minBytes + " bytes", ie);
        }
    }

    @Override
    public MemoryManager.MemoryChunk allocate(long minBytes, long reqBytes) {
        long nBytes = this.allocateBytes(minBytes, reqBytes);
        return this.newMemoryChunk(nBytes);
    }

    @Override
    public MemoryManager.MemoryChunk allocate(long nBytes) {
        return this.allocate(nBytes, nBytes);
    }

    private MemoryManager.MemoryChunk newMemoryChunk(long sizeBytes) {
        return new GlobalMemoryChunk(sizeBytes);
    }

    private class GlobalMemoryChunk
    implements MemoryManager.MemoryChunk {
        private volatile long size;

        private GlobalMemoryChunk(long size) {
            if (size < 0L) {
                throw new IllegalStateException("Size of memory chunk must be greater than zero, but instead is " + size);
            }
            this.size = size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getSize() {
            Object object = GlobalMemoryManager.this.sync;
            synchronized (object) {
                return this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resize(long nBytes) {
            if (nBytes < 0L) {
                throw new IllegalStateException("Number of bytes to resize to must be greater than zero, but instead is " + nBytes);
            }
            Object object = GlobalMemoryManager.this.sync;
            synchronized (object) {
                long nAdditionalBytes = nBytes - this.size;
                if (nAdditionalBytes < 0L) {
                    GlobalMemoryManager.this.usedMemoryBytes += nAdditionalBytes;
                    this.size = nBytes;
                    GlobalMemoryManager.this.sync.notifyAll();
                } else {
                    GlobalMemoryManager.this.allocateBytes(nAdditionalBytes, nAdditionalBytes);
                    this.size = nBytes;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                if (this.size > 0L) {
                    logger.warn("Orphaned chunk of " + this.size + " bytes found during finalize");
                }
                this.freeMemory();
            }
            finally {
                super.finalize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void freeMemory() {
            Object object = GlobalMemoryManager.this.sync;
            synchronized (object) {
                GlobalMemoryManager.this.usedMemoryBytes -= this.size;
                this.size = 0L;
                GlobalMemoryManager.this.sync.notifyAll();
            }
        }

        @Override
        public void close() {
            this.freeMemory();
        }
    }
}

