/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.phoenix.monitoring.GlobalMetric;
import org.apache.phoenix.monitoring.GlobalMetricImpl;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.query.QueryServicesOptions;

public enum GlobalClientMetrics {
    GLOBAL_MUTATION_BATCH_SIZE(MetricType.MUTATION_BATCH_SIZE),
    GLOBAL_MUTATION_BYTES(MetricType.MUTATION_BYTES),
    GLOBAL_MUTATION_COMMIT_TIME(MetricType.MUTATION_COMMIT_TIME),
    GLOBAL_QUERY_TIME(MetricType.QUERY_TIME),
    GLOBAL_NUM_PARALLEL_SCANS(MetricType.NUM_PARALLEL_SCANS),
    GLOBAL_SCAN_BYTES(MetricType.SCAN_BYTES),
    GLOBAL_SPOOL_FILE_SIZE(MetricType.SPOOL_FILE_SIZE),
    GLOBAL_MEMORY_CHUNK_BYTES(MetricType.MEMORY_CHUNK_BYTES),
    GLOBAL_MEMORY_WAIT_TIME(MetricType.MEMORY_WAIT_TIME),
    GLOBAL_TASK_QUEUE_WAIT_TIME(MetricType.TASK_QUEUE_WAIT_TIME),
    GLOBAL_TASK_END_TO_END_TIME(MetricType.TASK_END_TO_END_TIME),
    GLOBAL_TASK_EXECUTION_TIME(MetricType.TASK_EXECUTION_TIME),
    GLOBAL_MUTATION_SQL_COUNTER(MetricType.MUTATION_SQL_COUNTER),
    GLOBAL_SELECT_SQL_COUNTER(MetricType.SELECT_SQL_COUNTER),
    GLOBAL_TASK_EXECUTED_COUNTER(MetricType.TASK_EXECUTED_COUNTER),
    GLOBAL_REJECTED_TASK_COUNTER(MetricType.TASK_REJECTED_COUNTER),
    GLOBAL_QUERY_TIMEOUT_COUNTER(MetricType.QUERY_TIMEOUT_COUNTER),
    GLOBAL_FAILED_QUERY_COUNTER(MetricType.QUERY_FAILED_COUNTER),
    GLOBAL_SPOOL_FILE_COUNTER(MetricType.SPOOL_FILE_COUNTER),
    GLOBAL_OPEN_PHOENIX_CONNECTIONS(MetricType.OPEN_PHOENIX_CONNECTIONS_COUNTER),
    GLOBAL_QUERY_SERVICES_COUNTER(MetricType.QUERY_SERVICES_COUNTER),
    GLOBAL_HCONNECTIONS_COUNTER(MetricType.HCONNECTIONS_COUNTER),
    GLOBAL_PHOENIX_CONNECTIONS_THROTTLED_COUNTER(MetricType.PHOENIX_CONNECTIONS_THROTTLED_COUNTER),
    GLOBAL_PHOENIX_CONNECTIONS_ATTEMPTED_COUNTER(MetricType.PHOENIX_CONNECTIONS_ATTEMPTED_COUNTER);

    private static final boolean isGlobalMetricsEnabled;
    private GlobalMetric metric;

    public void update(long value) {
        if (isGlobalMetricsEnabled) {
            this.metric.change(value);
        }
    }

    @VisibleForTesting
    public GlobalMetric getMetric() {
        return this.metric;
    }

    public String toString() {
        return this.metric.toString();
    }

    private GlobalClientMetrics(MetricType metricType) {
        this.metric = new GlobalMetricImpl(metricType);
    }

    public void increment() {
        if (isGlobalMetricsEnabled) {
            this.metric.increment();
        }
    }

    public void decrement() {
        if (isGlobalMetricsEnabled) {
            this.metric.decrement();
        }
    }

    public static Collection<GlobalMetric> getMetrics() {
        ArrayList<GlobalMetric> metrics = new ArrayList<GlobalMetric>();
        for (GlobalClientMetrics m : GlobalClientMetrics.values()) {
            metrics.add(m.metric);
        }
        return metrics;
    }

    public static boolean isMetricsEnabled() {
        return isGlobalMetricsEnabled;
    }

    static {
        isGlobalMetricsEnabled = QueryServicesOptions.withDefaults().isGlobalMetricsEnabled();
    }
}

