/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.phoenix.monitoring.CombinableMetric;
import org.apache.phoenix.monitoring.CombinableMetricImpl;
import org.apache.phoenix.monitoring.MetricType;

public class MutationMetricQueue {
    private Map<String, MutationMetric> tableMutationMetric = new HashMap<String, MutationMetric>();

    public void addMetricsForTable(String tableName, MutationMetric metric) {
        MutationMetric tableMetric = this.tableMutationMetric.get(tableName);
        if (tableMetric == null) {
            this.tableMutationMetric.put(tableName, metric);
        } else {
            tableMetric.combineMetric(metric);
        }
    }

    public void combineMetricQueues(MutationMetricQueue other) {
        Map<String, MutationMetric> tableMetricMap = other.tableMutationMetric;
        for (Map.Entry<String, MutationMetric> entry : tableMetricMap.entrySet()) {
            this.addMetricsForTable(entry.getKey(), entry.getValue());
        }
    }

    public Map<String, Map<String, Long>> aggregate() {
        HashMap<String, Map<String, Long>> publishedMetrics = new HashMap<String, Map<String, Long>>();
        for (Map.Entry<String, MutationMetric> entry : this.tableMutationMetric.entrySet()) {
            String tableName = entry.getKey();
            MutationMetric metric = entry.getValue();
            HashMap<String, Long> publishedMetricsForTable = (HashMap<String, Long>)publishedMetrics.get(tableName);
            if (publishedMetricsForTable == null) {
                publishedMetricsForTable = new HashMap<String, Long>();
                publishedMetrics.put(tableName, publishedMetricsForTable);
            }
            publishedMetricsForTable.put(metric.getNumMutations().getName(), metric.getNumMutations().getValue());
            publishedMetricsForTable.put(metric.getMutationsSizeBytes().getName(), metric.getMutationsSizeBytes().getValue());
            publishedMetricsForTable.put(metric.getCommitTimeForMutations().getName(), metric.getCommitTimeForMutations().getValue());
        }
        return publishedMetrics;
    }

    public void clearMetrics() {
        this.tableMutationMetric.clear();
    }

    public static class NoOpMutationMetricsQueue
    extends MutationMetricQueue {
        public static final NoOpMutationMetricsQueue NO_OP_MUTATION_METRICS_QUEUE = new NoOpMutationMetricsQueue();

        private NoOpMutationMetricsQueue() {
        }

        @Override
        public void addMetricsForTable(String tableName, MutationMetric metric) {
        }

        @Override
        public Map<String, Map<String, Long>> aggregate() {
            return Collections.emptyMap();
        }
    }

    public static class MutationMetric {
        private final CombinableMetric numMutations = new CombinableMetricImpl(MetricType.MUTATION_BATCH_SIZE);
        private final CombinableMetric mutationsSizeBytes = new CombinableMetricImpl(MetricType.MUTATION_BYTES);
        private final CombinableMetric totalCommitTimeForMutations = new CombinableMetricImpl(MetricType.MUTATION_COMMIT_TIME);

        public MutationMetric(long numMutations, long mutationsSizeBytes, long commitTimeForMutations) {
            this.numMutations.change(numMutations);
            this.mutationsSizeBytes.change(mutationsSizeBytes);
            this.totalCommitTimeForMutations.change(commitTimeForMutations);
        }

        public CombinableMetric getCommitTimeForMutations() {
            return this.totalCommitTimeForMutations;
        }

        public CombinableMetric getNumMutations() {
            return this.numMutations;
        }

        public CombinableMetric getMutationsSizeBytes() {
            return this.mutationsSizeBytes;
        }

        public void combineMetric(MutationMetric other) {
            this.numMutations.combine(other.numMutations);
            this.mutationsSizeBytes.combine(other.mutationsSizeBytes);
            this.totalCommitTimeForMutations.combine(other.totalCommitTimeForMutations);
        }
    }
}

