/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import org.apache.phoenix.monitoring.Metric;
import org.apache.phoenix.monitoring.MetricType;

class NonAtomicMetric
implements Metric {
    private final MetricType type;
    private long value;

    public NonAtomicMetric(MetricType type) {
        this.type = type;
    }

    @Override
    public String getName() {
        return this.type.name();
    }

    @Override
    public String getDescription() {
        return this.type.description();
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public void change(long delta) {
        this.value += delta;
    }

    @Override
    public void increment() {
        ++this.value;
    }

    @Override
    public String getCurrentMetricState() {
        return this.getName() + ": " + this.value;
    }

    @Override
    public void reset() {
        this.value = 0L;
    }

    @Override
    public void decrement() {
        --this.value;
    }
}

