/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.parse.ColumnName;
import org.apache.phoenix.parse.ParseException;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.PrimaryKeyConstraint;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.schema.ConstraintViolationException;
import org.apache.phoenix.schema.DelegateSQLException;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.util.ExpressionUtil;
import org.apache.phoenix.util.SchemaUtil;

public class ColumnDef {
    private final ColumnName columnDefName;
    private final PDataType dataType;
    private final Boolean isNull;
    private final Integer maxLength;
    private final Integer scale;
    private boolean isPK;
    private final SortOrder sortOrder;
    private final boolean isArray;
    private final Integer arrSize;
    private final String expressionStr;
    private final boolean isRowTimestamp;

    public ColumnDef(ColumnDef def, String expressionStr) {
        this.columnDefName = def.columnDefName;
        this.dataType = def.dataType;
        this.isNull = def.isNull;
        this.maxLength = def.maxLength;
        this.scale = def.scale;
        this.isPK = def.isPK;
        this.sortOrder = def.sortOrder;
        this.isArray = def.isArray;
        this.arrSize = def.arrSize;
        this.isRowTimestamp = def.isRowTimestamp;
        this.expressionStr = expressionStr;
    }

    ColumnDef(ColumnName columnDefName, String sqlTypeName, boolean isArray, Integer arrSize, Boolean isNull, Integer maxLength, Integer scale, boolean isPK, SortOrder sortOrder, String expressionStr, boolean isRowTimestamp) {
        try {
            PDataType baseType;
            PDataType dataType;
            Preconditions.checkNotNull((Object)((Object)sortOrder));
            this.columnDefName = columnDefName;
            if (isArray) {
                this.isArray = true;
                dataType = sqlTypeName == null ? null : PDataType.fromTypeId(PDataType.sqlArrayType(SchemaUtil.normalizeIdentifier(sqlTypeName)));
                baseType = sqlTypeName == null ? null : PDataType.fromSqlTypeName(SchemaUtil.normalizeIdentifier(sqlTypeName));
                this.arrSize = arrSize;
                if (baseType == PVarbinary.INSTANCE) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.VARBINARY_ARRAY_NOT_SUPPORTED).setColumnName(columnDefName.getColumnName()).build().buildException();
                }
            } else {
                dataType = sqlTypeName == null ? null : PDataType.fromSqlTypeName(SchemaUtil.normalizeIdentifier(sqlTypeName));
                baseType = dataType;
                this.isArray = dataType != null && dataType.isArrayType();
                if (this.isArray) {
                    baseType = PDataType.arrayBaseType(dataType);
                }
                this.arrSize = null;
            }
            this.isNull = isNull;
            if (baseType == PDecimal.INSTANCE) {
                if (maxLength == null) {
                    scale = null;
                } else {
                    if (maxLength < 1 || maxLength > 38) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.DECIMAL_PRECISION_OUT_OF_RANGE).setColumnName(columnDefName.getColumnName()).build().buildException();
                    }
                    scale = scale == null ? 0 : (scale > maxLength ? maxLength : scale);
                }
            } else {
                if (maxLength != null && maxLength < 1) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.NONPOSITIVE_MAX_LENGTH).setColumnName(columnDefName.getColumnName()).build().buildException();
                }
                scale = null;
                if (baseType == null) {
                    maxLength = null;
                } else if (baseType.isFixedWidth()) {
                    if (baseType.getByteSize() == null) {
                        if (maxLength == null) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.MISSING_MAX_LENGTH).setColumnName(columnDefName.getColumnName()).build().buildException();
                        }
                    } else {
                        maxLength = null;
                    }
                }
            }
            this.maxLength = maxLength;
            this.scale = scale;
            this.isPK = isPK;
            this.sortOrder = sortOrder;
            this.dataType = dataType;
            this.expressionStr = expressionStr;
            this.isRowTimestamp = isRowTimestamp;
        }
        catch (SQLException e) {
            throw new ParseException(e);
        }
    }

    ColumnDef(ColumnName columnDefName, String sqlTypeName, Boolean isNull, Integer maxLength, Integer scale, boolean isPK, SortOrder sortOrder, String expressionStr, boolean isRowTimestamp) {
        this(columnDefName, sqlTypeName, false, 0, isNull, maxLength, scale, isPK, sortOrder, expressionStr, isRowTimestamp);
    }

    public ColumnName getColumnDefName() {
        return this.columnDefName;
    }

    public PDataType getDataType() {
        return this.dataType;
    }

    public boolean isNull() {
        return !Boolean.FALSE.equals(this.isNull);
    }

    public boolean isNullSet() {
        return this.isNull != null;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Integer getScale() {
        return this.scale;
    }

    public boolean isPK() {
        return this.isPK;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public Integer getArraySize() {
        return this.arrSize;
    }

    public String getExpression() {
        return this.expressionStr;
    }

    public boolean isRowTimestamp() {
        return this.isRowTimestamp;
    }

    public void setIsPK(boolean isPK) {
        this.isPK = isPK;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.columnDefName.getColumnNode().toString());
        buf.append(' ');
        buf.append(this.dataType.getSqlTypeName());
        if (this.maxLength != null) {
            buf.append('(');
            buf.append(this.maxLength);
            if (this.scale != null) {
                buf.append(',');
                buf.append(this.scale);
            }
            buf.append(')');
        }
        if (this.isArray) {
            buf.append(' ');
            buf.append("ARRAY");
            buf.append(' ');
        }
        return buf.toString();
    }

    public boolean validateDefault(StatementContext context, PrimaryKeyConstraint pkConstraint) throws SQLException {
        String defaultStr = this.getExpression();
        if (defaultStr == null) {
            return true;
        }
        ExpressionCompiler compiler = new ExpressionCompiler(context);
        ParseNode defaultParseNode = new SQLParser(this.getExpression()).parseExpression();
        Expression defaultExpression = defaultParseNode.accept(compiler);
        if (!defaultParseNode.isStateless() || defaultExpression.getDeterminism() != Determinism.ALWAYS) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CREATE_DEFAULT).setColumnName(this.getColumnDefName().getColumnName()).build().buildException();
        }
        if (this.isRowTimestamp() || pkConstraint != null && pkConstraint.isColumnRowTimestamp(this.getColumnDefName())) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CREATE_DEFAULT_ROWTIMESTAMP).setColumnName(this.getColumnDefName().getColumnName()).build().buildException();
        }
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        LiteralExpression defaultValue = ExpressionUtil.getConstantExpression(defaultExpression, ptr);
        if (defaultValue.getValue() == null) {
            return false;
        }
        PDataType sourceType = defaultExpression.getDataType();
        PDataType targetType = this.getDataType();
        context.getTempPtr().set(ptr.get(), ptr.getOffset(), ptr.getLength());
        try {
            targetType.coerceBytes(context.getTempPtr(), defaultValue.getValue(), sourceType, defaultValue.getMaxLength(), defaultValue.getScale(), defaultValue.getSortOrder(), this.getMaxLength(), this.getScale(), this.getSortOrder());
        }
        catch (ConstraintViolationException e) {
            if (e.getCause() instanceof SQLException) {
                SQLException sqlE = (SQLException)e.getCause();
                throw new DelegateSQLException(sqlE, ". DEFAULT columnName=" + this.getColumnDefName().getColumnName());
            }
            throw e;
        }
        if (!targetType.isSizeCompatible(ptr, defaultValue.getValue(), sourceType, this.sortOrder, defaultValue.getMaxLength(), defaultValue.getScale(), this.getMaxLength(), this.getScale())) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.DATA_EXCEEDS_MAX_CAPACITY).setColumnName(this.getColumnDefName().getColumnName()).setMessage("DEFAULT " + this.getExpression()).build().buildException();
        }
        return true;
    }
}

