/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.expression.function.CountAggregateFunction;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.AggregateFunctionParseNode;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.AndParseNode;
import org.apache.phoenix.parse.DerivedTableNode;
import org.apache.phoenix.parse.FamilyWildcardParseNode;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.JoinTableNode;
import org.apache.phoenix.parse.LimitNode;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.OffsetNode;
import org.apache.phoenix.parse.OrderByNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.TableNode;
import org.apache.phoenix.parse.TableWildcardParseNode;
import org.apache.phoenix.parse.UDFParseNode;
import org.apache.phoenix.parse.WildcardParseNode;

public class SelectStatement
implements FilterableStatement {
    public static final SelectStatement SELECT_ONE = new SelectStatement(null, null, false, Collections.singletonList(new AliasedNode(null, LiteralParseNode.ONE)), null, Collections.emptyList(), null, Collections.emptyList(), null, null, 0, false, false, Collections.emptyList(), new HashMap<String, UDFParseNode>(1));
    public static final SelectStatement COUNT_ONE = new SelectStatement(null, null, false, Collections.singletonList(new AliasedNode(null, new AggregateFunctionParseNode(CountAggregateFunction.NORMALIZED_NAME, LiteralParseNode.STAR, new FunctionParseNode.BuiltInFunctionInfo(CountAggregateFunction.class, CountAggregateFunction.class.getAnnotation(FunctionParseNode.BuiltInFunction.class))))), null, Collections.emptyList(), null, Collections.emptyList(), null, null, 0, true, false, Collections.emptyList(), new HashMap<String, UDFParseNode>(1));
    private final TableNode fromTable;
    private final HintNode hint;
    private final boolean isDistinct;
    private final List<AliasedNode> select;
    private final ParseNode where;
    private final List<ParseNode> groupBy;
    private final ParseNode having;
    private final List<OrderByNode> orderBy;
    private final LimitNode limit;
    private final int bindCount;
    private final boolean isAggregate;
    private final boolean hasSequence;
    private final boolean hasWildcard;
    private final List<SelectStatement> selects = new ArrayList<SelectStatement>();
    private final Map<String, UDFParseNode> udfParseNodes;
    private final OffsetNode offset;

    public static SelectStatement create(SelectStatement select, HintNode hint) {
        if (select.getHint() == hint || hint.isEmpty()) {
            return select;
        }
        return new SelectStatement(select.getFrom(), hint, select.isDistinct(), select.getSelect(), select.getWhere(), select.getGroupBy(), select.getHaving(), select.getOrderBy(), select.getLimit(), select.getOffset(), select.getBindCount(), select.isAggregate(), select.hasSequence(), select.getSelects(), select.getUdfParseNodes());
    }

    public SelectStatement combine(ParseNode where) {
        if (where == null) {
            return this;
        }
        if (this.getWhere() != null) {
            where = new AndParseNode(Arrays.asList(this.getWhere(), where));
        }
        return new SelectStatement(this.getFrom(), this.getHint(), this.isDistinct(), this.getSelect(), where, this.getGroupBy(), this.getHaving(), this.getOrderBy(), this.getLimit(), this.getOffset(), this.getBindCount(), this.isAggregate(), this.hasSequence(), this.selects, this.udfParseNodes);
    }

    public static SelectStatement create(SelectStatement select, List<AliasedNode> selects) {
        return new SelectStatement(select.getFrom(), select.getHint(), select.isDistinct(), selects, select.getWhere(), select.getGroupBy(), select.getHaving(), select.getOrderBy(), select.getLimit(), select.getOffset(), select.getBindCount(), select.isAggregate(), select.hasSequence(), select.getSelects(), select.getUdfParseNodes());
    }

    public static SelectStatement create(SelectStatement select, List<OrderByNode> orderBy, LimitNode limit, OffsetNode offset, boolean isAggregate) {
        return new SelectStatement(select.getFrom(), select.getHint(), select.isDistinct(), select.getSelect(), select.getWhere(), select.getGroupBy(), select.getHaving(), orderBy, limit, offset, select.getBindCount(), isAggregate, select.hasSequence(), select.getSelects(), select.getUdfParseNodes());
    }

    public final String toString() {
        StringBuilder buf = new StringBuilder();
        this.toSQL(null, buf);
        return buf.toString();
    }

    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        buf.append("SELECT ");
        if (this.hint != null) {
            buf.append(this.hint);
        }
        if (this.isDistinct) {
            buf.append("DISTINCT ");
        }
        for (AliasedNode aliasedNode : this.select) {
            aliasedNode.toSQL(resolver, buf);
            buf.append(',');
        }
        buf.setLength(buf.length() - 1);
        if (this.fromTable != null) {
            buf.append(" FROM ");
            this.fromTable.toSQL(resolver, buf);
        }
        if (this.where != null) {
            buf.append(" WHERE ");
            this.where.toSQL(resolver, buf);
        }
        if (!this.groupBy.isEmpty()) {
            buf.append(" GROUP BY ");
            for (ParseNode parseNode : this.groupBy) {
                parseNode.toSQL(resolver, buf);
                buf.append(',');
            }
            buf.setLength(buf.length() - 1);
        }
        if (this.having != null) {
            buf.append(" HAVING ");
            this.having.toSQL(resolver, buf);
        }
        if (!this.orderBy.isEmpty()) {
            buf.append(" ORDER BY ");
            for (OrderByNode orderByNode : this.orderBy) {
                orderByNode.toSQL(resolver, buf);
                buf.append(',');
            }
            buf.setLength(buf.length() - 1);
        }
        if (this.limit != null) {
            buf.append(" LIMIT " + this.limit.toString());
        }
        if (this.offset != null) {
            buf.append(" OFFSET " + this.offset.toString());
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fromTable == null ? 0 : this.fromTable.hashCode());
        result = 31 * result + (this.groupBy == null ? 0 : this.groupBy.hashCode());
        result = 31 * result + (this.having == null ? 0 : this.having.hashCode());
        result = 31 * result + (this.hint == null ? 0 : this.hint.hashCode());
        result = 31 * result + (this.isDistinct ? 1231 : 1237);
        result = 31 * result + (this.limit == null ? 0 : this.limit.hashCode());
        result = 31 * result + (this.orderBy == null ? 0 : this.orderBy.hashCode());
        result = 31 * result + (this.select == null ? 0 : this.select.hashCode());
        result = 31 * result + (this.where == null ? 0 : this.where.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SelectStatement other = (SelectStatement)obj;
        if (this.fromTable == null ? other.fromTable != null : !this.fromTable.equals(other.fromTable)) {
            return false;
        }
        if (this.groupBy == null ? other.groupBy != null : !this.groupBy.equals(other.groupBy)) {
            return false;
        }
        if (this.having == null ? other.having != null : !this.having.equals(other.having)) {
            return false;
        }
        if (this.hint == null ? other.hint != null : !this.hint.equals(other.hint)) {
            return false;
        }
        if (this.isDistinct != other.isDistinct) {
            return false;
        }
        if (this.limit == null ? other.limit != null : !this.limit.equals(other.limit)) {
            return false;
        }
        if (this.orderBy == null ? other.orderBy != null : !this.orderBy.equals(other.orderBy)) {
            return false;
        }
        if (this.select == null ? other.select != null : !this.select.equals(other.select)) {
            return false;
        }
        return !(this.where == null ? other.where != null : !this.where.equals(other.where));
    }

    private static int countConstants(List<ParseNode> nodes) {
        int count = 0;
        for (int i = 0; i < nodes.size(); ++i) {
            if (!nodes.get(i).isStateless()) continue;
            ++count;
        }
        return count;
    }

    protected SelectStatement(TableNode from, HintNode hint, boolean isDistinct, List<AliasedNode> select, ParseNode where, List<ParseNode> groupBy, ParseNode having, List<OrderByNode> orderBy, LimitNode limit, OffsetNode offset, int bindCount, boolean isAggregate, boolean hasSequence, List<SelectStatement> selects, Map<String, UDFParseNode> udfParseNodes) {
        this.fromTable = from;
        this.hint = hint == null ? HintNode.EMPTY_HINT_NODE : hint;
        this.isDistinct = isDistinct;
        this.select = Collections.unmodifiableList(select);
        this.where = where;
        this.groupBy = Collections.unmodifiableList(groupBy);
        this.having = having;
        this.orderBy = Collections.unmodifiableList(orderBy);
        this.limit = limit;
        this.offset = offset;
        this.bindCount = bindCount;
        this.isAggregate = isAggregate || groupBy.size() != SelectStatement.countConstants(groupBy) || this.having != null;
        this.hasSequence = hasSequence;
        boolean hasWildcard = false;
        for (AliasedNode aliasedNode : select) {
            ParseNode node = aliasedNode.getNode();
            if (!(node instanceof WildcardParseNode) && !(node instanceof TableWildcardParseNode) && !(node instanceof FamilyWildcardParseNode)) continue;
            hasWildcard = true;
            break;
        }
        this.hasWildcard = hasWildcard;
        if (!selects.isEmpty()) {
            this.selects.addAll(selects);
        }
        this.udfParseNodes = udfParseNodes;
    }

    @Override
    public boolean isDistinct() {
        return this.isDistinct;
    }

    @Override
    public LimitNode getLimit() {
        return this.limit;
    }

    @Override
    public int getBindCount() {
        return this.bindCount;
    }

    public TableNode getFrom() {
        return this.fromTable;
    }

    @Override
    public HintNode getHint() {
        return this.hint;
    }

    public List<AliasedNode> getSelect() {
        return this.select;
    }

    @Override
    public ParseNode getWhere() {
        return this.where;
    }

    public List<ParseNode> getGroupBy() {
        return this.groupBy;
    }

    public ParseNode getHaving() {
        return this.having;
    }

    @Override
    public List<OrderByNode> getOrderBy() {
        return this.orderBy;
    }

    @Override
    public boolean isAggregate() {
        return this.isAggregate;
    }

    public boolean hasSequence() {
        return this.hasSequence;
    }

    @Override
    public PhoenixStatement.Operation getOperation() {
        return PhoenixStatement.Operation.QUERY;
    }

    public boolean isJoin() {
        return this.fromTable != null && this.fromTable instanceof JoinTableNode;
    }

    public SelectStatement getInnerSelectStatement() {
        if (this.fromTable == null || !(this.fromTable instanceof DerivedTableNode)) {
            return null;
        }
        return ((DerivedTableNode)this.fromTable).getSelect();
    }

    public boolean isUnion() {
        return !this.getSelects().isEmpty();
    }

    public List<SelectStatement> getSelects() {
        return this.selects;
    }

    public boolean hasWildcard() {
        return this.hasWildcard;
    }

    public Map<String, UDFParseNode> getUdfParseNodes() {
        return this.udfParseNodes;
    }

    @Override
    public OffsetNode getOffset() {
        return this.offset;
    }
}

