/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.math.BigDecimal;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.schema.MetaDataSplitPolicy;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.SortOrder;

public interface QueryConstants {
    public static final String NAME_SEPARATOR = ".";
    public static final String NAMESPACE_SEPARATOR = ":";
    public static final String CHILD_VIEW_INDEX_NAME_SEPARATOR = "#";
    public static final byte[] NAMESPACE_SEPARATOR_BYTES = Bytes.toBytes((String)":");
    public static final byte NAMESPACE_SEPARATOR_BYTE = NAMESPACE_SEPARATOR_BYTES[0];
    public static final String NAME_SEPARATOR_REGEX = "\\.";
    public static final byte[] NAME_SEPARATOR_BYTES = Bytes.toBytes((String)".");
    public static final byte NAME_SEPARATOR_BYTE = NAME_SEPARATOR_BYTES[0];
    public static final String NULL_SCHEMA_NAME = "";
    public static final String NULL_DISPLAY_TEXT = "<null>";
    public static final long UNSET_TIMESTAMP = -1L;
    public static final String SYSTEM_SCHEMA_NAME = "SYSTEM";
    public static final byte[] SYSTEM_SCHEMA_NAME_BYTES = Bytes.toBytes((String)"SYSTEM");
    public static final String PHOENIX_METADATA = "table";
    public static final String OFFSET_ROW_KEY = "_OFFSET_";
    public static final byte[] OFFSET_ROW_KEY_BYTES = Bytes.toBytes((String)"_OFFSET_");
    public static final ImmutableBytesPtr OFFSET_ROW_KEY_PTR = new ImmutableBytesPtr(OFFSET_ROW_KEY_BYTES);
    public static final long AGG_TIMESTAMP = Long.MAX_VALUE;
    public static final byte[] UNGROUPED_AGG_ROW_KEY = Bytes.toBytes((String)"a");
    public static final String RESERVED_COLUMN_FAMILY = "_v";
    public static final byte[] RESERVED_COLUMN_FAMILY_BYTES = Bytes.toBytes((String)"_v");
    public static final byte[] VALUE_COLUMN_FAMILY = RESERVED_COLUMN_FAMILY_BYTES;
    public static final byte[] VALUE_COLUMN_QUALIFIER = PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(1);
    public static final byte[] ARRAY_VALUE_COLUMN_FAMILY = RESERVED_COLUMN_FAMILY_BYTES;
    public static final byte[] ARRAY_VALUE_COLUMN_QUALIFIER = PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(2);
    public static final PName SINGLE_COLUMN_NAME = PNameFactory.newNormalizedName("s");
    public static final PName SINGLE_COLUMN_FAMILY_NAME = PNameFactory.newNormalizedName("s");
    public static final byte[] SINGLE_COLUMN = SINGLE_COLUMN_NAME.getBytes();
    public static final byte[] SINGLE_COLUMN_FAMILY = SINGLE_COLUMN_FAMILY_NAME.getBytes();
    public static final byte[] TRUE = new byte[]{1};
    public static final String PRIORITY = "PRIORITY";
    public static final byte SEPARATOR_BYTE = 0;
    public static final byte[] SEPARATOR_BYTE_ARRAY = new byte[]{0};
    public static final byte DESC_SEPARATOR_BYTE = SortOrder.invert((byte)0);
    public static final byte[] DESC_SEPARATOR_BYTE_ARRAY = new byte[]{DESC_SEPARATOR_BYTE};
    public static final String DEFAULT_COPROCESS_PATH = "phoenix.jar";
    public static final int MILLIS_IN_DAY = 86400000;
    public static final String EMPTY_COLUMN_NAME = "_0";
    public static final byte[] EMPTY_COLUMN_BYTES = Bytes.toBytes((String)"_0");
    public static final ImmutableBytesPtr EMPTY_COLUMN_BYTES_PTR = new ImmutableBytesPtr(EMPTY_COLUMN_BYTES);
    public static final Integer ENCODED_EMPTY_COLUMN_NAME = 0;
    public static final byte[] ENCODED_EMPTY_COLUMN_BYTES = PTable.QualifierEncodingScheme.FOUR_BYTE_QUALIFIERS.encode(ENCODED_EMPTY_COLUMN_NAME);
    public static final String EMPTY_COLUMN_VALUE = "x";
    public static final byte[] EMPTY_COLUMN_VALUE_BYTES = Bytes.toBytes((String)"x");
    public static final ImmutableBytesPtr EMPTY_COLUMN_VALUE_BYTES_PTR = new ImmutableBytesPtr(EMPTY_COLUMN_VALUE_BYTES);
    public static final String ENCODED_EMPTY_COLUMN_VALUE = "x";
    public static final byte[] ENCODED_EMPTY_COLUMN_VALUE_BYTES = Bytes.toBytes((String)"x");
    public static final ImmutableBytesPtr ENCODED_EMPTY_COLUMN_VALUE_BYTES_PTR = new ImmutableBytesPtr(ENCODED_EMPTY_COLUMN_VALUE_BYTES);
    public static final String DEFAULT_COLUMN_FAMILY = "0";
    public static final byte[] DEFAULT_COLUMN_FAMILY_BYTES = Bytes.toBytes((String)"0");
    public static final ImmutableBytesPtr DEFAULT_COLUMN_FAMILY_BYTES_PTR = new ImmutableBytesPtr(DEFAULT_COLUMN_FAMILY_BYTES);
    public static final String SINGLE_KEYVALUE_COLUMN_QUALIFIER = "1";
    public static final byte[] SINGLE_KEYVALUE_COLUMN_QUALIFIER_BYTES = Bytes.toBytes((String)"1");
    public static final ImmutableBytesPtr SINGLE_KEYVALUE_COLUMN_QUALIFIER_BYTES_PTR = new ImmutableBytesPtr(SINGLE_KEYVALUE_COLUMN_QUALIFIER_BYTES);
    public static final String LOCAL_INDEX_COLUMN_FAMILY_PREFIX = "L#";
    public static final byte[] LOCAL_INDEX_COLUMN_FAMILY_PREFIX_BYTES = Bytes.toBytes((String)"L#");
    public static final ImmutableBytesPtr LOCAL_INDEX_COLUMN_FAMILY_PREFIX_PTR = new ImmutableBytesPtr(LOCAL_INDEX_COLUMN_FAMILY_PREFIX_BYTES);
    public static final String DEFAULT_LOCAL_INDEX_COLUMN_FAMILY = "L#0";
    public static final byte[] DEFAULT_LOCAL_INDEX_COLUMN_FAMILY_BYTES = Bytes.toBytes((String)"L#0");
    public static final ImmutableBytesPtr DEFAULT_LOCAL_INDEX_COLUMN_FAMILY_BYTES_PTR = new ImmutableBytesPtr(DEFAULT_LOCAL_INDEX_COLUMN_FAMILY_BYTES);
    public static final String ALL_FAMILY_PROPERTIES_KEY = "";
    public static final String SYSTEM_TABLE_PK_NAME = "pk";
    public static final double MILLIS_TO_NANOS_CONVERTOR = Math.pow(10.0, 6.0);
    public static final BigDecimal BD_MILLIS_NANOS_CONVERSION = BigDecimal.valueOf(MILLIS_TO_NANOS_CONVERTOR);
    public static final BigDecimal BD_MILLIS_IN_DAY = BigDecimal.valueOf(86400000L);
    public static final int MAX_ALLOWED_NANOS = 999999999;
    public static final int NANOS_IN_SECOND = BigDecimal.valueOf(Math.pow(10.0, 9.0)).intValue();
    public static final int DIVERGED_VIEW_BASE_COLUMN_COUNT = -100;
    public static final int BASE_TABLE_BASE_COLUMN_COUNT = -1;
    public static final int ENCODED_CQ_COUNTER_INITIAL_VALUE = 11;
    public static final String CREATE_TABLE_METADATA = "CREATE TABLE SYSTEM.\"CATALOG\"(\nTENANT_ID VARCHAR NULL,TABLE_SCHEM VARCHAR NULL,TABLE_NAME VARCHAR NOT NULL,COLUMN_NAME VARCHAR NULL,COLUMN_FAMILY VARCHAR NULL,TABLE_SEQ_NUM BIGINT,TABLE_TYPE CHAR(1),PK_NAME VARCHAR,COLUMN_COUNT INTEGER,SALT_BUCKETS INTEGER,DATA_TABLE_NAME VARCHAR,INDEX_STATE CHAR(1),\nIMMUTABLE_ROWS BOOLEAN,\nVIEW_STATEMENT VARCHAR,\nDEFAULT_COLUMN_FAMILY VARCHAR,\nDISABLE_WAL BOOLEAN,\nMULTI_TENANT BOOLEAN,\nVIEW_TYPE UNSIGNED_TINYINT,\nVIEW_INDEX_ID SMALLINT,\nDATA_TYPE INTEGER,COLUMN_SIZE INTEGER,DECIMAL_DIGITS INTEGER,NULLABLE INTEGER,ORDINAL_POSITION INTEGER,SORT_ORDER INTEGER,ARRAY_SIZE INTEGER,\nVIEW_CONSTANT VARBINARY,\nIS_VIEW_REFERENCED BOOLEAN,\nKEY_SEQ SMALLINT,\nLINK_TYPE UNSIGNED_TINYINT,\nTYPE_NAME VARCHAR,REMARKS VARCHAR,SELF_REFERENCING_COL_NAME VARCHAR,REF_GENERATION VARCHAR,BUFFER_LENGTH INTEGER,NUM_PREC_RADIX INTEGER,COLUMN_DEF VARCHAR,SQL_DATA_TYPE INTEGER,SQL_DATETIME_SUB INTEGER,CHAR_OCTET_LENGTH INTEGER,IS_NULLABLE VARCHAR,SCOPE_CATALOG VARCHAR,SCOPE_SCHEMA VARCHAR,SCOPE_TABLE VARCHAR,SOURCE_DATA_TYPE SMALLINT,IS_AUTOINCREMENT VARCHAR,INDEX_TYPE UNSIGNED_TINYINT,INDEX_DISABLE_TIMESTAMP BIGINT,STORE_NULLS BOOLEAN,BASE_COLUMN_COUNT INTEGER,IS_ROW_TIMESTAMP BOOLEAN, TRANSACTIONAL BOOLEAN,UPDATE_CACHE_FREQUENCY BIGINT,IS_NAMESPACE_MAPPED BOOLEAN,AUTO_PARTITION_SEQ VARCHAR,APPEND_ONLY_SCHEMA BOOLEAN,GUIDE_POSTS_WIDTH BIGINT,COLUMN_QUALIFIER VARBINARY,IMMUTABLE_STORAGE_SCHEME TINYINT, ENCODING_SCHEME TINYINT, QUALIFIER_COUNTER INTEGER, USE_STATS_FOR_PARALLELIZATION BOOLEAN, CONSTRAINT pk PRIMARY KEY (TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY))\nVERSIONS=1000,\nKEEP_DELETED_CELLS=true,\nSPLIT_POLICY='" + MetaDataSplitPolicy.class.getName() + "',\n" + "TRANSACTIONAL" + "=" + Boolean.FALSE;
    public static final String CREATE_STATS_TABLE_METADATA = "CREATE TABLE SYSTEM.\"STATS\"(\nPHYSICAL_NAME VARCHAR NOT NULL,COLUMN_FAMILY VARCHAR,GUIDE_POST_KEY VARBINARY,GUIDE_POSTS_WIDTH BIGINT,LAST_STATS_UPDATE_TIME DATE, GUIDE_POSTS_ROW_COUNT BIGINT, CONSTRAINT pk PRIMARY KEY (PHYSICAL_NAME,COLUMN_FAMILY,GUIDE_POST_KEY))\nVERSIONS=1,\nKEEP_DELETED_CELLS=false,\nSPLIT_POLICY='" + MetaDataSplitPolicy.class.getName() + "',\n" + "TRANSACTIONAL" + "=" + Boolean.FALSE;
    public static final String CREATE_SEQUENCE_METADATA = "CREATE TABLE SYSTEM.\"SEQUENCE\"(\nTENANT_ID VARCHAR NULL,SEQUENCE_SCHEMA VARCHAR NULL, \nSEQUENCE_NAME VARCHAR NOT NULL, \nSTART_WITH BIGINT, \nCURRENT_VALUE BIGINT, \nINCREMENT_BY BIGINT, \nCACHE_SIZE BIGINT, \nMIN_VALUE BIGINT, \nMAX_VALUE BIGINT, \nCYCLE_FLAG BOOLEAN, \nLIMIT_REACHED_FLAG BOOLEAN \n CONSTRAINT pk PRIMARY KEY (TENANT_ID,SEQUENCE_SCHEMA,SEQUENCE_NAME))\nVERSIONS=1000,\nKEEP_DELETED_CELLS=true,\nTRANSACTIONAL=" + Boolean.FALSE;
    public static final String CREATE_SYSTEM_SCHEMA = "CREATE SCHEMA SYSTEM";
    public static final String UPGRADE_TABLE_SNAPSHOT_PREFIX = "_UPGRADING_TABLE_";
    public static final String CREATE_FUNCTION_METADATA = "CREATE TABLE SYSTEM.\"FUNCTION\"(\nTENANT_ID VARCHAR NULL,FUNCTION_NAME VARCHAR NOT NULL, \nNUM_ARGS INTEGER, \nCLASS_NAME VARCHAR, \nJAR_PATH  VARCHAR, \nRETURN_TYPE VARCHAR, \nTYPE VARCHAR, \nARG_POSITION VARBINARY, \nIS_ARRAY BOOLEAN, \nIS_CONSTANT BOOLEAN, \nDEFAULT_VALUE VARCHAR, \nMIN_VALUE VARCHAR, \nMAX_VALUE VARCHAR, \n CONSTRAINT pk PRIMARY KEY (TENANT_ID, FUNCTION_NAME, TYPE, ARG_POSITION))\nVERSIONS=1000,\nKEEP_DELETED_CELLS=true,\nSPLIT_POLICY='" + MetaDataSplitPolicy.class.getName() + "',\n" + "TRANSACTIONAL" + "=" + Boolean.FALSE;
    public static final byte[] OFFSET_FAMILY = "f_offset".getBytes();
    public static final byte[] OFFSET_COLUMN = "c_offset".getBytes();
    public static final String LAST_SCAN = "LAST_SCAN";
    public static final byte[] UPGRADE_MUTEX = "UPGRADE_MUTEX".getBytes();

    public static enum JoinType {
        INNER,
        LEFT_OUTER;

    }
}

