/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.SizedUtil;

public abstract class ValueSchema
implements Writable {
    public static final int ESTIMATED_VARIABLE_LENGTH_SIZE = 10;
    private int[] fieldIndexByPosition;
    private List<Field> fields;
    private int estimatedLength;
    private boolean isFixedLength;
    private boolean isMaxLength;
    private int minNullable;
    protected boolean rowKeyOrderOptimizable;

    public ValueSchema() {
    }

    protected ValueSchema(int minNullable, List<Field> fields) {
        this(minNullable, fields, true);
    }

    protected ValueSchema(int minNullable, List<Field> fields, boolean rowKeyOrderOptimizable) {
        this.init(minNullable, fields, rowKeyOrderOptimizable);
    }

    public String toString() {
        return this.fields.toString();
    }

    public int getEstimatedSize() {
        int count = this.fieldIndexByPosition.length;
        return 24 + 4 * (4 + count) + 24 + count * 44 + SizedUtil.sizeOfArrayList(count);
    }

    private void init(int minNullable, List<Field> fields, boolean rowKeyOrderOptimizable) {
        this.rowKeyOrderOptimizable = rowKeyOrderOptimizable;
        this.minNullable = minNullable;
        this.fields = ImmutableList.copyOf(fields);
        int estimatedLength = 0;
        boolean isMaxLength = true;
        boolean isFixedLength = true;
        int positions = 0;
        for (Field field : fields) {
            int fieldEstLength = 0;
            PDataType type = field.getDataType();
            if (type != null) {
                Integer byteSize = type.getByteSize();
                if (type.isFixedWidth()) {
                    fieldEstLength += field.getByteSize();
                } else {
                    isFixedLength = false;
                    if (byteSize == null) {
                        isMaxLength = false;
                        fieldEstLength += 10;
                    } else {
                        fieldEstLength += WritableUtils.getVIntSize((long)byteSize.intValue());
                        fieldEstLength = byteSize;
                    }
                }
            }
            positions += field.getCount();
            estimatedLength += fieldEstLength * field.getCount();
        }
        this.fieldIndexByPosition = new int[positions];
        int j = 0;
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            Arrays.fill(this.fieldIndexByPosition, j, j + field.getCount(), i);
            j += field.getCount();
        }
        this.isFixedLength = isFixedLength;
        this.isMaxLength = isMaxLength;
        this.estimatedLength = estimatedLength;
    }

    public int getFieldCount() {
        return this.fieldIndexByPosition.length;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public boolean isFixedLength() {
        return this.isFixedLength;
    }

    public boolean isMaxLength() {
        return this.isMaxLength;
    }

    public int getEstimatedValueLength() {
        return this.estimatedLength;
    }

    public int getMinNullable() {
        return this.minNullable;
    }

    public int getEstimatedByteSize() {
        int size = 0;
        size += WritableUtils.getVIntSize((long)this.minNullable);
        size += WritableUtils.getVIntSize((long)this.fields.size());
        return size += this.fields.size() * 3;
    }

    public Field getField(int position) {
        return this.fields.get(this.fieldIndexByPosition[position]);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.minNullable;
        for (Field field : this.fields) {
            result = 31 * result + field.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueSchema other = (ValueSchema)obj;
        if (this.minNullable != other.minNullable) {
            return false;
        }
        if (this.fields.size() != other.fields.size()) {
            return false;
        }
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get(i).equals(other.fields.get(i))) continue;
            return false;
        }
        return true;
    }

    public void readFields(DataInput in) throws IOException {
        int minNullable = WritableUtils.readVInt((DataInput)in);
        int nFields = WritableUtils.readVInt((DataInput)in);
        boolean rowKeyOrderOptimizable = false;
        if (nFields < 0) {
            rowKeyOrderOptimizable = true;
            nFields *= -1;
        }
        ArrayList fields = Lists.newArrayListWithExpectedSize((int)nFields);
        for (int i = 0; i < nFields; ++i) {
            Field field = new Field();
            field.readFields(in);
            fields.add(field);
        }
        this.init(minNullable, fields, rowKeyOrderOptimizable);
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)this.minNullable);
        WritableUtils.writeVInt((DataOutput)out, (int)(this.fields.size() * (this.rowKeyOrderOptimizable ? -1 : 1)));
        for (int i = 0; i < this.fields.size(); ++i) {
            this.fields.get(i).write(out);
        }
    }

    public static abstract class ValueSchemaBuilder {
        protected List<Field> fields = new ArrayList<Field>();
        protected int nFields = Integer.MAX_VALUE;
        protected final int minNullable;

        public ValueSchemaBuilder(int minNullable) {
            this.minNullable = minNullable;
        }

        protected List<Field> buildFields() {
            ArrayList<Field> condensedFields = new ArrayList<Field>(this.fields.size());
            int i = 0;
            while (i < Math.min(this.nFields, this.fields.size())) {
                Field field = this.fields.get(i);
                int count = 1;
                while (++i < this.fields.size() && field.equals(this.fields.get(i))) {
                    ++count;
                }
                condensedFields.add(count == 1 ? field : new Field(field, count));
            }
            return condensedFields;
        }

        public abstract ValueSchema build();

        public ValueSchemaBuilder setMaxFields(int nFields) {
            this.nFields = nFields;
            return this;
        }

        protected ValueSchemaBuilder addField(PDatum datum, boolean isNullable, SortOrder sortOrder) {
            if (this.fields.size() >= this.nFields) {
                throw new IllegalArgumentException("Adding too many fields to Schema (max " + this.nFields + ")");
            }
            this.fields.add(new Field(datum, isNullable, 1, sortOrder));
            return this;
        }
    }

    public static final class Field
    implements Writable,
    PDatum {
        public static final int ESTIMATED_SIZE = 44;
        private int count;
        private PDataType type;
        private int byteSize = 0;
        private boolean isNullable;
        private SortOrder sortOrder;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.byteSize;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + this.sortOrder.hashCode();
            result = 31 * result + (this.isNullable ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Field other = (Field)obj;
            if (this.byteSize != other.byteSize) {
                return false;
            }
            if (this.sortOrder != other.sortOrder) {
                return false;
            }
            if (this.isNullable != other.isNullable) {
                return false;
            }
            return this.type == other.type;
        }

        public Field() {
        }

        private Field(PDatum datum, boolean isNullable, int count, SortOrder sortOrder) {
            Preconditions.checkNotNull((Object)((Object)sortOrder));
            this.type = datum.getDataType();
            this.sortOrder = sortOrder;
            this.count = count;
            this.isNullable = isNullable;
            if (this.type != null && this.type.isFixedWidth() && this.type.getByteSize() == null && datum.getMaxLength() != null) {
                this.byteSize = datum.getMaxLength();
            }
        }

        public String toString() {
            return (this.count == 1 ? "" : this.count + " * ") + this.type + (this.byteSize == 0 ? "" : "(" + this.byteSize + ")") + (this.isNullable ? "" : " NOT NULL") + (this.sortOrder == SortOrder.ASC ? "" : " " + (Object)((Object)this.sortOrder));
        }

        private Field(Field field, int count) {
            this.type = field.getDataType();
            this.byteSize = field.byteSize;
            this.count = count;
            this.sortOrder = SortOrder.getDefault();
        }

        @Override
        public final SortOrder getSortOrder() {
            return this.sortOrder;
        }

        @Override
        public final PDataType getDataType() {
            return this.type;
        }

        @Override
        public final boolean isNullable() {
            return this.isNullable;
        }

        public final int getByteSize() {
            return this.type.getByteSize() == null ? this.byteSize : this.type.getByteSize();
        }

        public final int getCount() {
            return this.count;
        }

        @Override
        public Integer getMaxLength() {
            return this.type.isFixedWidth() ? Integer.valueOf(this.byteSize) : null;
        }

        @Override
        public Integer getScale() {
            return null;
        }

        public void readFields(DataInput input) throws IOException {
            int typeOrdinal = WritableUtils.readVInt((DataInput)input);
            if (typeOrdinal < 0) {
                typeOrdinal *= -1;
                this.isNullable = true;
            }
            this.type = PDataType.values()[typeOrdinal - 1];
            this.count = WritableUtils.readVInt((DataInput)input);
            if (this.count < 0) {
                this.count *= -1;
                this.sortOrder = SortOrder.DESC;
            } else {
                this.sortOrder = SortOrder.ASC;
            }
            if (this.type.isFixedWidth() && this.type.getByteSize() == null) {
                this.byteSize = WritableUtils.readVInt((DataInput)input);
            }
        }

        public void write(DataOutput output) throws IOException {
            WritableUtils.writeVInt((DataOutput)output, (int)((this.type.ordinal() + 1) * (this.isNullable ? -1 : 1)));
            WritableUtils.writeVInt((DataOutput)output, (int)(this.count * (this.sortOrder == SortOrder.ASC ? 1 : -1)));
            if (this.type.isFixedWidth() && this.type.getByteSize() == null) {
                WritableUtils.writeVInt((DataOutput)output, (int)this.byteSize);
            }
        }
    }
}

