/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.stats;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.stats.GuidePostsInfo;
import org.apache.phoenix.schema.stats.GuidePostsInfoBuilder;
import org.apache.phoenix.schema.stats.StatisticsCollector;
import org.apache.phoenix.schema.stats.StatisticsScanner;
import org.apache.phoenix.schema.stats.StatisticsUtil;
import org.apache.phoenix.schema.stats.StatisticsWriter;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TimeKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultStatisticsCollector
implements StatisticsCollector {
    private static final Logger logger = LoggerFactory.getLogger(DefaultStatisticsCollector.class);
    private final Map<ImmutableBytesPtr, Pair<Long, GuidePostsInfoBuilder>> guidePostsInfoWriterMap = Maps.newHashMap();
    private final StatisticsWriter statsWriter;
    private final Pair<Long, GuidePostsInfoBuilder> cachedGuidePosts;
    private final byte[] guidePostWidthBytes;
    private final byte[] guidePostPerRegionBytes;
    private final byte[] ptableKey;
    private final RegionCoprocessorEnvironment env;
    private long guidePostDepth;
    private long maxTimeStamp = 0L;
    private static final Log LOG = LogFactory.getLog(DefaultStatisticsCollector.class);
    private ImmutableBytesWritable currentRow;

    DefaultStatisticsCollector(RegionCoprocessorEnvironment env, String tableName, long clientTimeStamp, byte[] family, byte[] gp_width_bytes, byte[] gp_per_region_bytes) throws IOException {
        this.env = env;
        this.guidePostWidthBytes = gp_width_bytes;
        this.guidePostPerRegionBytes = gp_per_region_bytes;
        boolean useCurrentTime = env.getConfiguration().getBoolean("phoenix.stats.useCurrentTime", true);
        if (!useCurrentTime) {
            clientTimeStamp = -1L;
        }
        String pName = tableName;
        if (MetaDataUtil.isViewIndex(tableName)) {
            pName = MetaDataUtil.getViewIndexUserTableName(tableName);
        }
        this.ptableKey = SchemaUtil.getTableKeyFromFullName(pName);
        this.statsWriter = StatisticsWriter.newWriter(env, tableName, clientTimeStamp);
        if (family != null) {
            ImmutableBytesPtr cfKey = new ImmutableBytesPtr(family);
            this.cachedGuidePosts = new Pair((Object)0L, (Object)new GuidePostsInfoBuilder());
            this.guidePostsInfoWriterMap.put(cfKey, this.cachedGuidePosts);
        } else {
            this.cachedGuidePosts = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initGuidepostDepth() throws IOException {
        if (this.guidePostPerRegionBytes != null || this.guidePostWidthBytes != null) {
            int guidepostPerRegion = 0;
            long guidepostWidth = 314572800L;
            if (this.guidePostPerRegionBytes != null) {
                guidepostPerRegion = PInteger.INSTANCE.getCodec().decodeInt(this.guidePostPerRegionBytes, 0, SortOrder.getDefault());
            }
            if (this.guidePostWidthBytes != null) {
                guidepostWidth = PLong.INSTANCE.getCodec().decodeInt(this.guidePostWidthBytes, 0, SortOrder.getDefault());
            }
            this.guidePostDepth = StatisticsUtil.getGuidePostDepth(guidepostPerRegion, guidepostWidth, this.env.getRegion().getTableDesc());
        } else {
            long guidepostWidth = -1L;
            HTableInterface htable = null;
            try {
                htable = this.env.getTable(SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, this.env.getConfiguration()));
                Get get = new Get(this.ptableKey);
                get.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.GUIDE_POSTS_WIDTH_BYTES);
                Result result = htable.get(get);
                if (!result.isEmpty()) {
                    Cell cell = (Cell)result.listCells().get(0);
                    guidepostWidth = PLong.INSTANCE.getCodec().decodeLong(cell.getValueArray(), cell.getValueOffset(), SortOrder.getDefault());
                }
            }
            finally {
                if (htable != null) {
                    try {
                        htable.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Failed to close " + htable.getName()), (Throwable)e);
                    }
                }
            }
            if (guidepostWidth >= 0L) {
                this.guidePostDepth = guidepostWidth;
            } else {
                Configuration config = this.env.getConfiguration();
                this.guidePostDepth = StatisticsUtil.getGuidePostDepth(config.getInt("phoenix.stats.guidepost.per.region", 0), config.getLong("phoenix.stats.guidepost.width", 314572800L), this.env.getRegion().getTableDesc());
            }
        }
    }

    @Override
    public long getMaxTimeStamp() {
        return this.maxTimeStamp;
    }

    @Override
    public void close() throws IOException {
        this.statsWriter.close();
    }

    @Override
    public void updateStatistic(Region region, Scan scan) {
        try {
            ArrayList<Mutation> mutations = new ArrayList<Mutation>();
            this.writeStatistics(region, true, mutations, TimeKeeper.SYSTEM.getCurrentTime(), scan);
            if (logger.isDebugEnabled()) {
                logger.debug("Committing new stats for the region " + region.getRegionInfo());
            }
            this.commitStats(mutations);
        }
        catch (IOException e) {
            logger.error("Unable to commit new stats", (Throwable)e);
        }
    }

    private void writeStatistics(Region region, boolean delete, List<Mutation> mutations, long currentTime, Scan scan) throws IOException {
        try {
            Set<ImmutableBytesPtr> fams = this.guidePostsInfoWriterMap.keySet();
            if (this.cachedGuidePosts == null) {
                boolean collectingForLocalIndex = scan != null && !scan.getFamilyMap().isEmpty() && MetaDataUtil.isLocalIndexFamily((byte[])scan.getFamilyMap().keySet().iterator().next());
                for (Store store : region.getStores()) {
                    ImmutableBytesPtr cfKey = new ImmutableBytesPtr(store.getFamily().getName());
                    boolean isLocalIndexStore = MetaDataUtil.isLocalIndexFamily(cfKey);
                    if (isLocalIndexStore != collectingForLocalIndex || this.guidePostsInfoWriterMap.containsKey((Object)cfKey)) continue;
                    Pair emptyGps = new Pair((Object)0L, (Object)new GuidePostsInfoBuilder());
                    this.guidePostsInfoWriterMap.put(cfKey, (Pair<Long, GuidePostsInfoBuilder>)emptyGps);
                }
            }
            for (ImmutableBytesPtr fam : fams) {
                if (delete) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Deleting the stats for the region " + region.getRegionInfo());
                    }
                    this.statsWriter.deleteStats(region, this, fam, mutations);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Adding new stats for the region " + region.getRegionInfo());
                }
                if (this.guidePostDepth <= 0L) continue;
                this.statsWriter.addStats(this, fam, mutations);
            }
        }
        catch (IOException e) {
            logger.error("Failed to update statistics table!", (Throwable)e);
            throw e;
        }
    }

    private void commitStats(List<Mutation> mutations) throws IOException {
        this.statsWriter.commitStats(mutations, this);
    }

    @Override
    public void collectStatistics(List<Cell> results) {
        if (this.guidePostDepth == 0L || results.size() == 0) {
            return;
        }
        HashMap famMap = Maps.newHashMap();
        boolean incrementRow = false;
        Cell c = results.get(0);
        ImmutableBytesWritable row = new ImmutableBytesWritable(c.getRowArray(), c.getRowOffset(), (int)c.getRowLength());
        if (this.currentRow == null || !row.equals((Object)this.currentRow)) {
            this.currentRow = row;
            incrementRow = true;
        }
        for (Cell cell : results) {
            Pair<Long, GuidePostsInfoBuilder> gps;
            KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
            this.maxTimeStamp = Math.max(this.maxTimeStamp, kv.getTimestamp());
            if (this.cachedGuidePosts == null) {
                ImmutableBytesPtr cfKey = new ImmutableBytesPtr(kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength());
                gps = this.guidePostsInfoWriterMap.get((Object)cfKey);
                if (gps == null) {
                    gps = new Pair((Object)0L, (Object)new GuidePostsInfoBuilder());
                    this.guidePostsInfoWriterMap.put(cfKey, gps);
                }
                if (famMap.get((Object)cfKey) == null) {
                    famMap.put(cfKey, true);
                    ((GuidePostsInfoBuilder)gps.getSecond()).incrementRowCount();
                }
            } else {
                gps = this.cachedGuidePosts;
                if (incrementRow) {
                    ((GuidePostsInfoBuilder)this.cachedGuidePosts.getSecond()).incrementRowCount();
                    incrementRow = false;
                }
            }
            int kvLength = kv.getLength();
            long byteCount = (Long)gps.getFirst() + (long)kvLength;
            gps.setFirst((Object)byteCount);
            if (byteCount < this.guidePostDepth || !((GuidePostsInfoBuilder)gps.getSecond()).addGuidePosts(row, byteCount, ((GuidePostsInfoBuilder)gps.getSecond()).getRowCount())) continue;
            gps.setFirst((Object)0L);
            ((GuidePostsInfoBuilder)gps.getSecond()).resetRowCount();
        }
    }

    @Override
    public InternalScanner createCompactionScanner(RegionCoprocessorEnvironment env, Store store, InternalScanner s) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Compaction scanner created for stats");
        }
        ImmutableBytesPtr cfKey = new ImmutableBytesPtr(store.getFamily().getName());
        return this.getInternalScanner(env, s, cfKey);
    }

    private InternalScanner getInternalScanner(RegionCoprocessorEnvironment env, InternalScanner internalScan, ImmutableBytesPtr family) throws IOException {
        StatisticsScanner scanner = new StatisticsScanner(this, this.statsWriter, env, internalScan, family);
        this.init();
        return scanner;
    }

    @Override
    public void init() throws IOException {
        this.initGuidepostDepth();
    }

    @Override
    public GuidePostsInfo getGuidePosts(ImmutableBytesPtr fam) {
        Pair<Long, GuidePostsInfoBuilder> pair = this.guidePostsInfoWriterMap.get((Object)fam);
        if (pair != null) {
            return ((GuidePostsInfoBuilder)pair.getSecond()).build();
        }
        return null;
    }
}

