/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.stats;

import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.util.ByteUtil;

public class GuidePostsInfo {
    public static final GuidePostsInfo EMPTY_GUIDEPOST = new GuidePostsInfo((List)new ArrayList(), new ImmutableBytesWritable(ByteUtil.EMPTY_BYTE_ARRAY), (List)new ArrayList(), 0, 0){

        @Override
        public int getEstimatedSize() {
            return 0;
        }
    };
    public static final GuidePostsInfo NO_GUIDEPOST = new GuidePostsInfo((List)new ArrayList(), new ImmutableBytesWritable(ByteUtil.EMPTY_BYTE_ARRAY), (List)new ArrayList(), 0, 0){

        @Override
        public int getEstimatedSize() {
            return 0;
        }
    };
    private final ImmutableBytesWritable guidePosts;
    private final int maxLength;
    private final int guidePostsCount;
    private final long[] rowCounts;
    private final long[] byteCounts;
    private final int estimatedSize;

    public GuidePostsInfo(List<Long> byteCounts, ImmutableBytesWritable guidePosts, List<Long> rowCounts, int maxLength, int guidePostsCount) {
        int estimatedSize;
        this.guidePosts = new ImmutableBytesWritable(guidePosts);
        this.maxLength = maxLength;
        this.guidePostsCount = guidePostsCount;
        this.rowCounts = Longs.toArray(rowCounts);
        this.byteCounts = Longs.toArray(byteCounts);
        this.estimatedSize = estimatedSize = 64 + guidePosts.getLength() + 4 + 4 + 24 + this.rowCounts.length * 8 + 24 + this.byteCounts.length * 8 + 4;
    }

    public ImmutableBytesWritable getGuidePosts() {
        return this.guidePosts;
    }

    public int getGuidePostsCount() {
        return this.guidePostsCount;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public long[] getRowCounts() {
        return this.rowCounts;
    }

    public long[] getByteCounts() {
        return this.byteCounts;
    }

    public int getEstimatedSize() {
        return this.estimatedSize;
    }
}

