/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.stats;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.schema.stats.GuidePostsInfo;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.PrefixByteEncoder;
import org.apache.phoenix.util.TrustedByteArrayOutputStream;

public class GuidePostsInfoBuilder {
    private PrefixByteEncoder encoder;
    private ImmutableBytesWritable lastRow;
    private ImmutableBytesWritable guidePosts = new ImmutableBytesWritable(ByteUtil.EMPTY_BYTE_ARRAY);
    private int guidePostsCount;
    private long rowCount = 0L;
    private int maxLength;
    private DataOutputStream output;
    private TrustedByteArrayOutputStream stream;
    private List<Long> rowCounts = new ArrayList<Long>();
    private List<Long> byteCounts = new ArrayList<Long>();

    public boolean isEmpty() {
        return this.rowCounts.size() == 0;
    }

    public List<Long> getRowCounts() {
        return this.rowCounts;
    }

    public List<Long> getByteCounts() {
        return this.byteCounts;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public GuidePostsInfoBuilder() {
        this.stream = new TrustedByteArrayOutputStream(1);
        this.output = new DataOutputStream(this.stream);
        this.encoder = new PrefixByteEncoder();
        this.lastRow = new ImmutableBytesWritable(ByteUtil.EMPTY_BYTE_ARRAY);
    }

    public boolean addGuidePosts(ImmutableBytesWritable row, long byteCount, long rowCount) {
        if (row.getLength() != 0 && this.lastRow.compareTo(row) < 0) {
            try {
                this.encoder.encode(this.output, row.get(), row.getOffset(), row.getLength());
                this.rowCounts.add(rowCount);
                this.byteCounts.add(byteCount);
                ++this.guidePostsCount;
                this.maxLength = this.encoder.getMaxLength();
                this.lastRow = row;
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    public boolean addGuidePosts(byte[] row) {
        return this.addGuidePosts(new ImmutableBytesWritable(row), 0L, 0L);
    }

    public boolean addGuidePosts(byte[] row, long byteCount) {
        return this.addGuidePosts(new ImmutableBytesWritable(row), byteCount, 0L);
    }

    public boolean addGuidePosts(byte[] row, long byteCount, long rowCount) {
        return this.addGuidePosts(new ImmutableBytesWritable(row), byteCount, rowCount);
    }

    public GuidePostsInfo build() {
        this.guidePosts.set(this.stream.getBuffer(), 0, this.stream.size());
        GuidePostsInfo guidePostsInfo = new GuidePostsInfo(this.byteCounts, this.guidePosts, this.rowCounts, this.maxLength, this.guidePostsCount);
        return guidePostsInfo;
    }

    public void incrementRowCount() {
        ++this.rowCount;
    }

    public void resetRowCount() {
        this.rowCount = 0L;
    }

    public long getRowCount() {
        return this.rowCount;
    }
}

