/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.schema.stats.StatisticsCollectionRunTracker;
import org.apache.phoenix.schema.stats.StatisticsCollector;
import org.apache.phoenix.schema.stats.StatisticsWriter;

public class StatisticsScanner
implements InternalScanner {
    private static final Log LOG = LogFactory.getLog(StatisticsScanner.class);
    private InternalScanner delegate;
    private StatisticsWriter statsWriter;
    private Region region;
    private StatisticsCollector tracker;
    private ImmutableBytesPtr family;
    private final Configuration config;
    private final RegionServerServices regionServerServices;

    public StatisticsScanner(StatisticsCollector tracker, StatisticsWriter stats, RegionCoprocessorEnvironment env, InternalScanner delegate, ImmutableBytesPtr family) {
        this.tracker = tracker;
        this.statsWriter = stats;
        this.delegate = delegate;
        this.regionServerServices = env.getRegionServerServices();
        this.region = env.getRegion();
        this.family = family;
        this.config = env.getConfiguration();
        StatisticsCollectionRunTracker.getInstance(this.config).addCompactingRegion(this.region.getRegionInfo());
    }

    public boolean next(List<Cell> result) throws IOException {
        boolean ret = this.delegate.next(result);
        this.updateStats(result);
        return ret;
    }

    public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
        boolean ret = this.delegate.next(result, scannerContext);
        this.updateStats(result);
        return ret;
    }

    private void updateStats(List<Cell> results) throws IOException {
        if (!results.isEmpty()) {
            this.tracker.collectStatistics(results);
        }
    }

    public void close() throws IOException {
        boolean async = this.getConfig().getBoolean("phoenix.stats.commit.async", true);
        StatisticsCollectionRunTracker collectionTracker = this.getStatsCollectionRunTracker(this.config);
        StatisticsScannerCallable callable = this.createCallable();
        if (this.getRegionServerServices().isStopping() || this.getRegionServerServices().isStopped()) {
            LOG.debug((Object)"Not updating table statistics because the server is stopping/stopped");
            return;
        }
        if (!async) {
            callable.call();
        } else {
            collectionTracker.runTask(callable);
        }
    }

    StatisticsCollectionRunTracker getStatsCollectionRunTracker(Configuration c) {
        return StatisticsCollectionRunTracker.getInstance(c);
    }

    Configuration getConfig() {
        return this.config;
    }

    StatisticsWriter getStatisticsWriter() {
        return this.statsWriter;
    }

    RegionServerServices getRegionServerServices() {
        return this.regionServerServices;
    }

    Region getRegion() {
        return this.region;
    }

    StatisticsScannerCallable createCallable() {
        return new StatisticsScannerCallable();
    }

    StatisticsCollector getTracker() {
        return this.tracker;
    }

    InternalScanner getDelegate() {
        return this.delegate;
    }

    class StatisticsScannerCallable
    implements Callable<Void> {
        StatisticsScannerCallable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Void call() throws IOException {
            IOException toThrow = null;
            StatisticsCollectionRunTracker collectionTracker = StatisticsScanner.this.getStatsCollectionRunTracker(StatisticsScanner.this.config);
            HRegionInfo regionInfo = StatisticsScanner.this.getRegion().getRegionInfo();
            try {
                ArrayList<Mutation> mutations = new ArrayList<Mutation>();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Deleting the stats for the region " + regionInfo.getRegionNameAsString() + " as part of major compaction"));
                }
                StatisticsScanner.this.getStatisticsWriter().deleteStats(StatisticsScanner.this.region, StatisticsScanner.this.tracker, StatisticsScanner.this.family, mutations);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding new stats for the region " + regionInfo.getRegionNameAsString() + " as part of major compaction"));
                }
                StatisticsScanner.this.getStatisticsWriter().addStats(StatisticsScanner.this.tracker, StatisticsScanner.this.family, mutations);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Committing new stats for the region " + regionInfo.getRegionNameAsString() + " as part of major compaction"));
                }
                StatisticsScanner.this.getStatisticsWriter().commitStats(mutations, StatisticsScanner.this.tracker);
                return null;
            }
            catch (IOException e) {
                if (!StatisticsScanner.this.getRegionServerServices().isStopping() && !StatisticsScanner.this.getRegionServerServices().isStopped()) {
                    LOG.error((Object)"Failed to update statistics table!", (Throwable)e);
                    toThrow = e;
                    return toThrow;
                }
                LOG.debug((Object)"Ignoring error updating statistics because region is closing/closed");
            }
            finally {
                try {
                    collectionTracker.removeCompactingRegion(regionInfo);
                    StatisticsScanner.this.getStatisticsWriter().close();
                    StatisticsScanner.this.getTracker().close();
                }
                catch (IOException e) {
                    if (toThrow == null) {
                        toThrow = e;
                    }
                    LOG.error((Object)"Error while closing the stats table", (Throwable)e);
                }
                finally {
                    try {
                        StatisticsScanner.this.getDelegate().close();
                    }
                    catch (IOException e) {
                        if (toThrow == null) {
                            toThrow = e;
                        }
                        LOG.error((Object)"Error while closing the scanner", (Throwable)e);
                    }
                    finally {
                        if (toThrow == null) return null;
                        throw toThrow;
                    }
                }
            }
        }
    }
}

