/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.tuple;

import java.io.IOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.schema.tuple.BaseTuple;

public class ValueGetterTuple
extends BaseTuple {
    private ValueGetter valueGetter;

    public ValueGetterTuple(ValueGetter valueGetter) {
        this.valueGetter = valueGetter;
    }

    public ValueGetterTuple() {
    }

    @Override
    public void getKey(ImmutableBytesWritable ptr) {
        ptr.set(this.valueGetter.getRowKey());
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    public KeyValue getValue(byte[] family, byte[] qualifier) {
        ImmutableBytesWritable value = null;
        try {
            value = this.valueGetter.getLatestValue(new ColumnReference(family, qualifier));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] rowKey = this.valueGetter.getRowKey();
        int valueOffset = 0;
        int valueLength = 0;
        byte[] valueBytes = HConstants.EMPTY_BYTE_ARRAY;
        if (value != null) {
            valueBytes = value.get();
            valueOffset = value.getOffset();
            valueLength = value.getLength();
        }
        return new KeyValue(rowKey, 0, rowKey.length, family, 0, family.length, qualifier, 0, qualifier.length, Long.MAX_VALUE, KeyValue.Type.Put, valueBytes, valueOffset, valueLength);
    }

    public String toString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    public KeyValue getValue(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getValue(byte[] family, byte[] qualifier, ImmutableBytesWritable ptr) {
        KeyValue kv = this.getValue(family, qualifier);
        if (kv == null) {
            return false;
        }
        ptr.set(kv.getBuffer(), kv.getValueOffset(), kv.getValueLength());
        return true;
    }
}

